/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.schemaspy.input.dbms.ConnectionConfig;

public class DbDriverLoaderErrorMessage {
    private final String[] driverClass;
    private final String driverPath;
    private final Set<URI> classpath;
    private final ConnectionConfig connectionConfig;

    public DbDriverLoaderErrorMessage(String[] driverClass, String driverPath, Set<URI> classpath, ConnectionConfig connectionConfig) {
        this.driverClass = driverClass;
        this.driverPath = driverPath;
        this.classpath = classpath;
        this.connectionConfig = connectionConfig;
    }

    public String createMessage() {
        StringBuilder sb = new StringBuilder().append("Failed to create any of '").append(Arrays.stream(this.driverClass).collect(Collectors.joining(", "))).append("' driver from driverPath '").append(this.driverPath).append("' with sibling jars ").append(this.connectionConfig.withLoadSiblings() ? "yes" : "no").append(".").append(System.lineSeparator()).append("Resulting in classpath:");
        if (this.classpath.isEmpty()) {
            sb.append(" empty").append(System.lineSeparator());
        } else {
            sb.append(System.lineSeparator());
            for (URI uri : this.classpath) {
                sb.append("\t").append(uri.toString()).append(System.lineSeparator());
            }
        }
        sb.append(this.missingPathsMessage());
        return sb.toString();
    }

    public String missingPathsMessage() {
        StringBuilder sb = new StringBuilder();
        List missingPaths = this.getMissingPaths(this.driverPath);
        if (!missingPaths.isEmpty()) {
            sb.append("There were missing paths in driverPath:").append(System.lineSeparator());
            for (String path : missingPaths) {
                sb.append("\t").append(path).append(System.lineSeparator());
            }
            sb.append("Use commandline option '-dp' to specify driver location.");
        }
        return sb.toString();
    }

    private List<String> getMissingPaths(String path) {
        String[] pieces;
        ArrayList<String> missingFiles = new ArrayList<String>();
        for (String piece : pieces = path.split(File.pathSeparator)) {
            if (new File(piece).exists()) continue;
            missingFiles.add(piece);
        }
        return missingFiles;
    }
}

