/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.model.Database;
import org.schemaspy.model.Routine;
import org.schemaspy.model.RoutineParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RoutineService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SqlService sqlService;
    private final Properties dbProperties;

    public RoutineService(SqlService sqlService, Properties dbProperties) {
        this.sqlService = sqlService;
        this.dbProperties = dbProperties;
    }

    public void gatherRoutines(Database database) {
        this.initRoutines(database);
        this.initRoutineParameters(database);
        database.getRoutinesMap().replaceAll((routineName, routine) -> {
            Routine newRoutine = new Routine(routine.getName(), RoutineService.trim((String)routine.getType()), RoutineService.trim((String)routine.getReturnType()), RoutineService.trim((String)routine.getDefinitionLanguage()), RoutineService.trim((String)routine.getDefinition()), routine.isDeterministic(), RoutineService.trim((String)routine.getDataAccess()), RoutineService.trim((String)routine.getSecurityType()), RoutineService.trim((String)routine.getComment()));
            routine.getParameters().forEach(arg_0 -> ((Routine)newRoutine).addParameter(arg_0));
            return newRoutine;
        });
    }

    private void initRoutines(Database db) {
        String sql = this.dbProperties.getProperty("selectRoutinesSql");
        boolean append = Boolean.parseBoolean(this.dbProperties.getProperty("multirowdata", "false"));
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String routineName = rs.getString("routine_name");
                    String routineType = rs.getString("routine_type");
                    String returnType = rs.getString("dtd_identifier");
                    String definitionLanguage = rs.getString("routine_body");
                    String definition = rs.getString("routine_definition");
                    String dataAccess = rs.getString("sql_data_access");
                    String securityType = rs.getString("security_type");
                    boolean deterministic = rs.getBoolean("is_deterministic");
                    String comment = RoutineService.getOptionalString((ResultSet)rs, (String)"routine_comment");
                    Routine routine = new Routine(routineName, routineType, returnType, definitionLanguage, definition, deterministic, dataAccess, securityType, comment);
                    if (append) {
                        db.getRoutinesMap().merge(routineName, routine, (oldRoutine, newRoutine) -> new Routine(oldRoutine.getName(), oldRoutine.getType(), oldRoutine.getReturnType(), oldRoutine.getDefinitionLanguage(), oldRoutine.getDefinition() + newRoutine.getDefinition(), oldRoutine.isDeterministic(), oldRoutine.getDataAccess(), oldRoutine.getSecurityType(), oldRoutine.getComment()));
                        continue;
                    }
                    db.getRoutinesMap().put(routineName, routine);
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to retrieve stored procedure/function details using sql '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }

    private void initRoutineParameters(Database db) {
        String sql = this.dbProperties.getProperty("selectRoutineParametersSql");
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String routineName = rs.getString("specific_name");
                    Routine routine = (Routine)db.getRoutinesMap().get(routineName);
                    if (routine == null) continue;
                    String paramName = RoutineService.trim((String)rs.getString("parameter_name"));
                    String type = RoutineService.trim((String)rs.getString("dtd_identifier"));
                    String mode = RoutineService.trim((String)rs.getString("parameter_mode"));
                    RoutineParameter param = new RoutineParameter(paramName, type, mode);
                    routine.addParameter(param);
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to retrieve stored procedure/function details using SQL '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }

    private static String getOptionalString(ResultSet rs, String columnName) {
        try {
            return rs.getString(columnName);
        }
        catch (SQLException sqlException) {
            LOGGER.debug("Failed to get value for column '{}'", (Object)sqlException.getMessage(), (Object)sqlException);
            return null;
        }
    }

    private static String trim(String string) {
        if (Objects.isNull(string)) {
            return null;
        }
        return string.trim();
    }
}

