/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.schemaspy.model.Table;
import org.schemaspy.output.dot.RuntimeDotConfig;
import org.schemaspy.output.dot.schemaspy.DotConfigHeader;
import org.schemaspy.output.dot.schemaspy.DotNode;
import org.schemaspy.output.dot.schemaspy.DotNodeConfig;
import org.schemaspy.output.dot.schemaspy.Header;
import org.schemaspy.output.dot.schemaspy.graph.Digraph;
import org.schemaspy.output.dot.schemaspy.graph.Element;
import org.schemaspy.output.dot.schemaspy.graph.Graph;

public class OrphanGraph
implements Graph {
    private final RuntimeDotConfig runtimeDotConfig;
    private final Collection<Table> tables;

    public OrphanGraph(RuntimeDotConfig runtimeDotConfig, Collection<Table> tables) {
        this.runtimeDotConfig = runtimeDotConfig;
        this.tables = tables;
    }

    public String dot() {
        return this.graph(this.orphans()).dot();
    }

    private List<Table> orphans() {
        return this.tables.stream().filter(table -> !table.isView()).filter(table -> table.isOrphan(false)).collect(Collectors.toList());
    }

    private Graph graph(List<Table> orphans) {
        return new Digraph(() -> "orphans", (Header)new DotConfigHeader(this.runtimeDotConfig, false), (Element[])orphans.stream().sorted(Table::compareTo).map(arg_0 -> this.asDotNode(arg_0)).toArray(Element[]::new));
    }

    private DotNode asDotNode(Table table) {
        return new DotNode(table, true, new DotNodeConfig(true, true), this.runtimeDotConfig);
    }
}

