<?php
// Enable CORS for any origin
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

// diet_orders.php - fetch diet orders with optional filters

$host   = 'db';
$port   = 3306;
$user   = 'openemr';
$pass   = 'openemrpass';
$db     = 'openemr';

// Connect to MySQL
$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => "Database connection failed: " . $conn->connect_error]);
    exit;
}

// Build query with JOINs to patient_data + forms
$sql = "
    SELECT d.*, 
           p.fname, p.lname, p.mname, p.DOB, p.sex,
           f.deleted
    FROM form_diet_orders d
    LEFT JOIN patient_data p ON d.pid = p.pid
    LEFT JOIN forms f ON (f.form_id = d.id AND f.formdir = 'diet_orders')
    WHERE 1=1
";

// Optional filters
if (!empty($_GET['pid'])) {
    $pid = intval($_GET['pid']);
    $sql .= " AND d.pid = $pid";
}

if (!empty($_GET['encounter'])) {
    $enc = intval($_GET['encounter']);
    $sql .= " AND d.encounter = $enc";
}

if (!empty($_GET['from']) && !empty($_GET['to'])) {
    $from = $conn->real_escape_string($_GET['from']);
    $to   = $conn->real_escape_string($_GET['to']);
    $sql .= " AND DATE(d.date) BETWEEN '$from' AND '$to'";
}

$sql .= " ORDER BY d.id DESC";

$result = $conn->query($sql);

$orders = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $pid = $row['pid'];

        // 🔸 Deleted = 1 → Order Cancellation
        if (!empty($row['deleted']) && $row['deleted'] == 1) {
            $row['event_code'] = 'O03'; // Order Cancellation
        } else {
            // 🧠 Check for previous orders
            $check_sql = "SELECT COUNT(*) AS total FROM form_diet_orders WHERE pid = $pid AND id < {$row['id']}";
            $check_result = $conn->query($check_sql);
            $has_previous = false;

            if ($check_result) {
                $check_data = $check_result->fetch_assoc();
                $has_previous = ($check_data['total'] > 0);
            }

            // 🩺 Assign event code
            $row['event_code'] = $has_previous ? 'O02' : 'O01';
        }

        $orders[] = $row;
    }
}

// Output JSON
echo json_encode($orders);
?>
