<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

$host = 'db';
$user = 'openemr';
$pass = 'openemrpass';
$db   = 'openemr';
$port = 3306;

$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => $conn->connect_error]);
    exit;
}

// Fetch transfers in ASC order to assign sequential encounters
$sql = "SELECT t.*, p.fname, p.lname, p.mname, p.DOB, p.sex 
        FROM form_transfer t 
        LEFT JOIN patient_data p ON t.pid = p.pid 
        WHERE 1=1";

if (!empty($_GET['pid'])) {
    $pid = intval($_GET['pid']);
    $sql .= " AND t.pid = $pid";
}

$sql .= " ORDER BY t.transfer_date ASC, t.id ASC"; // ascending to assign encounters

$result = $conn->query($sql);
if (!$result) {
    http_response_code(500);
    echo json_encode(["error" => $conn->error]);
    exit;
}

$transfers = [];
$encounter_counter = []; // counter per patient

while ($row = $result->fetch_assoc()) {
    $pid = intval($row['pid']);
    if (!isset($encounter_counter[$pid])) {
        $encounter_counter[$pid] = 1;
    } else {
        $encounter_counter[$pid]++;
    }

    // Assign sequential encounter
    $row['encounter'] = $encounter_counter[$pid];

    // Optional: update DB permanently
    $updateStmt = $conn->prepare("UPDATE form_transfer SET encounter = ? WHERE id = ?");
    $updateStmt->bind_param("ii", $encounter_counter[$pid], $row['id']);
    $updateStmt->execute();

    $row['event_code'] = 'A02';
    $transfers[] = $row;
}

// Reverse the array so latest transfers appear at the top
$transfers = array_reverse($transfers);

echo json_encode($transfers);
?>
