<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- Generated by hand -->
<!--
Copyright (C) 2009 Rod Roark <rod@sunsetsystems.com>

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.
 -->
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes"/>
<xsl:strip-space elements="*"/>
<xsl:template match="/">
<xsl:apply-templates select="form"/>
</xsl:template>
<xsl:template match="form">
<xsl:text disable-output-escaping="yes"><![CDATA[/* This CSS is used ONLY by the form defined in this same folder 
 * customize it as you see fit for your specific form
 */ 

/* turn off borders for fieldsets, to make them invisible */
fieldset {
border: none;
}

/* links should be undersized */
.link {
    font-size: 80%;
}

/* links should grow when clicked */
.link_submit {
    font-size: 120%;
}

]]></xsl:text>
<xsl:if test="/form/style='layout'">
<xsl:text disable-output-escaping="yes"><![CDATA[
/* give section objects blue borders, bold cell labels, */
.section {
 border: solid;
 border-width: 1px;
 border-color: #0000ff;
 margin: 0 0 0 10pt;
 padding: 5pt;
}

/* prevent the checkboxes on our sections from bunching up. */
span.sectionlabel {
page-break-after: always;
}

/* disappear the top button bar */
.top_buttons {
 display: none;
}

/* center the bottom button bar */
.button_bar {
text-align: center;
}

/* section labels should be visible, and bold in view, new, ??...*/
.sectionlabel {
 font-family: sans-serif;
 font-weight: bold;
}

/* section labels on the show page. turn them green, and bold. */
#show .sectionlabel {
 color: #080;
 font-family: sans-serif;
 font-weight: bold;
 font-size: 9pt;
 padding-right: 5px;
 height: 2em;
}


/* field labels should also be visible, and bold. */
.fieldlabel {
 font-family: sans-serif;
 font-weight: bold;
 font-size: 9pt;
 padding-right: 5px;
 height: 2em;
}

/* field labels on the show page. turn them bold. */
#show .fieldlabel {
 font-family: sans-serif;
 font-weight: bold;
 font-size: 9pt;
 padding-right: 5px;
 width: 25%;
}

/* Put some spacing around the edges of the form. */
body {
 padding: 5pt 5pt 5pt 5pt;
}

/* Use a single font style for most objects in this page. */
body, td, select {
 font-family: Arial, Helvetica, sans-serif;
}

input {
 font-family: Arial, Helvetica, sans-serif;
}

.save {
 margin-left: 2pt;
 margin-right: 2pt;
}

.dontsave {
 margin-left: 2pt;
 margin-right: 2pt;
}

.print {
 margin-left: 2pt;
 margin-right: 2pt;
}

/* HACK: keep textareas at an eight point font, so they don't get too wide for our 750px 'view' and 'new' pages. */
textarea {
 font-size: 8pt;
}
]]></xsl:text>
</xsl:if>
<xsl:if test="layout">
<xsl:text disable-output-escaping="yes"><![CDATA[
/* MORE HACK: compatibility between manual forms, and layout forms */

/* groupname sections are section labels on the show page. turn them green, and bold. */
.groupname {
 color: #080;
 font-family: sans-serif;
 font-weight: bold;
 font-size: 9pt;
 padding-right: 5px;
 height: 2em;
}

/* as for the labels on a show page, turn them bold. */
.label {
 font-family: sans-serif;
 font-weight: bold;
 font-size: 9pt;
}

]]></xsl:text>
</xsl:if>
<xsl:if test="/form/style='paper'">
<xsl:text disable-output-escaping="yes"><![CDATA[
/* The title should be visibly larger on 'paper' style forms. */
.title {
    font-size: 150%;
    font-weight: bold;
}

/* make the entire form 750 pixels wide, with a paper-like background, a black border, and clear margins. */
#form_container {
    border: 1px solid black;
    background-color: #ffffcc;
    width: 750px;
    padding: 10px;
    margin: 10px 0px 10px 0px;
}

/* do something similar, by making the entire form have a paper-like background, a black border, and margins, but do not set a size, so that the form may flow on paper. */
#print_form_container {
    border: 1px solid black;
    background-color: #ffffcc;
    padding: 10px;
    margin: 10px 0px 10px 0px;
}

.sectionlabel {
    visibility:hidden;
}

]]></xsl:text>
</xsl:if>
<!-- create default styles for all the div objects -->
<xsl:apply-templates select="div|section" mode="normal"/>
<xsl:apply-templates select="div|section" mode="print"/>
<xsl:text disable-output-escaping="yes"><![CDATA[
]]></xsl:text>
</xsl:template>
<xsl:template match="div|section" mode="print"><xsl:text disable-output-escaping="yes"><![CDATA[.print_]]></xsl:text>
<xsl:value-of select="@name"/>
<xsl:text disable-output-escaping="yes"><![CDATA[ {
    padding: 10px;
}

]]></xsl:text>
</xsl:template>
<xsl:template match="div|section" mode="normal"><xsl:text disable-output-escaping="yes"><![CDATA[.]]></xsl:text>
<xsl:value-of select="@name"/>
<xsl:text disable-output-escaping="yes"><![CDATA[ {
    padding: 10px;
}

]]></xsl:text>
</xsl:template>
</xsl:stylesheet>
