<?php
require_once("../../globals.php");
require_once("$srcdir/api.inc");

// Ensure a patient and encounter are active
$pid = $_SESSION['pid'] ?? null;
$encounter = $_SESSION['encounter'] ?? null;

if (!$pid || !$encounter) {
    die("⚠️ Please open a patient and create an encounter before using this form.");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>ATD Form</title>
<script src="/public/assets/jquery/dist/jquery.min.js"></script>
<style>
body { font-family: Arial, sans-serif; margin: 20px; background: #f8f9fa; }
h3 { color: #007BFF; }
label { display:block; margin-top:10px; font-weight:bold; }
input, select, textarea { width:100%; padding:8px; margin-top:4px; border-radius:4px; border:1px solid #ccc; }
.form-section { padding:15px; margin-top:15px; background:white; border-radius:5px; }
input[type=submit] { background:#007BFF; color:white; padding:10px 15px; border:none; border-radius:4px; cursor:pointer; margin-top:15px; }
input[type=submit]:hover { background:#0056b3; }
.hidden { display:none; }
</style>
<script>
$(function(){

    var rooms = {
        "General":["G1","G2","G3","G4","G5"],
        "Cabin":["Cabin 1","Cabin 2","Cabin 3"],
        "ICU":["ICU 1","ICU 2","ICU 3"]
    };

    function showSection(action){
        $(".form-section").addClass("hidden");
        $(".form-section input, .form-section select, .form-section textarea").prop("required", false);

        if(action === "Admission"){
            $("#admission_section").removeClass("hidden");
            $("#admission_section select, #admission_section input").prop("required", true);
        } else if(action === "Transfer"){
            $("#transfer_section").removeClass("hidden");
            $("#transfer_section select").prop("required", true);
        } else if(action === "Discharge"){
            $("#discharge_section").removeClass("hidden");
            $("#discharge_section input, #discharge_section textarea").prop("required", true);
        }
    }

    function populateRooms(wardSelect, roomSelect){
        var ward = $(wardSelect).val();
        var $room = $(roomSelect);
        $room.empty().append('<option value="">Select Room</option>');
        if(ward && rooms[ward]){
            rooms[ward].forEach(function(r){ $room.append('<option value="'+r+'">'+r+'</option>'); });
        }
    }

    $("#action_type").change(function(){ showSection($(this).val()); });
    $("#ward_type").change(function(){ populateRooms("#ward_type","#room"); });
    $("#new_ward_type").change(function(){ populateRooms("#new_ward_type","#new_room"); });

    $("#action_type").val("Admission");
    showSection("Admission");
});
</script>
</head>
<body>

<h3>Admission, Transfer, and Discharge (ATD) Form</h3>

<form method="post" action="save.php">

<label>Action Type</label>
<select name="action_type" id="action_type" required>
    <option value="">Select Action</option>
    <option value="Admission">Admission</option>
    <option value="Transfer">Transfer</option>
    <option value="Discharge">Discharge</option>
</select>

<!-- Admission -->
<div id="admission_section" class="form-section hidden">
    <h4>Admission</h4>
    <label>Doctor</label>
    <select name="doctor">
        <option value="">Select Doctor</option>
        <option value="Dr. 1">Dr. 1</option>
        <option value="Dr. 2">Dr. 2</option>
    </select>

    <label>Ward Type</label>
    <select name="ward_type" id="ward_type">
        <option value="">Select Ward</option>
        <option value="General">General</option>
        <option value="Cabin">Cabin</option>
        <option value="ICU">ICU</option>
    </select>

    <label>Room</label>
    <select name="room" id="room"><option value="">Select Room</option></select>

    <label>Admission Date</label>
    <input type="date" name="admission_date" value="<?=date('Y-m-d')?>">
</div>

<!-- Transfer -->
<div id="transfer_section" class="form-section hidden">
    <h4>Transfer</h4>
    <label>Transfer Doctor</label>
    <select name="transfer_doctor">
        <option value="">Select Doctor</option>
        <option value="Dr. 1">Dr. 1</option>
        <option value="Dr. 2">Dr. 2</option>
    </select>

    <label>New Ward</label>
    <select name="new_ward_type" id="new_ward_type">
        <option value="">Select Ward</option>
        <option value="General">General</option>
        <option value="Cabin">Cabin</option>
        <option value="ICU">ICU</option>
    </select>

    <label>New Room</label>
    <select name="new_room" id="new_room"><option value="">Select Room</option></select>
</div>

<!-- Discharge -->
<div id="discharge_section" class="form-section hidden">
    <h4>Discharger</h4>
    <label>Discharge Date</label>
    <input type="date" name="discharge_date" value="<?=date('Y-m-d')?>">

    <label>Treatment Summary</label>
    <textarea name="treatment_summary" rows="4"></textarea>
</div>

<input type="submit" value="Submit">
</form>

</body>
</html>
