<?php
require_once("../../globals.php");
require_once("$srcdir/api.inc");

$pid = $_SESSION['pid'];
$encounter = $_SESSION['encounter'];

// Fetch the most recent saved record for this encounter
$res = sqlStatement(
    "SELECT * FROM atd_form WHERE pid = ? AND encounter = ? ORDER BY id DESC LIMIT 1",
    array($pid, $encounter)
);
$form = sqlFetchArray($res);
?>

<?php if ($form) : ?>
  <h3>ADT Report</h3>
  <p><b>Doctor:</b> <?php echo text($form["doctor"]); ?></p>
  <p><b>Ward Type:</b> <?php echo text($form["ward_type"]); ?></p>
  <p><b>Room:</b> <?php echo text($form["room"]); ?></p>
  <p><b>Transfer To Doctor:</b> <?php echo text($form["transfer_doctor"]); ?></p>
  <p><b>New Ward Type:</b> <?php echo text($form["new_ward_type"]); ?></p>
  <p><b>New Room:</b> <?php echo text($form["new_room"]); ?></p>
  <p><b>Discharge Date:</b> <?php echo text($form["discharge_date"]); ?></p>
  <p><b>Discharge Summary:</b> <?php echo nl2br(text($form["discharge_summary"])); ?></p>
<?php else: ?>
  <p><i>No ADT records found for this encounter.</i></p>
<?php endif; ?>