<?php
require_once("../../globals.php");
require_once("$srcdir/api.inc");

$pid = $_SESSION['pid'] ?? null;
$encounter = $_SESSION['encounter'] ?? null;

if (!$pid || !$encounter) {
    die("⚠️ Patient or encounter not set in session!");
}

// Ensure action_type is selected
$action_type = $_POST['action_type'] ?? '';
if (!$action_type) { die("⚠️ Action type is required."); }

// Map POST to DB fields
$doctor = $_POST['doctor'] ?? '';
$ward = $_POST['ward_type'] ?? '';
$room = $_POST['room'] ?? '';
$admission_date = $_POST['admission_date'] ?? null;

$transfer_doctor = $_POST['transfer_doctor'] ?? '';
$new_ward = $_POST['new_ward_type'] ?? '';
$new_room = $_POST['new_room'] ?? '';

$discharge_date = $_POST['discharge_date'] ?? null;
$treatment_summary = $_POST['treatment_summary'] ?? '';

// Debugging: uncomment to check data before insert
// echo "<pre>"; print_r($_POST); die("Debug stop");

// Insert into DB
sqlInsert(
    "INSERT INTO atd_form
    (pid, encounter, doctor, ward, room, admission_date, transfer_doctor, new_ward, new_room, discharge_date, treatment_summary)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)",
    [$pid,$encounter,$doctor,$ward,$room,$admission_date,$transfer_doctor,$new_ward,$new_room,$discharge_date,$treatment_summary]
);

$newid = sqlInsertId();

// Register in OpenEMR forms table
sqlStatement(
    "INSERT INTO forms
    (date, encounter, form_name, form_id, pid, user, groupname, authorized, deleted, formdir)
    VALUES (NOW(), ?, ?, ?, ?, ?, ?, 1, 0, ?)",
    [$encounter,"ATD Form",$newid,$pid,$_SESSION['authUser'],$_SESSION['authProvider'] ?? "Default","atd_form"]
);

// Redirect to a simple view
header("Location: view.php?id=$newid");
exit;
?>
