<?php
require_once("../../globals.php");
require_once("$srcdir/api.inc");

$id = $_GET['id'] ?? null;
if (!$id) die("No form ID provided.");

$row = sqlQuery("SELECT * FROM atd_form WHERE id = ?", [$id]);
if (!$row) die("Form not found.");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>View ATD Form</title>
<style>
body { font-family: Arial; background:#f8f9fa; padding:20px; }
h3 { color:#007BFF; }
table { width:100%; border-collapse:collapse; margin-top:20px; }
th, td { border:1px solid #dee2e6; padding:10px; text-align:left; }
th { background:#007BFF; color:white; }
</style>
</head>
<body>
<h3>ATD Form - View</h3>
<table>
<tr><th>Field</th><th>Value</th></tr>
<tr><td>Action Type</td><td><?=htmlspecialchars($row['admission_date'] ? 'Admission' : ($row['transfer_doctor'] ? 'Transfer' : 'Discharge'))?></td></tr>
<tr><td>Doctor</td><td><?=htmlspecialchars($row['doctor'])?></td></tr>
<tr><td>Ward</td><td><?=htmlspecialchars($row['ward'])?></td></tr>
<tr><td>Room</td><td><?=htmlspecialchars($row['room'])?></td></tr>
<tr><td>Admission Date</td><td><?=htmlspecialchars($row['admission_date'])?></td></tr>
<tr><td>Transfer Doctor</td><td><?=htmlspecialchars($row['transfer_doctor'])?></td></tr>
<tr><td>New Ward</td><td><?=htmlspecialchars($row['new_ward'])?></td></tr>
<tr><td>New Room</td><td><?=htmlspecialchars($row['new_room'])?></td></tr>
<tr><td>Discharge Date</td><td><?=htmlspecialchars($row['discharge_date'])?></td></tr>
<tr><td>Treatment Summary</td><td><?=nl2br(htmlspecialchars($row['treatment_summary']))?></td></tr>
</table>
</body>
</html>
