<?php
include_once("../../globals.php");
include_once("$srcdir/api.inc");

$formid = $_GET['id'] ?? 0;

formHeader("Discharge Patient");

// -------------------------
// Case 1: No ID provided
// -------------------------
if (!$formid) {
    // Fetch all currently admitted patients
    $res = sqlStatement("SELECT * FROM form_admission WHERE status='Admitted' ORDER BY date_admission ASC");
    
    echo "<h2>Select a patient to discharge</h2>";
    echo "<form method='get' action='new.php'>";
    echo "<select name='id' required>";
    echo "<option value=''>-- Select Patient --</option>";
    while ($row = sqlFetchArray($res)) {
        $label = "Patient {$row['pid']} - Ward {$row['ward']} Bed {$row['bed']} (Admitted: {$row['date_admission']})";
        echo "<option value='{$row['id']}'>{$label}</option>";
    }
    echo "</select>";
    echo "<p><input type='submit' value='Proceed'></p>";
    echo "</form>";
    formFooter();
    exit;
}

// -------------------------
// Case 2: ID provided
// -------------------------

// Fetch admission record
$res = sqlStatement("SELECT * FROM form_admission WHERE id = ?", [$formid]);
$data = sqlFetchArray($res);
if (!$data) die("Admission record not found");

// Check if already discharged
if ($data['status'] === 'Discharged') die("Patient already discharged.");

?>
<html>
<head>
    <title>Discharge Patient</title>
    <style>
        .discharge-form {
            max-width: 500px;
            margin: 20px auto;
            padding: 20px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
            font-family: Arial, sans-serif;
        }
        .discharge-form h2 {
            text-align: center;
            color: #2c3e50;
        }
        .discharge-form p {
            margin: 10px 0;
        }
        .discharge-btn {
            display: block;
            width: 100%;
            padding: 10px;
            background: #e74c3c;
            color: #fff;
            font-weight: bold;
            border: none;
            border-radius: 6px;
            cursor: pointer;
        }
        .discharge-btn:hover {
            background: #c0392b;
        }
    </style>
</head>
<body>
<div class="discharge-form">
    <h2>Discharge Patient</h2>
    <form method="post" action="save.php?id=<?= attr_url($formid) ?>">
        <p><strong>Patient ID:</strong> <?= htmlspecialchars($data['pid']) ?></p>
        <p><strong>Ward:</strong> <?= htmlspecialchars($data['ward']) ?></p>
        <p><strong>Bed:</strong> <?= htmlspecialchars($data['bed']) ?></p>
        <p><strong>Admission Date:</strong> <?= htmlspecialchars($data['date_admission']) ?></p>
        <p>
            <input type="submit" class="discharge-btn" value="Discharge Patient">
        </p>
    </form>
</div>
</body>
</html>
<?php formFooter(); ?>
<?php
include_once("../../globals.php");
include_once("$srcdir/api.inc");

$formid = $_GET['id'] ?? 0;

formHeader("Discharge Patient");

// -------------------------
// Case 1: No ID provided
// -------------------------
if (!$formid) {
    // Fetch all currently admitted patients
    $res = sqlStatement("SELECT * FROM form_admission WHERE status='Admitted' ORDER BY date_admission ASC");
    
    echo "<h2>Select a patient to discharge</h2>";
    echo "<form method='get' action='new.php'>";
    echo "<select name='id' required>";
    echo "<option value=''>-- Select Patient --</option>";
    while ($row = sqlFetchArray($res)) {
        $label = "Patient {$row['pid']} - Ward {$row['ward']} Bed {$row['bed']} (Admitted: {$row['date_admission']})";
        echo "<option value='{$row['id']}'>{$label}</option>";
    }
    echo "</select>";
    echo "<p><input type='submit' value='Proceed'></p>";
    echo "</form>";
    formFooter();
    exit;
}

// -------------------------
// Case 2: ID provided
// -------------------------

// Fetch admission record
$res = sqlStatement("SELECT * FROM form_admission WHERE id = ?", [$formid]);
$data = sqlFetchArray($res);
if (!$data) die("Admission record not found");

// Check if already discharged
if ($data['status'] === 'Discharged') die("Patient already discharged.");

?>
<html>
<head>
    <title>Discharge Patient</title>
    <style>
        .discharge-form {
            max-width: 500px;
            margin: 20px auto;
            padding: 20px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
            font-family: Arial, sans-serif;
        }
        .discharge-form h2 {
            text-align: center;
            color: #2c3e50;
        }
        .discharge-form p {
            margin: 10px 0;
        }
        .discharge-btn {
            display: block;
            width: 100%;
            padding: 10px;
            background: #e74c3c;
            color: #fff;
            font-weight: bold;
            border: none;
            border-radius: 6px;
            cursor: pointer;
        }
        .discharge-btn:hover {
            background: #c0392b;
        }
    </style>
</head>
<body>
<div class="discharge-form">
    <h2>Discharge Patient</h2>
    <form method="post" action="save.php?id=<?= attr_url($formid) ?>">
        <p><strong>Patient ID:</strong> <?= htmlspecialchars($data['pid']) ?></p>
        <p><strong>Ward:</strong> <?= htmlspecialchars($data['ward']) ?></p>
        <p><strong>Bed:</strong> <?= htmlspecialchars($data['bed']) ?></p>
        <p><strong>Admission Date:</strong> <?= htmlspecialchars($data['date_admission']) ?></p>
        <p>
            <input type="submit" class="discharge-btn" value="Discharge Patient">
        </p>
    </form>
</div>
</body>
</html>
<?php formFooter(); ?>
