<?php
include_once("../../globals.php");
include_once("$srcdir/api.inc");

// Context: patient from encounter
$current_pid = $_SESSION["pid"] ?? null;

// Admission ID (if passed manually in URL)
$admission_id = $_GET["id"] ?? null;

// Admission record
$admission = null;

// If inside encounter → fetch admission for this patient only
if ($current_pid && !$admission_id) {
    $sql = "SELECT * FROM form_admission WHERE pid = ? AND status = 'Admitted' LIMIT 1";
    $res = sqlStatement($sql, [$current_pid]);
    $admission = sqlFetchArray($res);
    if ($admission) {
        $admission_id = $admission['id'];
    }
}

// If id provided explicitly, fetch admission
if ($admission_id && !$admission) {
    $sql = "SELECT * FROM form_admission WHERE id = ? AND status = 'Admitted'";
    $res = sqlStatement($sql, [$admission_id]);
    $admission = sqlFetchArray($res);
}

// If no encounter context → fetch list of all admitted patients (for global access)
$admittedPatients = [];
if (!$current_pid && !$admission_id) {
    $sql = "SELECT fa.id, fa.ward, fa.bed, p.fname, p.lname, p.pid
            FROM form_admission fa
            JOIN patient_data p ON p.pid = fa.pid
            WHERE fa.status = 'Admitted'";
    $res = sqlStatement($sql);
    while ($row = sqlFetchArray($res)) {
        $admittedPatients[] = $row;
    }
}

// 🔑 Fetch all occupied beds (excluding current patient’s bed)
$occupiedBeds = [];
$sql = "SELECT ward, bed FROM form_admission WHERE status = 'Admitted'";
$res = sqlStatement($sql);
while ($row = sqlFetchArray($res)) {
    if ($admission && $row['ward'] === $admission['ward'] && $row['bed'] === $admission['bed']) {
        continue;
    }
    $occupiedBeds[$row['ward']][] = $row['bed'];
}

formHeader("Form: Transfer Patient");
?>
<html>
<head>
    <title>Transfer Patient</title>
    <style>
        .transfer-form {
            max-width: 600px;
            margin: 20px auto;
            padding: 20px;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
        }
        .transfer-form h2 {
            text-align: center;
            margin-bottom: 20px;
            color: #2c3e50;
        }
        .form-group { margin-bottom: 15px; }
        label { font-weight: 600; display: block; margin-bottom: 5px; }
        select, input[type="text"] {
            width: 100%; padding: 8px; border-radius: 5px; border: 1px solid #ccc;
        }
        .btn {
            width: 100%; padding: 10px; background: #007bff;
            border: none; color: #fff; font-size: 16px; font-weight: 600;
            border-radius: 6px; cursor: pointer;
        }
        .btn:hover { background: #0056b3; }
    </style>
    <script>
    function updateBeds() {
        var ward = document.getElementById("new_ward").value;
        var bedSelect = document.getElementById("new_bed");
        bedSelect.innerHTML = "";

        let beds = [];
        if (ward === "General") beds = ["G1","G2","G3","G4","G5","G6","G7","G8","G9","G10"];
        else if (ward === "Cabin") beds = ["C1","C2","C3","C4","C5","C6","C7","C8","C9","C10"];
        else if (ward === "ICU") beds = ["ICU1","ICU2","ICU3"];

        // Inject occupied beds from PHP
        let occupied = <?php echo json_encode($occupiedBeds); ?>;
        let wardOccupied = occupied[ward] || [];

        beds.forEach(function(b) {
            let opt = document.createElement("option");
            opt.value = b;
            opt.text = b;
            if (wardOccupied.includes(b)) {
                opt.disabled = true;
                opt.text += " (Occupied)";
            }
            bedSelect.add(opt);
        });
    }
    </script>
</head>
<body>
<div class="transfer-form">
    <h2>Transfer Patient</h2>

    <?php if ($admission): ?>
        <!-- Transfer form -->
        <form method="post" 
              action="<?php echo $rootdir ?>/forms/form_transfer/save.php" 
              onsubmit="return top.restoreSession()">
            <input type="hidden" name="admission_id" value="<?= htmlspecialchars($admission['id']) ?>">

            <div class="form-group">
                <label>Current Ward</label>
                <input type="text" value="<?= htmlspecialchars($admission['ward']) ?>" readonly>
            </div>
            <div class="form-group">
                <label>Current Bed</label>
                <input type="text" value="<?= htmlspecialchars($admission['bed']) ?>" readonly>
            </div>

            <div class="form-group">
                <label for="new_ward">New Ward</label>
                <select id="new_ward" name="new_ward" onchange="updateBeds()" required>
                    <option value="">-- Select Ward --</option>
                    <option value="General">General Ward</option>
                    <option value="Cabin">Cabin</option>
                    <option value="ICU">ICU</option>
                </select>
            </div>

            <div class="form-group">
                <label for="new_bed">New Bed</label>
                <select id="new_bed" name="new_bed" required>
                    <option value="">-- Select Bed --</option>
                </select>
            </div>

            <button type="submit" class="btn">Transfer Patient</button>
        </form>

    <?php elseif (!$current_pid): ?>
        <!-- Global access: list all admitted patients -->
        <form method="get" action="new.php">
            <div class="form-group">
                <label for="id">Select Patient to Transfer</label>
                <select name="id" id="id" required>
                    <option value="">-- Select Patient --</option>
                    <?php foreach ($admittedPatients as $p): ?>
                        <option value="<?= htmlspecialchars($p['id']) ?>">
                            <?= htmlspecialchars($p['fname'] . " " . $p['lname'] . " (PID: " . $p['pid'] . ") - Ward: " . $p['ward'] . " Bed: " . $p['bed']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <button type="submit" class="btn">Proceed</button>
        </form>

    <?php else: ?>
        <p>This patient is not currently admitted.</p>
    <?php endif; ?>
</div>
</body>
</html>
<?php formFooter(); ?>
