<?php
include_once("../../globals.php");
include_once("$srcdir/api.inc");

// Get form id or patient id
$formid = $_GET["id"] ?? 0;
$pid = $_GET["pid"] ?? 0;

$data = [];

// 1️⃣ Fetch by form id if provided
if ($formid) {
    $sql = "SELECT * FROM form_transfer WHERE id = ?";
    $res = sqlStatement($sql, [$formid]);
    $data = sqlFetchArray($res);
}

// 2️⃣ If no form id, but pid provided, fetch the **latest transfer** for the patient
if (!$data && $pid) {
    $sql = "SELECT * FROM form_transfer WHERE pid = ? ORDER BY transfer_date DESC, id DESC LIMIT 1";
    $res = sqlStatement($sql, [$pid]);
    $data = sqlFetchArray($res);
}

formHeader("Transfer Form - View");
?>
<html>
<head>
    <title>Transfer Form</title>
    <style>
        .transfer-view {
            max-width: 600px;
            margin: 20px auto;
            padding: 20px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
            font-family: Arial, sans-serif;
        }
        .transfer-view h2 {
            text-align: center;
            color: #2c3e50;
            margin-bottom: 20px;
        }
        .detail-row { margin: 12px 0; padding: 10px; border-bottom: 1px solid #eee; }
        .detail-row:last-child { border-bottom: none; }
        .detail-label { font-weight: bold; color: #34495e; display: inline-block; width: 160px; }
        .detail-value { color: #2c3e50; }
        .from-to { font-weight: bold; color: #e67e22; }
        .btn-back {
            display: block; margin-top: 20px; text-align: center;
            background: #007bff; color: #fff; padding: 10px;
            border-radius: 6px; text-decoration: none; font-weight: bold;
        }
        .btn-back:hover { background: #0056b3; }
    </style>
</head>
<body>
<div class="transfer-view">
    <h2>Transfer Summary</h2>

    <?php if ($data): ?>
        <div class="detail-row">
            <span class="detail-label">Transfer Date:</span>
            <span class="detail-value"><?= htmlspecialchars($data['transfer_date']) ?></span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Doctor:</span>
            <span class="detail-value"><?= htmlspecialchars($data['doctor']) ?></span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Patient ID:</span>
            <span class="detail-value"><?= htmlspecialchars($data['pid']) ?></span>
        </div>
        <div class="detail-row">
            <span class="detail-label">From:</span>
            <span class="detail-value from-to">
                <?= htmlspecialchars($data['from_ward']) ?> - <?= htmlspecialchars($data['from_bed']) ?>
            </span>
        </div>
        <div class="detail-row">
            <span class="detail-label">To:</span>
            <span class="detail-value from-to">
                <?= htmlspecialchars($data['to_ward']) ?> - <?= htmlspecialchars($data['to_bed']) ?>
            </span>
        </div>
    <?php else: ?>
        <p>No transfer data found.</p>
    <?php endif; ?>

    <a href="<?php echo $rootdir; ?>/patient_file/encounter/encounter_top.php" class="btn-back">⬅ Back to Encounter</a>
</div>
</body>
</html>
<?php formFooter(); ?>
