/**
 * New Patient Encounter Form JavaScript
 *
 * @author    Brady Miller <brady.g.miller@gmail.com>
 * @author    Ranganath Pathak <pathak@scrs1.org>
 * @author    Jerry Padgett <sjpadgett@gmail.com>
 * @author    Stephen Nielson <snielson@discoverandchange.com>
 * @copyright Copyright (c) 2019 Brady Miller <brady.g.miller@gmail.com>
 * @copyright Copyright (c) 2019 Ranganath Pathak <pathak@scrs1.org>
 * @copyright Copyright (c) 2025 Mountain Valley Health <mvhinspire@mountainvalleyhealthinc.com>
 * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3
 * @license   There are segments of code in this file that have been generated via Claude.ai and used common.php as its original source are licensed as Public Domain.  They have been marked with a header and footer.
 */

// CODE GENERATED BY CLAUDE.AI - START
window.NewPatientForm = function(window) {
    let formConfig = {};

    const init = function(config) {
        formConfig = {
            webroot: config.webroot || '',
            pid: config.pid || '',
            encounter: config.encounter || '',
            isPosEnabled: config.isPosEnabled || false,
            validationConstraints: config.validationConstraints || [],
            csrfToken: config.csrfToken || '',
            viewmode: config.viewmode || false,
            enableGroupTherapy: config.enableGroupTherapy || false,
            therapyGroupCategories: config.therapyGroupCategories || [],
            duplicate: config.duplicate || {isDuplicate: false, encounter: null, dateStr: null}
        };
        if ((formConfig.webroot === undefined || formConfig === null) || !formConfig.pid || !formConfig.csrfToken) {
            console.error('Missing required configuration values', formConfig);
            return;
        }

        // Initialize datepickers
        initializeDatePickers();

        // Initialize tooltips
        initializeTooltips();

        // Add event listeners
        setupEventListeners();
// CODE GENERATED BY CLAUDE.AI - END

        focusOnReasonCode();

        if (formConfig.enableGroupTherapy) {
            setupGroupTherapy();
        }

        setupGlobalFunctions();

        checkForDuplicateEncounter(formConfig);
    };

    let xl = window.top.xl || function(str) { return str; };
    const initializeDatePickers = function() {
        datetimepickerTranslated('.datepicker', {
            timepicker: true
            , showSeconds: false
            , formatInput: true
        });
    };

    function setupGroupTherapy() {
        // Handle visibility of group name input based on category selection
        const categorySelect = document.getElementById('pc_catid');
        const therapyGroupDiv = document.getElementById('therapy_group_name');

        if (categorySelect && therapyGroupDiv) {
            categorySelect.addEventListener('change', function() {
                if (formConfig.therapyGroupCategories.indexOf(this.value) > -1) {
                    therapyGroupDiv.style.display = '';
                } else {
                    therapyGroupDiv.style.display = 'none';
                }
            });
        }
    }

    function checkForDuplicateEncounter(config) {
        if (config.duplicate && config.duplicate.isDuplicate) {
            if (!confirm(xl("A visit already exists for this patient today. Click Cancel to open it, or OK to proceed with creating a new one."))) {
                // User pressed the cancel button, so redirect to today's encounter
                top.restoreSession();
                parent.left_nav.setEncounter(config.duplicate.dateStr, config.duplicate.encounter, window.name);
                parent.left_nav.loadFrame('enc2', window.name, 'patient_file/encounter/encounter_top.php?set_encounter='
                    + encodeURIComponent(config.duplicate.encounter));
                return;
            }
        }
    }

    function setupGlobalFunctions() {
        // callback from add_edit_issue.php: refreshIssue
        window.refreshIssue = function refreshIssue(issue, title) {
            var s = document.forms[0]['issues[]'];
            s.options[s.options.length] = new Option(title, issue, true, true);
        };

        if (formConfig.enableGroupTherapy) {
            window.setgroup = setGroup;
        }
    }

    function focusOnReasonCode() {
        window.document.addEventListener('DOMContentLoaded', function() {
            $('#reason_code').focus();

            // $('#sensitivity-tooltip').attr({
            //     "title": xl('If set as high will restrict visibility of encounter to users belonging to certain groups (AROs). By default - Physicians and Administrators'),
            //     "data-toggle": "tooltip",
            //     "data-placement": "bottom"
            // }).tooltip();
        });
    }

// CODE GENERATED BY CLAUDE.AI - START
    const initializeTooltips = function() {
        $('#sensitivity-tooltip').attr({
            "title": xl('If set as high will restrict visibility of encounter to users belonging to certain groups (AROs). By default - Physicians and Administrators'),
            "data-toggle": "tooltip",
            "data-placement": "bottom",
            "trigger": "click"
        }).tooltip();

        $('#onset-tooltip').attr({
            "title": xl('Hospital date needed for successful billing of hospital encounters'),
            "data-toggle": "tooltip",
            "data-placement": "bottom"
        }).tooltip();
    };

    const setupEventListeners = function() {
        // Save button click handler
        $('#saveEncounter').on('click', function(event) {
            top.restoreSession();
            saveClicked(event);
        });

        $(".enc_issue").on('click', function (e) {
            e.preventDefault();
            e.stopPropagation();
            dlgopen('', '', 700, 650, '', '', {
                allowResize: true,
                allowDrag: true,
                dialogId: '',
                type: 'iframe',
                url: $(this).attr('href')
            });
        });

        // Cancel button click handler
        $('.btn-cancel').on('click', function() {
            if (formConfig.viewmode) {
                cancelClickedOld();
            } else {
                cancelClickedNew();
            }
        });

        // Facility selection change handler
        $('#facility_id_sel').on('change', function() {
            let facilitySelect = document.getElementById('facility_id_sel');
            let facilityHidden = document.getElementById('facility_id');
            facilityHidden.value = facilitySelect[facilitySelect.selectedIndex].value;
            if (formConfig.isPosEnabled) {
                getPOS();
            }
        });
        $('#provider_id').on('change', newUserSelected);

        // Group link click handler
        if (typeof formConfig.enableGroupTherapy !== 'undefined' && formConfig.enableGroupTherapy) {
            $('#form_group').on('click', function() {
                sel_group();
            });

            // Handle group category visibility
            if (formConfig.viewmode) {
                $('#pc_catid').on('change', function () {
                    const therapyGroupCategories = formConfig.therapyGroupCategories || [];
                    if (therapyGroupCategories.indexOf($(this).val()) > -1) {
                        $('#therapy_group_name').show();
                    } else {
                        $('#therapy_group_name').hide();
                    }
                });
            }
        }

        if (window.OeFormValidation) {
            window.OeFormValidation.init();
        }
    };

    // Save clicked verification
    const saveClicked = function(event) {
        const submit = window.OeFormValidation.submitme(1, event, 'new-encounter-form', formConfig.validationConstraints);
        if (submit) {
            top.restoreSession();
            $('#new-encounter-form').submit();
        }else {
            console.error(xl("Validation failed for form"));
        }
    };

    // POS code handling
    const getPOS = function() {
        if (!formConfig.isPosEnabled) {
            return false;
        }

        const facility = document.forms[0].facility_id.value;
        $.ajax({
            url: formConfig.webroot + "/library/ajax/facility_ajax_code.php",
            method: "GET",
            data: {
                mode: "get_pos",
                facility_id: facility,
                csrf_token_form: formConfig.csrfToken
            }
        }).done(function(fid) {
            document.forms[0].pos_code.value = JSON.parse(fid);
        }).fail(function(xhr) {
            console.error('Error fetching POS code:', xhr);
        });
    };

    // Provider selection handling
    const newUserSelected = function() {
        const provider = document.getElementById('provider_id').value;
        $.ajax({
            url: formConfig.webroot + "/library/ajax/facility_ajax_code.php",
            method: "GET",
            data: {
                mode: "get_user_data",
                provider_id: provider,
                csrf_token_form: formConfig.csrfToken
            }
        }).done(function(data) {
            const rtn = JSON.parse(data);
            document.forms[0].facility_id.value = rtn[0];
            // facility_id can be hidden so we only set it if it exists
            if (document.forms[0].facility_id_sel) {
                document.forms[0].facility_id_sel.value = rtn[0];
            }
            if (formConfig.isPosEnabled) {
                document.forms[0].pos_code.value = rtn[1];
            }
            if (Number(rtn[2]) === 1) {
                document.forms[0]['billing_facility'].value = rtn[0];
            }
        }).fail(function(xhr) {
            console.error('Error fetching provider data:', xhr);
        });
    };

    // Cancel handlers
    const cancelClickedNew = function() {
        top.restoreSession();
        window.parent.left_nav.loadFrame('ens1', window.name, 'patient_file/history/encounters.php');
        return false;
    };

    const cancelClickedOld = function() {
        top.restoreSession();
        location.href = formConfig.webroot + '/interface/patient_file/encounter/forms.php';
        return false;
    };

    // Group therapy related functions
    const sel_group = function() {
        top.restoreSession();
        const url = formConfig.webroot + '/interface/main/calendar/find_group_popup.php';
        dlgopen(url, '_blank', 500, 400, '', '', {
            buttons: [
                {text: xl('Close'), close: true, style: 'default btn-sm'}
            ]
        });
    };

    // Callback for find-group popup
    const setGroup = function(gid, name) {
        const f = document.forms[0];
        f.form_group.value = name;
        f.form_gid.value = gid;
    };

    return {
        init: init,
        setGroup: setGroup,
        getPOS: getPOS
    };
}(window);
// CODE GENERATED BY CLAUDE.AI - END
