/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */
/**
 * @module block-quote/blockquote
 */
import { Plugin } from 'ckeditor5/src/core.js';
import BlockQuoteEditing from './blockquoteediting.js';
import BlockQuoteUI from './blockquoteui.js';
/**
 * The block quote plugin.
 *
 * For more information about this feature check the {@glink api/block-quote package page}.
 *
 * This is a "glue" plugin which loads the {@link module:block-quote/blockquoteediting~BlockQuoteEditing block quote editing feature}
 * and {@link module:block-quote/blockquoteui~BlockQuoteUI block quote UI feature}.
 *
 * @extends module:core/plugin~Plugin
 */
export default class BlockQuote extends Plugin {
    /**
     * @inheritDoc
     */
    static get requires(): readonly [typeof BlockQuoteEditing, typeof BlockQuoteUI];
    /**
     * @inheritDoc
     */
    static get pluginName(): "BlockQuote";
    /**
     * @inheritDoc
     */
    static get isOfficialPlugin(): true;
}
