(function() {
  'use strict';
  // the 0.0001 offset fixes a bug in Chrome 27
  var PIx2 = Math.PI * 2 - 0.0001;
  /**
   * Ring constructor
   * @constructor
   * @augments Konva.Shape
   * @param {Object} config
   * @param {Number} config.innerRadius
   * @param {Number} config.outerRadius
   * @param {Boolean} [config.clockwise]
   * @@shapeParams
   * @@nodeParams
   * @example
   * var ring = new Konva.Ring({
   *   innerRadius: 40,
   *   outerRadius: 80,
   *   fill: 'red',
   *   stroke: 'black',
   *   strokeWidth: 5
   * });
   */
  Konva.Ring = function(config) {
    this.___init(config);
  };

  Konva.Ring.prototype = {
    _centroid: true,
    ___init: function(config) {
      // call super constructor
      Konva.Shape.call(this, config);
      this.className = 'Ring';
      this.sceneFunc(this._sceneFunc);
    },
    _sceneFunc: function(context) {
      context.beginPath();
      context.arc(0, 0, this.getInnerRadius(), 0, PIx2, false);
      context.moveTo(this.getOuterRadius(), 0);
      context.arc(0, 0, this.getOuterRadius(), PIx2, 0, true);
      context.closePath();
      context.fillStrokeShape(this);
    },
    // implements Shape.prototype.getWidth()
    getWidth: function() {
      return this.getOuterRadius() * 2;
    },
    // implements Shape.prototype.getHeight()
    getHeight: function() {
      return this.getOuterRadius() * 2;
    },
    // implements Shape.prototype.setWidth()
    setWidth: function(width) {
      Konva.Node.prototype.setWidth.call(this, width);
      if (this.outerRadius() !== width / 2) {
        this.setOuterRadius(width / 2);
      }
    },
    // implements Shape.prototype.setHeight()
    setHeight: function(height) {
      Konva.Node.prototype.setHeight.call(this, height);
      if (this.outerRadius() !== height / 2) {
        this.setOuterRadius(height / 2);
      }
    },
    setOuterRadius: function(val) {
      this._setAttr('outerRadius', val);
      this.setWidth(val * 2);
      this.setHeight(val * 2);
    }
  };
  Konva.Util.extend(Konva.Ring, Konva.Shape);

  // add getters setters
  Konva.Factory.addGetterSetter(
    Konva.Ring,
    'innerRadius',
    0,
    Konva.Validators.getNumberValidator()
  );

  /**
   * get/set innerRadius
   * @name innerRadius
   * @method
   * @memberof Konva.Ring.prototype
   * @param {Number} innerRadius
   * @returns {Number}
   * @example
   * // get inner radius
   * var innerRadius = ring.innerRadius();
   *
   * // set inner radius
   * ring.innerRadius(20);
   */
  Konva.Factory.addGetter(
    Konva.Ring,
    'outerRadius',
    0,
    Konva.Validators.getNumberValidator()
  );
  Konva.Factory.addOverloadedGetterSetter(Konva.Ring, 'outerRadius');

  /**
   * get/set outerRadius
   * @name outerRadius
   * @method
   * @memberof Konva.Ring.prototype
   * @param {Number} outerRadius
   * @returns {Number}
   * @example
   * // get outer radius
   * var outerRadius = ring.outerRadius();
   *
   * // set outer radius
   * ring.outerRadius(20);
   */

  Konva.Collection.mapMethods(Konva.Ring);
})();
