/**
   @license
   ----
   tiff.js: https://github.com/seikichi/tiff.js

   Copyright (C) 2013 seikichi[at]kmc.gr.jp

   This software is provided 'as-is', without any express or implied
   warranty. In no event will the authors be held liable for any damages
   arising from the use of this software.

   Permission is granted to anyone to use this software for any purpose,
   including commercial applications, and to alter it and redistribute it
   freely, subject to the following restrictions:

   1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.

   2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

   3. This notice may not be removed or altered from any source
   distribution.
   ----
   zlib: http://www.zlib.net/

   Copyright (C) 1995-2013 Jean-loup Gailly and Mark Adler

   This software is provided 'as-is', without any express or implied
   warranty.  In no event will the authors be held liable for any damages
   arising from the use of this software.

   Permission is granted to anyone to use this software for any purpose,
   including commercial applications, and to alter it and redistribute it
   freely, subject to the following restrictions:

   1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
   2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
   3. This notice may not be removed or altered from any source distribution.

   Jean-loup Gailly        Mark Adler
   jloup@gzip.org          madler@alumni.caltech.edu


   The data format used by the zlib library is described by RFCs (Request for
   Comments) 1950 to 1952 in the files http://tools.ietf.org/html/rfc1950
   (zlib format), rfc1951 (deflate format) and rfc1952 (gzip format).
   ----
   LibTIFF: http://www.remotesensing.org/libtiff/

   Copyright (c) 1988-1997 Sam Leffler
   Copyright (c) 1991-1997 Silicon Graphics, Inc.

   Permission to use, copy, modify, distribute, and sell this software and 
   its documentation for any purpose is hereby granted without fee, provided
   that (i) the above copyright notices and this permission notice appear in
   all copies of the software and related documentation, and (ii) the names of
   Sam Leffler and Silicon Graphics may not be used in any advertising or
   publicity relating to the software without the specific, prior written
   permission of Sam Leffler and Silicon Graphics.

   THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
   EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
   WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  

   IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
   ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
   OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
   WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
   LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
   OF THIS SOFTWARE.
*/
var loadModule=(function(options){var Module={};if("TOTAL_MEMORY"in options){Module["TOTAL_MEMORY"]=options["TOTAL_MEMORY"]}var Module;if(!Module)Module=(typeof Module!=="undefined"?Module:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){DYNAMICTOP=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};var sourceRegex=/^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){funcstr+="var stack = "+JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"="+convertCode.returnValue+";"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){funcstr+=JSsource["stackRestore"].body.replace("()","(stack)")+";"}funcstr+="return ret})";return eval(funcstr)}}))();Module["ccall"]=ccall;Module["cwrap"]=cwrap;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(typeof _sbrk!=="undefined"&&!_sbrk.called||!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<2)return 0;maxBytesToWrite-=2;var startPtr=outPtr;var numCharsToWrite=maxBytesToWrite<str.length*2?maxBytesToWrite/2:str.length;for(var i=0;i<numCharsToWrite;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr>>1]=codeUnit;outPtr+=2}HEAP16[outPtr>>1]=0;return outPtr-startPtr}Module["stringToUTF16"]=stringToUTF16;function lengthBytesUTF16(str){return str.length*2}Module["lengthBytesUTF16"]=lengthBytesUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<4)return 0;var startPtr=outPtr;var endPtr=startPtr+maxBytesToWrite-4;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++i);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr>>2]=codeUnit;outPtr+=4;if(outPtr+4>endPtr)break}HEAP32[outPtr>>2]=0;return outPtr-startPtr}Module["stringToUTF32"]=stringToUTF32;function lengthBytesUTF32(str){var len=0;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343)++i;len+=4}return len}Module["lengthBytesUTF32"]=lengthBytesUTF32;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}var parsed=func;try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}parsed=parse()}catch(e){parsed+="?"}if(parsed.indexOf("?")>=0&&!hasLibcxxabi){Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")}return parsed}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;var PAGE_SIZE=4096;function alignMemoryPage(x){if(x%4096>0){x+=4096-x%4096}return x}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function enlargeMemory(){var OLD_TOTAL_MEMORY=TOTAL_MEMORY;var LIMIT=Math.pow(2,31);if(DYNAMICTOP>=LIMIT)return false;while(TOTAL_MEMORY<=DYNAMICTOP){if(TOTAL_MEMORY<LIMIT/2){TOTAL_MEMORY=alignMemoryPage(2*TOTAL_MEMORY)}else{var last=TOTAL_MEMORY;TOTAL_MEMORY=alignMemoryPage((3*TOTAL_MEMORY+LIMIT)/4);if(TOTAL_MEMORY<=last)return false}}TOTAL_MEMORY=Math.max(TOTAL_MEMORY,16*1024*1024);if(TOTAL_MEMORY>=LIMIT)return false;try{if(ArrayBuffer.transfer){buffer=ArrayBuffer.transfer(buffer,TOTAL_MEMORY)}else{var oldHEAP8=HEAP8;buffer=new ArrayBuffer(TOTAL_MEMORY)}}catch(e){return false}var success=_emscripten_replace_memory(buffer);if(!success)return false;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer);if(!ArrayBuffer.transfer){HEAP8.set(oldHEAP8)}return true}var byteLength;try{byteLength=Function.prototype.call.bind(Object.getOwnPropertyDescriptor(ArrayBuffer.prototype,"byteLength").get);byteLength(new ArrayBuffer(4))}catch(e){byteLength=(function(buffer){return buffer.byteLength})}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||16777216;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}totalMemory=Math.max(totalMemory,16*1024*1024);if(totalMemory!==TOTAL_MEMORY){TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer;buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var ASM_CONSTS=[];STATIC_BASE=8;STATICTOP=STATIC_BASE+164992;__ATINIT__.push();allocate([0,0,0,0,0,0,240,63,239,97,72,177,80,49,246,63,202,111,77,145,174,231,244,63,170,17,108,239,98,208,242,63,0,0,0,0,0,0,240,63,59,191,167,192,105,36,233,63,187,32,199,123,122,81,225,63,93,171,114,222,85,168,209,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,0,0,0,84,8,0,0,1,0,0,0,0,0,0,0,56,0,0,0,116,0,0,0,154,130,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,82,251,1,0,0,0,0,0,157,130,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,95,251,1,0,0,0,0,0,34,136,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,103,251,1,0,0,0,0,0,36,136,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,119,251,1,0,0,0,0,0,39,136,0,0,255,255,255,255,3,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,65,0,1,1,139,251,1,0,0,0,0,0,40,136,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,155,251,1,0,0,0,0,0,0,144,0,0,4,0,4,0,7,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,1,0,184,251,1,0,0,0,0,0,3,144,0,0,20,0,20,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,196,251,1,0,0,0,0,0,4,144,0,0,20,0,20,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,213,251,1,0,0,0,0,0,1,145,0,0,4,0,4,0,7,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,1,0,231,251,1,0,0,0,0,0,2,145,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,255,251,1,0,0,0,0,0,1,146,0,0,1,0,1,0,10,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,22,252,1,0,0,0,0,0,2,146,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,40,252,1,0,0,0,0,0,3,146,0,0,1,0,1,0,10,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,54,252,1,0,0,0,0,0,4,146,0,0,1,0,1,0,10,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,70,252,1,0,0,0,0,0,5,146,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,88,252,1,0,0,0,0,0,6,146,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,105,252,1,0,0,0,0,0,7,146,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,121,252,1,0,0,0,0,0,8,146,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,134,252,1,0,0,0,0,0,9,146,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,146,252,1,0,0,0,0,0,10,146,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,152,252,1,0,0,0,0,0,20,146,0,0,255,255,255,255,3,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,65,0,1,1,164,252,1,0,0,0,0,0,124,146,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,176,252,1,0,0,0,0,0,134,146,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,186,252,1,0,0,0,0,0,144,146,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,198,252,1,0,0,0,0,0,145,146,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,209,252,1,0,0,0,0,0,146,146,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,228,252,1,0,0,0,0,0,0,160,0,0,4,0,4,0,7,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,1,0,248,252,1,0,0,0,0,0,1,160,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,8,253,1,0,0,0,0,0,2,160,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,1,0,19,253,1,0,0,0,0,0,3,160,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,1,0,35,253,1,0,0,0,0,0,4,160,0,0,13,0,13,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,51,253,1,0,0,0,0,0,11,162,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,68,253,1,0,0,0,0,0,12,162,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,80,253,1,0,0,0,0,0,14,162,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,105,253,1,0,0,0,0,0,15,162,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,127,253,1,0,0,0,0,0,16,162,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,149,253,1,0,0,0,0,0,20,162,0,0,2,0,2,0,3,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,65,0,1,0,174,253,1,0,0,0,0,0,21,162,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,190,253,1,0,0,0,0,0,23,162,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,204,253,1,0,0,0,0,0,0,163,0,0,1,0,1,0,7,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,65,0,1,0,218,253,1,0,0,0,0,0,1,163,0,0,1,0,1,0,7,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,65,0,1,0,229,253,1,0,0,0,0,0,2,163,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,239,253,1,0,0,0,0,0,1,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,250,253,1,0,0,0,0,0,2,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,9,254,1,0,0,0,0,0,3,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,22,254,1,0,0,0,0,0,4,164,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,35,254,1,0,0,0,0,0,5,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,52,254,1,0,0,0,0,0,6,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,74,254,1,0,0,0,0,0,7,164,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,91,254,1,0,0,0,0,0,8,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,103,254,1,0,0,0,0,0,9,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,112,254,1,0,0,0,0,0,10,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,123,254,1,0,0,0,0,0,11,164,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,133,254,1,0,0,0,0,0,12,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,158,254,1,0,0,0,0,0,32,164,0,0,33,0,33,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,179,254,1,0,0,0,0,0,254,0,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,5,0,1,0,193,254,1,0,0,0,0,0,255,0,0,0,1,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,1,0,205,254,1,0,0,0,0,0,0,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,1,0,0,0,220,254,1,0,0,0,0,0,1,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,1,0,1,0,211,8,2,0,0,0,0,0,2,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,6,0,0,0,231,254,1,0,0,0,0,0,3,1,0,0,255,255,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,7,0,0,0,99,20,2,0,0,0,0,0,6,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,8,0,0,0,245,254,1,0,0,0,0,0,7,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,9,0,1,0,15,255,1,0,0,0,0,0,8,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,29,255,1,0,0,0,0,0,9,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,39,255,1,0,0,0,0,0,10,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,10,0,0,0,50,255,1,0,0,0,0,0,13,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,60,255,1,0,0,0,0,0,14,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,73,255,1,0,0,0,0,0,15,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,90,255,1,0,0,0,0,0,16,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,95,255,1,0,0,0,0,0,17,1,0,0,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,24,9,2,0,0,0,0,0,18,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,15,0,0,0,101,255,1,0,0,0,0,0,21,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,16,0,0,0,113,255,1,0,0,0,0,0,22,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,17,0,0,0,129,255,1,0,0,0,0,0,23,1,0,0,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,191,10,2,0,0,0,0,0,24,1,0,0,254,255,255,255,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,18,0,1,0,142,255,1,0,0,0,0,0,25,1,0,0,254,255,255,255,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,19,0,1,0,157,255,1,0,0,0,0,0,26,1,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,3,0,1,0,172,255,1,0,0,0,0,0,27,1,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,3,0,1,0,184,255,1,0,0,0,0,0,28,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,20,0,0,0,196,255,1,0,0,0,0,0,29,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,216,255,1,0,0,0,0,0,30,1,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,4,0,1,0,225,255,1,0,0,0,0,0,31,1,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,4,0,1,0,235,255,1,0,0,0,0,0,32,1,0,0,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,255,1,0,0,0,0,0,33,1,0,0,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,0,0,0,0,34,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,16,0,2,0,0,0,0,0,35,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,33,0,2,0,0,0,0,0,40,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,22,0,1,0,51,0,2,0,0,0,0,0,41,1,0,0,2,0,2,0,3,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,23,0,1,0,66,0,2,0,0,0,0,0,44,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,77,0,2,0,0,0,0,0,45,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,51,0,0,0,0,0,0,0,44,0,1,0,95,0,2,0,0,0,0,0,49,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,112,0,2,0,0,0,0,0,50,1,0,0,20,0,20,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,121,0,2,0,0,0,0,0,59,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,130,0,2,0,0,0,0,0,60,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,137,0,2,0,0,0,0,0,62,1,0,0,2,0,2,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,1,0,150,0,2,0,0,0,0,0,63,1,0,0,6,0,6,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,1,0,161,0,2,0,0,0,0,0,64,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,51,0,0,0,0,0,0,0,26,0,1,0,183,0,2,0,0,0,0,0,65,1,0,0,2,0,2,0,3,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,37,0,1,0,192,0,2,0,0,0,0,0,66,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,2,0,0,0,206,0,2,0,0,0,0,0,67,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,2,0,0,0,216,0,2,0,0,0,0,0,68,1,0,0,255,255,1,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,12,9,2,0,0,0,0,0,69,1,0,0,255,255,1,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,227,0,2,0,0,0,0,0,74,1,0,0,255,255,255,255,18,0,0,0,0,0,0,0,38,0,0,0,0,0,0,0,49,0,1,1,242,0,2,0,84,0,0,0,76,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,0,0,59,20,2,0,0,0,0,0,77,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,27,0,0,0,0,0,0,0,46,0,1,1,249,0,2,0,0,0,0,0,78,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,2,1,2,0,0,0,0,0,80,1,0,0,2,0,2,0,3,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,65,0,0,0,15,1,2,0,0,0,0,0,81,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,24,1,2,0,0,0,0,0,82,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,31,0,0,1,38,1,2,0,0,0,0,0,83,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,32,0,0,0,51,1,2,0,0,0,0,0,84,1,0,0,254,255,255,255,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,33,0,1,0,64,1,2,0,0,0,0,0,85,1,0,0,254,255,255,255,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,34,0,1,0,80,1,2,0,0,0,0,0,87,1,0,0,255,255,253,255,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,1,96,1,2,0,0,0,0,0,88,1,0,0,1,0,1,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,105,1,2,0,0,0,0,0,88,1,0,0,1,0,1,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,105,1,2,0,0,0,0,0,89,1,0,0,1,0,1,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,120,1,2,0,0,0,0,0,17,2,0,0,3,0,3,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,0,0,135,1,2,0,0,0,0,0,18,2,0,0,2,0,2,0,3,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,39,0,0,0,153,1,2,0,0,0,0,0,19,2,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,40,0,0,0,170,1,2,0,0,0,0,0,20,2,0,0,6,0,6,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,41,0,1,0,187,1,2,0,0,0,0,0,188,2,0,0,253,255,253,255,1,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,65,0,0,1,207,1,2,0,0,0,0,0,227,128,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,31,0,0,0,217,1,2,0,0,0,0,0,228,128,0,0,254,255,255,255,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,32,0,0,0,226,1,2,0,0,0,0,0,229,128,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,35,0,0,0,235,1,2,0,0,0,0,0,230,128,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,36,0,0,0,246,1,2,0,0,0,0,0,20,130,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,1,0,0,2,2,0,0,0,0,0,21,130,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,1,0,15,2,2,0,0,0,0,0,22,130,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,31,2,2,0,0,0,0,0,23,130,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,45,2,2,0,0,0,0,0,24,130,0,0,1,0,1,0,11,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,65,0,1,0,62,2,2,0,0,0,0,0,25,130,0,0,16,0,16,0,11,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,1,0,83,2,2,0,0,0,0,0,26,130,0,0,16,0,16,0,11,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,1,0,103,2,2,0,0,0,0,0,141,130,0,0,2,0,2,0,3,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,65,0,0,0,123,2,2,0,0,0,0,0,142,130,0,0,4,0,4,0,1,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,0,0,239,253,1,0,0,0,0,0,152,130,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,143,2,2,0,0,0,0,0,187,131,0,0,253,255,253,255,4,0,0,0,0,0,0,0,44,0,0,0,0,0,0,0,65,0,0,1,153,2,2,0,0,0,0,0,73,134,0,0,253,255,253,255,1,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,65,0,0,1,166,2,2,0,0,0,0,0,105,135,0,0,1,0,1,0,18,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,65,0,0,0,176,2,2,0,100,0,0,0,115,135,0,0,253,255,253,255,7,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,65,0,0,1,190,2,2,0,0,0,0,0,37,136,0,0,1,0,1,0,18,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,65,0,0,0,202,2,2,0,0,0,0,0,92,136,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,65,0,1,0,215,2,2,0,0,0,0,0,93,136,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,65,0,1,0,229,2,2,0,0,0,0,0,94,136,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,65,0,1,0,243,2,2,0,0,0,0,0,95,136,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,65,0,1,0,255,2,2,0,0,0,0,0,63,146,0,0,1,0,1,0,12,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,6,3,2,0,0,0,0,0,5,160,0,0,1,0,1,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,14,3,2,0,0,0,0,0,18,198,0,0,4,0,4,0,1,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,0,0,40,3,2,0,0,0,0,0,19,198,0,0,4,0,4,0,1,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,0,0,51,3,2,0,0,0,0,0,20,198,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,70,3,2,0,0,0,0,0,21,198,0,0,255,255,255,255,1,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,88,3,2,0,0,0,0,0,22,198,0,0,255,255,255,255,1,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,0,1,109,3,2,0,0,0,0,0,23,198,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,0,0,123,3,2,0,0,0,0,0,24,198,0,0,255,255,255,255,3,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,65,0,0,1,133,3,2,0,0,0,0,0,25,198,0,0,2,0,2,0,3,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,65,0,0,0,152,3,2,0,0,0,0,0,26,198,0,0,255,255,255,255,5,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,172,3,2,0,0,0,0,0,27,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,183,3,2,0,0,0,0,0,28,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,200,3,2,0,0,0,0,0,29,198,0,0,255,255,255,255,4,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,65,0,0,1,217,3,2,0,0,0,0,0,30,198,0,0,2,0,2,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,0,0,228,3,2,0,0,0,0,0,92,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,241,3,2,0,0,0,0,0,31,198,0,0,2,0,2,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,0,0,2,4,2,0,0,0,0,0,32,198,0,0,2,0,2,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,0,0,20,4,2,0,0,0,0,0,33,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,36,4,2,0,0,0,0,0,34,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,49,4,2,0,0,0,0,0,35,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,62,4,2,0,0,0,0,0,36,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,81,4,2,0,0,0,0,0,37,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,100,4,2,0,0,0,0,0,38,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,117,4,2,0,0,0,0,0,39,198,0,0,255,255,255,255,5,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,134,4,2,0,0,0,0,0,40,198,0,0,255,255,255,255,5,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,148,4,2,0,0,0,0,0,41,198,0,0,2,0,2,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,0,0,162,4,2,0,0,0,0,0,42,198,0,0,1,0,1,0,10,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,176,4,2,0,0,0,0,0,43,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,193,4,2,0,0,0,0,0,44,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,207,4,2,0,0,0,0,0,45,198,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,0,0,225,4,2,0,0,0,0,0,46,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,241,4,2,0,0,0,0,0,47,198,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,5,5,2,0,0,0,0,0,48,198,0,0,4,0,4,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,0,0,24,5,2,0,0,0,0,0,49,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,33,5,2,0,0,0,0,0,50,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,50,5,2,0,0,0,0,0,51,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,68,5,2,0,0,0,0,0,52,198,0,0,255,255,255,255,1,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,0,1,80,5,2,0,0,0,0,0,53,198,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,0,0,95,5,2,0,0,0,0,0,90,198,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,0,0,111,5,2,0,0,0,0,0,91,198,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,0,0,134,5,2,0,0,0,0,0,93,198,0,0,16,0,16,0,1,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,0,0,157,5,2,0,0,0,0,0,139,198,0,0,255,255,255,255,1,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,173,5,2,0,0,0,0,0,140,198,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,0,1,193,5,2,0,0,0,0,0,141,198,0,0,4,0,4,0,4,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,65,0,0,0,213,5,2,0,0,0,0,0,142,198,0,0,255,255,255,255,4,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,65,0,0,1,224,5,2,0,0,0,0,0,143,198,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,0,1,236,5,2,0,0,0,0,0,144,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,253,5,2,0,0,0,0,0,145,198,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,0,1,20,6,2,0,0,0,0,0,146,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,38,6,2,0,0,0,0,0,27,0,1,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,62,6,2,0,0,0,0,0,90,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,0,0,72,6,2,0,0,0,0,0,144,1,0,0,1,0,1,0,18,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,65,0,0,0,80,6,2,0,0,0,0,0,145,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,0,0,100,6,2,0,0,0,0,0,146,1,0,0,1,0,1,0,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,65,0,0,0,112,6,2,0,0,0,0,0,147,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,0,0,123,6,2,0,0,0,0,0,148,1,0,0,4,0,4,0,1,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,0,0,137,6,2,0,0,0,0,0,149,1,0,0,1,0,1,0,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,65,0,0,0,149,6,2,0,0,0,0,0,177,1,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,160,6,2,0,0,0,0,0,178,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,65,0,0,1,167,6,2,0,0,0,0,0,179,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,0,0,182,6,2,0,0,0,0,0,47,2,0,0,255,255,255,255,4,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,65,0,0,1,193,6,2,0,0,0,0,0,172,135,0,0,2,0,2,0,4,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,65,0,0,0,208,6,2,0,0,0,0,0,0,0,0,0,139,108,79,64,134,201,196,191,128,72,255,190,126,29,120,191,197,32,240,63,195,100,42,61,211,188,99,61,96,229,80,190,199,75,135,63,0,0,200,66,0,0,200,66,0,0,200,66,255,0,0,0,255,0,0,0,255,0,0,0,0,0,128,63,0,0,128,63,0,0,128,63,154,153,25,64,154,153,25,64,154,153,25,64,0,0,0,0,1,0,0,0,2,0,0,0,135,22,153,62,162,69,22,63,213,120,233,61,0,0,0,0,0,0,0,0,0,0,0,0,101,44,2,0,1,0,0,0,1,0,0,0,106,44,2,0,5,0,0,0,2,0,0,0,110,44,2,0,5,128,0,0,3,0,0,0,119,44,2,0,41,128,0,0,4,0,0,0,131,44,2,0,254,127,0,0,5,0,0,0,136,44,2,0,7,0,0,0,6,0,0,0,141,44,2,0,6,0,0,0,7,0,0,0,156,44,2,0,2,0,0,0,8,0,0,0,166,44,2,0,3,128,0,0,9,0,0,0,178,44,2,0,3,0,0,0,10,0,0,0,192,44,2,0,4,0,0,0,11,0,0,0,206,44,2,0,101,135,0,0,12,0,0,0,215,44,2,0,178,128,0,0,13,0,0,0,223,44,2,0,8,0,0,0,13,0,0,0,236,44,2,0,141,128,0,0,14,0,0,0,245,44,2,0,116,135,0,0,15,0,0,0,252,44,2,0,117,135,0,0,15,0,0,0,5,45,2,0,109,136,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,73,0,0,0,3,50,2,0,0,0,0,0,37,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,73,0,0,0,245,49,2,0,0,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,7,0,0,0,15,0,0,0,31,0,0,0,63,0,0,0,127,0,0,0,255,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,168,52,2,0,0,0,0,0,4,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,51,0,0,0,0,0,0,0,0,0,0,0,176,52,2,0,0,0,0,0,70,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,66,0,1,0,188,52,2,0,0,0,0,0,71,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,67,0,1,0,200,52,2,0,0,0,0,0,72,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,68,0,1,0,213,52,2,0,0,0,0,0,12,7,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,5,6,0,0,2,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,5,7,0,0,3,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,4,6,0,0,2,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,6,7,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,5,6,0,0,2,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,4,7,0,0,3,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,4,6,0,0,2,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,12,11,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,11,0,0,0,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,11,0,0,64,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,64,8,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,64,9,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,192,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+10240);allocate([9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,11,0,0,128,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,192,8,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,192,9,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,12,11,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,11,0,0,0,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,11,0,0,64,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+20480);allocate([9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,128,8,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,128,9,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,0,8,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,11,0,0,128,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,0,9,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+30720);allocate([9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,0,10,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,12,11,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,0,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,23,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,20,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,25,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,128,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,56,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,30,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,64,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,57,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,21,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,54,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,52,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,48,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,64,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,44,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,36,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,128,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,28,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,60,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,40,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,64,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+40960);allocate([8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,192,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,50,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,34,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,128,6,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,26,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,128,5,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,32,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,128,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,61,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,42,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,0,4,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,0,3,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,62,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,192,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,46,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,38,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,0,2,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,19,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,24,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,22,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,192,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,12,11,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,0,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,23,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,20,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,25,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,192,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,0,5,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,31,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+51200);allocate([8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,64,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,58,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,21,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,128,3,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,128,2,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,49,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,128,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,45,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,37,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,192,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,29,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,0,6,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,41,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,128,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,0,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,51,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,35,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,64,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,27,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,59,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,33,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,128,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,0,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,43,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,128,4,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,55,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,63,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+61440);allocate([8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,0,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,47,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,39,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,53,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,19,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,24,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,22,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,0,10,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,12,11,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,0,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,23,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,20,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,25,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,128,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,56,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,30,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,64,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,57,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,21,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,54,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,52,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,48,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,64,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,44,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,36,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,128,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,28,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,60,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,40,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+71680);allocate([8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,64,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,192,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,50,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,34,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,192,6,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,26,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,192,5,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,32,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,128,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,61,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,42,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,64,4,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,64,3,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,62,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,192,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,46,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,38,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,64,2,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,19,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,24,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,22,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,192,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,12,11,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+81920);allocate([8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,0,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,23,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,20,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,25,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,192,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,64,5,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,31,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,64,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,58,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,21,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,192,3,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,192,2,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,49,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,128,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,45,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,37,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,192,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,29,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,64,6,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,41,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,128,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,0,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,51,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,35,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,64,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,27,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,59,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,33,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+92160);allocate([8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,128,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,0,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,43,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,192,4,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,55,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,63,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,0,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,47,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,39,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,53,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,19,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,24,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,22,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,0,10,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,91,1,0,0,253,255,253,255,7,0,0,0,0,0,0,0,40,0,0,0,40,0,0,0,66,0,0,1,140,60,2,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,1,0,39,96,2,0,0,0,0,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,39,96,2,0,0,0,0,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,39,96,2,0,0,0,0,0,95,155,125,62,4,0,0,0,52,161,121,62,6,0,4,0,3,124,119,62,7,0,10,0,62,149,115,62,9,0,17,0,88,145,113,62,10,0,26,0,132,185,109,62,12,0,36,0,27,213,105,62,14,0,48,0,112,176,103,62,15,0,62,0,57,181,99,62,17,0,77,0,41,179,97,62,18,0,94,0,240,220,91,62,21,0,112,0,179,209,89,62,22,0,133,0,63,199,87,62,23,0,155,0,59,229,81,62,26,0,178,0,144,219,79,62,27,0,204,0,226,6,76,62,29,0,231,0,181,55,72,62,31,0,4,1,152,52,70,62,32,0,35,1,97,111,66,62,34,0,67,1,104,175,62,62,36,0,101,1,104,175,62,62,36,0,137,1,102,249,58,62,38,0,173,1,144,76,55,62,40,0,211,1,92,173,51,62,42,0,251,1,8,33,48,62,44,0,37,2,8,33,48,62,44,0,81,2,160,168,44,62,46,0,125,2,160,168,44,62,46,0,171,2,52,128,39,62,49,0,217,2,12,115,34,62,52,0,10,3,12,115,34,62,52,0,62,3,12,115,34,62,52,0,114,3,174,129,29,62,55,0,166,3,174,129,29,62,55,0,221,3,226,172,24,62,58,0,20,4,226,172,24,62,58,0,78,4,2,44,18,62,62,0,136,4,2,44,18,62,62,0,198,4,2,44,18,62,62,0,4,5,167,150,13,62,65,0,66,5,167,150,13,62,65,0,131,5,167,150,13,62,65,0,196,5,134,86,7,62,69,0,5,6,134,86,7,62,69,0,74,6,159,59,1,62,73,0,143,6,159,59,1,62,73,0,216,6,159,59,1,62,73,0,33,7,80,138,246,61,77,0,106,7,80,138,246,61,77,0,183,7,80,138,246,61,77,0,4,8,80,138,246,61,77,0,81,8,159,88,231,61,82,0,158,8,159,88,231,61,82,0,240,8,159,88,231,61,82,0,66,9,191,14,220,61,86,0,148,9,191,14,220,61,86,0,234,9,191,14,220,61,86,0,64,10,191,14,220,61,86,0,150,10,161,128,205,61,91,0,236,10,161,128,205,61,91,0,71,11,161,128,205,61,91,0,162,11,108,209,194,61,95,0,253,11,108,209,194,61,95,0,92,12,108,209,194,61,95,0,187,12,108,209,194,61,95,0,26,13,12,202,180,61,100,0,121,13,12,202,180,61,100,0,221,13,12,202,180,61,100,0,65,14,12,202,180,61,100,0,165,14,136,245,166,61,105,0,9,15,136,245,166,61,105,0,114,15,136,245,166,61,105,0,219,15,136,245,166,61,105,0,68,16,185,80,153,61,110,0,173,16,185,80,153,61,110,0,27,17,185,80,153,61,110,0,137,17,185,80,153,61,110,0,247,17,161,219,139,61,115,0,101,18,161,219,139,61,115,0,216,18,161,219,139,61,115,0,75,19,161,219,139,61,115,0,190,19,144,50,130,61,119,0,49,20,144,50,130,61,119,0,168,20,144,50,130,61,119,0,31,21,144,50,130,61,119,0,150,21,120,94,106,61,124,0,13,22,120,94,106,61,124,0,137,22,120,94,106,61,124,0,5,23,120,94,106,61,124,0,129,23,166,213,80,61,129,0,253,23,166,213,80,61,129,0,126,24,166,213,80,61,129,0,255,24,166,213,80,61,129,0,128,25,166,213,80,61,129,0,1,26,18,190,55,61,134,0,130,26,18,190,55,61,134,0,8,27,18,190,55,61,134,0,142,27,18,190,55,61,134,0,20,28,199,45,38,61,138,0,154,28,199,45,38,61,138,0,36,29,199,45,38,61,138,0,174,29,199,45,38,61,138,0,56,30,52,216,20,61,142,0,194,30,52,216,20,61,142,0,80,31,52,216,20,61,142,0,222,31,52,216,20,61,142,0,108,32,47,164,3,61,146,0,250,32,47,164,3,61,146,0,140,33,47,164,3,61,146,0,30,34,47,164,3,61,146,0,176,34,27,241,228,60,150,0,66,35,27,241,228,60,150,0,216,35,27,241,228,60,150,0,110,36,75,120,194,60,154,0,4,37,75,120,194,60,154,0,158,37,75,120,194,60,154,0,56,38,75,120,194,60,154,0,210,38,218,198,159,60,158,0,108,39,218,198,159,60,158,0,10,40,218,198,159,60,158,0,168,40,65,17,139,60,161,0,70,41,65,17,139,60,161,0,231,41,65,17,139,60,161,0,136,42,65,17,139,60,161,0,41,43,207,19,79,60,165,0,202,43,207,19,79,60,165,0,111,44,207,19,79,60,165,0,20,45,75,177,35,60,168,0,185,45,75,177,35,60,168,0,97,46,75,177,35,60,168,0,9,47,216,183,19,60,170,0,177,47,216,183,19,60,170,0,91,48,216,183,19,60,170,0,5,49,250,183,203,59,173,0,175,49,250,183,203,59,173,0,92,50,188,4,167,59,175,0,9,51,188,4,167,59,175,0,184,51,188,4,167,59,175,0,103,52,18,23,128,59,177,0,22,53,18,23,128,59,177,0,199,53,175,90,25,59,177,0,120,54,197,144,28,59,170,0,41,55,34,252,139,58,164,0,211,55,122,169,216,58,157,0,119,56,14,245,59,58,150,0,20,57,218,140,211,58,143,0,170,57,201,142,141,57,136,0,57,58,97,193,253,57,129,0,193,58,138,146,144,58,123,0,66,59,155,202,162,58,115,0,189,59,170,182,155,58,109,0,48,60,136,131,132,58,103,0,157,60,47,220,57,58,97,0,4,61,137,207,157,57,89,0,101,61,193,85,30,59,82,0,190,61,187,14,85,59,76,0,16,62,216,186,84,59,69,0,92,62,58,177,135,59,62,0,161,62,69,101,195,59,55,0,223,62,116,209,16,60,47,0,22,63,64,222,43,60,40,0,69,63,0,55,139,60,31,0,109,63,133,208,193,60,21,0,140,63,24,0,1,0,0,0,0,0,3,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,1,0,173,64,2,0,0,0,0,0,25,0,1,0,0,0,0,0,3,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,1,0,187,64,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,1,0,1,0,16,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,66,0,1,0,190,81,2,0,0,0,0,0,2,2,0,0,1,0,1,0,16,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,67,0,1,0,212,81,2,0,0,0,0,0,7,2,0,0,253,255,253,255,16,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,68,0,0,1,240,81,2,0,0,0,0,0,8,2,0,0,253,255,253,255,16,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,69,0,0,1,252,81,2,0,0,0,0,0,9,2,0,0,253,255,253,255,16,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,70,0,0,1,9,82,2,0,0,0,0,0,0,2,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,71,0,0,0,22,82,2,0,0,0,0,0,3,2,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,72,0,0,0,31,82,2,0,0,0,0,0,13,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,39,96,2,0,0,0,0,0,22,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,39,96,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,66,0,0,0,166,88,2,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,253,255,255,255,254,255,255,255,255,255,255,255,21,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,1,0,39,96,2,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,4,0,4,0,8,0,4,0,17,0,0,0,4,0,5,0,16,0,8,0,17,0,0,0,4,0,6,0,32,0,32,0,17,0,0,0,4,0,4,0,16,0,16,0,18,0,0,0,8,0,16,0,32,0,32,0,18,0,0,0,8,0,16,0,128,0,128,0,18,0,0,0,8,0,32,0,128,0,0,1,18,0,0,0,32,0,128,0,2,1,0,4,18,0,0,0,32,0,2,1,2,1,0,16,18,0,0,0,48,242,1,0,88,174,1,0,1,1,0,0,30,1,0,0,15,0,0,0,176,246,1,0,64,175,1,0,0,0,0,0,30,0,0,0,15,0,0,0,0,0,0,0,48,176,1,0,0,0,0,0,19,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,10,0,0,0,12,0,0,0,14,0,0,0,16,0,0,0,20,0,0,0,24,0,0,0,28,0,0,0,32,0,0,0,40,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,80,0,0,0,96,0,0,0,112,0,0,0,128,0,0,0,160,0,0,0,192,0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,6,0,0,0,7,0,0,0,7,0,0,0,8,0,0,0,8,0,0,0,9,0,0,0,9,0,0,0,10,0,0,0,10,0,0,0,11,0,0,0,11,0,0,0,12,0,0,0,12,0,0,0,13,0,0,0,13,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,6,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,24,0,0,0,32,0,0,0,48,0,0,0,64,0,0,0,96,0,0,0,128,0,0,0,192,0,0,0,0,1,0,0,128,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,6,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,24,0,0,0,32,0,0,0,48,0,0,0,64,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,7,0,0,0,12,96,2,0,28,96,2,0,39,96,2,0,40,96,2,0,51,96,2,0,64,96,2,0,75,96,2,0,95,96,2,0,108,96,2,0,39,96,2,0,0,0,0,0,150,48,7,119,44,97,14,238,186,81,9,153,25,196,109,7,143,244,106,112,53,165,99,233,163,149,100,158,50,136,219,14,164,184,220,121,30,233,213,224,136,217,210,151,43,76,182,9,189,124,177,126,7,45,184,231,145,29,191,144,100,16,183,29,242,32,176,106,72,113,185,243,222,65,190,132,125,212,218,26,235,228,221,109,81,181,212,244,199,133,211,131,86,152,108,19,192,168,107,100,122,249,98,253,236,201,101,138,79,92,1,20,217,108,6,99,99,61,15,250,245,13,8,141,200,32,110,59,94,16,105,76,228,65,96,213,114,113,103,162,209,228,3,60,71,212,4,75,253,133,13,210,107,181,10,165,250,168,181,53,108,152,178,66,214,201,187,219,64,249,188,172,227,108,216,50,117,92,223,69,207,13,214,220,89,61,209,171,172,48,217,38,58,0,222,81,128,81,215,200,22,97,208,191,181,244,180,33,35,196,179,86,153,149,186,207,15,165,189,184,158,184,2,40,8,136,5,95,178,217,12,198,36,233,11,177,135,124,111,47,17,76,104,88,171,29,97,193,61,45,102,182,144,65,220,118,6,113,219,1,188,32,210,152,42,16,213,239,137,133,177,113,31,181,182,6,165,228,191,159,51,212,184,232,162,201,7,120,52,249,0,15,142,168,9,150,24,152,14,225,187,13,106,127,45,61,109,8,151,108,100,145,1,92,99,230,244,81,107,107,98,97,108,28,216,48,101,133,78,0,98,242,237,149,6,108,123,165,1,27,193,244,8,130,87,196,15,245,198,217,176,101,80,233,183,18,234,184,190,139,124,136,185,252,223,29,221,98,73,45,218,21,243,124,211,140,101,76,212,251,88,97,178,77,206,81,181,58,116,0,188,163,226,48,187,212,65,165,223,74,215,149,216,61,109,196,209,164,251,244,214,211,106,233,105,67,252,217,110,52,70,136,103,173,208,184,96,218,115,45,4,68,229,29,3,51,95,76,10,170,201,124,13,221,60,113,5,80,170,65,2,39,16,16,11,190,134,32,12,201,37,181,104,87,179,133,111,32,9,212,102,185,159,228,97,206,14,249,222,94,152,201,217,41,34,152,208,176,180,168,215,199,23,61,179,89,129,13,180,46,59,92,189,183,173,108,186,192,32,131,184,237,182,179,191,154,12,226,182,3,154,210,177,116,57,71,213,234,175,119,210,157,21,38,219,4,131,22,220,115,18,11,99,227,132,59,100,148,62,106,109,13,168,90,106,122,11,207,14,228,157,255,9,147,39,174,0,10,177,158,7,125,68,147,15,240,210,163,8,135,104,242,1,30,254,194,6,105,93,87,98,247,203,103,101,128,113,54,108,25,231,6,107,110,118,27,212,254,224,43,211,137,90,122,218,16,204,74,221,103,111,223,185,249,249,239,190,142,67,190,183,23,213,142,176,96,232,163,214,214,126,147,209,161,196,194,216,56,82,242,223,79,241,103,187,209,103,87,188,166,221,6,181,63,75,54,178,72,218,43,13,216,76,27,10,175,246,74,3,54,96,122,4,65,195,239,96,223,85,223,103,168,239,142,110,49,121,190,105,70,140,179,97,203,26,131,102,188,160,210,111,37,54,226,104,82,149,119,12,204,3,71,11,187,185,22,2,34,47,38,5,85,190,59,186,197,40,11,189,178,146,90,180,43,4,106,179,92,167,255,215,194,49,207,208,181,139,158,217,44,29,174,222,91,176,194,100,155,38,242,99,236,156,163,106,117,10,147,109,2,169,6,9,156,63,54,14,235,133,103,7,114,19,87,0,5,130,74,191,149,20,122,184,226,174,43,177,123,56,27,182,12,155,142,210,146,13,190,213,229,183,239,220,124,33,223,219,11,212,210,211,134,66,226,212,241,248,179,221,104,110,131,218,31,205,22,190,129,91,38,185,246,225,119,176,111,119,71,183,24,230,90,8,136,112,106,15,255,202,59,6,102,92,11,1,17,255,158,101,143,105,174,98,248,211,255,107,97,69,207,108,22,120,226,10,160,238,210,13,215,84,131,4,78,194,179,3,57,97,38,103,167,247,22,96,208,77,71,105,73,219,119,110,62,74,106,209,174,220,90,214,217,102,11,223,64,240,59,216,55,83,174,188,169,197,158,187,222,127,207,178,71,233,255,181,48,28,242,189,189,138,194,186,202,48,147,179,83,166,163,180,36,5,54,208,186,147,6,215,205,41,87,222,84,191,103,217,35,46,122,102,179,184,74,97,196,2,27,104,93,148,43,111,42,55,190,11,180,161,142,12,195,27,223,5,90,141,239,2,45,0,0,0,0,65,49,27,25,130,98,54,50,195,83,45,43,4,197,108,100,69,244,119,125,134,167,90,86,199,150,65,79,8,138,217,200,73,187,194,209,138,232,239,250,203,217,244,227,12,79,181,172,77,126,174,181,142,45,131,158,207,28,152,135,81,18,194,74,16,35,217,83,211,112,244,120,146,65,239,97,85,215,174,46,20,230,181,55,215,181,152,28,150,132,131,5,89,152,27,130,24,169,0,155,219,250,45,176,154,203,54,169,93,93,119,230,28,108,108,255,223,63,65,212,158,14,90,205,162,36,132,149,227,21,159,140,32,70,178,167,97,119,169,190,166,225,232,241,231,208,243,232,36,131,222,195,101,178,197,218,170,174,93,93,235,159,70,68,40,204,107,111,105,253,112,118,174,107,49,57,239,90,42,32,44,9,7,11,109,56,28,18,243,54,70,223,178,7,93,198,113,84,112,237,48,101,107,244,247,243,42,187,182,194,49,162,117,145,28,137,52,160,7,144,251,188,159,23,186,141,132,14,121,222,169,37,56,239,178,60,255,121,243,115,190,72,232,106,125,27,197,65,60,42,222,88,5,79,121,240,68,126,98,233,135,45,79,194,198,28,84,219,1,138,21,148,64,187,14,141,131,232,35,166,194,217,56,191,13,197,160,56,76,244,187,33,143,167,150,10,206,150,141,19,9,0,204,92,72,49,215,69,139,98,250,110,202,83,225,119,84,93,187,186,21,108,160,163,214,63,141,136,151,14,150,145,80,152,215,222,17,169,204,199,210,250,225,236,147,203,250,245,92,215,98,114,29,230,121,107,222,181,84,64,159,132,79,89,88,18,14,22,25,35,21,15,218,112,56,36,155,65,35,61,167,107,253,101,230,90,230,124,37,9,203,87,100,56,208,78,163,174,145,1,226,159,138,24,33,204,167,51,96,253,188,42,175,225,36,173,238,208,63,180,45,131,18,159,108,178,9,134,171,36,72,201,234,21,83,208,41,70,126,251,104,119,101,226,246,121,63,47,183,72,36,54,116,27,9,29,53,42,18,4,242,188,83,75,179,141,72,82,112,222,101,121,49,239,126,96,254,243,230,231,191,194,253,254,124,145,208,213,61,160,203,204,250,54,138,131,187,7,145,154,120,84,188,177,57,101,167,168,75,152,131,59,10,169,152,34,201,250,181,9,136,203,174,16,79,93,239,95,14,108,244,70,205,63,217,109,140,14,194,116,67,18,90,243,2,35,65,234,193,112,108,193,128,65,119,216,71,215,54,151,6,230,45,142,197,181,0,165,132,132,27,188,26,138,65,113,91,187,90,104,152,232,119,67,217,217,108,90,30,79,45,21,95,126,54,12,156,45,27,39,221,28,0,62,18,0,152,185,83,49,131,160,144,98,174,139,209,83,181,146,22,197,244,221,87,244,239,196,148,167,194,239,213,150,217,246,233,188,7,174,168,141,28,183,107,222,49,156,42,239,42,133,237,121,107,202,172,72,112,211,111,27,93,248,46,42,70,225,225,54,222,102,160,7,197,127,99,84,232,84,34,101,243,77,229,243,178,2,164,194,169,27,103,145,132,48,38,160,159,41,184,174,197,228,249,159,222,253,58,204,243,214,123,253,232,207,188,107,169,128,253,90,178,153,62,9,159,178,127,56,132,171,176,36,28,44,241,21,7,53,50,70,42,30,115,119,49,7,180,225,112,72,245,208,107,81,54,131,70,122,119,178,93,99,78,215,250,203,15,230,225,210,204,181,204,249,141,132,215,224,74,18,150,175,11,35,141,182,200,112,160,157,137,65,187,132,70,93,35,3,7,108,56,26,196,63,21,49,133,14,14,40,66,152,79,103,3,169,84,126,192,250,121,85,129,203,98,76,31,197,56,129,94,244,35,152,157,167,14,179,220,150,21,170,27,0,84,229,90,49,79,252,153,98,98,215,216,83,121,206,23,79,225,73],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+102400);allocate([86,126,250,80,149,45,215,123,212,28,204,98,19,138,141,45,82,187,150,52,145,232,187,31,208,217,160,6,236,243,126,94,173,194,101,71,110,145,72,108,47,160,83,117,232,54,18,58,169,7,9,35,106,84,36,8,43,101,63,17,228,121,167,150,165,72,188,143,102,27,145,164,39,42,138,189,224,188,203,242,161,141,208,235,98,222,253,192,35,239,230,217,189,225,188,20,252,208,167,13,63,131,138,38,126,178,145,63,185,36,208,112,248,21,203,105,59,70,230,66,122,119,253,91,181,107,101,220,244,90,126,197,55,9,83,238,118,56,72,247,177,174,9,184,240,159,18,161,51,204,63,138,114,253,36,147,0,0,0,0,55,106,194,1,110,212,132,3,89,190,70,2,220,168,9,7,235,194,203,6,178,124,141,4,133,22,79,5,184,81,19,14,143,59,209,15,214,133,151,13,225,239,85,12,100,249,26,9,83,147,216,8,10,45,158,10,61,71,92,11,112,163,38,28,71,201,228,29,30,119,162,31,41,29,96,30,172,11,47,27,155,97,237,26,194,223,171,24,245,181,105,25,200,242,53,18,255,152,247,19,166,38,177,17,145,76,115,16,20,90,60,21,35,48,254,20,122,142,184,22,77,228,122,23,224,70,77,56,215,44,143,57,142,146,201,59,185,248,11,58,60,238,68,63,11,132,134,62,82,58,192,60,101,80,2,61,88,23,94,54,111,125,156,55,54,195,218,53,1,169,24,52,132,191,87,49,179,213,149,48,234,107,211,50,221,1,17,51,144,229,107,36,167,143,169,37,254,49,239,39,201,91,45,38,76,77,98,35,123,39,160,34,34,153,230,32,21,243,36,33,40,180,120,42,31,222,186,43,70,96,252,41,113,10,62,40,244,28,113,45,195,118,179,44,154,200,245,46,173,162,55,47,192,141,154,112,247,231,88,113,174,89,30,115,153,51,220,114,28,37,147,119,43,79,81,118,114,241,23,116,69,155,213,117,120,220,137,126,79,182,75,127,22,8,13,125,33,98,207,124,164,116,128,121,147,30,66,120,202,160,4,122,253,202,198,123,176,46,188,108,135,68,126,109,222,250,56,111,233,144,250,110,108,134,181,107,91,236,119,106,2,82,49,104,53,56,243,105,8,127,175,98,63,21,109,99,102,171,43,97,81,193,233,96,212,215,166,101,227,189,100,100,186,3,34,102,141,105,224,103,32,203,215,72,23,161,21,73,78,31,83,75,121,117,145,74,252,99,222,79,203,9,28,78,146,183,90,76,165,221,152,77,152,154,196,70,175,240,6,71,246,78,64,69,193,36,130,68,68,50,205,65,115,88,15,64,42,230,73,66,29,140,139,67,80,104,241,84,103,2,51,85,62,188,117,87,9,214,183,86,140,192,248,83,187,170,58,82,226,20,124,80,213,126,190,81,232,57,226,90,223,83,32,91,134,237,102,89,177,135,164,88,52,145,235,93,3,251,41,92,90,69,111,94,109,47,173,95,128,27,53,225,183,113,247,224,238,207,177,226,217,165,115,227,92,179,60,230,107,217,254,231,50,103,184,229,5,13,122,228,56,74,38,239,15,32,228,238,86,158,162,236,97,244,96,237,228,226,47,232,211,136,237,233,138,54,171,235,189,92,105,234,240,184,19,253,199,210,209,252,158,108,151,254,169,6,85,255,44,16,26,250,27,122,216,251,66,196,158,249,117,174,92,248,72,233,0,243,127,131,194,242,38,61,132,240,17,87,70,241,148,65,9,244,163,43,203,245,250,149,141,247,205,255,79,246,96,93,120,217,87,55,186,216,14,137,252,218,57,227,62,219,188,245,113,222,139,159,179,223,210,33,245,221,229,75,55,220,216,12,107,215,239,102,169,214,182,216,239,212,129,178,45,213,4,164,98,208,51,206,160,209,106,112,230,211,93,26,36,210,16,254,94,197,39,148,156,196,126,42,218,198,73,64,24,199,204,86,87,194,251,60,149,195,162,130,211,193,149,232,17,192,168,175,77,203,159,197,143,202,198,123,201,200,241,17,11,201,116,7,68,204,67,109,134,205,26,211,192,207,45,185,2,206,64,150,175,145,119,252,109,144,46,66,43,146,25,40,233,147,156,62,166,150,171,84,100,151,242,234,34,149,197,128,224,148,248,199,188,159,207,173,126,158,150,19,56,156,161,121,250,157,36,111,181,152,19,5,119,153,74,187,49,155,125,209,243,154,48,53,137,141,7,95,75,140,94,225,13,142,105,139,207,143,236,157,128,138,219,247,66,139,130,73,4,137,181,35,198,136,136,100,154,131,191,14,88,130,230,176,30,128,209,218,220,129,84,204,147,132,99,166,81,133,58,24,23,135,13,114,213,134,160,208,226,169,151,186,32,168,206,4,102,170,249,110,164,171,124,120,235,174,75,18,41,175,18,172,111,173,37,198,173,172,24,129,241,167,47,235,51,166,118,85,117,164,65,63,183,165,196,41,248,160,243,67,58,161,170,253,124,163,157,151,190,162,208,115,196,181,231,25,6,180,190,167,64,182,137,205,130,183,12,219,205,178,59,177,15,179,98,15,73,177,85,101,139,176,104,34,215,187,95,72,21,186,6,246,83,184,49,156,145,185,180,138,222,188,131,224,28,189,218,94,90,191,237,52,152,190,0,0,0,0,101,103,188,184,139,200,9,170,238,175,181,18,87,151,98,143,50,240,222,55,220,95,107,37,185,56,215,157,239,40,180,197,138,79,8,125,100,224,189,111,1,135,1,215,184,191,214,74,221,216,106,242,51,119,223,224,86,16,99,88,159,87,25,80,250,48,165,232,20,159,16,250,113,248,172,66,200,192,123,223,173,167,199,103,67,8,114,117,38,111,206,205,112,127,173,149,21,24,17,45,251,183,164,63,158,208,24,135,39,232,207,26,66,143,115,162,172,32,198,176,201,71,122,8,62,175,50,160,91,200,142,24,181,103,59,10,208,0,135,178,105,56,80,47,12,95,236,151,226,240,89,133,135,151,229,61,209,135,134,101,180,224,58,221,90,79,143,207,63,40,51,119,134,16,228,234,227,119,88,82,13,216,237,64,104,191,81,248,161,248,43,240,196,159,151,72,42,48,34,90,79,87,158,226,246,111,73,127,147,8,245,199,125,167,64,213,24,192,252,109,78,208,159,53,43,183,35,141,197,24,150,159,160,127,42,39,25,71,253,186,124,32,65,2,146,143,244,16,247,232,72,168,61,88,20,155,88,63,168,35,182,144,29,49,211,247,161,137,106,207,118,20,15,168,202,172,225,7,127,190,132,96,195,6,210,112,160,94,183,23,28,230,89,184,169,244,60,223,21,76,133,231,194,209,224,128,126,105,14,47,203,123,107,72,119,195,162,15,13,203,199,104,177,115,41,199,4,97,76,160,184,217,245,152,111,68,144,255,211,252,126,80,102,238,27,55,218,86,77,39,185,14,40,64,5,182,198,239,176,164,163,136,12,28,26,176,219,129,127,215,103,57,145,120,210,43,244,31,110,147,3,247,38,59,102,144,154,131,136,63,47,145,237,88,147,41,84,96,68,180,49,7,248,12,223,168,77,30,186,207,241,166,236,223,146,254,137,184,46,70,103,23,155,84,2,112,39,236,187,72,240,113,222,47,76,201,48,128,249,219,85,231,69,99,156,160,63,107,249,199,131,211,23,104,54,193,114,15,138,121,203,55,93,228,174,80,225,92,64,255,84,78,37,152,232,246,115,136,139,174,22,239,55,22,248,64,130,4,157,39,62,188,36,31,233,33,65,120,85,153,175,215,224,139,202,176,92,51,59,182,89,237,94,209,229,85,176,126,80,71,213,25,236,255,108,33,59,98,9,70,135,218,231,233,50,200,130,142,142,112,212,158,237,40,177,249,81,144,95,86,228,130,58,49,88,58,131,9,143,167,230,110,51,31,8,193,134,13,109,166,58,181,164,225,64,189,193,134,252,5,47,41,73,23,74,78,245,175,243,118,34,50,150,17,158,138,120,190,43,152,29,217,151,32,75,201,244,120,46,174,72,192,192,1,253,210,165,102,65,106,28,94,150,247,121,57,42,79,151,150,159,93,242,241,35,229,5,25,107,77,96,126,215,245,142,209,98,231,235,182,222,95,82,142,9,194,55,233,181,122,217,70,0,104,188,33,188,208,234,49,223,136,143,86,99,48,97,249,214,34,4,158,106,154,189,166,189,7,216,193,1,191,54,110,180,173,83,9,8,21,154,78,114,29,255,41,206,165,17,134,123,183,116,225,199,15,205,217,16,146,168,190,172,42,70,17,25,56,35,118,165,128,117,102,198,216,16,1,122,96,254,174,207,114,155,201,115,202,34,241,164,87,71,150,24,239,169,57,173,253,204,94,17,69,6,238,77,118,99,137,241,206,141,38,68,220,232,65,248,100,81,121,47,249,52,30,147,65,218,177,38,83,191,214,154,235,233,198,249,179,140,161,69,11,98,14,240,25,7,105,76,161,190,81,155,60,219,54,39,132,53,153,146,150,80,254,46,46,153,185,84,38,252,222,232,158,18,113,93,140,119,22,225,52,206,46,54,169,171,73,138,17,69,230,63,3,32,129,131,187,118,145,224,227,19,246,92,91,253,89,233,73,152,62,85,241,33,6,130,108,68,97,62,212,170,206,139,198,207,169,55,126,56,65,127,214,93,38,195,110,179,137,118,124,214,238,202,196,111,214,29,89,10,177,161,225,228,30,20,243,129,121,168,75,215,105,203,19,178,14,119,171,92,161,194,185,57,198,126,1,128,254,169,156,229,153,21,36,11,54,160,54,110,81,28,142,167,22,102,134,194,113,218,62,44,222,111,44,73,185,211,148,240,129,4,9,149,230,184,177,123,73,13,163,30,46,177,27,72,62,210,67,45,89,110,251,195,246,219,233,166,145,103,81,31,169,176,204,122,206,12,116,148,97,185,102,241,6,5,222,0,0,0,0,119,7,48,150,238,14,97,44,153,9,81,186,7,109,196,25,112,106,244,143,233,99,165,53,158,100,149,163,14,219,136,50,121,220,184,164,224,213,233,30,151,210,217,136,9,182,76,43,126,177,124,189,231,184,45,7,144,191,29,145,29,183,16,100,106,176,32,242,243,185,113,72,132,190,65,222,26,218,212,125,109,221,228,235,244,212,181,81,131,211,133,199,19,108,152,86,100,107,168,192,253,98,249,122,138,101,201,236,20,1,92,79,99,6,108,217,250,15,61,99,141,8,13,245,59,110,32,200,76,105,16,94,213,96,65,228,162,103,113,114,60,3,228,209,75,4,212,71,210,13,133,253,165,10,181,107,53,181,168,250,66,178,152,108,219,187,201,214,172,188,249,64,50,216,108,227,69,223,92,117,220,214,13,207,171,209,61,89,38,217,48,172,81,222,0,58,200,215,81,128,191,208,97,22,33,180,244,181,86,179,196,35,207,186,149,153,184,189,165,15,40,2,184,158,95,5,136,8,198,12,217,178,177,11,233,36,47,111,124,135,88,104,76,17,193,97,29,171,182,102,45,61,118,220,65,144,1,219,113,6,152,210,32,188,239,213,16,42,113,177,133,137,6,182,181,31,159,191,228,165,232,184,212,51,120,7,201,162,15,0,249,52,150,9,168,142,225,14,152,24,127,106,13,187,8,109,61,45,145,100,108,151,230,99,92,1,107,107,81,244,28,108,97,98,133,101,48,216,242,98,0,78,108,6,149,237,27,1,165,123,130,8,244,193,245,15,196,87,101,176,217,198,18,183,233,80,139,190,184,234,252,185,136,124,98,221,29,223,21,218,45,73,140,211,124,243,251,212,76,101,77,178,97,88,58,181,81,206,163,188,0,116,212,187,48,226,74,223,165,65,61,216,149,215,164,209,196,109,211,214,244,251,67,105,233,106,52,110,217,252,173,103,136,70,218,96,184,208,68,4,45,115,51,3,29,229,170,10,76,95,221,13,124,201,80,5,113,60,39,2,65,170,190,11,16,16,201,12,32,134,87,104,181,37,32,111,133,179,185,102,212,9,206,97,228,159,94,222,249,14,41,217,201,152,176,208,152,34,199,215,168,180,89,179,61,23,46,180,13,129,183,189,92,59,192,186,108,173,237,184,131,32,154,191,179,182,3,182,226,12,116,177,210,154,234,213,71,57,157,210,119,175,4,219,38,21,115,220,22,131,227,99,11,18,148,100,59,132,13,109,106,62,122,106,90,168,228,14,207,11,147,9,255,157,10,0,174,39,125,7,158,177,240,15,147,68,135,8,163,210,30,1,242,104,105,6,194,254,247,98,87,93,128,101,103,203,25,108,54,113,110,107,6,231,254,212,27,118,137,211,43,224,16,218,122,90,103,221,74,204,249,185,223,111,142,190,239,249,23,183,190,67,96,176,142,213,214,214,163,232,161,209,147,126,56,216,194,196,79,223,242,82,209,187,103,241,166,188,87,103,63,181,6,221,72,178,54,75,216,13,43,218,175,10,27,76,54,3,74,246,65,4,122,96,223,96,239,195,168,103,223,85,49,110,142,239,70,105,190,121,203,97,179,140,188,102,131,26,37,111,210,160,82,104,226,54,204,12,119,149,187,11,71,3,34,2,22,185,85,5,38,47,197,186,59,190,178,189,11,40,43,180,90,146,92,179,106,4,194,215,255,167,181,208,207,49,44,217,158,139,91,222,174,29,155,100,194,176,236,99,242,38,117,106,163,156,2,109,147,10,156,9,6,169,235,14,54,63,114,7,103,133,5,0,87,19,149,191,74,130,226,184,122,20,123,177,43,174,12,182,27,56,146,210,142,155,229,213,190,13,124,220,239,183,11,219,223,33,134,211,210,212,241,212,226,66,104,221,179,248,31,218,131,110,129,190,22,205,246,185,38,91,111,176,119,225,24,183,71,119,136,8,90,230,255,15,106,112,102,6,59,202,17,1,11,92,143,101,158,255,248,98,174,105,97,107,255,211,22,108,207,69,160,10,226,120,215,13,210,238,78,4,131,84,57,3,179,194,167,103,38,97,208,96,22,247,73,105,71,77,62,110,119,219,174,209,106,74,217,214,90,220,64,223,11,102,55,216,59,240,169,188,174,83,222,187,158,197,71,178,207,127,48,181,255,233,189,189,242,28,202,186,194,138,83,179,147,48,36,180,163,166,186,208,54,5,205,215,6,147,84,222,87,41,35,217,103,191,179,102,122,46,196,97,74,184,93,104,27,2,42,111,43,148,180,11,190,55,195,12,142,161,90,5,223,27,45,2,239,141,0,0,0,0,25,27,49,65,50,54,98,130,43,45,83,195,100,108,197,4,125,119,244,69,86,90,167,134,79,65,150,199,200,217,138,8,209,194,187,73,250,239,232,138,227,244,217,203,172,181,79,12,181,174,126,77,158,131,45,142,135,152,28,207,74,194,18,81,83,217,35,16,120,244,112,211,97,239,65,146,46,174,215,85,55,181,230,20,28,152,181,215,5,131,132,150,130,27,152,89,155,0,169,24,176,45,250,219,169,54,203,154,230,119,93,93,255,108,108,28,212,65,63,223,205,90,14,158,149,132,36,162,140,159,21,227,167,178,70,32,190,169,119,97,241,232,225,166,232,243,208,231,195,222,131,36,218,197,178,101,93,93,174,170,68,70,159,235,111,107,204,40,118,112,253,105,57,49,107,174,32,42,90,239,11,7,9,44,18,28,56,109,223,70,54,243,198,93,7,178,237,112,84,113,244,107,101,48,187,42,243,247,162,49,194,182,137,28,145,117,144,7,160,52,23,159,188,251,14,132,141,186,37,169,222,121,60,178,239,56,115,243,121,255,106,232,72,190,65,197,27,125,88,222,42,60,240,121,79,5,233,98,126,68,194,79,45,135,219,84,28,198,148,21,138,1,141,14,187,64,166,35,232,131,191,56,217,194,56,160,197,13,33,187,244,76,10,150,167,143,19,141,150,206,92,204,0,9,69,215,49,72,110,250,98,139,119,225,83,202,186,187,93,84,163,160,108,21,136,141,63,214,145,150,14,151,222,215,152,80,199,204,169,17,236,225,250,210,245,250,203,147,114,98,215,92,107,121,230,29,64,84,181,222,89,79,132,159,22,14,18,88,15,21,35,25,36,56,112,218,61,35,65,155,101,253,107,167,124,230,90,230,87,203,9,37,78,208,56,100,1,145,174,163,24,138,159,226,51,167,204,33,42,188,253,96,173,36,225,175,180,63,208,238,159,18,131,45,134,9,178,108,201,72,36,171,208,83,21,234,251,126,70,41,226,101,119,104,47,63,121,246,54,36,72,183,29,9,27,116,4,18,42,53,75,83,188,242,82,72,141,179,121,101,222,112,96,126,239,49,231,230,243,254,254,253,194,191,213,208,145,124,204,203,160,61,131,138,54,250,154,145,7,187,177,188,84,120,168,167,101,57,59,131,152,75,34,152,169,10,9,181,250,201,16,174,203,136,95,239,93,79,70,244,108,14,109,217,63,205,116,194,14,140,243,90,18,67,234,65,35,2,193,108,112,193,216,119,65,128,151,54,215,71,142,45,230,6,165,0,181,197,188,27,132,132,113,65,138,26,104,90,187,91,67,119,232,152,90,108,217,217,21,45,79,30,12,54,126,95,39,27,45,156,62,0,28,221,185,152,0,18,160,131,49,83,139,174,98,144,146,181,83,209,221,244,197,22,196,239,244,87,239,194,167,148,246,217,150,213,174,7,188,233,183,28,141,168,156,49,222,107,133,42,239,42,202,107,121,237,211,112,72,172,248,93,27,111,225,70,42,46,102,222,54,225,127,197,7,160,84,232,84,99,77,243,101,34,2,178,243,229,27,169,194,164,48,132,145,103,41,159,160,38,228,197,174,184,253,222,159,249,214,243,204,58,207,232,253,123,128,169,107,188,153,178,90,253,178,159,9,62,171,132,56,127,44,28,36,176,53,7,21,241,30,42,70,50,7,49,119,115,72,112,225,180,81,107,208,245,122,70,131,54,99,93,178,119,203,250,215,78,210,225,230,15,249,204,181,204,224,215,132,141,175,150,18,74,182,141,35,11,157,160,112,200,132,187,65,137,3,35,93,70,26,56,108,7,49,21,63,196,40,14,14,133,103,79,152,66,126,84,169,3,85,121,250,192,76,98,203,129,129,56,197,31,152,35,244,94,179,14,167,157,170,21,150,220,229,84,0,27,252,79,49,90,215,98,98,153,206,121,83,216,73,225,79,23,80,250,126,86,123,215,45,149,98,204,28,212,45,141,138,19,52,150,187,82,31,187,232,145,6,160,217,208,94,126,243,236,71,101,194,173,108,72,145,110,117,83,160,47,58,18,54,232,35,9,7,169,8,36,84,106,17,63,101,43,150,167,121,228,143,188,72,165,164,145,27,102,189,138,42,39,242,203,188,224,235,208,141,161,192,253,222,98,217,230,239,35,20,188,225,189,13,167,208,252,38,138,131,63,63,145,178,126,112,208,36,185,105,203,21,248,66,230,70,59,91,253,119,122,220,101,107,181,197,126,90,244,238,83,9,55,247,72,56,118,184,9,174,177,161,18,159,240,138,63,204,51,147,36,253,114,0,0,0,0,1,194,106,55,3,132,212,110,2,70,190,89,7,9,168,220,6,203,194,235,4,141,124,178,5,79,22,133,14,19,81,184,15,209,59,143,13,151,133,214,12,85,239,225,9,26,249,100,8,216,147,83,10,158,45,10,11,92,71,61,28,38,163,112,29,228,201,71,31,162,119,30,30,96,29,41,27,47,11,172,26,237,97,155,24,171,223,194,25,105,181,245,18,53,242,200,19,247,152,255,17,177,38,166,16,115,76,145,21,60,90,20,20,254,48,35,22,184,142,122,23,122,228,77,56,77,70,224,57,143,44,215,59,201,146,142,58,11,248,185,63,68,238,60,62,134,132,11,60,192,58,82,61,2,80,101,54,94,23,88,55,156,125,111,53,218,195,54,52,24,169,1,49,87,191,132,48,149,213,179,50,211,107,234,51,17,1,221,36,107,229,144,37,169,143,167,39,239,49,254,38,45,91,201,35,98,77,76,34,160,39,123,32,230,153,34,33,36,243,21,42,120,180,40,43,186,222,31,41,252,96,70,40,62,10,113,45,113,28,244,44,179,118,195,46,245,200,154,47,55,162,173,112,154,141,192,113,88,231,247,115,30,89,174,114,220,51,153,119,147,37,28,118,81,79,43,116,23,241,114,117,213,155,69,126,137,220,120,127,75,182,79,125,13,8,22,124,207,98,33,121,128,116,164,120,66,30,147,122,4,160,202,123,198,202,253,108,188,46,176,109,126,68,135,111,56,250,222,110,250,144,233,107,181,134,108,106,119,236,91,104,49,82,2,105,243,56,53,98,175,127,8,99,109,21,63,97,43,171,102,96,233,193,81,101,166,215,212,100,100,189,227,102,34,3,186,103,224,105,141,72,215,203,32,73,21,161,23,75,83,31,78,74,145,117,121,79,222,99,252,78,28,9,203,76,90,183,146,77,152,221,165,70,196,154,152,71,6,240,175,69,64,78,246,68,130,36,193,65,205,50,68,64,15,88,115,66,73,230,42,67,139,140,29,84,241,104,80,85,51,2,103,87,117,188,62,86,183,214,9,83,248,192,140,82,58,170,187,80,124,20,226,81,190,126,213,90,226,57,232,91,32,83,223,89,102,237,134,88,164,135,177,93,235,145,52,92,41,251,3,94,111,69,90,95,173,47,109,225,53,27,128,224,247,113,183,226,177,207,238,227,115,165,217,230,60,179,92,231,254,217,107,229,184,103,50,228,122,13,5,239,38,74,56,238,228,32,15,236,162,158,86,237,96,244,97,232,47,226,228,233,237,136,211,235,171,54,138,234,105,92,189,253,19,184,240,252,209,210,199,254,151,108,158,255,85,6,169,250,26,16,44,251,216,122,27,249,158,196,66,248,92,174,117,243,0,233,72,242,194,131,127,240,132,61,38,241,70,87,17,244,9,65,148,245,203,43,163,247,141,149,250,246,79,255,205,217,120,93,96,216,186,55,87,218,252,137,14,219,62,227,57,222,113,245,188,223,179,159,139,221,245,33,210,220,55,75,229,215,107,12,216,214,169,102,239,212,239,216,182,213,45,178,129,208,98,164,4,209,160,206,51,211,230,112,106,210,36,26,93,197,94,254,16,196,156,148,39,198,218,42,126,199,24,64,73,194,87,86,204,195,149,60,251,193,211,130,162,192,17,232,149,203,77,175,168,202,143,197,159,200,201,123,198,201,11,17,241,204,68,7,116,205,134,109,67,207,192,211,26,206,2,185,45,145,175,150,64,144,109,252,119,146,43,66,46,147,233,40,25,150,166,62,156,151,100,84,171,149,34,234,242,148,224,128,197,159,188,199,248,158,126,173,207,156,56,19,150,157,250,121,161,152,181,111,36,153,119,5,19,155,49,187,74,154,243,209,125,141,137,53,48,140,75,95,7,142,13,225,94,143,207,139,105,138,128,157,236,139,66,247,219,137,4,73,130,136,198,35,181,131,154,100,136,130,88,14,191,128,30,176,230,129,220,218,209,132,147,204,84,133,81,166,99,135,23,24,58,134,213,114,13,169,226,208,160,168,32,186,151,170,102,4,206,171,164,110,249,174,235,120,124,175,41,18,75,173,111,172,18,172,173,198,37,167,241,129,24,166,51,235,47,164,117,85,118,165,183,63,65,160,248,41,196,161,58,67,243,163,124,253,170,162,190,151,157,181,196,115,208,180,6,25,231,182,64,167,190,183,130,205,137,178,205,219,12,179,15,177,59,177,73,15,98,176,139,101,85,187,215,34,104,186,21,72,95,184,83,246,6,185,145,156,49,188,222,138,180,189,28,224,131,191,90,94,218,190,152,52,237,0,0,0,0,184,188,103,101,170,9,200,139,18,181,175,238,143,98,151,87,55,222,240,50,37,107,95,220,157,215,56,185,197,180,40,239,125,8,79,138,111,189,224,100,215,1,135,1,74,214,191,184,242,106,216,221,224,223,119,51,88,99,16,86,80,25,87,159,232,165,48,250,250,16,159,20,66,172,248,113,223,123,192,200,103,199,167,173,117,114,8,67,205,206,111,38,149,173,127,112,45,17,24,21,63,164,183,251,135,24,208,158,26,207,232,39,162,115,143,66,176,198,32,172,8,122,71,201,160,50,175,62,24,142,200,91,10,59,103,181,178,135,0,208,47,80,56,105,151,236,95,12,133,89,240,226,61,229,151,135,101,134,135,209,221,58,224,180,207,143,79,90,119,51,40,63,234,228,16,134,82,88,119,227,64,237,216,13,248,81,191,104,240,43,248,161,72,151,159,196,90,34,48,42,226,158,87,79,127,73,111,246,199,245,8,147,213,64,167,125,109,252,192,24,53,159,208,78,141,35,183,43,159,150,24,197,39,42,127,160,186,253,71,25,2,65,32,124,16,244,143,146,168,72,232,247,155,20,88,61,35,168,63,88,49,29,144,182,137,161,247,211,20,118,207,106,172,202,168,15,190,127,7,225,6,195,96,132,94,160,112,210,230,28,23,183,244,169,184,89,76,21,223,60,209,194,231,133,105,126,128,224,123,203,47,14,195,119,72,107,203,13,15,162,115,177,104,199,97,4,199,41,217,184,160,76,68,111,152,245,252,211,255,144,238,102,80,126,86,218,55,27,14,185,39,77,182,5,64,40,164,176,239,198,28,12,136,163,129,219,176,26,57,103,215,127,43,210,120,145,147,110,31,244,59,38,247,3,131,154,144,102,145,47,63,136,41,147,88,237,180,68,96,84,12,248,7,49,30,77,168,223,166,241,207,186,254,146,223,236,70,46,184,137,84,155,23,103,236,39,112,2,113,240,72,187,201,76,47,222,219,249,128,48,99,69,231,85,107,63,160,156,211,131,199,249,193,54,104,23,121,138,15,114,228,93,55,203,92,225,80,174,78,84,255,64,246,232,152,37,174,139,136,115,22,55,239,22,4,130,64,248,188,62,39,157,33,233,31,36,153,85,120,65,139,224,215,175,51,92,176,202,237,89,182,59,85,229,209,94,71,80,126,176,255,236,25,213,98,59,33,108,218,135,70,9,200,50,233,231,112,142,142,130,40,237,158,212,144,81,249,177,130,228,86,95,58,88,49,58,167,143,9,131,31,51,110,230,13,134,193,8,181,58,166,109,189,64,225,164,5,252,134,193,23,73,41,47,175,245,78,74,50,34,118,243,138,158,17,150,152,43,190,120,32,151,217,29,120,244,201,75,192,72,174,46,210,253,1,192,106,65,102,165,247,150,94,28,79,42,57,121,93,159,150,151,229,35,241,242,77,107,25,5,245,215,126,96,231,98,209,142,95,222,182,235,194,9,142,82,122,181,233,55,104,0,70,217,208,188,33,188,136,223,49,234,48,99,86,143,34,214,249,97,154,106,158,4,7,189,166,189,191,1,193,216,173,180,110,54,21,8,9,83,29,114,78,154,165,206,41,255,183,123,134,17,15,199,225,116,146,16,217,205,42,172,190,168,56,25,17,70,128,165,118,35,216,198,102,117,96,122,1,16,114,207,174,254,202,115,201,155,87,164,241,34,239,24,150,71,253,173,57,169,69,17,94,204,118,77,238,6,206,241,137,99,220,68,38,141,100,248,65,232,249,47,121,81,65,147,30,52,83,38,177,218,235,154,214,191,179,249,198,233,11,69,161,140,25,240,14,98,161,76,105,7,60,155,81,190,132,39,54,219,150,146,153,53,46,46,254,80,38,84,185,153,158,232,222,252,140,93,113,18,52,225,22,119,169,54,46,206,17,138,73,171,3,63,230,69,187,131,129,32,227,224,145,118,91,92,246,19,73,233,89,253,241,85,62,152,108,130,6,33,212,62,97,68,198,139,206,170,126,55,169,207,214,127,65,56,110,195,38,93,124,118,137,179,196,202,238,214,89,29,214,111,225,161,177,10,243,20,30,228,75,168,121,129,19,203,105,215,171,119,14,178,185,194,161,92,1,126,198,57,156,169,254,128,36,21,153,229,54,160,54,11,142,28,81,110,134,102,22,167,62,218,113,194,44,111,222,44,148,211,185,73,9,4,129,240,177,184,230,149,163,13,73,123,27,177,46,30,67,210,62,72,251,110,89,45,233,219,246,195,81,103,145,166,204,176,169,31,116,12,206,122,102,185,97,148,222,5,6,241,16,0,0,0,11,0,0,0,10,0,0,0,16,0,0,0,24,0,0,0,40,0,0,0,51,0,0,0,61,0,0,0,12,0,0,0,12,0,0,0,14,0,0,0,19,0,0,0,26,0,0,0,58,0,0,0,60,0,0,0,55,0,0,0,14,0,0,0,13,0,0,0,16,0,0,0,24,0,0,0,40,0,0,0,57,0,0,0,69,0,0,0,56,0,0,0,14,0,0,0,17,0,0,0,22,0,0,0,29,0,0,0,51,0,0,0,87,0,0,0,80,0,0,0,62,0,0,0,18,0,0,0,22,0,0,0,37,0,0,0,56,0,0,0,68,0,0,0,109,0,0,0,103,0,0,0,77,0,0,0,24,0,0,0,35,0,0,0,55,0,0,0,64,0,0,0,81,0,0,0,104,0,0,0,113,0,0,0,92,0,0,0,49,0,0,0,64,0,0,0,78,0,0,0,87,0,0,0,103,0,0,0,121,0,0,0,120,0,0,0,101,0,0,0,72,0,0,0,92,0,0,0,95,0,0,0,98,0,0,0,112,0,0,0,100,0,0,0,103,0,0,0,99,0,0,0,17,0,0,0,18,0,0,0,24,0,0,0,47,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,18,0,0,0,21,0,0,0,26,0,0,0,66,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,24,0,0,0,26,0,0,0,56,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,47,0,0,0,66,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,121,98,2,0,143,98,2,0,175,98,2,0,212,98,2,0,238,98,2,0,13,99,2,0,34,99,2,0,63,99,2,0,105,99,2,0,169,99,2,0,200,99,2,0,223,99,2,0,245,99,2,0,9,100,2,0,70,100,2,0,118,100,2,0,146,100,2,0,181,100,2,0,236,100,2,0,35,101,2,0,58,101,2,0,90,101,2,0,132,101,2,0,209,101,2,0,236,101,2,0,23,102,2,0,51,102,2,0,88,102,2,0,126,102,2,0,163,102,2,0,182,102,2,0,203,102,2,0,222,102,2,0,241,102,2,0,22,103,2,0,43,103,2,0,63,103,2,0,96,103,2,0,118,103,2,0,165,103,2,0,205,103,2,0,238,103,2,0,15,104,2,0,62,104,2,0,79,104,2,0,107,104,2,0,169,104,2,0,208,104,2,0,247,104,2,0,11,105,2,0,57,105,2,0,97,105,2,0,125,105,2,0,162,105,2,0,196,105,2,0,238,105,2,0,25,106,2,0,55,106,2,0,101,106,2,0,141,106,2,0,180,106,2,0,223,106,2,0,12,107,2,0,60,107,2,0,102,107,2,0,147,107,2,0,182,107,2,0,212,107,2,0,242,107,2,0,40,108,2,0,82,108,2,0,113,108,2,0,148,108,2,0,187,108,2,0,208,108,2,0,228,108,2,0,25,109,2,0,41,109,2,0,103,109,2,0,169,109,2,0,211,109,2,0,255,109,2,0,38,110,2,0,66,110,2,0,109,110,2,0,136,110,2,0,156,110,2,0,179,110,2,0,192,110,2,0,232,110,2,0,29,111,2,0,89,111,2,0,135,111,2,0,168,111,2,0,207,111,2,0,232,111,2,0,16,112,2,0,51,112,2,0,75,112,2,0,111,112,2,0,148,112,2,0,154,112,2,0,211,112,2,0,13,113,2,0,44,113,2,0,59,113,2,0,88,113,2,0,118,113,2,0,147,113,2,0,172,113,2,0,197,113,2,0,7,114,2,0,65,114,2,0,119,114,2,0,171,114,2,0,191,114,2,0,214,114,2,0,252,114,2,0,35,115,2,0,101,115,2,0,161,115,2,0,210,115,2,0,246,115,2,0,36,116,2,0,63,116,2,0,119,116,2,0,162,116,2,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,16,0,0,0,9,0,0,0,2,0,0,0,3,0,0,0,10,0,0,0,17,0,0,0,24,0,0,0,32,0,0,0,25,0,0,0,18,0,0,0,11,0,0,0,4,0,0,0,5,0,0,0,12,0,0,0,19,0,0,0,26,0,0,0,33,0,0,0,40,0,0,0,48,0,0,0,41,0,0,0,34,0,0,0,27,0,0,0,20,0,0,0,13,0,0,0,6,0,0,0,7,0,0,0,14,0,0,0,21,0,0,0,28,0,0,0,35,0,0,0,42,0,0,0,49,0,0,0,56,0,0,0,57,0,0,0,50,0,0,0,43,0,0,0,36,0,0,0,29,0,0,0,22,0,0,0,15,0,0,0,23,0,0,0,30,0,0,0,37,0,0,0,44,0,0,0,51,0,0,0,58,0,0,0,59,0,0,0,52,0,0,0,45,0,0,0,38,0,0,0,31,0,0,0,39,0,0,0,46,0,0,0,53,0,0,0,60,0,0,0,61,0,0,0,54,0,0,0,47,0,0,0,55,0,0,0,62,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,16,0,0,0,9,0,0,0,2,0,0,0,3,0,0,0,10,0,0,0,17,0,0,0,24,0,0,0,32,0,0,0,25,0,0,0,18,0,0,0,11,0,0,0,4,0,0,0,5,0,0,0,12,0,0,0,19,0,0,0,26,0,0,0,33,0,0,0,40,0,0,0,48,0,0,0,41,0,0,0,34,0,0,0,27,0,0,0,20,0,0,0,13,0,0,0,6,0,0,0,14,0,0,0,21,0,0,0,28,0,0,0,35,0,0,0,42,0,0,0,49,0,0,0,50,0,0,0,43,0,0,0,36,0,0,0,29,0,0,0,22,0,0,0,30,0,0,0,37,0,0,0,44,0,0,0,51,0,0,0,52,0,0,0,45,0,0,0,38,0,0,0,46,0,0,0,53,0,0,0,54,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,16,0,0,0,9,0,0,0,2,0,0,0,3,0,0,0,10,0,0,0,17,0,0,0,24,0,0,0,32,0,0,0,25,0,0,0,18,0,0,0,11,0,0,0,4,0,0,0,5,0,0,0,12,0,0,0,19,0,0,0,26,0,0,0,33,0,0,0,40,0,0,0,41,0,0,0,34,0,0,0,27,0,0,0,20,0,0,0,13,0,0,0,21,0,0,0,28,0,0,0,35,0,0,0,42,0,0,0,43,0,0,0,36,0,0,0,29,0,0,0,37,0,0,0,44,0,0,0,45,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,16,0,0,0,9,0,0,0,2,0,0,0,3,0,0,0,10,0,0,0,17,0,0,0,24,0,0,0,32,0,0,0,25,0,0,0,18,0,0,0,11,0,0,0,4,0,0,0,12,0,0,0,19,0,0,0,26,0,0,0,33,0,0,0,34,0,0,0,27,0,0,0,20,0,0,0,28,0,0,0,35,0,0,0,36,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,16,0,0,0,9,0,0,0,2,0,0,0,3,0,0,0,10,0,0,0,17,0,0,0,24,0,0,0,25,0,0,0,18,0,0,0,11,0,0,0,19,0,0,0,26,0,0,0,27,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,16,0,0,0,9,0,0,0,2,0,0,0,10,0,0,0,17,0,0,0,18,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,9,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,64,6,0,0,128,62,0,0,0,0,0,0,136,19,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,2,0,0,0,4,0,0,0,6,0,0,0,3,0,0,0,7,0,0,0,8,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,12,0,0,0,3,0,0,0,8,0,0,0,11,0,0,0,13,0,0,0,9,0,0,0,10,0,0,0,14,0,0,0,15,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,14,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,13,0,0,0,15,0,0,0,3,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,21,0,0,0,9,0,0,0,11,0,0,0,17,0,0,0,20,0,0,0,22,0,0,0,10,0,0,0,18,0,0,0,19,0,0,0,23,0,0,0,24,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,14,0,0,0,15,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,13,0,0,0,16,0,0,0,25,0,0,0,3,0,0,0,8,0,0,0,12,0,0,0,17,0,0,0,24,0,0,0,26,0,0,0,9,0,0,0,11,0,0,0,18,0,0,0,23,0,0,0,27,0,0,0,32,0,0,0,10,0,0,0,19,0,0,0,22,0,0,0,28,0,0,0,31,0,0,0,33,0,0,0,20,0,0,0,21,0,0,0,29,0,0,0,30,0,0,0,34,0,0,0,35,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,14,0,0,0,15,0,0,0,27,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,13,0,0,0,16,0,0,0,26,0,0,0,28,0,0,0,3,0,0,0,8,0,0,0,12,0,0,0,17,0,0,0,25,0,0,0,29,0,0,0,38,0,0,0,9,0,0,0,11,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,37,0,0,0,39,0,0,0,10,0,0,0,19,0,0,0,23,0,0,0,31,0,0,0,36,0,0,0,40,0,0,0,45,0,0,0,20,0,0,0,22,0,0,0,32,0,0,0,35,0,0,0,41,0,0,0,44,0,0,0,46,0,0,0,21,0,0,0,33,0,0,0,34,0,0,0,42,0,0,0,43,0,0,0,47,0,0,0,48,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,14,0,0,0,15,0,0,0,27,0,0,0,28,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,13,0,0,0,16,0,0,0,26,0,0,0,29,0,0,0,42,0,0,0,3,0,0,0,8,0,0,0,12,0,0,0,17,0,0,0,25,0,0,0,30,0,0,0,41,0,0,0,43,0,0,0,9,0,0,0,11,0,0,0,18,0,0,0,24,0,0,0,31,0,0,0,40,0,0,0,44,0,0,0,53,0,0,0,10,0,0,0,19,0,0,0,23,0,0,0,32,0,0,0,39,0,0,0,45,0,0,0,52,0,0,0,54,0,0,0,20,0,0,0,22,0,0,0,33,0,0,0,38,0,0,0,46,0,0,0,51,0,0,0,55,0,0,0,60,0,0,0,21,0,0,0,34,0,0,0,37,0,0,0,47,0,0,0,50,0,0,0,56,0,0,0,59,0,0,0,61,0,0,0,35,0,0,0,36,0,0,0,48,0,0,0,49,0,0,0,57,0,0,0,58,0,0,0,62,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,7,0,0,0,15,0,0,0,31,0,0,0,63,0,0,0,127,0,0,0,255,0,0,0,255,1,0,0,255,3,0,0,255,7,0,0,255,15,0,0,255,31,0,0,255,63,0,0,255,127,0,0,129,1,29,90,14,2,134,37,16,3,20,17,18,4,11,8,20,5,216,3,23,6,218,1,25,7,229,0,28,8,111,0,30,9,54,0,33,10,26,0,35,11,13,0,9,12,6,0,10,13,3,0,12,13,1,0,143,15,127,90,36,16,37,63,38,17,242,44,39,18,124,32,40,19,185,23,42,20,130,17,43,21,239,12,45,22,161,9,46,23,47,7,48,24,92,5,49,25,6,4,51,26,3,3,52,27,64,2,54,28,177,1,56,29,68,1,57,30,245,0,59,31,183,0,60,32,138,0,62,33,104,0,63,34,78,0,32,35,59,0,33,9,44,0,165,37,225,90,64,38,76,72,65,39,13,58,67,40,241,46,68,41,31,38,69,42,51,31,70,43,168,25,72,44,24,21,73,45,119,17,74,46,116,14,75,47,251,11,77,48,248,9,78,49,97,8,79,50,6,7,48,51,205,5,50,52,222,4,50,53,15,4,51,54,99,3,52,55,212,2,53,56,92,2,54,57,248,1,55,58,164,1,56,59,96,1,57,60,37,1,58,61,246,0,59,62,203,0,61,63,171,0,61,32,143,0,193,65,18,91,80,66,4,77,81,67,44,65,82,68,216,55,83,69,232,47,84,70,60,41,86,71,121,35,87,72,223,30,87,73,169,26,72,74,78,23,72,75,36,20,74,76,156,17,74,77,107,15,75,78,81,13,77,79,182,11,77,48,64,10,208,81,50,88,88,82,28,77,89,83,142,67,90,84,221,59,91,85,238,52,92,86,174,46,93,87,154,41,86,71,22,37,216,89,112,85,95,90,169,76,96,91,217,68,97,92,34,62,99,93,36,56,99,94,180,50,93,86,23,46,223,96,168,86,101,97,70,79,102,98,229,71,103,99,207,65,104,100,61,60,99,93,94,55,105,102,49,82,106,103,15,76,107,104,57,70,103,99,94,65,233,106,39,86,108,107,231,80,109,103,133,75,110,109,151,85,111,107,79,80,238,111,16,90,112,109,34,85,240,111,235,89,113,113,29,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,192,3,0,0,192,4,0,0,192,5,0,0,192,6,0,0,192,7,0,0,192,8,0,0,192,9,0,0,192,10,0,0,192,11,0,0,192,12,0,0,192,13,0,0,192,14,0,0,192,15,0,0,192,16,0,0,192,17,0,0,192,18,0,0,192,19,0,0,192,20,0,0,192,21,0,0,192,22,0,0,192,23,0,0,192,24,0,0,192,25,0,0,192,26,0,0,192,27,0,0,192,28,0,0,192,29,0,0,192,30,0,0,192,31,0,0,192,0,0,0,179,1,0,0,195,2,0,0,195,3,0,0,195,4,0,0,195,5,0,0,195,6,0,0,195,7,0,0,195,8,0,0,195,9,0,0,195,10,0,0,195,11,0,0,195,12,0,0,195,13,0,0,211,14,0,0,195,15,0,0,195,0,0,12,187,1,0,12,195,2,0,12,195,3,0,12,195,4,0,12,211,120,224,1,0,232,224,1,0,0,0,0,0,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+112640);allocate([1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,102,130,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,3,0,0,0,94,126,2,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,53,0,0,0,6,0,7,0,1,0,4,0,7,0,2,0,4,0,8,0,3,0,4,0,11,0,4,0,4,0,12,0,5,0,4,0,14,0,6,0,4,0,15,0,7,0,5,0,19,0,8,0,5,0,20,0,9,0,5,0,7,0,10,0,5,0,8,0,11,0,6,0,8,0,12,0,6,0,3,0,13,0,6,0,52,0,14,0,6,0,53,0,15,0,6,0,42,0,16,0,6,0,43,0,17,0,7,0,39,0,18,0,7,0,12,0,19,0,7,0,8,0,20,0,7,0,23,0,21,0,7,0,3,0,22,0,7,0,4,0,23,0,7,0,40,0,24,0,7,0,43,0,25,0,7,0,19,0,26,0,7,0,36,0,27,0,7,0,24,0,28,0,8,0,2,0,29,0,8,0,3,0,30,0,8,0,26,0,31,0,8,0,27,0,32,0,8,0,18,0,33,0,8,0,19,0,34,0,8,0,20,0,35,0,8,0,21,0,36,0,8,0,22,0,37,0,8,0,23,0,38,0,8,0,40,0,39,0,8,0,41,0,40,0,8,0,42,0,41,0,8,0,43,0,42,0,8,0,44,0,43,0,8,0,45,0,44,0,8,0,4,0,45,0,8,0,5,0,46,0,8,0,10,0,47,0,8,0,11,0,48,0,8,0,82,0,49,0,8,0,83,0,50,0,8,0,84,0,51,0,8,0,85,0,52,0,8,0,36,0,53,0,8,0,37,0,54,0,8,0,88,0,55,0,8,0,89,0,56,0,8,0,90,0,57,0,8,0,91,0,58,0,8,0,74,0,59,0,8,0,75,0,60,0,8,0,50,0,61,0,8,0,51,0,62,0,8,0,52,0,63,0,5,0,27,0,64,0,5,0,18,0,128,0,6,0,23,0,192,0,7,0,55,0,0,1,8,0,54,0,64,1,8,0,55,0,128,1,8,0,100,0,192,1,8,0,101,0,0,2,8,0,104,0,64,2,8,0,103,0,128,2,9,0,204,0,192,2,9,0,205,0,0,3,9,0,210,0,64,3,9,0,211,0,128,3,9,0,212,0,192,3,9,0,213,0,0,4,9,0,214,0,64,4,9,0,215,0,128,4,9,0,216,0,192,4,9,0,217,0,0,5,9,0,218,0,64,5,9,0,219,0,128,5,9,0,152,0,192,5,9,0,153,0,0,6,9,0,154,0,64,6,6,0,24,0,128,6,9,0,155,0,192,6,11,0,8,0,0,7,11,0,12,0,64,7,11,0,13,0,128,7,12,0,18,0,192,7,12,0,19,0,0,8,12,0,20,0,64,8,12,0,21,0,128,8,12,0,22,0,192,8,12,0,23,0,0,9,12,0,28,0,64,9,12,0,29,0,128,9,12,0,30,0,192,9,12,0,31,0,0,10,12,0,1,0,255,255,9,0,1,0,254,255,10,0,1,0,254,255,11,0,1,0,254,255,12,0,0,0,254,255,10,0,55,0,0,0,3,0,2,0,1,0,2,0,3,0,2,0,2,0,2,0,3,0,3,0,3,0,4,0,4,0,3,0,5,0,4,0,2,0,6,0,5,0,3,0,7,0,6,0,5,0,8,0,6,0,4,0,9,0,7,0,4,0,10,0,7,0,5,0,11,0,7,0,7,0,12,0,8,0,4,0,13,0,8,0,7,0,14,0,9,0,24,0,15,0,10,0,23,0,16,0,10,0,24,0,17,0,10,0,8,0,18,0,11,0,103,0,19,0,11,0,104,0,20,0,11,0,108,0,21,0,11,0,55,0,22,0,11,0,40,0,23,0,11,0,23,0,24,0,11,0,24,0,25,0,12,0,202,0,26,0,12,0,203,0,27,0,12,0,204,0,28,0,12,0,205,0,29,0,12,0,104,0,30,0,12,0,105,0,31,0,12,0,106,0,32,0,12,0,107,0,33,0,12,0,210,0,34,0,12,0,211,0,35,0,12,0,212,0,36,0,12,0,213,0,37,0,12,0,214,0,38,0,12,0,215,0,39,0,12,0,108,0,40,0,12,0,109,0,41,0,12,0,218,0,42,0,12,0,219,0,43,0,12,0,84,0,44,0,12,0,85,0,45,0,12,0,86,0,46,0,12,0,87,0,47,0,12,0,100,0,48,0,12,0,101,0,49,0,12,0,82,0,50,0,12,0,83,0,51,0,12,0,36,0,52,0,12,0,55,0,53,0,12,0,56,0,54,0,12,0,39,0,55,0,12,0,40,0,56,0,12,0,88,0,57,0,12,0,89,0,58,0,12,0,43,0,59,0,12,0,44,0,60,0,12,0,90,0,61,0,12,0,102,0,62,0,12,0,103,0,63,0,10,0,15,0,64,0,12,0,200,0,128,0,12,0,201,0,192,0,12,0,91,0,0,1,12,0,51,0,64,1,12,0,52,0,128,1,12,0,53,0,192,1,13,0,108,0,0,2,13,0,109,0,64,2,13,0,74,0,128,2,13,0,75,0,192,2,13,0,76,0,0,3,13,0,77,0,64,3,13,0,114,0,128,3,13,0,115,0,192,3,13,0,116,0,0,4,13,0,117,0,64,4,13,0,118,0,128,4,13,0,119,0,192,4,13,0,82,0,0,5,13,0,83,0,64,5,13,0,84,0,128,5,13,0,85,0,192,5,13,0,90,0,0,6,13,0,91,0,64,6,13,0,100,0,128,6,13,0,101,0,192,6,11,0,8,0,0,7,11,0,12,0,64,7,11,0,13,0,128,7,12,0,18,0,192,7,12,0,19,0,0,8,12,0,20,0,64,8,12,0,21,0,128,8,12,0,22,0,192,8,12,0,23,0,0,9,12,0,28,0,64,9,12,0,29,0,128,9,12,0,30,0,192,9,12,0,31,0,0,10,12,0,1,0,255,255,9,0,1,0,254,255,10,0,1,0,254,255,11,0,1,0,254,255,12,0,0,0,254,255,7,0,3,0,0,0,6,0,3,0,0,0,3,0,3,0,0,0,1,0,1,0,0,0,3,0,2,0,0,0,6,0,2,0,0,0,7,0,2,0,0,0,96,7,0,0,0,8,80,0,0,8,16,0,20,8,115,0,18,7,31,0,0,8,112,0,0,8,48,0,0,9,192,0,16,7,10,0,0,8,96,0,0,8,32,0,0,9,160,0,0,8,0,0,0,8,128,0,0,8,64,0,0,9,224,0,16,7,6,0,0,8,88,0,0,8,24,0,0,9,144,0,19,7,59,0,0,8,120,0,0,8,56,0,0,9,208,0,17,7,17,0,0,8,104,0,0,8,40,0,0,9,176,0,0,8,8,0,0,8,136,0,0,8,72,0,0,9,240,0,16,7,4,0,0,8,84,0,0,8,20,0,21,8,227,0,19,7,43,0,0,8,116,0,0,8,52,0,0,9,200,0,17,7,13,0,0,8,100,0,0,8,36,0,0,9,168,0,0,8,4,0,0,8,132,0,0,8,68,0,0,9,232,0,16,7,8,0,0,8,92,0,0,8,28,0,0,9,152,0,20,7,83,0,0,8,124,0,0,8,60,0,0,9,216,0,18,7,23,0,0,8,108,0,0,8,44,0,0,9,184,0,0,8,12,0,0,8,140,0,0,8,76,0,0,9,248,0,16,7,3,0,0,8,82,0,0,8,18,0,21,8,163,0,19,7,35,0,0,8,114,0,0,8,50,0,0,9,196,0,17,7,11,0,0,8,98,0,0,8,34,0,0,9,164,0,0,8,2,0,0,8,130,0,0,8,66,0,0,9,228,0,16,7,7,0,0,8,90,0,0,8,26,0,0,9,148,0,20,7,67,0,0,8,122,0,0,8,58,0,0,9,212,0,18,7,19,0,0,8,106,0,0,8,42,0,0,9,180,0,0,8,10,0,0,8,138,0,0,8,74,0,0,9,244,0,16,7,5,0,0,8,86,0,0,8,22,0,64,8,0,0,19,7,51,0,0,8,118,0,0,8,54,0,0,9,204,0,17,7,15,0,0,8,102,0,0,8,38,0,0,9,172,0,0,8,6,0,0,8,134,0,0,8,70,0,0,9,236,0,16,7,9,0,0,8,94,0,0,8,30,0,0,9,156,0,20,7,99,0,0,8,126,0,0,8,62,0,0,9,220,0,18,7,27,0,0,8,110,0,0,8,46,0,0,9,188,0,0,8,14,0,0,8,142,0,0,8,78,0,0,9,252,0,96,7,0,0,0,8,81,0,0,8,17,0,21,8,131,0,18,7,31,0,0,8,113,0,0,8,49,0,0,9,194,0,16,7,10,0,0,8,97,0,0,8,33,0,0,9,162,0,0,8,1,0,0,8,129,0,0,8,65,0,0,9,226,0,16,7,6,0,0,8,89,0,0,8,25,0,0,9,146,0,19,7,59,0,0,8,121,0,0,8,57,0,0,9,210,0,17,7,17,0,0,8,105,0,0,8,41,0,0,9,178,0,0,8,9,0,0,8,137,0,0,8,73,0,0,9,242,0,16,7,4,0,0,8,85,0,0,8,21,0,16,8,2,1,19,7,43,0,0,8,117,0,0,8,53,0,0,9,202,0,17,7,13,0,0,8,101,0,0,8,37,0,0,9,170,0,0,8,5,0,0,8,133,0,0,8,69,0,0,9,234,0,16,7,8,0,0,8,93,0,0,8,29,0,0,9,154,0,20,7,83,0,0,8,125,0,0,8,61,0,0,9,218,0,18,7,23,0,0,8,109,0,0,8,45,0,0,9,186,0,0,8,13,0,0,8,141,0,0,8,77,0,0,9,250,0,16,7,3,0,0,8,83,0,0,8,19,0,21,8,195,0,19,7,35,0,0,8,115,0,0,8,51,0,0,9,198,0,17,7,11,0,0,8,99,0,0,8,35,0,0,9,166,0,0,8,3,0,0,8,131,0,0,8,67,0,0,9,230,0,16,7,7,0,0,8,91,0,0,8,27,0,0,9,150,0,20,7,67,0,0,8,123,0,0,8,59,0,0,9,214,0,18,7,19,0,0,8,107,0,0,8,43,0,0,9,182,0,0,8,11,0,0,8,139,0,0,8,75,0,0,9,246,0,16,7,5,0,0,8,87,0,0,8,23,0,64,8,0,0,19,7,51,0,0,8,119,0,0,8,55,0,0,9,206,0,17,7,15,0,0,8,103,0,0,8,39,0,0,9,174,0,0,8,7,0,0,8,135,0,0,8,71,0,0,9,238,0,16,7,9,0,0,8,95,0,0,8,31,0,0,9,158,0,20,7,99,0,0,8,127,0,0,8,63,0,0,9,222,0,18,7,27,0,0,8,111,0,0,8,47,0,0,9,190,0,0,8,15,0,0,8,143,0,0,8,79,0,0,9,254,0,96,7,0,0,0,8,80,0,0,8,16,0,20,8,115,0,18,7,31,0,0,8,112,0,0,8,48,0,0,9,193,0,16,7,10,0,0,8,96,0,0,8,32,0,0,9,161,0,0,8,0,0,0,8,128,0,0,8,64,0,0,9,225,0,16,7,6,0,0,8,88,0,0,8,24,0,0,9,145,0,19,7,59,0,0,8,120,0,0,8,56,0,0,9,209,0,17,7,17,0,0,8,104,0,0,8,40,0,0,9,177,0,0,8,8,0,0,8,136,0,0,8,72,0,0,9,241,0,16,7,4,0,0,8,84,0,0,8,20,0,21,8,227,0,19,7,43,0,0,8,116,0,0,8,52,0,0,9,201,0,17,7,13,0,0,8,100,0,0,8,36,0,0,9,169,0,0,8,4,0,0,8,132,0,0,8,68,0,0,9,233,0,16,7,8,0,0,8,92,0,0,8,28,0,0,9,153,0,20,7,83,0,0,8,124,0,0,8,60,0,0,9,217,0,18,7,23,0,0,8,108,0,0,8,44,0,0,9,185,0,0,8,12,0,0,8,140,0,0,8,76,0,0,9,249,0,16,7,3,0,0,8,82,0,0,8,18,0,21,8,163,0,19,7,35,0,0,8,114,0,0,8,50,0,0,9,197,0,17,7,11,0,0,8,98,0,0,8,34,0,0,9,165,0,0,8,2,0,0,8,130,0,0,8,66,0,0,9,229,0,16,7,7,0,0,8,90,0,0,8,26,0,0,9,149,0,20,7,67,0,0,8,122,0,0,8,58,0,0,9,213,0,18,7,19,0,0,8,106,0,0,8,42,0,0,9,181,0,0,8,10,0,0,8,138,0,0,8,74,0,0,9,245,0,16,7,5,0,0,8,86,0,0,8,22,0,64,8,0,0,19,7,51,0,0,8,118,0,0,8,54,0,0,9,205,0,17,7,15,0,0,8,102,0,0,8,38,0,0,9,173,0,0,8,6,0,0,8,134,0,0,8,70,0,0,9,237,0,16,7,9,0,0,8,94,0,0,8,30,0,0,9,157,0,20,7,99,0,0,8,126,0,0,8,62,0,0,9,221,0,18,7,27,0,0,8,110,0,0,8,46,0,0,9,189,0,0,8,14,0,0,8,142,0,0,8,78,0,0,9,253,0,96,7,0,0,0,8,81,0,0,8,17,0,21,8,131,0,18,7,31,0,0,8,113,0,0,8,49,0,0,9,195,0,16,7,10,0,0,8,97,0,0,8,33,0,0,9,163,0,0,8,1,0,0,8,129,0,0,8,65,0,0,9,227,0,16,7,6,0,0,8,89,0,0,8,25,0,0,9,147,0,19,7,59,0,0,8,121,0,0,8,57,0,0,9,211,0,17,7,17,0,0,8,105,0,0,8,41,0,0,9,179,0,0,8,9,0,0,8,137,0,0,8,73,0,0,9,243,0,16,7,4,0,0,8,85,0,0,8,21,0,16,8,2,1,19,7,43,0,0,8,117,0,0,8,53,0,0,9,203,0,17,7,13,0,0,8,101,0,0,8,37,0,0,9,171,0,0,8,5,0,0,8,133,0,0,8,69,0,0,9,235,0,16,7,8,0,0,8,93,0,0,8,29,0,0,9,155,0,20,7,83,0,0,8,125,0,0,8,61,0,0,9,219,0,18,7,23,0,0,8,109,0,0,8,45,0,0,9,187,0,0,8,13,0,0,8,141,0,0,8,77,0,0,9,251,0,16,7,3,0,0,8,83,0,0,8,19,0,21,8,195,0,19,7,35,0,0,8,115,0,0,8,51,0,0,9,199,0,17,7,11,0,0,8,99,0,0,8,35,0,0,9,167,0,0,8,3,0,0,8,131,0,0,8,67,0,0,9,231,0,16,7,7,0,0,8,91,0,0,8,27,0,0,9,151,0,20,7,67,0,0,8,123,0,0,8,59,0,0,9,215,0,18,7,19,0,0,8,107,0,0,8,43,0,0,9,183,0,0,8,11,0,0,8,139,0,0,8,75,0,0,9,247,0,16,7,5,0,0,8,87,0,0,8,23,0,64,8,0,0,19,7,51,0,0,8,119,0,0,8,55,0,0,9,207,0,17,7,15,0,0,8,103,0,0,8,39,0,0,9,175,0,0,8,7,0,0,8,135,0,0,8,71,0,0,9,239,0,16,7,9,0,0,8,95,0,0,8,31,0,0,9,159,0,20,7,99,0,0,8,127,0,0,8,63,0,0,9,223,0,18,7,27,0,0,8,111,0,0,8,47,0,0,9,191,0,0,8,15,0,0,8,143,0,0,8,79,0,0,9,255,0,16,5,1,0,23,5,1,1,19,5,17,0,27,5,1,16,17,5,5,0,25,5,1,4,21,5,65,0,29,5,1,64,16,5,3,0,24,5,1,2,20,5,33,0,28,5,1,32,18,5,9,0,26,5,1,8,22,5,129,0,64,5,0,0,16,5,2,0,23,5,129,1,19,5,25,0,27,5,1,24,17,5,7,0,25,5,1,6,21,5,97,0,29,5,1,96,16,5,4,0,24,5,1,3,20,5,49,0,28,5,1,48,18,5,13,0,26,5,1,12,22,5,193,0,64,5,0,0,16,0,17,0,18,0,0,0,8,0,7,0,9,0,6,0,10,0,5,0,11,0,4,0,12,0,3,0,13,0,2,0,14,0,1,0,15,0,1,0,2,0,3,0,4,0,5,0,7,0,9,0,13,0,17,0,25,0,33,0,49,0,65,0,97,0,129,0,193,0,1,1,129,1,1,2,1,3,1,4,1,6,1,8,1,12,1,16,1,24,1,32,1,48,1,64,1,96,0,0,0,0,3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,11,0,13,0,15,0,17,0,19,0,23,0,27,0,31,0,35,0,43,0,51,0,59,0,67,0,83,0,99,0,115,0,131,0,163,0,195,0,227,0,2,1,0,0,0,0,16,0,16,0,16,0,16,0,17,0,17,0,18,0,18,0,19,0,19,0,20,0,20,0,21,0,21,0,22,0,22,0,23,0,23,0,24,0,24,0,25,0,25,0,26,0,26,0,27,0,27,0,28,0,28,0,29,0,29,0,64,0,64,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,17,0,17,0,17,0,17,0,18,0,18,0,18,0,18,0,19,0,19,0,19,0,19,0,20,0,20,0,20,0,20,0,21,0,21,0,21,0,21,0,16,0,72,0,78,0,12,0,8,0,140,0,8,0,76,0,8,0,204,0,8,0,44,0,8,0,172,0,8,0,108,0,8,0,236,0,8,0,28,0,8,0,156,0,8,0,92,0,8,0,220,0,8,0,60,0,8,0,188,0,8,0,124,0,8,0,252,0,8,0,2,0,8,0,130,0,8,0,66,0,8,0,194,0,8,0,34,0,8,0,162,0,8,0,98,0,8,0,226,0,8,0,18,0,8,0,146,0,8,0,82,0,8,0,210,0,8,0,50,0,8,0,178,0,8,0,114,0,8,0,242,0,8,0,10,0,8,0,138,0,8,0,74,0,8,0,202,0,8,0,42,0,8,0,170,0,8,0,106,0,8,0,234,0,8,0,26,0,8,0,154,0,8,0,90,0,8,0,218,0,8,0,58,0,8,0,186,0,8,0,122,0,8,0,250,0,8,0,6,0,8,0,134,0,8,0,70,0,8,0,198,0,8,0,38,0,8,0,166,0,8,0,102,0,8,0,230,0,8,0,22,0,8,0,150,0,8,0,86,0,8,0,214,0,8,0,54,0,8,0,182,0,8,0,118,0,8,0,246,0,8,0,14,0,8,0,142,0,8,0,78,0,8,0,206,0,8,0,46,0,8,0,174,0,8,0,110,0,8,0,238,0,8,0,30,0,8,0,158,0,8,0,94,0,8,0,222,0,8,0,62,0,8,0,190,0,8,0,126,0,8,0,254,0,8,0,1,0,8,0,129,0,8,0,65,0,8,0,193,0,8,0,33,0,8,0,161,0,8,0,97,0,8,0,225,0,8,0,17,0,8,0,145,0,8,0,81,0,8,0,209,0,8,0,49,0,8,0,177,0,8,0,113,0,8,0,241,0,8,0,9,0,8,0,137,0,8,0,73,0,8,0,201,0,8,0,41,0,8,0,169,0,8,0,105,0,8,0,233,0,8,0,25,0,8,0,153,0,8,0,89,0,8,0,217,0,8,0,57,0,8,0,185,0,8,0,121,0,8,0,249,0,8,0,5,0,8,0,133,0,8,0,69,0,8,0,197,0,8,0,37,0,8,0,165,0,8,0,101,0,8,0,229,0,8,0,21,0,8,0,149,0,8,0,85,0,8,0,213,0,8,0,53,0,8,0,181,0,8,0,117,0,8,0,245,0,8,0,13,0,8,0,141,0,8,0,77,0,8,0,205,0,8,0,45,0,8,0,173,0,8,0,109,0,8,0,237,0,8,0,29,0,8,0,157,0,8,0,93,0,8,0,221,0,8,0,61,0,8,0,189,0,8,0,125,0,8,0,253,0,8,0,19,0,9,0,19,1,9,0,147,0,9,0,147,1,9,0,83,0,9,0,83,1,9,0,211,0,9,0,211,1,9,0,51,0,9,0,51,1,9,0,179,0,9,0,179,1,9,0,115,0,9,0,115,1,9,0,243,0,9,0,243,1,9,0,11,0,9,0,11,1,9,0,139,0,9,0,139,1,9,0,75,0,9,0,75,1,9,0,203,0,9,0,203,1,9,0,43,0,9,0,43,1,9,0,171,0,9,0,171,1,9,0,107,0,9,0,107,1,9,0,235,0,9,0,235,1,9,0,27,0,9,0,27,1,9,0,155,0,9,0,155,1,9,0,91,0,9,0,91,1,9,0,219,0,9,0,219,1,9,0,59,0,9,0,59,1,9,0,187,0,9,0,187,1,9,0,123,0,9,0,123,1,9,0,251,0,9,0,251,1,9,0,7,0,9,0,7,1,9,0,135,0,9,0,135,1,9,0,71,0,9,0,71,1,9,0,199,0,9,0,199,1,9,0,39,0,9,0,39,1,9,0,167,0,9,0,167,1,9,0,103,0,9,0,103,1,9,0,231,0,9,0,231,1,9,0,23,0,9,0,23,1,9,0,151,0,9,0,151,1,9,0,87,0,9,0,87,1,9,0,215,0,9,0,215,1,9,0,55,0,9,0,55,1,9,0,183,0,9,0,183,1,9,0,119,0,9,0,119,1,9,0,247,0,9,0,247,1,9,0,15,0,9,0,15,1,9,0,143,0,9,0,143,1,9,0,79,0,9,0,79,1,9,0,207,0,9,0,207,1,9,0,47,0,9,0,47,1,9,0,175,0,9,0,175,1,9,0,111,0,9,0,111,1,9,0,239,0,9,0,239,1,9,0,31,0,9,0,31,1,9,0,159,0,9,0,159,1,9,0,95,0,9,0,95,1,9,0,223,0,9,0,223,1,9,0,63,0,9,0,63,1,9,0,191,0,9,0,191,1,9,0,127,0,9,0,127,1,9,0,255,0,9,0,255,1,9,0,0,0,7,0,64,0,7,0,32,0,7,0,96,0,7,0,16,0,7,0,80,0,7,0,48,0,7,0,112,0,7,0,8,0,7,0,72,0,7,0,40,0,7,0,104,0,7,0,24,0,7,0,88,0,7,0,56,0,7,0,120,0,7,0,4,0,7,0,68,0,7,0,36,0,7,0,100,0,7,0,20,0,7,0,84,0,7,0,52,0,7,0,116,0,7,0,3,0,8,0,131,0,8,0,67,0,8,0,195,0,8,0,35,0,8,0,163,0,8,0,99,0,8,0,227,0,8,0,0,0,5,0,16,0,5,0,8,0,5,0,24,0,5,0,4,0,5,0,20,0,5,0,12,0,5,0,28,0,5,0,2,0,5,0,18,0,5,0,10,0,5,0,26,0,5,0,6,0,5,0,22,0,5,0,14,0,5,0,30,0,5,0,1,0,5,0,17,0,5,0,9,0,5,0,25,0,5,0,5,0,5,0,21,0,5,0,13,0,5,0,29,0,5,0,3,0,5,0,19,0,5,0,11,0,5,0,27,0,5,0,7,0,5,0,23,0,5,0,0,64,197,88,159,83,66,75,0,64,73,50,163,34,168,17,197,88,33,123,252,115,98,104,197,88,191,69,11,48,126,24,159,83,252,115,65,109,84,98,159,83,179,65,65,45,18,23,66,75,98,104,84,98,126,88,66,75,33,59,186,40,195,20,0,64,197,88,159,83,66,75,0,64,73,50,163,34,168,17,73,50,191,69,179,65,33,59,73,50,130,39,55,27,224,13,163,34,11,48,65,45,186,40,163,34,55,27,191,18,142,9,168,17,126,24,18,23,195,20,168,17,224,13,142,9,223,4,112,115,101,117,100,111,45,0,84,73,70,70,83,101,116,70,105,101,108,100,0,37,115,58,32,85,110,107,110,111,119,110,32,37,115,116,97,103,32,37,117,0,37,115,58,32,67,97,110,110,111,116,32,109,111,100,105,102,121,32,116,97,103,32,34,37,115,34,32,119,104,105,108,101,32,119,114,105,116,105,110,103,0,116,105,102,95,100,105,114,46,99,0,84,73,70,70,65,100,118,97,110,99,101,68,105,114,101,99,116,111,114,121,0,83,97,110,105,116,121,32,99,104,101,99,107,32,111,110,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,32,102,97,105,108,101,100,0,37,115,58,32,69,114,114,111,114,32,102,101,116,99,104,105,110,103,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,0,37,115,58,32,69,114,114,111,114,32,102,101,116,99,104,105,110,103,32,100,105,114,101,99,116,111,114,121,32,108,105,110,107,0,95,84,73,70,70,86,71,101,116,70,105,101,108,100,0,37,115,58,32,73,110,118,97,108,105,100,32,37,115,116,97,103,32,34,37,115,34,32,40,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,99,111,100,101,99,41,0,116,118,45,62,99,111,117,110,116,32,61,61,32,49,0,78,111,110,115,116,97,110,100,97,114,100,32,116,105,108,101,32,119,105,100,116,104,32,37,100,44,32,99,111,110,118,101,114,116,32,102,105,108,101,0,78,111,110,115,116,97,110,100,97,114,100,32,116,105,108,101,32,108,101,110,103,116,104,32,37,100,44,32,99,111,110,118,101,114,116,32,102,105,108,101,0,95,84,73,70,70,86,83,101,116,70,105,101,108,100,0,37,115,58,32,83,111,114,114,121,44,32,99,97,110,110,111,116,32,110,101,115,116,32,83,117,98,73,70,68,115,0,37,115,58,32,73,110,118,97,108,105,100,32,73,110,107,78,97,109,101,115,32,118,97,108,117,101,59,32,101,120,112,101,99,116,105,110,103,32,37,100,32,110,97,109,101,115,44,32,102,111,117,110,100,32,37,100,0,37,115,58,32,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,115,112,97,99,101,32,102,111,114,32,108,105,115,116,32,111,102,32,99,117,115,116,111,109,32,118,97,108,117,101,115,0,37,115,58,32,66,97,100,32,102,105,101,108,100,32,116,121,112,101,32,37,100,32,102,111,114,32,34,37,115,34,0,102,105,112,45,62,102,105,101,108,100,95,119,114,105,116,101,99,111,117,110,116,61,61,84,73,70,70,95,86,65,82,73,65,66,76,69,50,0,37,115,58,32,78,117,108,108,32,99,111,117,110,116,32,102,111,114,32,34,37,115,34,32,40,116,121,112,101,32,37,100,44,32,119,114,105,116,101,99,111,117,110,116,32,37,100,44,32,112,97,115,115,99,111,117,110,116,32,37,100,41,0,99,117,115,116,111,109,32,116,97,103,32,98,105,110,97,114,121,32,111,98,106,101,99,116,0,85,110,107,110,111,119,110,0,37,115,58,32,66,97,100,32,118,97,108,117,101,32,37,117,32,102,111,114,32,34,37,115,34,32,116,97,103,0,37,115,58,32,66,97,100,32,118,97,108,117,101,32,37,102,32,102,111,114,32,34,37,115,34,32,116,97,103,0,84,97,103,32,0,95,84,73,70,70,83,101,116,117,112,70,105,101,108,100,115,0,83,101,116,116,105,110,103,32,117,112,32,102,105,101,108,100,32,105,110,102,111,32,102,97,105,108,101,100,0,102,111,114,32,102,105,101,108,100,115,32,97,114,114,97,121,0,95,84,73,70,70,77,101,114,103,101,70,105,101,108,100,115,0,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,102,105,101,108,100,115,32,97,114,114,97,121,0,84,73,70,70,70,105,101,108,100,87,105,116,104,84,97,103,0,73,110,116,101,114,110,97,108,32,101,114,114,111,114,44,32,117,110,107,110,111,119,110,32,116,97,103,32,48,120,37,120,0,84,97,103,32,37,100,0,69,120,112,111,115,117,114,101,84,105,109,101,0,70,78,117,109,98,101,114,0,69,120,112,111,115,117,114,101,80,114,111,103,114,97,109,0,83,112,101,99,116,114,97,108,83,101,110,115,105,116,105,118,105,116,121,0,73,83,79,83,112,101,101,100,82,97,116,105,110,103,115,0,79,112,116,111,101,108,101,99,116,114,105,99,67,111,110,118,101,114,115,105,111,110,70,97,99,116,111,114,0,69,120,105,102,86,101,114,115,105,111,110,0,68,97,116,101,84,105,109,101,79,114,105,103,105,110,97,108,0,68,97,116,101,84,105,109,101,68,105,103,105,116,105,122,101,100,0,67,111,109,112,111,110,101,110,116,115,67,111,110,102,105,103,117,114,97,116,105,111,110,0,67,111,109,112,114,101,115,115,101,100,66,105,116,115,80,101,114,80,105,120,101,108,0,83,104,117,116,116,101,114,83,112,101,101,100,86,97,108,117,101,0,65,112,101,114,116,117,114,101,86,97,108,117,101,0,66,114,105,103,104,116,110,101,115,115,86,97,108,117,101,0,69,120,112,111,115,117,114,101,66,105,97,115,86,97,108,117,101,0,77,97,120,65,112,101,114,116,117,114,101,86,97,108,117,101,0,83,117,98,106,101,99,116,68,105,115,116,97,110,99,101,0,77,101,116,101,114,105,110,103,77,111,100,101,0,76,105,103,104,116,83,111,117,114,99,101,0,70,108,97,115,104,0,70,111,99,97,108,76,101,110,103,116,104,0,83,117,98,106,101,99,116,65,114,101,97,0,77,97,107,101,114,78,111,116,101,0,85,115,101,114,67,111,109,109,101,110,116,0,83,117,98,83,101,99,84,105,109,101,0,83,117,98,83,101,99,84,105,109,101,79,114,105,103,105,110,97,108,0,83,117,98,83,101,99,84,105,109,101,68,105,103,105,116,105,122,101,100,0,70,108,97,115,104,112,105,120,86,101,114,115,105,111,110,0,67,111,108,111,114,83,112,97,99,101,0,80,105,120,101,108,88,68,105,109,101,110,115,105,111,110,0,80,105,120,101,108,89,68,105,109,101,110,115,105,111,110,0,82,101,108,97,116,101,100,83,111,117,110,100,70,105,108,101,0,70,108,97,115,104,69,110,101,114,103,121,0,83,112,97,116,105,97,108,70,114,101,113,117,101,110,99,121,82,101,115,112,111,110,115,101,0,70,111,99,97,108,80,108,97,110,101,88,82,101,115,111,108,117,116,105,111,110,0,70,111,99,97,108,80,108,97,110,101,89,82,101,115,111,108,117,116,105,111,110,0,70,111,99,97,108,80,108,97,110,101,82,101,115,111,108,117,116,105,111,110,85,110,105,116,0,83,117,98,106,101,99,116,76,111,99,97,116,105,111,110,0,69,120,112,111,115,117,114,101,73,110,100,101,120,0,83,101,110,115,105,110,103,77,101,116,104,111,100,0,70,105,108,101,83,111,117,114,99,101,0,83,99,101,110,101,84,121,112,101,0,67,70,65,80,97,116,116,101,114,110,0,67,117,115,116,111,109,82,101,110,100,101,114,101,100,0,69,120,112,111,115,117,114,101,77,111,100,101,0,87,104,105,116,101,66,97,108,97,110,99,101,0,68,105,103,105,116,97,108,90,111,111,109,82,97,116,105,111,0,70,111,99,97,108,76,101,110,103,116,104,73,110,51,53,109,109,70,105,108,109,0,83,99,101,110,101,67,97,112,116,117,114,101,84,121,112,101,0,71,97,105,110,67,111,110,116,114,111,108,0,67,111,110,116,114,97,115,116,0,83,97,116,117,114,97,116,105,111,110,0,83,104,97,114,112,110,101,115,115,0,68,101,118,105,99,101,83,101,116,116,105,110,103,68,101,115,99,114,105,112,116,105,111,110,0,83,117,98,106,101,99,116,68,105,115,116,97,110,99,101,82,97,110,103,101,0,73,109,97,103,101,85,110,105,113,117,101,73,68,0,83,117,98,102,105,108,101,84,121,112,101,0,79,108,100,83,117,98,102,105,108,101,84,121,112,101,0,73,109,97,103,101,87,105,100,116,104,0,66,105,116,115,80,101,114,83,97,109,112,108,101,0,80,104,111,116,111,109,101,116,114,105,99,73,110,116,101,114,112,114,101,116,97,116,105,111,110,0,84,104,114,101,115,104,104,111,108,100,105,110,103,0,67,101,108,108,87,105,100,116,104,0,67,101,108,108,76,101,110,103,116,104,0,70,105,108,108,79,114,100,101,114,0,68,111,99,117,109,101,110,116,78,97,109,101,0,73,109,97,103,101,68,101,115,99,114,105,112,116,105,111,110,0,77,97,107,101,0,77,111,100,101,108,0,79,114,105,101,110,116,97,116,105,111,110,0,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,0,82,111,119,115,80,101,114,83,116,114,105,112,0,77,105,110,83,97,109,112,108,101,86,97,108,117,101,0,77,97,120,83,97,109,112,108,101,86,97,108,117,101,0,88,82,101,115,111,108,117,116,105,111,110,0,89,82,101,115,111,108,117,116,105,111,110,0,80,108,97,110,97,114,67,111,110,102,105,103,117,114,97,116,105,111,110,0,80,97,103,101,78,97,109,101,0,88,80,111,115,105,116,105,111,110,0,89,80,111,115,105,116,105,111,110,0,70,114,101,101,79,102,102,115,101,116,115,0,70,114,101,101,66,121,116,101,67,111,117,110,116,115,0,71,114,97,121,82,101,115,112,111,110,115,101,85,110,105,116,0,71,114,97,121,82,101,115,112,111,110,115,101,67,117,114,118,101,0,82,101,115,111,108,117,116,105,111,110,85,110,105,116,0,80,97,103,101,78,117,109,98,101,114,0,67,111,108,111,114,82,101,115,112,111,110,115,101,85,110,105,116,0,84,114,97,110,115,102,101,114,70,117,110,99,116,105,111,110,0,83,111,102,116,119,97,114,101,0,68,97,116,101,84,105,109,101,0,65,114,116,105,115,116,0,72,111,115,116,67,111,109,112,117,116,101,114,0,87,104,105,116,101,80,111,105,110,116,0,80,114,105,109,97,114,121,67,104,114,111,109,97,116,105,99,105,116,105,101,115,0,67,111,108,111,114,77,97,112,0,72,97,108,102,116,111,110,101,72,105,110,116,115,0,84,105,108,101,87,105,100,116,104,0,84,105,108,101,76,101,110,103,116,104,0,84,105,108,101,66,121,116,101,67,111,117,110,116,115,0,83,117,98,73,70,68,0,73,110,107,78,97,109,101,115,0,78,117,109,98,101,114,79,102,73,110,107,115,0,68,111,116,82,97,110,103,101,0,84,97,114,103,101,116,80,114,105,110,116,101,114,0,69,120,116,114,97,83,97,109,112,108,101,115,0,83,97,109,112,108,101,70,111,114,109,97,116,0,83,77,105,110,83,97,109,112,108,101,86,97,108,117,101,0,83,77,97,120,83,97,109,112,108,101,86,97,108,117,101,0,67,108,105,112,80,97,116,104,0,88,67,108,105,112,80,97,116,104,85,110,105,116,115,0,89,67,108,105,112,80,97,116,104,85,110,105,116,115,0,89,67,98,67,114,67,111,101,102,102,105,99,105,101,110,116,115,0,89,67,98,67,114,83,117,98,115,97,109,112,108,105,110,103,0,89,67,98,67,114,80,111,115,105,116,105,111,110,105,110,103,0,82,101,102,101,114,101,110,99,101,66,108,97,99,107,87,104,105,116,101,0,88,77,76,80,97,99,107,101,116,0,77,97,116,116,101,105,110,103,0,68,97,116,97,84,121,112,101,0,73,109,97,103,101,68,101,112,116,104,0,84,105,108,101,68,101,112,116,104,0,73,109,97,103,101,70,117,108,108,87,105,100,116,104,0,73,109,97,103,101,70,117,108,108,76,101,110,103,116,104,0,84,101,120,116,117,114,101,70,111,114,109,97,116,0,84,101,120,116,117,114,101,87,114,97,112,77,111,100,101,115,0,70,105,101,108,100,79,102,86,105,101,119,67,111,116,97,110,103,101,110,116,0,77,97,116,114,105,120,87,111,114,108,100,84,111,83,99,114,101,101,110,0,77,97,116,114,105,120,87,111,114,108,100,84,111,67,97,109,101,114,97,0,67,70,65,82,101,112,101,97,116,80,97,116,116,101,114,110,68,105,109,0,67,111,112,121,114,105,103,104,116,0,82,105,99,104,84,73,70,70,73,80,84,67,0,80,104,111,116,111,115,104,111,112,0,69,88,73,70,73,70,68,79,102,102,115,101,116,0,73,67,67,32,80,114,111,102,105,108,101,0,71,80,83,73,70,68,79,102,102,115,101,116,0,70,97,120,82,101,99,118,80,97,114,97,109,115,0,70,97,120,83,117,98,65,100,100,114,101,115,115,0,70,97,120,82,101,99,118,84,105,109,101,0,70,97,120,68,99,115,0,83,116,111,78,105,116,115,0,73,110,116,101,114,111,112,101,114,97,98,105,108,105,116,121,73,70,68,79,102,102,115,101,116,0,68,78,71,86,101,114,115,105,111,110,0,68,78,71,66,97,99,107,119,97,114,100,86,101,114,115,105,111,110,0,85,110,105,113,117,101,67,97,109,101,114,97,77,111,100,101,108,0,76,111,99,97,108,105,122,101,100,67,97,109,101,114,97,77,111,100,101,108,0,67,70,65,80,108,97,110,101,67,111,108,111,114,0,67,70,65,76,97,121,111,117,116,0,76,105,110,101,97,114,105,122,97,116,105,111,110,84,97,98,108,101,0,66,108,97,99,107,76,101,118,101,108,82,101,112,101,97,116,68,105,109,0,66,108,97,99,107,76,101,118,101,108,0,66,108,97,99,107,76,101,118,101,108,68,101,108,116,97,72,0,66,108,97,99,107,76,101,118,101,108,68,101,108,116,97,86,0,87,104,105,116,101,76,101,118,101,108,0,68,101,102,97,117,108,116,83,99,97,108,101,0,66,101,115,116,81,117,97,108,105,116,121,83,99,97,108,101,0,68,101,102,97,117,108,116,67,114,111,112,79,114,105,103,105,110,0,68,101,102,97,117,108,116,67,114,111,112,83,105,122,101,0,67,111,108,111,114,77,97,116,114,105,120,49,0,67,111,108,111,114,77,97,116,114,105,120,50,0,67,97,109,101,114,97,67,97,108,105,98,114,97,116,105,111,110,49,0,67,97,109,101,114,97,67,97,108,105,98,114,97,116,105,111,110,50,0,82,101,100,117,99,116,105,111,110,77,97,116,114,105,120,49,0,82,101,100,117,99,116,105,111,110,77,97,116,114,105,120,50,0,65,110,97,108,111,103,66,97,108,97,110,99,101,0,65,115,83,104,111,116,78,101,117,116,114,97,108,0,65,115,83,104,111,116,87,104,105,116,101,88,89,0,66,97,115,101,108,105,110,101,69,120,112,111,115,117,114,101,0,66,97,115,101,108,105,110,101,78,111,105,115,101,0,66,97,115,101,108,105,110,101,83,104,97,114,112,110,101,115,115,0,66,97,121,101,114,71,114,101,101,110,83,112,108,105,116,0,76,105,110,101,97,114,82,101,115,112,111,110,115,101,76,105,109,105,116,0,67,97,109,101,114,97,83,101,114,105,97,108,78,117,109,98,101,114,0,76,101,110,115,73,110,102,111,0,67,104,114,111,109,97,66,108,117,114,82,97,100,105,117,115,0,65,110,116,105,65,108,105,97,115,83,116,114,101,110,103,116,104,0,83,104,97,100,111,119,83,99,97,108,101,0,68,78,71,80,114,105,118,97,116,101,68,97,116,97,0,77,97,107,101,114,78,111,116,101,83,97,102,101,116,121,0,67,97,108,105,98,114,97,116,105,111,110,73,108,108,117,109,105,110,97,110,116,49,0,67,97,108,105,98,114,97,116,105,111,110,73,108,108,117,109,105,110,97,110,116,50,0,82,97,119,68,97,116,97,85,110,105,113,117,101,73,68,0,79,114,105,103,105,110,97,108,82,97,119,70,105,108,101,78,97,109,101,0,79,114,105,103,105,110,97,108,82,97,119,70,105,108,101,68,97,116,97,0,65,99,116,105,118,101,65,114,101,97,0,77,97,115,107,101,100,65,114,101,97,115,0,65,115,83,104,111,116,73,67,67,80,114,111,102,105,108,101,0,65,115,83,104,111,116,80,114,101,80,114,111,102,105,108,101,77,97,116,114,105,120,0,67,117,114,114,101,110,116,73,67,67,80,114,111,102,105,108,101,0,67,117,114,114,101,110,116,80,114,101,80,114,111,102,105,108,101,77,97,116,114,105,120,0,80,101,114,83,97,109,112,108,101,0,73,110,100,101,120,101,100,0,71,108,111,98,97,108,80,97,114,97,109,101,116,101,114,115,73,70,68,0,80,114,111,102,105,108,101,84,121,112,101,0,70,97,120,80,114,111,102,105,108,101,0,67,111,100,105,110,103,77,101,116,104,111,100,115,0,86,101,114,115,105,111,110,89,101,97,114,0,77,111,100,101,78,117,109,98,101,114,0,68,101,99,111,100,101,0,73,109,97,103,101,66,97,115,101,67,111,108,111,114,0,84,56,50,79,112,116,105,111,110,115,0,83,116,114,105,112,82,111,119,67,111,117,110,116,115,0,73,109,97,103,101,76,97,121,101,114,0,84,73,70,70,67,104,101,99,107,68,105,114,79,102,102,115,101,116,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,109,111,114,101,32,116,104,97,110,32,54,53,53,51,53,32,84,73,70,70,32,100,105,114,101,99,116,111,114,105,101,115,0,102,111,114,32,73,70,68,32,108,105,115,116,0,84,73,70,70,82,101,97,100,68,105,114,101,99,116,111,114,121,0,70,97,105,108,101,100,32,116,111,32,114,101,97,100,32,100,105,114,101,99,116,111,114,121,32,97,116,32,111,102,102,115,101,116,32,37,108,117,0,84,73,70,70,82,101,97,100,68,105,114,101,99,116,111,114,121,67,104,101,99,107,79,114,100,101,114,0,73,110,118,97,108,105,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,59,32,116,97,103,115,32,97,114,101,32,110,111,116,32,115,111,114,116,101,100,32,105,110,32,97,115,99,101,110,100,105,110,103,32,111,114,100,101,114,0,85,110,107,110,111,119,110,32,102,105,101,108,100,32,119,105,116,104,32,116,97,103,32,37,100,32,40,48,120,37,120,41,32,101,110,99,111,117,110,116,101,114,101,100,0,82,101,103,105,115,116,101,114,105,110,103,32,97,110,111,110,121,109,111,117,115,32,102,105,101,108,100,32,119,105,116,104,32,116,97,103,32,37,100,32,40,48,120,37,120,41,32,102,97,105,108,101,100,0,102,105,105,32,33,61,32,70,65,73,76],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+122916);allocate([69,68,95,70,73,73,0,116,105,102,95,100,105,114,114,101,97,100,46,99,0,80,108,97,110,97,114,99,111,110,102,105,103,32,116,97,103,32,118,97,108,117,101,32,97,115,115,117,109,101,100,32,105,110,99,111,114,114,101,99,116,44,32,97,115,115,117,109,105,110,103,32,100,97,116,97,32,105,115,32,99,111,110,116,105,103,32,105,110,115,116,101,97,100,32,111,102,32,99,104,117,110,107,121,0,77,105,115,115,105,110,103,82,101,113,117,105,114,101,100,0,84,73,70,70,32,100,105,114,101,99,116,111,114,121,32,105,115,32,109,105,115,115,105,110,103,32,114,101,113,117,105,114,101,100,32,34,37,115,34,32,102,105,101,108,100,0,73,109,97,103,101,76,101,110,103,116,104,0,116,105,108,101,115,0,115,116,114,105,112,115,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,122,101,114,111,32,110,117,109,98,101,114,32,111,102,32,37,115,0,84,105,108,101,79,102,102,115,101,116,115,0,83,116,114,105,112,79,102,102,115,101,116,115,0,117,110,107,110,111,119,110,32,116,97,103,110,97,109,101,0,73,103,110,111,114,105,110,103,32,37,115,32,115,105,110,99,101,32,66,105,116,115,80,101,114,83,97,109,112,108,101,32,116,97,103,32,110,111,116,32,102,111,117,110,100,0,80,104,111,116,111,109,101,116,114,105,99,32,116,97,103,32,105,115,32,109,105,115,115,105,110,103,44,32,97,115,115,117,109,105,110,103,32,100,97,116,97,32,105,115,32,89,67,98,67,114,0,80,104,111,116,111,109,101,116,114,105,99,32,116,97,103,32,118,97,108,117,101,32,97,115,115,117,109,101,100,32,105,110,99,111,114,114,101,99,116,44,32,97,115,115,117,109,105,110,103,32,100,97,116,97,32,105,115,32,89,67,98,67,114,32,105,110,115,116,101,97,100,32,111,102,32,82,71,66,0,66,105,116,115,80,101,114,83,97,109,112,108,101,32,116,97,103,32,105,115,32,109,105,115,115,105,110,103,44,32,97,115,115,117,109,105,110,103,32,56,32,98,105,116,115,32,112,101,114,32,115,97,109,112,108,101,0,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,32,116,97,103,32,105,115,32,109,105,115,115,105,110,103,44,32,97,115,115,117,109,105,110,103,32,99,111,114,114,101,99,116,32,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,32,118,97,108,117,101,32,105,115,32,51,0,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,32,116,97,103,32,105,115,32,109,105,115,115,105,110,103,44,32,97,112,112,108,121,105,110,103,32,99,111,114,114,101,99,116,32,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,32,118,97,108,117,101,32,111,102,32,51,0,67,111,108,111,114,109,97,112,0,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,0,84,73,70,70,32,100,105,114,101,99,116,111,114,121,32,105,115,32,109,105,115,115,105,110,103,32,114,101,113,117,105,114,101,100,32,34,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,34,32,102,105,101,108,100,44,32,99,97,108,99,117,108,97,116,105,110,103,32,102,114,111,109,32,105,109,97,103,101,108,101,110,103,116,104,0,66,111,103,117,115,32,34,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,34,32,102,105,101,108,100,44,32,105,103,110,111,114,105,110,103,32,97,110,100,32,99,97,108,99,117,108,97,116,105,110,103,32,102,114,111,109,32,105,109,97,103,101,108,101,110,103,116,104,0,87,114,111,110,103,32,34,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,34,32,102,105,101,108,100,44,32,105,103,110,111,114,105,110,103,32,97,110,100,32,99,97,108,99,117,108,97,116,105,110,103,32,102,114,111,109,32,105,109,97,103,101,108,101,110,103,116,104,0,102,111,114,32,99,104,111,112,112,101,100,32,34,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,34,32,97,114,114,97,121,0,102,111,114,32,99,104,111,112,112,101,100,32,34,83,116,114,105,112,79,102,102,115,101,116,115,34,32,97,114,114,97,121,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,122,101,114,111,32,115,99,97,110,108,105,110,101,32,115,105,122,101,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,122,101,114,111,32,116,105,108,101,32,115,105,122,101,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,122,101,114,111,32,115,116,114,105,112,32,115,105,122,101,0,102,111,114,32,34,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,34,32,97,114,114,97,121,0,69,115,116,105,109,97,116,101,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,0,67,97,110,110,111,116,32,100,101,116,101,114,109,105,110,101,32,115,105,122,101,32,111,102,32,117,110,107,110,111,119,110,32,116,97,103,32,116,121,112,101,32,37,100,0,84,73,70,70,70,101,116,99,104,83,116,114,105,112,84,104,105,110,103,0,102,111,114,32,115,116,114,105,112,32,97,114,114,97,121,0,40,116,109,115,105,122,101,95,116,41,100,97,116,97,115,105,122,101,62,48,0,84,73,70,70,82,101,97,100,68,105,114,69,110,116,114,121,65,114,114,97,121,0,82,101,97,100,68,105,114,69,110,116,114,121,65,114,114,97,121,0,73,110,99,111,114,114,101,99,116,32,99,111,117,110,116,32,102,111,114,32,34,37,115,34,0,73,110,99,111,109,112,97,116,105,98,108,101,32,116,121,112,101,32,102,111,114,32,34,37,115,34,0,73,79,32,101,114,114,111,114,32,100,117,114,105,110,103,32,114,101,97,100,105,110,103,32,111,102,32,34,37,115,34,0,73,110,99,111,114,114,101,99,116,32,118,97,108,117,101,32,102,111,114,32,34,37,115,34,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,100,105,102,102,101,114,101,110,116,32,118,97,108,117,101,115,32,112,101,114,32,115,97,109,112,108,101,32,102,111,114,32,34,37,115,34,0,83,97,110,105,116,121,32,99,104,101,99,107,32,111,110,32,115,105,122,101,32,111,102,32,34,37,115,34,32,118,97,108,117,101,32,102,97,105,108,101,100,0,79,117,116,32,111,102,32,109,101,109,111,114,121,32,114,101,97,100,105,110,103,32,111,102,32,34,37,115,34,0,84,73,70,70,82,101,97,100,68,105,114,69,110,116,114,121,79,117,116,112,117,116,69,114,114,0,73,110,99,111,114,114,101,99,116,32,99,111,117,110,116,32,102,111,114,32,34,37,115,34,59,32,116,97,103,32,105,103,110,111,114,101,100,0,73,110,99,111,109,112,97,116,105,98,108,101,32,116,121,112,101,32,102,111,114,32,34,37,115,34,59,32,116,97,103,32,105,103,110,111,114,101,100,0,73,79,32,101,114,114,111,114,32,100,117,114,105,110,103,32,114,101,97,100,105,110,103,32,111,102,32,34,37,115,34,59,32,116,97,103,32,105,103,110,111,114,101,100,0,73,110,99,111,114,114,101,99,116,32,118,97,108,117,101,32,102,111,114,32,34,37,115,34,59,32,116,97,103,32,105,103,110,111,114,101,100,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,100,105,102,102,101,114,101,110,116,32,118,97,108,117,101,115,32,112,101,114,32,115,97,109,112,108,101,32,102,111,114,32,34,37,115,34,59,32,116,97,103,32,105,103,110,111,114,101,100,0,83,97,110,105,116,121,32,99,104,101,99,107,32,111,110,32,115,105,122,101,32,111,102,32,34,37,115,34,32,118,97,108,117,101,32,102,97,105,108,101,100,59,32,116,97,103,32,105,103,110,111,114,101,100,0,79,117,116,32,111,102,32,109,101,109,111,114,121,32,114,101,97,100,105,110,103,32,111,102,32,34,37,115,34,59,32,116,97,103,32,105,103,110,111,114,101,100,0,84,73,70,70,70,101,116,99,104,78,111,114,109,97,108,84,97,103,0,78,111,32,100,101,102,105,110,105,116,105,111,110,32,102,111,117,110,100,32,102,111,114,32,116,97,103,32,37,100,0,102,105,112,32,33,61,32,78,85,76,76,0,102,105,112,45,62,115,101,116,95,102,105,101,108,100,95,116,121,112,101,33,61,84,73,70,70,95,83,69,84,71,69,84,95,79,84,72,69,82,0,102,105,112,45,62,115,101,116,95,102,105,101,108,100,95,116,121,112,101,33,61,84,73,70,70,95,83,69,84,71,69,84,95,73,78,84,0,102,105,112,45,62,102,105,101,108,100,95,112,97,115,115,99,111,117,110,116,61,61,48,0,65,83,67,73,73,32,118,97,108,117,101,32,102,111,114,32,116,97,103,32,34,37,115,34,32,99,111,110,116,97,105,110,115,32,110,117,108,108,32,98,121,116,101,32,105,110,32,118,97,108,117,101,59,32,118,97,108,117,101,32,105,110,99,111,114,114,101,99,116,108,121,32,116,114,117,110,99,97,116,101,100,32,100,117,114,105,110,103,32,114,101,97,100,105,110,103,32,100,117,101,32,116,111,32,105,109,112,108,101,109,101,110,116,97,116,105,111,110,32,108,105,109,105,116,97,116,105,111,110,115,0,65,83,67,73,73,32,118,97,108,117,101,32,102,111,114,32,116,97,103,32,34,37,115,34,32,100,111,101,115,32,110,111,116,32,101,110,100,32,105,110,32,110,117,108,108,32,98,121,116,101,0,102,105,112,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,49,0,102,105,112,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,50,0,105,110,99,111,114,114,101,99,116,32,99,111,117,110,116,32,102,111,114,32,102,105,101,108,100,32,34,37,115,34,44,32,101,120,112,101,99,116,101,100,32,50,44,32,103,111,116,32,37,100,0,102,105,112,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,62,61,49,0,105,110,99,111,114,114,101,99,116,32,99,111,117,110,116,32,102,111,114,32,102,105,101,108,100,32,34,37,115,34,44,32,101,120,112,101,99,116,101,100,32,37,100,44,32,103,111,116,32,37,100,0,102,105,112,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,84,73,70,70,95,86,65,82,73,65,66,76,69,0,102,105,112,45,62,102,105,101,108,100,95,112,97,115,115,99,111,117,110,116,61,61,49,0,102,105,112,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,84,73,70,70,95,86,65,82,73,65,66,76,69,50,0,112,100,105,114,0,84,73,70,70,70,101,116,99,104,68,105,114,101,99,116,111,114,121,0,83,97,110,105,116,121,32,99,104,101,99,107,32,111,110,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,32,102,97,105,108,101,100,44,32,116,104,105,115,32,105,115,32,112,114,111,98,97,98,108,121,32,110,111,116,32,97,32,118,97,108,105,100,32,73,70,68,32,111,102,102,115,101,116,0,116,111,32,114,101,97,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,0,37,46,49,48,48,115,58,32,67,97,110,32,110,111,116,32,114,101,97,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,0,67,97,110,32,110,111,116,32,114,101,97,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,0,83,97,110,105,116,121,32,99,104,101,99,107,32,111,110,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,32,102,97,105,108,101,100,44,32,122,101,114,111,32,116,97,103,32,100,105,114,101,99,116,111,114,105,101,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,67,97,110,32,110,111,116,32,114,101,97,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,0,83,111,114,114,121,44,32,114,101,113,117,101,115,116,101,100,32,99,111,109,112,114,101,115,115,105,111,110,32,109,101,116,104,111,100,32,105,115,32,110,111,116,32,99,111,110,102,105,103,117,114,101,100,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,105,109,97,103,101,115,32,119,105,116,104,32,37,100,45,98,105,116,32,115,97,109,112,108,101,115,0,77,105,115,115,105,110,103,32,110,101,101,100,101,100,32,37,115,32,116,97,103,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,99,111,110,116,105,103,117,111,117,115,32,100,97,116,97,32,119,105,116,104,32,37,115,61,37,100,44,32,97,110,100,32,37,115,61,37,100,32,97,110,100,32,66,105,116,115,47,83,97,109,112,108,101,61,37,100,0,83,97,109,112,108,101,115,47,112,105,120,101,108,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,82,71,66,32,105,109,97,103,101,32,119,105,116,104,32,37,115,61,37,100,0,67,111,108,111,114,32,99,104,97,110,110,101,108,115,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,115,101,112,97,114,97,116,101,100,32,105,109,97,103,101,32,119,105,116,104,32,37,115,61,37,100,0,73,110,107,83,101,116,0,83,111,114,114,121,44,32,76,111,103,76,32,100,97,116,97,32,109,117,115,116,32,104,97,118,101,32,37,115,61,37,100,0,67,111,109,112,114,101,115,115,105,111,110,0,83,111,114,114,121,44,32,76,111,103,76,117,118,32,100,97,116,97,32,109,117,115,116,32,104,97,118,101,32,37,115,61,37,100,32,111,114,32,37,100,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,76,111,103,76,117,118,32,105,109,97,103,101,115,32,119,105,116,104,32,37,115,61,37,100,0,80,108,97,110,97,114,99,111,110,102,105,103,117,114,97,116,105,111,110,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,105,109,97,103,101,32,119,105,116,104,32,37,115,61,37,100,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,105,109,97,103,101,32,119,105,116,104,32,37,115,61,37,100,32,97,110,100,32,37,115,61,37,100,0,66,105,116,115,47,115,97,109,112,108,101,0,77,105,115,115,105,110,103,32,114,101,113,117,105,114,101,100,32,34,67,111,108,111,114,109,97,112,34,32,116,97,103,0,79,117,116,32,111,102,32,109,101,109,111,114,121,32,102,111,114,32,99,111,108,111,114,109,97,112,32,99,111,112,121,0,105,109,103,45,62,85,97,84,111,65,97,61,61,78,85,76,76,0,116,105,102,95,103,101,116,105,109,97,103,101,46,99,0,66,117,105,108,100,77,97,112,85,97,84,111,65,97,0,105,109,103,45,62,66,105,116,100,101,112,116,104,49,54,84,111,56,61,61,78,85,76,76,0,66,117,105,108,100,77,97,112,66,105,116,100,101,112,116,104,49,54,84,111,56,0,105,110,105,116,67,73,69,76,97,98,67,111,110,118,101,114,115,105,111,110,0,78,111,32,115,112,97,99,101,32,102,111,114,32,67,73,69,32,76,42,97,42,98,42,45,62,82,71,66,32,99,111,110,118,101,114,115,105,111,110,32,115,116,97,116,101,46,0,70,97,105,108,101,100,32,116,111,32,105,110,105,116,105,97,108,105,122,101,32,67,73,69,32,76,42,97,42,98,42,45,62,82,71,66,32,99,111,110,118,101,114,115,105,111,110,32,115,116,97,116,101,46,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,105,109,97,103,101,0,78,111,32,34,103,101,116,34,32,114,111,117,116,105,110,101,32,115,101,116,117,112,0,78,111,32,34,112,117,116,34,32,114,111,117,116,105,110,101,32,115,101,116,117,112,108,59,32,112,114,111,98,97,98,108,121,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,105,109,97,103,101,32,102,111,114,109,97,116,0,103,116,83,116,114,105,112,83,101,112,97,114,97,116,101,0,78,111,32,115,112,97,99,101,32,102,111,114,32,116,105,108,101,32,98,117,102,102,101,114,0,103,116,84,105,108,101,83,101,112,97,114,97,116,101,0,105,110,105,116,89,67,98,67,114,67,111,110,118,101,114,115,105,111,110,0,78,111,32,115,112,97,99,101,32,102,111,114,32,89,67,98,67,114,45,62,82,71,66,32,99,111,110,118,101,114,115,105,111,110,32,115,116,97,116,101,0,78,111,32,115,112,97,99,101,32,102,111,114,32,112,104,111,116,111,109,101,116,114,105,99,32,99,111,110,118,101,114,115,105,111,110,32,116,97,98,108,101,0,78,111,32,115,112,97,99,101,32,102,111,114,32,66,38,87,32,109,97,112,112,105,110,103,32,116,97,98,108,101,0,65,115,115,117,109,105,110,103,32,56,45,98,105,116,32,99,111,108,111,114,109,97,112,0,78,111,32,115,112,97,99,101,32,102,111,114,32,80,97,108,101,116,116,101,32,109,97,112,112,105,110,103,32,116,97,98,108,101,0,73,110,118,97,108,105,100,32,118,101,114,116,105,99,97,108,32,89,67,98,67,114,32,115,117,98,115,97,109,112,108,105,110,103,0,78,111,32,115,112,97,99,101,32,102,111,114,32,115,116,114,105,112,32,98,117,102,102,101,114,0,34,37,115,34,58,32,66,97,100,32,109,111,100,101,0,84,73,70,70,67,108,105,101,110,116,79,112,101,110,0,37,115,58,32,79,117,116,32,111,102,32,109,101,109,111,114,121,32,40,84,73,70,70,32,115,116,114,117,99,116,117,114,101,41,0,79,110,101,32,111,102,32,116,104,101,32,99,108,105,101,110,116,32,112,114,111,99,101,100,117,114,101,115,32,105,115,32,78,85,76,76,32,112,111,105,110,116,101,114,46,0,67,97,110,110,111,116,32,114,101,97,100,32,84,73,70,70,32,104,101,97,100,101,114,0,78,111,116,32,97,32,84,73,70,70,32,111,114,32,77,68,73,32,102,105,108,101,44,32,98,97,100,32,109,97,103,105,99,32,110,117,109,98,101,114,32,37,100,32,40,48,120,37,120,41,0,78,111,116,32,97,32,84,73,70,70,32,102,105,108,101,44,32,98,97,100,32,118,101,114,115,105,111,110,32,110,117,109,98,101,114,32,37,100,32,40,48,120,37,120,41,0,78,111,116,32,97,32,84,73,70,70,32,102,105,108,101,44,32,98,97,100,32,66,105,103,84,73,70,70,32,111,102,102,115,101,116,115,105,122,101,32,37,100,32,40,48,120,37,120,41,0,78,111,116,32,97,32,84,73,70,70,32,102,105,108,101,44,32,98,97,100,32,66,105,103,84,73,70,70,32,117,110,117,115,101,100,32,37,100,32,40,48,120,37,120,41,0,40,116,111,102,102,95,116,41,116,105,102,45,62,116,105,102,95,115,105,122,101,61,61,110,0,116,105,102,95,111,112,101,110,46,99,0,70,105,108,101,32,110,111,116,32,111,112,101,110,32,102,111,114,32,114,101,97,100,105,110,103,0,67,97,110,32,110,111,116,32,114,101,97,100,32,115,99,97,110,108,105,110,101,115,32,102,114,111,109,32,97,32,116,105,108,101,100,32,105,109,97,103,101,0,40,116,105,102,45,62,116,105,102,95,102,108,97,103,115,38,84,73,70,70,95,78,79,82,69,65,68,82,65,87,41,61,61,48,0,116,105,102,95,114,101,97,100,46,99,0,84,73,70,70,82,101,97,100,66,117,102,102,101,114,83,101,116,117,112,0,73,110,118,97,108,105,100,32,98,117,102,102,101,114,32,115,105,122,101,0,83,101,101,107,32,101,114,114,111,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,44,32,115,116,114,105,112,32,37,108,117,0,82,101,97,100,32,101,114,114,111,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,59,32,103,111,116,32,37,108,108,117,32,98,121,116,101,115,44,32,101,120,112,101,99,116,101,100,32,37,108,108,117,0,84,73,70,70,82,101,97,100,69,110,99,111,100,101,100,83,116,114,105,112,0,37,108,117,58,32,83,116,114,105,112,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,109,97,120,32,37,108,117,0,84,73,70,70,70,105,108,108,83,116,114,105,112,0,73,110,118,97,108,105,100,32,115,116,114,105,112,32,98,121,116,101,32,99,111,117,110,116,32,37,108,108,117,44,32,115,116,114,105,112,32,37,108,117,0,82,101,97,100,32,101,114,114,111,114,32,111,110,32,115,116,114,105,112,32,37,108,117,59,32,103,111,116,32,37,108,108,117,32,98,121,116,101,115,44,32,101,120,112,101,99,116,101,100,32,37,108,108,117,0,68,97,116,97,32,98,117,102,102,101,114,32,116,111,111,32,115,109,97,108,108,32,116,111,32,104,111,108,100,32,115,116,114,105,112,32,37,108,117,0,78,111,32,115,112,97,99,101,32,102,111,114,32,100,97,116,97,32,98,117,102,102,101,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,0,67,97,110,32,110,111,116,32,114,101,97,100,32,116,105,108,101,115,32,102,114,111,109,32,97,32,115,116,114,105,112,112,101,100,32,105,109,97,103,101,0,84,73,70,70,82,101,97,100,69,110,99,111,100,101,100,84,105,108,101,0,37,108,117,58,32,84,105,108,101,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,109,97,120,32,37,108,117,0,84,73,70,70,70,105,108,108,84,105,108,101,0,37,108,108,117,58,32,73,110,118,97,108,105,100,32,116,105,108,101,32,98,121,116,101,32,99,111,117,110,116,44,32,116,105,108,101,32,37,108,117,0,68,97,116,97,32,98,117,102,102,101,114,32,116,111,111,32,115,109,97,108,108,32,116,111,32,104,111,108,100,32,116,105,108,101,32,37,108,117,0,84,73,70,70,83,116,97,114,116,84,105,108,101,0,90,101,114,111,32,116,105,108,101,115,0,40,99,99,32,38,32,49,41,32,61,61,32,48,0,95,84,73,70,70,83,119,97,98,49,54,66,105,116,68,97,116,97,0,40,99,99,32,37,32,51,41,32,61,61,32,48,0,95,84,73,70,70,83,119,97,98,50,52,66,105,116,68,97,116,97,0,40,99,99,32,38,32,51,41,32,61,61,32,48,0,95,84,73,70,70,83,119,97,98,51,50,66,105,116,68,97,116,97,0,40,99,99,32,38,32,55,41,32,61,61,32,48,0,95,84,73,70,70,83,119,97,98,54,52,66,105,116,68,97,116,97,0,84,73,70,70,82,101,97,100,82,97,119,84,105,108,101,49,0,83,101,101,107,32,101,114,114,111,114,32,97,116,32,114,111,119,32,37,108,117,44,32,99,111,108,32,37,108,117,44,32,116,105,108,101,32,37,108,117,0,82,101,97,100,32,101,114,114,111,114,32,97,116,32,114,111,119,32,37,108,117,44,32,99,111,108,32,37,108,117,59,32,103,111,116,32,37,108,108,117,32,98,121,116,101,115,44,32,101,120,112,101,99,116,101,100,32,37,108,108,117,0,82,101,97,100,32,101,114,114,111,114,32,97,116,32,114,111,119,32,37,108,117,44,32,99,111,108,32,37,108,117,44,32,116,105,108,101,32,37,108,117,59,32,103,111,116,32,37,108,108,117,32,98,121,116,101,115,44,32,101,120,112,101,99,116,101,100,32,37,108,108,117,0,84,73,70,70,82,101,97,100,82,97,119,83,116,114,105,112,49,0,82,101,97,100,32,101,114,114,111,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,44,32,115,116,114,105,112,32,37,108,117,59,32,103,111,116,32,37,108,108,117,32,98,121,116,101,115,44,32,101,120,112,101,99,116,101,100,32,37,108,108,117,0,84,73,70,70,67,111,109,112,117,116,101,83,116,114,105,112,0,84,73,70,70,78,117,109,98,101,114,79,102,83,116,114,105,112,115,0,84,73,70,70,86,83,116,114,105,112,83,105,122,101,54,52,0,73,110,118,97,108,105,100,32,116,100,95,115,97,109,112,108,101,115,112,101,114,112,105,120,101,108,32,118,97,108,117,101,0,84,73,70,70,83,99,97,110,108,105,110,101,83,105,122,101,54,52,0,73,110,118,97,108,105,100,32,89,67,98,67,114,32,115,117,98,115,97,109,112,108,105,110,103,0,67,111,109,112,117,116,101,100,32,115,99,97,110,108,105,110,101,32,115,105,122,101,32,105,115,32,122,101,114,111,0,84,73,70,70,86,83,116,114,105,112,83,105,122,101,0,84,73,70,70,83,116,114,105,112,83,105,122,101,0,84,73,70,70,83,99,97,110,108,105,110,101,83,105,122,101,0,73,110,116,101,103,101,114,32,97,114,105,116,104,109,101,116,105,99,32,111,118,101,114,102,108,111,119,0,0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253,3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243,11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251,7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247,15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,37,108,117,58,32,67,111,108,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,109,97,120,32,37,108,117,0,37,108,117,58,32,82,111,119,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,109,97,120,32,37,108,117,0,37,108,117,58,32,68,101,112,116,104,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,109,97,120,32,37,108,117,0,37,108,117,58,32,83,97,109,112,108,101,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,109,97,120,32,37,108,117,0,84,73,70,70,78,117,109,98,101,114,79,102,84,105,108,101,115,0,84,73,70,70,84,105,108,101,82,111,119,83,105,122,101,54,52,0,84,105,108,101,32,108,101,110,103,116,104,32,105,115,32,122,101,114,111,0,84,105,108,101,32,119,105,100,116,104,32,105,115,32,122,101,114,111,0,84,73,70,70,84,105,108,101,82,111,119,83,105,122,101,0,83,97,109,112,108,101,115,32,112,101,114,32,112,105,120,101,108,32,105,115,32,122,101,114,111,0,67,111,109,112,117,116,101,100,32,116,105,108,101,32,114,111,119,32,115,105,122,101,32,105,115,32,122,101,114,111,0,73,110,116,101,103,101,114,32,111,118,101,114,102,108,111,119,0,84,73,70,70,86,84,105,108,101,83,105,122,101,54,52,0,73,110,118,97,108,105,100,32,89,67,98,67,114,32,115,117,98,115,97,109,112,108,105,110,103,32,40,37,100,120,37,100,41,0,84,73,70,70,84,105,108,101,83,105,122,101,0,116,100,45,62,116,100,95,110,115,116,114,105,112,115,32,62,32,48,0,116,105,102,95,119,114,105,116,101,46,99,0,84,73,70,70,65,112,112,101,110,100,84,111,83,116,114,105,112,0,83,101,101,107,32,101,114,114,111,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,0,87,114,105,116,101,32,101,114,114,111,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,0,84,73,70,70,79,112,101,110,0,37,115,58,32,37,115,0,37,115,58,32,67,97,110,110,111,116,32,111,112,101,110,0,37,115,58,32,0,46,10,0,87,97,114,110,105,110,103,44,32,0,73,110,116,101,103,101,114,32,111,118,101,114,102,108,111,119,32,105,110,32,37,115,0,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,109,101,109,111,114,121,32,102,111,114,32,37,115,32,40,37,108,100,32,101,108,101,109,101,110,116,115,32,111,102,32,37,108,100,32,98,121,116,101,115,32,101,97,99,104,41,0,78,111,32,115,112,97,99,101,32,102,111,114,32,34,84,114,97,110,115,102,101,114,70,117,110,99,116,105,111,110,34,32,116,97,103,0,37,115,32,37,115,32,101,110,99,111,100,105,110,103,32,105,115,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,115,99,97,110,108,105,110,101,0,67,111,109,112,114,101,115,115,105,111,110,32,115,99,104,101,109,101,32,37,117,32,37,115,32,101,110,99,111,100,105,110,103,32,105,115,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,37,115,32,37,115,32,100,101,99,111,100,105,110,103,32,105,115,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,67,111,109,112,114,101,115,115,105,111,110,32,115,99,104,101,109,101,32,37,117,32,37,115,32,100,101,99,111,100,105,110,103,32,105,115,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,67,111,109,112,114,101,115,115,105,111,110,32,97,108,103,111,114,105,116,104,109,32,100,111,101,115,32,110,111,116,32,115,117,112,112,111,114,116,32,114,97,110,100,111,109,32,97,99,99,101,115,115,0,69,114,114,111,114,32,117,112,100,97,116,105,110,103,32,84,73,70,70,32,104,101,97,100,101,114,0,84,73,70,70,82,101,119,114,105,116,101,68,105,114,101,99,116,111,114,121,0,69,114,114,111,114,32,102,101,116,99,104,105,110,103,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,0,69,114,114,111,114,32,102,101,116,99,104,105,110,103,32,100,105,114,101,99,116,111,114,121,32,108,105,110,107,0,69,114,114,111,114,32,119,114,105,116,105,110,103,32,100,105,114,101,99,116,111,114,121,32,108,105,110,107,0,83,97,110,105,116,121,32,99,104,101,99,107,32,111,110,32,116,97,103,32,99,111,117,110,116,32,102,97,105,108,101,100,44,32,108,105,107,101,108,121,32,99,111,114,114,117,112,116,32,84,73,70,70,0,84,73,70,70,82,101,115,101,116,70,105,101,108,100,0,77,101,109,111,114,121,32,109,97,112,112,101,100,32,102,105,108,101,115,32,110,111,116,32,99,117,114,114,101,110,116,108,121,32,115,117,112,112,111,114,116,101,100,32,102,111,114,32,116,104,105,115,32,111,112,101,114,97,116,105,111,110,46,0,65,116,116,101,109,112,116,32,116,111,32,114,101,115,101,116,32,102,105,101,108,100,32,111,110,32,100,105,114,101,99,116,111,114,121,32,110,111,116,32,97,108,114,101,97,100,121,32,111,110,32,100,105,115,107,46,0,37,115,58,32,83,101,101,107,32,101,114,114,111,114,32,97,99,99,101,115,115,105,110,103,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,0,37,115,58,32,67,97,110,32,110,111,116,32,114,101,97,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,0,37,115,58,32,67,97,110,32,110,111,116,32,114,101,97,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,32,101,110,116,114,121,46,0,37,115,58,32,67,111,117,108,100,32,110,111,116,32,102,105,110,100,32,116,97,103,32,37,100,46,0,102,111,114,32,102,105,101,108,100,32,98,117,102,102,101,114,46,0,86,97,108,117,101,32,101,120,99,101,101,100,115,32,51,50,98,105,116,32,114,97,110,103,101,32,111,102,32,111,117,116,112,117,116,32,116,121,112,101,46,0,37,115,58,32,67,97,110,32,110,111,116,32,119,114,105,116,101,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,32,101,110,116,114,121,46,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,83,101,99,0,69,114,114,111,114,32,112,111,115,116,45,101,110,99,111,100,105,110,103,32,98,101,102,111,114,101,32,100,105,114,101,99,116,111,114,121,32,119,114,105,116,101,0,69,114,114,111,114,32,102,108,117,115,104,105,110,103,32,100,97,116,97,32,98,101,102,111,114,101,32,100,105,114,101,99,116,111,114,121,32,119,114,105,116,101,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,83,104,111,114,116,80,101,114,83,97,109,112,108,101,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,111,108,111,114,109,97,112,0,99,111,117,110,116,60,48,120,56,48,48,48,48,48,48,48,0,116,105,102,95,100,105,114,119,114,105,116,101,46,99,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,83,104,111,114,116,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,84,114,97,110,115,102,101,114,102,117,110,99,116,105,111,110,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,83,117,98,105,102,100,0,112,97,32,33,61,32,48,0,42,112,97,32,60,61,32,48,120,70,70,70,70,70,70,70,70,85,76,0,111,45,62,102,105,101,108,100,95,116,121,112,101,61,61,84,73,70,70,95,65,83,67,73,73,0,111,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,84,73,70,70,95,86,65,82,73,65,66,76,69,0,111,45,62,102,105,101,108,100,95,112,97,115,115,99,111,117,110,116,61,61,48,0,111,45,62,102,105,101,108,100,95,116,121,112,101,61,61,84,73,70,70,95,83,72,79,82,84,0,111,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,49,0,111,45,62,102,105,101,108,100,95,116,121,112,101,61,61,84,73,70,70,95,76,79,78,71,0,111,45,62,102,105,101,108,100,95,116,121,112,101,61,61,84,73,70,70,95,85,78,68,69,70,73,78,69,68,0,111,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,84,73,70,70,95,86,65,82,73,65,66,76,69,50,0,111,45,62,102,105,101,108,100,95,112,97,115,115,99,111,117,110,116,61,61,49,0,48,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,83,115,104,111,114,116,65,114,114,97,121,0,99,111,117,110,116,60,48,120,52,48,48,48,48,48,48,48,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,76,111,110,103,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,83,108,111,110,103,65,114,114,97,121,0,99,111,117,110,116,60,48,120,50,48,48,48,48,48,48,48,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,76,111,110,103,56,65,114,114,97,121,0,116,105,102,45,62,116,105,102,95,102,108,97,103,115,38,84,73,70,70,95,66,73,71,84,73,70,70,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,83,108,111,110,103,56,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,83,114,97,116,105,111,110,97,108,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,70,108,111,97,116,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,68,111,117,98,108,101,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,73,102,100,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,73,102,100,56,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,73,102,100,73,102,100,56,65,114,114,97,121,0,65,116,116,101,109,112,116,32,116,111,32,119,114,105,116,101,32,118,97,108,117,101,32,108,97,114,103,101,114,32,116,104,97,110,32,48,120,70,70,70,70,70,70,70,70,32,105,110,32,67,108,97,115,115,105,99,32,84,73,70,70,32,102,105,108,101,46,0,84,73,70,70,76,105,110,107,68,105,114,101,99,116,111,114,121,0,69,114,114,111,114,32,119,114,105,116,105,110,103,32,83,117,98,73,70,68,32,100,105,114,101,99,116,111,114,121,32,108,105,110,107,0,69,114,114,111,114,32,119,114,105,116,105,110,103,32,84,73,70,70,32,104,101,97,100,101,114,0,77,97,120,105,109,117,109,32,84,73,70,70,32,102,105,108,101,32,115,105,122,101,32,101,120,99,101,101,100,101,100,0,110,97,60,110,100,105,114,0,73,79,32,101,114,114,111,114,32,119,114,105,116,105,110,103,32,100,105,114,101,99,116,111,114,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,82,97,116,105,111,110,97,108,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,83,97,109,112,108,101,102,111,114,109,97,116,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,76,111,110,103,76,111,110,103,56,65,114,114,97,121,0,118,97,108,117,101,62,61,48,46,48,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,82,97,116,105,111,110,97,108,0,100,105,114,91,109,93,46,116,100,105,114,95,116,97,103,33,61,116,97,103,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,68,97,116,97,0,73,79,32,101,114,114,111,114,32,119,114,105,116,105,110,103,32,116,97,103,32,100,97,116,97,0,100,97,116,97,108,101,110,103,116,104,60,48,120,56,48,48,48,48,48,48,48,85,76,0,78,111,110,101,0,76,90,87,0,80,97,99,107,66,105,116,115,0,84,104,117,110,100,101,114,83,99,97,110,0,78,101,88,84,0,74,80,69,71,0,79,108,100,45,115,116,121,108,101,32,74,80,69,71,0,67,67,73,84,84,32,82,76,69,0,67,67,73,84,84,32,82,76,69,47,87,0,67,67,73,84,84,32,71,114,111,117,112,32,51,0,67,67,73,84,84,32,71,114,111,117,112,32,52,0,73,83,79,32,74,66,73,71,0,68,101,102,108,97,116,101,0,65,100,111,98,101,68,101,102,108,97,116,101,0,80,105,120,97,114,76,111,103,0,83,71,73,76,111,103,0,83,71,73,76,111,103,50,52,0,76,90,77,65,0,37,100,0,37,115,32,99,111,109,112,114,101,115,115,105,111,110,32,115,117,112,112,111,114,116,32,105,115,32,110,111,116,32,99,111,110,102,105,103,117,114,101,100,0,110,32,62,32,48,0,116,105,102,95,100,117,109,112,109,111,100,101,46,99,0,68,117,109,112,77,111,100,101,69,110,99,111,100,101,0,68,117,109,112,77,111,100,101,68,101,99,111,100,101,0,78,111,116,32,101,110,111,117,103,104,32,100,97,116,97,32,102,111,114,32,115,99,97,110,108,105,110,101,32,37,108,117,44,32,101,120,112,101,99,116,101,100,32,97,32,114,101,113,117,101,115,116,32,102,111,114,32,97,116,32,109,111,115,116,32,37,108,108,100,32,98,121,116,101,115,44,32,103,111,116,32,97,32,114,101,113,117,101,115,116,32,102,111,114,32,37,108,108,100,32,98,121,116,101,115,0,0,128,192,224,240,248,252,254,255,120,32,61,61,32,108,97,115,116,120,0,116,105,102,95,102,97,120,51,46,99,0,95,84,73,70,70,70,97,120,51,102,105,108,108,114,117,110,115,0,84,73,70,70,73,110,105,116,67,67,73,84,84,70,97,120,51,0,77,101,114,103,105,110,103,32,67,67,73,84,84,32,70,97,120,32,51,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,84,73,70,70,73,110,105,116,67,67,73,84,84,70,97,120,52,0,77,101,114,103,105,110,103,32,67,67,73,84,84,32,70,97,120,32,52,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,70,97,120,51,68,101,99,111,100,101,82,76,69,0,116,105,108,101,0,115,116,114,105,112,0,66,97,100,32,99,111,100,101,32,119,111,114,100,32,97,116,32,108,105,110,101,32,37,117,32,111,102,32,37,115,32,37,117,32,40,120,32,37,117,41,0,80,114,101,109,97,116,117,114,101,32,69,79,70,32,97,116,32,108,105,110,101,32,37,117,32,111,102,32,37,115,32,37,117,32,40,120,32,37,117,41,0,80,114,101,109,97,116,117,114,101,32,69,79,76,0,76,105,110,101,32,108,101,110,103,116,104,32,109,105,115,109,97,116,99,104,0,37,115,32,97,116,32,108,105,110,101,32,37,117,32,111,102,32,37,115,32,37,117,32,40,103,111,116,32,37,117,44,32,101,120,112,101,99,116,101,100,32,37,117,41,0,108,101,110,103,116,104,32,60,32,57,0,70,97,120,51,80,117,116,66,105,116,115,0,70,97,120,52,69,110,99,111,100,101,0,70,114,97,99,116,105,111,110,97,108,32,115,99,97,110,108,105,110,101,115,32,99,97,110,110,111,116,32,98,101,32,119,114,105,116,116,101,110,0,8,7,6,6,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+133156);allocate([112,117,116,115,112,97,110,0,116,101,45,62,114,117,110,108,101,110,32,61,61,32,54,52,42,40,115,112,97,110,62,62,54,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,6,6,7,8,70,97,120,52,68,101,99,111,100,101,0,85,110,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,40,110,111,116,32,115,117,112,112,111,114,116,101,100,41,32,97,116,32,108,105,110,101,32,37,117,32,111,102,32,37,115,32,37,117,32,40,120,32,37,117,41,0,71,114,111,117,112,52,79,112,116,105,111,110,115,0,71,114,111,117,112,51,79,112,116,105,111,110,115,0,73,110,105,116,67,67,73,84,84,70,97,120,51,0,77,101,114,103,105,110,103,32,99,111,109,109,111,110,32,67,67,73,84,84,32,70,97,120,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,78,111,32,115,112,97,99,101,32,102,111,114,32,115,116,97,116,101,32,98,108,111,99,107,0,70,97,120,51,67,108,101,97,110,117,112,0,70,97,120,51,69,110,99,111,100,101,0,116,112,97,114,109,32,60,32,57,0,70,97,120,51,80,117,116,69,79,76,0,70,97,120,51,80,114,101,69,110,99,111,100,101,0,70,97,120,51,68,101,99,111,100,101,49,68,0,70,97,120,51,80,114,101,68,101,99,111,100,101,0,70,97,120,51,83,101,116,117,112,83,116,97,116,101,0,66,105,116,115,47,115,97,109,112,108,101,32,109,117,115,116,32,98,101,32,49,32,102,111,114,32,71,114,111,117,112,32,51,47,52,32,101,110,99,111,100,105,110,103,47,100,101,99,111,100,105,110,103,0,82,111,119,32,112,105,120,101,108,115,32,105,110,116,101,103,101,114,32,111,118,101,114,102,108,111,119,32,40,114,111,119,112,105,120,101,108,115,32,37,117,41,0,102,111,114,32,71,114,111,117,112,32,51,47,52,32,114,117,110,32,97,114,114,97,121,115,0,78,111,32,115,112,97,99,101,32,102,111,114,32,71,114,111,117,112,32,51,47,52,32,114,101,102,101,114,101,110,99,101,32,108,105,110,101,0,70,97,120,51,68,101,99,111,100,101,50,68,0,70,97,120,51,80,114,105,110,116,68,105,114,0,32,32,71,114,111,117,112,32,52,32,79,112,116,105,111,110,115,58,0,37,115,117,110,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,0,32,0,32,32,71,114,111,117,112,32,51,32,79,112,116,105,111,110,115,58,0,37,115,50,45,100,32,101,110,99,111,100,105,110,103,0,43,0,37,115,69,79,76,32,112,97,100,100,105,110,103,0,32,40,37,108,117,32,61,32,48,120,37,108,120,41,10,0,32,32,70,97,120,32,68,97,116,97,58,0,32,99,108,101,97,110,0,32,114,101,99,101,105,118,101,114,32,114,101,103,101,110,101,114,97,116,101,100,0,32,117,110,99,111,114,114,101,99,116,101,100,32,101,114,114,111,114,115,0,32,40,37,117,32,61,32,48,120,37,120,41,10,0,32,32,66,97,100,32,70,97,120,32,76,105,110,101,115,58,32,37,108,117,10,0,32,32,67,111,110,115,101,99,117,116,105,118,101,32,66,97,100,32,70,97,120,32,76,105,110,101,115,58,32,37,108,117,10,0,70,97,120,51,86,83,101,116,70,105,101,108,100,0,115,112,45,62,118,115,101,116,112,97,114,101,110,116,32,33,61,32,48,0,70,97,120,51,86,71,101,116,70,105,101,108,100,0,70,97,120,77,111,100,101,0,70,97,120,70,105,108,108,70,117,110,99,0,66,97,100,70,97,120,76,105,110,101,115,0,67,108,101,97,110,70,97,120,68,97,116,97,0,67,111,110,115,101,99,117,116,105,118,101,66,97,100,70,97,120,76,105,110,101,115,0,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,74,80,69,71,0,116,105,102,95,106,112,101,103,46,99,0,84,73,70,70,73,110,105,116,74,80,69,71,0,77,101,114,103,105,110,103,32,74,80,69,71,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,78,111,32,115,112,97,99,101,32,102,111,114,32,74,80,69,71,32,115,116,97,116,101,32,98,108,111,99,107,0,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,109,101,109,111,114,121,32,102,111,114,32,74,80,69,71,32,116,97,98,108,101,115,0,74,80,69,71,67,108,101,97,110,117,112,0,74,80,69,71,69,110,99,111,100,101,0,102,114,97,99,116,105,111,110,97,108,32,115,99,97,110,108,105,110,101,32,100,105,115,99,97,114,100,101,100,0,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,109,101,109,111,114,121,0,74,80,69,71,80,114,101,69,110,99,111,100,101,0,33,115,112,45,62,99,105,110,102,111,46,99,111,109,109,46,105,115,95,100,101,99,111,109,112,114,101,115,115,111,114,0,83,116,114,105,112,47,116,105,108,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,74,80,69,71,0,74,80,69,71,69,110,99,111,100,101,82,97,119,0,74,80,69,71,83,101,116,117,112,69,110,99,111,100,101,0,80,104,111,116,111,109,101,116,114,105,99,73,110,116,101,114,112,114,101,116,97,116,105,111,110,32,37,100,32,110,111,116,32,97,108,108,111,119,101,100,32,102,111,114,32,74,80,69,71,0,66,105,116,115,80,101,114,83,97,109,112,108,101,32,37,100,32,110,111,116,32,97,108,108,111,119,101,100,32,102,111,114,32,74,80,69,71,0,74,80,69,71,32,116,105,108,101,32,104,101,105,103,104,116,32,109,117,115,116,32,98,101,32,109,117,108,116,105,112,108,101,32,111,102,32,37,100,0,74,80,69,71,32,116,105,108,101,32,119,105,100,116,104,32,109,117,115,116,32,98,101,32,109,117,108,116,105,112,108,101,32,111,102,32,37,100,0,82,111,119,115,80,101,114,83,116,114,105,112,32,109,117,115,116,32,98,101,32,109,117,108,116,105,112,108,101,32,111,102,32,37,100,32,102,111,114,32,74,80,69,71,0,0,0,0,0,0,0,0,0,0,0,84,73,70,70,106,112,101,103,95,116,97,98,108,101,115,95,100,101,115,116,0,78,111,32,115,112,97,99,101,32,102,111,114,32,74,80,69,71,84,97,98,108,101,115,0,74,80,69,71,76,105,98,0,102,114,97,99,116,105,111,110,97,108,32,115,99,97,110,108,105,110,101,32,110,111,116,32,114,101,97,100,0,74,80,69,71,80,114,101,68,101,99,111,100,101,0,115,112,45,62,99,105,110,102,111,46,99,111,109,109,46,105,115,95,100,101,99,111,109,112,114,101,115,115,111,114,0,73,109,112,114,111,112,101,114,32,74,80,69,71,32,115,116,114,105,112,47,116,105,108,101,32,115,105,122,101,44,32,101,120,112,101,99,116,101,100,32,37,100,120,37,100,44,32,103,111,116,32,37,100,120,37,100,0,74,80,69,71,32,115,116,114,105,112,47,116,105,108,101,32,115,105,122,101,32,101,120,99,101,101,100,115,32,101,120,112,101,99,116,101,100,32,100,105,109,101,110,115,105,111,110,115,44,32,101,120,112,101,99,116,101,100,32,37,100,120,37,100,44,32,103,111,116,32,37,100,120,37,100,0,73,109,112,114,111,112,101,114,32,74,80,69,71,32,99,111,109,112,111,110,101,110,116,32,99,111,117,110,116,0,73,109,112,114,111,112,101,114,32,74,80,69,71,32,100,97,116,97,32,112,114,101,99,105,115,105,111,110,0,73,109,112,114,111,112,101,114,32,74,80,69,71,32,115,97,109,112,108,105,110,103,32,102,97,99,116,111,114,115,32,37,100,44,37,100,10,65,112,112,97,114,101,110,116,108,121,32,115,104,111,117,108,100,32,98,101,32,37,100,44,37,100,46,0,73,109,112,114,111,112,101,114,32,74,80,69,71,32,115,97,109,112,108,105,110,103,32,102,97,99,116,111,114,115,0,74,80,69,71,68,101,99,111,100,101,82,97,119,0,97,112,112,108,105,99,97,116,105,111,110,32,98,117,102,102,101,114,32,110,111,116,32,108,97,114,103,101,32,101,110,111,117,103,104,32,102,111,114,32,97,108,108,32,100,97,116,97,46,0,97,112,112,108,105,99,97,116,105,111,110,32,98,117,102,102,101,114,32,110,111,116,32,108,97,114,103,101,32,101,110,111,117,103,104,32,102,111,114,32,97,108,108,32,100,97,116,97,44,32,112,111,115,115,105,98,108,101,32,115,117,98,115,97,109,112,108,105,110,103,32,105,115,115,117,101,0,84,73,70,70,82,101,97,100,83,99,97,110,108,105,110,101,0,115,99,97,110,108,105,110,101,32,111,114,105,101,110,116,101,100,32,97,99,99,101,115,115,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,102,111,114,32,100,111,119,110,115,97,109,112,108,101,100,32,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,105,109,97,103,101,115,44,32,99,111,110,115,105,100,101,114,32,101,110,97,98,108,105,110,103,32,84,73,70,70,95,74,80,69,71,67,79,76,79,82,77,79,68,69,32,97,115,32,74,80,69,71,67,79,76,79,82,77,79,68,69,95,82,71,66,46,0,74,80,69,71,83,101,116,117,112,68,101,99,111,100,101,0,66,111,103,117,115,32,74,80,69,71,84,97,98,108,101,115,32,102,105,101,108,100,0,255,217,74,80,69,71,70,105,120,117,112,84,97,103,115,83,117,98,115,97,109,112,108,105,110,103,0,85,110,97,98,108,101,32,116,111,32,97,108,108,111,99,97,116,101,32,109,101,109,111,114,121,32,102,111,114,32,97,117,116,111,45,99,111,114,114,101,99,116,105,110,103,32,111,102,32,115,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,59,32,97,117,116,111,45,99,111,114,114,101,99,116,105,110,103,32,115,107,105,112,112,101,100,0,109,60,48,120,56,48,48,48,48,48,48,48,85,76,0,74,80,69,71,70,105,120,117,112,84,97,103,115,83,117,98,115,97,109,112,108,105,110,103,82,101,97,100,66,121,116,101,0,74,80,69,71,70,105,120,117,112,84,97,103,115,83,117,98,115,97,109,112,108,105,110,103,83,101,99,0,83,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,32,105,110,115,105,100,101,32,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,104,97,118,101,32,110,111,32,84,73,70,70,32,101,113,117,105,118,97,108,101,110,116,44,32,97,117,116,111,45,99,111,114,114,101,99,116,105,111,110,32,111,102,32,84,73,70,70,32,115,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,32,102,97,105,108,101,100,0,65,117,116,111,45,99,111,114,114,101,99,116,101,100,32,102,111,114,109,101,114,32,84,73,70,70,32,115,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,32,91,37,100,44,37,100,93,32,116,111,32,109,97,116,99,104,32,115,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,32,105,110,115,105,100,101,32,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,91,37,100,44,37,100,93,0,85,110,97,98,108,101,32,116,111,32,97,117,116,111,45,99,111,114,114,101,99,116,32,115,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,44,32,108,105,107,101,108,121,32,99,111,114,114,117,112,116,32,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,110,32,102,105,114,115,116,32,115,116,114,105,112,47,116,105,108,101,59,32,97,117,116,111,45,99,111,114,114,101,99,116,105,110,103,32,115,107,105,112,112,101,100,0,74,80,69,71,80,114,105,110,116,68,105,114,0,32,32,74,80,69,71,32,84,97,98,108,101,115,58,32,40,37,108,117,32,98,121,116,101,115,41,10,0,74,80,69,71,86,83,101,116,70,105,101,108,100,0,74,80,69,71,86,71,101,116,70,105,101,108,100,0,74,80,69,71,84,97,98,108,101,115,0,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,83,71,73,76,79,71,50,52,32,124,124,32,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,83,71,73,76,79,71,0,116,105,102,95,108,117,118,46,99,0,84,73,70,70,73,110,105,116,83,71,73,76,111,103,0,77,101,114,103,105,110,103,32,83,71,73,76,111,103,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,37,115,58,32,78,111,32,115,112,97,99,101,32,102,111,114,32,76,111,103,76,117,118,32,115,116,97,116,101,32,98,108,111,99,107,0,85,110,107,110,111,119,110,32,100,97,116,97,32,102,111,114,109,97,116,32,37,100,32,102,111,114,32,76,111,103,76,117,118,32,99,111,109,112,114,101,115,115,105,111,110,0,76,111,103,76,117,118,86,83,101,116,70,105,101,108,100,0,85,110,107,110,111,119,110,32,101,110,99,111,100,105,110,103,32,37,100,32,102,111,114,32,76,111,103,76,117,118,32,99,111,109,112,114,101,115,115,105,111,110,0,76,111,103,76,117,118,67,108,101,97,110,117,112,0,99,99,37,114,111,119,108,101,110,32,61,61,32,48,0,76,111,103,76,117,118,69,110,99,111,100,101,84,105,108,101,0,76,111,103,76,117,118,69,110,99,111,100,101,83,116,114,105,112,0,76,111,103,76,117,118,83,101,116,117,112,69,110,99,111,100,101,0,73,110,97,112,112,114,111,112,114,105,97,116,101,32,112,104,111,116,111,109,101,116,114,105,99,32,105,110,116,101,114,112,114,101,116,97,116,105,111,110,32,37,100,32,102,111,114,32,83,71,73,76,111,103,32,99,111,109,112,114,101,115,115,105,111,110,59,32,37,115,0,109,117,115,116,32,98,101,32,101,105,116,104,101,114,32,76,111,103,76,85,86,32,111,114,32,76,111,103,76,0,89,44,32,76,0,88,89,90,44,32,76,117,118,0,83,71,73,76,111,103,32,99,111,109,112,114,101,115,115,105,111,110,32,115,117,112,112,111,114,116,101,100,32,111,110,108,121,32,102,111,114,32,37,115,44,32,111,114,32,114,97,119,32,100,97,116,97,0,115,32,61,61,32,48,0,76,111,103,76,49,54,69,110,99,111,100,101,0,115,112,45,62,116,98,117,102,108,101,110,32,62,61,32,110,112,105,120,101,108,115,0,76,111,103,76,49,54,73,110,105,116,83,116,97,116,101,0,116,100,45,62,116,100,95,112,104,111,116,111,109,101,116,114,105,99,32,61,61,32,80,72,79,84,79,77,69,84,82,73,67,95,76,79,71,76,0,78,111,32,115,117,112,112,111,114,116,32,102,111,114,32,99,111,110,118,101,114,116,105,110,103,32,117,115,101,114,32,100,97,116,97,32,102,111,114,109,97,116,32,116,111,32,76,111,103,76,0,78,111,32,115,112,97,99,101,32,102,111,114,32,83,71,73,76,111,103,32,116,114,97,110,115,108,97,116,105,111,110,32,98,117,102,102,101,114,0,76,111,103,76,117,118,69,110,99,111,100,101,51,50,0,76,111,103,76,117,118,69,110,99,111,100,101,50,52,0,76,111,103,76,117,118,73,110,105,116,83,116,97,116,101,0,116,100,45,62,116,100,95,112,104,111,116,111,109,101,116,114,105,99,32,61,61,32,80,72,79,84,79,77,69,84,82,73,67,95,76,79,71,76,85,86,0,83,71,73,76,111,103,32,99,111,109,112,114,101,115,115,105,111,110,32,99,97,110,110,111,116,32,104,97,110,100,108,101,32,110,111,110,45,99,111,110,116,105,103,117,111,117,115,32,100,97,116,97,0,78,111,32,115,117,112,112,111,114,116,32,102,111,114,32,99,111,110,118,101,114,116,105,110,103,32,117,115,101,114,32,100,97,116,97,32,102,111,114,109,97,116,32,116,111,32,76,111,103,76,117,118,0,76,111,103,76,117,118,68,101,99,111,100,101,84,105,108,101,0,76,111,103,76,117,118,68,101,99,111,100,101,83,116,114,105,112,0,76,111,103,76,117,118,83,101,116,117,112,68,101,99,111,100,101,0,76,111,103,76,49,54,68,101,99,111,100,101,0,78,111,116,32,101,110,111,117,103,104,32,100,97,116,97,32,97,116,32,114,111,119,32,37,108,117,32,40,115,104,111,114,116,32,37,108,108,117,32,112,105,120,101,108,115,41,0,76,111,103,76,117,118,68,101,99,111,100,101,51,50,0,76,111,103,76,117,118,68,101,99,111,100,101,50,52,0,83,71,73,76,111,103,68,97,116,97,70,109,116,0,83,71,73,76,111,103,69,110,99,111,100,101,0,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,76,90,87,0,116,105,102,95,108,122,119,46,99,0,84,73,70,70,73,110,105,116,76,90,87,0,78,111,32,115,112,97,99,101,32,102,111,114,32,76,90,87,32,115,116,97,116,101,32,98,108,111,99,107,0,116,105,102,45,62,116,105,102,95,100,97,116,97,32,33,61,32,48,0,76,90,87,67,108,101,97,110,117,112,0,115,112,45,62,101,110,99,95,104,97,115,104,116,97,98,32,33,61,32,78,85,76,76,0,76,90,87,69,110,99,111,100,101,0,110,98,105,116,115,32,60,61,32,66,73,84,83,95,77,65,88,0,76,90,87,80,114,101,69,110,99,111,100,101,0,76,90,87,83,101,116,117,112,69,110,99,111,100,101,0,78,111,32,115,112,97,99,101,32,102,111,114,32,76,90,87,32,104,97,115,104,32,116,97,98,108,101,0,76,90,87,68,101,99,111,100,101,0,115,112,45,62,100,101,99,95,99,111,100,101,116,97,98,32,33,61,32,78,85,76,76,0,76,90,87,68,101,99,111,100,101,58,32,83,116,114,105,112,32,37,100,32,110,111,116,32,116,101,114,109,105,110,97,116,101,100,32,119,105,116,104,32,69,79,73,32,99,111,100,101,0,76,90,87,68,101,99,111,100,101,58,32,67,111,114,114,117,112,116,101,100,32,76,90,87,32,116,97,98,108,101,32,97,116,32,115,99,97,110,108,105,110,101,32,37,100,0,67,111,114,114,117,112,116,101,100,32,76,90,87,32,116,97,98,108,101,32,97,116,32,115,99,97,110,108,105,110,101,32,37,100,0,87,114,111,110,103,32,108,101,110,103,116,104,32,111,102,32,100,101,99,111,100,101,100,32,115,116,114,105,110,103,58,32,100,97,116,97,32,112,114,111,98,97,98,108,121,32,99,111,114,114,117,112,116,101,100,32,97,116,32,115,99,97,110,108,105,110,101,32,37,100,0,66,111,103,117,115,32,101,110,99,111,100,105,110,103,44,32,108,111,111,112,32,105,110,32,116,104,101,32,99,111,100,101,32,116,97,98,108,101,59,32,115,99,97,110,108,105,110,101,32,37,100,0,78,111,116,32,101,110,111,117,103,104,32,100,97,116,97,32,97,116,32,115,99,97,110,108,105,110,101,32,37,100,32,40,115,104,111,114,116,32,37,108,108,117,32,98,121,116,101,115,41,0,76,90,87,80,114,101,68,101,99,111,100,101,0,79,108,100,45,115,116,121,108,101,32,76,90,87,32,99,111,100,101,115,44,32,99,111,110,118,101,114,116,32,102,105,108,101,0,76,90,87,68,101,99,111,100,101,67,111,109,112,97,116,0,76,90,87,83,101,116,117,112,68,101,99,111,100,101,0,78,111,32,115,112,97,99,101,32,102,111,114,32,76,90,87,32,99,111,100,101,32,116,97,98,108,101,0,78,101,88,84,68,101,99,111,100,101,0,78,111,116,32,101,110,111,117,103,104,32,100,97,116,97,32,102,111,114,32,115,99,97,110,108,105,110,101,32,37,108,100,0,78,101,88,84,80,114,101,68,101,99,111,100,101,0,85,110,115,117,112,112,111,114,116,101,100,32,66,105,116,115,80,101,114,83,97,109,112,108,101,32,61,32,37,100,0,115,99,104,101,109,101,61,61,67,79,77,80,82,69,83,83,73,79,78,95,79,74,80,69,71,0,116,105,102,95,111,106,112,101,103,46,99,0,84,73,70,70,73,110,105,116,79,74,80,69,71,0,77,101,114,103,105,110,103,32,79,108,100,32,74,80,69,71,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,78,111,32,115,112,97,99,101,32,102,111,114,32,79,74,80,69,71,32,115,116,97,116,101,32,98,108,111,99,107,0,115,112,33,61,78,85,76,76,0,79,74,80,69,71,80,114,105,110,116,68,105,114,0,32,32,74,112,101,103,73,110,116,101,114,99,104,97,110,103,101,70,111,114,109,97,116,58,32,37,108,117,10,0,32,32,74,112,101,103,73,110,116,101,114,99,104,97,110,103,101,70,111,114,109,97,116,76,101,110,103,116,104,58,32,37,108,117,10,0,32,32,74,112,101,103,81,84,97,98,108,101,115,58,0,32,37,108,117,0,32,32,74,112,101,103,68,99,84,97,98,108,101,115,58,0,32,32,74,112,101,103,65,99,84,97,98,108,101,115,58,0,32,32,74,112,101,103,80,114,111,99,58,32,37,117,10,0,32,32,74,112,101,103,82,101,115,116,97,114,116,73,110,116,101,114,118,97,108,58,32,37,117,10,0,79,74,80,69,71,86,83,101,116,70,105,101,108,100,0,74,112,101,103,81,84,97,98,108,101,115,32,116,97,103,32,104,97,115,32,105,110,99,111,114,114,101,99,116,32,99,111,117,110,116,0,74,112,101,103,68,99,84,97,98,108,101,115,32,116,97,103,32,104,97,115,32,105,110,99,111,114,114,101,99,116,32,99,111,117,110,116,0,74,112,101,103,65,99,84,97,98,108,101,115,32,116,97,103,32,104,97,115,32,105,110,99,111,114,114,101,99,116,32,99,111,117,110,116,0,115,112,45,62,115,117,98,115,97,109,112,108,105,110,103,99,111,114,114,101,99,116,95,100,111,110,101,61,61,48,0,79,74,80,69,71,83,117,98,115,97,109,112,108,105,110,103,67,111,114,114,101,99,116,0,83,117,98,115,97,109,112,108,105,110,103,32,116,97,103,32,110,111,116,32,97,112,112,114,111,112,114,105,97,116,101,32,102,111,114,32,116,104,105,115,32,80,104,111,116,111,109,101,116,114,105,99,32,97,110,100,47,111,114,32,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,0,83,117,98,115,97,109,112,108,105,110,103,32,116,97,103,32,105,115,32,110,111,116,32,115,101,116,44,32,121,101,116,32,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,91,37,100,44,37,100,93,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,100,101,102,97,117,108,116,32,118,97,108,117,101,115,32,91,50,44,50,93,59,32,97,115,115,117,109,105,110,103,32,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,105,115,32,99,111,114,114,101,99,116,0,83,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,91,37,100,44,37,100,93,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,115,117,98,115,97,109,112,108,105,110,103,32,116,97,103,32,118,97,108,117,101,115,32,91,37,100,44,37,100,93,59,32,97,115,115,117,109,105,110,103,32,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,105,115,32,99,111,114,114,101,99,116,0,83,117,98,115,97,109,112,108,105,110,103,32,116,97,103,32,105,115,32,110,111,116,32,115,101,116,44,32,121,101,116,32,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,100,101,102,97,117,108,116,32,118,97,108,117,101,115,32,91,50,44,50,93,32,40,110,111,114,32,97,110,121,32,111,116,104,101,114,32,118,97,108,117,101,115,32,97,108,108,111,119,101,100,32,105,110,32,84,73,70,70,41,59,32,97,115,115,117,109,105,110,103,32,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,105,115,32,99,111,114,114,101,99,116,32,97,110,100,32,100,101,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,101,99,111,109,112,114,101,115,115,105,111,110,0,83,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,115,117,98,115,97,109,112,108,105,110,103,32,116,97,103,32,118,97,108,117,101,115,32,91,37,100,44,37,100,93,32,40,110,111,114,32,97,110,121,32,111,116,104,101,114,32,118,97,108,117,101,115,32,97,108,108,111,119,101,100,32,105,110,32,84,73,70,70,41,59,32,97,115,115,117,109,105,110,103,32,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,105,115,32,99,111,114,114,101,99,116,32,97,110,100,32,100,101,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,101,99,111,109,112,114,101,115,115,105,111,110,0,83,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,32,91,37,100,44,37,100,93,32,97,114,101,32,110,111,116,32,97,108,108,111,119,101,100,32,105,110,32,84,73,70,70,0,115,112,45,62,105,110,95,98,117,102,102,101,114,95,116,111,103,111,62,48,0,79,74,80,69,71,82,101,97,100,66,121,116,101,80,101,101,107,0,79,74,80,69,71,82,101,97,100,66,121,116,101,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,0,67,111,114,114,117,112,116,32,74,80,69,71,32,100,97,116,97,0,115,112,45,62,105,110,95,98,117,102,102,101,114,95,116,111,103,111,61,61,48,0,79,74,80,69,71,82,101,97,100,83,107,105,112,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,83,116,114,101,97,109,68,114,105,0,67,111,114,114,117,112,116,32,68,82,73,32,109,97,114,107,101,114,32,105,110,32,74,80,69,71,32,100,97,116,97,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,83,116,114,101,97,109,68,113,116,0,67,111,114,114,117,112,116,32,68,81,84,32,109,97,114,107,101,114,32,105,110,32,74,80,69,71,32,100,97,116,97,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,79,74,80,69,71,82,101,97,100,66,108,111,99,107,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,83,116,114,101,97,109,68,104,116,0,67,111,114,114,117,112,116,32,68,72,84,32,109,97,114,107,101,114,32,105,110,32,74,80,69,71,32,100,97,116,97,0,108,101,110,62,48,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,83,116,114,101,97,109,83,111,102,0,67,111,114,114,117,112,116,32,83,79,70,32,109,97,114,107,101,114,32,105,110,32,74,80,69,71,32,100,97,116,97,0,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,110,100,105,99,97,116,101,115,32,117,110,101,120,112,101,99,116,101,100,32,110,117,109,98,101,114,32,111,102,32,115,97,109,112,108,101,115,0,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,110,100,105,99,97,116,101,115,32,117,110,101,120,112,101,99,116,101,100,32,110,117,109,98,101,114,32,111,102,32,98,105,116,115,32,112,101,114,32,115,97,109,112,108,101,0,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,110,100,105,99,97,116,101,115,32,117,110,101,120,112,101,99,116,101,100,32,104,101,105,103,104,116,0,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,110,100,105,99,97,116,101,115,32,117,110,101,120,112,101,99,116,101,100,32,119,105,100,116,104,0,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,109,97,103,101,32,119,105,100,116,104,32,101,120,99,101,101,100,115,32,101,120,112,101,99,116,101,100,32,105,109,97,103,101,32,119,105,100,116,104,0,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,110,100,105,99,97,116,101,115,32,117,110,101,120,112,101,99,116,101,100,32,115,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,0,115,112,45,62,112,108,97,110,101,95,115,97,109,112,108,101,95,111,102,102,115,101,116,61,61,48,0,85,110,107,110,111,119,110,32,109,97,114,107,101,114,32,116,121,112,101,32,37,100,32,105,110,32,74,80,69,71,32,100,97,116,97,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,84,97,98,108,101,115,81,84,97,98,108,101,0,77,105,115,115,105,110,103,32,74,80,69,71,32,116,97,98,108,101,115,0,67,111,114,114,117,112,116,32,74,112,101,103,81,84,97,98,108,101,115,32,116,97,103,32,118,97,108,117,101,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,84,97,98,108,101,115,68,99,84,97,98,108,101,0,67,111,114,114,117,112,116,32,74,112,101,103,68,99,84,97,98,108,101,115,32,116,97,103,32,118,97,108,117,101,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,84,97,98,108,101,115,65,99,84,97,98,108,101,0,67,111,114,114,117,112,116,32,74,112,101,103,65,99,84,97,98,108,101,115,32,116,97,103,32,118,97,108,117,101,0,115,112,45,62,115,117,98,115,97,109,112,108,105,110,103,99,111,114,114,101,99,116,61,61,48,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,83,116,114,101,97,109,83,111,115,0,67,111,114,114,117,112,116,32,83,79,83,32,109,97,114,107,101,114,32,105,110,32,74,80,69,71,32,100,97,116,97,0,110,62,48,0,79,74,80,69,71,82,101,97,100,66,117,102,102,101,114,70,105,108,108,0,110,60,61,79,74,80,69,71,95,66,85,70,70,69,82,0,40,117,105,110,116,54,52,41,110,60,61,115,112,45,62,105,110,95,98,117,102,102,101,114,95,102,105,108,101,95,116,111,103,111,0,115,112,45,62,108,105,98,106,112,101,103,95,115,101,115,115,105,111,110,95,97,99,116,105,118,101,33,61,48,0,79,74,80,69,71,76,105,98,106,112,101,103,83,101,115,115,105,111,110,65,98,111,114,116,0,79,74,80,69,71,69,110,99,111,100,101,0,79,74,80,69,71,32,101,110,99,111,100,105,110,103,32,110,111,116,32,115,117,112,112,111,114,116,101,100,59,32,117,115,101,32,110,101,119,45,115,116,121,108,101,32,74,80,69,71,32,99,111,109,112,114,101,115,115,105,111,110,32,105,110,115,116,101,97,100,0,79,74,80,69,71,80,111,115,116,69,110,99,111,100,101,0,79,74,80,69,71,80,114,101,69,110,99,111,100,101,0,79,74,80,69,71,83,101,116,117,112,69,110,99,111,100,101,0,79,74,80,69,71,68,101,99,111,100,101,82,97,119,0,70,114,97,99,116,105,111,110,97,108,32,115,99,97,110,108,105,110,101,32,110,111,116,32,114,101,97,100,0,99,99,62,48,0,79,74,80,69,71,68,101,99,111,100,101,83,99,97,110,108,105,110,101,115,0,79,74,80,69,71,80,111,115,116,68,101,99,111,100,101,0,115,112,45,62,114,101,97,100,104,101,97,100,101,114,95,100,111,110,101,61,61,48,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,0,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,32,37,100,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,102,111,114,32,116,104,105,115,32,99,111,109,112,114,101,115,115,105,111,110,32,115,99,104,101,109,101,0,73,110,99,111,109,112,97,116,105,98,108,101,32,118,101,114,116,105,99,97,108,32,115,117,98,115,97,109,112,108,105,110,103,32,97,110,100,32,105,109,97,103,101,32,115,116,114,105,112,47,116,105,108,101,32,108,101,110,103,116,104,0,115,62,48,0,79,74,80,69,71,82,101,97,100,83,101,99,111,110,100,97,114,121,83,111,115,0,115,60,51,0,115,112,45,62,115,111,115,95,101,110,100,91,48,93,46,108,111,103,33,61,48,0,115,112,45,62,115,111,115,95,101,110,100,91,115,93,46,108,111,103,61,61,48,0,115,112,45,62,115,117,98,115,97,109,112,108,105,110,103,95,99,111,110,118,101,114,116,95,121,99,98,99,114,98,117,102,61,61,48,0,79,74,80,69,71,87,114,105,116,101,72,101,97,100,101,114,73,110,102,111,0,115,112,45,62,115,117,98,115,97,109,112,108,105,110,103,95,99,111,110,118,101,114,116,95,121,99,98,99,114,105,109,97,103,101,61,61,48,0,79,74,80,69,71,80,114,101,68,101,99,111,100,101,83,107,105,112,83,99,97,110,108,105,110,101,115,0,76,105,98,74,112,101,103,0,85,110,101,120,112,101,99,116,101,100,32,101,114,114,111,114,0,115,112,45,62,111,117,116,95,115,116,97,116,101,60,61,111,115,111,115,69,111,105,0,79,74,80,69,71,87,114,105,116,101,83,116,114,101,97,109,0,50,53,53,62,61,56,43,115,112,45,62,115,97,109,112,108,101,115,95,112,101,114,95,112,105,120,101,108,95,112,101,114,95,112,108,97,110,101,42,51,0,79,74,80,69,71,87,114,105,116,101,83,116,114,101,97,109,83,111,102,0,50,53,53,62,61,54,43,115,112,45,62,115,97,109,112,108,101,115,95,112,101,114,95,112,105,120,101,108,95,112,101,114,95,112,108,97,110,101,42,50,0,79,74,80,69,71,87,114,105,116,101,83,116,114,101,97,109,83,111,115,0,79,74,80,69,71,87,114,105,116,101,83,116,114,101,97,109,67,111,109,112,114,101,115,115,101,100,0,80,114,101,109,97,116,117,114,101,32,101,110,100,32,111,102,32,74,80,69,71,32,100,97,116,97,0,79,74,80,69,71,83,101,116,117,112,68,101,99,111,100,101,0,68,101,112,114,101,99,105,97,116,101,100,32,97,110,100,32,116,114,111,117,98,108,101,115,111,109,101,32,111,108,100,45,115,116,121,108,101,32,74,80,69,71,32,99,111,109,112,114,101,115,115,105,111,110,32,109,111,100,101,44,32,112,108,101,97,115,101,32,99,111,110,118,101,114,116,32,116,111,32,110,101,119,45,115,116,121,108,101,32,74,80,69,71,32,99,111,109,112,114,101,115,115,105,111,110,32,97,110,100,32,110,111,116,105,102,121,32,118,101,110,100,111,114,32,111,102,32,119,114,105,116,105,110,103,32,115,111,102,116,119,97,114,101,0,74,112,101,103,73,110,116,101,114,99,104,97,110,103,101,70,111,114,109,97,116,0,74,112,101,103,73,110,116,101,114,99,104,97,110,103,101,70,111,114,109,97,116,76,101,110,103,116,104,0,74,112,101,103,81,84,97,98,108,101,115,0,74,112,101,103,68,99,84,97,98,108,101,115,0,74,112,101,103,65,99,84,97,98,108,101,115,0,74,112,101,103,80,114,111,99,0,74,112,101,103,82,101,115,116,97,114,116,73,110,116,101,114,118,97,108,0,80,97,99,107,66,105,116,115,68,101,99,111,100,101,0,68,105,115,99,97,114,100,105,110,103,32,37,108,117,32,98,121,116,101,115,32,116,111,32,97,118,111,105,100,32,98,117,102,102,101,114,32,111,118,101,114,114,117,110,0,84,101,114,109,105,110,97,116,105,110,103,32,80,97,99,107,66,105,116,115,68,101,99,111,100,101,32,100,117,101,32,116,111,32,108,97,99,107,32,111,102,32,100,97,116,97,46,0,78,111,116,32,101,110,111,117,103,104,32,100,97,116,97,32,102,111,114,32,115,99,97,110,108,105,110,101,32,37,108,117,0,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,80,73,88,65,82,76,79,71,0,116,105,102,95,112,105,120,97,114,108,111,103,46,99,0,84,73,70,70,73,110,105,116,80,105,120,97,114,76,111,103,0,77,101,114,103,105,110,103,32,80,105,120,97,114,76,111,103,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,78,111,32,115,112,97,99,101,32,102,111,114,32,80,105,120,97,114,76,111,103,32,115,116,97,116,101,32,98,108,111,99,107,0,80,105,120,97,114,76,111,103,86,83,101,116,70,105,101,108,100,0,80,105,120,97,114,76,111,103,67,108,101,97,110,117,112,0,80,105,120,97,114,76,111,103,69,110,99,111,100,101,0,37,100,32,98,105,116,32,105,110,112,117,116,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,105,110,32,80,105,120,97,114,76,111,103,0,90,76,105,98,32,99,97,110,110,111,116,32,100,101,97,108,32,119,105,116,104,32,98,117,102,102,101,114,115,32,116,104,105,115,32,115,105,122,101,0,80,105,120,97,114,76,111,103,80,111,115,116,69,110,99,111,100,101,0,80,105,120,97,114,76,111,103,80,114,101,69,110,99,111,100,101,0,80,105,120,97,114,76,111,103,83,101,116,117,112,69,110,99,111,100,101,0,80,105,120,97,114,76,111,103,32,99,111,109,112,114,101,115,115,105,111,110,32,99,97,110,39,116,32,104,97,110,100,108,101,32,37,100,32,98,105,116,32,108,105,110,101,97,114,32,101,110,99,111,100,105,110,103,115,0,80,105,120,97,114,76,111,103,68,101,99,111,100,101,0,115,116,114,105,100,101,32,37,108,117,32,105,115,32,110,111,116,32,97,32,109,117,108,116,105,112,108,101,32,111,102,32,115,97,109,112,108,101,32,99,111,117,110,116,44,32,37,108,117,44,32,100,97,116,97,32,116,114,117,110,99,97,116,101,100,46,0,85,110,115,117,112,112,111,114,116,101,100,32,98,105,116,115,47,115,97,109,112,108,101,58,32,37,100,0,80,105,120,97,114,76,111,103,80,114,101,68,101,99,111,100,101,0,80,105,120,97,114,76,111,103,83,101,116,117,112,68,101,99,111,100,101,0,80,105,120,97,114,76,111,103,32,99,111,109,112,114,101,115,115,105,111,110,32,99,97,110,39,116,32,104,97,110,100,108,101,32,98,105,116,115,32,100,101,112,116,104,47,100,97,116,97,32,102,111,114,109,97,116,32,99,111,109,98,105,110,97,116,105,111,110,32,40,100,101,112,116,104,58,32,37,100,41,0,116,105,102,95,112,114,101,100,105,99,116,46,99,0,84,73,70,70,80,114,101,100,105,99,116,111,114,73,110,105,116,0,77,101,114,103,105,110,103,32,80,114,101,100,105,99,116,111,114,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,84,73,70,70,80,114,101,100,105,99,116,111,114,67,108,101,97,110,117,112,0,40,99,99,37,40,98,112,115,42,115,116,114,105,100,101,41,41,61,61,48,0,102,112,68,105,102,102,0,80,114,101,100,105,99,116,111,114,69,110,99,111,100,101,84,105,108,101,0,115,112,45,62,101,110,99,111,100,101,112,102,117,110,99,32,33,61,32,78,85,76,76,0,115,112,45,62,101,110,99,111,100,101,116,105,108,101,32,33,61,32,78,85,76,76,0,79,117,116,32,111,102,32,109,101,109,111,114,121,32,97,108,108,111,99,97,116,105,110,103,32,37,108,100,32,98,121,116,101,32,116,101,109,112,32,98,117,102,102,101,114,46,0,114,111,119,115,105,122,101,32,62,32,48,0,40,99,99,48,37,114,111,119,115,105,122,101,41,61,61,48,0,80,114,101,100,105,99,116,111,114,69,110,99,111,100,101,82,111,119,0,115,112,45,62,101,110,99,111,100,101,114,111,119,32,33,61,32,78,85,76,76,0,40,99,99,37,40,52,42,115,116,114,105,100,101,41,41,61,61,48,0,104,111,114,68,105,102,102,51,50,0,40,99,99,37,40,50,42,115,116,114,105,100,101,41,41,61,61,48,0,104,111,114,68,105,102,102,49,54,0,40,99,99,37,115,116,114,105,100,101,41,61,61,48,0,104,111,114,68,105,102,102,56,0,80,114,101,100,105,99,116,111,114,83,101,116,117,112,0,72,111,114,105,122,111,110,116,97,108,32,100,105,102,102,101,114,101,110,99,105,110,103,32,34,80,114,101,100,105,99,116,111,114,34,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,119,105,116,104,32,37,100,45,98,105,116,32,115,97,109,112,108,101,115,0,70,108,111,97,116,105,110,103,32,112,111,105,110,116,32,34,80,114,101,100,105,99,116,111,114,34,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,119,105,116,104,32,37,100,32,100,97,116,97,32,102,111,114,109,97,116,0,34,80,114,101,100,105,99,116,111,114,34,32,118,97,108,117,101,32,37,100,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,102,112,65,99,99,0,80,114,101,100,105,99,116,111,114,68,101,99,111,100,101,84,105,108,101,0,115,112,45,62,100,101,99,111,100,101,116,105,108,101,32,33,61,32,78,85,76,76,0,40,111,99,99,48,37,114,111,119,115,105,122,101,41,61,61,48,0,115,112,45,62,100,101,99,111,100,101,112,102,117,110,99,32,33,61,32,78,85,76,76,0,80,114,101,100,105,99,116,111,114,68,101,99,111,100,101,82,111,119,0,115,112,45,62,100,101,99,111,100,101,114,111,119,32,33,61,32,78,85,76,76,0,104,111,114,65,99,99,51,50,0,104,111,114,65,99,99,49,54,0,104,111,114,65,99,99,56,0,32,32,80,114,101,100,105,99,116,111,114,58,32,0,110,111,110,101,32,0,104,111,114,105,122,111,110,116,97,108,32,100,105,102,102,101,114,101,110,99,105,110,103,32,0,102,108,111,97,116,105,110,103,32,112,111,105,110,116,32,112,114,101,100,105,99,116,111,114,32,0,37,117,32,40,48,120,37,120,41,10,0,80,114,101,100,105,99,116,111,114,86,83,101,116,70,105,101,108,100,0,115,112,45,62,118,115,101,116,112,97,114,101,110,116,32,33,61,32,78,85,76,76,0,80,114,101,100,105,99,116,111,114,86,71,101,116,70],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+143490);allocate([105,101,108,100,0,115,112,45,62,118,103,101,116,112,97,114,101,110,116,32,33,61,32,78,85,76,76,0,80,114,101,100,105,99,116,111,114,0,84,104,117,110,100,101,114,68,101,99,111,100,101,82,111,119,0,70,114,97,99,116,105,111,110,97,108,32,115,99,97,110,108,105,110,101,115,32,99,97,110,110,111,116,32,98,101,32,114,101,97,100,0,78,111,116,32,101,110,111,117,103,104,0,84,111,111,32,109,117,99,104,0,84,104,117,110,100,101,114,68,101,99,111,100,101,0,37,115,32,100,97,116,97,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,32,40,37,108,108,117,32,33,61,32,37,108,108,117,41,0,84,104,117,110,100,101,114,83,101,116,117,112,68,101,99,111,100,101,0,87,114,111,110,103,32,98,105,116,115,112,101,114,115,97,109,112,108,101,32,118,97,108,117,101,32,40,37,100,41,44,32,84,104,117,110,100,101,114,32,100,101,99,111,100,101,114,32,111,110,108,121,32,115,117,112,112,111,114,116,115,32,52,98,105,116,115,32,112,101,114,32,115,97,109,112,108,101,46,0,40,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,68,69,70,76,65,84,69,41,32,124,124,32,40,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,65,68,79,66,69,95,68,69,70,76,65,84,69,41,0,116,105,102,95,122,105,112,46,99,0,84,73,70,70,73,110,105,116,90,73,80,0,77,101,114,103,105,110,103,32,68,101,102,108,97,116,101,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,78,111,32,115,112,97,99,101,32,102,111,114,32,90,73,80,32,115,116,97,116,101,32,98,108,111,99,107,0,115,112,32,33,61,32,48,0,90,73,80,67,108,101,97,110,117,112,0,115,112,32,33,61,32,78,85,76,76,0,90,73,80,69,110,99,111,100,101,0,115,112,45,62,115,116,97,116,101,32,61,61,32,90,83,84,65,84,69,95,73,78,73,84,95,69,78,67,79,68,69,0,69,110,99,111,100,101,114,32,101,114,114,111,114,58,32,37,115,0,90,73,80,80,111,115,116,69,110,99,111,100,101,0,90,76,105,98,32,101,114,114,111,114,58,32,37,115,0,90,73,80,80,114,101,69,110,99,111,100,101,0,90,73,80,83,101,116,117,112,69,110,99,111,100,101,0,49,46,50,46,56,0,37,115,0,90,73,80,68,101,99,111,100,101,0,115,112,45,62,115,116,97,116,101,32,61,61,32,90,83,84,65,84,69,95,73,78,73,84,95,68,69,67,79,68,69,0,68,101,99,111,100,105,110,103,32,101,114,114,111,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,44,32,37,115,0,78,111,116,32,101,110,111,117,103,104,32,100,97,116,97,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,32,40,115,104,111,114,116,32,37,108,117,32,98,121,116,101,115,41,0,90,73,80,80,114,101,68,101,99,111,100,101,0,90,73,80,83,101,116,117,112,68,101,99,111,100,101,0,90,73,80,86,83,101,116,70,105,101,108,100,0,105,110,99,111,114,114,101,99,116,32,104,101,97,100,101,114,32,99,104,101,99,107,0,117,110,107,110,111,119,110,32,99,111,109,112,114,101,115,115,105,111,110,32,109,101,116,104,111,100,0,105,110,118,97,108,105,100,32,119,105,110,100,111,119,32,115,105,122,101,0,117,110,107,110,111,119,110,32,104,101,97,100,101,114,32,102,108,97,103,115,32,115,101,116,0,104,101,97,100,101,114,32,99,114,99,32,109,105,115,109,97,116,99,104,0,105,110,118,97,108,105,100,32,98,108,111,99,107,32,116,121,112,101,0,105,110,118,97,108,105,100,32,115,116,111,114,101,100,32,98,108,111,99,107,32,108,101,110,103,116,104,115,0,116,111,111,32,109,97,110,121,32,108,101,110,103,116,104,32,111,114,32,100,105,115,116,97,110,99,101,32,115,121,109,98,111,108,115,0,105,110,118,97,108,105,100,32,99,111,100,101,32,108,101,110,103,116,104,115,32,115,101,116,0,105,110,118,97,108,105,100,32,98,105,116,32,108,101,110,103,116,104,32,114,101,112,101,97,116,0,105,110,118,97,108,105,100,32,99,111,100,101,32,45,45,32,109,105,115,115,105,110,103,32,101,110,100,45,111,102,45,98,108,111,99,107,0,105,110,118,97,108,105,100,32,108,105,116,101,114,97,108,47,108,101,110,103,116,104,115,32,115,101,116,0,105,110,118,97,108,105,100,32,100,105,115,116,97,110,99,101,115,32,115,101,116,0,105,110,99,111,114,114,101,99,116,32,100,97,116,97,32,99,104,101,99,107,0,105,110,99,111,114,114,101,99,116,32,108,101,110,103,116,104,32,99,104,101,99,107,0,0,1,2,3,4,4,5,5,6,6,6,6,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,0,0,16,17,18,18,19,19,20,20,20,20,21,21,21,21,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,0,1,2,3,4,5,6,7,8,8,9,9,10,10,11,11,12,12,12,12,13,13,13,13,14,14,14,14,15,15,15,15,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,28,16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15,110,101,101,100,32,100,105,99,116,105,111,110,97,114,121,0,115,116,114,101,97,109,32,101,110,100,0,0,102,105,108,101,32,101,114,114,111,114,0,115,116,114,101,97,109,32,101,114,114,111,114,0,100,97,116,97,32,101,114,114,111,114,0,105,110,115,117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,0,98,117,102,102,101,114,32,101,114,114,111,114,0,105,110,99,111,109,112,97,116,105,98,108,101,32,118,101,114,115,105,111,110,0,105,110,118,97,108,105,100,32,100,105,115,116,97,110,99,101,32,116,111,111,32,102,97,114,32,98,97,99,107,0,105,110,118,97,108,105,100,32,100,105,115,116,97,110,99,101,32,99,111,100,101,0,105,110,118,97,108,105,100,32,108,105,116,101,114,97,108,47,108,101,110,103,116,104,32,99,111,100,101,0,0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,0,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125,1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250,0,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,0,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119,0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,248,249,250,83,79,83,0,76,83,69,0,66,111,103,117,115,32,109,101,115,115,97,103,101,32,99,111,100,101,32,37,100,0,65,76,73,71,78,95,84,89,80,69,32,105,115,32,119,114,111,110,103,44,32,112,108,101,97,115,101,32,102,105,120,0,77,65,88,95,65,76,76,79,67,95,67,72,85,78,75,32,105,115,32,119,114,111,110,103,44,32,112,108,101,97,115,101,32,102,105,120,0,66,111,103,117,115,32,98,117,102,102,101,114,32,99,111,110,116,114,111,108,32,109,111,100,101,0,73,110,118,97,108,105,100,32,99,111,109,112,111,110,101,110,116,32,73,68,32,37,100,32,105,110,32,83,79,83,0,73,110,118,97,108,105,100,32,99,114,111,112,32,114,101,113,117,101,115,116,0,68,67,84,32,99,111,101,102,102,105,99,105,101,110,116,32,111,117,116,32,111,102,32,114,97,110,103,101,0,68,67,84,32,115,99,97,108,101,100,32,98,108,111,99,107,32,115,105,122,101,32,37,100,120,37,100,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,67,111,109,112,111,110,101,110,116,32,105,110,100,101,120,32,37,100,58,32,109,105,115,109,97,116,99,104,105,110,103,32,115,97,109,112,108,105,110,103,32,114,97,116,105,111,32,37,100,58,37,100,44,32,37,100,58,37,100,44,32,37,99,0,66,111,103,117,115,32,72,117,102,102,109,97,110,32,116,97,98,108,101,32,100,101,102,105,110,105,116,105,111,110,0,66,111,103,117,115,32,105,110,112,117,116,32,99,111,108,111,114,115,112,97,99,101,0,66,111,103,117,115,32,74,80,69,71,32,99,111,108,111,114,115,112,97,99,101,0,66,111,103,117,115,32,109,97,114,107,101,114,32,108,101,110,103,116,104,0,87,114,111,110,103,32,74,80,69,71,32,108,105,98,114,97,114,121,32,118,101,114,115,105,111,110,58,32,108,105,98,114,97,114,121,32,105,115,32,37,100,44,32,99,97,108,108,101,114,32,101,120,112,101,99,116,115,32,37,100,0,83,97,109,112,108,105,110,103,32,102,97,99,116,111,114,115,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,105,110,116,101,114,108,101,97,118,101,100,32,115,99,97,110,0,73,110,118,97,108,105,100,32,109,101,109,111,114,121,32,112,111,111,108,32,99,111,100,101,32,37,100,0,85,110,115,117,112,112,111,114,116,101,100,32,74,80,69,71,32,100,97,116,97,32,112,114,101,99,105,115,105,111,110,32,37,100,0,73,110,118,97,108,105,100,32,112,114,111,103,114,101,115,115,105,118,101,32,112,97,114,97,109,101,116,101,114,115,32,83,115,61,37,100,32,83,101,61,37,100,32,65,104,61,37,100,32,65,108,61,37,100,0,73,110,118,97,108,105,100,32,112,114,111,103,114,101,115,115,105,118,101,32,112,97,114,97,109,101,116,101,114,115,32,97,116,32,115,99,97,110,32,115,99,114,105,112,116,32,101,110,116,114,121,32,37,100,0,66,111,103,117,115,32,115,97,109,112,108,105,110,103,32,102,97,99,116,111,114,115,0,73,110,118,97,108,105,100,32,115,99,97,110,32,115,99,114,105,112,116,32,97,116,32,101,110,116,114,121,32,37,100,0,73,109,112,114,111,112,101,114,32,99,97,108,108,32,116,111,32,74,80,69,71,32,108,105,98,114,97,114,121,32,105,110,32,115,116,97,116,101,32,37,100,0,74,80,69,71,32,112,97,114,97,109,101,116,101,114,32,115,116,114,117,99,116,32,109,105,115,109,97,116,99,104,58,32,108,105,98,114,97,114,121,32,116,104,105,110,107,115,32,115,105,122,101,32,105,115,32,37,117,44,32,99,97,108,108,101,114,32,101,120,112,101,99,116,115,32,37,117,0,66,111,103,117,115,32,118,105,114,116,117,97,108,32,97,114,114,97,121,32,97,99,99,101,115,115,0,66,117,102,102,101,114,32,112,97,115,115,101,100,32,116,111,32,74,80,69,71,32,108,105,98,114,97,114,121,32,105,115,32,116,111,111,32,115,109,97,108,108,0,83,117,115,112,101,110,115,105,111,110,32,110,111,116,32,97,108,108,111,119,101,100,32,104,101,114,101,0,67,67,73,82,54,48,49,32,115,97,109,112,108,105,110,103,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,32,121,101,116,0,84,111,111,32,109,97,110,121,32,99,111,108,111,114,32,99,111,109,112,111,110,101,110,116,115,58,32,37,100,44,32,109,97,120,32,37,100,0,85,110,115,117,112,112,111,114,116,101,100,32,99,111,108,111,114,32,99,111,110,118,101,114,115,105,111,110,32,114,101,113,117,101,115,116,0,66,111,103,117,115,32,68,65,67,32,105,110,100,101,120,32,37,100,0,66,111,103,117,115,32,68,65,67,32,118,97,108,117,101,32,48,120,37,120,0,66,111,103,117,115,32,68,72,84,32,105,110,100,101,120,32,37,100,0,66,111,103,117,115,32,68,81,84,32,105,110,100,101,120,32,37,100,0,69,109,112,116,121,32,74,80,69,71,32,105,109,97,103,101,32,40,68,78,76,32,110,111,116,32,115,117,112,112,111,114,116,101,100,41,0,82,101,97,100,32,102,114,111,109,32,69,77,83,32,102,97,105,108,101,100,0,87,114,105,116,101,32,116,111,32,69,77,83,32,102,97,105,108,101,100,0,68,105,100,110,39,116,32,101,120,112,101,99,116,32,109,111,114,101,32,116,104,97,110,32,111,110,101,32,115,99,97,110,0,73,110,112,117,116,32,102,105,108,101,32,114,101,97,100,32,101,114,114,111,114,0,79,117,116,112,117,116,32,102,105,108,101,32,119,114,105,116,101,32,101,114,114,111,114,32,45,45,45,32,111,117,116,32,111,102,32,100,105,115,107,32,115,112,97,99,101,63,0,70,114,97,99,116,105,111,110,97,108,32,115,97,109,112,108,105,110,103,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,32,121,101,116,0,72,117,102,102,109,97,110,32,99,111,100,101,32,115,105,122,101,32,116,97,98,108,101,32,111,118,101,114,102,108,111,119,0,77,105,115,115,105,110,103,32,72,117,102,102,109,97,110,32,99,111,100,101,32,116,97,98,108,101,32,101,110,116,114,121,0,77,97,120,105,109,117,109,32,115,117,112,112,111,114,116,101,100,32,105,109,97,103,101,32,100,105,109,101,110,115,105,111,110,32,105,115,32,37,117,32,112,105,120,101,108,115,0,69,109,112,116,121,32,105,110,112,117,116,32,102,105,108,101,0,80,114,101,109,97,116,117,114,101,32,101,110,100,32,111,102,32,105,110,112,117,116,32,102,105,108,101,0,67,97,110,110,111,116,32,116,114,97,110,115,99,111,100,101,32,100,117,101,32,116,111,32,109,117,108,116,105,112,108,101,32,117,115,101,32,111,102,32,113,117,97,110,116,105,122,97,116,105,111,110,32,116,97,98,108,101,32,37,100,0,83,99,97,110,32,115,99,114,105,112,116,32,100,111,101,115,32,110,111,116,32,116,114,97,110,115,109,105,116,32,97,108,108,32,100,97,116,97,0,73,110,118,97,108,105,100,32,99,111,108,111,114,32,113,117,97,110,116,105,122,97,116,105,111,110,32,109,111,100,101,32,99,104,97,110,103,101,0,78,111,116,32,105,109,112,108,101,109,101,110,116,101,100,32,121,101,116,0,82,101,113,117,101,115,116,101,100,32,102,101,97,116,117,114,101,32,119,97,115,32,111,109,105,116,116,101,100,32,97,116,32,99,111,109,112,105,108,101,32,116,105,109,101,0,65,114,105,116,104,109,101,116,105,99,32,116,97,98,108,101,32,48,120,37,48,50,120,32,119,97,115,32,110,111,116,32,100,101,102,105,110,101,100,0,66,97,99,107,105,110,103,32,115,116,111,114,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,72,117,102,102,109,97,110,32,116,97,98,108,101,32,48,120,37,48,50,120,32,119,97,115,32,110,111,116,32,100,101,102,105,110,101,100,0,74,80,69,71,32,100,97,116,97,115,116,114,101,97,109,32,99,111,110,116,97,105,110,115,32,110,111,32,105,109,97,103,101,0,81,117,97,110,116,105,122,97,116,105,111,110,32,116,97,98,108,101,32,48,120,37,48,50,120,32,119,97,115,32,110,111,116,32,100,101,102,105,110,101,100,0,78,111,116,32,97,32,74,80,69,71,32,102,105,108,101,58,32,115,116,97,114,116,115,32,119,105,116,104,32,48,120,37,48,50,120,32,48,120,37,48,50,120,0,73,110,115,117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,32,40,99,97,115,101,32,37,100,41,0,67,97,110,110,111,116,32,113,117,97,110,116,105,122,101,32,109,111,114,101,32,116,104,97,110,32,37,100,32,99,111,108,111,114,32,99,111,109,112,111,110,101,110,116,115,0,67,97,110,110,111,116,32,113,117,97,110,116,105,122,101,32,116,111,32,102,101,119,101,114,32,116,104,97,110,32,37,100,32,99,111,108,111,114,115,0,67,97,110,110,111,116,32,113,117,97,110,116,105,122,101,32,116,111,32,109,111,114,101,32,116,104,97,110,32,37,100,32,99,111,108,111,114,115,0,73,110,118,97,108,105,100,32,74,80,69,71,32,102,105,108,101,32,115,116,114,117,99,116,117,114,101,58,32,37,115,32,98,101,102,111,114,101,32,83,79,70,0,73,110,118,97,108,105,100,32,74,80,69,71,32,102,105,108,101,32,115,116,114,117,99,116,117,114,101,58,32,116,119,111,32,83,79,70,32,109,97,114,107,101,114,115,0,73,110,118,97,108,105,100,32,74,80,69,71,32,102,105,108,101,32,115,116,114,117,99,116,117,114,101,58,32,109,105,115,115,105,110,103,32,83,79,83,32,109,97,114,107,101,114,0,85,110,115,117,112,112,111,114,116,101,100,32,74,80,69,71,32,112,114,111,99,101,115,115,58,32,83,79,70,32,116,121,112,101,32,48,120,37,48,50,120,0,73,110,118,97,108,105,100,32,74,80,69,71,32,102,105,108,101,32,115,116,114,117,99,116,117,114,101,58,32,116,119,111,32,83,79,73,32,109,97,114,107,101,114,115,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,116,101,109,112,111,114,97,114,121,32,102,105,108,101,32,37,115,0,82,101,97,100,32,102,97,105,108,101,100,32,111,110,32,116,101,109,112,111,114,97,114,121,32,102,105,108,101,0,83,101,101,107,32,102,97,105,108,101,100,32,111,110,32,116,101,109,112,111,114,97,114,121,32,102,105,108,101,0,87,114,105,116,101,32,102,97,105,108,101,100,32,111,110,32,116,101,109,112,111,114,97,114,121,32,102,105,108,101,32,45,45,45,32,111,117,116,32,111,102,32,100,105,115,107,32,115,112,97,99,101,63,0,65,112,112,108,105,99,97,116,105,111,110,32,116,114,97,110,115,102,101,114,114,101,100,32,116,111,111,32,102,101,119,32,115,99,97,110,108,105,110,101,115,0,85,110,115,117,112,112,111,114,116,101,100,32,109,97,114,107,101,114,32,116,121,112,101,32,48,120,37,48,50,120,0,86,105,114,116,117,97,108,32,97,114,114,97,121,32,99,111,110,116,114,111,108,108,101,114,32,109,101,115,115,101,100,32,117,112,0,73,109,97,103,101,32,116,111,111,32,119,105,100,101,32,102,111,114,32,116,104,105,115,32,105,109,112,108,101,109,101,110,116,97,116,105,111,110,0,82,101,97,100,32,102,114,111,109,32,88,77,83,32,102,97,105,108,101,100,0,87,114,105,116,101,32,116,111,32,88,77,83,32,102,97,105,108,101,100,0,67,111,112,121,114,105,103,104,116,32,40,67,41,32,50,48,49,54,44,32,84,104,111,109,97,115,32,71,46,32,76,97,110,101,44,32,71,117,105,100,111,32,86,111,108,108,98,101,100,105,110,103,0,57,98,32,32,49,55,45,74,97,110,45,50,48,49,54,0,67,97,117,116,105,111,110,58,32,113,117,97,110,116,105,122,97,116,105,111,110,32,116,97,98,108,101,115,32,97,114,101,32,116,111,111,32,99,111,97,114,115,101,32,102,111,114,32,98,97,115,101,108,105,110,101,32,74,80,69,71,0,65,100,111,98,101,32,65,80,80,49,52,32,109,97,114,107,101,114,58,32,118,101,114,115,105,111,110,32,37,100,44,32,102,108,97,103,115,32,48,120,37,48,52,120,32,48,120,37,48,52,120,44,32,116,114,97,110,115,102,111,114,109,32,37,100,0,85,110,107,110,111,119,110,32,65,80,80,48,32,109,97,114,107,101,114,32,40,110,111,116,32,74,70,73,70,41,44,32,108,101,110,103,116,104,32,37,117,0,85,110,107,110,111,119,110,32,65,80,80,49,52,32,109,97,114,107,101,114,32,40,110,111,116,32,65,100,111,98,101,41,44,32,108,101,110,103,116,104,32,37,117,0,68,101,102,105,110,101,32,65,114,105,116,104,109,101,116,105,99,32,84,97,98,108,101,32,48,120,37,48,50,120,58,32,48,120,37,48,50,120,0,68,101,102,105,110,101,32,72,117,102,102,109,97,110,32,84,97,98,108,101,32,48,120,37,48,50,120,0,68,101,102,105,110,101,32,81,117,97,110,116,105,122,97,116,105,111,110,32,84,97,98,108,101,32,37,100,32,32,112,114,101,99,105,115,105,111,110,32,37,100,0,68,101,102,105,110,101,32,82,101,115,116,97,114,116,32,73,110,116,101,114,118,97,108,32,37,117,0,70,114,101,101,100,32,69,77,83,32,104,97,110,100,108,101,32,37,117,0,79,98,116,97,105,110,101,100,32,69,77,83,32,104,97,110,100,108,101,32,37,117,0,69,110,100,32,79,102,32,73,109,97,103,101,0,32,32,32,32,32,32,32,32,37,51,100,32,37,51,100,32,37,51,100,32,37,51,100,32,37,51,100,32,37,51,100,32,37,51,100,32,37,51,100,0,74,70,73,70,32,65,80,80,48,32,109,97,114,107,101,114,58,32,118,101,114,115,105,111,110,32,37,100,46,37,48,50,100,44,32,100,101,110,115,105,116,121,32,37,100,120,37,100,32,32,37,100,0,87,97,114,110,105,110,103,58,32,116,104,117,109,98,110,97,105,108,32,105,109,97,103,101,32,115,105,122,101,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,100,97,116,97,32,108,101,110,103,116,104,32,37,117,0,74,70,73,70,32,101,120,116,101,110,115,105,111,110,32,109,97,114,107,101,114,58,32,116,121,112,101,32,48,120,37,48,50,120,44,32,108,101,110,103,116,104,32,37,117,0,32,32,32,32,119,105,116,104,32,37,100,32,120,32,37,100,32,116,104,117,109,98,110,97,105,108,32,105,109,97,103,101,0,77,105,115,99,101,108,108,97,110,101,111,117,115,32,109,97,114,107,101,114,32,48,120,37,48,50,120,44,32,108,101,110,103,116,104,32,37,117,0,85,110,101,120,112,101,99,116,101,100,32,109,97,114,107,101,114,32,48,120,37,48,50,120,0,32,32,32,32,32,32,32,32,37,52,117,32,37,52,117,32,37,52,117,32,37,52,117,32,37,52,117,32,37,52,117,32,37,52,117,32,37,52,117,0,81,117,97,110,116,105,122,105,110,103,32,116,111,32,37,100,32,61,32,37,100,42,37,100,42,37,100,32,99,111,108,111,114,115,0,81,117,97,110,116,105,122,105,110,103,32,116,111,32,37,100,32,99,111,108,111,114,115,0,83,101,108,101,99,116,101,100,32,37,100,32,99,111,108,111,114,115,32,102,111,114,32,113,117,97,110,116,105,122,97,116,105,111,110,0,65,116,32,109,97,114,107,101,114,32,48,120,37,48,50,120,44,32,114,101,99,111,118,101,114,121,32,97,99,116,105,111,110,32,37,100,0,82,83,84,37,100,0,83,109,111,111,116,104,105,110,103,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,119,105,116,104,32,110,111,110,115,116,97,110,100,97,114,100,32,115,97,109,112,108,105,110,103,32,114,97,116,105,111,115,0,83,116,97,114,116,32,79,102,32,70,114,97,109,101,32,48,120,37,48,50,120,58,32,119,105,100,116,104,61,37,117,44,32,104,101,105,103,104,116,61,37,117,44,32,99,111,109,112,111,110,101,110,116,115,61,37,100,0,32,32,32,32,67,111,109,112,111,110,101,110,116,32,37,100,58,32,37,100,104,120,37,100,118,32,113,61,37,100,0,83,116,97,114,116,32,111,102,32,73,109,97,103,101,0,83,116,97,114,116,32,79,102,32,83,99,97,110,58,32,37,100,32,99,111,109,112,111,110,101,110,116,115,0,32,32,32,32,67,111,109,112,111,110,101,110,116,32,37,100,58,32,100,99,61,37,100,32,97,99,61,37,100,0,32,32,83,115,61,37,100,44,32,83,101,61,37,100,44,32,65,104,61,37,100,44,32,65,108,61,37,100,0,67,108,111,115,101,100,32,116,101,109,112,111,114,97,114,121,32,102,105,108,101,32,37,115,0,79,112,101,110,101,100,32,116,101,109,112,111,114,97,114,121,32,102,105,108,101,32,37,115,0,74,70,73,70,32,101,120,116,101,110,115,105,111,110,32,109,97,114,107,101,114,58,32,74,80,69,71,45,99,111,109,112,114,101,115,115,101,100,32,116,104,117,109,98,110,97,105,108,32,105,109,97,103,101,44,32,108,101,110,103,116,104,32,37,117,0,74,70,73,70,32,101,120,116,101,110,115,105,111,110,32,109,97,114,107,101,114,58,32,112,97,108,101,116,116,101,32,116,104,117,109,98,110,97,105,108,32,105,109,97,103,101,44,32,108,101,110,103,116,104,32,37,117,0,74,70,73,70,32,101,120,116,101,110,115,105,111,110,32,109,97,114,107,101,114,58,32,82,71,66,32,116,104,117,109,98,110,97,105,108,32,105,109,97,103,101,44,32,108,101,110,103,116,104,32,37,117,0,85,110,114,101,99,111,103,110,105,122,101,100,32,99,111,109,112,111,110,101,110,116,32,73,68,115,32,37,100,32,37,100,32,37,100,44,32,97,115,115,117,109,105,110,103,32,89,67,98,67,114,0,70,114,101,101,100,32,88,77,83,32,104,97,110,100,108,101,32,37,117,0,79,98,116,97,105,110,101,100,32,88,77,83,32,104,97,110,100,108,101,32,37,117,0,85,110,107,110,111,119,110,32,65,100,111,98,101,32,99,111,108,111,114,32,116,114,97,110,115,102,111,114,109,32,99,111,100,101,32,37,100,0,67,111,114,114,117,112,116,32,74,80,69,71,32,100,97,116,97,58,32,98,97,100,32,97,114,105,116,104,109,101,116,105,99,32,99,111,100,101,0,73,110,99,111,110,115,105,115,116,101,110,116,32,112,114,111,103,114,101,115,115,105,111,110,32,115,101,113,117,101,110,99,101,32,102,111,114,32,99,111,109,112,111,110,101,110,116,32,37,100,32,99,111,101,102,102,105,99,105,101,110,116,32,37,100,0,67,111,114,114,117,112,116,32,74,80,69,71,32,100,97,116,97,58,32,37,117,32,101,120,116,114,97,110,101,111,117,115,32,98,121,116,101,115,32,98,101,102,111,114,101,32,109,97,114,107,101,114,32,48,120,37,48,50,120,0,67,111,114,114,117,112,116,32,74,80,69,71,32,100,97,116,97,58,32,112,114,101,109,97,116,117,114,101,32,101,110,100,32,111,102,32,100,97,116,97,32,115,101,103,109,101,110,116,0,67,111,114,114,117,112,116,32,74,80,69,71,32,100,97,116,97,58,32,98,97,100,32,72,117,102,102,109,97,110,32,99,111,100,101,0,87,97,114,110,105,110,103,58,32,117,110,107,110,111,119,110,32,74,70,73,70,32,114,101,118,105,115,105,111,110,32,110,117,109,98,101,114,32,37,100,46,37,48,50,100,0,80,114,101,109,97,116,117,114,101,32,101,110,100,32,111,102,32,74,80,69,71,32,102,105,108,101,0,67,111,114,114,117,112,116,32,74,80,69,71,32,100,97,116,97,58,32,102,111,117,110,100,32,109,97,114,107,101,114,32,48,120,37,48,50,120,32,105,110,115,116,101,97,100,32,111,102,32,82,83,84,37,100,0,73,110,118,97,108,105,100,32,83,79,83,32,112,97,114,97,109,101,116,101,114,115,32,102,111,114,32,115,101,113,117,101,110,116,105,97,108,32,74,80,69,71,0,65,112,112,108,105,99,97,116,105,111,110,32,116,114,97,110,115,102,101,114,114,101,100,32,116,111,111,32,109,97,110,121,32,115,99,97,110,108,105,110,101,115,0,37,115,10,0,0,192,48,240,12,204,60,252,3,195,51,243,15,207,63,255,128,64,176,112,140,76,188,124,131,67,179,115,143,79,191,127,32,224,16,208,44,236,28,220,35,227,19,211,47,239,31,223,160,96,144,80,172,108,156,92,163,99,147,83,175,111,159,95,8,200,56,248,4,196,52,244,11,203,59,251,7,199,55,247,136,72,184,120,132,68,180,116,139,75,187,123,135,71,183,119,40,232,24,216,36,228,20,212,43,235,27,219,39,231,23,215,168,104,152,88,164,100,148,84,171,107,155,91,167,103,151,87,2,194,50,242,14,206,62,254,1,193,49,241,13,205,61,253,130,66,178,114,142,78,190,126,129,65,177,113,141,77,189,125,34,226,18,210,46,238,30,222,33,225,17,209,45,237,29,221,162,98,146,82,174,110,158,94,161,97,145,81,173,109,157,93,10,202,58,250,6,198,54,246,9,201,57,249,5,197,53,245,138,74,186,122,134,70,182,118,137,73,185,121,133,69,181,117,42,234,26,218,38,230,22,214,41,233,25,217,37,229,21,213,170,106,154,90,166,102,150,86,169,105,153,89,165,101,149,85,74,80,69,71,77,69,77,0,37,108,100,37,99,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,105,110,102,105,110,105,116,121,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,4,7,3,6,5],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+153730);allocate([17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+164446);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}var TTY={ttys:[],init:(function(){}),shutdown:(function(){}),register:(function(dev,ops){TTY.ttys[dev]={input:[],output:[],ops:ops};FS.registerDevice(dev,TTY.stream_ops)}),stream_ops:{open:(function(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}stream.tty=tty;stream.seekable=false}),close:(function(stream){stream.tty.ops.flush(stream.tty)}),flush:(function(stream){stream.tty.ops.flush(stream.tty)}),read:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}for(var i=0;i<length;i++){try{stream.tty.ops.put_char(stream.tty,buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})},default_tty_ops:{get_char:(function(tty){if(!tty.input.length){var result=null;if(ENVIRONMENT_IS_NODE){var BUFSIZE=256;var buf=new Buffer(BUFSIZE);var bytesRead=0;var fd=process.stdin.fd;var usingDevice=false;try{fd=fs.openSync("/dev/stdin","r");usingDevice=true}catch(e){}bytesRead=fs.readSync(fd,buf,0,BUFSIZE,null);if(usingDevice){fs.closeSync(fd)}if(bytesRead>0){result=buf.slice(0,bytesRead).toString("utf-8")}else{result=null}}else if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else if(typeof readline=="function"){result=readline();if(result!==null){result+="\n"}}if(!result){return null}tty.input=intArrayFromString(result,true)}return tty.input.shift()}),put_char:(function(tty,val){if(val===null||val===10){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}})},default_tty1_ops:{put_char:(function(tty,val){if(val===null||val===10){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}})}};var MEMFS={ops_table:null,mount:(function(mount){return MEMFS.createNode(null,"/",16384|511,0)}),createNode:(function(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(!MEMFS.ops_table){MEMFS.ops_table={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap,msync:MEMFS.stream_ops.msync}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}}}var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.timestamp=Date.now();if(parent){parent.contents[name]=node}return node}),getFileDataAsRegularArray:(function(node){if(node.contents&&node.contents.subarray){var arr=[];for(var i=0;i<node.usedBytes;++i)arr.push(node.contents[i]);return arr}return node.contents}),getFileDataAsTypedArray:(function(node){if(!node.contents)return new Uint8Array;if(node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)}),expandFileStorage:(function(node,newCapacity){if(node.contents&&node.contents.subarray&&newCapacity>node.contents.length){node.contents=MEMFS.getFileDataAsRegularArray(node);node.usedBytes=node.contents.length}if(!node.contents||node.contents.subarray){var prevCapacity=node.contents?node.contents.buffer.byteLength:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)|0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0);return}if(!node.contents&&newCapacity>0)node.contents=[];while(node.contents.length<newCapacity)node.contents.push(0)}),resizeFileStorage:(function(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0;return}if(!node.contents||node.contents.subarray){var oldContents=node.contents;node.contents=new Uint8Array(new ArrayBuffer(newSize));if(oldContents){node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)))}node.usedBytes=newSize;return}if(!node.contents)node.contents=[];if(node.contents.length>newSize)node.contents.length=newSize;else while(node.contents.length<newSize)node.contents.push(0);node.usedBytes=newSize}),node_ops:{getattr:(function(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.timestamp);attr.mtime=new Date(node.timestamp);attr.ctime=new Date(node.timestamp);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}}),lookup:(function(parent,name){throw FS.genericErrors[ERRNO_CODES.ENOENT]}),mknod:(function(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)}),rename:(function(old_node,new_dir,new_name){if(FS.isDir(old_node.mode)){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){for(var i in new_node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}}}delete old_node.parent.contents[old_node.name];old_node.name=new_name;new_dir.contents[new_name]=old_node;old_node.parent=new_dir}),unlink:(function(parent,name){delete parent.contents[name]}),rmdir:(function(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}delete parent.contents[name]}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node}),readlink:(function(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return node.link})},stream_ops:{read:(function(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);assert(size>=0);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size}),write:(function(stream,buffer,offset,length,position,canOwn){if(!length)return 0;var node=stream.node;node.timestamp=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=new Uint8Array(buffer.subarray(offset,offset+length));node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray)node.contents.set(buffer.subarray(offset,offset+length),position);else{for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}}node.usedBytes=Math.max(node.usedBytes,position+length);return length}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position}),allocate:(function(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&(contents.buffer===buffer||contents.buffer===buffer.buffer)){allocated=false;ptr=contents.byteOffset}else{if(position>0||position+length<stream.node.usedBytes){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}allocated=true;ptr=_malloc(length);if(!ptr){throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)}buffer.set(contents,ptr)}return{ptr:ptr,allocated:allocated}}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(mmapFlags&2){return 0}var bytesWritten=MEMFS.stream_ops.write(stream,buffer,0,length,offset,false);return 0})}};var IDBFS={dbs:{},indexedDB:(function(){if(typeof indexedDB!=="undefined")return indexedDB;var ret=null;if(typeof window==="object")ret=window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB;assert(ret,"IDBFS used, but indexedDB not supported");return ret}),DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:(function(mount){return MEMFS.mount.apply(null,arguments)}),syncfs:(function(mount,populate,callback){IDBFS.getLocalSet(mount,(function(err,local){if(err)return callback(err);IDBFS.getRemoteSet(mount,(function(err,remote){if(err)return callback(err);var src=populate?remote:local;var dst=populate?local:remote;IDBFS.reconcile(src,dst,callback)}))}))}),getDB:(function(name,callback){var db=IDBFS.dbs[name];if(db){return callback(null,db)}var req;try{req=IDBFS.indexedDB().open(name,IDBFS.DB_VERSION)}catch(e){return callback(e)}req.onupgradeneeded=(function(e){var db=e.target.result;var transaction=e.target.transaction;var fileStore;if(db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)){fileStore=transaction.objectStore(IDBFS.DB_STORE_NAME)}else{fileStore=db.createObjectStore(IDBFS.DB_STORE_NAME)}if(!fileStore.indexNames.contains("timestamp")){fileStore.createIndex("timestamp","timestamp",{unique:false})}});req.onsuccess=(function(){db=req.result;IDBFS.dbs[name]=db;callback(null,db)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),getLocalSet:(function(mount,callback){var entries={};function isRealDir(p){return p!=="."&&p!==".."}function toAbsolute(root){return(function(p){return PATH.join2(root,p)})}var check=FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));while(check.length){var path=check.pop();var stat;try{stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){check.push.apply(check,FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))}entries[path]={timestamp:stat.mtime}}return callback(null,{type:"local",entries:entries})}),getRemoteSet:(function(mount,callback){var entries={};IDBFS.getDB(mount.mountpoint,(function(err,db){if(err)return callback(err);var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readonly");transaction.onerror=(function(e){callback(this.error);e.preventDefault()});var store=transaction.objectStore(IDBFS.DB_STORE_NAME);var index=store.index("timestamp");index.openKeyCursor().onsuccess=(function(event){var cursor=event.target.result;if(!cursor){return callback(null,{type:"remote",db:db,entries:entries})}entries[cursor.primaryKey]={timestamp:cursor.key};cursor.continue()})}))}),loadLocalEntry:(function(path,callback){var stat,node;try{var lookup=FS.lookupPath(path);node=lookup.node;stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){return callback(null,{timestamp:stat.mtime,mode:stat.mode})}else if(FS.isFile(stat.mode)){node.contents=MEMFS.getFileDataAsTypedArray(node);return callback(null,{timestamp:stat.mtime,mode:stat.mode,contents:node.contents})}else{return callback(new Error("node type not supported"))}}),storeLocalEntry:(function(path,entry,callback){try{if(FS.isDir(entry.mode)){FS.mkdir(path,entry.mode)}else if(FS.isFile(entry.mode)){FS.writeFile(path,entry.contents,{encoding:"binary",canOwn:true})}else{return callback(new Error("node type not supported"))}FS.chmod(path,entry.mode);FS.utime(path,entry.timestamp,entry.timestamp)}catch(e){return callback(e)}callback(null)}),removeLocalEntry:(function(path,callback){try{var lookup=FS.lookupPath(path);var stat=FS.stat(path);if(FS.isDir(stat.mode)){FS.rmdir(path)}else if(FS.isFile(stat.mode)){FS.unlink(path)}}catch(e){return callback(e)}callback(null)}),loadRemoteEntry:(function(store,path,callback){var req=store.get(path);req.onsuccess=(function(event){callback(null,event.target.result)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),storeRemoteEntry:(function(store,path,entry,callback){var req=store.put(entry,path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),removeRemoteEntry:(function(store,path,callback){var req=store.delete(path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),reconcile:(function(src,dst,callback){var total=0;var create=[];Object.keys(src.entries).forEach((function(key){var e=src.entries[key];var e2=dst.entries[key];if(!e2||e.timestamp>e2.timestamp){create.push(key);total++}}));var remove=[];Object.keys(dst.entries).forEach((function(key){var e=dst.entries[key];var e2=src.entries[key];if(!e2){remove.push(key);total++}}));if(!total){return callback(null)}var errored=false;var completed=0;var db=src.type==="remote"?src.db:dst.db;var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readwrite");var store=transaction.objectStore(IDBFS.DB_STORE_NAME);function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=total){return callback(null)}}transaction.onerror=(function(e){done(this.error);e.preventDefault()});create.sort().forEach((function(path){if(dst.type==="local"){IDBFS.loadRemoteEntry(store,path,(function(err,entry){if(err)return done(err);IDBFS.storeLocalEntry(path,entry,done)}))}else{IDBFS.loadLocalEntry(path,(function(err,entry){if(err)return done(err);IDBFS.storeRemoteEntry(store,path,entry,done)}))}}));remove.sort().reverse().forEach((function(path){if(dst.type==="local"){IDBFS.removeLocalEntry(path,done)}else{IDBFS.removeRemoteEntry(store,path,done)}}))})};var NODEFS={isWindows:false,staticInit:(function(){NODEFS.isWindows=!!process.platform.match(/^win/)}),mount:(function(mount){assert(ENVIRONMENT_IS_NODE);return NODEFS.createNode(null,"/",NODEFS.getMode(mount.opts.root),0)}),createNode:(function(parent,name,mode,dev){if(!FS.isDir(mode)&&!FS.isFile(mode)&&!FS.isLink(mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=FS.createNode(parent,name,mode);node.node_ops=NODEFS.node_ops;node.stream_ops=NODEFS.stream_ops;return node}),getMode:(function(path){var stat;try{stat=fs.lstatSync(path);if(NODEFS.isWindows){stat.mode=stat.mode|(stat.mode&146)>>1}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return stat.mode}),realPath:(function(node){var parts=[];while(node.parent!==node){parts.push(node.name);node=node.parent}parts.push(node.mount.opts.root);parts.reverse();return PATH.join.apply(null,parts)}),flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:(function(flags){flags&=~32768;if(flags in NODEFS.flagsToPermissionStringMap){return NODEFS.flagsToPermissionStringMap[flags]}else{throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}}),node_ops:{getattr:(function(node){var path=NODEFS.realPath(node);var stat;try{stat=fs.lstatSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(NODEFS.isWindows&&!stat.blksize){stat.blksize=4096}if(NODEFS.isWindows&&!stat.blocks){stat.blocks=(stat.size+stat.blksize-1)/stat.blksize|0}return{dev:stat.dev,ino:stat.ino,mode:stat.mode,nlink:stat.nlink,uid:stat.uid,gid:stat.gid,rdev:stat.rdev,size:stat.size,atime:stat.atime,mtime:stat.mtime,ctime:stat.ctime,blksize:stat.blksize,blocks:stat.blocks}}),setattr:(function(node,attr){var path=NODEFS.realPath(node);try{if(attr.mode!==undefined){fs.chmodSync(path,attr.mode);node.mode=attr.mode}if(attr.timestamp!==undefined){var date=new Date(attr.timestamp);fs.utimesSync(path,date,date)}if(attr.size!==undefined){fs.truncateSync(path,attr.size)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),lookup:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);var mode=NODEFS.getMode(path);return NODEFS.createNode(parent,name,mode)}),mknod:(function(parent,name,mode,dev){var node=NODEFS.createNode(parent,name,mode,dev);var path=NODEFS.realPath(node);try{if(FS.isDir(node.mode)){fs.mkdirSync(path,node.mode)}else{fs.writeFileSync(path,"",{mode:node.mode})}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return node}),rename:(function(oldNode,newDir,newName){var oldPath=NODEFS.realPath(oldNode);var newPath=PATH.join2(NODEFS.realPath(newDir),newName);try{fs.renameSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),unlink:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.unlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),rmdir:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.rmdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readdir:(function(node){var path=NODEFS.realPath(node);try{return fs.readdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),symlink:(function(parent,newName,oldPath){var newPath=PATH.join2(NODEFS.realPath(parent),newName);try{fs.symlinkSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readlink:(function(node){var path=NODEFS.realPath(node);try{path=fs.readlinkSync(path);path=NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root),path);return path}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}})},stream_ops:{open:(function(stream){var path=NODEFS.realPath(stream.node);try{if(FS.isFile(stream.node.mode)){stream.nfd=fs.openSync(path,NODEFS.flagsToPermissionString(stream.flags))}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),close:(function(stream){try{if(FS.isFile(stream.node.mode)&&stream.nfd){fs.closeSync(stream.nfd)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),read:(function(stream,buffer,offset,length,position){if(length===0)return 0;var nbuffer=new Buffer(length);var res;try{res=fs.readSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(res>0){for(var i=0;i<res;i++){buffer[offset+i]=nbuffer[i]}}return res}),write:(function(stream,buffer,offset,length,position){var nbuffer=new Buffer(buffer.subarray(offset,offset+length));var res;try{res=fs.writeSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}return res}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){try{var stat=fs.fstatSync(stream.nfd);position+=stat.size}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:(function(mount){assert(ENVIRONMENT_IS_WORKER);if(!WORKERFS.reader)WORKERFS.reader=new FileReaderSync;var root=WORKERFS.createNode(null,"/",WORKERFS.DIR_MODE,0);var createdParents={};function ensureParent(path){var parts=path.split("/");var parent=root;for(var i=0;i<parts.length-1;i++){var curr=parts.slice(0,i+1).join("/");if(!createdParents[curr]){createdParents[curr]=WORKERFS.createNode(parent,curr,WORKERFS.DIR_MODE,0)}parent=createdParents[curr]}return parent}function base(path){var parts=path.split("/");return parts[parts.length-1]}Array.prototype.forEach.call(mount.opts["files"]||[],(function(file){WORKERFS.createNode(ensureParent(file.name),base(file.name),WORKERFS.FILE_MODE,0,file,file.lastModifiedDate)}));(mount.opts["blobs"]||[]).forEach((function(obj){WORKERFS.createNode(ensureParent(obj["name"]),base(obj["name"]),WORKERFS.FILE_MODE,0,obj["data"])}));(mount.opts["packages"]||[]).forEach((function(pack){pack["metadata"].files.forEach((function(file){var name=file.filename.substr(1);WORKERFS.createNode(ensureParent(name),base(name),WORKERFS.FILE_MODE,0,pack["blob"].slice(file.start,file.end))}))}));return root}),createNode:(function(parent,name,mode,dev,contents,mtime){var node=FS.createNode(parent,name,mode);node.mode=mode;node.node_ops=WORKERFS.node_ops;node.stream_ops=WORKERFS.stream_ops;node.timestamp=(mtime||new Date).getTime();assert(WORKERFS.FILE_MODE!==WORKERFS.DIR_MODE);if(mode===WORKERFS.FILE_MODE){node.size=contents.size;node.contents=contents}else{node.size=4096;node.contents={}}if(parent){parent.contents[name]=node}return node}),node_ops:{getattr:(function(node){return{dev:1,ino:undefined,mode:node.mode,nlink:1,uid:0,gid:0,rdev:undefined,size:node.size,atime:new Date(node.timestamp),mtime:new Date(node.timestamp),ctime:new Date(node.timestamp),blksize:4096,blocks:Math.ceil(node.size/4096)}}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}}),lookup:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}),mknod:(function(parent,name,mode,dev){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rename:(function(oldNode,newDir,newName){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),unlink:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rmdir:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readdir:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),symlink:(function(parent,newName,oldPath){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readlink:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)})},stream_ops:{read:(function(stream,buffer,offset,length,position){if(position>=stream.node.size)return 0;var chunk=stream.node.contents.slice(position,position+length);var ab=WORKERFS.reader.readAsArrayBuffer(chunk);buffer.set(new Uint8Array(ab),offset);return chunk.size}),write:(function(stream,buffer,offset,length,position){throw new FS.ErrnoError(ERRNO_CODES.EIO)}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.size}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var _stdin=allocate(1,"i32*",ALLOC_STATIC);var _stdout=allocate(1,"i32*",ALLOC_STATIC);var _stderr=allocate(1,"i32*",ALLOC_STATIC);var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,handleFSError:(function(e){if(!(e instanceof FS.ErrnoError))throw e+" : "+stackTrace();return ___setErrNo(e.errno)}),lookupPath:(function(path,opts){path=PATH.resolve(FS.cwd(),path);opts=opts||{};if(!path)return{path:"",node:null};var defaults={follow_mount:true,recurse_count:0};for(var key in defaults){if(opts[key]===undefined){opts[key]=defaults[key]}}if(opts.recurse_count>8){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}var parts=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),false);var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}current=FS.lookupNode(current,parts[i]);current_path=PATH.join2(current_path,parts[i]);if(FS.isMountpoint(current)){if(!islast||islast&&opts.follow_mount){current=current.mounted.root}}if(!islast||opts.follow){var count=0;while(FS.isLink(current.mode)){var link=FS.readlink(current_path);current_path=PATH.resolve(PATH.dirname(current_path),link);var lookup=FS.lookupPath(current_path,{recurse_count:opts.recurse_count});current=lookup.node;if(count++>40){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}}}}return{path:current_path,node:current}}),getPath:(function(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?mount+"/"+path:mount+path}path=path?node.name+"/"+path:node.name;node=node.parent}}),hashName:(function(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length}),hashAddNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node}),hashRemoveNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}}),lookupNode:(function(parent,name){var err=FS.mayLookup(parent);if(err){throw new FS.ErrnoError(err,parent)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)}),createNode:(function(parent,name,mode,rdev){if(!FS.FSNode){FS.FSNode=(function(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.mounted=null;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.node_ops={};this.stream_ops={};this.rdev=rdev});FS.FSNode.prototype={};var readMode=292|73;var writeMode=146;Object.defineProperties(FS.FSNode.prototype,{read:{get:(function(){return(this.mode&readMode)===readMode}),set:(function(val){val?this.mode|=readMode:this.mode&=~readMode})},write:{get:(function(){return(this.mode&writeMode)===writeMode}),set:(function(val){val?this.mode|=writeMode:this.mode&=~writeMode})},isFolder:{get:(function(){return FS.isDir(this.mode)})},isDevice:{get:(function(){return FS.isChrdev(this.mode)})}})}var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node}),destroyNode:(function(node){FS.hashRemoveNode(node)}),isRoot:(function(node){return node===node.parent}),isMountpoint:(function(node){return!!node.mounted}),isFile:(function(mode){return(mode&61440)===32768}),isDir:(function(mode){return(mode&61440)===16384}),isLink:(function(mode){return(mode&61440)===40960}),isChrdev:(function(mode){return(mode&61440)===8192}),isBlkdev:(function(mode){return(mode&61440)===24576}),isFIFO:(function(mode){return(mode&61440)===4096}),isSocket:(function(mode){return(mode&49152)===49152}),flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:(function(str){var flags=FS.flagModes[str];if(typeof flags==="undefined"){throw new Error("Unknown file open mode: "+str)}return flags}),flagsToPermissionString:(function(flag){var perms=["r","w","rw"][flag&3];if(flag&512){perms+="w"}return perms}),nodePermissions:(function(node,perms){if(FS.ignorePermissions){return 0}if(perms.indexOf("r")!==-1&&!(node.mode&292)){return ERRNO_CODES.EACCES}else if(perms.indexOf("w")!==-1&&!(node.mode&146)){return ERRNO_CODES.EACCES}else if(perms.indexOf("x")!==-1&&!(node.mode&73)){return ERRNO_CODES.EACCES}return 0}),mayLookup:(function(dir){var err=FS.nodePermissions(dir,"x");if(err)return err;if(!dir.node_ops.lookup)return ERRNO_CODES.EACCES;return 0}),mayCreate:(function(dir,name){try{var node=FS.lookupNode(dir,name);return ERRNO_CODES.EEXIST}catch(e){}return FS.nodePermissions(dir,"wx")}),mayDelete:(function(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var err=FS.nodePermissions(dir,"wx");if(err){return err}if(isdir){if(!FS.isDir(node.mode)){return ERRNO_CODES.ENOTDIR}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return ERRNO_CODES.EBUSY}}else{if(FS.isDir(node.mode)){return ERRNO_CODES.EISDIR}}return 0}),mayOpen:(function(node,flags){if(!node){return ERRNO_CODES.ENOENT}if(FS.isLink(node.mode)){return ERRNO_CODES.ELOOP}else if(FS.isDir(node.mode)){if((flags&2097155)!==0||flags&512){return ERRNO_CODES.EISDIR}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))}),MAX_OPEN_FDS:4096,nextfd:(function(fd_start,fd_end){fd_start=fd_start||0;fd_end=fd_end||FS.MAX_OPEN_FDS;for(var fd=fd_start;fd<=fd_end;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(ERRNO_CODES.EMFILE)}),getStream:(function(fd){return FS.streams[fd]}),createStream:(function(stream,fd_start,fd_end){if(!FS.FSStream){FS.FSStream=(function(){});FS.FSStream.prototype={};Object.defineProperties(FS.FSStream.prototype,{object:{get:(function(){return this.node}),set:(function(val){this.node=val})},isRead:{get:(function(){return(this.flags&2097155)!==1})},isWrite:{get:(function(){return(this.flags&2097155)!==0})},isAppend:{get:(function(){return this.flags&1024})}})}var newStream=new FS.FSStream;for(var p in stream){newStream[p]=stream[p]}stream=newStream;var fd=FS.nextfd(fd_start,fd_end);stream.fd=fd;FS.streams[fd]=stream;return stream}),closeStream:(function(fd){FS.streams[fd]=null}),chrdev_stream_ops:{open:(function(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;if(stream.stream_ops.open){stream.stream_ops.open(stream)}}),llseek:(function(){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)})},major:(function(dev){return dev>>8}),minor:(function(dev){return dev&255}),makedev:(function(ma,mi){return ma<<8|mi}),registerDevice:(function(dev,ops){FS.devices[dev]={stream_ops:ops}}),getDevice:(function(dev){return FS.devices[dev]}),getMounts:(function(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push.apply(check,m.mounts)}return mounts}),syncfs:(function(populate,callback){if(typeof populate==="function"){callback=populate;populate=false}var mounts=FS.getMounts(FS.root.mount);var completed=0;function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=mounts.length){callback(null)}}mounts.forEach((function(mount){if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)}))}),mount:(function(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}}var mount={type:type,opts:opts,mountpoint:mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot}),unmount:(function(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach((function(hash){var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.indexOf(current.mount)!==-1){FS.destroyNode(current)}current=next}}));node.mounted=null;var idx=node.mount.mounts.indexOf(mount);assert(idx!==-1);node.mount.mounts.splice(idx,1)}),lookup:(function(parent,name){return parent.node_ops.lookup(parent,name)}),mknod:(function(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);if(!name||name==="."||name===".."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.mayCreate(parent,name);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.mknod(parent,name,mode,dev)}),create:(function(path,mode){mode=mode!==undefined?mode:438;mode&=4095;mode|=32768;return FS.mknod(path,mode,0)}),mkdir:(function(path,mode){mode=mode!==undefined?mode:511;mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)}),mkdev:(function(path,mode,dev){if(typeof dev==="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)}),symlink:(function(oldpath,newpath){if(!PATH.resolve(oldpath)){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var newname=PATH.basename(newpath);var err=FS.mayCreate(parent,newname);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.symlink(parent,newname,oldpath)}),rename:(function(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;try{lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!old_dir||!new_dir)throw new FS.ErrnoError(ERRNO_CODES.ENOENT);if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(ERRNO_CODES.EXDEV)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}relative=PATH.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var err=FS.mayDelete(old_dir,old_name,isdir);if(err){throw new FS.ErrnoError(err)}err=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(err){throw new FS.ErrnoError(err)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(new_dir!==old_dir){err=FS.nodePermissions(old_dir,"w");if(err){throw new FS.ErrnoError(err)}}try{if(FS.trackingDelegate["willMovePath"]){FS.trackingDelegate["willMovePath"](old_path,new_path)}}catch(e){console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name)}catch(e){throw e}finally{FS.hashAddNode(old_node)}try{if(FS.trackingDelegate["onMovePath"])FS.trackingDelegate["onMovePath"](old_path,new_path)}catch(e){console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}}),rmdir:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,true);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}return node.node_ops.readdir(node)}),unlink:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,false);if(err){if(err===ERRNO_CODES.EISDIR)err=ERRNO_CODES.EPERM;throw new FS.ErrnoError(err)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.unlink(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readlink:(function(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!link.node_ops.readlink){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return PATH.resolve(FS.getPath(link.parent),link.node_ops.readlink(link))}),stat:(function(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!node.node_ops.getattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return node.node_ops.getattr(node)}),lstat:(function(path){return FS.stat(path,true)}),chmod:(function(path,mode,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,timestamp:Date.now()})}),lchmod:(function(path,mode){FS.chmod(path,mode,true)}),fchmod:(function(fd,mode){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chmod(stream.node,mode)}),chown:(function(path,uid,gid,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{timestamp:Date.now()})}),lchown:(function(path,uid,gid){FS.chown(path,uid,gid,true)}),fchown:(function(fd,uid,gid){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chown(stream.node,uid,gid)}),truncate:(function(path,len){if(len<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.nodePermissions(node,"w");if(err){throw new FS.ErrnoError(err)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})}),ftruncate:(function(fd,len){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}FS.truncate(stream.node,len)}),utime:(function(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{timestamp:Math.max(atime,mtime)})}),open:(function(path,flags,mode,fd_start,fd_end){if(path===""){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}flags=typeof flags==="string"?FS.modeStringToFlags(flags):flags;mode=typeof mode==="undefined"?438:mode;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path==="object"){node=path}else{path=PATH.normalize(path);try{var lookup=FS.lookupPath(path,{follow:!(flags&131072)});node=lookup.node}catch(e){}}var created=false;if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(ERRNO_CODES.EEXIST)}}else{node=FS.mknod(path,mode,0);created=true}}if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(FS.isChrdev(node.mode)){flags&=~512}if(flags&65536&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}if(!created){var err=FS.mayOpen(node,flags);if(err){throw new FS.ErrnoError(err)}}if(flags&512){FS.truncate(node,0)}flags&=~(128|512);var stream=FS.createStream({node:node,path:FS.getPath(node),flags:flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false},fd_start,fd_end);if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!FS.readFiles)FS.readFiles={};if(!(path in FS.readFiles)){FS.readFiles[path]=1;Module["printErr"]("read file: "+path)}}try{if(FS.trackingDelegate["onOpenFile"]){var trackingFlags=0;if((flags&2097155)!==1){trackingFlags|=FS.tracking.openFlags.READ}if((flags&2097155)!==0){trackingFlags|=FS.tracking.openFlags.WRITE}FS.trackingDelegate["onOpenFile"](path,trackingFlags)}}catch(e){console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: "+e.message)}return stream}),close:(function(stream){if(stream.getdents)stream.getdents=null;try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}}),llseek:(function(stream,offset,whence){if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}stream.position=stream.stream_ops.llseek(stream,offset,whence);stream.ungotten=[];return stream.position}),read:(function(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.read){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead}),write:(function(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.write){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(stream.flags&1024){FS.llseek(stream,0,2)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;try{if(stream.path&&FS.trackingDelegate["onWriteToFile"])FS.trackingDelegate["onWriteToFile"](stream.path)}catch(e){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+e.message)}return bytesWritten}),allocate:(function(stream,offset,length){if(offset<0||length<=0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}stream.stream_ops.allocate(stream,offset,length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EACCES)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}return stream.stream_ops.mmap(stream,buffer,offset,length,position,prot,flags)}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!stream||!stream.stream_ops.msync){return 0}return stream.stream_ops.msync(stream,buffer,offset,length,mmapFlags)}),munmap:(function(stream){return 0}),ioctl:(function(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)}return stream.stream_ops.ioctl(stream,cmd,arg)}),readFile:(function(path,opts){opts=opts||{};opts.flags=opts.flags||"r";opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret=UTF8ArrayToString(buf,0)}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret}),writeFile:(function(path,data,opts){opts=opts||{};opts.flags=opts.flags||"w";opts.encoding=opts.encoding||"utf8";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var stream=FS.open(path,opts.flags,opts.mode);if(opts.encoding==="utf8"){var buf=new Uint8Array(lengthBytesUTF8(data)+1);var actualNumBytes=stringToUTF8Array(data,buf,0,buf.length);FS.write(stream,buf,0,actualNumBytes,0,opts.canOwn)}else if(opts.encoding==="binary"){FS.write(stream,data,0,data.length,0,opts.canOwn)}FS.close(stream)}),cwd:(function(){return FS.currentPath}),chdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}var err=FS.nodePermissions(lookup.node,"x");if(err){throw new FS.ErrnoError(err)}FS.currentPath=lookup.path}),createDefaultDirectories:(function(){FS.mkdir("/tmp");FS.mkdir("/home");FS.mkdir("/home/web_user")}),createDefaultDevices:(function(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:(function(){return 0}),write:(function(stream,buffer,offset,length,pos){return length})});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var random_device;if(typeof crypto!=="undefined"){var randomBuffer=new Uint8Array(1);random_device=(function(){crypto.getRandomValues(randomBuffer);return randomBuffer[0]})}else if(ENVIRONMENT_IS_NODE){random_device=(function(){return require("crypto").randomBytes(1)[0]})}else{random_device=(function(){return Math.random()*256|0})}FS.createDevice("/dev","random",random_device);FS.createDevice("/dev","urandom",random_device);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")}),createSpecialDirectories:(function(){FS.mkdir("/proc");FS.mkdir("/proc/self");FS.mkdir("/proc/self/fd");FS.mount({mount:(function(){var node=FS.createNode("/proc/self","fd",16384|511,73);node.node_ops={lookup:(function(parent,name){var fd=+name;var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);var ret={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:(function(){return stream.path})}};ret.parent=ret;return ret})};return node})},{},"/proc/self/fd")}),createStandardStreams:(function(){if(Module["stdin"]){FS.createDevice("/dev","stdin",Module["stdin"])}else{FS.symlink("/dev/tty","/dev/stdin")}if(Module["stdout"]){FS.createDevice("/dev","stdout",null,Module["stdout"])}else{FS.symlink("/dev/tty","/dev/stdout")}if(Module["stderr"]){FS.createDevice("/dev","stderr",null,Module["stderr"])}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin","r");assert(stdin.fd===0,"invalid handle for stdin ("+stdin.fd+")");var stdout=FS.open("/dev/stdout","w");assert(stdout.fd===1,"invalid handle for stdout ("+stdout.fd+")");var stderr=FS.open("/dev/stderr","w");assert(stderr.fd===2,"invalid handle for stderr ("+stderr.fd+")")}),ensureErrnoError:(function(){if(FS.ErrnoError)return;FS.ErrnoError=function ErrnoError(errno,node){this.node=node;this.setErrno=(function(errno){this.errno=errno;for(var key in ERRNO_CODES){if(ERRNO_CODES[key]===errno){this.code=key;break}}});this.setErrno(errno);this.message=ERRNO_MESSAGES[errno]};FS.ErrnoError.prototype=new Error;FS.ErrnoError.prototype.constructor=FS.ErrnoError;[ERRNO_CODES.ENOENT].forEach((function(code){FS.genericErrors[code]=new FS.ErrnoError(code);FS.genericErrors[code].stack="<generic error, no stack>"}))}),staticInit:(function(){FS.ensureErrnoError();FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices();FS.createSpecialDirectories();FS.filesystems={"MEMFS":MEMFS,"IDBFS":IDBFS,"NODEFS":NODEFS,"WORKERFS":WORKERFS}}),init:(function(input,output,error){assert(!FS.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");FS.init.initialized=true;FS.ensureErrnoError();Module["stdin"]=input||Module["stdin"];Module["stdout"]=output||Module["stdout"];Module["stderr"]=error||Module["stderr"];FS.createStandardStreams()}),quit:(function(){FS.init.initialized=false;var fflush=Module["_fflush"];if(fflush)fflush(0);for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}}),getMode:(function(canRead,canWrite){var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode}),joinPath:(function(parts,forceRelative){var path=PATH.join.apply(null,parts);if(forceRelative&&path[0]=="/")path=path.substr(1);return path}),absolutePath:(function(relative,base){return PATH.resolve(base,relative)}),standardizePath:(function(path){return PATH.normalize(path)}),findObject:(function(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object}else{___setErrNo(ret.error);return null}}),analyzePath:(function(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret}),createFolder:(function(parent,name,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.mkdir(path,mode)}),createPath:(function(parent,path,canRead,canWrite){parent=typeof parent==="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current}),createFile:(function(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.create(path,mode)}),createDataFile:(function(parent,name,data,canRead,canWrite,canOwn){var path=name?PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name):parent;var mode=FS.getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data==="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,"w");FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}return node}),createDevice:(function(parent,name,input,output){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(!!input,!!output);if(!FS.createDevice.major)FS.createDevice.major=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open:(function(stream){stream.seekable=false}),close:(function(stream){if(output&&output.buffer&&output.buffer.length){output(10)}}),read:(function(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})});return FS.mkdev(path,mode,dev)}),createLink:(function(parent,name,target,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);return FS.symlink(target,path)}),forceLoadFile:(function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;var success=true;if(typeof XMLHttpRequest!=="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else if(Module["read"]){try{obj.contents=intArrayFromString(Module["read"](obj.url),true);obj.usedBytes=obj.contents.length}catch(e){success=false}}else{throw new Error("Cannot load without read() or XMLHttpRequest.")}if(!success)___setErrNo(ERRNO_CODES.EIO);return success}),createLazyFile:(function(parent,name,url,canRead,canWrite){function LazyUint8Array(){this.lengthKnown=false;this.chunks=[]}LazyUint8Array.prototype.get=function LazyUint8Array_get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=idx/this.chunkSize|0;return this.getter(chunkNum)[chunkOffset]};LazyUint8Array.prototype.setDataGetter=function LazyUint8Array_setDataGetter(getter){this.getter=getter};LazyUint8Array.prototype.cacheLength=function LazyUint8Array_cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=(function(from,to){if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);if(typeof Uint8Array!="undefined")xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}else{return intArrayFromString(xhr.responseText||"",true)}});var lazyArray=this;lazyArray.setDataGetter((function(chunkNum){var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]==="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]==="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]}));this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true};if(typeof XMLHttpRequest!=="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;Object.defineProperty(lazyArray,"length",{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._length})});Object.defineProperty(lazyArray,"chunkSize",{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize})});var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url:url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperty(node,"usedBytes",{get:(function(){return this.contents.length})});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach((function(key){var fn=node.stream_ops[key];stream_ops[key]=function forceLoadLazyFile(){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}return fn.apply(null,arguments)}}));stream_ops.read=function stream_ops_read(stream,buffer,offset,length,position){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);assert(size>=0);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size};node.stream_ops=stream_ops;return node}),createPreloadedFile:(function(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn,preFinish){Browser.init();var fullname=name?PATH.resolve(PATH.join2(parent,name)):parent;var dep=getUniqueRunDependency("cp "+fullname);function processData(byteArray){function finish(byteArray){if(preFinish)preFinish();if(!dontCreateFile){FS.createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}if(onload)onload();removeRunDependency(dep)}var handled=false;Module["preloadPlugins"].forEach((function(plugin){if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,(function(){if(onerror)onerror();removeRunDependency(dep)}));handled=true}}));if(!handled)finish(byteArray)}addRunDependency(dep);if(typeof url=="string"){Browser.asyncLoad(url,(function(byteArray){processData(byteArray)}),onerror)}else{processData(url)}}),indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_NAME:(function(){return"EM_FS_"+window.location.pathname}),DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=function openRequest_onupgradeneeded(){console.log("creating db");var db=openRequest.result;db.createObjectStore(FS.DB_STORE_NAME)};openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;var transaction=db.transaction([FS.DB_STORE_NAME],"readwrite");var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var putRequest=files.put(FS.analyzePath(path).object.contents,path);putRequest.onsuccess=function putRequest_onsuccess(){ok++;if(ok+fail==total)finish()};putRequest.onerror=function putRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror}),loadFilesFromDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=onerror;openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;try{var transaction=db.transaction([FS.DB_STORE_NAME],"readonly")}catch(e){onerror(e);return}var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var getRequest=files.get(path);getRequest.onsuccess=function getRequest_onsuccess(){if(FS.analyzePath(path).exists){FS.unlink(path)}FS.createDataFile(PATH.dirname(path),PATH.basename(path),getRequest.result,true,true,true);ok++;if(ok+fail==total)finish()};getRequest.onerror=function getRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror})};Module["FS"]=FS;var PATH={splitPath:(function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)}),normalizeArray:(function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up--;up){parts.unshift("..")}}return parts}),normalize:(function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path}),dirname:(function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir}),basename:(function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)}),extname:(function(path){return PATH.splitPath(path)[3]}),join:(function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))}),join2:(function(l,r){return PATH.normalize(l+"/"+r)}),resolve:(function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:FS.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){return""}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter((function(p){return!!p})),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."}),relative:(function(from,to){from=PATH.resolve(from).substr(1);to=PATH.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")})};function _emscripten_set_main_loop_timing(mode,value){Browser.mainLoop.timingMode=mode;Browser.mainLoop.timingValue=value;if(!Browser.mainLoop.func){return 1}if(mode==0){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setTimeout(){setTimeout(Browser.mainLoop.runner,value)};Browser.mainLoop.method="timeout"}else if(mode==1){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_rAF(){Browser.requestAnimationFrame(Browser.mainLoop.runner)};Browser.mainLoop.method="rAF"}else if(mode==2){if(!window["setImmediate"]){var setImmediates=[];var emscriptenMainLoopMessageId="__emcc";function Browser_setImmediate_messageHandler(event){if(event.source===window&&event.data===emscriptenMainLoopMessageId){event.stopPropagation();setImmediates.shift()()}}window.addEventListener("message",Browser_setImmediate_messageHandler,true);window["setImmediate"]=function Browser_emulated_setImmediate(func){setImmediates.push(func);window.postMessage(emscriptenMainLoopMessageId,"*")}}Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setImmediate(){window["setImmediate"](Browser.mainLoop.runner)};Browser.mainLoop.method="immediate"}return 0}function _emscripten_set_main_loop(func,fps,simulateInfiniteLoop,arg,noSetTiming){Module["noExitRuntime"]=true;assert(!Browser.mainLoop.func,"emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.");Browser.mainLoop.func=func;Browser.mainLoop.arg=arg;var thisMainLoopId=Browser.mainLoop.currentlyRunningMainloop;Browser.mainLoop.runner=function Browser_mainLoop_runner(){if(ABORT)return;if(Browser.mainLoop.queue.length>0){var start=Date.now();var blocker=Browser.mainLoop.queue.shift();blocker.func(blocker.arg);if(Browser.mainLoop.remainingBlockers){var remaining=Browser.mainLoop.remainingBlockers;var next=remaining%1==0?remaining-1:Math.floor(remaining);if(blocker.counted){Browser.mainLoop.remainingBlockers=next}else{next=next+.5;Browser.mainLoop.remainingBlockers=(8*remaining+next)/9}}console.log('main loop blocker "'+blocker.name+'" took '+(Date.now()-start)+" ms");Browser.mainLoop.updateStatus();setTimeout(Browser.mainLoop.runner,0);return}if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;Browser.mainLoop.currentFrameNumber=Browser.mainLoop.currentFrameNumber+1|0;if(Browser.mainLoop.timingMode==1&&Browser.mainLoop.timingValue>1&&Browser.mainLoop.currentFrameNumber%Browser.mainLoop.timingValue!=0){Browser.mainLoop.scheduler();return}if(Browser.mainLoop.method==="timeout"&&Module.ctx){Module.printErr("Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!");Browser.mainLoop.method=""}Browser.mainLoop.runIter((function(){if(typeof arg!=="undefined"){Runtime.dynCall("vi",func,[arg])}else{Runtime.dynCall("v",func)}}));if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;if(typeof SDL==="object"&&SDL.audio&&SDL.audio.queueNewAudioData)SDL.audio.queueNewAudioData();Browser.mainLoop.scheduler()};if(!noSetTiming){if(fps&&fps>0)_emscripten_set_main_loop_timing(0,1e3/fps);else _emscripten_set_main_loop_timing(1,1);Browser.mainLoop.scheduler()}if(simulateInfiniteLoop){throw"SimulateInfiniteLoop"}}var Browser={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:(function(){Browser.mainLoop.scheduler=null;Browser.mainLoop.currentlyRunningMainloop++}),resume:(function(){Browser.mainLoop.currentlyRunningMainloop++;var timingMode=Browser.mainLoop.timingMode;var timingValue=Browser.mainLoop.timingValue;var func=Browser.mainLoop.func;Browser.mainLoop.func=null;_emscripten_set_main_loop(func,0,false,Browser.mainLoop.arg,true);_emscripten_set_main_loop_timing(timingMode,timingValue);Browser.mainLoop.scheduler()}),updateStatus:(function(){if(Module["setStatus"]){var message=Module["statusMessage"]||"Please wait...";var remaining=Browser.mainLoop.remainingBlockers;var expected=Browser.mainLoop.expectedBlockers;if(remaining){if(remaining<expected){Module["setStatus"](message+" ("+(expected-remaining)+"/"+expected+")")}else{Module["setStatus"](message)}}else{Module["setStatus"]("")}}}),runIter:(function(func){if(ABORT)return;if(Module["preMainLoop"]){var preRet=Module["preMainLoop"]();if(preRet===false){return}}try{func()}catch(e){if(e instanceof ExitStatus){return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}if(Module["postMainLoop"])Module["postMainLoop"]()})},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:(function(){if(!Module["preloadPlugins"])Module["preloadPlugins"]=[];if(Browser.initted)return;Browser.initted=true;try{new Blob;Browser.hasBlobConstructor=true}catch(e){Browser.hasBlobConstructor=false;console.log("warning: no blob constructor, cannot create blobs with mimetypes")}Browser.BlobBuilder=typeof MozBlobBuilder!="undefined"?MozBlobBuilder:typeof WebKitBlobBuilder!="undefined"?WebKitBlobBuilder:!Browser.hasBlobConstructor?console.log("warning: no BlobBuilder"):null;Browser.URLObject=typeof window!="undefined"?window.URL?window.URL:window.webkitURL:undefined;if(!Module.noImageDecoding&&typeof Browser.URLObject==="undefined"){console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");Module.noImageDecoding=true}var imagePlugin={};imagePlugin["canHandle"]=function imagePlugin_canHandle(name){return!Module.noImageDecoding&&/\.(jpg|jpeg|png|bmp)$/i.test(name)};imagePlugin["handle"]=function imagePlugin_handle(byteArray,name,onload,onerror){var b=null;if(Browser.hasBlobConstructor){try{b=new Blob([byteArray],{type:Browser.getMimetype(name)});if(b.size!==byteArray.length){b=new Blob([(new Uint8Array(byteArray)).buffer],{type:Browser.getMimetype(name)})}}catch(e){Runtime.warnOnce("Blob constructor present but fails: "+e+"; falling back to blob builder")}}if(!b){var bb=new Browser.BlobBuilder;bb.append((new Uint8Array(byteArray)).buffer);b=bb.getBlob()}var url=Browser.URLObject.createObjectURL(b);var img=new Image;img.onload=function img_onload(){assert(img.complete,"Image "+name+" could not be decoded");var canvas=document.createElement("canvas");canvas.width=img.width;canvas.height=img.height;var ctx=canvas.getContext("2d");ctx.drawImage(img,0,0);Module["preloadedImages"][name]=canvas;Browser.URLObject.revokeObjectURL(url);if(onload)onload(byteArray)};img.onerror=function img_onerror(event){console.log("Image "+url+" could not be decoded");if(onerror)onerror()};img.src=url};Module["preloadPlugins"].push(imagePlugin);var audioPlugin={};audioPlugin["canHandle"]=function audioPlugin_canHandle(name){return!Module.noAudioDecoding&&name.substr(-4)in{".ogg":1,".wav":1,".mp3":1}};audioPlugin["handle"]=function audioPlugin_handle(byteArray,name,onload,onerror){var done=false;function finish(audio){if(done)return;done=true;Module["preloadedAudios"][name]=audio;if(onload)onload(byteArray)}function fail(){if(done)return;done=true;Module["preloadedAudios"][name]=new Audio;if(onerror)onerror()}if(Browser.hasBlobConstructor){try{var b=new Blob([byteArray],{type:Browser.getMimetype(name)})}catch(e){return fail()}var url=Browser.URLObject.createObjectURL(b);var audio=new Audio;audio.addEventListener("canplaythrough",(function(){finish(audio)}),false);audio.onerror=function audio_onerror(event){if(done)return;console.log("warning: browser could not fully decode audio "+name+", trying slower base64 approach");function encode64(data){var BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var PAD="=";var ret="";var leftchar=0;var leftbits=0;for(var i=0;i<data.length;i++){leftchar=leftchar<<8|data[i];leftbits+=8;while(leftbits>=6){var curr=leftchar>>leftbits-6&63;leftbits-=6;ret+=BASE[curr]}}if(leftbits==2){ret+=BASE[(leftchar&3)<<4];ret+=PAD+PAD}else if(leftbits==4){ret+=BASE[(leftchar&15)<<2];ret+=PAD}return ret}audio.src="data:audio/x-"+name.substr(-3)+";base64,"+encode64(byteArray);finish(audio)};audio.src=url;Browser.safeSetTimeout((function(){finish(audio)}),1e4)}else{return fail()}};Module["preloadPlugins"].push(audioPlugin);var canvas=Module["canvas"];function pointerLockChange(){Browser.pointerLock=document["pointerLockElement"]===canvas||document["mozPointerLockElement"]===canvas||document["webkitPointerLockElement"]===canvas||document["msPointerLockElement"]===canvas}if(canvas){canvas.requestPointerLock=canvas["requestPointerLock"]||canvas["mozRequestPointerLock"]||canvas["webkitRequestPointerLock"]||canvas["msRequestPointerLock"]||(function(){});canvas.exitPointerLock=document["exitPointerLock"]||document["mozExitPointerLock"]||document["webkitExitPointerLock"]||document["msExitPointerLock"]||(function(){});canvas.exitPointerLock=canvas.exitPointerLock.bind(document);document.addEventListener("pointerlockchange",pointerLockChange,false);document.addEventListener("mozpointerlockchange",pointerLockChange,false);document.addEventListener("webkitpointerlockchange",pointerLockChange,false);document.addEventListener("mspointerlockchange",pointerLockChange,false);if(Module["elementPointerLock"]){canvas.addEventListener("click",(function(ev){if(!Browser.pointerLock&&canvas.requestPointerLock){canvas.requestPointerLock();ev.preventDefault()}}),false)}}}),createContext:(function(canvas,useWebGL,setInModule,webGLContextAttributes){if(useWebGL&&Module.ctx&&canvas==Module.canvas)return Module.ctx;var ctx;var contextHandle;if(useWebGL){var contextAttributes={antialias:false,alpha:false};if(webGLContextAttributes){for(var attribute in webGLContextAttributes){contextAttributes[attribute]=webGLContextAttributes[attribute]}}contextHandle=GL.createContext(canvas,contextAttributes);if(contextHandle){ctx=GL.getContext(contextHandle).GLctx}canvas.style.backgroundColor="black"}else{ctx=canvas.getContext("2d")}if(!ctx)return null;if(setInModule){if(!useWebGL)assert(typeof GLctx==="undefined","cannot set in module if GLctx is used, but we are a non-GL context that would replace it");Module.ctx=ctx;if(useWebGL)GL.makeContextCurrent(contextHandle);Module.useWebGL=useWebGL;Browser.moduleContextCreatedCallbacks.forEach((function(callback){callback()}));Browser.init()}return ctx}),destroyContext:(function(canvas,useWebGL,setInModule){}),fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:(function(lockPointer,resizeCanvas,vrDevice){Browser.lockPointer=lockPointer;Browser.resizeCanvas=resizeCanvas;Browser.vrDevice=vrDevice;if(typeof Browser.lockPointer==="undefined")Browser.lockPointer=true;if(typeof Browser.resizeCanvas==="undefined")Browser.resizeCanvas=false;if(typeof Browser.vrDevice==="undefined")Browser.vrDevice=null;var canvas=Module["canvas"];function fullScreenChange(){Browser.isFullScreen=false;var canvasContainer=canvas.parentNode;if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvasContainer){canvas.cancelFullScreen=document["cancelFullScreen"]||document["mozCancelFullScreen"]||document["webkitCancelFullScreen"]||document["msExitFullscreen"]||document["exitFullscreen"]||(function(){});canvas.cancelFullScreen=canvas.cancelFullScreen.bind(document);if(Browser.lockPointer)canvas.requestPointerLock();Browser.isFullScreen=true;if(Browser.resizeCanvas)Browser.setFullScreenCanvasSize()}else{canvasContainer.parentNode.insertBefore(canvas,canvasContainer);canvasContainer.parentNode.removeChild(canvasContainer);if(Browser.resizeCanvas)Browser.setWindowedCanvasSize()}if(Module["onFullScreen"])Module["onFullScreen"](Browser.isFullScreen);Browser.updateCanvasDimensions(canvas)}if(!Browser.fullScreenHandlersInstalled){Browser.fullScreenHandlersInstalled=true;document.addEventListener("fullscreenchange",fullScreenChange,false);document.addEventListener("mozfullscreenchange",fullScreenChange,false);document.addEventListener("webkitfullscreenchange",fullScreenChange,false);document.addEventListener("MSFullscreenChange",fullScreenChange,false)}var canvasContainer=document.createElement("div");canvas.parentNode.insertBefore(canvasContainer,canvas);canvasContainer.appendChild(canvas);canvasContainer.requestFullScreen=canvasContainer["requestFullScreen"]||canvasContainer["mozRequestFullScreen"]||canvasContainer["msRequestFullscreen"]||(canvasContainer["webkitRequestFullScreen"]?(function(){canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"])}):null);if(vrDevice){canvasContainer.requestFullScreen({vrDisplay:vrDevice})}else{canvasContainer.requestFullScreen()}}),nextRAF:0,fakeRequestAnimationFrame:(function(func){var now=Date.now();if(Browser.nextRAF===0){Browser.nextRAF=now+1e3/60}else{while(now+2>=Browser.nextRAF){Browser.nextRAF+=1e3/60}}var delay=Math.max(Browser.nextRAF-now,0);setTimeout(func,delay)}),requestAnimationFrame:function requestAnimationFrame(func){if(typeof window==="undefined"){Browser.fakeRequestAnimationFrame(func)}else{if(!window.requestAnimationFrame){window.requestAnimationFrame=window["requestAnimationFrame"]||window["mozRequestAnimationFrame"]||window["webkitRequestAnimationFrame"]||window["msRequestAnimationFrame"]||window["oRequestAnimationFrame"]||Browser.fakeRequestAnimationFrame}window.requestAnimationFrame(func)}},safeCallback:(function(func){return(function(){if(!ABORT)return func.apply(null,arguments)})}),allowAsyncCallbacks:true,queuedAsyncCallbacks:[],pauseAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=false}),resumeAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=true;if(Browser.queuedAsyncCallbacks.length>0){var callbacks=Browser.queuedAsyncCallbacks;Browser.queuedAsyncCallbacks=[];callbacks.forEach((function(func){func()}))}}),safeRequestAnimationFrame:(function(func){return Browser.requestAnimationFrame((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}))}),safeSetTimeout:(function(func,timeout){Module["noExitRuntime"]=true;return setTimeout((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}),timeout)}),safeSetInterval:(function(func,timeout){Module["noExitRuntime"]=true;return setInterval((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}}),timeout)}),getMimetype:(function(name){return{"jpg":"image/jpeg","jpeg":"image/jpeg","png":"image/png","bmp":"image/bmp","ogg":"audio/ogg","wav":"audio/wav","mp3":"audio/mpeg"}[name.substr(name.lastIndexOf(".")+1)]}),getUserMedia:(function(func){if(!window.getUserMedia){window.getUserMedia=navigator["getUserMedia"]||navigator["mozGetUserMedia"]}window.getUserMedia(func)}),getMovementX:(function(event){return event["movementX"]||event["mozMovementX"]||event["webkitMovementX"]||0}),getMovementY:(function(event){return event["movementY"]||event["mozMovementY"]||event["webkitMovementY"]||0}),getMouseWheelDelta:(function(event){var delta=0;switch(event.type){case"DOMMouseScroll":delta=event.detail;break;case"mousewheel":delta=event.wheelDelta;break;case"wheel":delta=event["deltaY"];break;default:throw"unrecognized mouse wheel event: "+event.type}return delta}),mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:(function(event){if(Browser.pointerLock){if(event.type!="mousemove"&&"mozMovementX"in event){Browser.mouseMovementX=Browser.mouseMovementY=0}else{Browser.mouseMovementX=Browser.getMovementX(event);Browser.mouseMovementY=Browser.getMovementY(event)}if(typeof SDL!="undefined"){Browser.mouseX=SDL.mouseX+Browser.mouseMovementX;Browser.mouseY=SDL.mouseY+Browser.mouseMovementY}else{Browser.mouseX+=Browser.mouseMovementX;Browser.mouseY+=Browser.mouseMovementY}}else{var rect=Module["canvas"].getBoundingClientRect();var cw=Module["canvas"].width;var ch=Module["canvas"].height;var scrollX=typeof window.scrollX!=="undefined"?window.scrollX:window.pageXOffset;var scrollY=typeof window.scrollY!=="undefined"?window.scrollY:window.pageYOffset;if(event.type==="touchstart"||event.type==="touchend"||event.type==="touchmove"){var touch=event.touch;if(touch===undefined){return}var adjustedX=touch.pageX-(scrollX+rect.left);var adjustedY=touch.pageY-(scrollY+rect.top);adjustedX=adjustedX*(cw/rect.width);adjustedY=adjustedY*(ch/rect.height);var coords={x:adjustedX,y:adjustedY};if(event.type==="touchstart"){Browser.lastTouches[touch.identifier]=coords;Browser.touches[touch.identifier]=coords}else if(event.type==="touchend"||event.type==="touchmove"){var last=Browser.touches[touch.identifier];if(!last)last=coords;Browser.lastTouches[touch.identifier]=last;Browser.touches[touch.identifier]=coords}return}var x=event.pageX-(scrollX+rect.left);var y=event.pageY-(scrollY+rect.top);x=x*(cw/rect.width);y=y*(ch/rect.height);Browser.mouseMovementX=x-Browser.mouseX;Browser.mouseMovementY=y-Browser.mouseY;Browser.mouseX=x;Browser.mouseY=y}}),xhrLoad:(function(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)}),asyncLoad:(function(url,onload,onerror,noRunDep){Browser.xhrLoad(url,(function(arrayBuffer){assert(arrayBuffer,'Loading data file "'+url+'" failed (no arrayBuffer).');onload(new Uint8Array(arrayBuffer));if(!noRunDep)removeRunDependency("al "+url)}),(function(event){if(onerror){onerror()}else{throw'Loading data file "'+url+'" failed.'}}));if(!noRunDep)addRunDependency("al "+url)}),resizeListeners:[],updateResizeListeners:(function(){var canvas=Module["canvas"];Browser.resizeListeners.forEach((function(listener){listener(canvas.width,canvas.height)}))}),setCanvasSize:(function(width,height,noUpdates){var canvas=Module["canvas"];Browser.updateCanvasDimensions(canvas,width,height);if(!noUpdates)Browser.updateResizeListeners()}),windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags|8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),setWindowedCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags&~8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),updateCanvasDimensions:(function(canvas,wNative,hNative){if(wNative&&hNative){canvas.widthNative=wNative;canvas.heightNative=hNative}else{wNative=canvas.widthNative;hNative=canvas.heightNative}var w=wNative;var h=hNative;if(Module["forcedAspectRatio"]&&Module["forcedAspectRatio"]>0){if(w/h<Module["forcedAspectRatio"]){w=Math.round(h*Module["forcedAspectRatio"])}else{h=Math.round(w/Module["forcedAspectRatio"])}}if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvas.parentNode&&typeof screen!="undefined"){var factor=Math.min(screen.width/w,screen.height/h);w=Math.round(w*factor);h=Math.round(h*factor)}if(Browser.resizeCanvas){if(canvas.width!=w)canvas.width=w;if(canvas.height!=h)canvas.height=h;if(typeof canvas.style!="undefined"){canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}else{if(canvas.width!=wNative)canvas.width=wNative;if(canvas.height!=hNative)canvas.height=hNative;if(typeof canvas.style!="undefined"){if(w!=wNative||h!=hNative){canvas.style.setProperty("width",w+"px","important");canvas.style.setProperty("height",h+"px","important")}else{canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}}}),wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:(function(){var handle=Browser.nextWgetRequestHandle;Browser.nextWgetRequestHandle++;return handle})};Module["_i64Subtract"]=_i64Subtract;function ___assert_fail(condition,filename,line,func){ABORT=true;throw"Assertion failed: "+Pointer_stringify(condition)+", at: "+[filename?Pointer_stringify(filename):"unknown filename",line,func?Pointer_stringify(func):"unknown function"]+" at "+stackTrace()}var _SItoD=true;var _SItoF=true;Module["_memset"]=_memset;var _BDtoILow=true;Module["_bitshift64Shl"]=_bitshift64Shl;var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:(function(dirfd,path){if(path[0]!=="/"){var dir;if(dirfd===-100){dir=FS.cwd()}else{var dirstream=FS.getStream(dirfd);if(!dirstream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);dir=dirstream.path}path=PATH.join2(dir,path)}return path}),doStat:(function(func,path,buf){try{var stat=func(path)}catch(e){if(e&&e.node&&PATH.normalize(path)!==PATH.normalize(FS.getPath(e.node))){return-ERRNO_CODES.ENOTDIR}throw e}HEAP32[buf>>2]=stat.dev;HEAP32[buf+4>>2]=0;HEAP32[buf+8>>2]=stat.ino;HEAP32[buf+12>>2]=stat.mode;HEAP32[buf+16>>2]=stat.nlink;HEAP32[buf+20>>2]=stat.uid;HEAP32[buf+24>>2]=stat.gid;HEAP32[buf+28>>2]=stat.rdev;HEAP32[buf+32>>2]=0;HEAP32[buf+36>>2]=stat.size;HEAP32[buf+40>>2]=4096;HEAP32[buf+44>>2]=stat.blocks;HEAP32[buf+48>>2]=stat.atime.getTime()/1e3|0;HEAP32[buf+52>>2]=0;HEAP32[buf+56>>2]=stat.mtime.getTime()/1e3|0;HEAP32[buf+60>>2]=0;HEAP32[buf+64>>2]=stat.ctime.getTime()/1e3|0;HEAP32[buf+68>>2]=0;HEAP32[buf+72>>2]=stat.ino;return 0}),doMsync:(function(addr,stream,len,flags){var buffer=new Uint8Array(HEAPU8.subarray(addr,addr+len));FS.msync(stream,buffer,0,len,flags)}),doMkdir:(function(path,mode){path=PATH.normalize(path);if(path[path.length-1]==="/")path=path.substr(0,path.length-1);FS.mkdir(path,mode,0);return 0}),doMknod:(function(path,mode,dev){switch(mode&61440){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:return-ERRNO_CODES.EINVAL}FS.mknod(path,mode,dev);return 0}),doReadlink:(function(path,buf,bufsize){if(bufsize<=0)return-ERRNO_CODES.EINVAL;var ret=FS.readlink(path);ret=ret.slice(0,Math.max(0,bufsize));writeStringToMemory(ret,buf,true);return ret.length}),doAccess:(function(path,amode){if(amode&~7){return-ERRNO_CODES.EINVAL}var node;var lookup=FS.lookupPath(path,{follow:true});node=lookup.node;var perms="";if(amode&4)perms+="r";if(amode&2)perms+="w";if(amode&1)perms+="x";if(perms&&FS.nodePermissions(node,perms)){return-ERRNO_CODES.EACCES}return 0}),doDup:(function(path,flags,suggestFD){var suggest=FS.getStream(suggestFD);if(suggest)FS.close(suggest);return FS.open(path,flags,0,suggestFD,suggestFD).fd}),doReadv:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.read(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len)break}return ret}),doWritev:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.write(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr}return ret}),varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),getStreamFromFD:(function(){var stream=FS.getStream(SYSCALLS.get());if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return stream}),getSocketFromFD:(function(){var socket=SOCKFS.getSocket(SYSCALLS.get());if(!socket)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return socket}),getSocketAddress:(function(allowNull){var addrp=SYSCALLS.get(),addrlen=SYSCALLS.get();if(allowNull&&addrp===0)return null;var info=__read_sockaddr(addrp,addrlen);if(info.errno)throw new FS.ErrnoError(info.errno);info.addr=DNS.lookup_addr(info.addr)||info.addr;return info}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall192(which,varargs){SYSCALLS.varargs=varargs;try{var addr=SYSCALLS.get(),len=SYSCALLS.get(),prot=SYSCALLS.get(),flags=SYSCALLS.get(),fd=SYSCALLS.get(),off=SYSCALLS.get();off<<=12;var ptr;var allocated=false;if(fd===-1){ptr=_malloc(len);if(!ptr)return-ERRNO_CODES.ENOMEM;_memset(ptr,0,len);allocated=true}else{var info=FS.getStream(fd);if(!info)return-ERRNO_CODES.EBADF;var res=FS.mmap(info,HEAPU8,addr,len,off,prot,flags);ptr=res.ptr;allocated=res.allocated}SYSCALLS.mappings[ptr]={malloc:ptr,len:len,allocated:allocated,fd:fd,flags:flags};return ptr}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall195(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),buf=SYSCALLS.get();return SYSCALLS.doStat(FS.stat,path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall197(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),buf=SYSCALLS.get();return SYSCALLS.doStat(FS.stat,stream.path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var _UItoF=true;function ___lock(){}function ___unlock(){}Module["_i64Add"]=_i64Add;var _emscripten_cleanup_setjmp=true;var _emscripten_postinvoke=true;var _floor=Math_floor;var _emscripten_prep_setjmp=true;var _sqrt=Math_sqrt;var _emscripten_check_longjmp=true;function _realloc(){throw"bad"}Module["_realloc"]=_realloc;Module["_saveSetjmp"]=_saveSetjmp;function ___syscall91(which,varargs){SYSCALLS.varargs=varargs;try{var addr=SYSCALLS.get(),len=SYSCALLS.get();var info=SYSCALLS.mappings[addr];if(!info)return 0;if(len===info.len){var stream=FS.getStream(info.fd);SYSCALLS.doMsync(addr,stream,len,info.flags);FS.munmap(stream);SYSCALLS.mappings[addr]=null;if(info.allocated){_free(info.malloc)}}return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var _emscripten_get_longjmp_result=true;function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function __exit(status){Module["exit"](status)}function _exit(status){__exit(status)}var _UItoD=true;function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall54(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),op=SYSCALLS.get();switch(op){case 21505:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21506:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21519:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;var argp=SYSCALLS.get();HEAP32[argp>>2]=0;return 0};case 21520:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return-ERRNO_CODES.EINVAL};case 21531:{var argp=SYSCALLS.get();return FS.ioctl(stream,op,argp)};default:abort("bad ioctl syscall "+op)}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 85:return totalMemory/PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}Module["_bitshift64Lshr"]=_bitshift64Lshr;Module["_testSetjmp"]=_testSetjmp;function _longjmp(env,value){asm["setThrew"](env,value||1);throw"longjmp"}var _BDtoIHigh=true;function _pthread_cleanup_push(routine,arg){__ATEXIT__.push((function(){Runtime.dynCall("vi",routine,[arg])}));_pthread_cleanup_push.level=__ATEXIT__.length}var _environ=allocate(1,"i32*",ALLOC_STATIC);var ___environ=_environ;function ___buildEnvironment(env){var MAX_ENV_VALUES=64;var TOTAL_ENV_SIZE=1024;var poolPtr;var envPtr;if(!___buildEnvironment.called){___buildEnvironment.called=true;ENV["USER"]=ENV["LOGNAME"]="web_user";ENV["PATH"]="/";ENV["PWD"]="/";ENV["HOME"]="/home/web_user";ENV["LANG"]="C";ENV["_"]=Module["thisProgram"];poolPtr=allocate(TOTAL_ENV_SIZE,"i8",ALLOC_STATIC);envPtr=allocate(MAX_ENV_VALUES*4,"i8*",ALLOC_STATIC);HEAP32[envPtr>>2]=poolPtr;HEAP32[_environ>>2]=envPtr}else{envPtr=HEAP32[_environ>>2];poolPtr=HEAP32[envPtr>>2]}var strings=[];var totalSize=0;for(var key in env){if(typeof env[key]==="string"){var line=key+"="+env[key];strings.push(line);totalSize+=line.length}}if(totalSize>TOTAL_ENV_SIZE){throw new Error("Environment size exceeded TOTAL_ENV_SIZE!")}var ptrSize=4;for(var i=0;i<strings.length;i++){var line=strings[i];writeAsciiToMemory(line,poolPtr);HEAP32[envPtr+i*ptrSize>>2]=poolPtr;poolPtr+=line.length+1}HEAP32[envPtr+strings.length*ptrSize>>2]=0}var ENV={};function _getenv(name){if(name===0)return 0;name=Pointer_stringify(name);if(!ENV.hasOwnProperty(name))return 0;if(_getenv.ret)_free(_getenv.ret);_getenv.ret=allocate(intArrayFromString(ENV[name]),"i8",ALLOC_NORMAL);return _getenv.ret}function _pthread_cleanup_pop(){assert(_pthread_cleanup_push.level==__ATEXIT__.length,"cannot pop if something else added meanwhile!");__ATEXIT__.pop();_pthread_cleanup_push.level=__ATEXIT__.length}function _emscripten_longjmp(env,value){_longjmp(env,value)}function ___syscall3(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),buf=SYSCALLS.get(),count=SYSCALLS.get();return FS.read(stream,HEAP8,buf,count)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall5(which,varargs){SYSCALLS.varargs=varargs;try{var pathname=SYSCALLS.getStr(),flags=SYSCALLS.get(),mode=SYSCALLS.get();var stream=FS.open(pathname,flags,mode);return stream.fd}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall4(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),buf=SYSCALLS.get(),count=SYSCALLS.get();return FS.write(stream,HEAP8,buf,count)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var _log=Math_log;var _emscripten_setjmp=true;var _fabs=Math_abs;function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0){var success=self.alloc(bytes);if(!success)return-1>>>0}return ret}var _emscripten_preinvoke=true;var _BItoD=true;function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;var _atan2=Math_atan2;function _abort(){Module["abort"]()}Module["_llvm_bswap_i32"]=_llvm_bswap_i32;var _exp=Math_exp;var _llvm_pow_f64=Math_pow;function _pthread_self(){return 0}function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;assert(offset_high===0);FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doWritev(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall221(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),cmd=SYSCALLS.get();switch(cmd){case 0:{var arg=SYSCALLS.get();if(arg<0){return-ERRNO_CODES.EINVAL}var newStream;newStream=FS.open(stream.path,stream.flags,0,arg);return newStream.fd};case 1:case 2:return 0;case 3:return stream.flags;case 4:{var arg=SYSCALLS.get();stream.flags|=arg;return 0};case 12:case 12:{var arg=SYSCALLS.get();var offset=0;HEAP16[arg+offset>>1]=2;return 0};case 13:case 14:case 13:case 14:return 0;case 16:case 8:return-ERRNO_CODES.EINVAL;case 9:___setErrNo(ERRNO_CODES.EINVAL);return-1;default:{return-ERRNO_CODES.EINVAL}}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}Module["requestFullScreen"]=function Module_requestFullScreen(lockPointer,resizeCanvas,vrDevice){Browser.requestFullScreen(lockPointer,resizeCanvas,vrDevice)};Module["requestAnimationFrame"]=function Module_requestAnimationFrame(func){Browser.requestAnimationFrame(func)};Module["setCanvasSize"]=function Module_setCanvasSize(width,height,noUpdates){Browser.setCanvasSize(width,height,noUpdates)};Module["pauseMainLoop"]=function Module_pauseMainLoop(){Browser.mainLoop.pause()};Module["resumeMainLoop"]=function Module_resumeMainLoop(){Browser.mainLoop.resume()};Module["getUserMedia"]=function Module_getUserMedia(){Browser.getUserMedia()};Module["createContext"]=function Module_createContext(canvas,useWebGL,setInModule,webGLContextAttributes){return Browser.createContext(canvas,useWebGL,setInModule,webGLContextAttributes)};FS.staticInit();__ATINIT__.unshift((function(){if(!Module["noFSInit"]&&!FS.init.initialized)FS.init()}));__ATMAIN__.push((function(){FS.ignorePermissions=false}));__ATEXIT__.push((function(){FS.quit()}));Module["FS_createFolder"]=FS.createFolder;Module["FS_createPath"]=FS.createPath;Module["FS_createDataFile"]=FS.createDataFile;Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_createLazyFile"]=FS.createLazyFile;Module["FS_createLink"]=FS.createLink;Module["FS_createDevice"]=FS.createDevice;Module["FS_unlink"]=FS.unlink;__ATINIT__.unshift((function(){TTY.init()}));__ATEXIT__.push((function(){TTY.shutdown()}));if(ENVIRONMENT_IS_NODE){var fs=require("fs");var NODEJS_PATH=require("path");NODEFS.staticInit()}___buildEnvironment(ENV);STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){try{Module["dynCall_viiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity,"byteLength":byteLength};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_iiii":invoke_iiii,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiii":invoke_viiiii,"invoke_vi":invoke_vi,"invoke_vii":invoke_vii,"invoke_iiiiiii":invoke_iiiiiii,"invoke_viiiiiiiiiiii":invoke_viiiiiiiiiiii,"invoke_ii":invoke_ii,"invoke_viii":invoke_viii,"invoke_viiiiiiiii":invoke_viiiiiiiii,"invoke_iiiii":invoke_iiiii,"invoke_iii":invoke_iii,"invoke_iiiiii":invoke_iiiiii,"invoke_viiii":invoke_viiii,"_pthread_cleanup_pop":_pthread_cleanup_pop,"_fabs":_fabs,"_exp":_exp,"_llvm_pow_f64":_llvm_pow_f64,"___syscall54":___syscall54,"_pthread_cleanup_push":_pthread_cleanup_push,"___syscall6":___syscall6,"_atan2":_atan2,"___setErrNo":___setErrNo,"___assert_fail":___assert_fail,"___buildEnvironment":___buildEnvironment,"_longjmp":_longjmp,"___syscall91":___syscall91,"_emscripten_set_main_loop_timing":_emscripten_set_main_loop_timing,"_sbrk":_sbrk,"___syscall192":___syscall192,"___syscall197":___syscall197,"_emscripten_memcpy_big":_emscripten_memcpy_big,"__exit":__exit,"___syscall195":___syscall195,"___syscall221":___syscall221,"_floor":_floor,"_pthread_self":_pthread_self,"_getenv":_getenv,"_sqrt":_sqrt,"_log":_log,"___unlock":___unlock,"_emscripten_set_main_loop":_emscripten_set_main_loop,"___syscall3":___syscall3,"_sysconf":_sysconf,"___lock":___lock,"_abort":_abort,"___syscall5":___syscall5,"___syscall4":___syscall4,"_time":_time,"_emscripten_longjmp":_emscripten_longjmp,"___syscall140":___syscall140,"_exit":_exit,"___syscall146":___syscall146,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=global.Int8Array;var b=global.Int16Array;var c=global.Int32Array;var d=global.Uint8Array;var e=global.Uint16Array;var f=global.Uint32Array;var g=global.Float32Array;var h=global.Float64Array;var i=new a(buffer);var j=new b(buffer);var k=new c(buffer);var l=new d(buffer);var m=new e(buffer);var n=new f(buffer);var o=new g(buffer);var p=new h(buffer);var q=global.byteLength;var r=env.STACKTOP|0;var s=env.STACK_MAX|0;var t=env.tempDoublePtr|0;var u=env.ABORT|0;var v=env.cttz_i8|0;var w=0;var x=0;var y=0;var z=0;var A=global.NaN,B=global.Infinity;var C=0,D=0,E=0,F=0,G=0.0,H=0,I=0,J=0,K=0.0;var L=0;var M=0;var N=0;var O=0;var P=0;var Q=0;var R=0;var S=0;var T=0;var U=0;var V=global.Math.floor;var W=global.Math.abs;var X=global.Math.sqrt;var Y=global.Math.pow;var Z=global.Math.cos;var _=global.Math.sin;var $=global.Math.tan;var aa=global.Math.acos;var ba=global.Math.asin;var ca=global.Math.atan;var da=global.Math.atan2;var ea=global.Math.exp;var fa=global.Math.log;var ga=global.Math.ceil;var ha=global.Math.imul;var ia=global.Math.min;var ja=global.Math.clz32;var ka=env.abort;var la=env.assert;var ma=env.invoke_iiii;var na=env.invoke_viiiiiii;var oa=env.invoke_viiiii;var pa=env.invoke_vi;var qa=env.invoke_vii;var ra=env.invoke_iiiiiii;var sa=env.invoke_viiiiiiiiiiii;var ta=env.invoke_ii;var ua=env.invoke_viii;var va=env.invoke_viiiiiiiii;var wa=env.invoke_iiiii;var xa=env.invoke_iii;var ya=env.invoke_iiiiii;var za=env.invoke_viiii;var Aa=env._pthread_cleanup_pop;var Ba=env._fabs;var Ca=env._exp;var Da=env._llvm_pow_f64;var Ea=env.___syscall54;var Fa=env._pthread_cleanup_push;var Ga=env.___syscall6;var Ha=env._atan2;var Ia=env.___setErrNo;var Ja=env.___assert_fail;var Ka=env.___buildEnvironment;var La=env._longjmp;var Ma=env.___syscall91;var Na=env._emscripten_set_main_loop_timing;var Oa=env._sbrk;var Pa=env.___syscall192;var Qa=env.___syscall197;var Ra=env._emscripten_memcpy_big;var Sa=env.__exit;var Ta=env.___syscall195;var Ua=env.___syscall221;var Va=env._floor;var Wa=env._pthread_self;var Xa=env._getenv;var Ya=env._sqrt;var Za=env._log;var _a=env.___unlock;var $a=env._emscripten_set_main_loop;var ab=env.___syscall3;var bb=env._sysconf;var cb=env.___lock;var db=env._abort;var eb=env.___syscall5;var fb=env.___syscall4;var gb=env._time;var hb=env._emscripten_longjmp;var ib=env.___syscall140;var jb=env._exit;var kb=env.___syscall146;var lb=0.0;function mb(newBuffer){if(q(newBuffer)&16777215||q(newBuffer)<=16777215||q(newBuffer)>2147483648)return false;i=new a(newBuffer);j=new b(newBuffer);k=new c(newBuffer);l=new d(newBuffer);m=new e(newBuffer);n=new f(newBuffer);o=new g(newBuffer);p=new h(newBuffer);buffer=newBuffer;return true}
// EMSCRIPTEN_START_FUNCS
function mc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,n=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0,A=0.0;d=r;r=r+16|0;e=d+4|0;f=d;g=b+2|0;switch(m[g>>1]|0){case 12:case 11:case 10:case 5:case 17:case 16:case 9:case 4:case 8:case 3:case 6:case 1:break;default:{h=2;r=d;return h|0}}n=qc(a,b,e,8,f)|0;b=k[f>>2]|0;f=b;if((n|0)!=0|(b|0)==0){k[c>>2]=0;h=n;r=d;return h|0}if((j[g>>1]|0)==12){if(k[a+12>>2]&128)Wd(b,k[e>>2]|0);k[c>>2]=f;h=0;r=d;return h|0}f=k[e>>2]|0;e=me(f<<3)|0;if(!e){ne(b);h=7;r=d;return h|0}do switch(m[g>>1]|0){case 1:{if(f){n=b;q=e;s=0;while(1){p[q>>3]=+(l[n>>0]|0);s=s+1|0;if(s>>>0>=f>>>0)break;else{n=n+1|0;q=q+8|0}}}break}case 6:{if(f){q=b;n=e;s=0;while(1){p[n>>3]=+(i[q>>0]|0);s=s+1|0;if(s>>>0>=f>>>0)break;else{q=q+1|0;n=n+8|0}}}break}case 3:{if(f){n=a+12|0;q=b;s=e;t=0;while(1){if(k[n>>2]&128)Qd(q);p[s>>3]=+(m[q>>1]|0);t=t+1|0;if(t>>>0>=f>>>0)break;else{q=q+2|0;s=s+8|0}}}break}case 8:{if(f){s=a+12|0;q=b;t=e;n=0;while(1){if(k[s>>2]&128)Qd(q);p[t>>3]=+(j[q>>1]|0);n=n+1|0;if(n>>>0>=f>>>0)break;else{q=q+2|0;t=t+8|0}}}break}case 4:{if(f){t=a+12|0;q=b;n=e;s=0;while(1){if(k[t>>2]&128)Rd(q);p[n>>3]=+((k[q>>2]|0)>>>0);s=s+1|0;if(s>>>0>=f>>>0)break;else{q=q+4|0;n=n+8|0}}}break}case 9:{if(f){n=a+12|0;q=b;s=e;t=0;while(1){if(k[n>>2]&128)Rd(q);p[s>>3]=+(k[q>>2]|0);t=t+1|0;if(t>>>0>=f>>>0)break;else{q=q+4|0;s=s+8|0}}}break}case 16:{if(f){s=a+12|0;q=b;t=e;n=0;while(1){if(k[s>>2]&128)Sd(q);u=q;p[t>>3]=+((k[u>>2]|0)>>>0)+4294967296.0*+((k[u+4>>2]|0)>>>0);n=n+1|0;if(n>>>0>=f>>>0)break;else{q=q+8|0;t=t+8|0}}}break}case 17:{if(f){t=a+12|0;q=b;n=e;s=0;while(1){if(k[t>>2]&128)Sd(q);u=q;p[n>>3]=+((k[u>>2]|0)>>>0)+4294967296.0*+(k[u+4>>2]|0);s=s+1|0;if(s>>>0>=f>>>0)break;else{q=q+8|0;n=n+8|0}}}break}case 5:{if(f){n=a+12|0;q=b;s=e;t=0;while(1){u=k[n>>2]|0;if(!(u&128))v=u;else{Rd(q);v=k[n>>2]|0}u=q+4|0;w=k[q>>2]|0;if(v&128)Rd(u);x=k[u>>2]|0;if(!x)y=0.0;else y=+(w>>>0)/+(x>>>0);p[s>>3]=y;t=t+1|0;if(t>>>0>=f>>>0)break;else{q=q+8|0;s=s+8|0}}}break}case 10:{if(f){s=a+12|0;q=b;t=e;n=0;while(1){x=k[s>>2]|0;if(!(x&128))z=x;else{Rd(q);z=k[s>>2]|0}x=k[q>>2]|0;w=q+4|0;if(z&128)Rd(w);u=k[w>>2]|0;if(!u)A=0.0;else A=+(x|0)/+(u>>>0);p[t>>3]=A;n=n+1|0;if(n>>>0>=f>>>0)break;else{q=q+8|0;t=t+8|0}}}break}case 11:{if(k[a+12>>2]&128)Vd(b,f);if(f){t=b;q=e;n=0;while(1){p[q>>3]=+o[t>>2];n=n+1|0;if(n>>>0>=f>>>0)break;else{t=t+4|0;q=q+8|0}}}break}default:{}}while(0);ne(b);k[c>>2]=e;h=0;r=d;return h|0}function nc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,l=0;e=r;r=r+16|0;f=e;g=pc(a,b,f)|0;if(g){h=cc(a,m[b>>1]|0)|0;if(!h)i=133413;else i=k[h+28>>2]|0;lc(a,g,134332,i,0);j=0;r=e;return j|0}i=b+8|0;b=i;if((k[b+4>>2]|0)==0?(k[b>>2]|0)==(c|0):0)l=k[f>>2]|0;else{b=Ee(a,c,8,134352)|0;if(!b){ne(k[f>>2]|0);j=0;r=e;return j|0}a=i;g=k[a>>2]|0;h=k[a+4>>2]|0;a=k[f>>2]|0;if(h>>>0<0|(h|0)==0&g>>>0<c>>>0){qe(b,a,g<<3);g=k[i>>2]|0;pe(b+(g<<3)|0,0,c-g<<3)}else qe(b,a,c<<3);ne(a);k[f>>2]=b;l=b}k[d>>2]=l;j=1;r=e;return j|0}function oc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;d=r;r=r+16|0;e=d;f=a+176|0;g=k[f>>2]|0;if(g)ne(g);g=a+168|0;h=Ee(a,k[g>>2]|0,8,134235)|0;k[f>>2]=h;if(!h){i=-1;r=d;return i|0}do if((j[a+88>>1]|0)==1)if(!(k[a+12>>2]&1024)){h=Ld(a)|0;l=k[g>>2]|0;if(!l)break;n=Dr(((k[a+60>>2]|0)>>>0)/((k[a+164>>2]|0)>>>0)|0|0,0,h|0,L|0)|0;h=L;o=k[f>>2]|0;p=0;do{q=o+(p<<3)|0;k[q>>2]=n;k[q+4>>2]=h;p=p+1|0}while(p>>>0<l>>>0)}else{l=fe(a)|0;p=L;h=k[g>>2]|0;if(!h)break;n=k[f>>2]|0;o=0;do{q=n+(o<<3)|0;k[q>>2]=l;k[q+4>>2]=p;o=o+1|0}while(o>>>0<h>>>0)}else{h=a+628|0;o=ub[k[a+648>>2]&63](k[h>>2]|0)|0;p=L;l=a+12|0;n=c&65535;q=(k[l>>2]&524288|0)==0?(n*12|0)+14|0:(n*20|0)+32|0;a:do if(!(c<<16>>16)){s=q;t=0}else{n=q;u=0;v=b;w=c;while(1){x=v+2|0;y=ac(m[x>>1]|0)|0;if(!y){z=x;break}x=v+8|0;A=Dr(k[x>>2]|0,k[x+4>>2]|0,y|0,0)|0;y=L;x=(k[l>>2]&524288|0)==0?y>>>0<0|(y|0)==0&A>>>0<5:y>>>0<0|(y|0)==0&A>>>0<9;B=sr((x?0:A)|0,(x?0:y)|0,n|0,u|0)|0;y=L;w=w+-1<<16>>16;if(!(w<<16>>16)){s=B;t=y;break a}else{n=B;u=y;v=v+24|0}}v=k[h>>2]|0;k[e>>2]=m[z>>1];vc(v,134263,134287,e);i=-1;r=d;return i|0}while(0);h=pr(o|0,p|0,s|0,t|0)|0;l=L;if((j[a+126>>1]|0)==2){q=Er(h|0,l|0,m[a+98>>1]|0,0)|0;C=q;D=L}else{C=h;D=l}l=k[g>>2]|0;h=k[f>>2]|0;if(!l)E=-1;else{q=l>>>0>1;v=0;do{u=h+(v<<3)|0;k[u>>2]=C;k[u+4>>2]=D;v=v+1|0}while(v>>>0<l>>>0);E=q?l+-1|0:0}v=(k[a+172>>2]|0)+(E<<3)|0;u=k[v>>2]|0;n=k[v+4>>2]|0;v=h+(E<<3)|0;w=v;y=sr(k[w>>2]|0,k[w+4>>2]|0,u|0,n|0)|0;w=L;if(w>>>0>p>>>0|(w|0)==(p|0)&y>>>0>o>>>0){y=pr(o|0,p|0,u|0,n|0)|0;n=v;k[n>>2]=y;k[n+4>>2]=L}}while(0);E=a+40|0;D=k[E>>2]|0;k[E>>2]=D|16777216;if(D&131072){i=1;r=d;return i|0}k[a+100>>2]=k[a+60>>2];i=1;r=d;return i|0}function pc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0;d=r;r=r+16|0;e=d+4|0;f=d;g=b+2|0;switch(m[g>>1]|0|0){case 17:case 16:case 9:case 4:case 8:case 3:case 6:case 1:break;default:{h=2;r=d;return h|0}}n=qc(a,b,e,8,f)|0;b=k[f>>2]|0;f=b;if((n|0)!=0|(b|0)==0){k[c>>2]=0;h=n;r=d;return h|0}switch(m[g>>1]|0|0){case 16:{k[c>>2]=b;if(!(k[a+12>>2]&128)){h=0;r=d;return h|0}Wd(b,k[e>>2]|0);h=0;r=d;return h|0}case 17:{n=k[e>>2]|0;a:do if(n){o=a+12|0;p=b;q=0;while(1){if(k[o>>2]&128)Sd(p);s=p;t=k[s+4>>2]|0;if(!((t|0)>-1|(t|0)==-1&(k[s>>2]|0)>>>0>4294967295))break;q=q+1|0;if(q>>>0>=n>>>0)break a;else p=p+8|0}ne(b);h=4;r=d;return h|0}while(0);k[c>>2]=f;h=0;r=d;return h|0}default:{f=k[e>>2]|0;e=me(f<<3)|0;if(!e){ne(b);h=7;r=d;return h|0}b:do switch(m[g>>1]|0|0){case 1:{if(!f)u=46;else{n=b;p=e;q=0;while(1){o=p;k[o>>2]=l[n>>0];k[o+4>>2]=0;q=q+1|0;if(q>>>0>=f>>>0){u=46;break}else{n=n+1|0;p=p+8|0}}}break}case 6:{if(!f)u=46;else{p=b;n=e;q=0;while(1){o=i[p>>0]|0;if(o<<24>>24<=-1){v=4;u=45;break b}s=o<<24>>24;o=n;k[o>>2]=s;k[o+4>>2]=((s|0)<0)<<31>>31;q=q+1|0;if(q>>>0>=f>>>0){u=46;break}else{p=p+1|0;n=n+8|0}}}break}case 3:{if(!f)u=46;else{n=a+12|0;p=b;q=e;s=0;while(1){if(k[n>>2]&128)Qd(p);o=q;k[o>>2]=m[p>>1];k[o+4>>2]=0;s=s+1|0;if(s>>>0>=f>>>0){u=46;break}else{p=p+2|0;q=q+8|0}}}break}case 8:{if(!f)u=46;else{q=a+12|0;p=b;s=e;n=0;while(1){if(k[q>>2]&128)Qd(p);o=j[p>>1]|0;if(o<<16>>16<=-1){v=4;u=45;break b}t=o<<16>>16;o=s;k[o>>2]=t;k[o+4>>2]=((t|0)<0)<<31>>31;n=n+1|0;if(n>>>0>=f>>>0){u=46;break}else{p=p+2|0;s=s+8|0}}}break}case 4:{if(!f)u=46;else{s=a+12|0;p=b;n=e;q=0;while(1){if(k[s>>2]&128)Rd(p);t=n;k[t>>2]=k[p>>2];k[t+4>>2]=0;q=q+1|0;if(q>>>0>=f>>>0){u=46;break}else{p=p+4|0;n=n+8|0}}}break}case 9:{if(!f)u=46;else{n=a+12|0;p=b;q=e;s=0;while(1){if(k[n>>2]&128)Rd(p);t=k[p>>2]|0;o=t>>31&4;if(o){v=o;u=45;break b}o=q;k[o>>2]=t;k[o+4>>2]=((t|0)<0)<<31>>31;s=s+1|0;if(s>>>0>=f>>>0){u=46;break}else{p=p+4|0;q=q+8|0}}}break}default:u=46}while(0);if((u|0)==45){ne(b);ne(e);h=v;r=d;return h|0}else if((u|0)==46){ne(b);k[c>>2]=e;h=0;r=d;return h|0}}}return 0}function qc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0;f=r;r=r+16|0;g=f+8|0;h=f;i=ac(m[b+2>>1]|0)|0;j=b+8|0;l=k[j>>2]|0;n=k[j+4>>2]|0;if((i|0)==0|(l|0)==0&(n|0)==0){k[e>>2]=0;o=0;r=f;return o|0}j=2147483647/(i|0)|0;p=((j|0)<0)<<31>>31;if(p>>>0<n>>>0|(p|0)==(n|0)&j>>>0<l>>>0){o=6;r=f;return o|0}if(0<n>>>0|(0==(n|0)?(2147483647/(d>>>0)|0)>>>0<l>>>0:0)){o=6;r=f;return o|0}k[c>>2]=l;c=ha(l,i)|0;if((c|0)<=0)Ja(134368,133171,790,134389);d=Ee(a,l,i,134411)|0;if(!d){o=7;r=f;return o|0}i=a+12|0;l=k[i>>2]|0;do if(!(l&524288)){n=b+16|0;if(c>>>0<5){qe(d,n,c);break}j=k[n>>2]|0;k[g>>2]=j;if(!(l&128)){q=l;s=j}else{Rd(g);q=k[i>>2]|0;s=k[g>>2]|0}if(!(q&2048)){j=a+628|0;n=xb[k[a+640>>2]&63](k[j>>2]|0,s,0,0)|0;if((n|0)==(s|0)&(L|0)==0?(nb[k[a+632>>2]&63](k[j>>2]|0,d,c)|0)==(c|0):0)break}else{j=s+c|0;if(!(j>>>0<c>>>0|j>>>0<s>>>0)?j>>>0<=(k[a+616>>2]|0)>>>0:0){qe(d,(k[a+612>>2]|0)+s|0,c);break}}ne(d);o=3;r=f;return o|0}else{if(c>>>0<9){qe(d,b+16|0,c);break}j=b+16|0;n=k[j>>2]|0;p=k[j+4>>2]|0;j=h;k[j>>2]=n;k[j+4>>2]=p;if(!(l&128)){t=l;u=n;v=p}else{Sd(h);p=h;t=k[i>>2]|0;u=k[p>>2]|0;v=k[p+4>>2]|0}if(!(t&2048)){p=a+628|0;n=xb[k[a+640>>2]&63](k[p>>2]|0,u,v,0)|0;if((n|0)==(u|0)&(L|0)==(v|0)?(nb[k[a+632>>2]&63](k[p>>2]|0,d,c)|0)==(c|0):0)break}else{p=u+c|0;if(!(p>>>0<c>>>0|((u|0)!=(u|0)|0!=(v|0)|p>>>0<u>>>0))?p>>>0<=(k[a+616>>2]|0)>>>0:0){qe(d,(k[a+612>>2]|0)+u|0,c);break}}ne(d);o=3;r=f;return o|0}while(0);k[e>>2]=d;o=0;r=f;return o|0}function rc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0;d=r;r=r+16|0;e=d+4|0;f=d;g=b+2|0;switch(m[g>>1]|0){case 17:case 16:case 9:case 4:case 8:case 3:case 6:case 1:case 7:case 2:break;default:{h=2;r=d;return h|0}}l=qc(a,b,e,1,f)|0;b=k[f>>2]|0;n=b;if((l|0)!=0|(b|0)==0){k[c>>2]=0;h=l;r=d;return h|0}switch(m[g>>1]|0){case 1:case 7:case 2:{k[c>>2]=n;h=0;r=d;return h|0}case 6:{l=k[e>>2]|0;a:do if(l){o=b;p=0;while(1){if((i[o>>0]|0)<=-1)break;p=p+1|0;if(p>>>0>=l>>>0)break a;else o=o+1|0}ne(b);h=4;r=d;return h|0}while(0);k[c>>2]=n;h=0;r=d;return h|0}default:{n=k[e>>2]|0;l=me(n)|0;if(!l){ne(b);h=7;r=d;return h|0}b:do switch(m[g>>1]|0){case 3:{if(!n)q=51;else{o=a+12|0;p=b;s=l;t=0;while(1){if(k[o>>2]&128)Qd(p);u=j[p>>1]|0;if((u&65535)>=256){q=50;break b}i[s>>0]=u;t=t+1|0;if(t>>>0>=(k[e>>2]|0)>>>0){q=51;break}else{p=p+2|0;s=s+1|0}}}break}case 8:{if(!n)q=51;else{s=a+12|0;p=b;t=l;o=0;while(1){if(k[s>>2]&128)Qd(p);u=j[p>>1]|0;if((u&65535)>=256){q=50;break b}i[t>>0]=u;o=o+1|0;if(o>>>0>=(k[e>>2]|0)>>>0){q=51;break}else{p=p+2|0;t=t+1|0}}}break}case 4:{if(!n)q=51;else{t=a+12|0;p=b;o=l;s=0;while(1){if(k[t>>2]&128)Rd(p);u=k[p>>2]|0;if(u>>>0>=256){q=50;break b}i[o>>0]=u;s=s+1|0;if(s>>>0>=(k[e>>2]|0)>>>0){q=51;break}else{p=p+4|0;o=o+1|0}}}break}case 9:{if(!n)q=51;else{o=a+12|0;p=b;s=l;t=0;while(1){if(k[o>>2]&128)Rd(p);u=k[p>>2]|0;if(u>>>0>=256){q=50;break b}i[s>>0]=u;t=t+1|0;if(t>>>0>=(k[e>>2]|0)>>>0){q=51;break}else{p=p+4|0;s=s+1|0}}}break}case 16:{if(!n)q=51;else{s=a+12|0;p=b;t=l;o=0;while(1){if(k[s>>2]&128)Sd(p);u=p;v=k[u>>2]|0;w=k[u+4>>2]|0;if(!(w>>>0<0|(w|0)==0&v>>>0<256)){q=50;break b}i[t>>0]=v;o=o+1|0;if(o>>>0>=(k[e>>2]|0)>>>0){q=51;break}else{p=p+8|0;t=t+1|0}}}break}case 17:{if(!n)q=51;else{t=a+12|0;p=b;o=l;s=0;while(1){if(k[t>>2]&128)Sd(p);v=p;w=k[v>>2]|0;u=k[v+4>>2]|0;if(!(u>>>0<0|(u|0)==0&w>>>0<256)){q=50;break b}i[o>>0]=w;s=s+1|0;if(s>>>0>=(k[e>>2]|0)>>>0){q=51;break}else{p=p+8|0;o=o+1|0}}}break}default:q=51}while(0);if((q|0)==50){ne(k[f>>2]|0);ne(l);h=4;r=d;return h|0}else if((q|0)==51){ne(k[f>>2]|0);k[c>>2]=l;h=0;r=d;return h|0}}}return 0}function sc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0;d=r;r=r+16|0;e=d+4|0;f=d;g=b+2|0;switch(m[g>>1]|0|0){case 17:case 16:case 9:case 4:case 8:case 3:case 6:case 1:break;default:{h=2;r=d;return h|0}}n=qc(a,b,e,4,f)|0;b=k[f>>2]|0;f=b;if((n|0)!=0|(b|0)==0){k[c>>2]=0;h=n;r=d;return h|0}switch(m[g>>1]|0|0){case 4:{k[c>>2]=b;if(!(k[a+12>>2]&128)){h=0;r=d;return h|0}Vd(b,k[e>>2]|0);h=0;r=d;return h|0}case 9:{n=k[e>>2]|0;a:do if(n){o=a+12|0;p=b;q=0;while(1){if(k[o>>2]&128)Rd(p);s=k[p>>2]>>31&4;if(s){t=s;break}q=q+1|0;if(q>>>0>=n>>>0)break a;else p=p+4|0}ne(b);h=t;r=d;return h|0}while(0);k[c>>2]=f;h=0;r=d;return h|0}default:{f=k[e>>2]|0;t=me(f<<2)|0;if(!t){ne(b);h=7;r=d;return h|0}b:do switch(m[g>>1]|0|0){case 1:{if(!f)u=47;else{n=b;p=t;q=0;while(1){k[p>>2]=l[n>>0];q=q+1|0;if(q>>>0>=(k[e>>2]|0)>>>0){u=47;break}else{n=n+1|0;p=p+4|0}}}break}case 6:{if(!f)u=47;else{p=b;n=t;q=0;while(1){o=i[p>>0]|0;if(o<<24>>24<=-1){u=46;break b}k[n>>2]=o<<24>>24;q=q+1|0;if(q>>>0>=(k[e>>2]|0)>>>0){u=47;break}else{p=p+1|0;n=n+4|0}}}break}case 3:{if(!f)u=47;else{n=a+12|0;p=b;q=t;o=0;while(1){if(k[n>>2]&128)Qd(p);k[q>>2]=m[p>>1];o=o+1|0;if(o>>>0>=(k[e>>2]|0)>>>0){u=47;break}else{p=p+2|0;q=q+4|0}}}break}case 8:{if(!f)u=47;else{q=a+12|0;p=b;o=t;n=0;while(1){if(k[q>>2]&128)Qd(p);s=j[p>>1]|0;if(s<<16>>16<=-1){u=46;break b}k[o>>2]=s<<16>>16;n=n+1|0;if(n>>>0>=(k[e>>2]|0)>>>0){u=47;break}else{p=p+2|0;o=o+4|0}}}break}case 16:{if(!f)u=47;else{o=a+12|0;p=b;n=t;q=0;while(1){if(k[o>>2]&128)Sd(p);s=p;v=k[s>>2]|0;w=k[s+4>>2]|0;if(!(w>>>0<1|(w|0)==1&v>>>0<0)){u=46;break b}k[n>>2]=v;q=q+1|0;if(q>>>0>=(k[e>>2]|0)>>>0){u=47;break}else{p=p+8|0;n=n+4|0}}}break}case 17:{if(!f)u=47;else{n=a+12|0;p=b;q=t;o=0;while(1){if(k[n>>2]&128)Sd(p);v=p;w=k[v>>2]|0;s=k[v+4>>2]|0;if(!(s>>>0<1|(s|0)==1&w>>>0<0)){u=46;break b}k[q>>2]=w;o=o+1|0;if(o>>>0>=(k[e>>2]|0)>>>0){u=47;break}else{p=p+8|0;q=q+4|0}}}break}default:u=47}while(0);if((u|0)==46){ne(b);ne(t);h=4;r=d;return h|0}else if((u|0)==47){ne(b);k[c>>2]=t;h=0;r=d;return h|0}}}return 0}function tc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,n=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0,A=0.0;d=r;r=r+16|0;e=d+4|0;f=d;g=b+2|0;switch(m[g>>1]|0){case 12:case 11:case 10:case 5:case 17:case 16:case 9:case 4:case 8:case 3:case 6:case 1:break;default:{h=2;r=d;return h|0}}n=qc(a,b,e,4,f)|0;b=k[f>>2]|0;f=b;if((n|0)!=0|(b|0)==0){k[c>>2]=0;h=n;r=d;return h|0}if((j[g>>1]|0)==11){if(k[a+12>>2]&128)Vd(b,k[e>>2]|0);k[c>>2]=f;h=0;r=d;return h|0}f=k[e>>2]|0;e=me(f<<2)|0;if(!e){ne(b);h=7;r=d;return h|0}do switch(m[g>>1]|0){case 1:{if(f){n=b;q=e;s=0;while(1){o[q>>2]=+(l[n>>0]|0);s=s+1|0;if(s>>>0>=f>>>0)break;else{n=n+1|0;q=q+4|0}}}break}case 6:{if(f){q=b;n=e;s=0;while(1){o[n>>2]=+(i[q>>0]|0);s=s+1|0;if(s>>>0>=f>>>0)break;else{q=q+1|0;n=n+4|0}}}break}case 3:{if(f){n=a+12|0;q=b;s=e;t=0;while(1){if(k[n>>2]&128)Qd(q);o[s>>2]=+(m[q>>1]|0);t=t+1|0;if(t>>>0>=f>>>0)break;else{q=q+2|0;s=s+4|0}}}break}case 8:{if(f){s=a+12|0;q=b;t=e;n=0;while(1){if(k[s>>2]&128)Qd(q);o[t>>2]=+(j[q>>1]|0);n=n+1|0;if(n>>>0>=f>>>0)break;else{q=q+2|0;t=t+4|0}}}break}case 4:{if(f){t=a+12|0;q=b;n=e;s=0;while(1){if(k[t>>2]&128)Rd(q);o[n>>2]=+((k[q>>2]|0)>>>0);s=s+1|0;if(s>>>0>=f>>>0)break;else{q=q+4|0;n=n+4|0}}}break}case 9:{if(f){n=a+12|0;q=b;s=e;t=0;while(1){if(k[n>>2]&128)Rd(q);o[s>>2]=+(k[q>>2]|0);t=t+1|0;if(t>>>0>=f>>>0)break;else{q=q+4|0;s=s+4|0}}}break}case 16:{if(f){s=a+12|0;q=b;t=e;n=0;while(1){if(k[s>>2]&128)Sd(q);u=q;o[t>>2]=+((k[u>>2]|0)>>>0)+4294967296.0*+((k[u+4>>2]|0)>>>0);n=n+1|0;if(n>>>0>=f>>>0)break;else{q=q+8|0;t=t+4|0}}}break}case 17:{if(f){t=a+12|0;q=b;n=e;s=0;while(1){if(k[t>>2]&128)Sd(q);u=q;o[n>>2]=+((k[u>>2]|0)>>>0)+4294967296.0*+(k[u+4>>2]|0);s=s+1|0;if(s>>>0>=f>>>0)break;else{q=q+8|0;n=n+4|0}}}break}case 5:{if(f){n=a+12|0;q=b;s=e;t=0;while(1){u=k[n>>2]|0;if(!(u&128))v=u;else{Rd(q);v=k[n>>2]|0}u=q+4|0;w=k[q>>2]|0;if(v&128)Rd(u);x=k[u>>2]|0;if(!x)y=0.0;else y=+(w>>>0)/+(x>>>0);o[s>>2]=y;t=t+1|0;if(t>>>0>=f>>>0)break;else{q=q+8|0;s=s+4|0}}}break}case 10:{if(f){s=a+12|0;q=b;t=e;n=0;while(1){x=k[s>>2]|0;if(!(x&128))z=x;else{Rd(q);z=k[s>>2]|0}x=k[q>>2]|0;w=q+4|0;if(z&128)Rd(w);u=k[w>>2]|0;if(!u)A=0.0;else A=+(x|0)/+(u>>>0);o[t>>2]=A;n=n+1|0;if(n>>>0>=f>>>0)break;else{q=q+8|0;t=t+4|0}}}break}case 12:{if(k[a+12>>2]&128)Wd(b,f);if(f){t=b;q=e;n=0;while(1){o[q>>2]=+p[t>>3];n=n+1|0;if(n>>>0>=f>>>0)break;else{t=t+8|0;q=q+4|0}}}break}default:{}}while(0);ne(b);k[c>>2]=e;h=0;r=d;return h|0}function uc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0;d=r;r=r+16|0;e=d+4|0;f=d;g=b+2|0;switch(m[g>>1]|0|0){case 18:case 13:case 16:case 4:break;default:{h=2;r=d;return h|0}}i=qc(a,b,e,8,f)|0;b=k[f>>2]|0;if((i|0)!=0|(b|0)==0){k[c>>2]=0;h=i;r=d;return h|0}switch(m[g>>1]|0|0){case 18:case 16:{k[c>>2]=b;if(!(k[a+12>>2]&128)){h=0;r=d;return h|0}Wd(b,k[e>>2]|0);h=0;r=d;return h|0}default:{}}i=k[e>>2]|0;e=me(i<<3)|0;if(!e){ne(b);h=7;r=d;return h|0}switch(m[g>>1]|0|0){case 13:case 4:{if(i){g=a+12|0;a=b;f=e;j=0;while(1){if(k[g>>2]&128)Rd(a);l=f;k[l>>2]=k[a>>2];k[l+4>>2]=0;j=j+1|0;if(j>>>0>=i>>>0)break;else{a=a+4|0;f=f+8|0}}}break}default:{}}ne(b);k[c>>2]=e;h=0;r=d;return h|0}function vc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=r;r=r+16|0;f=e;k[f>>2]=d;d=k[1934]|0;if(d)vb[d&127](b,c,f);d=k[1910]|0;if(!d){r=e;return}Ab[d&31](a,b,c,f);r=e;return}function wc(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0;b=r;r=r+48|0;c=b+24|0;d=b+16|0;e=b+8|0;f=b;g=b+32|0;h=b+28|0;i=a+8|0;if(!(k[i>>2]|0)){j=1;r=b;return j|0}l=a+12|0;m=k[l>>2]|0;do if(m&64){if((m&4096|0)!=0?(k[l>>2]=m&-4097,(ub[k[a+528>>2]&63](a)|0)==0):0){j=0;r=b;return j|0}if(!(je(a)|0)){j=0;r=b;return j|0}else{n=k[l>>2]|0;break}}else n=m;while(0);do if((n&2097160|0)==2097152?(k[i>>2]|0)==2:0){k[g>>2]=0;k[h>>2]=0;if(!(rd(a)|0)){k[d>>2]=g;if(!(Pb(a,273,d)|0))break;k[c>>2]=h;if(!(Pb(a,279,c)|0))break;m=a+168|0;if(!($e(a,273,16,k[m>>2]|0,k[g>>2]|0)|0))break;if(!($e(a,279,16,k[m>>2]|0,k[h>>2]|0)|0))break;k[l>>2]=k[l>>2]&-2097217;j=1;r=b;return j|0}else{k[f>>2]=g;if(!(Pb(a,324,f)|0))break;k[e>>2]=h;if(!(Pb(a,325,e)|0))break;m=a+168|0;if(!($e(a,324,16,k[m>>2]|0,k[g>>2]|0)|0))break;if(!($e(a,325,16,k[m>>2]|0,k[h>>2]|0)|0))break;k[l>>2]=k[l>>2]&-2097217;j=1;r=b;return j|0}}while(0);if((k[l>>2]&2097160|0)!=0?(_e(a)|0)==0:0){j=0;r=b;return j|0}j=1;r=b;return j|0}function xc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;c=r;r=r+160|0;d=c+136|0;e=c+120|0;f=c+112|0;g=c+104|0;h=c+88|0;l=c+80|0;n=c+72|0;o=c+64|0;p=c+56|0;q=c+48|0;s=c+24|0;t=c+16|0;u=c+8|0;v=c;w=c+146|0;x=c+144|0;if(!(k[a+500>>2]|0)){y=b;z=135926;A=y+54|0;do{i[y>>0]=i[z>>0]|0;y=y+1|0;z=z+1|0}while((y|0)<(A|0));B=0;r=c;return B|0}z=a+84|0;y=m[z>>1]|0;switch(y|0){case 16:case 8:case 4:case 2:case 1:break;default:{k[v>>2]=y;Bq(b,135980,v)|0;B=0;r=c;return B|0}}v=a+98|0;y=(m[v>>1]|0)-(m[a+156>>1]|0)|0;k[u>>2]=w;a:do if(!(Pb(a,262,u)|0))switch(y|0){case 1:{j[w>>1]=1;C=1;break a;break}case 3:{j[w>>1]=2;C=2;break a;break}default:{k[t>>2]=130805;Bq(b,136029,t)|0;B=0;r=c;return B|0}}else C=j[w>>1]|0;while(0);w=C&65535;b:do if((w|0)<5){switch(w|0){case 3:case 1:case 0:break;case 2:{if((y|0)>=3){B=1;r=c;return B|0}k[q>>2]=136187;k[q+4>>2]=y;Bq(b,136144,q)|0;B=0;r=c;return B|0}default:break b}if((j[a+126>>1]|0)!=1){B=1;r=c;return B|0}C=j[v>>1]|0;if(C<<16>>16==1){B=1;r=c;return B|0}t=j[z>>1]|0;if((t&65535)>=8){B=1;r=c;return B|0}k[s>>2]=130805;k[s+4>>2]=w;k[s+8>>2]=136130;k[s+12>>2]=C&65535;k[s+16>>2]=t&65535;Bq(b,136051,s)|0;B=0;r=c;return B|0}else{if((w|0)<8){switch(w|0){case 5:break;case 6:{B=1;r=c;return B|0}default:break b}k[p>>2]=x;Ge(a,332,p)|0;t=j[x>>1]|0;if(t<<16>>16!=1){k[o>>2]=136251;k[o+4>>2]=t&65535;Bq(b,136202,o)|0;B=0;r=c;return B|0}t=j[v>>1]|0;if((t&65535)>=4){B=1;r=c;return B|0}k[n>>2]=136130;k[n+4>>2]=t&65535;Bq(b,136202,n)|0;B=0;r=c;return B|0}if((w|0)<32844){switch(w|0){case 8:break;default:break b}t=j[v>>1]|0;C=j[z>>1]|0;if(t<<16>>16==3&C<<16>>16==8){B=1;r=c;return B|0}k[e>>2]=136130;k[e+4>>2]=t&65535;k[e+8>>2]=136499;k[e+12>>2]=C&65535;Bq(b,136450,e)|0;B=0;r=c;return B|0}switch(w|0){case 32844:{if((j[a+88>>1]|0)==-30860){B=1;r=c;return B|0}k[l>>2]=136291;k[l+4>>2]=34676;Bq(b,136258,l)|0;B=0;r=c;return B|0}case 32845:break;default:break b}if((j[a+88>>1]&-2)<<16>>16!=-30860){k[h>>2]=136291;k[h+4>>2]=34676;k[h+8>>2]=34677;Bq(b,136303,h)|0;B=0;r=c;return B|0}C=j[a+126>>1]|0;if(C<<16>>16!=1){k[g>>2]=136391;k[g+4>>2]=C&65535;Bq(b,136344,g)|0;B=0;r=c;return B|0}C=j[v>>1]|0;if(C<<16>>16==3){B=1;r=c;return B|0}k[f>>2]=136130;k[f+4>>2]=C&65535;Bq(b,136411,f)|0;B=0;r=c;return B|0}while(0);k[d>>2]=130805;k[d+4>>2]=w;Bq(b,136411,d)|0;B=0;r=c;return B|0}function yc(a){a=a|0;var b=0,c=0,d=0;b=a+56|0;c=k[b>>2]|0;if(c){ne(c);k[b>>2]=0}b=a+60|0;c=k[b>>2]|0;if(c){ne(c);k[b>>2]=0}b=a+64|0;c=k[b>>2]|0;if(c){ne(c);k[b>>2]=0}b=a+68|0;c=k[b>>2]|0;if(c){ne(c);k[b>>2]=0}b=a+72|0;c=k[b>>2]|0;if(c){ne(c);k[b>>2]=0}b=a+76|0;c=k[b>>2]|0;if(c){ne(c);k[b>>2]=0}b=a+80|0;c=k[b>>2]|0;if(c){ne(c);k[b>>2]=0}b=a+36|0;c=k[b>>2]|0;if(!c)return;ne(c);c=a+40|0;ne(k[c>>2]|0);d=a+44|0;ne(k[d>>2]|0);k[d>>2]=0;k[c>>2]=0;k[b>>2]=0;return}function zc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,l=0,n=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0.0;e=r;r=r+384|0;f=e+344|0;g=e+336|0;h=e+328|0;l=e+320|0;n=e+312|0;p=e+304|0;q=e+296|0;s=e+288|0;t=e+280|0;u=e+272|0;v=e+264|0;w=e+256|0;x=e+248|0;y=e+240|0;z=e+224|0;A=e+216|0;B=e+208|0;C=e+200|0;D=e+192|0;E=e+176|0;F=e+168|0;G=e+160|0;H=e+152|0;I=e+144|0;J=e+136|0;K=e+128|0;L=e+120|0;M=e+96|0;N=e+80|0;O=e+72|0;P=e+64|0;Q=e+56|0;R=e+48|0;S=e+40|0;T=e+32|0;U=e+24|0;V=e+16|0;W=e+8|0;X=e;Y=e+364|0;Z=e+374|0;_=e+372|0;$=e+370|0;aa=e+360|0;ba=e+356|0;ca=e+352|0;da=e+368|0;k[a+84>>2]=0;k[a+88>>2]=0;ea=a+36|0;k[ea>>2]=0;fa=a+40|0;k[fa>>2]=0;ga=a+44|0;k[ga>>2]=0;j[a+30>>1]=4;k[a>>2]=b;k[a+4>>2]=c;c=a+24|0;k[X>>2]=c;Ge(b,258,X)|0;X=m[c>>1]|0;a:do switch(X|0){case 16:case 8:case 4:case 2:case 1:{ia=a+12|0;k[ia>>2]=0;ja=a+26|0;k[V>>2]=ja;Ge(b,277,V)|0;k[U>>2]=Z;k[U+4>>2]=Y;Ge(b,338,U)|0;b:do if(j[Z>>1]|0){ka=m[k[Y>>2]>>1]|0;switch(ka|0){case 0:break;case 2:case 1:{k[ia>>2]=ka;break b;break}default:break b}if((m[ja>>1]|0)>3)k[ia>>2]=1}while(0);ka=a+32|0;k[T>>2]=ka;if(!(Pb(b,262,T)|0))j[ka>>1]=0;la=j[Z>>1]|0;ma=j[ja>>1]|0;if(!(la<<16>>16))if(ma<<16>>16==4)if((j[ka>>1]|0)==2){k[ia>>2]=1;j[Z>>1]=1;na=4;oa=1}else{na=4;oa=0}else{na=ma;oa=0}else{na=ma;oa=la}la=(na&65535)-(oa&65535)|0;k[S>>2]=$;Ge(b,259,S)|0;k[R>>2]=_;Ge(b,284,R)|0;k[Q>>2]=ka;c:do if(!(Pb(b,262,Q)|0))switch(la|0){case 1:{k[P>>2]=Q;Pb(b,259,P)|0;ma=j[Q>>1]|0;d:do if(ma<<16>>16<3)if(ma<<16>>16<2)switch(ma<<16>>16){case -32765:{pa=18;break d;break}default:{pa=19;break d}}else switch(ma<<16>>16){case 2:{pa=18;break d;break}default:{pa=19;break d}}else switch(ma<<16>>16){case 4:case 3:{pa=18;break}default:pa=19}while(0);if((pa|0)==18){j[ka>>1]=0;qa=0;break c}else if((pa|0)==19){j[ka>>1]=1;qa=1;break c}break}case 3:{j[ka>>1]=2;qa=2;break c;break}default:{k[O>>2]=130805;Bq(d,136029,O)|0;break a}}else qa=j[ka>>1]|0;while(0);ma=qa&65535;e:do if((ma|0)<5){switch(ma|0){case 3:{pa=23;break}case 1:case 0:break;case 2:{if((la|0)>=3)break e;k[K>>2]=136187;k[K+4>>2]=la;Bq(d,136144,K)|0;break a;break}default:{pa=49;break e}}do if((pa|0)==23){k[N>>2]=aa;k[N+4>>2]=ba;k[N+8>>2]=ca;if(!(Pb(b,320,N)|0)){ra=d;sa=136511;ta=ra+32|0;do{i[ra>>0]=i[sa>>0]|0;ra=ra+1|0;sa=sa+1|0}while((ra|0)<(ta|0));break a}ua=2<<m[c>>1];va=me(ua)|0;k[ea>>2]=va;va=me(ua)|0;k[fa>>2]=va;va=me(ua)|0;k[ga>>2]=va;wa=k[ea>>2]|0;if((wa|0)!=0?!((va|0)==0|(k[fa>>2]|0)==0):0){qe(wa,k[aa>>2]|0,ua);qe(k[fa>>2]|0,k[ba>>2]|0,ua);qe(k[ga>>2]|0,k[ca>>2]|0,ua);break}ra=d;sa=136543;ta=ra+32|0;do{i[ra>>0]=i[sa>>0]|0;ra=ra+1|0;sa=sa+1|0}while((ra|0)<(ta|0));break a}while(0);if(((j[_>>1]|0)==1?(ua=j[ja>>1]|0,wa=ua&65535,ua<<16>>16!=1):0)?(ua=j[c>>1]|0,(ua&65535)<8):0){va=m[ka>>1]|0;k[M>>2]=130805;k[M+4>>2]=va;k[M+8>>2]=136130;k[M+12>>2]=wa;k[M+16>>2]=ua&65535;Bq(d,136051,M)|0;break a}}else{if((ma|0)<8){switch(ma|0){case 6:{if(!((j[_>>1]|0)==1&(j[$>>1]|0)==7))break e;k[L>>2]=1;Ob(b,65538,L)|0;j[ka>>1]=2;break e;break}case 5:break;default:{pa=49;break e}}k[J>>2]=da;Ge(b,332,J)|0;ua=j[da>>1]|0;if(ua<<16>>16!=1){k[I>>2]=136251;k[I+4>>2]=ua&65535;Bq(d,136202,I)|0;break a}ua=j[ja>>1]|0;if((ua&65535)>=4)break;k[H>>2]=136130;k[H+4>>2]=ua&65535;Bq(d,136202,H)|0;break a}if((ma|0)<32844)switch(ma|0){case 8:{break e;break}default:{pa=49;break e}}switch(ma|0){case 32844:{if((j[$>>1]|0)==-30860){k[F>>2]=3;Ob(b,65560,F)|0;j[ka>>1]=1;j[c>>1]=8;break e}else{k[G>>2]=136291;k[G+4>>2]=34676;Bq(d,136258,G)|0;break a}break}case 32845:break;default:{pa=49;break e}}if((j[$>>1]&-2)<<16>>16!=-30860){k[E>>2]=136291;k[E+4>>2]=34676;k[E+8>>2]=34677;Bq(d,136303,E)|0;break a}ua=j[_>>1]|0;if(ua<<16>>16==1){k[C>>2]=3;Ob(b,65560,C)|0;j[ka>>1]=2;j[c>>1]=8;break}k[D>>2]=136391;k[D+4>>2]=ua&65535;Bq(d,136344,D)|0;xa=0;r=e;return xa|0}while(0);if((pa|0)==49){k[B>>2]=130805;k[B+4>>2]=ma;Bq(d,136411,B)|0;break a}la=a+56|0;ua=a+72|0;wa=a+76|0;va=a+80|0;k[la>>2]=0;k[la+4>>2]=0;k[la+8>>2]=0;k[la+12>>2]=0;k[la+16>>2]=0;k[la+20>>2]=0;k[la+24>>2]=0;k[A>>2]=a+16;Pb(b,256,A)|0;k[z>>2]=a+20;Pb(b,257,z)|0;k[y>>2]=a+28;Ge(b,274,y)|0;if((j[_>>1]|0)==2){ya=(m[ja>>1]|0)<2;k[a+8>>2]=ya&1;if(!ya){ya=(rd(k[a>>2]|0)|0)!=0;za=a+48|0;k[za>>2]=ya?3:4;ya=a+52|0;k[ya>>2]=0;f:do switch(m[ka>>1]|0){case 2:case 1:case 0:{switch(m[c>>1]|0){case 8:{switch(k[ia>>2]|0){case 1:{k[ya>>2]=1;break f;break}case 2:{if(k[wa>>2]|0)Ja(136575,136593,2728,136608);Aa=me(65536)|0;k[wa>>2]=Aa;if(!Aa){vc(k[(k[a>>2]|0)+628>>2]|0,136608,150005,n);break f}else{Ba=0;Ca=Aa}while(1){Aa=0;Da=Ca;while(1){Ea=((((ha(Aa,Ba)|0)+127|0)>>>0)/255|0)&255;i[Da>>0]=Ea;Aa=Aa+1|0;if((Aa|0)==256)break;else Da=Da+1|0}Ba=Ba+1|0;if((Ba|0)==256)break;else Ca=Ca+256|0}k[ya>>2]=2;break f;break}default:{k[ya>>2]=3;break f}}break}case 16:break;default:break f}Da=k[ia>>2]|0;if((Da|0)==1){if(k[va>>2]|0)Ja(136623,136593,2750,136648);Aa=me(65536)|0;k[va>>2]=Aa;if(!Aa){vc(k[(k[a>>2]|0)+628>>2]|0,136648,150005,l);break f}else{Fa=Aa;Ga=0}while(1){i[Fa>>0]=((Ga+128|0)>>>0)/257|0;Ga=Ga+1|0;if((Ga|0)==65536)break;else Fa=Fa+1|0}k[ya>>2]=4;break f}Aa=(Da|0)==2;if(k[va>>2]|0)Ja(136623,136593,2750,136648);Ea=me(65536)|0;k[va>>2]=Ea;if(!Ea){vc(k[(k[a>>2]|0)+628>>2]|0,136648,150005,h);Ha=0}else{Ia=Ea;Ea=0;while(1){i[Ia>>0]=((Ea+128|0)>>>0)/257|0;Ea=Ea+1|0;if((Ea|0)==65536){Ha=1;break}else Ia=Ia+1|0}}if(!Aa){if(!Ha)break f;k[ya>>2]=6;break f}if(Ha){if(k[wa>>2]|0)Ja(136575,136593,2728,136608);Ia=me(65536)|0;k[wa>>2]=Ia;if(!Ia){vc(k[(k[a>>2]|0)+628>>2]|0,136608,150005,g);break f}else{Ka=0;La=Ia}while(1){Ia=0;Ea=La;while(1){Da=((((ha(Ia,Ka)|0)+127|0)>>>0)/255|0)&255;i[Ea>>0]=Da;Ia=Ia+1|0;if((Ia|0)==256)break;else Ea=Ea+1|0}Ka=Ka+1|0;if((Ka|0)==256)break;else La=La+256|0}k[ya>>2]=5}break}case 5:{if((j[c>>1]|0)==8?(j[ja>>1]|0)==4:0){k[ia>>2]=1;k[ya>>2]=7}break}case 6:{if((((j[c>>1]|0)==8?(j[ja>>1]|0)==3:0)?(Xc(a)|0)!=0:0)?(Aa=k[a>>2]|0,k[f>>2]=y,k[f+4>>2]=z,Ge(Aa,530,f)|0,(m[y>>1]<<4|m[z>>1]|0)==17):0)k[ya>>2]=8;break}default:{}}while(0);if(k[za>>2]|0)if(k[ya>>2]|0){xa=1;r=e;return xa|0}ra=d;sa=136793;ta=ra+28|0;do{i[ra>>0]=i[sa>>0]|0;ra=ra+1|0;sa=sa+1|0}while((ra|0)<(ta|0));break a}}else k[a+8>>2]=1;ya=(rd(k[a>>2]|0)|0)!=0;za=a+48|0;k[za>>2]=ya?1:2;ya=a+52|0;k[ya>>2]=0;g:do switch(m[ka>>1]|0){case 2:{switch(m[c>>1]|0){case 8:{switch(k[ia>>2]|0){case 1:{k[ya>>2]=1;break g;break}case 2:{if(k[wa>>2]|0)Ja(136575,136593,2728,136608);ma=me(65536)|0;k[wa>>2]=ma;if(!ma){vc(k[(k[a>>2]|0)+628>>2]|0,136608,150005,x);break g}else{Ma=0;Na=ma}while(1){ma=0;Aa=Na;while(1){Ea=((((ha(ma,Ma)|0)+127|0)>>>0)/255|0)&255;i[Aa>>0]=Ea;ma=ma+1|0;if((ma|0)==256)break;else Aa=Aa+1|0}Ma=Ma+1|0;if((Ma|0)==256)break;else Na=Na+256|0}k[ya>>2]=2;break g;break}default:{k[ya>>2]=3;break g}}break}case 16:break;default:break g}Aa=k[ia>>2]|0;if((Aa|0)==1){if(k[va>>2]|0)Ja(136623,136593,2750,136648);ma=me(65536)|0;k[va>>2]=ma;if(!ma){vc(k[(k[a>>2]|0)+628>>2]|0,136648,150005,w);break g}else{Oa=ma;Pa=0}while(1){i[Oa>>0]=((Pa+128|0)>>>0)/257|0;Pa=Pa+1|0;if((Pa|0)==65536)break;else Oa=Oa+1|0}k[ya>>2]=4;break g}ma=(Aa|0)==2;if(k[va>>2]|0)Ja(136623,136593,2750,136648);Ea=me(65536)|0;k[va>>2]=Ea;if(!Ea){vc(k[(k[a>>2]|0)+628>>2]|0,136648,150005,v);Qa=0}else{Ia=Ea;Ea=0;while(1){i[Ia>>0]=((Ea+128|0)>>>0)/257|0;Ea=Ea+1|0;if((Ea|0)==65536){Qa=1;break}else Ia=Ia+1|0}}if(!ma){if(!Qa)break g;k[ya>>2]=6;break g}if(Qa){if(k[wa>>2]|0)Ja(136575,136593,2728,136608);Ia=me(65536)|0;k[wa>>2]=Ia;if(!Ia){vc(k[(k[a>>2]|0)+628>>2]|0,136608,150005,u);break g}else{Ra=0;Sa=Ia}while(1){Ia=0;Ea=Sa;while(1){Aa=((((ha(Ia,Ra)|0)+127|0)>>>0)/255|0)&255;i[Ea>>0]=Aa;Ia=Ia+1|0;if((Ia|0)==256)break;else Ea=Ea+1|0}Ra=Ra+1|0;if((Ra|0)==256)break;else Sa=Sa+256|0}k[ya>>2]=5}break}case 5:{if((Kc(a)|0)!=0?(j[c>>1]|0)==8:0)if(!(k[la>>2]|0)){k[ya>>2]=7;break g}else{k[ya>>2]=8;break g}break}case 3:{if(Kc(a)|0)switch(m[c>>1]|0){case 8:{k[ya>>2]=9;break g;break}case 4:{k[ya>>2]=10;break g;break}case 2:{k[ya>>2]=11;break g;break}case 1:{k[ya>>2]=12;break g;break}default:break g}break}case 1:case 0:{if(Kc(a)|0)switch(m[c>>1]|0){case 16:{k[ya>>2]=13;break g;break}case 8:{if((k[ia>>2]|0)!=0?(j[ja>>1]|0)==2:0){k[ya>>2]=14;break g}k[ya>>2]=15;break g;break}case 4:{k[ya>>2]=16;break g;break}case 2:{k[ya>>2]=17;break g;break}case 1:{k[ya>>2]=18;break g;break}default:break g}break}case 6:{if(((j[c>>1]|0)==8?(j[ja>>1]|0)==3:0)?(Xc(a)|0)!=0:0){ma=k[a>>2]|0;k[t>>2]=A;k[t+4>>2]=Q;Ge(ma,530,t)|0;switch(m[A>>1]<<4|m[Q>>1]|0){case 68:{k[ya>>2]=19;break g;break}case 66:{k[ya>>2]=20;break g;break}case 65:{k[ya>>2]=21;break g;break}case 34:{k[ya>>2]=22;break g;break}case 33:{k[ya>>2]=23;break g;break}case 18:{k[ya>>2]=24;break g;break}case 17:{k[ya>>2]=25;break g;break}default:break g}}break}case 8:{if((Kc(a)|0)!=0?(j[c>>1]|0)==8:0){if((k[ua>>2]|0)==0?(ma=me(18124)|0,k[ua>>2]=ma,(ma|0)==0):0){vc(k[(k[a>>2]|0)+628>>2]|0,136670,136691,s);Ta=0}else{ma=k[a>>2]|0;k[q>>2]=y;Ge(ma,318,q)|0;o[z+4>>2]=100.0;ma=k[y>>2]|0;Ea=ma+4|0;o[z>>2]=+o[ma>>2]/+o[Ea>>2]*100.0;Ua=+o[Ea>>2];o[z+8>>2]=(1.0-+o[ma>>2]-Ua)/Ua*100.0;if((Je(k[ua>>2]|0,7644,z)|0)<0){vc(k[(k[a>>2]|0)+628>>2]|0,136670,136738,p);ne(k[ua>>2]|0);Ta=0}else Ta=26}k[ya>>2]=Ta}break}default:{}}while(0);if(k[za>>2]|0)if(k[ya>>2]|0){xa=1;r=e;return xa|0}ra=d;sa=136793;ta=ra+28|0;do{i[ra>>0]=i[sa>>0]|0;ra=ra+1|0;sa=sa+1|0}while((ra|0)<(ta|0));break}default:{k[W>>2]=X;Bq(d,135980,W)|0}}while(0);ne(k[ea>>2]|0);ne(k[fa>>2]|0);ne(k[ga>>2]|0);k[ga>>2]=0;k[fa>>2]=0;k[ea>>2]=0;xa=0;r=e;return xa|0}function Ac(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,l=0,m=0,n=0,o=0,p=0,q=0;g=r;r=r+1136|0;h=g+16|0;i=g+8|0;l=g;m=g+112|0;n=g+20|0;qr(m|0,0,1024)|0;if((xc(a,m)|0)!=0?(zc(n,a,f,m)|0)!=0:0){j[n+30>>1]=e;e=k[n+20>>2]|0;f=d+((ha(c-e|0,b)|0)<<2)|0;c=k[n+48>>2]|0;do if(c)if(!(k[n+52>>2]|0)){d=k[n>>2]|0;o=k[d+628>>2]|0;vc(o,qd(d)|0,136844,i);p=0;break}else{p=xb[c&63](n,f,b,e)|0;break}else{d=k[n>>2]|0;o=k[d+628>>2]|0;vc(o,qd(d)|0,136821,l);p=0}while(0);yc(n);q=p;r=g;return q|0}p=k[a+628>>2]|0;n=qd(a)|0;k[h>>2]=m;vc(p,n,154321,h);q=0;r=g;return q|0}function Bc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Ac(a,b,c,d,4,e)|0}function Cc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;e=r;r=r+32|0;f=e+16|0;g=e+8|0;h=e;i=e+24|0;l=e+20|0;n=k[a>>2]|0;o=k[a+52>>2]|0;p=me(ge(n)|0)|0;if(!p){q=k[n+628>>2]|0;s=qd(n)|0;k[h>>2]=136922;vc(q,s,154321,h);t=0;r=e;return t|0}pe(p,0,ge(n)|0);k[g>>2]=i;Pb(n,322,g)|0;k[f>>2]=l;Pb(n,323,f)|0;a:do switch(m[a+28>>1]|0){case 5:case 1:{switch(j[a+30>>1]|0){case 6:case 2:{u=2;v=17;break a;break}case 7:case 3:{w=3;v=16;break a;break}case 8:case 4:{w=1;v=16;break a;break}default:{u=0;v=17;break a}}break}case 6:case 2:{switch(j[a+30>>1]|0){case 5:case 1:{u=2;v=17;break a;break}case 7:case 3:{w=1;v=16;break a;break}case 8:case 4:{w=3;v=16;break a;break}default:{u=0;v=17;break a}}break}case 7:case 3:{switch(j[a+30>>1]|0){case 5:case 1:{w=3;v=16;break a;break}case 8:case 4:{u=2;v=17;break a;break}case 6:case 2:{w=1;v=16;break a;break}default:{u=0;v=17;break a}}break}case 8:case 4:{switch(j[a+30>>1]|0){case 5:case 1:{w=1;v=16;break a;break}case 7:case 3:{u=2;v=17;break a;break}case 6:case 2:{w=3;v=16;break a;break}default:{u=0;v=17;break a}}break}default:{u=0;v=17}}while(0);if((v|0)==16){f=k[i>>2]|0;x=w;y=f;z=1;A=0-(f+c)|0;B=d+-1|0}else if((v|0)==17){v=k[i>>2]|0;x=u;y=v;z=0;A=c-v|0;B=0}v=a+88|0;u=((k[v>>2]|0)>>>0)%(y>>>0)|0;f=y-u|0;y=u+A|0;w=(d|0)==0;if(w)C=1;else{g=a+84|0;h=a+4|0;s=(c|0)==0;q=a+26|0;D=1;E=0;F=B;while(1){B=k[l>>2]|0;G=k[g>>2]|0;H=B-(((G+E|0)>>>0)%(B>>>0)|0)|0;B=(H+E|0)>>>0>d>>>0?d-E|0:H;b:do if(s)I=D;else{H=ha(F,c)|0;J=G;K=k[v>>2]|0;L=u;M=y;N=f;O=0;while(1){if((yd(n,p,K,J+E|0,0,0)|0)==-1?(k[h>>2]|0)!=0:0){I=0;break b}P=(((k[g>>2]|0)+E|0)>>>0)%((k[l>>2]|0)>>>0)|0;Q=ha(de(n)|0,P)|0;P=(ha(m[q>>1]|0,L)|0)+Q|0;if((O+N|0)>>>0>c>>>0){Q=c-O|0;R=(k[i>>2]|0)-Q|0;S=R;T=R+A|0;U=Q}else{S=L;T=M;U=N}wb[o&31](a,b+(O+H<<2)|0,O,F,U,B,S,T,p+P|0);P=U+O|0;if(P>>>0>=c>>>0){I=D;break b}J=k[g>>2]|0;K=U+K|0;L=0;M=A;N=k[i>>2]|0;O=P}}while(0);E=B+E|0;if(E>>>0>=d>>>0){C=I;break}else{D=I;F=(z?0-B|0:B)+F|0}}}ne(p);if((x&2|0)==0|w){t=C;r=e;return t|0}w=c+-1|0;x=0;do{p=ha(x,c)|0;F=w+p|0;if((p|0)<(F|0)){z=b+(p<<2)|0;p=b+(F<<2)|0;do{F=k[z>>2]|0;k[z>>2]=k[p>>2];k[p>>2]=F;z=z+4|0;p=p+-4|0}while(z>>>0<p>>>0)}x=x+1|0}while((x|0)!=(d|0));t=C;r=e;return t|0}function Dc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;e=r;r=r+48|0;f=e+24|0;g=e;h=e+28|0;i=e+32|0;l=k[a>>2]|0;n=k[a+52>>2]|0;o=k[a+16>>2]|0;k[g>>2]=e+34;k[g+4>>2]=i;Ge(l,530,g)|0;if(!(j[i>>1]|0)){g=k[l+628>>2]|0;vc(g,qd(l)|0,137155,e+8|0);p=0;r=e;return p|0}g=me(Nd(l)|0)|0;if(!g){q=k[l+628>>2]|0;vc(q,qd(l)|0,137190,e+16|0);p=0;r=e;return p|0}pe(g,0,Nd(l)|0);a:do switch(m[a+28>>1]|0){case 5:case 1:{switch(j[a+30>>1]|0){case 6:case 2:{s=2;t=0;u=0;v=0;break a;break}case 7:case 3:{w=3;x=18;break a;break}case 8:case 4:{w=1;x=18;break a;break}default:{s=0;t=0;u=0;v=0;break a}}break}case 6:case 2:{switch(j[a+30>>1]|0){case 5:case 1:{s=2;t=0;u=0;v=0;break a;break}case 7:case 3:{w=1;x=18;break a;break}case 8:case 4:{w=3;x=18;break a;break}default:{s=0;t=0;u=0;v=0;break a}}break}case 7:case 3:{switch(j[a+30>>1]|0){case 5:case 1:{w=3;x=18;break a;break}case 8:case 4:{s=2;t=0;u=0;v=0;break a;break}case 6:case 2:{w=1;x=18;break a;break}default:{s=0;t=0;u=0;v=0;break a}}break}case 8:case 4:{switch(j[a+30>>1]|0){case 5:case 1:{w=1;x=18;break a;break}case 7:case 3:{s=2;t=0;u=0;v=0;break a;break}case 6:case 2:{w=3;x=18;break a;break}default:{s=0;t=0;u=0;v=0;break a}}break}default:{s=0;t=0;u=0;v=0}}while(0);if((x|0)==18){s=w;t=1;u=0-(c<<1)|0;v=d+-1|0}k[f>>2]=h;Ge(l,278,f)|0;f=Pd(l)|0;w=o>>>0>c>>>0?o-c|0:0;o=a+4|0;x=(d|0)==0;b:do if(!x){q=a+84|0;y=a+88|0;z=a+26|0;if(t){A=0;B=v;while(1){C=k[h>>2]|0;D=(k[q>>2]|0)+A|0;E=C-((D>>>0)%(C>>>0)|0)|0;C=(E+A|0)>>>0>d>>>0?d-A|0:E;E=m[i>>1]|0;F=(C>>>0)%(E>>>0)|0;G=Id(l,D,0)|0;if((vd(l,G,g,ha(C+((F|0)==0?0:E-F|0)+((((k[q>>2]|0)+A|0)>>>0)%((k[h>>2]|0)>>>0)|0)|0,f)|0)|0)==-1?(k[o>>2]|0)!=0:0){H=0;break b}F=ha((((k[q>>2]|0)+A|0)>>>0)%((k[h>>2]|0)>>>0)|0,f)|0;E=b+((ha(B,c)|0)<<2)|0;G=g+((ha(m[z>>1]|0,k[y>>2]|0)|0)+F)|0;wb[n&31](a,E,0,B,c,C,w,u,G);A=C+A|0;if(A>>>0>=d>>>0){H=1;break}else B=B-C|0}}else{B=0;A=v;while(1){C=k[h>>2]|0;G=(k[q>>2]|0)+B|0;E=C-((G>>>0)%(C>>>0)|0)|0;C=(E+B|0)>>>0>d>>>0?d-B|0:E;E=m[i>>1]|0;F=(C>>>0)%(E>>>0)|0;D=Id(l,G,0)|0;if((vd(l,D,g,ha(C+((F|0)==0?0:E-F|0)+((((k[q>>2]|0)+B|0)>>>0)%((k[h>>2]|0)>>>0)|0)|0,f)|0)|0)==-1?(k[o>>2]|0)!=0:0){H=0;break b}F=ha((((k[q>>2]|0)+B|0)>>>0)%((k[h>>2]|0)>>>0)|0,f)|0;E=b+((ha(A,c)|0)<<2)|0;D=g+((ha(m[z>>1]|0,k[y>>2]|0)|0)+F)|0;wb[n&31](a,E,0,A,c,C,w,u,D);B=C+B|0;if(B>>>0>=d>>>0){H=1;break}else A=C+A|0}}}else H=1;while(0);if(!((s&2|0)==0|x)){x=c+-1|0;s=0;do{u=ha(s,c)|0;w=x+u|0;if((u|0)<(w|0)){a=b+(u<<2)|0;u=b+(w<<2)|0;do{w=k[a>>2]|0;k[a>>2]=k[u>>2];k[u>>2]=w;a=a+4|0;u=u+-4|0}while(a>>>0<u>>>0)}s=s+1|0}while((s|0)!=(d|0))}ne(g);p=H;r=e;return p|0}function Ec(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ia=0,ja=0,ka=0;d=m[a+26>>1]|0;a=ha(d,g)|0;if(!f)return;g=e>>>0>7;c=d+1|0;j=d+2|0;n=d+3|0;o=d<<1;p=o|1;q=o+2|0;r=o+3|0;s=d*3|0;t=s+1|0;u=s+2|0;v=s+3|0;w=d<<2;x=w|1;y=w|2;z=w|3;A=d*5|0;B=A+1|0;C=A+2|0;D=A+3|0;E=d*6|0;F=E|1;G=E+2|0;H=E+3|0;I=d*7|0;J=I+1|0;K=I+2|0;L=I+3|0;M=d<<3;N=e+-8|0;O=N&-8;P=N-O|0;N=O+8|0;O=ha(N,d)|0;Q=i;i=b;b=f;while(1){b=b+-1|0;if(g){f=Q+O|0;R=Q;S=i;T=e;while(1){k[S>>2]=(l[R+1>>0]|0)<<8|(l[R>>0]|0)|(l[R+2>>0]|0)<<16|(l[R+3>>0]|0)<<24;k[S+4>>2]=(l[R+c>>0]|0)<<8|(l[R+d>>0]|0)|(l[R+j>>0]|0)<<16|(l[R+n>>0]|0)<<24;k[S+8>>2]=(l[R+p>>0]|0)<<8|(l[R+o>>0]|0)|(l[R+q>>0]|0)<<16|(l[R+r>>0]|0)<<24;k[S+12>>2]=(l[R+t>>0]|0)<<8|(l[R+s>>0]|0)|(l[R+u>>0]|0)<<16|(l[R+v>>0]|0)<<24;k[S+16>>2]=(l[R+x>>0]|0)<<8|(l[R+w>>0]|0)|(l[R+y>>0]|0)<<16|(l[R+z>>0]|0)<<24;k[S+20>>2]=(l[R+B>>0]|0)<<8|(l[R+A>>0]|0)|(l[R+C>>0]|0)<<16|(l[R+D>>0]|0)<<24;k[S+24>>2]=(l[R+F>>0]|0)<<8|(l[R+E>>0]|0)|(l[R+G>>0]|0)<<16|(l[R+H>>0]|0)<<24;k[S+28>>2]=(l[R+J>>0]|0)<<8|(l[R+I>>0]|0)|(l[R+K>>0]|0)<<16|(l[R+L>>0]|0)<<24;T=T+-8|0;if(T>>>0<=7)break;else{R=R+M|0;S=S+32|0}}U=i+(N<<2)|0;V=f;W=P}else{U=i;V=Q;W=e}switch(W|0){case 1:{X=U;Y=V;Z=14;break}case 7:{k[U>>2]=(l[V+1>>0]|0)<<8|(l[V>>0]|0)|(l[V+2>>0]|0)<<16|(l[V+3>>0]|0)<<24;_=U+4|0;$=V+d|0;Z=9;break}case 6:{_=U;$=V;Z=9;break}case 5:{aa=U;ba=V;Z=10;break}case 4:{ca=U;da=V;Z=11;break}case 3:{ea=U;fa=V;Z=12;break}case 2:{ga=U;ia=V;Z=13;break}default:{ja=U;ka=V}}if((Z|0)==9){Z=0;k[_>>2]=(l[$+1>>0]|0)<<8|(l[$>>0]|0)|(l[$+2>>0]|0)<<16|(l[$+3>>0]|0)<<24;aa=_+4|0;ba=$+d|0;Z=10}if((Z|0)==10){Z=0;k[aa>>2]=(l[ba+1>>0]|0)<<8|(l[ba>>0]|0)|(l[ba+2>>0]|0)<<16|(l[ba+3>>0]|0)<<24;ca=aa+4|0;da=ba+d|0;Z=11}if((Z|0)==11){Z=0;k[ca>>2]=(l[da+1>>0]|0)<<8|(l[da>>0]|0)|(l[da+2>>0]|0)<<16|(l[da+3>>0]|0)<<24;ea=ca+4|0;fa=da+d|0;Z=12}if((Z|0)==12){Z=0;k[ea>>2]=(l[fa+1>>0]|0)<<8|(l[fa>>0]|0)|(l[fa+2>>0]|0)<<16|(l[fa+3>>0]|0)<<24;ga=ea+4|0;ia=fa+d|0;Z=13}if((Z|0)==13){Z=0;k[ga>>2]=(l[ia+1>>0]|0)<<8|(l[ia>>0]|0)|(l[ia+2>>0]|0)<<16|(l[ia+3>>0]|0)<<24;X=ga+4|0;Y=ia+d|0;Z=14}if((Z|0)==14){Z=0;k[X>>2]=(l[Y+1>>0]|0)<<8|(l[Y>>0]|0)|(l[Y+2>>0]|0)<<16|(l[Y+3>>0]|0)<<24;ja=X+4|0;ka=Y+d|0}if(!b)break;else{Q=ka+a|0;i=ja+(h<<2)|0}}return}function Fc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;d=m[a+26>>1]|0;c=ha(d,g)|0;if(!f)return;g=(e|0)==0;j=a+76|0;a=ha(d,e)|0;n=b;b=i;i=f;while(1){i=i+-1|0;if(g){o=n;p=b}else{f=b+a|0;q=k[j>>2]|0;r=e;s=b;t=n;while(1){r=r+-1|0;u=l[s+3>>0]|0;v=u<<8;k[t>>2]=l[q+(l[s>>0]|0|v)>>0]|0|u<<24|(l[q+(l[s+1>>0]|0|v)>>0]|0)<<8|(l[q+(l[s+2>>0]|0|v)>>0]|0)<<16;if(!r)break;else{s=s+d|0;t=t+4|0}}o=n+(e<<2)|0;p=f}if(!i)break;else{n=o+(h<<2)|0;b=p+c|0}}return}function Gc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0;d=m[a+26>>1]|0;a=ha(d,g)|0;if(!f)return;g=e>>>0>7;c=d+1|0;j=d+2|0;n=d<<1;o=n|1;p=n+2|0;q=d*3|0;r=q+1|0;s=q+2|0;t=d<<2;u=t|1;v=t|2;w=d*5|0;x=w+1|0;y=w+2|0;z=d*6|0;A=z|1;B=z+2|0;C=d*7|0;D=C+1|0;E=C+2|0;F=d<<3;G=e+-8|0;H=G&-8;I=G-H|0;G=H+8|0;H=ha(G,d)|0;J=i;i=b;b=f;while(1){b=b+-1|0;if(g){f=J+H|0;K=J;L=i;M=e;while(1){k[L>>2]=l[K>>0]|0|(l[K+1>>0]|0)<<8|(l[K+2>>0]|0)<<16|-16777216;k[L+4>>2]=l[K+d>>0]|0|(l[K+c>>0]|0)<<8|(l[K+j>>0]|0)<<16|-16777216;k[L+8>>2]=l[K+n>>0]|0|(l[K+o>>0]|0)<<8|(l[K+p>>0]|0)<<16|-16777216;k[L+12>>2]=l[K+q>>0]|0|(l[K+r>>0]|0)<<8|(l[K+s>>0]|0)<<16|-16777216;k[L+16>>2]=l[K+t>>0]|0|(l[K+u>>0]|0)<<8|(l[K+v>>0]|0)<<16|-16777216;k[L+20>>2]=l[K+w>>0]|0|(l[K+x>>0]|0)<<8|(l[K+y>>0]|0)<<16|-16777216;k[L+24>>2]=l[K+z>>0]|0|(l[K+A>>0]|0)<<8|(l[K+B>>0]|0)<<16|-16777216;k[L+28>>2]=l[K+C>>0]|0|(l[K+D>>0]|0)<<8|(l[K+E>>0]|0)<<16|-16777216;M=M+-8|0;if(M>>>0<=7)break;else{K=K+F|0;L=L+32|0}}N=i+(G<<2)|0;O=f;P=I}else{N=i;O=J;P=e}switch(P|0){case 1:{Q=N;R=O;S=14;break}case 7:{k[N>>2]=l[O>>0]|0|(l[O+1>>0]|0)<<8|(l[O+2>>0]|0)<<16|-16777216;T=N+4|0;U=O+d|0;S=9;break}case 6:{T=N;U=O;S=9;break}case 5:{V=N;W=O;S=10;break}case 4:{X=N;Y=O;S=11;break}case 3:{Z=N;_=O;S=12;break}case 2:{$=N;aa=O;S=13;break}default:{ba=N;ca=O}}if((S|0)==9){S=0;k[T>>2]=l[U>>0]|0|(l[U+1>>0]|0)<<8|(l[U+2>>0]|0)<<16|-16777216;V=T+4|0;W=U+d|0;S=10}if((S|0)==10){S=0;k[V>>2]=l[W>>0]|0|(l[W+1>>0]|0)<<8|(l[W+2>>0]|0)<<16|-16777216;X=V+4|0;Y=W+d|0;S=11}if((S|0)==11){S=0;k[X>>2]=l[Y>>0]|0|(l[Y+1>>0]|0)<<8|(l[Y+2>>0]|0)<<16|-16777216;Z=X+4|0;_=Y+d|0;S=12}if((S|0)==12){S=0;k[Z>>2]=l[_>>0]|0|(l[_+1>>0]|0)<<8|(l[_+2>>0]|0)<<16|-16777216;$=Z+4|0;aa=_+d|0;S=13}if((S|0)==13){S=0;k[$>>2]=l[aa>>0]|0|(l[aa+1>>0]|0)<<8|(l[aa+2>>0]|0)<<16|-16777216;Q=$+4|0;R=aa+d|0;S=14}if((S|0)==14){S=0;k[Q>>2]=l[R>>0]|0|(l[R+1>>0]|0)<<8|(l[R+2>>0]|0)<<16|-16777216;ba=Q+4|0;ca=R+d|0}if(!b)break;else{J=ca+a|0;i=ba+(h<<2)|0}}return}function Hc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;d=m[a+26>>1]|0;c=ha(d,g)|0;if(!f)return;g=(e|0)==0;j=a+80|0;a=ha(d,e)|0;n=b;b=f;f=i;while(1){b=b+-1|0;if(g){o=n;p=f}else{i=f+(a<<1)|0;q=k[j>>2]|0;r=e;s=n;t=f;while(1){r=r+-1|0;k[s>>2]=(l[q+(m[t+2>>1]|0)>>0]|0)<<8|(l[q+(m[t>>1]|0)>>0]|0)|(l[q+(m[t+4>>1]|0)>>0]|0)<<16|(l[q+(m[t+6>>1]|0)>>0]|0)<<24;if(!r)break;else{s=s+4|0;t=t+(d<<1)|0}}o=n+(e<<2)|0;p=i}if(!b)break;else{n=o+(h<<2)|0;f=p+(c<<1)|0}}return}function Ic(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;d=m[a+26>>1]|0;c=ha(d,g)|0;if(!f)return;g=(e|0)==0;j=a+80|0;n=a+76|0;a=ha(d,e)|0;o=b;b=f;f=i;while(1){b=b+-1|0;if(g){p=o;q=f}else{i=f+(a<<1)|0;r=k[j>>2]|0;s=k[n>>2]|0;t=e;u=o;v=f;while(1){t=t+-1|0;w=l[r+(m[v+6>>1]|0)>>0]|0;x=w<<8;k[u>>2]=l[s+(l[r+(m[v>>1]|0)>>0]|0|x)>>0]|0|w<<24|(l[s+(l[r+(m[v+2>>1]|0)>>0]|0|x)>>0]|0)<<8|(l[s+(l[r+(m[v+4>>1]|0)>>0]|0|x)>>0]|0)<<16;if(!t)break;else{u=u+4|0;v=v+(d<<1)|0}}p=o+(e<<2)|0;q=i}if(!b)break;else{o=p+(h<<2)|0;f=q+(c<<1)|0}}return}function Jc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;d=m[a+26>>1]|0;c=ha(d,g)|0;if(!f)return;g=(e|0)==0;j=a+80|0;a=ha(d,e)|0;n=b;b=f;f=i;while(1){b=b+-1|0;if(g){o=n;p=f}else{i=f+(a<<1)|0;q=k[j>>2]|0;r=e;s=n;t=f;while(1){r=r+-1|0;k[s>>2]=l[q+(m[t>>1]|0)>>0]|0|(l[q+(m[t+2>>1]|0)>>0]|0)<<8|(l[q+(m[t+4>>1]|0)>>0]|0)<<16|-16777216;if(!r)break;else{s=s+4|0;t=t+(d<<1)|0}}o=n+(e<<2)|0;p=i}if(!b)break;else{n=o+(h<<2)|0;f=p+(c<<1)|0}}return}function Kc(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;b=r;r=r+32|0;c=b+24|0;d=b+16|0;e=b+8|0;f=b;g=a+32|0;switch(m[g>>1]|0){case 5:case 6:case 2:{if((j[a+24>>1]|0)==8){h=1;r=b;return h|0}break}case 0:case 1:break;case 3:{n=a+36|0;o=k[n>>2]|0;p=a+40|0;q=k[p>>2]|0;s=a+44|0;t=k[s>>2]|0;u=a+24|0;v=j[u>>1]|0;w=1<<(v&65535);x=t;y=q;z=w;A=o;while(1){if((z|0)<=0){B=36;break}if((m[A>>1]|0)>255){B=34;break}if((m[y>>1]|0)>255){B=34;break}if((m[x>>1]|0)>255){B=34;break}else{x=x+2|0;y=y+2|0;z=z+-1|0;A=A+2|0}}if((B|0)==34)if(v<<16>>16==31){h=1;r=b;return h|0}else{v=w;do{w=v;v=v+-1|0;A=o+(v<<1)|0;j[A>>1]=(m[A>>1]|0)>>>8;A=q+(v<<1)|0;j[A>>1]=(m[A>>1]|0)>>>8;A=t+(v<<1)|0;j[A>>1]=(m[A>>1]|0)>>>8}while((w|0)>1)}else if((B|0)==36){B=k[a>>2]|0;v=k[B+628>>2]|0;ie(v,qd(B)|0,137096,d)}d=j[u>>1]|0;if((d&65535)>=9){h=1;r=b;return h|0}u=d&65535;d=k[n>>2]|0;n=k[p>>2]|0;p=k[s>>2]|0;s=me(((8/(u>>>0)|0)<<10)+1024|0)|0;B=a+64|0;k[B>>2]=s;if(!s){v=k[a>>2]|0;t=k[v+628>>2]|0;vc(t,qd(v)|0,137120,c);h=0;r=b;return h|0}c=s;v=0;t=s+1024|0;while(1){k[c+(v<<2)>>2]=t;switch(u|0){case 1:{s=v>>>7&1;k[t>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;s=v>>>6&1;k[t+4>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;s=v>>>5&1;k[t+8>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;s=v>>>4&1;k[t+12>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;s=v>>>3&1;k[t+16>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;s=v>>>2&1;k[t+20>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;s=v>>>1&1;k[t+24>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;s=v&1;k[t+28>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;C=t+32|0;break}case 2:{s=v>>>6&3;k[t>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;s=v>>>4&3;k[t+4>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;s=v>>>2&3;k[t+8>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;s=v&3;k[t+12>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;C=t+16|0;break}case 4:{s=v>>>4&15;k[t>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;s=v&15;k[t+4>>2]=m[d+(s<<1)>>1]&255|m[n+(s<<1)>>1]<<8&65280|m[p+(s<<1)>>1]<<16|-16777216;C=t+8|0;break}case 8:{k[t>>2]=m[d+(v<<1)>>1]&255|m[n+(v<<1)>>1]<<8&65280|m[p+(v<<1)>>1]<<16|-16777216;C=t+4|0;break}default:C=t}s=v+1|0;if((s|0)==256){h=1;break}c=k[B>>2]|0;v=s;t=C}r=b;return h|0}default:{h=1;r=b;return h|0}}C=a+24|0;t=j[C>>1]|0;v=t<<16>>16==16?255:(1<<(t&65535))+-1|0;t=v+1|0;B=me(t)|0;c=a+56|0;k[c>>2]=B;if(!B){p=k[a>>2]|0;n=k[p+628>>2]|0;vc(n,qd(p)|0,137023,f);h=0;r=b;return h|0}f=(v|0)<0;if(!(j[g>>1]|0)){if(!f?(i[B>>0]=-1,(v|0)!=0):0){p=1;do{i[(k[c>>2]|0)+p>>0]=((v-p|0)*255|0)/(v|0)|0;p=p+1|0}while((p|0)!=(t|0))}}else if(!f?(i[B>>0]=0,(v|0)!=0):0){B=1;do{i[(k[c>>2]|0)+B>>0]=(B*255|0)/(v|0)|0;B=B+1|0}while((B|0)!=(t|0))}t=j[C>>1]|0;if((t&65535)>=17){h=1;r=b;return h|0}if((m[g>>1]|0)>=2){h=1;r=b;return h|0}g=k[c>>2]|0;C=t&65535;B=8/(C>>>0)|0;v=me((B|0)==0?2048:(B<<10)+1024|0)|0;B=a+60|0;k[B>>2]=v;if(!v){f=k[a>>2]|0;a=k[f+628>>2]|0;vc(a,qd(f)|0,137065,e);h=0;r=b;return h|0}e=v+1024|0;a:do switch(t<<16>>16){case 1:{f=v;a=0;p=e;while(1){k[f+(a<<2)>>2]=p;n=l[g+(a>>7)>>0]|0;k[p>>2]=n|n<<8|n<<16|-16777216;n=l[g+(a>>>6&1)>>0]|0;k[p+4>>2]=n|n<<8|n<<16|-16777216;n=l[g+(a>>>5&1)>>0]|0;k[p+8>>2]=n|n<<8|n<<16|-16777216;n=l[g+(a>>>4&1)>>0]|0;k[p+12>>2]=n|n<<8|n<<16|-16777216;n=l[g+(a>>>3&1)>>0]|0;k[p+16>>2]=n|n<<8|n<<16|-16777216;n=l[g+(a>>>2&1)>>0]|0;k[p+20>>2]=n|n<<8|n<<16|-16777216;n=l[g+(a>>>1&1)>>0]|0;k[p+24>>2]=n|n<<8|n<<16|-16777216;n=l[g+(a&1)>>0]|0;k[p+28>>2]=n|n<<8|n<<16|-16777216;n=a+1|0;if((n|0)==256)break a;f=k[B>>2]|0;a=n;p=p+32|0}break}case 2:{p=v;a=0;f=e;while(1){k[p+(a<<2)>>2]=f;n=l[g+(a>>6)>>0]|0;k[f>>2]=n|n<<8|n<<16|-16777216;n=l[g+(a>>>4&3)>>0]|0;k[f+4>>2]=n|n<<8|n<<16|-16777216;n=l[g+(a>>>2&3)>>0]|0;k[f+8>>2]=n|n<<8|n<<16|-16777216;n=l[g+(a&3)>>0]|0;k[f+12>>2]=n|n<<8|n<<16|-16777216;if((a|0)==255)break a;p=k[B>>2]|0;a=a+1|0;f=f+16|0}break}case 16:{k[v>>2]=e;f=l[g>>0]|0;k[e>>2]=f|f<<8|f<<16|-16777216;f=1;a=e;do{a=a+4|0;k[(k[B>>2]|0)+(f<<2)>>2]=a;p=l[g+f>>0]|0;k[a>>2]=p|p<<8|p<<16|-16777216;f=f+1|0}while((f|0)!=256);break}default:{f=v;a=0;p=e;while(1){k[f+(a<<2)>>2]=p;switch(C|0){case 8:case 16:{n=l[g+a>>0]|0;k[p>>2]=n|n<<8|n<<16|-16777216;D=p+4|0;break}case 4:{n=l[g+(a>>4)>>0]|0;k[p>>2]=n|n<<8|n<<16|-16777216;n=l[g+(a&15)>>0]|0;k[p+4>>2]=n|n<<8|n<<16|-16777216;D=p+8|0;break}default:D=p}n=a+1|0;if((n|0)>=256)break a;f=k[B>>2]|0;a=n;p=D}}}while(0);ne(k[c>>2]|0);k[c>>2]=0;h=1;r=b;return h|0}function Lc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0;d=m[a+26>>1]|0;a=ha(d,g)|0;if(!f)return;g=e>>>0>7;c=d+3|0;j=d+1|0;n=d+2|0;o=d<<1;p=o+3|0;q=o|1;r=o+2|0;s=d*3|0;t=s+3|0;u=s+1|0;v=s+2|0;w=d<<2;x=w|3;y=w|1;z=w|2;A=d*5|0;B=A+3|0;C=A+1|0;D=A+2|0;E=d*6|0;F=E+3|0;G=E|1;H=E+2|0;I=d*7|0;J=I+3|0;K=I+1|0;L=I+2|0;M=d<<3;N=e+-8|0;O=N&-8;P=N-O|0;N=O+8|0;O=ha(N,d)|0;Q=i;i=b;b=f;while(1){b=b+-1|0;if(g){f=Q+O|0;R=Q;S=i;T=e;while(1){U=(l[R+3>>0]|0)^255;V=((ha((l[R>>0]|0)^255,U)|0)>>>0)/255|0;W=((ha((l[R+1>>0]|0)^255,U)|0)>>>0)/255|0;X=V|W<<8|(((ha((l[R+2>>0]|0)^255,U)|0)>>>0)/255|0)<<16|-16777216;k[S>>2]=X;X=(l[R+c>>0]|0)^255;U=((ha((l[R+d>>0]|0)^255,X)|0)>>>0)/255|0;W=((ha((l[R+j>>0]|0)^255,X)|0)>>>0)/255|0;V=U|W<<8|(((ha((l[R+n>>0]|0)^255,X)|0)>>>0)/255|0)<<16|-16777216;k[S+4>>2]=V;V=(l[R+p>>0]|0)^255;X=((ha((l[R+o>>0]|0)^255,V)|0)>>>0)/255|0;W=((ha((l[R+q>>0]|0)^255,V)|0)>>>0)/255|0;U=X|W<<8|(((ha((l[R+r>>0]|0)^255,V)|0)>>>0)/255|0)<<16|-16777216;k[S+8>>2]=U;U=(l[R+t>>0]|0)^255;V=((ha((l[R+s>>0]|0)^255,U)|0)>>>0)/255|0;W=((ha((l[R+u>>0]|0)^255,U)|0)>>>0)/255|0;X=V|W<<8|(((ha((l[R+v>>0]|0)^255,U)|0)>>>0)/255|0)<<16|-16777216;k[S+12>>2]=X;X=(l[R+x>>0]|0)^255;U=((ha((l[R+w>>0]|0)^255,X)|0)>>>0)/255|0;W=((ha((l[R+y>>0]|0)^255,X)|0)>>>0)/255|0;V=U|W<<8|(((ha((l[R+z>>0]|0)^255,X)|0)>>>0)/255|0)<<16|-16777216;k[S+16>>2]=V;V=(l[R+B>>0]|0)^255;X=((ha((l[R+A>>0]|0)^255,V)|0)>>>0)/255|0;W=((ha((l[R+C>>0]|0)^255,V)|0)>>>0)/255|0;U=X|W<<8|(((ha((l[R+D>>0]|0)^255,V)|0)>>>0)/255|0)<<16|-16777216;k[S+20>>2]=U;U=(l[R+F>>0]|0)^255;V=((ha((l[R+E>>0]|0)^255,U)|0)>>>0)/255|0;W=((ha((l[R+G>>0]|0)^255,U)|0)>>>0)/255|0;X=V|W<<8|(((ha((l[R+H>>0]|0)^255,U)|0)>>>0)/255|0)<<16|-16777216;k[S+24>>2]=X;X=(l[R+J>>0]|0)^255;U=((ha((l[R+I>>0]|0)^255,X)|0)>>>0)/255|0;W=((ha((l[R+K>>0]|0)^255,X)|0)>>>0)/255|0;V=U|W<<8|(((ha((l[R+L>>0]|0)^255,X)|0)>>>0)/255|0)<<16|-16777216;k[S+28>>2]=V;T=T+-8|0;if(T>>>0<=7)break;else{R=R+M|0;S=S+32|0}}Y=i+(N<<2)|0;Z=f;_=P}else{Y=i;Z=Q;_=e}switch(_|0){case 1:{$=Y;aa=Z;ba=14;break}case 7:{S=(l[Z+3>>0]|0)^255;R=((ha((l[Z>>0]|0)^255,S)|0)>>>0)/255|0;T=R|(((ha((l[Z+1>>0]|0)^255,S)|0)>>>0)/255|0)<<8|(((ha((l[Z+2>>0]|0)^255,S)|0)>>>0)/255|0)<<16|-16777216;k[Y>>2]=T;ca=Y+4|0;da=Z+d|0;ba=9;break}case 6:{ca=Y;da=Z;ba=9;break}case 5:{ea=Y;fa=Z;ba=10;break}case 4:{ga=Y;ia=Z;ba=11;break}case 3:{ja=Y;ka=Z;ba=12;break}case 2:{la=Y;ma=Z;ba=13;break}default:{na=Y;oa=Z}}if((ba|0)==9){ba=0;T=(l[da+3>>0]|0)^255;S=((ha((l[da>>0]|0)^255,T)|0)>>>0)/255|0;R=((ha((l[da+1>>0]|0)^255,T)|0)>>>0)/255|0;V=S|R<<8|(((ha((l[da+2>>0]|0)^255,T)|0)>>>0)/255|0)<<16|-16777216;k[ca>>2]=V;ea=ca+4|0;fa=da+d|0;ba=10}if((ba|0)==10){ba=0;V=(l[fa+3>>0]|0)^255;T=((ha((l[fa>>0]|0)^255,V)|0)>>>0)/255|0;R=((ha((l[fa+1>>0]|0)^255,V)|0)>>>0)/255|0;S=T|R<<8|(((ha((l[fa+2>>0]|0)^255,V)|0)>>>0)/255|0)<<16|-16777216;k[ea>>2]=S;ga=ea+4|0;ia=fa+d|0;ba=11}if((ba|0)==11){ba=0;S=(l[ia+3>>0]|0)^255;V=((ha((l[ia>>0]|0)^255,S)|0)>>>0)/255|0;R=((ha((l[ia+1>>0]|0)^255,S)|0)>>>0)/255|0;T=V|R<<8|(((ha((l[ia+2>>0]|0)^255,S)|0)>>>0)/255|0)<<16|-16777216;k[ga>>2]=T;ja=ga+4|0;ka=ia+d|0;ba=12}if((ba|0)==12){ba=0;T=(l[ka+3>>0]|0)^255;S=((ha((l[ka>>0]|0)^255,T)|0)>>>0)/255|0;R=((ha((l[ka+1>>0]|0)^255,T)|0)>>>0)/255|0;V=S|R<<8|(((ha((l[ka+2>>0]|0)^255,T)|0)>>>0)/255|0)<<16|-16777216;k[ja>>2]=V;la=ja+4|0;ma=ka+d|0;ba=13}if((ba|0)==13){ba=0;V=(l[ma+3>>0]|0)^255;T=((ha((l[ma>>0]|0)^255,V)|0)>>>0)/255|0;R=((ha((l[ma+1>>0]|0)^255,V)|0)>>>0)/255|0;S=T|R<<8|(((ha((l[ma+2>>0]|0)^255,V)|0)>>>0)/255|0)<<16|-16777216;k[la>>2]=S;$=la+4|0;aa=ma+d|0;ba=14}if((ba|0)==14){ba=0;S=(l[aa+3>>0]|0)^255;V=((ha((l[aa>>0]|0)^255,S)|0)>>>0)/255|0;R=((ha((l[aa+1>>0]|0)^255,S)|0)>>>0)/255|0;T=V|R<<8|(((ha((l[aa+2>>0]|0)^255,S)|0)>>>0)/255|0)<<16|-16777216;k[$>>2]=T;na=$+4|0;oa=aa+d|0}if(!b)break;else{Q=oa+a|0;i=na+(h<<2)|0}}return}function Mc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;d=m[a+26>>1]|0;c=k[a+56>>2]|0;a=ha(d,g)|0;if(!f)return;g=(e|0)==0;j=ha(d,e)|0;n=b;b=i;i=f;while(1){i=i+-1|0;if(g){o=n;p=b}else{f=b+j|0;q=e;r=b;s=n;while(1){q=q+-1|0;t=(l[r+3>>0]|0)^255;u=((ha((l[r>>0]|0)^255,t)|0)>>>0)/255|0;v=((ha((l[r+1>>0]|0)^255,t)|0)>>>0)/255|0;w=((ha((l[r+2>>0]|0)^255,t)|0)>>>0)/255|0;k[s>>2]=l[c+u>>0]|0|(l[c+v>>0]|0)<<8|(l[c+w>>0]|0)<<16|-16777216;if(!q)break;else{r=r+d|0;s=s+4|0}}o=n+(e<<2)|0;p=f}if(!i)break;else{n=o+(h<<2)|0;b=p+a|0}}return}function Nc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,n=0,o=0,p=0,q=0,r=0,s=0;d=k[a+64>>2]|0;c=m[a+26>>1]|0;if(!f)return;a=(e|0)==0;j=ha(c,e)|0;n=b;b=i;i=f;while(1){i=i+-1|0;if(a){o=n;p=b}else{f=b+j|0;q=e;r=b;s=n;while(1){q=q+-1|0;k[s>>2]=k[k[d+((l[r>>0]|0)<<2)>>2]>>2];if(!q)break;else{r=r+c|0;s=s+4|0}}o=n+(e<<2)|0;p=f}if(!i)break;else{n=o+(h<<2)|0;b=p+g|0}}return}function Oc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;d=k[a+64>>2]|0;a=(g|0)/2|0;if(!f)return;g=e>>>0>1;c=e+-2|0;j=c>>>1;m=j<<1;n=c-m|0;c=m+2|0;m=j+1|0;j=b;b=i;i=f;while(1){i=i+-1|0;if(g){f=j+(c<<2)|0;o=b;p=j;q=e;while(1){r=k[d+((l[o>>0]|0)<<2)>>2]|0;k[p>>2]=k[r>>2];k[p+4>>2]=k[r+4>>2];q=q+-2|0;if(q>>>0<=1)break;else{o=o+1|0;p=p+8|0}}s=f;t=b+m|0;u=n}else{s=j;t=b;u=e}if(!u){v=s;w=t}else{k[s>>2]=k[k[d+((l[t>>0]|0)<<2)>>2]>>2];v=s+4|0;w=t+1|0}if(!i)break;else{j=v+(h<<2)|0;b=w+a|0}}return}function Pc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;d=k[a+64>>2]|0;a=(g|0)/4|0;if(!f)return;g=e>>>0>3;c=e+-4|0;j=c>>>2;m=j<<2;n=c-m|0;c=m+4|0;m=j+1|0;j=b;b=i;i=f;while(1){i=i+-1|0;if(g){f=j+(c<<2)|0;o=b;p=j;q=e;while(1){r=k[d+((l[o>>0]|0)<<2)>>2]|0;k[p>>2]=k[r>>2];k[p+4>>2]=k[r+4>>2];k[p+8>>2]=k[r+8>>2];k[p+12>>2]=k[r+12>>2];q=q+-4|0;if(q>>>0<=3)break;else{o=o+1|0;p=p+16|0}}s=f;t=b+m|0;u=n}else{s=j;t=b;u=e}a:do if(!u){v=t;w=s}else{p=t+1|0;o=k[d+((l[t>>0]|0)<<2)>>2]|0;switch(u|0){case 3:{k[s>>2]=k[o>>2];x=s+4|0;y=o+4|0;z=10;break}case 2:{x=s;y=o;z=10;break}case 1:{A=s;B=o;break}default:{v=p;w=s;break a}}if((z|0)==10){z=0;k[x>>2]=k[y>>2];A=x+4|0;B=y+4|0}k[A>>2]=k[B>>2];v=p;w=A+4|0}while(0);if(!i)break;else{j=w+(h<<2)|0;b=v+a|0}}return}function Qc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;d=k[a+64>>2]|0;a=(g|0)/8|0;if(!f)return;g=e>>>0>7;c=e+-8|0;j=c>>>3;m=j<<3;n=c-m|0;c=m+8|0;m=j+1|0;j=b;b=i;i=f;while(1){i=i+-1|0;if(g){f=j+(c<<2)|0;o=b;p=j;q=e;while(1){r=k[d+((l[o>>0]|0)<<2)>>2]|0;k[p>>2]=k[r>>2];k[p+4>>2]=k[r+4>>2];k[p+8>>2]=k[r+8>>2];k[p+12>>2]=k[r+12>>2];k[p+16>>2]=k[r+16>>2];k[p+20>>2]=k[r+20>>2];k[p+24>>2]=k[r+24>>2];k[p+28>>2]=k[r+28>>2];q=q+-8|0;if(q>>>0<=7)break;else{o=o+1|0;p=p+32|0}}s=f;t=b+m|0;u=n}else{s=j;t=b;u=e}a:do if(!u){v=t;w=s}else{p=t+1|0;o=k[d+((l[t>>0]|0)<<2)>>2]|0;switch(u|0){case 7:{k[s>>2]=k[o>>2];x=s+4|0;y=o+4|0;z=10;break}case 6:{x=s;y=o;z=10;break}case 5:{A=s;B=o;z=11;break}case 4:{C=s;D=o;z=12;break}case 3:{E=s;F=o;z=13;break}case 2:{G=s;H=o;z=14;break}case 1:{I=s;J=o;break}default:{v=p;w=s;break a}}if((z|0)==10){z=0;k[x>>2]=k[y>>2];A=x+4|0;B=y+4|0;z=11}if((z|0)==11){z=0;k[A>>2]=k[B>>2];C=A+4|0;D=B+4|0;z=12}if((z|0)==12){z=0;k[C>>2]=k[D>>2];E=C+4|0;F=D+4|0;z=13}if((z|0)==13){z=0;k[E>>2]=k[F>>2];G=E+4|0;H=F+4|0;z=14}if((z|0)==14){z=0;k[G>>2]=k[H>>2];I=G+4|0;J=H+4|0}k[I>>2]=k[J>>2];v=p;w=I+4|0}while(0);if(!i)break;else{j=w+(h<<2)|0;b=v+a|0}}return}function Rc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,l=0,n=0,o=0,p=0,q=0,r=0;d=m[a+26>>1]|0;c=k[a+60>>2]|0;if(!f)return;a=(e|0)==0;j=(ha(d,e)|0)<<1;l=b;b=i;i=f;while(1){i=i+-1|0;if(a){n=l;o=b}else{f=b+j|0;p=e;q=l;r=b;while(1){p=p+-1|0;k[q>>2]=k[k[c+((m[r>>1]|0)>>>8<<2)>>2]>>2];if(!p)break;else{q=q+4|0;r=r+(d<<1)|0}}n=l+(e<<2)|0;o=f}if(!i)break;else{l=n+(h<<2)|0;b=o+g|0}}return}function Sc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,n=0,o=0,p=0,q=0,r=0,s=0;d=m[a+26>>1]|0;c=k[a+60>>2]|0;if(!f)return;a=(e|0)==0;j=ha(d,e)|0;n=b;b=i;i=f;while(1){i=i+-1|0;if(a){o=n;p=b}else{f=b+j|0;q=e;r=b;s=n;while(1){q=q+-1|0;k[s>>2]=((l[r+1>>0]|0)<<24|16777215)&k[k[c+((l[r>>0]|0)<<2)>>2]>>2];if(!q)break;else{r=r+d|0;s=s+4|0}}o=n+(e<<2)|0;p=f}if(!i)break;else{n=o+(h<<2)|0;b=p+g|0}}return}function Tc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,n=0,o=0,p=0,q=0,r=0,s=0;d=m[a+26>>1]|0;c=k[a+60>>2]|0;if(!f)return;a=(e|0)==0;j=ha(d,e)|0;n=b;b=i;i=f;while(1){i=i+-1|0;if(a){o=n;p=b}else{f=b+j|0;q=e;r=b;s=n;while(1){q=q+-1|0;k[s>>2]=k[k[c+((l[r>>0]|0)<<2)>>2]>>2];if(!q)break;else{r=r+d|0;s=s+4|0}}o=n+(e<<2)|0;p=f}if(!i)break;else{n=o+(h<<2)|0;b=p+g|0}}return}function Uc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;d=k[a+60>>2]|0;a=(g|0)/2|0;if(!f)return;g=e>>>0>1;c=e+-2|0;j=c>>>1;m=j<<1;n=c-m|0;c=m+2|0;m=j+1|0;j=b;b=i;i=f;while(1){i=i+-1|0;if(g){f=j+(c<<2)|0;o=b;p=j;q=e;while(1){r=k[d+((l[o>>0]|0)<<2)>>2]|0;k[p>>2]=k[r>>2];k[p+4>>2]=k[r+4>>2];q=q+-2|0;if(q>>>0<=1)break;else{o=o+1|0;p=p+8|0}}s=f;t=b+m|0;u=n}else{s=j;t=b;u=e}if(!u){v=s;w=t}else{k[s>>2]=k[k[d+((l[t>>0]|0)<<2)>>2]>>2];v=s+4|0;w=t+1|0}if(!i)break;else{j=v+(h<<2)|0;b=w+a|0}}return}function Vc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;d=k[a+60>>2]|0;a=(g|0)/4|0;if(!f)return;g=e>>>0>3;c=e+-4|0;j=c>>>2;m=j<<2;n=c-m|0;c=m+4|0;m=j+1|0;j=b;b=i;i=f;while(1){i=i+-1|0;if(g){f=j+(c<<2)|0;o=b;p=j;q=e;while(1){r=k[d+((l[o>>0]|0)<<2)>>2]|0;k[p>>2]=k[r>>2];k[p+4>>2]=k[r+4>>2];k[p+8>>2]=k[r+8>>2];k[p+12>>2]=k[r+12>>2];q=q+-4|0;if(q>>>0<=3)break;else{o=o+1|0;p=p+16|0}}s=f;t=b+m|0;u=n}else{s=j;t=b;u=e}a:do if(!u){v=t;w=s}else{p=t+1|0;o=k[d+((l[t>>0]|0)<<2)>>2]|0;switch(u|0){case 3:{k[s>>2]=k[o>>2];x=s+4|0;y=o+4|0;z=10;break}case 2:{x=s;y=o;z=10;break}case 1:{A=s;B=o;break}default:{v=p;w=s;break a}}if((z|0)==10){z=0;k[x>>2]=k[y>>2];A=x+4|0;B=y+4|0}k[A>>2]=k[B>>2];v=p;w=A+4|0}while(0);if(!i)break;else{j=w+(h<<2)|0;b=v+a|0}}return}function Wc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;d=k[a+60>>2]|0;a=(g|0)/8|0;if(!f)return;g=e>>>0>7;c=e+-8|0;j=c>>>3;m=j<<3;n=c-m|0;c=m+8|0;m=j+1|0;j=b;b=i;i=f;while(1){i=i+-1|0;if(g){f=j+(c<<2)|0;o=b;p=j;q=e;while(1){r=k[d+((l[o>>0]|0)<<2)>>2]|0;k[p>>2]=k[r>>2];k[p+4>>2]=k[r+4>>2];k[p+8>>2]=k[r+8>>2];k[p+12>>2]=k[r+12>>2];k[p+16>>2]=k[r+16>>2];k[p+20>>2]=k[r+20>>2];k[p+24>>2]=k[r+24>>2];k[p+28>>2]=k[r+28>>2];q=q+-8|0;if(q>>>0<=7)break;else{o=o+1|0;p=p+32|0}}s=f;t=b+m|0;u=n}else{s=j;t=b;u=e}a:do if(!u){v=t;w=s}else{p=t+1|0;o=k[d+((l[t>>0]|0)<<2)>>2]|0;switch(u|0){case 7:{k[s>>2]=k[o>>2];x=s+4|0;y=o+4|0;z=10;break}case 6:{x=s;y=o;z=10;break}case 5:{A=s;B=o;z=11;break}case 4:{C=s;D=o;z=12;break}case 3:{E=s;F=o;z=13;break}case 2:{G=s;H=o;z=14;break}case 1:{I=s;J=o;break}default:{v=p;w=s;break a}}if((z|0)==10){z=0;k[x>>2]=k[y>>2];A=x+4|0;B=y+4|0;z=11}if((z|0)==11){z=0;k[A>>2]=k[B>>2];C=A+4|0;D=B+4|0;z=12}if((z|0)==12){z=0;k[C>>2]=k[D>>2];E=C+4|0;F=D+4|0;z=13}if((z|0)==13){z=0;k[E>>2]=k[F>>2];G=E+4|0;H=F+4|0;z=14}if((z|0)==14){z=0;k[G>>2]=k[H>>2];I=G+4|0;J=H+4|0}k[I>>2]=k[J>>2];v=p;w=I+4|0}while(0);if(!i)break;else{j=w+(h<<2)|0;b=v+a|0}}return}function Xc(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;b=r;r=r+32|0;c=b+16|0;d=b+8|0;e=b;f=b+24|0;g=b+20|0;h=a+68|0;if((k[h>>2]|0)==0?(i=me(6168)|0,k[h>>2]=i,(i|0)==0):0){vc(k[(k[a>>2]|0)+628>>2]|0,136962,136982,e);j=0;r=b;return j|0}e=k[a>>2]|0;k[d>>2]=f;Ge(e,529,d)|0;d=k[a>>2]|0;k[c>>2]=g;Ge(d,532,c)|0;j=(Le(k[h>>2]|0,k[f>>2]|0,k[g>>2]|0)|0)>>>31^1;r=b;return j|0}function Yc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0;d=r;r=r+384|0;c=d+380|0;j=d+376|0;m=d+372|0;n=d+368|0;o=d+364|0;p=d+360|0;q=d+356|0;s=d+352|0;t=d+348|0;u=d+344|0;v=d+340|0;w=d+336|0;x=d+332|0;y=d+328|0;z=d+324|0;A=d+320|0;B=d+316|0;C=d+312|0;D=d+308|0;E=d+304|0;F=d+300|0;G=d+296|0;H=d+292|0;I=d+288|0;J=d+284|0;K=d+280|0;L=d+276|0;M=d+272|0;N=d+268|0;O=d+264|0;P=d+260|0;Q=d+256|0;R=d+252|0;S=d+248|0;T=d+244|0;U=d+240|0;V=d+236|0;W=d+232|0;X=d+228|0;Y=d+224|0;Z=d+220|0;_=d+216|0;$=d+212|0;aa=d+208|0;ba=d+204|0;ca=d+200|0;da=d+196|0;ea=d+192|0;fa=d+188|0;ga=d+184|0;ha=d+180|0;ia=d+176|0;ja=d+172|0;ka=d+168|0;la=d+164|0;ma=d+160|0;na=d+156|0;oa=d+152|0;pa=d+148|0;qa=d+144|0;ra=d+140|0;sa=d+136|0;ta=d+132|0;ua=d+128|0;va=d+124|0;wa=d+120|0;xa=d+116|0;ya=d+112|0;za=d+108|0;Aa=d+104|0;Ba=d+100|0;Ca=d+96|0;Da=d+92|0;Ea=d+88|0;Fa=d+84|0;Ga=d+80|0;Ha=d+76|0;Ia=d+72|0;Ja=d+68|0;Ka=d+64|0;La=d+60|0;Ma=d+56|0;Na=d+52|0;Oa=d+48|0;Pa=d+44|0;Qa=d+40|0;Ra=d+36|0;Sa=d+32|0;Ta=d+28|0;Ua=d+24|0;Va=d+20|0;Wa=d+16|0;Xa=d+12|0;Ya=d+8|0;Za=d+4|0;_a=d;$a=h+e|0;ab=b+($a<<2)|0;bb=b+($a<<1<<2)|0;cb=b+($a*3<<2)|0;$a=(h<<2)+(e*3|0)|0;h=(g*18|0)/4|0;if(!((f|e)&3)){if(f>>>0<=3){r=d;return}g=e>>>2;db=a+68|0;eb=g<<2;fb=eb+$a|0;gb=eb+$a|0;hb=eb+$a|0;ib=eb+$a|0;eb=(g*18|0)+h|0;jb=b;kb=f;lb=i;mb=ab;nb=bb;ob=cb;while(1){pb=g;qb=jb;rb=lb;sb=mb;tb=nb;ub=ob;while(1){vb=l[rb+16>>0]|0;wb=l[rb+17>>0]|0;Ke(k[db>>2]|0,l[rb>>0]|0,vb,wb,c,j,m);k[qb>>2]=k[c>>2]|k[j>>2]<<8|k[m>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+1>>0]|0,vb,wb,n,o,p);k[qb+4>>2]=k[n>>2]|k[o>>2]<<8|k[p>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+2>>0]|0,vb,wb,q,s,t);k[qb+8>>2]=k[q>>2]|k[s>>2]<<8|k[t>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+3>>0]|0,vb,wb,u,v,w);k[qb+12>>2]=k[u>>2]|k[v>>2]<<8|k[w>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+4>>0]|0,vb,wb,x,y,z);k[sb>>2]=k[x>>2]|k[y>>2]<<8|k[z>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+5>>0]|0,vb,wb,A,B,C);k[sb+4>>2]=k[A>>2]|k[B>>2]<<8|k[C>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+6>>0]|0,vb,wb,D,E,F);k[sb+8>>2]=k[D>>2]|k[E>>2]<<8|k[F>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+7>>0]|0,vb,wb,G,H,I);k[sb+12>>2]=k[G>>2]|k[H>>2]<<8|k[I>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+8>>0]|0,vb,wb,J,K,L);k[tb>>2]=k[J>>2]|k[K>>2]<<8|k[L>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+9>>0]|0,vb,wb,M,N,O);k[tb+4>>2]=k[M>>2]|k[N>>2]<<8|k[O>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+10>>0]|0,vb,wb,P,Q,R);k[tb+8>>2]=k[P>>2]|k[Q>>2]<<8|k[R>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+11>>0]|0,vb,wb,S,T,U);k[tb+12>>2]=k[S>>2]|k[T>>2]<<8|k[U>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+12>>0]|0,vb,wb,V,W,X);k[ub>>2]=k[V>>2]|k[W>>2]<<8|k[X>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+13>>0]|0,vb,wb,Y,Z,_);k[ub+4>>2]=k[Y>>2]|k[Z>>2]<<8|k[_>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+14>>0]|0,vb,wb,$,aa,ba);k[ub+8>>2]=k[$>>2]|k[aa>>2]<<8|k[ba>>2]<<16|-16777216;Ke(k[db>>2]|0,l[rb+15>>0]|0,vb,wb,ca,da,ea);k[ub+12>>2]=k[ca>>2]|k[da>>2]<<8|k[ea>>2]<<16|-16777216;pb=pb+-1|0;if(!pb)break;else{qb=qb+16|0;rb=rb+18|0;sb=sb+16|0;tb=tb+16|0;ub=ub+16|0}}kb=kb+-4|0;if(kb>>>0<=3)break;else{jb=jb+(fb<<2)|0;lb=lb+eb|0;mb=mb+(gb<<2)|0;nb=nb+(hb<<2)|0;ob=ob+(ib<<2)|0}}r=d;return}if(!f){r=d;return}ib=(e|0)==0;ob=a+68|0;a=f;f=b;b=i;i=ab;ab=bb;bb=cb;while(1){a:do if(ib){xb=f;yb=b;zb=i;Ab=ab;Bb=bb}else{cb=e;hb=f;nb=b;gb=i;mb=ab;eb=bb;while(1){lb=l[nb+16>>0]|0;fb=l[nb+17>>0]|0;switch(cb|0){case 3:{Cb=16;break}case 2:{Cb=21;break}case 1:break;default:{switch(a|0){case 3:{Cb=13;break}case 2:{Cb=14;break}case 1:break;default:{Ke(k[ob>>2]|0,l[nb+15>>0]|0,lb,fb,fa,ga,ha);k[eb+12>>2]=k[fa>>2]|k[ga>>2]<<8|k[ha>>2]<<16|-16777216;Cb=13}}if((Cb|0)==13){Cb=0;Ke(k[ob>>2]|0,l[nb+11>>0]|0,lb,fb,ia,ja,ka);k[mb+12>>2]=k[ia>>2]|k[ja>>2]<<8|k[ka>>2]<<16|-16777216;Cb=14}if((Cb|0)==14){Cb=0;Ke(k[ob>>2]|0,l[nb+7>>0]|0,lb,fb,la,ma,na);k[gb+12>>2]=k[la>>2]|k[ma>>2]<<8|k[na>>2]<<16|-16777216}Ke(k[ob>>2]|0,l[nb+3>>0]|0,lb,fb,oa,pa,qa);k[hb+12>>2]=k[oa>>2]|k[pa>>2]<<8|k[qa>>2]<<16|-16777216;Cb=16}}if((Cb|0)==16){Cb=0;switch(a|0){case 3:{Cb=18;break}case 2:{Cb=19;break}case 1:break;default:{Ke(k[ob>>2]|0,l[nb+14>>0]|0,lb,fb,ra,sa,ta);k[eb+8>>2]=k[ra>>2]|k[sa>>2]<<8|k[ta>>2]<<16|-16777216;Cb=18}}if((Cb|0)==18){Cb=0;Ke(k[ob>>2]|0,l[nb+10>>0]|0,lb,fb,ua,va,wa);k[mb+8>>2]=k[ua>>2]|k[va>>2]<<8|k[wa>>2]<<16|-16777216;Cb=19}if((Cb|0)==19){Cb=0;Ke(k[ob>>2]|0,l[nb+6>>0]|0,lb,fb,xa,ya,za);k[gb+8>>2]=k[xa>>2]|k[ya>>2]<<8|k[za>>2]<<16|-16777216}Ke(k[ob>>2]|0,l[nb+2>>0]|0,lb,fb,Aa,Ba,Ca);k[hb+8>>2]=k[Aa>>2]|k[Ba>>2]<<8|k[Ca>>2]<<16|-16777216;Cb=21}if((Cb|0)==21){Cb=0;switch(a|0){case 3:{Cb=23;break}case 2:{Cb=24;break}case 1:break;default:{Ke(k[ob>>2]|0,l[nb+13>>0]|0,lb,fb,Da,Ea,Fa);k[eb+4>>2]=k[Da>>2]|k[Ea>>2]<<8|k[Fa>>2]<<16|-16777216;Cb=23}}if((Cb|0)==23){Cb=0;Ke(k[ob>>2]|0,l[nb+9>>0]|0,lb,fb,Ga,Ha,Ia);k[mb+4>>2]=k[Ga>>2]|k[Ha>>2]<<8|k[Ia>>2]<<16|-16777216;Cb=24}if((Cb|0)==24){Cb=0;Ke(k[ob>>2]|0,l[nb+5>>0]|0,lb,fb,Ja,Ka,La);k[gb+4>>2]=k[Ja>>2]|k[Ka>>2]<<8|k[La>>2]<<16|-16777216}Ke(k[ob>>2]|0,l[nb+1>>0]|0,lb,fb,Ma,Na,Oa);k[hb+4>>2]=k[Ma>>2]|k[Na>>2]<<8|k[Oa>>2]<<16|-16777216}switch(a|0){case 3:{Cb=28;break}case 2:{Cb=29;break}case 1:break;default:{Ke(k[ob>>2]|0,l[nb+12>>0]|0,lb,fb,Pa,Qa,Ra);k[eb>>2]=k[Pa>>2]|k[Qa>>2]<<8|k[Ra>>2]<<16|-16777216;Cb=28}}if((Cb|0)==28){Cb=0;Ke(k[ob>>2]|0,l[nb+8>>0]|0,lb,fb,Sa,Ta,Ua);k[mb>>2]=k[Sa>>2]|k[Ta>>2]<<8|k[Ua>>2]<<16|-16777216;Cb=29}if((Cb|0)==29){Cb=0;Ke(k[ob>>2]|0,l[nb+4>>0]|0,lb,fb,Va,Wa,Xa);k[gb>>2]=k[Va>>2]|k[Wa>>2]<<8|k[Xa>>2]<<16|-16777216}Ke(k[ob>>2]|0,l[nb>>0]|0,lb,fb,Ya,Za,_a);k[hb>>2]=k[Ya>>2]|k[Za>>2]<<8|k[_a>>2]<<16|-16777216;if(cb>>>0<4){Db=cb;Eb=hb;Fb=nb;Gb=gb;Hb=mb;Ib=eb;break}fb=hb+16|0;lb=gb+16|0;jb=mb+16|0;kb=eb+16|0;cb=cb+-4|0;ea=nb+18|0;if(!cb){xb=fb;yb=ea;zb=lb;Ab=jb;Bb=kb;break a}else{hb=fb;nb=ea;gb=lb;mb=jb;eb=kb}}xb=Eb+(Db<<2)|0;yb=Fb+18|0;zb=Gb+(Db<<2)|0;Ab=Hb+(Db<<2)|0;Bb=Ib+(Db<<2)|0}while(0);if(a>>>0<5){Cb=35;break}a=a+-4|0;if(!a){Cb=35;break}else{f=xb+($a<<2)|0;b=yb+h|0;i=zb+($a<<2)|0;ab=Ab+($a<<2)|0;bb=Bb+($a<<2)|0}}if((Cb|0)==35){r=d;return}}function Zc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0;d=r;r=r+192|0;c=d+188|0;j=d+184|0;m=d+180|0;n=d+176|0;o=d+172|0;p=d+168|0;q=d+164|0;s=d+160|0;t=d+156|0;u=d+152|0;v=d+148|0;w=d+144|0;x=d+140|0;y=d+136|0;z=d+132|0;A=d+128|0;B=d+124|0;C=d+120|0;D=d+116|0;E=d+112|0;F=d+108|0;G=d+104|0;H=d+100|0;I=d+96|0;J=d+92|0;K=d+88|0;L=d+84|0;M=d+80|0;N=d+76|0;O=d+72|0;P=d+68|0;Q=d+64|0;R=d+60|0;S=d+56|0;T=d+52|0;U=d+48|0;V=d+44|0;W=d+40|0;X=d+36|0;Y=d+32|0;Z=d+28|0;_=d+24|0;$=d+20|0;aa=d+16|0;ba=d+12|0;ca=d+8|0;da=d+4|0;ea=d;fa=b+(h+e<<2)|0;ga=(h<<1)+e|0;h=(g*10|0)/4|0;if(!(f&1|e&3)){if(f>>>0<=1){r=d;return}g=e>>>2;ha=a+68|0;ia=g<<2;ja=ia+ga|0;ka=ia+ga|0;ia=(g*10|0)+h|0;la=b;ma=f;na=i;oa=fa;while(1){pa=g;qa=la;ra=na;sa=oa;while(1){ta=l[ra+8>>0]|0;ua=l[ra+9>>0]|0;Ke(k[ha>>2]|0,l[ra>>0]|0,ta,ua,c,j,m);k[qa>>2]=k[c>>2]|k[j>>2]<<8|k[m>>2]<<16|-16777216;Ke(k[ha>>2]|0,l[ra+1>>0]|0,ta,ua,n,o,p);k[qa+4>>2]=k[n>>2]|k[o>>2]<<8|k[p>>2]<<16|-16777216;Ke(k[ha>>2]|0,l[ra+2>>0]|0,ta,ua,q,s,t);k[qa+8>>2]=k[q>>2]|k[s>>2]<<8|k[t>>2]<<16|-16777216;Ke(k[ha>>2]|0,l[ra+3>>0]|0,ta,ua,u,v,w);k[qa+12>>2]=k[u>>2]|k[v>>2]<<8|k[w>>2]<<16|-16777216;Ke(k[ha>>2]|0,l[ra+4>>0]|0,ta,ua,x,y,z);k[sa>>2]=k[x>>2]|k[y>>2]<<8|k[z>>2]<<16|-16777216;Ke(k[ha>>2]|0,l[ra+5>>0]|0,ta,ua,A,B,C);k[sa+4>>2]=k[A>>2]|k[B>>2]<<8|k[C>>2]<<16|-16777216;Ke(k[ha>>2]|0,l[ra+6>>0]|0,ta,ua,D,E,F);k[sa+8>>2]=k[D>>2]|k[E>>2]<<8|k[F>>2]<<16|-16777216;Ke(k[ha>>2]|0,l[ra+7>>0]|0,ta,ua,G,H,I);k[sa+12>>2]=k[G>>2]|k[H>>2]<<8|k[I>>2]<<16|-16777216;pa=pa+-1|0;if(!pa)break;else{qa=qa+16|0;ra=ra+10|0;sa=sa+16|0}}ma=ma+-2|0;if(ma>>>0<=1)break;else{la=la+(ja<<2)|0;na=na+ia|0;oa=oa+(ka<<2)|0}}r=d;return}if(!f){r=d;return}ka=(e|0)==0;oa=a+68|0;a=f;f=i;i=b;b=fa;while(1){a:do if(ka){va=i;wa=f;xa=b}else{fa=(a|0)==1;ia=e;na=f;ja=i;la=b;while(1){ma=l[na+8>>0]|0;I=l[na+9>>0]|0;switch(ia|0){case 3:{ya=15;break}case 2:{ya=18;break}case 1:break;default:{if(!fa){Ke(k[oa>>2]|0,l[na+7>>0]|0,ma,I,J,K,L);k[la+12>>2]=k[J>>2]|k[K>>2]<<8|k[L>>2]<<16|-16777216}Ke(k[oa>>2]|0,l[na+3>>0]|0,ma,I,M,N,O);k[ja+12>>2]=k[M>>2]|k[N>>2]<<8|k[O>>2]<<16|-16777216;ya=15}}if((ya|0)==15){ya=0;if(!fa){Ke(k[oa>>2]|0,l[na+6>>0]|0,ma,I,P,Q,R);k[la+8>>2]=k[P>>2]|k[Q>>2]<<8|k[R>>2]<<16|-16777216}Ke(k[oa>>2]|0,l[na+2>>0]|0,ma,I,S,T,U);k[ja+8>>2]=k[S>>2]|k[T>>2]<<8|k[U>>2]<<16|-16777216;ya=18}if((ya|0)==18){ya=0;if(!fa){Ke(k[oa>>2]|0,l[na+5>>0]|0,ma,I,V,W,X);k[la+4>>2]=k[V>>2]|k[W>>2]<<8|k[X>>2]<<16|-16777216}Ke(k[oa>>2]|0,l[na+1>>0]|0,ma,I,Y,Z,_);k[ja+4>>2]=k[Y>>2]|k[Z>>2]<<8|k[_>>2]<<16|-16777216}if(!fa){Ke(k[oa>>2]|0,l[na+4>>0]|0,ma,I,$,aa,ba);k[la>>2]=k[$>>2]|k[aa>>2]<<8|k[ba>>2]<<16|-16777216}Ke(k[oa>>2]|0,l[na>>0]|0,ma,I,ca,da,ea);k[ja>>2]=k[ca>>2]|k[da>>2]<<8|k[ea>>2]<<16|-16777216;I=ia>>>0<4;ma=I?la+(ia<<2)|0:la+16|0;H=I?ja+(ia<<2)|0:ja+16|0;G=na+10|0;ia=I?0:ia+-4|0;if(!ia){va=H;wa=G;xa=ma;break a}else{na=G;ja=H;la=ma}}}while(0);if(a>>>0<3){ya=26;break}a=a+-2|0;if(!a){ya=26;break}else{f=wa+h|0;i=va+(ga<<2)|0;b=xa+(ga<<2)|0}}if((ya|0)==26){r=d;return}}function _c(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;d=r;r=r+96|0;c=d+80|0;j=d+76|0;m=d+72|0;n=d+68|0;o=d+64|0;p=d+60|0;q=d+56|0;s=d+52|0;t=d+48|0;u=d+44|0;v=d+40|0;w=d+36|0;x=d+32|0;y=d+28|0;z=d+24|0;A=d+20|0;B=d+16|0;C=d+12|0;D=d+8|0;E=d+4|0;F=d;G=e>>>2;H=(G|0)==0;I=e&3;e=(I|0)==0;J=a+68|0;a=G*6|0;K=G<<2;L=b;b=f;f=i;while(1){if(H){M=L;N=f}else{i=f+a|0;O=G;P=L;Q=f;while(1){R=l[Q+4>>0]|0;S=l[Q+5>>0]|0;Ke(k[J>>2]|0,l[Q>>0]|0,R,S,c,j,m);k[P>>2]=k[c>>2]|k[j>>2]<<8|k[m>>2]<<16|-16777216;Ke(k[J>>2]|0,l[Q+1>>0]|0,R,S,n,o,p);k[P+4>>2]=k[n>>2]|k[o>>2]<<8|k[p>>2]<<16|-16777216;Ke(k[J>>2]|0,l[Q+2>>0]|0,R,S,q,s,t);k[P+8>>2]=k[q>>2]|k[s>>2]<<8|k[t>>2]<<16|-16777216;Ke(k[J>>2]|0,l[Q+3>>0]|0,R,S,u,v,w);k[P+12>>2]=k[u>>2]|k[v>>2]<<8|k[w>>2]<<16|-16777216;O=O+-1|0;if(!O)break;else{P=P+16|0;Q=Q+6|0}}M=L+(K<<2)|0;N=i}if(e){T=M;U=N}else{Q=l[N+4>>0]|0;P=l[N+5>>0]|0;switch(I|0){case 3:{Ke(k[J>>2]|0,l[N+2>>0]|0,Q,P,x,y,z);k[M+8>>2]=k[x>>2]|k[y>>2]<<8|k[z>>2]<<16|-16777216;V=9;break}case 2:{V=9;break}case 1:{V=10;break}default:{}}if((V|0)==9){V=0;Ke(k[J>>2]|0,l[N+1>>0]|0,Q,P,A,B,C);k[M+4>>2]=k[A>>2]|k[B>>2]<<8|k[C>>2]<<16|-16777216;V=10}if((V|0)==10){V=0;Ke(k[J>>2]|0,l[N>>0]|0,Q,P,D,E,F);k[M>>2]=k[D>>2]|k[E>>2]<<8|k[F>>2]<<16|-16777216}T=M+(I<<2)|0;U=N+6|0}b=b+-1|0;if(!b)break;else{L=T+(h<<2)|0;f=U+g|0}}r=d;return}function $c(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0;d=r;r=r+112|0;c=d+104|0;j=d+100|0;m=d+96|0;n=d+92|0;o=d+88|0;p=d+84|0;q=d+80|0;s=d+76|0;t=d+72|0;u=d+68|0;v=d+64|0;w=d+60|0;x=d+56|0;y=d+52|0;z=d+48|0;A=d+44|0;B=d+40|0;C=d+36|0;D=d+32|0;E=d+28|0;F=d+24|0;G=d+20|0;H=d+16|0;I=d+12|0;J=d+8|0;K=d+4|0;L=d;M=(h<<1)+e|0;N=((g|0)/2|0)*6|0;if(f>>>0>1){g=e>>>0>1;O=a+68|0;P=e+-2|0;Q=P>>>1;R=Q<<1;S=P-R|0;P=(Q*6|0)+6|0;Q=R+2|0;R=b;T=f;U=i;V=b+(h+e<<2)|0;while(1){if(g){h=V+(Q<<2)|0;W=e;X=R;Y=U;Z=V;while(1){_=l[Y+4>>0]|0;$=l[Y+5>>0]|0;Ke(k[O>>2]|0,l[Y>>0]|0,_,$,c,j,m);k[X>>2]=k[c>>2]|k[j>>2]<<8|k[m>>2]<<16|-16777216;Ke(k[O>>2]|0,l[Y+1>>0]|0,_,$,n,o,p);k[X+4>>2]=k[n>>2]|k[o>>2]<<8|k[p>>2]<<16|-16777216;Ke(k[O>>2]|0,l[Y+2>>0]|0,_,$,q,s,t);k[Z>>2]=k[q>>2]|k[s>>2]<<8|k[t>>2]<<16|-16777216;Ke(k[O>>2]|0,l[Y+3>>0]|0,_,$,u,v,w);k[Z+4>>2]=k[u>>2]|k[v>>2]<<8|k[w>>2]<<16|-16777216;W=W+-2|0;if(W>>>0<=1)break;else{X=X+8|0;Y=Y+6|0;Z=Z+8|0}}aa=S;ba=R+(Q<<2)|0;ca=U+P|0;da=h}else{aa=e;ba=R;ca=U;da=V}if((aa|0)==1){Z=l[ca+4>>0]|0;Y=l[ca+5>>0]|0;Ke(k[O>>2]|0,l[ca>>0]|0,Z,Y,x,y,z);k[ba>>2]=k[x>>2]|k[y>>2]<<8|k[z>>2]<<16|-16777216;Ke(k[O>>2]|0,l[ca+2>>0]|0,Z,Y,A,B,C);k[da>>2]=k[A>>2]|k[B>>2]<<8|k[C>>2]<<16|-16777216;ea=ba+4|0;fa=ca+6|0;ga=da+4|0}else{ea=ba;fa=ca;ga=da}Y=ea+(M<<2)|0;Z=fa+N|0;T=T+-2|0;if(T>>>0<=1){ha=Y;ia=Z;break}else{R=Y;U=Z;V=ga+(M<<2)|0}}ja=ha;ka=f&1;la=ia}else{ja=b;ka=f;la=i}if((ka|0)!=1){r=d;return}if(e>>>0>1){ka=a+68|0;i=e+-2|0;f=i>>>1;b=f<<1;ia=(f*6|0)+6|0;f=b+2|0;ha=e;M=ja;ga=la;while(1){V=l[ga+4>>0]|0;U=l[ga+5>>0]|0;Ke(k[ka>>2]|0,l[ga>>0]|0,V,U,D,E,F);k[M>>2]=k[D>>2]|k[E>>2]<<8|k[F>>2]<<16|-16777216;Ke(k[ka>>2]|0,l[ga+1>>0]|0,V,U,G,H,I);k[M+4>>2]=k[G>>2]|k[H>>2]<<8|k[I>>2]<<16|-16777216;ha=ha+-2|0;if(ha>>>0<=1)break;else{M=M+8|0;ga=ga+6|0}}ma=i-b|0;na=ja+(f<<2)|0;oa=la+ia|0}else{ma=e;na=ja;oa=la}if((ma|0)!=1){r=d;return}Ke(k[a+68>>2]|0,l[oa>>0]|0,l[oa+4>>0]|0,l[oa+5>>0]|0,J,K,L);k[na>>2]=k[J>>2]|k[K>>2]<<8|k[L>>2]<<16|-16777216;r=d;return}function ad(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;d=r;r=r+48|0;c=d+32|0;j=d+28|0;m=d+24|0;n=d+20|0;o=d+16|0;p=d+12|0;q=d+8|0;s=d+4|0;t=d;u=g<<1;g=e>>>1;v=(g|0)==0;w=(e&1|0)==0;e=a+68|0;a=g<<2;x=g<<1;y=b;b=f;f=i;while(1){if(v){z=y;A=f}else{i=f+a|0;B=g;C=f;D=y;while(1){E=l[C+2>>0]|0;F=l[C+3>>0]|0;Ke(k[e>>2]|0,l[C>>0]|0,E,F,c,j,m);k[D>>2]=k[c>>2]|k[j>>2]<<8|k[m>>2]<<16|-16777216;Ke(k[e>>2]|0,l[C+1>>0]|0,E,F,n,o,p);k[D+4>>2]=k[n>>2]|k[o>>2]<<8|k[p>>2]<<16|-16777216;B=B+-1|0;if(!B)break;else{C=C+4|0;D=D+8|0}}z=y+(x<<2)|0;A=i}if(w){G=z;H=A}else{Ke(k[e>>2]|0,l[A>>0]|0,l[A+2>>0]|0,l[A+3>>0]|0,q,s,t);k[z>>2]=k[q>>2]|k[s>>2]<<8|k[t>>2]<<16|-16777216;G=z+4|0;H=A+4|0}b=b+-1|0;if(!b)break;else{y=G+(h<<2)|0;f=H+u|0}}r=d;return}function bd(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0;d=r;r=r+48|0;c=d+32|0;j=d+28|0;m=d+24|0;n=d+20|0;o=d+16|0;p=d+12|0;q=d+8|0;s=d+4|0;t=d;if(f>>>0>1){u=h+e|0;v=(g|0)/2|0;g=a+68|0;w=e+1+(h<<1)|0;x=e+-1|0;y=e<<2;z=f+-2|0;A=z>>>1;B=A<<1;C=v<<2;D=(ha(A,C+y|0)|0)+C+y|0;C=(ha(A,u)|0)+h+e<<1;h=x+w|0;A=x+w|0;w=y+(v<<2)|0;v=b;y=f;x=i;E=b+(u<<2)|0;while(1){u=e;F=v;G=x;H=E;while(1){I=l[G+2>>0]|0;J=l[G+3>>0]|0;Ke(k[g>>2]|0,l[G>>0]|0,I,J,c,j,m);k[F>>2]=k[c>>2]|k[j>>2]<<8|k[m>>2]<<16|-16777216;Ke(k[g>>2]|0,l[G+1>>0]|0,I,J,n,o,p);k[H>>2]=k[n>>2]|k[o>>2]<<8|k[p>>2]<<16|-16777216;u=u+-1|0;if(!u)break;else{F=F+4|0;G=G+4|0;H=H+4|0}}y=y+-2|0;if(y>>>0<=1)break;else{v=v+(h<<2)|0;x=x+w|0;E=E+(A<<2)|0}}K=b+(C<<2)|0;L=z-B|0;M=i+D|0}else{K=b;L=f;M=i}if((L|0)!=1){r=d;return}L=a+68|0;a=e;e=K;K=M;while(1){Ke(k[L>>2]|0,l[K>>0]|0,l[K+2>>0]|0,l[K+3>>0]|0,q,s,t);k[e>>2]=k[q>>2]|k[s>>2]<<8|k[t>>2]<<16|-16777216;a=a+-1|0;if(!a)break;else{e=e+4|0;K=K+4|0}}r=d;return}function cd(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,m=0,n=0,o=0,p=0;d=r;r=r+16|0;c=d+8|0;j=d+4|0;m=d;n=a+68|0;a=e+h|0;h=(e+g|0)*3|0;g=b;b=i;i=f;while(1){f=e;o=g;p=b;while(1){Ke(k[n>>2]|0,l[p>>0]|0,l[p+1>>0]|0,l[p+2>>0]|0,c,j,m);k[o>>2]=k[c>>2]|k[j>>2]<<8|k[m>>2]<<16|-16777216;f=f+-1|0;if(!f)break;else{o=o+4|0;p=p+3|0}}i=i+-1|0;if(!i)break;else{g=g+(a<<2)|0;b=b+h|0}}r=d;return}function dd(a,b,c,d,e,f,g,h,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var m=0,n=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;d=r;r=r+32|0;c=d+20|0;m=d+16|0;n=d+12|0;p=d+8|0;q=d+4|0;s=d;t=g*3|0;if(!f){r=d;return}g=(e|0)==0;u=a+72|0;a=e*3|0;v=j;j=b;b=f;while(1){b=b+-1|0;if(g){w=v;x=j}else{f=v+a|0;y=e;z=j;A=v;while(1){y=y+-1|0;He(k[u>>2]|0,l[A>>0]|0,i[A+1>>0]|0,i[A+2>>0]|0,c,m,n);Ie(k[u>>2]|0,+o[c>>2],+o[m>>2],+o[n>>2],p,q,s);k[z>>2]=k[p>>2]|k[q>>2]<<8|k[s>>2]<<16|-16777216;if(!y)break;else{z=z+4|0;A=A+3|0}}w=f;x=j+(e<<2)|0}if(!b)break;else{v=w+t|0;j=x+(h<<2)|0}}r=d;return}function ed(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;e=r;r=r+48|0;f=e+24|0;g=e+16|0;h=e+8|0;i=e;l=e+32|0;n=e+28|0;o=k[a>>2]|0;p=k[a+52>>2]|0;q=k[a+12>>2]|0;s=ge(o)|0;if((s|0)!=0?(t=(q|0)!=0,q=ha(t?4:3,s)|0,(q|0)!=0):0){u=me(q)|0;if(!u){v=k[o+628>>2]|0;w=qd(o)|0;k[h>>2]=136922;vc(v,w,154321,h);x=0;r=e;return x|0}pe(u,0,q);q=u+s|0;h=u+(s<<1)|0;w=t?u+(s*3|0)|0:0;k[g>>2]=l;Pb(o,322,g)|0;k[f>>2]=n;Pb(o,323,f)|0;a:do switch(m[a+28>>1]|0){case 5:case 1:{switch(j[a+30>>1]|0){case 6:case 2:{y=2;z=20;break a;break}case 7:case 3:{A=3;z=19;break a;break}case 8:case 4:{A=1;z=19;break a;break}default:{y=0;z=20;break a}}break}case 6:case 2:{switch(j[a+30>>1]|0){case 5:case 1:{y=2;z=20;break a;break}case 7:case 3:{A=1;z=19;break a;break}case 8:case 4:{A=3;z=19;break a;break}default:{y=0;z=20;break a}}break}case 7:case 3:{switch(j[a+30>>1]|0){case 5:case 1:{A=3;z=19;break a;break}case 8:case 4:{y=2;z=20;break a;break}case 6:case 2:{A=1;z=19;break a;break}default:{y=0;z=20;break a}}break}case 8:case 4:{switch(j[a+30>>1]|0){case 5:case 1:{A=1;z=19;break a;break}case 7:case 3:{y=2;z=20;break a;break}case 6:case 2:{A=3;z=19;break a;break}default:{y=0;z=20;break a}}break}default:{y=0;z=20}}while(0);if((z|0)==19){f=k[l>>2]|0;B=A;C=1;D=f;E=0-(f+c)|0;F=d+-1|0}else if((z|0)==20){z=k[l>>2]|0;B=y;C=0;D=z;E=c-z|0;F=0}switch(m[a+32>>1]|0){case 3:case 1:case 0:{G=1;H=u;I=u;break}default:{G=3;H=q;I=h}}h=a+88|0;q=((k[h>>2]|0)>>>0)%(D>>>0)|0;z=D-q|0;D=q+E|0;y=(d|0)==0;if(y)J=1;else{f=a+84|0;A=a+4|0;g=(c|0)==0;s=(G|0)==1;v=G&65535;G=a+26|0;K=1;L=0;M=F;while(1){F=k[n>>2]|0;N=k[f>>2]|0;O=F-(((N+L|0)>>>0)%(F>>>0)|0)|0;F=(O+L|0)>>>0>d>>>0?d-L|0:O;b:do if(g)P=K;else{O=ha(M,c)|0;Q=N;R=k[h>>2]|0;S=q;T=D;U=z;V=0;while(1){if((yd(o,u,R,Q+L|0,0,0)|0)==-1?(k[A>>2]|0)!=0:0){P=0;break b}if(!s){if((yd(o,H,R,(k[f>>2]|0)+L|0,0,1)|0)==-1?(k[A>>2]|0)!=0:0){P=0;break b}if((yd(o,I,R,(k[f>>2]|0)+L|0,0,2)|0)==-1?(k[A>>2]|0)!=0:0){P=0;break b}}if((t?(yd(o,w,R,(k[f>>2]|0)+L|0,0,v)|0)==-1:0)?(k[A>>2]|0)!=0:0){P=0;break b}W=(((k[f>>2]|0)+L|0)>>>0)%((k[n>>2]|0)>>>0)|0;X=ha(de(o)|0,W)|0;W=(ha(m[G>>1]|0,S)|0)+X|0;if((V+U|0)>>>0>c>>>0){X=c-V|0;Y=(k[l>>2]|0)-X|0;Z=Y;_=Y+E|0;$=X}else{Z=S;_=T;$=U}tb[p&15](a,b+(V+O<<2)|0,V,M,$,F,Z,_,u+W|0,H+W|0,I+W|0,t?w+W|0:0);W=$+V|0;if(W>>>0>=c>>>0){P=K;break b}Q=k[f>>2]|0;R=$+R|0;S=0;T=E;U=k[l>>2]|0;V=W}}while(0);L=F+L|0;if(L>>>0>=d>>>0){J=P;break}else{K=P;M=(C?0-F|0:F)+M|0}}}if(!((B&2|0)==0|y)){y=c+-1|0;B=0;do{M=ha(B,c)|0;C=y+M|0;if((M|0)<(C|0)){P=b+(M<<2)|0;M=b+(C<<2)|0;do{C=k[P>>2]|0;k[P>>2]=k[M>>2];k[M>>2]=C;P=P+4|0;M=M+-4|0}while(P>>>0<M>>>0)}B=B+1|0}while((B|0)!=(d|0))}ne(u);x=J;r=e;return x|0}J=k[o+628>>2]|0;u=qd(o)|0;k[i>>2]=136947;vc(J,u,139955,i);x=0;r=e;return x|0}function fd(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0;e=r;r=r+32|0;f=e+16|0;g=e+8|0;h=e;i=e+20|0;l=k[a>>2]|0;n=k[a+52>>2]|0;o=k[a+16>>2]|0;p=k[a+12>>2]|0;q=Nd(l)|0;if((q|0)!=0?(s=(p|0)!=0,p=ha(s?4:3,q)|0,(p|0)!=0):0){t=me(p)|0;if(!t){u=k[l+628>>2]|0;vc(u,qd(l)|0,136922,g);v=0;r=e;return v|0}pe(t,0,p);p=t+q|0;g=t+(q<<1)|0;u=s?t+(q*3|0)|0:0;a:do switch(m[a+28>>1]|0){case 5:case 1:{switch(j[a+30>>1]|0){case 6:case 2:{w=2;x=0;y=0;z=0;break a;break}case 7:case 3:{A=3;B=19;break a;break}case 8:case 4:{A=1;B=19;break a;break}default:{w=0;x=0;y=0;z=0;break a}}break}case 6:case 2:{switch(j[a+30>>1]|0){case 5:case 1:{w=2;x=0;y=0;z=0;break a;break}case 7:case 3:{A=1;B=19;break a;break}case 8:case 4:{A=3;B=19;break a;break}default:{w=0;x=0;y=0;z=0;break a}}break}case 7:case 3:{switch(j[a+30>>1]|0){case 5:case 1:{A=3;B=19;break a;break}case 8:case 4:{w=2;x=0;y=0;z=0;break a;break}case 6:case 2:{A=1;B=19;break a;break}default:{w=0;x=0;y=0;z=0;break a}}break}case 8:case 4:{switch(j[a+30>>1]|0){case 5:case 1:{A=1;B=19;break a;break}case 7:case 3:{w=2;x=0;y=0;z=0;break a;break}case 6:case 2:{A=3;B=19;break a;break}default:{w=0;x=0;y=0;z=0;break a}}break}default:{w=0;x=0;y=0;z=0}}while(0);if((B|0)==19){w=A;x=1;y=0-(c<<1)|0;z=d+-1|0}switch(m[a+32>>1]|0){case 3:case 1:case 0:{C=1;D=t;E=t;break}default:{C=3;D=p;E=g}}k[f>>2]=i;Ge(l,278,f)|0;f=Pd(l)|0;g=o>>>0>c>>>0?o-c|0:0;o=a+4|0;p=(d|0)==0;b:do if(p)F=1;else{A=a+84|0;B=(C|0)==1;q=C&65535;G=a+88|0;H=a+26|0;I=0;J=z;while(1){K=k[i>>2]|0;L=(k[A>>2]|0)+I|0;M=K-((L>>>0)%(K>>>0)|0)|0;K=(M+I|0)>>>0>d>>>0?d-I|0:M;M=Id(l,L,0)|0;if((vd(l,M,t,ha(((((k[A>>2]|0)+I|0)>>>0)%((k[i>>2]|0)>>>0)|0)+K|0,f)|0)|0)==-1?(k[o>>2]|0)!=0:0){F=0;break b}if(!B){M=Id(l,L,1)|0;if((vd(l,M,D,ha(((((k[A>>2]|0)+I|0)>>>0)%((k[i>>2]|0)>>>0)|0)+K|0,f)|0)|0)==-1?(k[o>>2]|0)!=0:0){F=0;break b}M=Id(l,L,2)|0;if((vd(l,M,E,ha(((((k[A>>2]|0)+I|0)>>>0)%((k[i>>2]|0)>>>0)|0)+K|0,f)|0)|0)==-1?(k[o>>2]|0)!=0:0){F=0;break b}}if((s?(M=Id(l,L,q)|0,(vd(l,M,u,ha(((((k[A>>2]|0)+I|0)>>>0)%((k[i>>2]|0)>>>0)|0)+K|0,f)|0)|0)==-1):0)?(k[o>>2]|0)!=0:0){F=0;break b}M=ha((((k[A>>2]|0)+I|0)>>>0)%((k[i>>2]|0)>>>0)|0,f)|0;L=(ha(m[H>>1]|0,k[G>>2]|0)|0)+M|0;M=b+((ha(J,c)|0)<<2)|0;tb[n&15](a,M,0,J,c,K,g,y,t+L|0,D+L|0,E+L|0,s?u+L|0:0);I=K+I|0;if(I>>>0>=d>>>0){F=1;break}else J=(x?0-K|0:K)+J|0}}while(0);if(!((w&2|0)==0|p)){p=c+-1|0;w=0;do{x=ha(w,c)|0;u=p+x|0;if((x|0)<(u|0)){s=b+(x<<2)|0;x=b+(u<<2)|0;do{u=k[s>>2]|0;k[s>>2]=k[x>>2];k[x>>2]=u;s=s+4|0;x=x+-4|0}while(s>>>0<x>>>0)}w=w+1|0}while((w|0)!=(d|0))}ne(t);v=F;r=e;return v|0}F=k[l+628>>2]|0;t=qd(l)|0;k[h>>2]=136906;vc(F,t,139955,h);v=0;r=e;return v|0}function gd(a,b,c,d,e,f,g,h,i,j,m,n){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0;if(!f)return;d=e>>>0>7;c=e+-8|0;a=c&-8;o=c-a|0;c=a+8|0;a=j;j=m;m=i;i=b;b=n;n=f;while(1){n=n+-1|0;if(d){f=b+c|0;p=a+c|0;q=a;r=m;s=j;t=i;u=b;v=e;while(1){k[t>>2]=(l[q>>0]|0)<<8|(l[r>>0]|0)|(l[s>>0]|0)<<16|(l[u>>0]|0)<<24;k[t+4>>2]=(l[q+1>>0]|0)<<8|(l[r+1>>0]|0)|(l[s+1>>0]|0)<<16|(l[u+1>>0]|0)<<24;k[t+8>>2]=(l[q+2>>0]|0)<<8|(l[r+2>>0]|0)|(l[s+2>>0]|0)<<16|(l[u+2>>0]|0)<<24;k[t+12>>2]=(l[q+3>>0]|0)<<8|(l[r+3>>0]|0)|(l[s+3>>0]|0)<<16|(l[u+3>>0]|0)<<24;k[t+16>>2]=(l[q+4>>0]|0)<<8|(l[r+4>>0]|0)|(l[s+4>>0]|0)<<16|(l[u+4>>0]|0)<<24;k[t+20>>2]=(l[q+5>>0]|0)<<8|(l[r+5>>0]|0)|(l[s+5>>0]|0)<<16|(l[u+5>>0]|0)<<24;k[t+24>>2]=(l[q+6>>0]|0)<<8|(l[r+6>>0]|0)|(l[s+6>>0]|0)<<16|(l[u+6>>0]|0)<<24;k[t+28>>2]=(l[q+7>>0]|0)<<8|(l[r+7>>0]|0)|(l[s+7>>0]|0)<<16|(l[u+7>>0]|0)<<24;v=v+-8|0;if(v>>>0<=7)break;else{q=q+8|0;r=r+8|0;s=s+8|0;t=t+32|0;u=u+8|0}}w=f;x=p;y=j+c|0;z=m+c|0;A=i+(c<<2)|0;B=o}else{w=b;x=a;y=j;z=m;A=i;B=e}switch(B|0){case 1:{C=w;D=x;E=z;F=A;G=y;H=14;break}case 7:{k[A>>2]=(l[x>>0]|0)<<8|(l[z>>0]|0)|(l[y>>0]|0)<<16|(l[w>>0]|0)<<24;I=w+1|0;J=x+1|0;K=z+1|0;L=y+1|0;M=A+4|0;H=9;break}case 6:{I=w;J=x;K=z;L=y;M=A;H=9;break}case 5:{N=w;O=x;P=z;Q=A;R=y;H=10;break}case 4:{S=w;T=x;U=z;V=A;W=y;H=11;break}case 3:{X=w;Y=x;Z=z;_=A;$=y;H=12;break}case 2:{aa=w;ba=x;ca=z;da=A;ea=y;H=13;break}default:{fa=w;ga=x;ha=z;ia=A;ja=y}}if((H|0)==9){H=0;k[M>>2]=(l[J>>0]|0)<<8|(l[K>>0]|0)|(l[L>>0]|0)<<16|(l[I>>0]|0)<<24;N=I+1|0;O=J+1|0;P=K+1|0;Q=M+4|0;R=L+1|0;H=10}if((H|0)==10){H=0;k[Q>>2]=(l[O>>0]|0)<<8|(l[P>>0]|0)|(l[R>>0]|0)<<16|(l[N>>0]|0)<<24;S=N+1|0;T=O+1|0;U=P+1|0;V=Q+4|0;W=R+1|0;H=11}if((H|0)==11){H=0;k[V>>2]=(l[T>>0]|0)<<8|(l[U>>0]|0)|(l[W>>0]|0)<<16|(l[S>>0]|0)<<24;X=S+1|0;Y=T+1|0;Z=U+1|0;_=V+4|0;$=W+1|0;H=12}if((H|0)==12){H=0;k[_>>2]=(l[Y>>0]|0)<<8|(l[Z>>0]|0)|(l[$>>0]|0)<<16|(l[X>>0]|0)<<24;aa=X+1|0;ba=Y+1|0;ca=Z+1|0;da=_+4|0;ea=$+1|0;H=13}if((H|0)==13){H=0;k[da>>2]=(l[ba>>0]|0)<<8|(l[ca>>0]|0)|(l[ea>>0]|0)<<16|(l[aa>>0]|0)<<24;C=aa+1|0;D=ba+1|0;E=ca+1|0;F=da+4|0;G=ea+1|0;H=14}if((H|0)==14){H=0;k[F>>2]=(l[D>>0]|0)<<8|(l[E>>0]|0)|(l[G>>0]|0)<<16|(l[C>>0]|0)<<24;fa=C+1|0;ga=D+1|0;ha=E+1|0;ia=F+4|0;ja=G+1|0}if(!n)break;else{a=ga+g|0;j=ja+g|0;m=ha+g|0;i=ia+(h<<2)|0;b=fa+g|0}}return}function hd(a,b,c,d,e,f,g,h,i,j,m,n){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;if(!f)return;d=(e|0)==0;c=a+76|0;a=b;b=i;i=j;j=n;n=m;m=f;while(1){m=m+-1|0;if(d){o=a;p=n;q=b;r=i;s=j}else{f=n+e|0;t=b+e|0;u=k[c>>2]|0;v=e;w=n;x=a;y=b;z=i;A=j;while(1){v=v+-1|0;B=l[A>>0]|0;C=B<<8;k[x>>2]=l[u+(l[y>>0]|0|C)>>0]|0|B<<24|(l[u+(l[z>>0]|0|C)>>0]|0)<<8|(l[u+(l[w>>0]|0|C)>>0]|0)<<16;if(!v)break;else{w=w+1|0;x=x+4|0;y=y+1|0;z=z+1|0;A=A+1|0}}o=a+(e<<2)|0;p=f;q=t;r=i+e|0;s=j+e|0}if(!m)break;else{a=o+(h<<2)|0;b=q+g|0;i=r+g|0;j=s+g|0;n=p+g|0}}return}function id(a,b,c,d,e,f,g,h,i,j,m,n){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;if(!f)return;n=e>>>0>7;d=e+-8|0;c=d&-8;a=d-c|0;d=c+8|0;c=j;j=m;m=i;i=b;b=f;while(1){b=b+-1|0;if(n){f=i+(d<<2)|0;o=c+d|0;p=c;q=m;r=j;s=i;t=e;while(1){k[s>>2]=l[q>>0]|0|(l[p>>0]|0)<<8|(l[r>>0]|0)<<16|-16777216;k[s+4>>2]=l[q+1>>0]|0|(l[p+1>>0]|0)<<8|(l[r+1>>0]|0)<<16|-16777216;k[s+8>>2]=l[q+2>>0]|0|(l[p+2>>0]|0)<<8|(l[r+2>>0]|0)<<16|-16777216;k[s+12>>2]=l[q+3>>0]|0|(l[p+3>>0]|0)<<8|(l[r+3>>0]|0)<<16|-16777216;k[s+16>>2]=l[q+4>>0]|0|(l[p+4>>0]|0)<<8|(l[r+4>>0]|0)<<16|-16777216;k[s+20>>2]=l[q+5>>0]|0|(l[p+5>>0]|0)<<8|(l[r+5>>0]|0)<<16|-16777216;k[s+24>>2]=l[q+6>>0]|0|(l[p+6>>0]|0)<<8|(l[r+6>>0]|0)<<16|-16777216;k[s+28>>2]=l[q+7>>0]|0|(l[p+7>>0]|0)<<8|(l[r+7>>0]|0)<<16|-16777216;t=t+-8|0;if(t>>>0<=7)break;else{p=p+8|0;q=q+8|0;r=r+8|0;s=s+32|0}}u=f;v=o;w=j+d|0;x=m+d|0;y=a}else{u=i;v=c;w=j;x=m;y=e}switch(y|0){case 1:{z=u;A=v;B=x;C=w;D=14;break}case 7:{k[u>>2]=l[x>>0]|0|(l[v>>0]|0)<<8|(l[w>>0]|0)<<16|-16777216;E=u+4|0;F=v+1|0;G=x+1|0;H=w+1|0;D=9;break}case 6:{E=u;F=v;G=x;H=w;D=9;break}case 5:{I=u;J=v;K=x;L=w;D=10;break}case 4:{M=u;N=v;O=x;P=w;D=11;break}case 3:{Q=u;R=v;S=x;T=w;D=12;break}case 2:{U=u;V=v;W=x;X=w;D=13;break}default:{Y=u;Z=v;_=x;$=w}}if((D|0)==9){D=0;k[E>>2]=l[G>>0]|0|(l[F>>0]|0)<<8|(l[H>>0]|0)<<16|-16777216;I=E+4|0;J=F+1|0;K=G+1|0;L=H+1|0;D=10}if((D|0)==10){D=0;k[I>>2]=l[K>>0]|0|(l[J>>0]|0)<<8|(l[L>>0]|0)<<16|-16777216;M=I+4|0;N=J+1|0;O=K+1|0;P=L+1|0;D=11}if((D|0)==11){D=0;k[M>>2]=l[O>>0]|0|(l[N>>0]|0)<<8|(l[P>>0]|0)<<16|-16777216;Q=M+4|0;R=N+1|0;S=O+1|0;T=P+1|0;D=12}if((D|0)==12){D=0;k[Q>>2]=l[S>>0]|0|(l[R>>0]|0)<<8|(l[T>>0]|0)<<16|-16777216;U=Q+4|0;V=R+1|0;W=S+1|0;X=T+1|0;D=13}if((D|0)==13){D=0;k[U>>2]=l[W>>0]|0|(l[V>>0]|0)<<8|(l[X>>0]|0)<<16|-16777216;z=U+4|0;A=V+1|0;B=W+1|0;C=X+1|0;D=14}if((D|0)==14){D=0;k[z>>2]=l[B>>0]|0|(l[A>>0]|0)<<8|(l[C>>0]|0)<<16|-16777216;Y=z+4|0;Z=A+1|0;_=B+1|0;$=C+1|0}if(!b)break;else{c=Z+g|0;j=$+g|0;m=_+g|0;i=Y+(h<<2)|0}}return}function jd(a,b,c,d,e,f,g,h,i,j,n,o){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;n=n|0;o=o|0;var p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;if(!f)return;d=(e|0)==0;c=a+80|0;a=b;b=f;f=o;o=n;n=j;j=i;while(1){b=b+-1|0;if(d){p=a;q=f;r=o;s=n;t=j}else{i=f+(e<<1)|0;u=n+(e<<1)|0;v=k[c>>2]|0;w=0;x=a;y=f;z=o;A=n;B=j;while(1){k[x>>2]=(l[v+(m[A>>1]|0)>>0]|0)<<8|(l[v+(m[B>>1]|0)>>0]|0)|(l[v+(m[z>>1]|0)>>0]|0)<<16|(l[v+(m[y>>1]|0)>>0]|0)<<24;w=w+1|0;if((w|0)==(e|0))break;else{x=x+4|0;y=y+2|0;z=z+2|0;A=A+2|0;B=B+2|0}}p=a+(e<<2)|0;q=i;r=o+(e<<1)|0;s=u;t=j+(e<<1)|0}if(!b)break;else{a=p+(h<<2)|0;f=q+(g<<1)|0;o=r+(g<<1)|0;n=s+(g<<1)|0;j=t+(g<<1)|0}}return}function kd(a,b,c,d,e,f,g,h,i,j,n,o){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;n=n|0;o=o|0;var p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;if(!f)return;d=(e|0)==0;c=a+80|0;p=a+76|0;a=b;b=f;f=o;o=n;n=j;j=i;while(1){b=b+-1|0;if(d){q=a;r=f;s=o;t=n;u=j}else{i=o+(e<<1)|0;v=j+(e<<1)|0;w=k[c>>2]|0;x=k[p>>2]|0;y=e;z=a;A=f;B=o;C=n;D=j;while(1){y=y+-1|0;E=l[w+(m[A>>1]|0)>>0]|0;F=E<<8;k[z>>2]=l[x+(l[w+(m[D>>1]|0)>>0]|0|F)>>0]|0|E<<24|(l[x+(l[w+(m[C>>1]|0)>>0]|0|F)>>0]|0)<<8|(l[x+(l[w+(m[B>>1]|0)>>0]|0|F)>>0]|0)<<16;if(!y)break;else{z=z+4|0;A=A+2|0;B=B+2|0;C=C+2|0;D=D+2|0}}q=a+(e<<2)|0;r=f+(e<<1)|0;s=i;t=n+(e<<1)|0;u=v}if(!b)break;else{a=q+(h<<2)|0;f=r+(g<<1)|0;o=s+(g<<1)|0;n=t+(g<<1)|0;j=u+(g<<1)|0}}return}function ld(a,b,c,d,e,f,g,h,i,j,n,o){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;n=n|0;o=o|0;var p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;if(!f)return;o=(e|0)==0;d=a+80|0;a=b;b=f;f=n;n=j;j=i;while(1){b=b+-1|0;if(o){p=a;q=f;r=n;s=j}else{i=a+(e<<2)|0;c=n+(e<<1)|0;t=k[d>>2]|0;u=0;v=a;w=f;x=n;y=j;while(1){k[v>>2]=l[t+(m[y>>1]|0)>>0]|0|(l[t+(m[x>>1]|0)>>0]|0)<<8|(l[t+(m[w>>1]|0)>>0]|0)<<16|-16777216;u=u+1|0;if((u|0)==(e|0))break;else{v=v+4|0;w=w+2|0;x=x+2|0;y=y+2|0}}p=i;q=f+(e<<1)|0;r=c;s=j+(e<<1)|0}if(!b)break;else{a=p+(h<<2)|0;f=q+(g<<1)|0;n=r+(g<<1)|0;j=s+(g<<1)|0}}return}function md(a,b,c,d,e,f,g,h,i,j,m,n){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;if(!f)return;d=(e|0)==0;c=b;b=i;i=n;n=m;m=j;j=f;while(1){j=j+-1|0;if(d){o=c;p=m;q=b;r=i;s=n}else{f=n+e|0;a=b+e|0;t=e;u=m;v=c;w=b;x=i;y=n;while(1){t=t+-1|0;z=(l[x>>0]|0)^255;A=((ha((l[w>>0]|0)^255,z)|0)>>>0)/255|0;B=((ha((l[u>>0]|0)^255,z)|0)>>>0)/255|0;C=A|B<<8|(((ha((l[y>>0]|0)^255,z)|0)>>>0)/255|0)<<16|-16777216;k[v>>2]=C;if(!t)break;else{u=u+1|0;v=v+4|0;w=w+1|0;x=x+1|0;y=y+1|0}}o=c+(e<<2)|0;p=m+e|0;q=a;r=i+e|0;s=f}if(!j)break;else{c=o+(h<<2)|0;b=q+g|0;i=r+g|0;n=s+g|0;m=p+g|0}}return}function nd(a,b,c,d,e,f,g,h,i,j,m,n){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;m=m|0;n=n|0;var o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0;n=r;r=r+16|0;d=n+8|0;c=n+4|0;o=n;if(!f){r=n;return}p=a+68|0;a=e+g|0;q=e+g|0;s=e+g|0;g=e+h|0;h=m;m=b;b=j;j=i;i=f;while(1){f=e;t=m;u=h;v=b;w=j;while(1){Ke(k[p>>2]|0,l[w>>0]|0,l[v>>0]|0,l[u>>0]|0,d,c,o);k[t>>2]=k[d>>2]|k[c>>2]<<8|k[o>>2]<<16|-16777216;f=f+-1|0;if(!f)break;else{t=t+4|0;u=u+1|0;v=v+1|0;w=w+1|0}}i=i+-1|0;if(!i)break;else{h=h+s|0;m=m+(g<<2)|0;b=b+q|0;j=j+a|0}}r=n;return}function od(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0;c=r;r=r+16|0;d=c;e=i[a>>0]|0;switch(e<<24>>24|0){case 114:{f=(i[a+1>>0]|0)==43?2:0;r=c;return f|0}case 97:case 119:{r=c;return (e<<24>>24==119?578:66)|0}default:{k[d>>2]=a;vc(0,b,137216,d);f=-1;r=c;return f|0}}return 0}function pd(a,b,c,d,e,f,g,h,l,n){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;l=l|0;n=n|0;var o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;o=r;r=r+96|0;p=o+80|0;q=o+72|0;s=o+64|0;t=o+56|0;u=o+48|0;v=o+40|0;w=o+32|0;x=o+24|0;y=o+16|0;z=o+8|0;A=o;B=i[b>>0]|0;switch(B<<24>>24|0){case 114:{C=(i[b+1>>0]|0)==43?2:0;break}case 97:case 119:{C=B<<24>>24==119?578:66;break}default:{k[z>>2]=b;vc(0,137231,137216,z);D=0;r=o;return D|0}}z=me((Qq(a)|0)+697|0)|0;if(!z){k[y>>2]=a;vc(c,137231,137246,y);D=0;r=o;return D|0}pe(z,0,696);y=z+696|0;k[z>>2]=y;Pq(y,a)|0;y=z+8|0;k[y>>2]=C&2;j[z+448>>1]=-1;B=z+456|0;k[B>>2]=0;k[B+4>>2]=0;k[z+452>>2]=-1;k[z+444>>2]=-1;B=z+628|0;k[B>>2]=c;if(!((d|0)!=0&(e|0)!=0&(f|0)!=0&(g|0)!=0&(h|0)!=0)){vc(c,137231,137281,x);D=0;r=o;return D|0}x=z+632|0;k[x>>2]=d;d=z+636|0;k[d>>2]=e;e=z+640|0;k[e>>2]=f;k[z+644>>2]=g;k[z+648>>2]=h;h=z+620|0;k[h>>2]=(l|0)==0?7:l;k[z+624>>2]=(n|0)==0?1:n;Ve(z);n=z+12|0;l=(C|0)==0;g=l?2049:1;f=(C&576|0)==0?g|32768:g;k[n>>2]=f;g=i[b>>0]|0;a:do if(g<<24>>24){c=(C&64|0)==0;if(l){E=g;F=f;G=f;H=f;I=f;J=f;K=b}else{L=g;M=f;N=f;O=b;while(1){switch(L<<24>>24|0){case 98:{if(c){P=M;Q=N}else{R=M|128;k[n>>2]=R;P=R;Q=R}break}case 56:{if(c){P=M;Q=N}else{R=M|524288;k[n>>2]=R;P=R;Q=R}break}case 66:{R=M&-4|1;k[n>>2]=R;P=R;Q=R;break}case 76:{R=M&-4|2;k[n>>2]=R;P=R;Q=R;break}case 72:{R=M&-4|2;k[n>>2]=R;P=R;Q=R;break}case 104:{R=N|65536;k[n>>2]=R;P=R;Q=R;break}default:{P=M;Q=N}}O=O+1|0;L=i[O>>0]|0;if(!(L<<24>>24))break a;else{M=P;N=Q}}}while(1){do switch(E<<24>>24|0){case 98:{if(c){S=J;T=I;U=H;V=G;W=F}else{N=J|128;k[n>>2]=N;S=N;T=N;U=N;V=N;W=N}break}case 56:{if(c){S=J;T=I;U=H;V=G;W=F}else{N=J|524288;k[n>>2]=N;S=N;T=N;U=N;V=N;W=N}break}case 66:{N=J&-4|1;k[n>>2]=N;S=N;T=N;U=N;V=N;W=N;break}case 76:{N=J&-4|2;k[n>>2]=N;S=N;T=N;U=N;V=N;W=N;break}case 72:{N=J&-4|2;k[n>>2]=N;S=N;T=N;U=N;V=N;W=N;break}case 77:{N=J|2048;k[n>>2]=N;S=N;T=N;U=N;V=N;W=N;break}case 109:{N=I&-2049;k[n>>2]=N;S=N;T=N;U=N;V=N;W=N;break}case 67:{N=H|32768;k[n>>2]=N;S=N;T=N;U=N;V=N;W=N;break}case 99:{N=G&-32769;k[n>>2]=N;S=N;T=N;U=N;V=N;W=N;break}case 104:{N=F|65536;k[n>>2]=N;S=N;T=N;U=N;V=N;W=N;break}default:{S=J;T=I;U=H;V=G;W=F}}while(0);K=K+1|0;E=i[K>>0]|0;if(!(E<<24>>24))break a;else{F=W;G=V;H=U;I=T;J=S}}}while(0);b:do if((C&512|0)==0?(S=z+424|0,(nb[k[x>>2]&63](k[B>>2]|0,S,8)|0)==8):0){J=j[S>>1]|0;S=J&65535;switch(J<<16>>16){case 19789:{k[n>>2]=k[n>>2]|128;break}case 20549:case 18761:break;default:{J=k[B>>2]|0;k[u>>2]=S;k[u+4>>2]=S;vc(J,a,137351,u);break b}}J=z+426|0;if(k[n>>2]&128)Qd(J);S=j[J>>1]|0;J=S&65535;if((S&-2)<<16>>16!=42){T=k[B>>2]|0;k[t>>2]=J;k[t+4>>2]=J;vc(T,a,137402,t);break}do if(S<<16>>16!=42){T=z+432|0;if((nb[k[x>>2]&63](k[B>>2]|0,T,8)|0)!=8){vc(k[B>>2]|0,a,137327,s);break b}J=z+428|0;if(k[n>>2]&128){Qd(J);Sd(T)}T=j[J>>1]|0;J=T&65535;if(T<<16>>16!=8){T=k[B>>2]|0;k[q>>2]=J;k[q+4>>2]=J;vc(T,a,137448,q);break b}T=j[z+430>>1]|0;J=T&65535;if(!(T<<16>>16)){j[z+440>>1]=16;T=k[n>>2]|524288;k[n>>2]=T;X=T;break}else{T=k[B>>2]|0;k[p>>2]=J;k[p+4>>2]=J;vc(T,a,137498,p);break b}}else{T=k[n>>2]|0;if(!(T&128))Y=T;else{Rd(z+428|0);Y=k[n>>2]|0}j[z+440>>1]=8;X=Y}while(0);S=X|512;k[n>>2]=S;T=z+588|0;k[T>>2]=0;k[T+4>>2]=0;k[T+8>>2]=0;k[T+12>>2]=0;k[T+16>>2]=0;switch(i[b>>0]|0){case 114:break;case 97:{if(!(Tb(z)|0))break b;else D=z;r=o;return D|0}default:break b}if(!(X&524288)){T=z+24|0;k[T>>2]=k[z+428>>2];k[T+4>>2]=0}else{T=z+432|0;J=k[T+4>>2]|0;I=z+24|0;k[I>>2]=k[T>>2];k[I+4>>2]=J}do if(X&2048){if(!(nb[k[h>>2]&63](k[B>>2]|0,z+612|0,A)|0)){J=k[n>>2]&-2049;k[n>>2]=J;Z=J;break}J=A;I=k[J>>2]|0;T=k[J+4>>2]|0;k[z+616>>2]=I;if((I|0)==(I|0)&(((I|0)<0)<<31>>31|0)==(T|0)){Z=k[n>>2]|0;break}else Ja(137544,137569,449,137231)}else Z=S;while(0);if(Z&65536){D=z;r=o;return D|0}if(fc(z)|0){k[z+608>>2]=-1;k[n>>2]=k[n>>2]|16;D=z;r=o;return D|0}}else _=37;while(0);do if((_|0)==37){if(!(k[y>>2]|0)){vc(k[B>>2]|0,a,137327,w);break}Z=k[n>>2]|0;A=Z&128;h=z+424|0;j[h>>1]=(A|0)!=0?19789:18761;X=z+426|0;if(!(Z&524288)){j[X>>1]=42;k[z+428>>2]=0;if(A)Qd(X);Z=z+440|0;j[Z>>1]=8;$=Z}else{j[X>>1]=43;Z=z+428|0;j[Z>>1]=8;j[z+430>>1]=0;b=z+432|0;k[b>>2]=0;k[b+4>>2]=0;if(A){Qd(X);Qd(Z)}Z=z+440|0;j[Z>>1]=16;$=Z}xb[k[e>>2]&63](k[B>>2]|0,0,0,0)|0;Z=nb[k[d>>2]&63](k[B>>2]|0,h,m[$>>1]|0)|0;if((Z|0)!=(m[$>>1]|0)){vc(k[B>>2]|0,a,142082,v);break}if((j[h>>1]|0)==19789)k[n>>2]=k[n>>2]|128;if(Tb(z)|0){h=z+16|0;k[h>>2]=0;k[h+4>>2]=0;k[z+32>>2]=0;j[z+36>>1]=0;j[z+38>>1]=0;D=z;r=o;return D|0}}while(0);k[y>>2]=0;Lb(z);D=0;r=o;return D|0}function qd(a){a=a|0;return k[a>>2]|0}function rd(a){a=a|0;return (k[a+12>>2]|0)>>>10&1|0}function sd(a){a=a|0;return j[a+448>>1]|0}function td(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function ud(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function vd(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=r;r=r+32|0;f=e+16|0;if((k[a+8>>2]|0)==1){vc(k[a+628>>2]|0,k[a>>2]|0,137580,e);g=-1;r=e;return g|0}if(k[a+12>>2]&1024){vc(k[a+628>>2]|0,k[a>>2]|0,137606,e+8|0);g=-1;r=e;return g|0}h=k[a+168>>2]|0;if(h>>>0<=b>>>0){i=k[a+628>>2]|0;k[f>>2]=b;k[f+4>>2]=h;vc(i,137830,137851,f);g=-1;r=e;return g|0}f=k[a+100>>2]|0;i=k[a+60>>2]|0;h=f>>>0>i>>>0?i:f;f=((i+-1+h|0)>>>0)/(h>>>0)|0;j=i-(ha((b>>>0)%(f>>>0)|0,h)|0)|0;i=Md(a,j>>>0>h>>>0?h:j)|0;if(!i){g=-1;r=e;return g|0}j=(d|0)!=-1&(i|0)>(d|0)?d:i;if(!(wd(a,b)|0)){g=-1;r=e;return g|0}if((xb[k[a+540>>2]&63](a,c,j,((b>>>0)/(f>>>0)|0)&65535)|0)<1){g=-1;r=e;return g|0}vb[k[a+652>>2]&127](a,c,j);g=j;r=e;return g|0}function wd(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;c=r;r=r+64|0;d=c+48|0;e=c+40|0;f=c+16|0;g=c;if(!(gc(a)|0)){h=0;r=c;return h|0}i=a+176|0;j=k[i>>2]|0;if(!j){h=0;r=c;return h|0}l=a+12|0;n=k[l>>2]|0;do if(!(n&131072)){o=j+(b<<3)|0;p=k[o>>2]|0;q=k[o+4>>2]|0;if((q|0)<0|(q|0)==0&p>>>0<1){o=k[a+628>>2]|0;s=g;k[s>>2]=p;k[s+4>>2]=q;k[g+8>>2]=b;vc(o,137884,137898,g);h=0;r=c;return h|0}if((n&2048|0)!=0?((m[a+94>>1]|0|256)&n|0)!=0:0){if((n&512|0)!=0?(o=a+588|0,s=k[o>>2]|0,(s|0)!=0):0){ne(s);k[o>>2]=0;k[a+592>>2]=0;t=k[l>>2]|0}else t=n;o=t&-513;k[l>>2]=o;s=k[a+616>>2]|0;u=((s|0)<0)<<31>>31;v=(k[a+172>>2]|0)+(b<<3)|0;w=k[v>>2]|0;x=k[v+4>>2]|0;v=pr(s|0,u|0,p|0,q|0)|0;y=L;if(!(u>>>0<q>>>0|(u|0)==(q|0)&s>>>0<p>>>0|(x>>>0>y>>>0|(x|0)==(y|0)&w>>>0>v>>>0))){k[a+592>>2]=p;k[a+588>>2]=(k[a+612>>2]|0)+w;k[a+596>>2]=0;k[a+600>>2]=p;k[l>>2]=o|8388608;break}o=k[a+628>>2]|0;v=pr(s|0,u|0,w|0,x|0)|0;k[f>>2]=b;x=f+8|0;k[x>>2]=v;k[x+4>>2]=L;x=f+16|0;k[x>>2]=p;k[x+4>>2]=q;vc(o,137884,137939,f);k[a+452>>2]=-1;h=0;r=c;return h|0}if(!((p|0)==(p|0)&(((p|0)<0)<<31>>31|0)==(q|0))){vc(k[a+628>>2]|0,137884,139721,e);h=0;r=c;return h|0}do if((p|0)>(k[a+592>>2]|0)){k[a+452>>2]=-1;if(!(n&512)){q=k[a+628>>2]|0;k[d>>2]=b;vc(q,137884,137994,d);h=0;r=c;return h|0}if(!(xd(a,0,p)|0)){h=0;r=c;return h|0}else{z=k[l>>2]|0;break}}else z=n;while(0);if((z&8388608|0)!=0?(k[a+452>>2]=-1,(xd(a,0,p)|0)==0):0){h=0;r=c;return h|0}q=a+588|0;if((Gd(a,b,k[q>>2]|0,p,137884)|0)!=(p|0)){h=0;r=c;return h|0}k[a+596>>2]=0;k[a+600>>2]=p;if(!((m[a+94>>1]|0|256)&k[l>>2]))_d(k[q>>2]|0,p)}while(0);if(!(gc(a)|0)){h=0;r=c;return h|0}if(!(k[i>>2]|0)){h=0;r=c;return h|0}z=k[l>>2]|0;do if(!(z&32))if(!(ub[k[a+508>>2]&63](a)|0)){h=0;r=c;return h|0}else{n=k[l>>2]|32;k[l>>2]=n;A=n;break}else A=z;while(0);k[a+452>>2]=b;z=k[a+164>>2]|0;n=ha(k[a+100>>2]|0,(b>>>0)%(z>>>0)|0)|0;k[a+444>>2]=n;k[l>>2]=A&-1048577;if(!(A&131072)){k[a+604>>2]=k[a+588>>2];B=k[(k[i>>2]|0)+(b<<3)>>2]|0}else{k[a+604>>2]=0;B=0}k[a+608>>2]=B;h=yb[k[a+512>>2]&127](a,((b>>>0)/(z>>>0)|0)&65535)|0;r=c;return h|0}function xd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0;d=r;r=r+16|0;e=d+8|0;f=d;g=a+12|0;h=k[g>>2]|0;if(h&131072)Ja(137648,137683,918,137694);k[g>>2]=h&-8388609;i=a+588|0;j=k[i>>2]|0;if(j){if(h&512)ne(j);k[i>>2]=0;k[a+592>>2]=0}if(b){k[a+592>>2]=c;k[i>>2]=b;k[g>>2]=k[g>>2]&-513;l=1;r=d;return l|0}b=c+1023&-1024;k[a+592>>2]=b;if(!b){vc(k[a+628>>2]|0,137694,137714,f);l=0;r=d;return l|0}f=me(b)|0;k[i>>2]=f;k[g>>2]=k[g>>2]|512;if(f){l=1;r=d;return l|0}f=k[a+628>>2]|0;k[e>>2]=k[a+444>>2];vc(f,137694,138034,e);k[a+592>>2]=0;l=0;r=d;return l|0}function yd(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=r;r=r+16|0;if((k[a+8>>2]|0)==1){vc(k[a+628>>2]|0,k[a>>2]|0,137580,g);h=-1;r=g;return h|0}if(!(k[a+12>>2]&1024)){vc(k[a+628>>2]|0,k[a>>2]|0,138075,g+8|0);h=-1;r=g;return h|0}if(!(ae(a,c,d,e,f)|0)){h=-1;r=g;return h|0}h=zd(a,$d(a,c,d,e,f)|0,b,-1)|0;r=g;return h|0}function zd(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=r;r=r+32|0;f=e+16|0;g=k[a+496>>2]|0;if((k[a+8>>2]|0)==1){vc(k[a+628>>2]|0,k[a>>2]|0,137580,e);h=-1;r=e;return h|0}if(!(k[a+12>>2]&1024)){vc(k[a+628>>2]|0,k[a>>2]|0,138075,e+8|0);h=-1;r=e;return h|0}i=k[a+168>>2]|0;if(i>>>0<=b>>>0){j=k[a+628>>2]|0;k[f>>2]=b;k[f+4>>2]=i;vc(j,138116,138136,f);h=-1;r=e;return h|0}f=(d|0)==-1|(g|0)<(d|0)?g:d;if(!(Ad(a,b)|0)){h=-1;r=e;return h|0}if(!(xb[k[a+548>>2]&63](a,c,f,((b>>>0)/((k[a+164>>2]|0)>>>0)|0)&65535)|0)){h=-1;r=e;return h|0}vb[k[a+652>>2]&127](a,c,f);h=f;r=e;return h|0}function Ad(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;c=r;r=r+48|0;d=c+40|0;e=c+32|0;f=c+24|0;g=c+16|0;h=c;if(!(gc(a)|0)){i=0;r=c;return i|0}j=a+176|0;l=k[j>>2]|0;if(!l){i=0;r=c;return i|0}n=a+12|0;o=k[n>>2]|0;do if(!(o&131072)){p=l+(b<<3)|0;q=k[p>>2]|0;s=k[p+4>>2]|0;if((s|0)<0|(s|0)==0&q>>>0<1){p=k[a+628>>2]|0;t=h;k[t>>2]=q;k[t+4>>2]=s;k[h+8>>2]=b;vc(p,138168,138181,h);i=0;r=c;return i|0}if((o&2048|0)!=0?((m[a+94>>1]|0|256)&o|0)!=0:0){if((o&512|0)!=0?(p=a+588|0,t=k[p>>2]|0,(t|0)!=0):0){ne(t);k[p>>2]=0;k[a+592>>2]=0;u=k[n>>2]|0}else u=o;p=u&-513;k[n>>2]=p;t=k[a+616>>2]|0;v=((t|0)<0)<<31>>31;if(!(v>>>0<s>>>0|(v|0)==(s|0)&t>>>0<q>>>0)?(w=(k[a+172>>2]|0)+(b<<3)|0,x=k[w>>2]|0,y=k[w+4>>2]|0,w=pr(t|0,v|0,q|0,s|0)|0,v=L,!(y>>>0>v>>>0|(y|0)==(v|0)&x>>>0>w>>>0)):0){k[a+592>>2]=q;k[a+588>>2]=(k[a+612>>2]|0)+x;k[a+596>>2]=0;k[a+600>>2]=q;k[n>>2]=p|8388608;break}k[a+492>>2]=-1;i=0;r=c;return i|0}if(!((q|0)==(q|0)&(((q|0)<0)<<31>>31|0)==(s|0))){vc(k[a+628>>2]|0,138168,139721,g);i=0;r=c;return i|0}do if((q|0)>(k[a+592>>2]|0)){k[a+492>>2]=-1;if(!(o&512)){s=k[a+628>>2]|0;k[f>>2]=b;vc(s,138168,138221,f);i=0;r=c;return i|0}if(!(xd(a,0,q)|0)){i=0;r=c;return i|0}else{z=k[n>>2]|0;break}}else z=o;while(0);if((z&8388608|0)!=0?(k[a+492>>2]=-1,(xd(a,0,q)|0)==0):0){i=0;r=c;return i|0}s=a+588|0;if((Hd(a,b,k[s>>2]|0,q,138168)|0)!=(q|0)){i=0;r=c;return i|0}k[a+596>>2]=0;k[a+600>>2]=q;if(!((m[a+94>>1]|0|256)&k[n>>2]))_d(k[s>>2]|0,q)}while(0);if(!(gc(a)|0)){i=0;r=c;return i|0}if(!(k[j>>2]|0)){i=0;r=c;return i|0}z=k[n>>2]|0;do if(!(z&32))if(!(ub[k[a+508>>2]&63](a)|0)){i=0;r=c;return i|0}else{o=k[n>>2]|32;k[n>>2]=o;A=o;break}else A=z;while(0);k[a+492>>2]=b;z=k[a+56>>2]|0;o=k[a+68>>2]|0;if(z>>>0<(0-o|0)>>>0?(f=((z+-1+o|0)>>>0)/(o>>>0)|0,(f|0)!=0):0){z=k[a+72>>2]|0;g=ha(z,(b>>>0)%(f>>>0)|0)|0;k[a+444>>2]=g;g=k[a+60>>2]|0;if(g>>>0<(0-z|0)>>>0?(f=((z+-1+g|0)>>>0)/(z>>>0)|0,(f|0)!=0):0){z=ha((b>>>0)%(f>>>0)|0,o)|0;k[a+488>>2]=z;k[n>>2]=A&-1048577;if(!(A&131072)){k[a+604>>2]=k[a+588>>2];B=k[(k[j>>2]|0)+(b<<3)>>2]|0}else{k[a+604>>2]=0;B=0}k[a+608>>2]=B;i=yb[k[a+512>>2]&127](a,((b>>>0)/((k[a+164>>2]|0)>>>0)|0)&65535)|0;r=c;return i|0}vc(k[a+628>>2]|0,138260,138274,d);i=0;r=c;return i|0}vc(k[a+628>>2]|0,138260,138274,e);i=0;r=c;return i|0}function Bd(a,b,c){a=a|0;b=b|0;c=c|0;return}function Cd(a,b,c){a=a|0;b=b|0;c=c|0;if(!(c&1)){Td(b,(c|0)/2|0);return}else Ja(138285,137683,1059,138299)}function Dd(a,b,c){a=a|0;b=b|0;c=c|0;if(!((c|0)%3|0)){Ud(b,(c|0)/3|0);return}else Ja(138318,137683,1067,138332)}function Ed(a,b,c){a=a|0;b=b|0;c=c|0;if(!(c&3)){Vd(b,(c|0)/4|0);return}else Ja(138351,137683,1075,138365)}function Fd(a,b,c){a=a|0;b=b|0;c=c|0;if(!(c&7)){Yd(b,(c|0)/8|0);return}else Ja(138384,137683,1083,138398)}function Gd(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0;f=r;r=r+64|0;g=f+32|0;h=f+8|0;i=f;if(!(gc(a)|0)){j=-1;r=f;return j|0}l=k[a+12>>2]|0;if(l&131072)Ja(137648,137683,372,138609);if(!(l&2048)){l=a+628|0;m=a+172|0;n=(k[m>>2]|0)+(b<<3)|0;o=xb[k[a+640>>2]&63](k[l>>2]|0,k[n>>2]|0,k[n+4>>2]|0,0)|0;n=(k[m>>2]|0)+(b<<3)|0;if(!((o|0)==(k[n>>2]|0)?(L|0)==(k[n+4>>2]|0):0)){n=k[l>>2]|0;k[i>>2]=k[a+444>>2];k[i+4>>2]=b;vc(n,e,137734,i);j=-1;r=f;return j|0}i=nb[k[a+632>>2]&63](k[l>>2]|0,c,d)|0;if((i|0)==(d|0)){j=d;r=f;return j|0}n=k[l>>2]|0;k[h>>2]=k[a+444>>2];l=h+8|0;k[l>>2]=i;k[l+4>>2]=((i|0)<0)<<31>>31;i=h+16|0;k[i>>2]=d;k[i+4>>2]=((d|0)<0)<<31>>31;vc(n,e,137772,h);j=-1;r=f;return j|0}h=(k[a+172>>2]|0)+(b<<3)|0;n=k[h>>2]|0;i=n+d|0;if(((n|0)==(n|0)?(((n|0)<0)<<31>>31|0)==(k[h+4>>2]|0):0)?(h=k[a+616>>2]|0,(h|0)>=(n|0)):0){if((n|d|0)<0|(i|0)>(h|0)){p=h-n|0;q=13}}else{p=0;q=13}if((q|0)==13?(p|0)!=(d|0):0){q=k[a+628>>2]|0;k[g>>2]=k[a+444>>2];k[g+4>>2]=b;b=g+8|0;k[b>>2]=p;k[b+4>>2]=((p|0)<0)<<31>>31;p=g+16|0;k[p>>2]=d;k[p+4>>2]=((d|0)<0)<<31>>31;vc(q,e,138627,g);j=-1;r=f;return j|0}qe(c,(k[a+612>>2]|0)+n|0,d);j=d;r=f;return j|0}function Hd(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0;f=r;r=r+80|0;g=f+40|0;h=f+16|0;i=f;if(!(gc(a)|0)){j=-1;r=f;return j|0}l=k[a+12>>2]|0;if(l&131072)Ja(137648,137683,684,138417);if(!(l&2048)){l=a+628|0;m=a+172|0;n=(k[m>>2]|0)+(b<<3)|0;o=xb[k[a+640>>2]&63](k[l>>2]|0,k[n>>2]|0,k[n+4>>2]|0,0)|0;n=(k[m>>2]|0)+(b<<3)|0;if(!((o|0)==(k[n>>2]|0)?(L|0)==(k[n+4>>2]|0):0)){n=k[l>>2]|0;o=k[a+488>>2]|0;k[i>>2]=k[a+444>>2];k[i+4>>2]=o;k[i+8>>2]=b;vc(n,e,138434,i);j=-1;r=f;return j|0}i=nb[k[a+632>>2]&63](k[l>>2]|0,c,d)|0;if((i|0)==(d|0)){j=d;r=f;return j|0}n=k[l>>2]|0;l=k[a+488>>2]|0;k[h>>2]=k[a+444>>2];k[h+4>>2]=l;l=h+8|0;k[l>>2]=i;k[l+4>>2]=((i|0)<0)<<31>>31;i=h+16|0;k[i>>2]=d;k[i+4>>2]=((d|0)<0)<<31>>31;vc(n,e,138475,h);j=-1;r=f;return j|0}h=(k[a+172>>2]|0)+(b<<3)|0;n=k[h>>2]|0;i=n+d|0;if(((n|0)==(n|0)?(((n|0)<0)<<31>>31|0)==(k[h+4>>2]|0):0)?(h=k[a+616>>2]|0,(h|0)>=(n|0)):0){if((n|d|0)<0|(i|0)>(h|0)){p=h-n|0;q=13}}else{p=0;q=13}if((q|0)==13?(p|0)!=(d|0):0){q=k[a+628>>2]|0;h=k[a+488>>2]|0;k[g>>2]=k[a+444>>2];k[g+4>>2]=h;k[g+8>>2]=b;b=g+16|0;k[b>>2]=p;k[b+4>>2]=((p|0)<0)<<31>>31;p=g+24|0;k[p>>2]=d;k[p+4>>2]=((d|0)<0)<<31>>31;vc(q,e,138537,g);j=-1;r=f;return j|0}qe(c,(k[a+612>>2]|0)+n|0,d);j=d;r=f;return j|0}function Id(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;d=r;r=r+16|0;e=d;f=(b>>>0)/((k[a+100>>2]|0)>>>0)|0;if((j[a+126>>1]|0)!=2){g=f;r=d;return g|0}b=c&65535;h=j[a+98>>1]|0;if((h&65535)>(c&65535)){g=(ha(k[a+164>>2]|0,b)|0)+f|0;r=d;return g|0}else{f=k[a+628>>2]|0;k[e>>2]=b;k[e+4>>2]=h&65535;vc(f,138696,139539,e);g=0;r=d;return g|0}return 0}function Jd(a){a=a|0;var b=0,c=0,d=0,e=0;b=k[a+100>>2]|0;if((b|0)!=-1){c=k[a+60>>2]|0;if(c>>>0<(0-b|0)>>>0)d=((b+-1+c|0)>>>0)/(b>>>0)|0;else d=0}else d=1;if((j[a+126>>1]|0)!=2){e=d;return e|0}e=Be(a,d,m[a+98>>1]|0,138713)|0;return e|0}function Kd(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0;c=r;r=r+32|0;d=c+16|0;e=c+8|0;f=c;g=c+24|0;if((b|0)==-1)h=k[a+60>>2]|0;else h=b;if(((j[a+126>>1]|0)==1?(j[a+90>>1]|0)==6:0)?(k[a+12>>2]&16384|0)==0:0){if((j[a+98>>1]|0)!=3){vc(k[a+628>>2]|0,138732,138749,f);i=0;l=0;L=i;r=c;return l|0}f=g+2|0;k[e>>2]=g;k[e+4>>2]=f;Ge(a,530,e)|0;e=j[g>>1]|0;a:do switch(e<<16>>16){case 4:case 2:case 1:{g=j[f>>1]|0;switch(g<<16>>16){case 4:case 2:case 1:break;default:{n=g;break a}}b=e&65535;o=g&65535;g=(ha(o,b)|0)+2|0;p=k[a+56>>2]|0;if(p>>>0<(0-b|0)>>>0){q=((b+-1+p|0)>>>0)/(b>>>0)|0;s=0}else{q=0;s=0}if(h>>>0<(0-o|0)>>>0){t=((h+-1+o|0)>>>0)/(o>>>0)|0;u=0}else{t=0;u=0}o=Ce(a,q,s,g&65535,0,138732)|0;g=L;b=a+84|0;p=Ce(a,o,g,m[b>>1]|0,0,138732)|0;v=Ce(a,sr(ur(Ce(a,o,g,m[b>>1]|0,0,138732)|0,L|0,3)|0,L|0,((p&7|0)!=0|0!=0)&1|0,0)|0,L,t,u,138732)|0;i=L;l=v;L=i;r=c;return l|0}default:n=j[f>>1]|0}while(0);f=k[a+628>>2]|0;k[d>>2]=e&65535;k[d+4>>2]=n&65535;vc(f,138732,139754,d);i=0;l=0;L=i;r=c;return l|0}d=Ld(a)|0;f=Ce(a,h,0,d,L,138732)|0;i=L;l=f;L=i;r=c;return l|0}function Ld(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0;b=r;r=r+32|0;c=b+16|0;d=b+8|0;e=b;f=b+20|0;a:do if((j[a+126>>1]|0)==1){g=j[a+98>>1]|0;if(g<<16>>16==3?(j[a+90>>1]|0)==6:0)if(!(k[a+12>>2]&16384)){h=f+2|0;k[e>>2]=f;k[e+4>>2]=h;Ge(a,530,e)|0;i=j[f>>1]|0;b:do switch(i<<16>>16){case 4:case 2:case 1:{l=j[h>>1]|0;switch(l<<16>>16){case 4:case 2:case 1:break;default:break b}n=i&65535;o=(ha(l&65535,n)|0)+2|0;l=k[a+56>>2]|0;if(l>>>0<(0-n|0)>>>0){p=((n+-1+l|0)>>>0)/(n>>>0)|0;q=0}else{p=0;q=0}s=Er(ur(sr(Ce(a,Ce(a,p,q,o&65535,0,138782)|0,L,m[a+84>>1]|0,0,138782)|0,L|0,7,0)|0,L|0,3)|0,L|0,m[h>>1]|0,0)|0;t=L;break a;break}default:{}}while(0);vc(k[a+628>>2]|0,138782,138801,d);u=0;v=0;L=u;r=b;return v|0}else w=3;else w=g;h=Ce(a,k[a+56>>2]|0,0,w&65535,0,138782)|0;i=Ce(a,h,L,m[a+84>>1]|0,0,138782)|0;h=sr(i|0,L|0,7,0)|0;i=ur(h|0,L|0,3)|0;s=i;t=L}else{i=Ce(a,k[a+56>>2]|0,0,m[a+84>>1]|0,0,138782)|0;h=sr(i|0,L|0,7,0)|0;i=ur(h|0,L|0,3)|0;s=i;t=L}while(0);if(!((s|0)==0&(t|0)==0)){u=t;v=s;L=u;r=b;return v|0}vc(k[a+628>>2]|0,138782,138827,c);u=0;v=0;L=u;r=b;return v|0}function Md(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=r;r=r+16|0;d=Kd(a,b)|0;if((d|0)==(d|0)&(((d|0)<0)<<31>>31|0)==(L|0)){e=d;r=c;return e|0}vc(k[a+628>>2]|0,138858,139721,c);e=0;r=c;return e|0}function Nd(a){a=a|0;var b=0,c=0,d=0,e=0,f=0;b=r;r=r+16|0;c=k[a+100>>2]|0;d=k[a+60>>2]|0;e=Kd(a,c>>>0>d>>>0?d:c)|0;if((e|0)==(e|0)&(((e|0)<0)<<31>>31|0)==(L|0)){f=e;r=b;return f|0}vc(k[a+628>>2]|0,138873,139721,b);f=0;r=b;return f|0}function Od(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;if((b|0)>=1){c=b;return c|0}b=Ld(a)|0;a=L;d=(b|0)==0&(a|0)==0;e=Er(8192,0,(d?1:b)|0,(d?0:a)|0)|0;c=(e|0)==0&(L|0)==0?1:e;return c|0}function Pd(a){a=a|0;var b=0,c=0,d=0;b=r;r=r+16|0;c=Ld(a)|0;if((c|0)==(c|0)&(((c|0)<0)<<31>>31|0)==(L|0)){d=c;r=b;return d|0}vc(k[a+628>>2]|0,138887,138904,b);d=0;r=b;return d|0}function Qd(a){a=a|0;var b=0,c=0;b=a+1|0;c=i[b>>0]|0;i[b>>0]=i[a>>0]|0;i[a>>0]=c;return}function Rd(a){a=a|0;var b=0,c=0,d=0;b=a+3|0;c=i[b>>0]|0;i[b>>0]=i[a>>0]|0;i[a>>0]=c;c=a+2|0;b=i[c>>0]|0;d=a+1|0;i[c>>0]=i[d>>0]|0;i[d>>0]=b;return}function Sd(a){a=a|0;var b=0,c=0,d=0;b=a+7|0;c=i[b>>0]|0;i[b>>0]=i[a>>0]|0;i[a>>0]=c;c=a+6|0;b=i[c>>0]|0;d=a+1|0;i[c>>0]=i[d>>0]|0;i[d>>0]=b;b=a+5|0;d=i[b>>0]|0;c=a+2|0;i[b>>0]=i[c>>0]|0;i[c>>0]=d;d=a+4|0;c=i[d>>0]|0;b=a+3|0;i[d>>0]=i[b>>0]|0;i[b>>0]=c;return}function Td(a,b){a=a|0;b=b|0;var c=0,d=0;if((b|0)>0){c=b;d=a}else return;while(1){a=d+1|0;b=i[a>>0]|0;i[a>>0]=i[d>>0]|0;i[d>>0]=b;if((c|0)>1){c=c+-1|0;d=d+2|0}else break}return}function Ud(a,b){a=a|0;b=b|0;var c=0,d=0;if((b|0)>0){c=b;d=a}else return;while(1){a=d+2|0;b=i[a>>0]|0;i[a>>0]=i[d>>0]|0;i[d>>0]=b;if((c|0)>1){c=c+-1|0;d=d+3|0}else break}return}function Vd(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;if((b|0)>0){c=b;d=a}else return;while(1){a=d+3|0;b=i[a>>0]|0;i[a>>0]=i[d>>0]|0;i[d>>0]=b;b=d+2|0;a=i[b>>0]|0;e=d+1|0;i[b>>0]=i[e>>0]|0;i[e>>0]=a;if((c|0)>1){c=c+-1|0;d=d+4|0}else break}return}function Wd(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;if((b|0)>0){c=b;d=a}else return;while(1){a=d+7|0;b=i[a>>0]|0;i[a>>0]=i[d>>0]|0;i[d>>0]=b;b=d+6|0;a=i[b>>0]|0;e=d+1|0;i[b>>0]=i[e>>0]|0;i[e>>0]=a;a=d+5|0;e=i[a>>0]|0;b=d+2|0;i[a>>0]=i[b>>0]|0;i[b>>0]=e;e=d+4|0;b=i[e>>0]|0;a=d+3|0;i[e>>0]=i[a>>0]|0;i[a>>0]=b;if((c|0)>1){c=c+-1|0;d=d+8|0}else break}return}function Xd(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;if((b|0)>0){c=b;d=a}else return;while(1){a=d+3|0;b=i[a>>0]|0;i[a>>0]=i[d>>0]|0;i[d>>0]=b;b=d+2|0;a=i[b>>0]|0;e=d+1|0;i[b>>0]=i[e>>0]|0;i[e>>0]=a;if((c|0)>1){c=c+-1|0;d=d+4|0}else break}return}function Yd(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;if((b|0)>0){c=b;d=a}else return;while(1){a=d+7|0;b=i[a>>0]|0;i[a>>0]=i[d>>0]|0;i[d>>0]=b;b=d+6|0;a=i[b>>0]|0;e=d+1|0;i[b>>0]=i[e>>0]|0;i[e>>0]=a;a=d+5|0;e=i[a>>0]|0;b=d+2|0;i[a>>0]=i[b>>0]|0;i[b>>0]=e;e=d+4|0;b=i[e>>0]|0;a=d+3|0;i[e>>0]=i[a>>0]|0;i[a>>0]=b;if((c|0)>1){c=c+-1|0;d=d+8|0}else break}return}function Zd(a){a=a|0;return ((a|0)!=0?138932:139188)|0}function _d(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,m=0;if((b|0)>8){c=b+-9&-8;d=c+8|0;e=a;f=b;while(1){i[e>>0]=i[138932+(l[e>>0]|0)>>0]|0;g=e+1|0;i[g>>0]=i[138932+(l[g>>0]|0)>>0]|0;g=e+2|0;i[g>>0]=i[138932+(l[g>>0]|0)>>0]|0;g=e+3|0;i[g>>0]=i[138932+(l[g>>0]|0)>>0]|0;g=e+4|0;i[g>>0]=i[138932+(l[g>>0]|0)>>0]|0;g=e+5|0;i[g>>0]=i[138932+(l[g>>0]|0)>>0]|0;g=e+6|0;i[g>>0]=i[138932+(l[g>>0]|0)>>0]|0;g=e+7|0;i[g>>0]=i[138932+(l[g>>0]|0)>>0]|0;f=f+-8|0;if((f|0)<=8)break;else e=e+8|0}h=b+-8-c|0;j=a+d|0}else{h=b;j=a}if((h|0)>0){k=j;m=h}else return;while(1){i[k>>0]=i[138932+(l[k>>0]|0)>>0]|0;if((m|0)>1){k=k+1|0;m=m+-1|0}else break}return}function $d(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;f=k[a+68>>2]|0;g=k[a+72>>2]|0;h=k[a+76>>2]|0;i=k[a+64>>2]|0;l=(i|0)==1?0:d;if((f|0)==-1)m=k[a+56>>2]|0;else m=f;if((g|0)==-1)n=k[a+60>>2]|0;else n=g;g=(h|0)==-1?i:h;if(!((m|0)!=0&(n|0)!=0&(g|0)!=0)){o=1;return o|0}h=k[a+56>>2]|0;if(h>>>0<(0-m|0)>>>0)p=((m+-1+h|0)>>>0)/(m>>>0)|0;else p=0;h=k[a+60>>2]|0;if(h>>>0<(0-n|0)>>>0)q=((n+-1+h|0)>>>0)/(n>>>0)|0;else q=0;if(i>>>0<(0-g|0)>>>0)r=((g+-1+i|0)>>>0)/(g>>>0)|0;else r=0;i=ha(q,p)|0;if((j[a+126>>1]|0)==2){o=((b>>>0)/(m>>>0)|0)+(ha((c>>>0)/(n>>>0)|0,p)|0)+(ha(((l>>>0)/(g>>>0)|0)+(ha(r,e&65535)|0)|0,i)|0)|0;return o|0}else{o=(ha((c>>>0)/(n>>>0)|0,p)|0)+(ha((l>>>0)/(g>>>0)|0,i)|0)+((b>>>0)/(m>>>0)|0)|0;return o|0}return 0}function ae(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,l=0,m=0,n=0,o=0,p=0;f=r;r=r+32|0;g=f+24|0;h=f+16|0;i=f+8|0;l=f;m=k[a+56>>2]|0;if(m>>>0<=b>>>0){n=k[a+628>>2]|0;o=k[a>>2]|0;k[l>>2]=b;k[l+4>>2]=m+-1;vc(n,o,139444,l);p=0;r=f;return p|0}l=k[a+60>>2]|0;if(l>>>0<=c>>>0){o=k[a+628>>2]|0;n=k[a>>2]|0;k[i>>2]=c;k[i+4>>2]=l+-1;vc(o,n,139475,i);p=0;r=f;return p|0}i=k[a+64>>2]|0;if(i>>>0<=d>>>0){n=k[a+628>>2]|0;o=k[a>>2]|0;k[h>>2]=d;k[h+4>>2]=i+-1;vc(n,o,139506,h);p=0;r=f;return p|0}if((j[a+126>>1]|0)!=2){p=1;r=f;return p|0}h=j[a+98>>1]|0;if((h&65535)>(e&65535)){p=1;r=f;return p|0}o=k[a+628>>2]|0;n=k[a>>2]|0;k[g>>2]=e&65535;k[g+4>>2]=(h&65535)+-1;vc(o,n,139539,g);p=0;r=f;return p|0}function be(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0;b=k[a+68>>2]|0;c=k[a+72>>2]|0;d=k[a+76>>2]|0;if((b|0)==-1)e=k[a+56>>2]|0;else e=b;if((c|0)==-1)f=k[a+60>>2]|0;else f=c;if((d|0)==-1)g=k[a+64>>2]|0;else g=d;if((e|0)==0|(f|0)==0|(g|0)==0)h=0;else{d=k[a+56>>2]|0;if(d>>>0<(0-e|0)>>>0)i=((e+-1+d|0)>>>0)/(e>>>0)|0;else i=0;e=k[a+60>>2]|0;if(e>>>0<(0-f|0)>>>0)l=((f+-1+e|0)>>>0)/(f>>>0)|0;else l=0;f=Be(a,i,l,139573)|0;l=k[a+64>>2]|0;if(l>>>0<(0-g|0)>>>0)n=((g+-1+l|0)>>>0)/(g>>>0)|0;else n=0;h=Be(a,f,n,139573)|0}if((j[a+126>>1]|0)!=2){o=h;return o|0}o=Be(a,h,m[a+98>>1]|0,139573)|0;return o|0}function ce(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0;b=r;r=r+32|0;c=b+24|0;d=b+16|0;if(!(k[a+72>>2]|0)){vc(k[a+628>>2]|0,139591,139609,b);e=0;f=0;L=e;r=b;return f|0}g=k[a+68>>2]|0;if(!g){vc(k[a+628>>2]|0,139591,139629,b+8|0);e=0;f=0;L=e;r=b;return f|0}h=Ce(a,m[a+84>>1]|0,0,g,0,139648)|0;g=L;do if((j[a+126>>1]|0)==1){i=j[a+98>>1]|0;if(i<<16>>16){l=Ce(a,h,g,i&65535,0,139648)|0;n=l;o=L;break}vc(k[a+628>>2]|0,139591,139664,d);e=0;f=0;L=e;r=b;return f|0}else{n=h;o=g}while(0);g=ur(n|0,o|0,3)|0;o=sr(((n&7|0)!=0|0!=0)&1|0,0,g|0,L|0)|0;g=L;if(!((o|0)==0&(g|0)==0)){e=g;f=o;L=e;r=b;return f|0}vc(k[a+628>>2]|0,139591,139690,c);e=0;f=0;L=e;r=b;return f|0}function de(a){a=a|0;var b=0,c=0,d=0;b=r;r=r+16|0;c=ce(a)|0;if((c|0)==(c|0)&(((c|0)<0)<<31>>31|0)==(L|0)){d=c;r=b;return d|0}vc(k[a+628>>2]|0,139648,139721,b);d=0;r=b;return d|0}function ee(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0;c=r;r=r+32|0;d=c+8|0;e=c;f=c+16|0;if(!(k[a+72>>2]|0)){g=0;h=0;L=g;r=c;return h|0}i=a+68|0;if(!(k[i>>2]|0)){g=0;h=0;L=g;r=c;return h|0}if(!(k[a+76>>2]|0)){g=0;h=0;L=g;r=c;return h|0}if((((j[a+126>>1]|0)==1?(j[a+90>>1]|0)==6:0)?(j[a+98>>1]|0)==3:0)?(k[a+12>>2]&16384|0)==0:0){l=f+2|0;k[e>>2]=f;k[e+4>>2]=l;Ge(a,530,e)|0;e=j[f>>1]|0;a:do switch(e<<16>>16){case 4:case 2:case 1:{f=j[l>>1]|0;switch(f<<16>>16){case 4:case 2:case 1:break;default:{n=f;break a}}o=e&65535;p=f&65535;f=(ha(p,o)|0)+2|0;q=k[i>>2]|0;if(q>>>0<(0-o|0)>>>0){s=((o+-1+q|0)>>>0)/(o>>>0)|0;t=0}else{s=0;t=0}if(b>>>0<(0-p|0)>>>0){u=((b+-1+p|0)>>>0)/(p>>>0)|0;v=0}else{u=0;v=0}p=Ce(a,s,t,f&65535,0,139738)|0;f=L;o=a+84|0;q=Ce(a,p,f,m[o>>1]|0,0,139738)|0;w=Ce(a,sr(ur(Ce(a,p,f,m[o>>1]|0,0,139738)|0,L|0,3)|0,L|0,((q&7|0)!=0|0!=0)&1|0,0)|0,L,u,v,139738)|0;g=L;h=w;L=g;r=c;return h|0}default:n=j[l>>1]|0}while(0);l=k[a+628>>2]|0;k[d>>2]=e&65535;k[d+4>>2]=n&65535;vc(l,139738,139754,d);g=0;h=0;L=g;r=c;return h|0}d=ce(a)|0;l=Ce(a,b,0,d,L,139738)|0;g=L;h=l;L=g;r=c;return h|0}function fe(a){a=a|0;var b=0;b=ee(a,k[a+72>>2]|0)|0;return b|0}function ge(a){a=a|0;var b=0,c=0,d=0;b=r;r=r+16|0;c=ee(a,k[a+72>>2]|0)|0;if((c|0)==(c|0)&(((c|0)<0)<<31>>31|0)==(L|0)){d=c;r=b;return d|0}vc(k[a+628>>2]|0,139788,139721,b);d=0;r=b;return d|0}function he(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;a=k[b>>2]|0;if((a|0)<1){k[b>>2]=256;d=256}else d=a;a=k[c>>2]|0;if((a|0)<1){k[c>>2]=256;e=256;f=k[b>>2]|0}else{e=a;f=d}if(!(f&15))g=e;else{k[b>>2]=f>>>0<4294967280?f+15&-16:0;g=k[c>>2]|0}if(!(g&15))return;k[c>>2]=g>>>0<4294967280?g+15&-16:0;return}function ie(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=r;r=r+16|0;f=e;k[f>>2]=d;d=k[1933]|0;if(d)vb[d&127](b,c,f);d=k[1932]|0;if(!d){r=e;return}Ab[d&31](a,b,c,f);r=e;return}function je(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;b=a+608|0;c=k[b>>2]|0;if((c|0)<=0){d=1;return d|0}e=a+12|0;f=k[e>>2]|0;if(!(f&1048576)){d=1;return d|0}g=a+588|0;if(!((m[a+94>>1]|0|256)&f)){_d(k[g>>2]|0,c);h=k[e>>2]|0;i=k[b>>2]|0}else{h=f;i=c}if(!(ke(a,k[((h&1024|0)==0?a+452|0:a+492|0)>>2]|0,k[g>>2]|0,i)|0)){d=0;return d|0}k[b>>2]=0;k[a+604>>2]=k[g>>2];d=1;return d|0}function ke(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;e=r;r=r+32|0;f=e+16|0;g=e+8|0;h=e;i=a+172|0;j=(k[i>>2]|0)+(b<<3)|0;l=k[j>>2]|0;m=k[j+4>>2]|0;j=(l|0)==0&(m|0)==0;if(!j?(n=a+456|0,o=n,p=k[o>>2]|0,q=k[o+4>>2]|0,!((p|0)==0&(q|0)==0)):0){s=n;t=p;u=q;v=-1;w=-1}else{if(!(k[a+168>>2]|0))Ja(139801,139820,690,139832);q=a+176|0;p=(k[q>>2]|0)+(b<<3)|0;n=k[p>>2]|0;o=k[p+4>>2]|0;if(!((n|0)==0&(o|0)==0)?(p=((d|0)<0)<<31>>31,!(o>>>0<p>>>0|(o|0)==(p|0)&n>>>0<d>>>0|j)):0){j=a+628|0;n=xb[k[a+640>>2]&63](k[j>>2]|0,l,m,0)|0;m=L;l=(k[i>>2]|0)+(b<<3)|0;if((n|0)==(k[l>>2]|0)?(m|0)==(k[l+4>>2]|0):0){x=n;y=m}else{m=k[j>>2]|0;k[h>>2]=k[a+444>>2];vc(m,139832,139850,h);z=0;r=e;return z|0}}else{h=xb[k[a+640>>2]&63](k[a+628>>2]|0,0,0,2)|0;m=L;j=(k[i>>2]|0)+(b<<3)|0;k[j>>2]=h;k[j+4>>2]=m;j=a+12|0;k[j>>2]=k[j>>2]|2097152;x=h;y=m}m=a+456|0;h=m;k[h>>2]=x;k[h+4>>2]=y;y=(k[q>>2]|0)+(b<<3)|0;q=y;h=k[q>>2]|0;x=k[q+4>>2]|0;q=y;k[q>>2]=0;k[q+4>>2]=0;q=m;s=m;t=k[q>>2]|0;u=k[q+4>>2]|0;v=h;w=x}x=((d|0)<0)<<31>>31;h=sr(t|0,u|0,d|0,x|0)|0;q=a+12|0;m=(k[q>>2]&524288|0)==0;y=m?h:h;h=m?0:L;if(h>>>0<u>>>0|(h|0)==(u|0)&y>>>0<t>>>0|(h>>>0<x>>>0|(h|0)==(x|0)&y>>>0<d>>>0)){vc(k[a+628>>2]|0,139832,142108,g);z=0;r=e;return z|0}g=a+628|0;if((nb[k[a+636>>2]&63](k[g>>2]|0,c,d)|0)!=(d|0)){c=k[g>>2]|0;k[f>>2]=k[a+444>>2];vc(c,139832,139877,f);z=0;r=e;return z|0}f=s;k[f>>2]=y;k[f+4>>2]=h;h=(k[a+176>>2]|0)+(b<<3)|0;b=h;a=sr(k[b>>2]|0,k[b+4>>2]|0,d|0,x|0)|0;x=L;d=h;k[d>>2]=a;k[d+4>>2]=x;if((a|0)==(v|0)&(x|0)==(w|0)){z=1;r=e;return z|0}k[q>>2]=k[q>>2]|2097152;z=1;r=e;return z|0}function le(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;c=r;r=r+32|0;d=c+16|0;e=c+8|0;f=c;g=od(b,139905)|0;if((g|0)==-1){h=0;r=c;return h|0}k[f>>2]=438;i=Pp(a,g,f)|0;if((i|0)>=0){f=pd(a,b,i,8,9,5,2,3,10,2)|0;if(!f){Tq(i)|0;h=0;r=c;return h|0}else{k[f+4>>2]=i;h=f;r=c;return h|0}}f=Np()|0;i=k[f>>2]|0;if((i|0)>0?(Op(i)|0)!=0:0){i=Op(k[f>>2]|0)|0;k[e>>2]=a;k[e+4>>2]=i;vc(0,139905,139914,e);h=0;r=c;return h|0}k[d>>2]=a;vc(0,139905,139921,d);h=0;r=c;return h|0}function me(a){a=a|0;var b=0;if(!a)b=0;else b=jr(a)|0;return b|0}function ne(a){a=a|0;kr(a);return}function oe(a,b){a=a|0;b=b|0;return lr(a,b)|0}function pe(a,b,c){a=a|0;b=b|0;c=c|0;qr(a|0,b&255|0,c|0)|0;return}function qe(a,b,c){a=a|0;b=b|0;c=c|0;wr(a|0,b|0,c|0)|0;return}function re(a,b,c){a=a|0;b=b|0;c=c|0;return Lq(a,b,c)|0}function se(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=a;if(!c){e=-1;return e|0}else f=0;while(1){a=c-f|0;g=Vq(d,b+f|0,(a|0)<0?2147483647:a)|0;if((g|0)<1){h=g;i=f;break}a=g+f|0;if(a>>>0<c>>>0)f=a;else{h=g;i=a;break}}e=(h|0)<0?-1:i;return e|0}function te(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=a;if(!c){e=-1;return e|0}else f=0;while(1){a=c-f|0;g=Wq(d,b+f|0,(a|0)<0?2147483647:a)|0;if((g|0)<1){h=g;i=f;break}a=g+f|0;if(a>>>0<c>>>0)f=a;else{h=g;i=a;break}}e=(h|0)<0?-1:i;return e|0}function ue(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;if((b|0)==(b|0)&(((b|0)<0)<<31>>31|0)==(c|0)){c=Uq(a,b,d)|0;e=((c|0)<0)<<31>>31;f=c;L=e;return f|0}else{c=Np()|0;k[c>>2]=22;e=-1;f=-1;L=e;return f|0}return 0}function ve(a){a=a|0;return Tq(a)|0}function we(a){a=a|0;var b=0,c=0,d=0;b=r;r=r+80|0;c=b;d=(jq(a,c)|0)<0;a=k[c+36>>2]|0;L=d?0:((a|0)<0)<<31>>31;r=b;return (d?0:a)|0}function xe(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=r;r=r+80|0;e=d;f=a;a=(jq(f,e)|0)<0;g=k[e+36>>2]|0;e=a?0:g;h=a?0:((g|0)<0)<<31>>31;if(!((e|0)==(e|0)&(((e|0)<0)<<31>>31|0)==(h|0))){i=0;r=d;return i|0}g=cq(0,e,1,1,f,0)|0;k[b>>2]=g;if((g|0)==(-1|0)){i=0;r=d;return i|0}g=c;k[g>>2]=e;k[g+4>>2]=h;i=1;r=d;return i|0}function ye(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;dq(b,c)|0;return}function ze(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;d=r;r=r+16|0;e=d;f=k[30710]|0;if(a){k[e>>2]=a;wq(f,139937,e)|0}zq(139945,9,1,f)|0;Dq(f,b,c)|0;zq(139942,2,1,f)|0;r=d;return}function Ae(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;d=r;r=r+16|0;e=d;f=k[30710]|0;if(a){k[e>>2]=a;wq(f,139937,e)|0}Dq(f,b,c)|0;zq(139942,2,1,f)|0;r=d;return}function Be(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;e=r;r=r+16|0;f=e;g=ha(c,b)|0;if((c|0)!=0?((g>>>0)/(c>>>0)|0|0)!=(b|0):0){b=k[a+628>>2]|0;k[f>>2]=d;vc(b,d,139955,f);h=0}else h=g;r=e;return h|0}function Ce(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,l=0,m=0,n=0;g=r;r=r+16|0;h=g;i=Dr(d|0,e|0,b|0,c|0)|0;j=L;if(!((d|0)==0&(e|0)==0)?(l=Er(i|0,j|0,d|0,e|0)|0,!((l|0)==(b|0)&(L|0)==(c|0))):0){c=k[a+628>>2]|0;k[h>>2]=f;vc(c,f,139955,h);m=0;n=0}else{m=j;n=i}L=m;r=g;return n|0}function De(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=r;r=r+16|0;g=f;if((c|0)!=0&(d|0)!=0?(h=oe(b,ha(d,c)|0)|0,(h|0)!=0):0){i=h;r=f;return i|0}h=k[a+628>>2]|0;b=k[a>>2]|0;k[g>>2]=e;k[g+4>>2]=c;k[g+8>>2]=d;vc(h,b,139978,g);i=0;r=f;return i|0}function Ee(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e=r;r=r+16|0;f=e;if((b|0)!=0&(c|0)!=0?(g=oe(0,ha(c,b)|0)|0,(g|0)!=0):0){h=g;r=e;return h|0}g=k[a+628>>2]|0;i=k[a>>2]|0;k[f>>2]=d;k[f+4>>2]=b;k[f+8>>2]=c;vc(g,i,139978,f);h=0;r=e;return h|0}
function Qf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0,Xb=0,Yb=0,Zb=0,_b=0,$b=0,ac=0,bc=0,cc=0,dc=0,ec=0,fc=0,gc=0,hc=0,ic=0,jc=0,kc=0,lc=0,mc=0,nc=0,oc=0,pc=0,qc=0,rc=0,sc=0,tc=0,uc=0,wc=0,xc=0,yc=0,zc=0,Ac=0,Bc=0,Cc=0,Dc=0,Ec=0,Fc=0,Gc=0,Hc=0,Ic=0,Jc=0,Kc=0,Lc=0,Mc=0,Nc=0,Oc=0,Pc=0,Qc=0,Rc=0,Sc=0,Tc=0,Uc=0,Vc=0,Wc=0,Xc=0,Yc=0,Zc=0,_c=0,$c=0,ad=0,bd=0,cd=0,dd=0,ed=0,fd=0,gd=0,hd=0,id=0,jd=0,kd=0,ld=0,md=0,nd=0,od=0,pd=0,qd=0,rd=0,sd=0,td=0,ud=0,vd=0,wd=0,xd=0,yd=0,zd=0,Ad=0,Bd=0,Cd=0,Dd=0,Ed=0,Fd=0,Gd=0,Hd=0,Id=0,Jd=0,Kd=0,Ld=0,Md=0,Nd=0,Od=0,Pd=0,Qd=0,Rd=0,Sd=0,Td=0,Ud=0,Vd=0,Wd=0,Xd=0,Yd=0,Zd=0,_d=0,$d=0,ae=0,be=0,ce=0,de=0,ee=0,fe=0,ge=0,he=0,je=0,ke=0,le=0,me=0,ne=0,oe=0,pe=0,qe=0,re=0,se=0,te=0,ue=0,ve=0,we=0,xe=0,ye=0,ze=0,Ae=0,Be=0,Ce=0,De=0,Ee=0,Fe=0,Ge=0,He=0,Ie=0,Je=0,Ke=0,Le=0,Me=0,Ne=0,Oe=0,Pe=0,Qe=0,Re=0,Se=0,Te=0,Ue=0,Ve=0,We=0,Xe=0,Ye=0,Ze=0,_e=0,$e=0,af=0,bf=0,cf=0,df=0,ef=0,ff=0,gf=0,hf=0,jf=0,kf=0,lf=0,mf=0,nf=0,of=0,pf=0,qf=0,rf=0,sf=0,tf=0,uf=0,vf=0,wf=0,xf=0,yf=0,zf=0,Af=0,Bf=0,Cf=0,Df=0,Ef=0,Ff=0,Gf=0,Hf=0,If=0,Jf=0,Kf=0,Lf=0,Mf=0,Nf=0,Of=0,Pf=0,Qf=0,Rf=0,Sf=0,Tf=0,Uf=0,Vf=0;d=r;r=r+288|0;e=d+264|0;f=d+240|0;g=d+216|0;h=d+200|0;i=d+184|0;j=d+168|0;m=d+152|0;n=d+136|0;o=d+120|0;p=d+104|0;q=d+80|0;s=d+56|0;t=d+40|0;u=d+24|0;v=d+8|0;w=k[a+576>>2]|0;x=k[w+12>>2]|0;y=k[w+44>>2]|0;z=w+8|0;if((c|0)%(k[z>>2]|0)|0){vc(k[a+628>>2]|0,144240,153793,d);A=-1;r=d;return A|0}B=w+48|0;C=k[B>>2]|0;D=w+52|0;E=k[D>>2]|0;F=w+56|0;G=k[F>>2]|0;H=a+604|0;I=k[H>>2]|0;J=a+608|0;K=k[J>>2]|0;L=I+K|0;a:do if((c|0)>0){M=w+72|0;N=w+68|0;O=(x|0)>0;P=w+92|0;Q=a+628|0;R=a+12|0;S=a+492|0;T=a+452|0;U=w+60|0;V=b;W=c;X=k[M>>2]|0;Y=C;Z=E;_=G;$=I;b:while(1){c:do if(!_){aa=Y;ba=Z;ca=$;while(1){do if((ba|0)<11){if(ca>>>0>=L>>>0)if(!ba){da=V;ea=X;fa=aa;ga=0;ha=ca;ia=186;break b}else{ja=aa;ka=11;la=ca;break}ma=ca+1|0;na=(l[y+(l[ca>>0]|0)>>0]|0)<<ba|aa;oa=ba+8|0;if((oa|0)<11)if(ma>>>0<L>>>0){ja=(l[y+(l[ma>>0]|0)>>0]|0)<<oa|na;ka=ba+16|0;la=ca+2|0}else{ja=na;ka=11;la=ma}else{ja=na;ka=oa;la=ma}}else{ja=aa;ka=ba;la=ca}while(0);if(!(ja&2047)){pa=ja;qa=ka;ra=la;break c}aa=ja>>>1;ba=ka+-1|0;ca=la}}else{pa=Y;qa=Z;ra=$}while(0);while(1){do if((qa|0)<8)if(ra>>>0>=L>>>0)if(!qa){da=V;ea=X;fa=pa;ga=_;ha=ra;ia=186;break b}else{sa=pa;ta=8;ua=ra;break}else{sa=(l[y+(l[ra>>0]|0)>>0]|0)<<qa|pa;ta=qa+8|0;ua=ra+1|0;break}else{sa=pa;ta=qa;ua=ra}while(0);if(sa&255){va=sa;wa=ta;xa=ua;break}pa=sa>>>8;qa=ta+-8|0;ra=ua}ca=va;ba=wa;while(1){aa=ba+-1|0;ma=ca>>>1;if(!(ca&1)){ca=ma;ba=aa}else{ya=aa;za=ma;Aa=ba;break}}do if((Aa|0)<2)if(xa>>>0>=L>>>0)if(!ya){da=V;ea=X;fa=za;ga=0;ha=xa;ia=186;break b}else{Ba=za;Ca=1;Da=xa;break}else{Ba=(l[y+(l[xa>>0]|0)>>0]|0)<<ya|za;Ca=Aa+7|0;Da=xa+1|0;break}else{Ba=za;Ca=ya;Da=xa}while(0);ba=Ca+-1|0;ca=Ba>>>1;ma=k[N>>2]|0;aa=ma+4|0;oa=k[ma>>2]|0;do if(!(Ba&1)){d:do if(O){ma=X;na=ca;Ea=ba;Fa=0;Ga=0;Ha=oa;Ia=Da;Ja=X;Ka=aa;e:while(1){La=(Ja|0)==(X|0);f:do if(La){Ma=na;Na=Ea;Oa=0;Pa=Fa;Qa=Ga;Ra=Ha;Sa=Ia;Ta=Ka;while(1){do if((Na|0)<7)if(Sa>>>0>=L>>>0)if(!Na){Ua=V;Va=X;Wa=Ma;Xa=0;Ya=Oa;Za=Qa;_a=Sa;$a=X;ia=154;break b}else{ab=Ma;bb=7;cb=Sa;break}else{ab=(l[y+(l[Sa>>0]|0)>>0]|0)<<Na|Ma;bb=Na+8|0;cb=Sa+1|0;break}else{ab=Ma;bb=Na;cb=Sa}while(0);db=ab&127;eb=l[8280+(db<<3)+1>>0]|0;fb=bb-eb|0;gb=ab>>>eb;switch(l[8280+(db<<3)>>0]|0|0){case 6:{hb=fb;ib=gb;jb=Oa;kb=Qa;lb=cb;mb=X;ia=143;break e;break}case 12:{nb=eb;ob=fb;pb=gb;qb=bb;rb=Oa;sb=Qa;tb=cb;ub=X;ia=144;break e;break}case 2:{vb=fb;wb=gb;xb=Oa;yb=Qa;zb=Ra;Bb=cb;Cb=Ta;ia=88;break f;break}case 3:{Db=fb;Eb=gb;Fb=Oa;Gb=Qa;Hb=Pa;Ib=Ra;Jb=cb;Kb=Ta;ia=128;break f;break}case 4:{Lb=db;Mb=fb;Nb=gb;Ob=Oa;Pb=Qa;Qb=Pa;Rb=Ra;Sb=cb;Tb=Ta;ia=132;break f;break}case 5:{Ub=db;Vb=fb;Wb=gb;Xb=Oa;Yb=Qa;Zb=Ra;_b=cb;$b=Ta;ia=136;break f;break}case 1:break;default:{ac=gb;bc=fb;cc=Oa;dc=Qa;ec=cb;fc=X;ia=151;break e}}db=(k[Ta>>2]|0)+Ra|0;eb=Pa+Oa+db|0;if((x|0)>(db|0)){Ma=gb;Na=fb;Oa=eb;Pa=0-db|0;Qa=db;Ra=db+(k[Ta+4>>2]|0)|0;Sa=cb;Ta=Ta+8|0}else{gc=gb;hc=fb;ic=eb;jc=db;kc=cb;lc=X;ia=165;break e}}}else{Ta=na;Sa=Ea;Ra=0;Qa=Fa;Pa=Ga;Oa=Ha;Na=Ia;Ma=Ka;while(1){do if((Sa|0)<7)if(Na>>>0>=L>>>0)if(!Sa){Ua=V;Va=X;Wa=Ta;Xa=0;Ya=Ra;Za=Pa;_a=Na;$a=Ja;ia=154;break b}else{mc=Ta;nc=7;oc=Na;break}else{mc=(l[y+(l[Na>>0]|0)>>0]|0)<<Sa|Ta;nc=Sa+8|0;oc=Na+1|0;break}else{mc=Ta;nc=Sa;oc=Na}while(0);db=mc&127;eb=l[8280+(db<<3)+1>>0]|0;fb=nc-eb|0;gb=mc>>>eb;switch(l[8280+(db<<3)>>0]|0|0){case 6:{hb=fb;ib=gb;jb=Ra;kb=Pa;lb=oc;mb=Ja;ia=143;break e;break}case 12:{nb=eb;ob=fb;pb=gb;qb=nc;rb=Ra;sb=Pa;tb=oc;ub=Ja;ia=144;break e;break}case 2:{vb=fb;wb=gb;xb=Ra;yb=Pa;zb=Oa;Bb=oc;Cb=Ma;ia=88;break f;break}case 3:{Db=fb;Eb=gb;Fb=Ra;Gb=Pa;Hb=Qa;Ib=Oa;Jb=oc;Kb=Ma;ia=128;break f;break}case 4:{Lb=db;Mb=fb;Nb=gb;Ob=Ra;Pb=Pa;Qb=Qa;Rb=Oa;Sb=oc;Tb=Ma;ia=132;break f;break}case 5:{Ub=db;Vb=fb;Wb=gb;Xb=Ra;Yb=Pa;Zb=Oa;_b=oc;$b=Ma;ia=136;break f;break}case 1:break;default:{ac=gb;bc=fb;cc=Ra;dc=Pa;ec=oc;fc=Ja;ia=151;break e}}if((Oa|0)<=(Pa|0)&(Oa|0)<(x|0)){db=Oa;eb=Ma;while(1){pc=(k[eb>>2]|0)+db+(k[eb+4>>2]|0)|0;qc=eb+8|0;if((pc|0)<=(Pa|0)&(pc|0)<(x|0)){db=pc;eb=qc}else{rc=pc;sc=qc;break}}}else{rc=Oa;sc=Ma}eb=(k[sc>>2]|0)+rc|0;db=Qa+Ra+eb|0;if((x|0)>(eb|0)){Ta=gb;Sa=fb;Ra=db;Qa=0-eb|0;Pa=eb;Oa=eb+(k[sc+4>>2]|0)|0;Na=oc;Ma=sc+8|0}else{gc=gb;hc=fb;ic=db;jc=eb;kc=oc;lc=Ja;ia=165;break e}}}while(0);if((ia|0)==88){ia=0;if(!(Ja-ma&4)){Ma=wb;Na=vb;Oa=xb;Pa=yb;Qa=Bb;g:while(1){do if((Na|0)<12){if(Qa>>>0>=L>>>0)if(!Na){Ua=V;Va=X;Wa=Ma;Xa=0;Ya=Oa;Za=Pa;_a=Qa;$a=Ja;ia=154;break b}else{tc=Ma;uc=12;wc=Qa;break}Ra=Qa+1|0;Sa=(l[y+(l[Qa>>0]|0)>>0]|0)<<Na|Ma;Ta=Na+8|0;if((Ta|0)<12){if(Ra>>>0>=L>>>0){tc=Sa;uc=12;wc=Ra;break}tc=(l[y+(l[Ra>>0]|0)>>0]|0)<<Ta|Sa;uc=Na+16|0;wc=Qa+2|0}else{tc=Sa;uc=Ta;wc=Ra}}else{tc=Ma;uc=Na;wc=Qa}while(0);Ra=tc&4095;Ta=l[9304+(Ra<<3)+1>>0]|0;Sa=uc-Ta|0;eb=tc>>>Ta;switch(l[9304+(Ra<<3)>>0]|0|0){case 7:{xc=Ra;yc=Sa;zc=eb;Ac=Oa;Bc=Pa;Cc=wc;break g;break}case 11:case 9:break;default:{Dc=eb;Ec=Sa;Fc=Oa;Gc=Pa;Hc=wc;Ic=Ja;ia=153;break e}}Ta=k[9304+(Ra<<3)+4>>2]|0;Ma=eb;Na=Sa;Oa=Ta+Oa|0;Pa=Ta+Pa|0;Qa=wc}Qa=k[9304+(xc<<3)+4>>2]|0;Pa=Ja+4|0;k[Ja>>2]=Qa+Ac;Oa=zc;Na=yc;Ma=0;Ta=Qa+Bc|0;Qa=Cc;h:while(1){do if((Na|0)<13){if(Qa>>>0>=L>>>0)if(!Na){Ua=V;Va=X;Wa=Oa;Xa=0;Ya=Ma;Za=Ta;_a=Qa;$a=Pa;ia=154;break b}else{Jc=Oa;Kc=13;Lc=Qa;break}Sa=Qa+1|0;eb=(l[y+(l[Qa>>0]|0)>>0]|0)<<Na|Oa;Ra=Na+8|0;if((Ra|0)<13){if(Sa>>>0>=L>>>0){Jc=eb;Kc=13;Lc=Sa;break}Jc=(l[y+(l[Sa>>0]|0)>>0]|0)<<Ra|eb;Kc=Na+16|0;Lc=Qa+2|0}else{Jc=eb;Kc=Ra;Lc=Sa}}else{Jc=Oa;Kc=Na;Lc=Qa}while(0);Sa=Jc&8191;Ra=l[42072+(Sa<<3)+1>>0]|0;eb=Kc-Ra|0;db=Jc>>>Ra;switch(l[42072+(Sa<<3)>>0]|0|0){case 8:{Mc=Sa;Nc=eb;Oc=db;Pc=Ma;Qc=Ta;Rc=Lc;break h;break}case 11:case 10:break;default:{Sc=db;Tc=eb;Uc=Ma;Vc=Ta;Wc=Lc;Xc=Pa;ia=152;break e}}Ra=k[42072+(Sa<<3)+4>>2]|0;Oa=db;Na=eb;Ma=Ra+Ma|0;Ta=Ra+Ta|0;Qa=Lc}Qa=k[42072+(Mc<<3)+4>>2]|0;k[Pa>>2]=Qa+Pc;Yc=Oc;Zc=Nc;_c=Qa+Qc|0;$c=Rc}else{Qa=wb;Ta=vb;Ma=xb;Na=yb;Oa=Bb;i:while(1){do if((Ta|0)<13){if(Oa>>>0>=L>>>0)if(!Ta){Ua=V;Va=X;Wa=Qa;Xa=0;Ya=Ma;Za=Na;_a=Oa;$a=Ja;ia=154;break b}else{ad=Qa;bd=13;cd=Oa;break}Ra=Oa+1|0;eb=(l[y+(l[Oa>>0]|0)>>0]|0)<<Ta|Qa;db=Ta+8|0;if((db|0)<13){if(Ra>>>0>=L>>>0){ad=eb;bd=13;cd=Ra;break}ad=(l[y+(l[Ra>>0]|0)>>0]|0)<<db|eb;bd=Ta+16|0;cd=Oa+2|0}else{ad=eb;bd=db;cd=Ra}}else{ad=Qa;bd=Ta;cd=Oa}while(0);Ra=ad&8191;db=l[42072+(Ra<<3)+1>>0]|0;eb=bd-db|0;Sa=ad>>>db;switch(l[42072+(Ra<<3)>>0]|0|0){case 8:{dd=Ra;ed=eb;fd=Sa;gd=Ma;hd=Na;id=cd;break i;break}case 11:case 10:break;default:{Sc=Sa;Tc=eb;Uc=Ma;Vc=Na;Wc=cd;Xc=Ja;ia=152;break e}}db=k[42072+(Ra<<3)+4>>2]|0;Qa=Sa;Ta=eb;Ma=db+Ma|0;Na=db+Na|0;Oa=cd}Oa=k[42072+(dd<<3)+4>>2]|0;Na=Ja+4|0;k[Ja>>2]=Oa+gd;Ma=fd;Ta=ed;Qa=0;Pa=Oa+hd|0;Oa=id;j:while(1){do if((Ta|0)<12){if(Oa>>>0>=L>>>0)if(!Ta){Ua=V;Va=X;Wa=Ma;Xa=0;Ya=Qa;Za=Pa;_a=Oa;$a=Na;ia=154;break b}else{jd=Ma;kd=12;ld=Oa;break}db=Oa+1|0;eb=(l[y+(l[Oa>>0]|0)>>0]|0)<<Ta|Ma;Sa=Ta+8|0;if((Sa|0)<12){if(db>>>0>=L>>>0){jd=eb;kd=12;ld=db;break}jd=(l[y+(l[db>>0]|0)>>0]|0)<<Sa|eb;kd=Ta+16|0;ld=Oa+2|0}else{jd=eb;kd=Sa;ld=db}}else{jd=Ma;kd=Ta;ld=Oa}while(0);db=jd&4095;Sa=l[9304+(db<<3)+1>>0]|0;eb=kd-Sa|0;Ra=jd>>>Sa;switch(l[9304+(db<<3)>>0]|0|0){case 7:{md=db;nd=eb;od=Ra;pd=Qa;qd=Pa;rd=ld;break j;break}case 11:case 9:break;default:{Dc=Ra;Ec=eb;Fc=Qa;Gc=Pa;Hc=ld;Ic=Na;ia=153;break e}}Sa=k[9304+(db<<3)+4>>2]|0;Ma=Ra;Ta=eb;Qa=Sa+Qa|0;Pa=Sa+Pa|0;Oa=ld}Oa=k[9304+(md<<3)+4>>2]|0;k[Na>>2]=Oa+pd;Yc=od;Zc=nd;_c=Oa+qd|0;$c=rd}Oa=Ja+8|0;if((Oa|0)!=(X|0))if((zb|0)<=(_c|0)&(zb|0)<(x|0)){Pa=zb;Qa=Cb;while(1){Ta=(k[Qa>>2]|0)+Pa+(k[Qa+4>>2]|0)|0;Ma=Qa+8|0;if((Ta|0)<=(_c|0)&(Ta|0)<(x|0)){Pa=Ta;Qa=Ma}else{sd=Yc;td=Zc;ud=_c;vd=Ta;wd=$c;xd=Oa;yd=Ma;break}}}else{sd=Yc;td=Zc;ud=_c;vd=zb;wd=$c;xd=Oa;yd=Cb}else{sd=Yc;td=Zc;ud=_c;vd=zb;wd=$c;xd=X;yd=Cb}}else if((ia|0)==128){ia=0;if(!La?(Ib|0)<=(Gb|0)&(Ib|0)<(x|0):0){Qa=Ib;Pa=Kb;while(1){Na=(k[Pa>>2]|0)+Qa+(k[Pa+4>>2]|0)|0;Ma=Pa+8|0;if((Na|0)<=(Gb|0)&(Na|0)<(x|0)){Qa=Na;Pa=Ma}else{zd=Na;Ad=Ma;break}}}else{zd=Ib;Ad=Kb}k[Ja>>2]=Hb+Fb+zd;sd=Eb;td=Db;ud=zd;vd=(k[Ad>>2]|0)+zd|0;wd=Jb;xd=Ja+4|0;yd=Ad+4|0}else if((ia|0)==132){ia=0;if(!La?(Rb|0)<=(Pb|0)&(Rb|0)<(x|0):0){Pa=Rb;Qa=Tb;while(1){Oa=(k[Qa>>2]|0)+Pa+(k[Qa+4>>2]|0)|0;Ma=Qa+8|0;if((Oa|0)<=(Pb|0)&(Oa|0)<(x|0)){Pa=Oa;Qa=Ma}else{Bd=Oa;Cd=Ma;break}}}else{Bd=Rb;Cd=Tb}Qa=k[8280+(Lb<<3)+4>>2]|0;k[Ja>>2]=Qb+Ob+Bd+Qa;sd=Nb;td=Mb;ud=Qa+Bd|0;vd=(k[Cd>>2]|0)+Bd|0;wd=Sb;xd=Ja+4|0;yd=Cd+4|0}else if((ia|0)==136){ia=0;Qa=(Ja|0)!=(X|0);if(Qa?(Zb|0)<=(Yb|0)&(Zb|0)<(x|0):0){Pa=Zb;La=$b;while(1){Ma=(k[La>>2]|0)+Pa+(k[La+4>>2]|0)|0;Oa=La+8|0;if((Ma|0)<=(Yb|0)&(Ma|0)<(x|0)){Pa=Ma;La=Oa}else{Dd=Ma;Ed=Oa;break}}}else{Dd=Zb;Ed=$b}La=k[8280+(Ub<<3)+4>>2]|0;Pa=La+Yb|0;if((Dd|0)<=(Pa|0)&(Qa|(Dd|0)<(Pa|0))){Fd=Vb;Gd=Wb;Hd=Xb;Id=Yb;Jd=_b;Kd=Ja;ia=140;break}k[Ja>>2]=Dd-Yb+Xb-La;Pa=Ed+-4|0;sd=Wb;td=Vb;ud=Dd-La|0;vd=Dd-(k[Pa>>2]|0)|0;wd=_b;xd=Ja+4|0;yd=Pa}if((x|0)>(ud|0)){na=sd;Ea=td;Fa=0-ud|0;Ga=ud;Ha=vd;Ia=wd;Ja=xd;Ka=yd}else{Ld=sd;Md=td;Nd=0;Od=ud;Pd=wd;Qd=xd;break d}}do if((ia|0)==140){ia=0;Ka=k[Q>>2]|0;Ja=(k[R>>2]&1024|0)!=0;Ia=k[(Ja?S:T)>>2]|0;k[p>>2]=k[P>>2];k[p+4>>2]=Ja?142996:143001;k[p+8>>2]=Ia;k[p+12>>2]=Id;vc(Ka,144240,143007,p);Rd=Gd;Sd=Fd;Td=0;Ud=Hd;Vd=Id;Wd=Jd;Xd=Kd}else if((ia|0)==143){ia=0;k[mb>>2]=x-kb;Ka=k[Q>>2]|0;Ia=(k[R>>2]&1024|0)!=0;Ja=k[(Ia?S:T)>>2]|0;k[o>>2]=k[P>>2];k[o+4>>2]=Ia?142996:143001;k[o+8>>2]=Ja;k[o+12>>2]=kb;vc(Ka,144240,143800,o);Rd=ib;Sd=hb;Td=0;Ud=jb;Vd=kb;Wd=lb;Xd=mb+4|0}else if((ia|0)==144){ia=0;Ka=ub+4|0;k[ub>>2]=x-sb;do if((ob|0)<4)if(tb>>>0>=L>>>0)if((qb|0)==(nb|0)){Ua=V;Va=X;Wa=pb;Xa=ob;Ya=rb;Za=sb;_a=tb;$a=Ka;ia=154;break b}else{Yd=pb;Zd=4;_d=tb;break}else{Yd=(l[y+(l[tb>>0]|0)>>0]|0)<<ob|pb;Zd=ob+8|0;_d=tb+1|0;break}else{Yd=pb;Zd=ob;_d=tb}while(0);if(Yd&15){Qa=k[Q>>2]|0;Ja=(k[R>>2]&1024|0)!=0;Ia=k[(Ja?S:T)>>2]|0;k[n>>2]=k[P>>2];k[n+4>>2]=Ja?142996:143001;k[n+8>>2]=Ia;k[n+12>>2]=sb;vc(Qa,144240,143007,n)}Rd=Yd>>>4;Sd=Zd+-4|0;Td=1;Ud=rb;Vd=sb;Wd=_d;Xd=Ka}else if((ia|0)==152){ia=0;Qa=k[Q>>2]|0;Ia=(k[R>>2]&1024|0)!=0;Ja=k[(Ia?S:T)>>2]|0;k[j>>2]=k[P>>2];k[j+4>>2]=Ia?142996:143001;k[j+8>>2]=Ja;k[j+12>>2]=Vc;vc(Qa,144240,143007,j);Rd=Sc;Sd=Tc;Td=0;Ud=Uc;Vd=Vc;Wd=Wc;Xd=Xc}else if((ia|0)==153){ia=0;Qa=k[Q>>2]|0;Ja=(k[R>>2]&1024|0)!=0;Ia=k[(Ja?S:T)>>2]|0;k[i>>2]=k[P>>2];k[i+4>>2]=Ja?142996:143001;k[i+8>>2]=Ia;k[i+12>>2]=Gc;vc(Qa,144240,143007,i);Rd=Dc;Sd=Ec;Td=0;Ud=Fc;Vd=Gc;Wd=Hc;Xd=Ic}else if((ia|0)==165){ia=0;if(!ic){Ld=gc;Md=hc;Nd=0;Od=jc;Pd=kc;Qd=lc;break d}if((jc+ic|0)<(x|0)){do if((hc|0)<1)if(kc>>>0>=L>>>0)if(!hc){Ua=V;Va=X;Wa=gc;Xa=0;Ya=ic;Za=jc;_a=kc;$a=lc;ia=154;break b}else{$d=gc;ae=1;be=kc;break}else{$d=(l[y+(l[kc>>0]|0)>>0]|0)<<hc|gc;ae=hc+8|0;be=kc+1|0;break}else{$d=gc;ae=hc;be=kc}while(0);if(!($d&1)){ac=$d;bc=ae;cc=ic;dc=jc;ec=be;fc=lc;ia=151;break}ce=$d>>>1;de=ae+-1|0;ee=be}else{ce=gc;de=hc;ee=kc}k[lc>>2]=ic;Ld=ce;Md=de;Nd=0;Od=jc;Pd=ee;Qd=lc+4|0;break d}while(0);if((ia|0)==151){ia=0;Ka=k[Q>>2]|0;Qa=(k[R>>2]&1024|0)!=0;Ia=k[(Qa?S:T)>>2]|0;k[m>>2]=k[P>>2];k[m+4>>2]=Qa?142996:143001;k[m+8>>2]=Ia;k[m+12>>2]=dc;vc(Ka,144240,143007,m);Rd=ac;Sd=bc;Td=0;Ud=cc;Vd=dc;Wd=ec;Xd=fc}if(!Ud){Ld=Rd;Md=Sd;Nd=Td;Od=Vd;Pd=Wd;Qd=Xd}else{k[Xd>>2]=Ud;Ld=Rd;Md=Sd;Nd=Td;Od=Vd;Pd=Wd;Qd=Xd+4|0}}else{Ld=ca;Md=ba;Nd=0;Od=0;Pd=Da;Qd=X}while(0);if((Od|0)==(x|0)){fe=Ld;ge=Md;he=Nd;je=Pd;ke=Qd}else{Ka=k[P>>2]|0;Ia=k[Q>>2]|0;Qa=(k[R>>2]&1024|0)!=0;Ja=k[(Qa?S:T)>>2]|0;k[f>>2]=Od>>>0<x>>>0?143089:143103;k[f+4>>2]=Ka;k[f+8>>2]=Qa?142996:143001;k[f+12>>2]=Ja;k[f+16>>2]=Od;k[f+20>>2]=x;ie(Ia,144240,143124,f);Ia=(Od|0)>(x|0);if(Qd>>>0>X>>>0&Ia){Ja=Od;Qa=Qd;while(1){Ka=Qa+-4|0;Ha=Ja-(k[Ka>>2]|0)|0;Ga=(Ha|0)>(x|0);if(Ka>>>0>X>>>0&Ga){Ja=Ha;Qa=Ka}else{le=Ga;me=Ha;ne=Ka;break}}}else{le=Ia;me=Od;ne=Qd}if((me|0)>=(x|0)){if(!le){fe=Ld;ge=Md;he=Nd;je=Pd;ke=ne;break}k[ne>>2]=x;k[ne+4>>2]=0;fe=Ld;ge=Md;he=Nd;je=Pd;ke=ne+8|0;break}if(!(ne-X&4))oe=ne;else{k[ne>>2]=0;oe=ne+4|0}k[oe>>2]=x-((me|0)<0?0:me);fe=Ld;ge=Md;he=Nd;je=Pd;ke=oe+4|0}}else{Qa=ca;Ja=ba;Ka=0;Ha=Da;Ga=X;k:while(1){Fa=Qa;Ea=Ja;na=0;ma=Ka;Pa=Ha;l:while(1){do if((Ea|0)<12){if(Pa>>>0>=L>>>0)if(!Ea){pe=V;qe=X;re=Fa;se=na;te=ma;ue=Pa;ve=Ga;ia=51;break b}else{we=Fa;xe=12;ye=Pa;break}La=Pa+1|0;Oa=(l[y+(l[Pa>>0]|0)>>0]|0)<<Ea|Fa;Ma=Ea+8|0;if((Ma|0)<12)if(La>>>0<L>>>0){we=(l[y+(l[La>>0]|0)>>0]|0)<<Ma|Oa;xe=Ea+16|0;ye=Pa+2|0}else{we=Oa;xe=12;ye=La}else{we=Oa;xe=Ma;ye=La}}else{we=Fa;xe=Ea;ye=Pa}while(0);La=we&4095;Ma=l[9304+(La<<3)+1>>0]|0;Oa=xe-Ma|0;Na=we>>>Ma;switch(l[9304+(La<<3)>>0]|0|0){case 12:{ze=Na;Ae=Oa;Be=1;Ce=na;De=ma;Ee=ye;Fe=Ga;ia=62;break k;break}case 7:{Ge=La;He=Oa;Ie=Na;Je=na;Ke=ma;Le=ye;break l;break}case 11:case 9:break;default:{Me=Oa;Ne=Na;Oe=na;Pe=ma;Qe=ye;Re=Ga;ia=38;break k}}Ma=k[9304+(La<<3)+4>>2]|0;Fa=Na;Ea=Oa;na=Ma+na|0;ma=Ma+ma|0;Pa=ye}Pa=k[9304+(Ge<<3)+4>>2]|0;ma=Pa+Je|0;na=Ga+4|0;k[Ga>>2]=ma;Ea=Pa+Ke|0;if((Ea|0)<(x|0)){Se=Ie;Te=He;Ue=0;Ve=Ea;We=Le}else{Xe=Ie;Ye=He;Ze=0;_e=Ea;$e=Le;af=na;break}m:while(1){do if((Te|0)<13){if(We>>>0>=L>>>0)if(!Te){pe=V;qe=X;re=Se;se=Ue;te=Ve;ue=We;ve=na;ia=51;break b}else{bf=Se;cf=13;df=We;break}Ea=We+1|0;Pa=(l[y+(l[We>>0]|0)>>0]|0)<<Te|Se;Fa=Te+8|0;if((Fa|0)<13)if(Ea>>>0<L>>>0){bf=(l[y+(l[Ea>>0]|0)>>0]|0)<<Fa|Pa;cf=Te+16|0;df=We+2|0}else{bf=Pa;cf=13;df=Ea}else{bf=Pa;cf=Fa;df=Ea}}else{bf=Se;cf=Te;df=We}while(0);Ea=bf&8191;Fa=l[42072+(Ea<<3)+1>>0]|0;Pa=cf-Fa|0;Ma=bf>>>Fa;switch(l[42072+(Ea<<3)>>0]|0|0){case 12:{ze=Ma;Ae=Pa;Be=1;Ce=Ue;De=Ve;Ee=df;Fe=na;ia=62;break k;break}case 8:{ef=Ea;ff=Pa;gf=Ma;hf=Ue;jf=Ve;kf=df;break m;break}case 11:case 10:break;default:{lf=Pa;mf=Ma;nf=na;of=Ue;pf=Ve;qf=df;ia=48;break k}}Fa=k[42072+(Ea<<3)+4>>2]|0;Se=Ma;Te=Pa;Ue=Fa+Ue|0;Ve=Fa+Ve|0;We=df}Fa=k[42072+(ef<<3)+4>>2]|0;Pa=Fa+hf|0;Ma=Ga+8|0;k[na>>2]=Pa;Ea=Fa+jf|0;if((Ea|0)>=(x|0)){Xe=gf;Ye=ff;Ze=0;_e=Ea;$e=kf;af=Ma;break}Qa=gf;Ja=ff;Ka=Ea;Ha=kf;Ga=(Pa|ma|0)==0?Ga:Ma}if((ia|0)==38){ia=0;Ga=k[Q>>2]|0;Ha=(k[R>>2]&1024|0)!=0;Ka=k[(Ha?S:T)>>2]|0;k[v>>2]=k[P>>2];k[v+4>>2]=Ha?142996:143001;k[v+8>>2]=Ka;k[v+12>>2]=Pe;vc(Ga,144240,143007,v);ze=Ne;Ae=Me;Be=0;Ce=Oe;De=Pe;Ee=Qe;Fe=Re;ia=62}else if((ia|0)==48){ia=0;Ga=k[Q>>2]|0;Ka=(k[R>>2]&1024|0)!=0;Ha=k[(Ka?S:T)>>2]|0;k[u>>2]=k[P>>2];k[u+4>>2]=Ka?142996:143001;k[u+8>>2]=Ha;k[u+12>>2]=pf;vc(Ga,144240,143007,u);ze=mf;Ae=lf;Be=0;Ce=of;De=pf;Ee=qf;Fe=nf;ia=62}if((ia|0)==62){ia=0;if(!Ce){Xe=ze;Ye=Ae;Ze=Be;_e=De;$e=Ee;af=Fe}else{k[Fe>>2]=Ce;Xe=ze;Ye=Ae;Ze=Be;_e=De;$e=Ee;af=Fe+4|0}}if((_e|0)==(x|0)){fe=Xe;ge=Ye;he=Ze;je=$e;ke=af}else{Ga=k[P>>2]|0;Ha=k[Q>>2]|0;Ka=(k[R>>2]&1024|0)!=0;Ja=k[(Ka?S:T)>>2]|0;k[q>>2]=_e>>>0<x>>>0?143089:143103;k[q+4>>2]=Ga;k[q+8>>2]=Ka?142996:143001;k[q+12>>2]=Ja;k[q+16>>2]=_e;k[q+20>>2]=x;ie(Ha,144240,143124,q);Ha=(_e|0)>(x|0);if(af>>>0>X>>>0&Ha){Ja=_e;Ka=af;while(1){Ga=Ka+-4|0;Qa=Ja-(k[Ga>>2]|0)|0;Ia=(Qa|0)>(x|0);if(Ga>>>0>X>>>0&Ia){Ja=Qa;Ka=Ga}else{rf=Ia;sf=Qa;tf=Ga;break}}}else{rf=Ha;sf=_e;tf=af}if((sf|0)>=(x|0)){if(!rf){fe=Xe;ge=Ye;he=Ze;je=$e;ke=tf;break}k[tf>>2]=x;k[tf+4>>2]=0;fe=Xe;ge=Ye;he=Ze;je=$e;ke=tf+8|0;break}if(!(tf-X&4))uf=tf;else{k[tf>>2]=0;uf=tf+4|0}k[uf>>2]=x-((sf|0)<0?0:sf);fe=Xe;ge=Ye;he=Ze;je=$e;ke=uf+4|0}}while(0);Ab[k[U>>2]&31](V,X,ke,x);k[ke>>2]=0;ba=k[M>>2]|0;X=k[N>>2]|0;k[M>>2]=X;k[N>>2]=ba;ba=k[z>>2]|0;W=W-ba|0;k[P>>2]=(k[P>>2]|0)+1;if((W|0)<=0){vf=fe;wf=ge;xf=he;yf=je;ia=190;break}else{V=V+ba|0;Y=fe;Z=ge;_=he;$=je}}do if((ia|0)==51){$=k[Q>>2]|0;_=(k[R>>2]&1024|0)!=0;Z=k[(_?S:T)>>2]|0;k[t>>2]=k[P>>2];k[t+4>>2]=_?142996:143001;k[t+8>>2]=Z;k[t+12>>2]=te;ie($,144240,143048,t);if(!se)zf=ve;else{k[ve>>2]=se;zf=ve+4|0}if((te|0)==(x|0)){Af=pe;Bf=qe;Cf=re;Df=0;Ef=0;Ff=ue;Gf=zf}else{$=k[P>>2]|0;Z=k[Q>>2]|0;_=(k[R>>2]&1024|0)!=0;Y=k[(_?S:T)>>2]|0;k[s>>2]=te>>>0<x>>>0?143089:143103;k[s+4>>2]=$;k[s+8>>2]=_?142996:143001;k[s+12>>2]=Y;k[s+16>>2]=te;k[s+20>>2]=x;ie(Z,144240,143124,s);Z=(te|0)>(x|0);if(zf>>>0>qe>>>0&Z){Y=te;_=zf;while(1){$=_+-4|0;V=Y-(k[$>>2]|0)|0;W=(V|0)>(x|0);if($>>>0>qe>>>0&W){Y=V;_=$}else{Hf=W;If=V;Jf=$;break}}}else{Hf=Z;If=te;Jf=zf}if((If|0)>=(x|0)){if(!Hf){Af=pe;Bf=qe;Cf=re;Df=0;Ef=0;Ff=ue;Gf=Jf;break}k[Jf>>2]=x;k[Jf+4>>2]=0;Af=pe;Bf=qe;Cf=re;Df=0;Ef=0;Ff=ue;Gf=Jf+8|0;break}if(!(Jf-qe&4))Kf=Jf;else{k[Jf>>2]=0;Kf=Jf+4|0}k[Kf>>2]=x-((If|0)<0?0:If);Af=pe;Bf=qe;Cf=re;Df=0;Ef=0;Ff=ue;Gf=Kf+4|0}}else if((ia|0)==154){_=k[Q>>2]|0;Y=(k[R>>2]&1024|0)!=0;$=k[(Y?S:T)>>2]|0;k[h>>2]=k[P>>2];k[h+4>>2]=Y?142996:143001;k[h+8>>2]=$;k[h+12>>2]=Za;ie(_,144240,143048,h);if(!Ya)Lf=$a;else{k[$a>>2]=Ya;Lf=$a+4|0}if((Za|0)==(x|0)){Af=Ua;Bf=Va;Cf=Wa;Df=Xa;Ef=0;Ff=_a;Gf=Lf}else{_=k[P>>2]|0;$=k[Q>>2]|0;Y=(k[R>>2]&1024|0)!=0;V=k[(Y?S:T)>>2]|0;k[g>>2]=Za>>>0<x>>>0?143089:143103;k[g+4>>2]=_;k[g+8>>2]=Y?142996:143001;k[g+12>>2]=V;k[g+16>>2]=Za;k[g+20>>2]=x;ie($,144240,143124,g);$=(Za|0)>(x|0);if(Lf>>>0>Va>>>0&$){V=Za;Y=Lf;while(1){_=Y+-4|0;W=V-(k[_>>2]|0)|0;N=(W|0)>(x|0);if(_>>>0>Va>>>0&N){V=W;Y=_}else{Mf=N;Nf=W;Of=_;break}}}else{Mf=$;Nf=Za;Of=Lf}if((Nf|0)>=(x|0)){if(!Mf){Af=Ua;Bf=Va;Cf=Wa;Df=Xa;Ef=0;Ff=_a;Gf=Of;break}k[Of>>2]=x;k[Of+4>>2]=0;Af=Ua;Bf=Va;Cf=Wa;Df=Xa;Ef=0;Ff=_a;Gf=Of+8|0;break}if(!(Of-Va&4))Pf=Of;else{k[Of>>2]=0;Pf=Of+4|0}k[Pf>>2]=x-((Nf|0)<0?0:Nf);Af=Ua;Bf=Va;Cf=Wa;Df=Xa;Ef=0;Ff=_a;Gf=Pf+4|0}}else if((ia|0)==186)if(x){Y=k[P>>2]|0;V=k[Q>>2]|0;Z=(k[R>>2]&1024|0)!=0;_=k[(Z?S:T)>>2]|0;k[e>>2]=143089;k[e+4>>2]=Y;k[e+8>>2]=Z?142996:143001;k[e+12>>2]=_;k[e+16>>2]=0;k[e+20>>2]=x;ie(V,144240,143124,e);V=ea+4|0;k[ea>>2]=x;if(O){Af=da;Bf=ea;Cf=fa;Df=0;Ef=ga;Ff=ha;Gf=V}else{k[V>>2]=0;Af=da;Bf=ea;Cf=fa;Df=0;Ef=ga;Ff=ha;Gf=ea+8|0}}else{Af=da;Bf=ea;Cf=fa;Df=0;Ef=ga;Ff=ha;Gf=ea}else if((ia|0)==190){Qf=k[H>>2]|0;Rf=k[J>>2]|0;Sf=vf;Tf=wf;Uf=xf;Vf=yf;break a}while(0);Ab[k[U>>2]&31](Af,Bf,Gf,x);k[D>>2]=Df;k[B>>2]=Cf;k[F>>2]=Ef;k[J>>2]=(k[H>>2]|0)-Ff+(k[J>>2]|0);k[H>>2]=Ff;A=-1;r=d;return A|0}else{Qf=I;Rf=K;Sf=C;Tf=E;Uf=G;Vf=I}while(0);k[D>>2]=Tf;k[B>>2]=Sf;k[F>>2]=Uf;k[J>>2]=Qf-Vf+Rf;k[H>>2]=Vf;A=1;r=d;return A|0}function Rf(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=r;r=r+32|0;if((b|0)!=7)Ja(144620,144647,2307,144658);if(!(_b(a,107608,4)|0)){vc(k[a+628>>2]|0,144658,144671,c);d=0;r=c;return d|0}b=me(936)|0;e=a+576|0;k[e>>2]=b;if(!b){vc(k[a+628>>2]|0,144658,144711,c+8|0);d=0;r=c;return d|0}pe(b,0,936);b=k[e>>2]|0;k[b+828>>2]=a;e=a+668|0;f=a+672|0;k[b+892>>2]=k[f>>2];k[f>>2]=13;k[b+896>>2]=k[e>>2];k[e>>2]=14;e=a+676|0;k[b+900>>2]=k[e>>2];k[e>>2]=10;e=b+912|0;k[e>>2]=0;f=b+916|0;k[f>>2]=0;k[b+920>>2]=75;k[b+924>>2]=0;k[b+928>>2]=3;k[b+932>>2]=0;k[a+504>>2]=12;k[a+508>>2]=13;k[a+512>>2]=26;k[a+532>>2]=20;k[a+540>>2]=20;k[a+548>>2]=20;k[a+516>>2]=14;k[a+524>>2]=27;k[a+528>>2]=15;k[a+536>>2]=21;k[a+544>>2]=21;k[a+552>>2]=21;k[a+564>>2]=4;g=a+568|0;k[b+904>>2]=k[g>>2];k[g>>2]=28;g=a+572|0;k[b+908>>2]=k[g>>2];k[g>>2]=11;g=a+12|0;k[g>>2]=k[g>>2]|256;k[b+488>>2]=0;b=a+16|0;if(!((k[b>>2]|0)==0&(k[b+4>>2]|0)==0)){d=1;r=c;return d|0}k[f>>2]=2e3;f=me(2e3)|0;k[e>>2]=f;if(!f){vc(k[a+628>>2]|0,144658,144741,c+16|0);d=0;r=c;return d|0}else{pe(f,0,2e3);d=1;r=c;return d|0}return 0}function Sf(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;d=k[a+576>>2]|0;if(!d)Ja(154187,144647,2186,146558);a:do if((b|0)<65538)if((b|0)<65537){switch(b|0){case 347:break;default:break a}e=k[d+916>>2]|0;f=(k[c>>2]|0)+(4-1)&~(4-1);g=k[f>>2]|0;k[c>>2]=f+4;k[g>>2]=e;e=k[d+912>>2]|0;g=(k[c>>2]|0)+(4-1)&~(4-1);f=k[g>>2]|0;k[c>>2]=g+4;k[f>>2]=e;h=1;return h|0}else{switch(b|0){case 65537:break;default:break a}e=k[d+920>>2]|0;f=(k[c>>2]|0)+(4-1)&~(4-1);g=k[f>>2]|0;k[c>>2]=f+4;k[g>>2]=e;h=1;return h|0}else switch(b|0){case 65538:{e=k[d+924>>2]|0;g=(k[c>>2]|0)+(4-1)&~(4-1);f=k[g>>2]|0;k[c>>2]=g+4;k[f>>2]=e;h=1;return h|0}case 65539:{e=k[d+928>>2]|0;f=(k[c>>2]|0)+(4-1)&~(4-1);g=k[f>>2]|0;k[c>>2]=f+4;k[g>>2]=e;h=1;return h|0}default:break a}while(0);h=nb[k[d+892>>2]&63](a,b,c)|0;return h|0}function Tf(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,l=0,m=0,n=0,o=0,p=0,q=0;d=a+576|0;e=k[d>>2]|0;if(!e)Ja(154187,144647,2132,146544);a:do if((b|0)<65537)switch(b|0){case 347:{f=(k[c>>2]|0)+(4-1)&~(4-1);g=k[f>>2]|0;k[c>>2]=f+4;if(!g){h=0;return h|0}f=(k[c>>2]|0)+(4-1)&~(4-1);i=k[f>>2]|0;k[c>>2]=f+4;Nb(e+912|0,i,g);k[e+916>>2]=g;g=a+48|0;k[g>>2]=k[g>>2]|4;g=cc(a,347)|0;if(!g){h=0;return h|0}i=j[g+24>>1]|0;g=a+40+(((i&65535)>>>5&65535)<<2)|0;k[g>>2]=1<<(i&31)|k[g>>2];g=a+12|0;k[g>>2]=k[g>>2]|8;h=1;return h|0}case 262:{g=nb[k[e+896>>2]&63](a,262,c)|0;i=k[d>>2]|0;f=a+12|0;l=k[f>>2]|0;m=l&-16385;k[f>>2]=m;if(((j[a+126>>1]|0)==1?(j[a+90>>1]|0)==6:0)?(k[i+924>>2]|0)==1:0){i=l|16384;k[f>>2]=i;n=i}else n=m;m=a+496|0;if((k[m>>2]|0)>0){if(!(n&1024))o=-1;else o=ge(a)|0;k[m>>2]=o}m=a+580|0;if((k[m>>2]|0)<=0){h=g;return h|0}i=Pd(a)|0;k[m>>2]=i;h=g;return h|0}case 530:{k[e+932>>2]=1;h=nb[k[e+896>>2]&63](a,530,c)|0;return h|0}default:break a}else switch(b|0){case 65537:{g=(k[c>>2]|0)+(4-1)&~(4-1);i=k[g>>2]|0;k[c>>2]=g+4;k[e+920>>2]=i;h=1;return h|0}case 65538:{i=(k[c>>2]|0)+(4-1)&~(4-1);g=k[i>>2]|0;k[c>>2]=i+4;k[e+924>>2]=g;g=k[d>>2]|0;i=a+12|0;m=k[i>>2]|0;f=m&-16385;k[i>>2]=f;if(((j[a+126>>1]|0)==1?(j[a+90>>1]|0)==6:0)?(k[g+924>>2]|0)==1:0){g=m|16384;k[i>>2]=g;p=g}else p=f;f=a+496|0;if((k[f>>2]|0)>0){if(!(p&1024))q=-1;else q=ge(a)|0;k[f>>2]=q}f=a+580|0;if((k[f>>2]|0)<=0){h=1;return h|0}g=Pd(a)|0;k[f>>2]=g;h=1;return h|0}case 65539:{g=(k[c>>2]|0)+(4-1)&~(4-1);f=k[g>>2]|0;k[c>>2]=g+4;k[e+928>>2]=f;h=1;return h|0}default:break a}while(0);h=nb[k[e+896>>2]&63](a,b,c)|0;return h|0}function Uf(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;d=r;r=r+16|0;e=d;f=k[a+576>>2]|0;if(!f)Ja(154187,144647,2213,146503);if(k[a+48>>2]&4){k[e>>2]=k[f+916>>2];wq(b,146516,e)|0}e=k[f+900>>2]|0;if(!e){r=d;return}vb[e&127](a,b,c);r=d;return}function Vf(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,yb=0,zb=0,Ab=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0,Xb=0,Yb=0,Zb=0,_b=0;b=r;r=r+48|0;c=b+40|0;d=b+24|0;e=b+16|0;f=b+8|0;if((j[a+90>>1]|0)!=6){r=b;return 1}if((j[a+126>>1]|0)!=1){r=b;return 1}g=a+98|0;if((j[g>>1]|0)!=3){r=b;return 1}gc(a)|0;h=a+176|0;n=k[h>>2]|0;if(!n){r=b;return 1}o=a+172|0;if(!(k[o>>2]|0)){r=b;return 1}p=n;if((k[p>>2]|0)==0&(k[p+4>>2]|0)==0){r=b;return 1}p=me(2048)|0;if(!p){ie(k[a+628>>2]|0,145945,145970,b);r=b;return 1}n=k[o>>2]|0;o=k[n>>2]|0;q=k[n+4>>2]|0;n=k[h>>2]|0;h=k[n>>2]|0;s=k[n+4>>2]|0;a:do if(!((h|0)==0&(s|0)==0)){n=a+640|0;t=a+628|0;xb[k[n>>2]&63](k[t>>2]|0,o,q,0)|0;u=s>>>0<0|(s|0)==0&h>>>0<2048?h:2048;if((u|0)<=-1)Ja(146063,144647,902,146078);v=a+632|0;if((nb[k[v>>2]&63](k[t>>2]|0,p,u)|0)==(u|0)){w=sr(u|0,0,o|0,q|0)|0;x=L;y=pr(h|0,s|0,u|0,0)|0;z=u;u=p;A=p;B=1;C=y;y=L;D=w;w=x;b:while(1){x=A+1|0;E=x;F=z+-1|0;c:do if((i[u>>0]|0)==-1){G=F;H=E;I=C;J=y;K=B;M=D;N=w;O=x;while(1){if(!G){if((I|0)==0&(J|0)==0){P=t;Q=114;break a}if(!(K<<24>>24)){xb[k[n>>2]&63](k[t>>2]|0,M,N,0)|0;R=1}else R=K;S=J>>>0<0|(J|0)==0&I>>>0<2048?I:2048;if((S|0)<=-1){Q=31;break b}if((nb[k[v>>2]&63](k[t>>2]|0,p,S)|0)!=(S|0)){P=t;Q=114;break a}T=sr(S|0,0,M|0,N|0)|0;U=L;V=pr(I|0,J|0,S|0,0)|0;W=p;X=p;Y=S;Z=R;_=V;$=L;aa=T;ba=U}else{W=H;X=O;Y=G;Z=K;_=I;$=J;aa=M;ba=N}U=i[W>>0]|0;T=X+1|0;V=Y+-1|0;S=T;if(U<<24>>24==-1){G=V;H=S;I=_;J=$;K=Z;M=aa;N=ba;O=T}else{ca=Z;da=U;ea=T;fa=V;ga=S;ha=_;ia=$;ja=aa;ka=ba;break}}switch(da&255|0){case 202:case 201:case 194:case 193:case 192:{la=ca;ma=ea;na=fa;oa=ha;pa=ia;qa=ja;ra=ka;Q=58;break b;break}case 216:{sa=ea;ta=ca;ua=ha;va=ia;wa=ja;xa=ka;ya=fa;za=ga;Q=16;break c;break}case 221:case 196:case 218:case 219:case 239:case 238:case 237:case 236:case 235:case 234:case 233:case 232:case 231:case 230:case 229:case 228:case 227:case 226:case 225:case 224:case 254:break;default:{P=t;Q=114;break a}}if(!fa){if((ha|0)==0&(ia|0)==0){P=t;Q=114;break a}if(!(ca<<24>>24)){xb[k[n>>2]&63](k[t>>2]|0,ja,ka,0)|0;Aa=1}else Aa=ca;O=ia>>>0<0|(ia|0)==0&ha>>>0<2048?ha:2048;if((O|0)<=-1){Q=41;break b}if((nb[k[v>>2]&63](k[t>>2]|0,p,O)|0)!=(O|0)){P=t;Q=114;break a}N=sr(O|0,0,ja|0,ka|0)|0;M=L;K=pr(ha|0,ia|0,O|0,0)|0;Ba=p;Ca=O;Da=K;Ea=L;Fa=Aa;Ga=N;Ha=M}else{Ba=ea;Ca=fa;Da=ha;Ea=ia;Fa=ca;Ga=ja;Ha=ka}M=i[Ba>>0]|0;N=Ba+1|0;K=Ca+-1|0;if(!K){if((Da|0)==0&(Ea|0)==0){P=t;Q=114;break a}if(!(Fa<<24>>24)){xb[k[n>>2]&63](k[t>>2]|0,Ga,Ha,0)|0;Ia=1}else Ia=Fa;O=Ea>>>0<0|(Ea|0)==0&Da>>>0<2048?Da:2048;if((O|0)<=-1){Q=49;break b}if((nb[k[v>>2]&63](k[t>>2]|0,p,O)|0)!=(O|0)){P=t;Q=114;break a}J=sr(O|0,0,Ga|0,Ha|0)|0;I=L;H=pr(Da|0,Ea|0,O|0,0)|0;Ka=p;La=O;Ma=L;Na=H;Oa=J;Pa=I;Qa=Ia}else{Ka=N;La=K;Ma=Ea;Na=Da;Oa=Ga;Pa=Ha;Qa=Fa}K=Ka+1|0;N=La+-1|0;I=l[Ka>>0]|(M&255)<<8;if((I&65535)<2){P=t;Q=114;break a}M=I+65534|0;I=M&65535;if(!I){sa=K;ta=Qa;ua=Na;va=Ma;wa=Oa;xa=Pa;ya=N;za=K;Q=16}else{if(N>>>0>=I>>>0){K=Ka+(I+1)|0;sa=K;ta=Qa;ua=Na;va=Ma;wa=Oa;xa=Pa;ya=N-I|0;za=K;Q=16;break}K=M-N&65535;if(Ma>>>0<0|(Ma|0)==0&Na>>>0<K>>>0){P=t;Q=114;break a}N=sr(K|0,0,Oa|0,Pa|0)|0;M=L;I=pr(Na|0,Ma|0,K|0,0)|0;Ra=I;Sa=L;Ta=0;Ua=N;Va=M}}else{sa=x;ta=B;ua=C;va=y;wa=D;xa=w;ya=F;za=E;Q=16}while(0);if((Q|0)==16){Q=0;if(!ya){Ra=ua;Sa=va;Ta=ta;Ua=wa;Va=xa}else{z=ya;u=za;A=sa;B=ta;C=ua;y=va;D=wa;w=xa;continue}}if((Ra|0)==0&(Sa|0)==0){P=t;Q=114;break a}if(!(Ta<<24>>24)){xb[k[n>>2]&63](k[t>>2]|0,Ua,Va,0)|0;Wa=1}else Wa=Ta;E=Sa>>>0<0|(Sa|0)==0&Ra>>>0<2048?Ra:2048;if((E|0)<=-1){Q=22;break}if((nb[k[v>>2]&63](k[t>>2]|0,p,E)|0)!=(E|0)){P=t;Q=114;break a}F=sr(E|0,0,Ua|0,Va|0)|0;x=L;M=pr(Ra|0,Sa|0,E|0,0)|0;z=E;u=p;A=p;B=Wa;C=M;y=L;D=F;w=x}if((Q|0)==22)Ja(146063,144647,902,146078);else if((Q|0)==31)Ja(146063,144647,902,146078);else if((Q|0)==41)Ja(146063,144647,902,146078);else if((Q|0)==49)Ja(146063,144647,902,146078);else if((Q|0)==58){if(!na){if((oa|0)==0&(pa|0)==0){P=t;Q=114;break}if(!(la<<24>>24)){xb[k[n>>2]&63](k[t>>2]|0,qa,ra,0)|0;Xa=1}else Xa=la;w=pa>>>0<0|(pa|0)==0&oa>>>0<2048?oa:2048;if((w|0)<=-1)Ja(146063,144647,902,146078);if((nb[k[v>>2]&63](k[t>>2]|0,p,w)|0)!=(w|0)){P=t;Q=114;break}D=sr(w|0,0,qa|0,ra|0)|0;y=L;C=pr(oa|0,pa|0,w|0,0)|0;Ya=p;Za=w;_a=C;$a=L;ab=Xa;bb=D;cb=y}else{Ya=ma;Za=na;_a=oa;$a=pa;ab=la;bb=qa;cb=ra}y=i[Ya>>0]|0;D=Ya+1|0;C=Za+-1|0;if(!C){if((_a|0)==0&($a|0)==0){P=t;Q=114;break}if(!(ab<<24>>24)){xb[k[n>>2]&63](k[t>>2]|0,bb,cb,0)|0;db=1}else db=ab;w=$a>>>0<0|($a|0)==0&_a>>>0<2048?_a:2048;if((w|0)<=-1)Ja(146063,144647,902,146078);if((nb[k[v>>2]&63](k[t>>2]|0,p,w)|0)!=(w|0)){P=t;Q=114;break}B=sr(w|0,0,bb|0,cb|0)|0;A=L;u=pr(_a|0,$a|0,w|0,0)|0;eb=p;fb=w;gb=L;hb=u;ib=B;jb=A;kb=db}else{eb=D;fb=C;gb=$a;hb=_a;ib=bb;jb=cb;kb=ab}if((l[eb>>0]|(y&255)<<8|0)!=(((m[g>>1]|0)*3|0)+8|0)){P=t;Q=114;break}if((fb+-1|0)>>>0>=7){y=fb+-8|0;if(!y){lb=hb;mb=gb;ob=kb;pb=ib;qb=jb;Q=79}else{rb=eb+8|0;sb=y;tb=hb;ub=gb;vb=ib;wb=jb;yb=kb}}else{y=8-fb&65535;if(gb>>>0<0|(gb|0)==0&hb>>>0<y>>>0){P=t;Q=114;break}C=sr(y|0,0,ib|0,jb|0)|0;D=L;A=pr(hb|0,gb|0,y|0,0)|0;lb=A;mb=L;ob=0;pb=C;qb=D;Q=79}if((Q|0)==79){if((lb|0)==0&(mb|0)==0){P=t;Q=114;break}if(!(ob<<24>>24)){xb[k[n>>2]&63](k[t>>2]|0,pb,qb,0)|0;zb=1}else zb=ob;D=mb>>>0<0|(mb|0)==0&lb>>>0<2048?lb:2048;if((D|0)<=-1)Ja(146063,144647,902,146078);if((nb[k[v>>2]&63](k[t>>2]|0,p,D)|0)!=(D|0)){P=t;Q=114;break}C=sr(D|0,0,pb|0,qb|0)|0;A=L;y=pr(lb|0,mb|0,D|0,0)|0;rb=p;sb=D;tb=y;ub=L;vb=C;wb=A;yb=zb}A=i[rb>>0]|0;C=(A&255)>>>4;y=A&15;A=rb+1|0;if((sb|0)==1)if((tb|0)==0&(ub|0)==0){Ab=A;Bb=yb;Cb=0;Db=0;Eb=vb;Fb=wb;Gb=0}else{D=sr(vb|0,wb|0,1,0)|0;B=L;u=sr(tb|0,ub|0,-1,-1)|0;Ab=A;Bb=0;Cb=u;Db=L;Eb=D;Fb=B;Gb=0}else{Ab=rb+2|0;Bb=yb;Cb=tb;Db=ub;Eb=vb;Fb=wb;Gb=sb+-2|0}d:do if((m[g>>1]|0)>1){B=Gb;D=Cb;u=Db;A=Eb;w=Fb;z=Ab;x=Bb;F=1;while(1){if(B){M=B+-1|0;if(!M){Hb=D;Ib=u;Jb=x;Kb=A;Lb=w;Q=95}else{Mb=z+1|0;Nb=M;Ob=D;Pb=u;Qb=A;Rb=w;Sb=x}}else{if((D|0)==0&(u|0)==0){P=t;Q=114;break a}M=sr(A|0,w|0,1,0)|0;E=L;N=sr(D|0,u|0,-1,-1)|0;Hb=N;Ib=L;Jb=0;Kb=M;Lb=E;Q=95}if((Q|0)==95){Q=0;if((Hb|0)==0&(Ib|0)==0){P=t;Q=114;break a}if(!(Jb<<24>>24)){xb[k[n>>2]&63](k[t>>2]|0,Kb,Lb,0)|0;Tb=1}else Tb=Jb;E=Ib>>>0<0|(Ib|0)==0&Hb>>>0<2048?Hb:2048;if((E|0)<=-1){Q=99;break}if((nb[k[v>>2]&63](k[t>>2]|0,p,E)|0)!=(E|0)){P=t;Q=114;break a}M=sr(E|0,0,Kb|0,Lb|0)|0;N=L;I=pr(Hb|0,Ib|0,E|0,0)|0;Mb=p;Nb=E;Ob=I;Pb=L;Qb=M;Rb=N;Sb=Tb}N=Mb+1|0;if((i[Mb>>0]|0)!=17){Q=103;break}do if((Nb|0)==1){if((Ob|0)==0&(Pb|0)==0){Ub=N;Vb=Sb;Wb=0;Xb=0;Yb=Qb;Zb=Rb;_b=0;break}M=sr(Qb|0,Rb|0,1,0)|0;I=L;E=sr(Ob|0,Pb|0,-1,-1)|0;Ub=N;Vb=0;Wb=E;Xb=L;Yb=M;Zb=I;_b=0}else{Ub=Mb+2|0;Vb=Sb;Wb=Ob;Xb=Pb;Yb=Qb;Zb=Rb;_b=Nb+-2|0}while(0);F=F+1<<16>>16;if((F&65535)>=(m[g>>1]|0))break d;else{B=_b;D=Wb;u=Xb;A=Yb;w=Zb;z=Ub;x=Vb}}if((Q|0)==99)Ja(146063,144647,902,146078);else if((Q|0)==103){ie(k[t>>2]|0,146111,146139,f);break a}}while(0);v=C&255;e:do switch(C<<24>>24){case 4:case 2:case 1:{switch(y|0){case 4:case 2:case 1:break;default:break e}n=a+192|0;x=m[n>>1]|0;z=a+194|0;w=m[z>>1]|0;if((v|0)==(x|0)&(y|0)==(w|0))break a;A=k[t>>2]|0;k[d>>2]=x;k[d+4>>2]=w;k[d+8>>2]=v;k[d+12>>2]=y;ie(A,146111,146261,d);j[n>>1]=C&255;j[z>>1]=y;break a;break}default:{}}while(0);ie(k[t>>2]|0,146111,146139,e);break}}else{P=t;Q=114}}else{P=a+628|0;Q=114}while(0);if((Q|0)==114)ie(k[P>>2]|0,145945,146379,c);ne(p);r=b;return 1}function Wf(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0;b=r;r=r+16|0;c=b;d=k[a+576>>2]|0;e=d+488|0;if(k[e>>2]|0){if(!(k[d+16>>2]|0)){eg(d);k[e>>2]=0;f=4}}else f=4;do if((f|0)==4){if(Hg(d)|0){k[e>>2]=1;break}if(!d)Ja(154187,144647,972,145904)}while(0);if(!(k[d+16>>2]|0))Ja(145286,144647,973,145904);if((k[a+48>>2]&4|0)!=0?(e=d+800|0,k[d+24>>2]=e,k[d+812>>2]=16,k[d+816>>2]=1,k[d+820>>2]=29,k[d+824>>2]=5,k[d+804>>2]=0,k[e>>2]=0,k[d+808>>2]=6,(Cg(d,0)|0)!=2):0){vc(k[a+628>>2]|0,145904,145920,c);g=0;r=b;return g|0}c=j[a+90>>1]|0;j[d+832>>1]=c;if(c<<16>>16==6){j[d+834>>1]=j[a+192>>1]|0;h=j[a+194>>1]|0}else{j[d+834>>1]=1;h=1}j[d+836>>1]=h;h=d+800|0;k[d+24>>2]=h;k[d+808>>2]=7;k[d+812>>2]=16;k[d+816>>2]=1;k[d+820>>2]=29;k[d+824>>2]=5;k[d+804>>2]=0;k[h>>2]=0;k[a+652>>2]=3;g=1;r=b;return g|0}function Xf(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;c=r;r=r+80|0;d=c+72|0;e=c+64|0;f=c+48|0;g=c+40|0;h=c+32|0;i=c+16|0;l=c;n=a+576|0;o=k[n>>2]|0;if(!o)Ja(154187,144647,1017,145272);p=o+16|0;if((k[p>>2]|0)==0?(ub[k[a+508>>2]&63](a)|0,(k[p>>2]|0)==0):0)Ja(145286,144647,1024,145272);if(!(Bg(o)|0)){q=0;r=c;return q|0}if((Cg(o,1)|0)!=1){q=0;r=c;return q|0}k[a+604>>2]=k[o+800>>2];k[a+608>>2]=k[o+804>>2];p=(k[a+60>>2]|0)-(k[a+444>>2]|0)|0;if(!(k[a+12>>2]&1024)){s=k[a+56>>2]|0;t=k[a+100>>2]|0;u=Pd(a)|0;v=p>>>0>t>>>0?t:p;w=s}else{s=k[a+68>>2]|0;p=k[a+72>>2]|0;u=de(a)|0;v=p;w=s}k[o+840>>2]=u;u=a+126|0;if(!(b<<16>>16==0|(j[u>>1]|0)!=2)){b=m[o+834>>1]|0;if(w>>>0<(0-b|0)>>>0)x=((w+-1+b|0)>>>0)/(b>>>0)|0;else x=0;b=m[o+836>>1]|0;if(v>>>0<(0-b|0)>>>0){y=((v+-1+b|0)>>>0)/(b>>>0)|0;z=x}else{y=0;z=x}}else{y=v;z=w}w=o+28|0;v=k[w>>2]|0;x=k[o+32>>2]|0;if(v>>>0<z>>>0|x>>>0<y>>>0){b=k[a+628>>2]|0;k[l>>2]=z;k[l+4>>2]=y;k[l+8>>2]=v;k[l+12>>2]=x;ie(b,145272,145317,l);A=k[w>>2]|0}else A=v;v=k[o+32>>2]|0;if(A>>>0>z>>>0|v>>>0>y>>>0){w=k[a+628>>2]|0;k[i>>2]=z;k[i+4>>2]=y;k[i+8>>2]=A;k[i+12>>2]=v;vc(w,145272,145374,i);q=0;r=c;return q|0}i=o+36|0;w=k[i>>2]|0;v=(j[u>>1]|0)==1;if(v)B=m[a+98>>1]|0;else B=1;if((w|0)!=(B|0)){vc(k[a+628>>2]|0,145272,145450,h);q=0;r=c;return q|0}if((k[o+212>>2]|0)!=(m[a+84>>1]|0)){vc(k[a+628>>2]|0,145272,145480,g);q=0;r=c;return q|0}g=o+216|0;h=k[g>>2]|0;B=k[h+8>>2]|0;a:do if(v){u=m[o+834>>1]|0;A=k[h+12>>2]|0;y=j[o+836>>1]|0;if(!((B|0)==(u|0)&(A|0)==(y&65535|0))){z=k[a+628>>2]|0;k[f>>2]=B;k[f+4>>2]=A;k[f+8>>2]=u;k[f+12>>2]=y&65535;vc(z,145272,145509,f);q=0;r=c;return q|0}do if((w|0)>1){z=1;while(1){if((k[h+(z*88|0)+8>>2]|0)!=1)break;if((k[h+(z*88|0)+12>>2]|0)!=1)break;z=z+1|0;if((z|0)>=(w|0)){C=37;break}}if((C|0)==37)if(v)break;else{C=41;break a}vc(k[a+628>>2]|0,145272,145574,e);q=0;r=c;return q|0}while(0);if((j[o+832>>1]|0)==6?(k[o+924>>2]|0)==1:0){k[o+40>>2]=3;k[o+44>>2]=2;C=45;break}k[o+40>>2]=0;k[o+44>>2]=0;if((j[o+834>>1]|0)==1?(j[o+836>>1]|0)==1:0){C=45;break}k[o+68>>2]=1;k[o+76>>2]=0;k[a+532>>2]=22;k[a+540>>2]=23;k[a+548>>2]=23;D=0}else{if((B|0)==1?(k[h+12>>2]|0)==1:0){C=41;break}vc(k[a+628>>2]|0,145272,145574,d);q=0;r=c;return q|0}while(0);if((C|0)==41){k[o+40>>2]=0;k[o+44>>2]=0;C=45}if((C|0)==45){k[o+68>>2]=0;k[a+532>>2]=20;k[a+540>>2]=20;k[a+548>>2]=20;D=1}a=(Fg(o)|0)==0;if(D|a){q=a&1^1;r=c;return q|0}a=k[i>>2]|0;i=k[n>>2]|0;b:do if((a|0)>0){n=0;D=k[g>>2]|0;C=0;while(1){d=k[D+8>>2]|0;h=k[D+12>>2]|0;B=mg(i,k[D+28>>2]<<3,h<<3)|0;if(!B){q=0;break}e=(ha(h,d)|0)+C|0;k[i+844+(n<<2)>>2]=B;n=n+1|0;if((n|0)>=(a|0)){E=e;break b}else{D=D+88|0;C=e}}r=c;return q|0}else E=0;while(0);k[i+888>>2]=E;k[o+884>>2]=8;q=1;r=c;return q|0}function Yf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0;d=r;r=r+16|0;e=d+4|0;f=k[a+576>>2]|0;g=a+604|0;h=f+800|0;k[h>>2]=k[g>>2];i=a+608|0;j=f+804|0;k[j>>2]=k[i>>2];l=f+840|0;m=k[l>>2]|0;if(!m){n=0;r=d;return n|0}o=(c|0)/(m|0)|0;if((c|0)%(m|0)|0)ie(k[a+628>>2]|0,k[a>>2]|0,145243,d);m=k[f+32>>2]|0;c=(o|0)>(m|0)?m:o;a:do if(c){o=a+444|0;m=b;p=c;while(1){k[e>>2]=m;if((zg(f,e)|0)!=1){n=0;break}k[o>>2]=(k[o>>2]|0)+1;if((p|0)>1){m=m+(k[l>>2]|0)|0;p=p+-1|0}else break a}r=d;return n|0}while(0);k[g>>2]=k[h>>2];k[i>>2]=k[j>>2];if((k[f+140>>2]|0)>>>0<(k[f+116>>2]|0)>>>0)q=1;else q=(Ag(f)|0)!=0;n=q&1;r=d;return n|0}function Zf(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,l=0,n=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0.0;b=r;r=r+96|0;c=b+56|0;d=b+48|0;e=b+40|0;f=b+32|0;g=b+24|0;h=b+16|0;i=b+8|0;l=b;n=b+88|0;p=b+64|0;q=a+576|0;s=k[q>>2]|0;t=s+488|0;if(k[t>>2]|0){if(k[s+16>>2]|0){eg(s);k[t>>2]=0;u=4}}else u=4;do if((u|0)==4){if(ng(s)|0){k[t>>2]=1;break}if(!s)Ja(154187,144647,1590,144952)}while(0);if(k[s+16>>2]|0)Ja(144876,144647,1591,144952);t=j[a+90>>1]|0;u=s+832|0;j[u>>1]=t;a:do if((j[a+126>>1]|0)==1){v=j[a+98>>1]|0;k[s+36>>2]=v&65535;if(t<<16>>16==6){w=s+40|0;if((k[s+924>>2]|0)==1){k[w>>2]=2;break}else{k[w>>2]=3;break}}b:do if((t&65535)<2){if(v<<16>>16==1){k[s+40>>2]=1;break a}}else switch(t<<16>>16){case 2:{if(v<<16>>16!=3)break b;k[s+40>>2]=2;break a;break}case 5:{if(v<<16>>16!=4)break b;k[s+40>>2]=4;break a;break}default:break b}while(0);k[s+40>>2]=0}else{k[s+36>>2]=1;k[s+40>>2]=0}while(0);if(!(og(s)|0)){x=0;r=b;return x|0}t=m[u>>1]|0;switch(t|0){case 6:{j[s+834>>1]=j[a+192>>1]|0;j[s+836>>1]=j[a+194>>1]|0;k[l>>2]=n;if(!(Pb(a,532,l)|0)){l=1<<m[a+84>>1];o[p>>2]=0.0;y=+(l+-1|0);o[p+4>>2]=y;z=+(l>>1|0);o[p+8>>2]=z;o[p+12>>2]=y;o[p+16>>2]=z;o[p+20>>2]=y;k[i>>2]=p;Ob(a,532,i)|0}break}case 4:case 3:{i=k[a+628>>2]|0;k[h>>2]=t;vc(i,144952,144968,h);x=0;r=b;return x|0}default:{j[s+834>>1]=1;j[s+836>>1]=1}}h=j[a+84>>1]|0;i=h&65535;if(h<<16>>16!=8){h=k[a+628>>2]|0;k[g>>2]=i;vc(h,144952,145018,g);x=0;r=b;return x|0}k[s+72>>2]=i;i=a+12|0;if(!(k[i>>2]&1024)){g=k[a+100>>2]|0;if(g>>>0<(k[a+60>>2]|0)>>>0?(h=m[s+836>>1]<<3,((g>>>0)%(h>>>0)|0|0)!=0):0){g=k[a+628>>2]|0;k[d>>2]=h;vc(g,144952,145135,d);x=0;r=b;return x|0}}else{d=m[s+836>>1]<<3;if(((k[a+72>>2]|0)>>>0)%(d>>>0)|0){g=k[a+628>>2]|0;k[f>>2]=d;vc(g,144952,145056,f);x=0;r=b;return x|0}f=m[s+834>>1]<<3;if(((k[a+68>>2]|0)>>>0)%(f>>>0)|0){g=k[a+628>>2]|0;k[e>>2]=f;vc(g,144952,145096,e);x=0;r=b;return x|0}}do if(k[s+928>>2]&3){e=k[s+912>>2]|0;if((e|0)!=0?(Lq(e,145180,8)|0)!=0:0)break;e=k[q>>2]|0;if(!(jg(e,k[e+920>>2]|0)|0)){x=0;r=b;return x|0}if(!(pg(e)|0)){x=0;r=b;return x|0}g=k[e+928>>2]|0;if(g&1){f=e+88|0;d=k[f>>2]|0;if(d)k[d+128>>2]=0;if((j[e+832>>1]|0)==6?(d=k[f+4>>2]|0,(d|0)!=0):0)k[d+128>>2]=0}if(g&2){g=e+120|0;d=k[g>>2]|0;if(d)k[d+276>>2]=0;d=e+136|0;f=k[d>>2]|0;if(f)k[f+276>>2]=0;if((j[e+832>>1]|0)==6){f=k[g+4>>2]|0;if(f)k[f+276>>2]=0;f=k[d+4>>2]|0;if(f)k[f+276>>2]=0}}f=e+912|0;d=k[f>>2]|0;if(d)ne(d);d=e+916|0;k[d>>2]=1e3;g=me(1e3)|0;k[f>>2]=g;if(!g){k[d>>2]=0;vc(k[(k[e+828>>2]|0)+628>>2]|0,145190,145211,c);x=0;r=b;return x|0}k[e+24>>2]=e+780;k[e+788>>2]=8;k[e+792>>2]=17;k[e+796>>2]=9;if(!(tg(e)|0)){x=0;r=b;return x|0}else{k[i>>2]=k[i>>2]|8;e=a+48|0;k[e>>2]=k[e>>2]|4;break}}else{e=a+48|0;k[e>>2]=k[e>>2]&-5}while(0);k[s+24>>2]=s+780;k[s+788>>2]=10;k[s+792>>2]=18;k[s+796>>2]=11;x=1;r=b;return x|0}function _f(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0;c=r;r=r+16|0;d=c;e=a+576|0;f=k[e>>2]|0;if(!f)Ja(154187,144647,1745,144862);g=f+16|0;h=k[g>>2]|0;if((h|0)==1){ub[k[a+516>>2]&63](a)|0;i=k[g>>2]|0}else i=h;if(i)Ja(144876,144647,1752,144862);if(!(k[a+12>>2]&1024)){i=k[a+56>>2]|0;h=(k[a+60>>2]|0)-(k[a+444>>2]|0)|0;g=k[a+100>>2]|0;l=Pd(a)|0;n=h>>>0>g>>>0?g:h;o=i}else{i=k[a+68>>2]|0;h=k[a+72>>2]|0;l=de(a)|0;n=h;o=i}k[f+840>>2]=l;l=j[a+126>>1]|0;i=b<<16>>16==0;if(!(i|l<<16>>16!=2)){h=m[f+834>>1]|0;if(o>>>0<(0-h|0)>>>0)p=((o+-1+h|0)>>>0)/(h>>>0)|0;else p=0;h=m[f+836>>1]|0;if(n>>>0<(0-h|0)>>>0){q=((n+-1+h|0)>>>0)/(h>>>0)|0;s=p}else{q=0;s=p}}else{q=n;s=o}if((q|s)>>>0>65535){vc(k[a+628>>2]|0,144862,144908,d);t=0;r=c;return t|0}k[f+28>>2]=s;k[f+32>>2]=q;do if(l<<16>>16==1){k[f+36>>2]=m[a+98>>1];if((j[f+832>>1]|0)!=6){if(!(ig(f,k[f+40>>2]|0)|0))t=0;else{u=0;break}r=c;return t|0}do if((k[f+924>>2]|0)==1)v=0;else{if((j[f+834>>1]|0)==1?(j[f+836>>1]|0)==1:0){v=0;break}v=1}while(0);if(!(ig(f,3)|0)){t=0;r=c;return t|0}else{q=k[f+84>>2]|0;k[q+8>>2]=m[f+834>>1];k[q+12>>2]=m[f+836>>1];u=v;break}}else{if(!(ig(f,0)|0)){t=0;r=c;return t|0}q=k[f+84>>2]|0;k[q>>2]=b&65535;if(i|(j[f+832>>1]|0)!=6)u=0;else{k[q+16>>2]=1;k[q+20>>2]=1;k[q+24>>2]=1;u=0}}while(0);k[f+244>>2]=0;k[f+256>>2]=0;if(!(jg(f,k[f+920>>2]|0)|0)){t=0;r=c;return t|0}i=k[f+928>>2]|0;b=f+88|0;v=k[b>>2]|0;l=(v|0)==0;if(!(i&1)){if(!l)k[v+128>>2]=0;q=k[b+4>>2]|0;if(q)k[q+128>>2]=0}else{if(!l)k[v+128>>2]=1;v=k[b+4>>2]|0;if(v)k[v+128>>2]=1}if(!(i&2))k[f+216>>2]=1;else{i=f+120|0;v=k[i>>2]|0;if(v)k[v+276>>2]=1;v=f+136|0;b=k[v>>2]|0;if(b)k[b+276>>2]=1;b=k[i+4>>2]|0;if(b)k[b+276>>2]=1;b=k[v+4>>2]|0;if(b)k[b+276>>2]=1;k[f+216>>2]=0}b=(u|0)!=0;k[f+208>>2]=b&1;k[a+536>>2]=b?24:21;k[a+544>>2]=b?24:21;k[a+552>>2]=b?24:21;if(!(lg(f)|0)){t=0;r=c;return t|0}if(b){b=k[f+76>>2]|0;a=k[e>>2]|0;a:do if((b|0)>0){e=0;u=k[f+84>>2]|0;v=0;while(1){i=k[u+8>>2]|0;l=k[u+12>>2]|0;q=mg(a,k[u+28>>2]<<3,l<<3)|0;if(!q){t=0;break}s=(ha(l,i)|0)+v|0;k[a+844+(e<<2)>>2]=q;e=e+1|0;if((e|0)>=(b|0)){w=s;break a}else{u=u+88|0;v=s}}r=c;return t|0}else w=0;while(0);k[a+888>>2]=w}k[f+884>>2]=0;t=1;r=c;return t|0}function $f(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;b=a+576|0;a=k[b>>2]|0;c=a+884|0;d=k[c>>2]|0;do if((d|0)>0){e=a+76|0;f=k[e>>2]|0;a:do if((f|0)>0){g=d;h=f;i=0;j=k[a+84>>2]|0;while(1){l=k[j+12>>2]|0;m=k[j+28>>2]<<3;n=ha(g,l)|0;if((n|0)<(l<<3|0)){o=a+844+(i<<2)|0;p=l<<3;l=n;do{n=k[o>>2]|0;qe(k[n+(l<<2)>>2]|0,k[n+(l+-1<<2)>>2]|0,m);l=l+1|0}while((l|0)!=(p|0));q=k[e>>2]|0}else q=h;p=i+1|0;if((p|0)>=(q|0))break a;g=k[c>>2]|0;h=q;i=p;j=j+88|0}}while(0);e=k[a+276>>2]<<3;if((gg(a,a+844|0,e)|0)==(e|0)){r=k[b>>2]|0;break}else{s=0;return s|0}}else r=a;while(0);s=hg(r)|0;return s|0}function ag(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;d=r;r=r+16|0;e=d+8|0;f=d+12|0;g=k[a+576>>2]|0;if(!g)Ja(154187,144647,1883,144795);h=g+840|0;j=k[h>>2]|0;m=(c|0)/(j|0)|0;if((c|0)%(j|0)|0)ie(k[a+628>>2]|0,k[a>>2]|0,144806,d);if(!(k[a+12>>2]&1024)){j=k[a+444>>2]|0;c=k[a+60>>2]|0;n=(j+m|0)>>>0>c>>>0?c-j|0:m}else n=m;m=g+72|0;j=k[m>>2]|0;if((j|0)==12){c=(k[h>>2]<<1|0)/3|0;o=me(c<<1)|0;if(!o){vc(k[a+628>>2]|0,144795,144836,e);p=0;r=d;return p|0}else{q=b;s=o;t=c;u=n;v=10}}else{w=b;x=j;y=0;z=0;A=n}while(1){if((v|0)==10){v=0;w=q;x=k[m>>2]|0;y=s;z=t;A=u}n=A+-1|0;B=(x|0)==12;if((A|0)<=0)break;if(B){j=(z|0)/2|0;k[f>>2]=y;if((z|0)>1){b=0;do{c=b*3|0;o=y+(b<<1<<1)|0;i[o>>0]=(l[w+(c+1)>>0]|0)>>>4|(l[w+c>>0]|0)<<4;i[o+1>>0]=i[w+(c+2)>>0]|0;b=b+1|0}while((b|0)<(j|0))}C=f}else{k[f>>2]=w;C=f}if((fg(g,C)|0)!=1){p=0;v=23;break}if((A|0)>1){j=a+444|0;k[j>>2]=(k[j>>2]|0)+1}q=w+(k[h>>2]|0)|0;s=y;t=z;u=n;v=10}if((v|0)==23){r=d;return p|0}if(!B){p=1;r=d;return p|0}ne(y);p=1;r=d;return p|0}function bg(a){a=a|0;var b=0,c=0,d=0,e=0;b=a+576|0;c=k[b>>2]|0;if(!c)Ja(154168,144647,2075,144783);k[a+672>>2]=k[c+892>>2];k[a+668>>2]=k[c+896>>2];k[a+676>>2]=k[c+900>>2];if(k[c+488>>2]|0)eg(c);d=k[c+912>>2]|0;if(!d){e=k[b>>2]|0;ne(e);k[b>>2]=0;Ve(a);return}ne(d);e=k[b>>2]|0;ne(e);k[b>>2]=0;Ve(a);return}function cg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=yb[k[(k[a+576>>2]|0)+904>>2]&127](a,b)|0;if(c>>>0>=(k[a+60>>2]|0)>>>0){d=c;return d|0}b=m[a+194>>1]|0;a=b<<3;if(c>>>0<(0-a|0)>>>0)e=(((c+-1+a|0)>>>0)/(a>>>0)|0)<<3;else e=0;d=ha(e,b)|0;return d|0}function dg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;vb[k[(k[a+576>>2]|0)+908>>2]&127](a,b,c);d=k[b>>2]|0;e=m[a+192>>1]|0;f=e<<3;if(d>>>0<(0-f|0)>>>0)g=(((d+-1+f|0)>>>0)/(f>>>0)|0)<<3;else g=0;f=ha(g,e)|0;k[b>>2]=f;f=k[c>>2]|0;b=m[a+194>>1]|0;a=b<<3;if(f>>>0>=(0-a|0)>>>0){h=0;i=ha(h,b)|0;k[c>>2]=i;return}h=(((f+-1+a|0)>>>0)/(a>>>0)|0)<<3;i=ha(h,b)|0;k[c>>2]=i;return}function eg(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0;b=4;c=jr(40)|0;k[c>>2]=0;c=tr(a+624|0,1,c|0,b|0)|0;b=L;w=0;d=w;w=0;if((d|0)!=0&(x|0)!=0){e=vr(k[d>>2]|0,c|0,b|0)|0;if(!e)La(d|0,x|0);L=x}else e=-1;if((e|0)==1)f=L;else f=0;while(1){if(f){g=6;break}w=0;pa(12,a|0);e=w;w=0;if((e|0)!=0&(x|0)!=0){h=vr(k[e>>2]|0,c|0,b|0)|0;if(!h)La(e|0,x|0);L=x}else h=-1;if((h|0)==1)f=L;else break}if((g|0)==6){kr(c|0);return}kr(c|0);return}function fg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0;c=4;d=jr(40)|0;k[d>>2]=0;d=tr(a+624|0,1,d|0,c|0)|0;c=L;w=0;e=w;w=0;if((e|0)!=0&(x|0)!=0){f=vr(k[e>>2]|0,d|0,c|0)|0;if(!f)La(e|0,x|0);L=x}else f=-1;if((f|0)==1)g=L;else g=0;while(1){if(g){h=-1;i=6;break}w=0;j=ma(15,a|0,b|0,1)|0;f=w;w=0;if((f|0)!=0&(x|0)!=0){l=vr(k[f>>2]|0,d|0,c|0)|0;if(!l)La(f|0,x|0);L=x}else l=-1;if((l|0)==1)g=L;else break}if((i|0)==6){kr(d|0);return h|0}h=j;kr(d|0);return h|0}function gg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0;d=4;e=jr(40)|0;k[e>>2]=0;e=tr(a+624|0,1,e|0,d|0)|0;d=L;w=0;f=w;w=0;if((f|0)!=0&(x|0)!=0){g=vr(k[f>>2]|0,e|0,d|0)|0;if(!g)La(f|0,x|0);L=x}else g=-1;if((g|0)==1)h=L;else h=0;while(1){if(h){i=-1;j=6;break}w=0;l=ma(16,a|0,b|0,c|0)|0;g=w;w=0;if((g|0)!=0&(x|0)!=0){m=vr(k[g>>2]|0,e|0,d|0)|0;if(!m)La(g|0,x|0);L=x}else m=-1;if((m|0)==1)h=L;else break}if((j|0)==6){kr(e|0);return i|0}i=l;kr(e|0);return i|0}function hg(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;b=4;c=jr(40)|0;k[c>>2]=0;c=tr(a+624|0,1,c|0,b|0)|0;b=L;w=0;d=w;w=0;if((d|0)!=0&(x|0)!=0){e=vr(k[d>>2]|0,c|0,b|0)|0;if(!e)La(d|0,x|0);L=x}else e=-1;if((e|0)==1)f=L;else f=0;while(1){if(f){g=0;h=6;break}w=0;pa(13,a|0);e=w;w=0;if((e|0)!=0&(x|0)!=0){i=vr(k[e>>2]|0,c|0,b|0)|0;if(!i)La(e|0,x|0);L=x}else i=-1;if((i|0)==1)f=L;else break}if((h|0)==6){kr(c|0);return g|0}g=1;kr(c|0);return g|0}function ig(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;c=4;d=jr(40)|0;k[d>>2]=0;d=tr(a+624|0,1,d|0,c|0)|0;c=L;w=0;e=w;w=0;if((e|0)!=0&(x|0)!=0){f=vr(k[e>>2]|0,d|0,c|0)|0;if(!f)La(e|0,x|0);L=x}else f=-1;if((f|0)==1)g=L;else g=0;while(1){if(g){h=0;i=6;break}w=0;qa(2,a|0,b|0);f=w;w=0;if((f|0)!=0&(x|0)!=0){j=vr(k[f>>2]|0,d|0,c|0)|0;if(!j)La(f|0,x|0);L=x}else j=-1;if((j|0)==1)g=L;else break}if((i|0)==6){kr(d|0);return h|0}h=1;kr(d|0);return h|0}function jg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;c=4;d=jr(40)|0;k[d>>2]=0;d=tr(a+624|0,1,d|0,c|0)|0;c=L;w=0;e=w;w=0;if((e|0)!=0&(x|0)!=0){f=vr(k[e>>2]|0,d|0,c|0)|0;if(!f)La(e|0,x|0);L=x}else f=-1;if((f|0)==1)g=L;else g=0;while(1){if(g){h=0;i=6;break}w=0;ua(12,a|0,b|0,0);f=w;w=0;if((f|0)!=0&(x|0)!=0){j=vr(k[f>>2]|0,d|0,c|0)|0;if(!j)La(f|0,x|0);L=x}else j=-1;if((j|0)==1)g=L;else break}if((i|0)==6){kr(d|0);return h|0}h=1;kr(d|0);return h|0}function kg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0;d=r;r=r+16|0;e=k[a+576>>2]|0;f=k[e+888>>2]|0;if(!e)Ja(154187,144647,1965,144938);g=m[e+834>>1]|0;h=e+836|0;j=m[h>>1]|0;l=(ha(j,g)|0)+2|0;n=((ha(ha(k[e+72>>2]|0,(((k[e+28>>2]|0)+-1+g|0)>>>0)/(g>>>0)|0)|0,l)|0)+7|0)>>>3;l=ha((c|0)/(n|0)|0,j)|0;if((c|0)%(n|0)|0)ie(k[a+628>>2]|0,k[a>>2]|0,144806,d);c=e+84|0;j=k[(k[c>>2]|0)+132>>2]|0;g=e+276|0;if((l|0)<=0){o=1;r=d;return o|0}p=e+76|0;q=e+884|0;s=e+844|0;t=a+444|0;a=(j|0)==0;u=b;b=l;while(1){l=k[p>>2]|0;if((l|0)>0){v=l;l=0;w=0;x=k[c>>2]|0;while(1){y=k[x+8>>2]|0;z=k[x+12>>2]|0;A=k[x+28>>2]|0;B=ha(y,j)|0;if((z|0)>0){C=e+844+(l<<2)|0;D=(y|0)==1;E=((A<<3)-B|0)>0;F=(A<<3)-B|0;B=ha(y,z)|0;A=a|(y|0)<1;G=w;H=0;while(1){I=u+G|0;J=(ha(k[q>>2]|0,z)|0)+H|0;K=k[(k[C>>2]|0)+(J<<2)>>2]|0;if(D)if(a)L=K;else{J=I;M=j;N=K;while(1){M=M+-1|0;i[N>>0]=i[J>>0]|0;if(!M)break;else{J=J+f|0;N=N+1|0}}L=K+j|0}else if(A)L=K;else{N=j;J=I;M=K;while(1){N=N+-1|0;O=M;P=0;while(1){i[O>>0]=i[J+P>>0]|0;P=P+1|0;if((P|0)==(y|0))break;else O=O+1|0}O=M+y|0;if(!N){L=O;break}else{J=J+f|0;M=O}}}if(E){M=L;J=0;while(1){i[M>>0]=i[M+-1>>0]|0;J=J+1|0;if((J|0)==(F|0))break;else M=M+1|0}}H=H+1|0;if((H|0)==(z|0))break;else G=G+y|0}Q=k[p>>2]|0;R=w+B|0}else{Q=v;R=w}l=l+1|0;if((l|0)>=(Q|0))break;else{v=Q;w=R;x=x+88|0}}}x=k[q>>2]|0;k[q>>2]=x+1;if((x|0)>6){x=k[g>>2]<<3;if((gg(e,s,x)|0)!=(x|0)){o=0;S=28;break}k[q>>2]=0}x=m[h>>1]|0;k[t>>2]=(k[t>>2]|0)+x;b=b-x|0;if((b|0)<=0){o=1;S=28;break}else u=u+n|0}if((S|0)==28){r=d;return o|0}return 0}function lg(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;b=4;c=jr(40)|0;k[c>>2]=0;c=tr(a+624|0,1,c|0,b|0)|0;b=L;w=0;d=w;w=0;if((d|0)!=0&(x|0)!=0){e=vr(k[d>>2]|0,c|0,b|0)|0;if(!e)La(d|0,x|0);L=x}else e=-1;if((e|0)==1)f=L;else f=0;while(1){if(f){g=0;h=6;break}w=0;qa(3,a|0,0);e=w;w=0;if((e|0)!=0&(x|0)!=0){i=vr(k[e>>2]|0,c|0,b|0)|0;if(!i)La(e|0,x|0);L=x}else i=-1;if((i|0)==1)f=L;else break}if((h|0)==6){kr(c|0);return g|0}g=1;kr(c|0);return g|0}function mg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0;d=4;e=jr(40)|0;k[e>>2]=0;e=tr(a+624|0,1,e|0,d|0)|0;d=L;w=0;f=w;w=0;if((f|0)!=0&(x|0)!=0){g=vr(k[f>>2]|0,e|0,d|0)|0;if(!g)La(f|0,x|0);L=x}else g=-1;if((g|0)==1)h=L;else h=0;while(1){if(h){i=0;j=6;break}w=0;l=wa(k[(k[a+4>>2]|0)+8>>2]|0,a|0,1,b|0,c|0)|0;g=w;w=0;if((g|0)!=0&(x|0)!=0){m=vr(k[g>>2]|0,e|0,d|0)|0;if(!m)La(g|0,x|0);L=x}else m=-1;if((m|0)==1)h=L;else break}if((j|0)==6){kr(e|0);return i|0}i=l;kr(e|0);return i|0}function ng(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0;b=4;c=jr(40)|0;k[c>>2]=0;d=a+492|0;w=0;e=ta(19,d|0)|0;f=w;w=0;if((f|0)!=0&(x|0)!=0){g=vr(k[f>>2]|0,c|0,b|0)|0;if(!g)La(f|0,x|0);L=x}else g=-1;if((g|0)!=1){k[a>>2]=e;k[d>>2]=14;k[a+500>>2]=15;k[a+12>>2]=0;c=tr(a+624|0,1,c|0,b|0)|0;b=L;w=0;d=w;w=0;if((d|0)!=0&(x|0)!=0){h=vr(k[d>>2]|0,c|0,b|0)|0;if(!h)La(d|0,x|0);L=x}else h=-1;if((h|0)!=1)i=0;else i=L}else i=L;while(1){if(i){j=0;l=7;break}w=0;ua(13,a|0,90,440);h=w;w=0;if((h|0)!=0&(x|0)!=0){m=vr(k[h>>2]|0,c|0,b|0)|0;if(!m)La(h|0,x|0);L=x}else m=-1;if((m|0)==1)i=L;else break}if((l|0)==7){kr(c|0);return j|0}j=1;kr(c|0);return j|0}function og(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;b=4;c=jr(40)|0;k[c>>2]=0;c=tr(a+624|0,1,c|0,b|0)|0;b=L;w=0;d=w;w=0;if((d|0)!=0&(x|0)!=0){e=vr(k[d>>2]|0,c|0,b|0)|0;if(!e)La(d|0,x|0);L=x}else e=-1;if((e|0)==1)f=L;else f=0;while(1){if(f){g=0;h=6;break}w=0;pa(16,a|0);e=w;w=0;if((e|0)!=0&(x|0)!=0){i=vr(k[e>>2]|0,c|0,b|0)|0;if(!i)La(e|0,x|0);L=x}else i=-1;if((i|0)==1)f=L;else break}if((h|0)==6){kr(c|0);return g|0}g=1;kr(c|0);return g|0}function pg(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;b=4;c=jr(40)|0;k[c>>2]=0;c=tr(a+624|0,1,c|0,b|0)|0;b=L;w=0;d=w;w=0;if((d|0)!=0&(x|0)!=0){e=vr(k[d>>2]|0,c|0,b|0)|0;if(!e)La(d|0,x|0);L=x}else e=-1;if((e|0)==1)f=L;else f=0;while(1){if(f){g=0;h=6;break}w=0;qa(4,a|0,1);e=w;w=0;if((e|0)!=0&(x|0)!=0){i=vr(k[e>>2]|0,c|0,b|0)|0;if(!i)La(e|0,x|0);L=x}else i=-1;if((i|0)==1)f=L;else break}if((h|0)==6){kr(c|0);return g|0}g=1;kr(c|0);return g|0}function qg(a){a=a|0;k[a+780>>2]=k[a+912>>2];k[a+784>>2]=k[a+916>>2];return}function rg(a){a=a|0;var b=0,c=0,d=0,e=0;b=a+912|0;c=a+916|0;d=oe(k[b>>2]|0,(k[c>>2]|0)+1e3|0)|0;if(!d){e=k[a>>2]|0;k[e+20>>2]=56;k[e+24>>2]=100;qb[k[e>>2]&127](a)}e=k[c>>2]|0;k[a+780>>2]=d+e;k[a+784>>2]=1e3;k[b>>2]=d;k[c>>2]=e+1e3;return 1}function sg(a){a=a|0;var b=0;b=a+916|0;k[b>>2]=(k[b>>2]|0)-(k[a+784>>2]|0);return}function tg(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;b=4;c=jr(40)|0;k[c>>2]=0;c=tr(a+624|0,1,c|0,b|0)|0;b=L;w=0;d=w;w=0;if((d|0)!=0&(x|0)!=0){e=vr(k[d>>2]|0,c|0,b|0)|0;if(!e)La(d|0,x|0);L=x}else e=-1;if((e|0)==1)f=L;else f=0;while(1){if(f){g=0;h=6;break}w=0;pa(17,a|0);e=w;w=0;if((e|0)!=0&(x|0)!=0){i=vr(k[e>>2]|0,c|0,b|0)|0;if(!i)La(e|0,x|0);L=x}else i=-1;if((i|0)==1)f=L;else break}if((h|0)==6){kr(c|0);return g|0}g=1;kr(c|0);return g|0}function ug(a){a=a|0;var b=0;b=k[a+828>>2]|0;k[a+780>>2]=k[b+588>>2];k[a+784>>2]=k[b+592>>2];return}function vg(a){a=a|0;var b=0,c=0;b=k[a+828>>2]|0;c=b+592|0;k[b+608>>2]=k[c>>2];je(b)|0;k[a+780>>2]=k[b+588>>2];k[a+784>>2]=k[c>>2];return 1}function wg(a){a=a|0;var b=0;b=k[a+828>>2]|0;k[b+604>>2]=k[a+780>>2];k[b+608>>2]=(k[b+592>>2]|0)-(k[a+784>>2]|0);return}function xg(a){a=a|0;var b=0,c=0,d=0;b=r;r=r+208|0;c=b;d=b+8|0;rb[k[(k[a>>2]|0)+12>>2]&31](a,d);b=k[(k[a+828>>2]|0)+628>>2]|0;k[c>>2]=d;vc(b,145235,154321,c);Ak(a);La(a+624|0,1)}function yg(a){a=a|0;var b=0,c=0,d=0,e=0;b=r;r=r+208|0;c=b;d=b+8|0;rb[k[(k[a>>2]|0)+12>>2]&31](a,d);e=k[(k[a+828>>2]|0)+628>>2]|0;k[c>>2]=d;ie(e,145235,154321,c);r=b;return}function zg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0;c=4;d=jr(40)|0;k[d>>2]=0;d=tr(a+624|0,1,d|0,c|0)|0;c=L;w=0;e=w;w=0;if((e|0)!=0&(x|0)!=0){f=vr(k[e>>2]|0,d|0,c|0)|0;if(!f)La(e|0,x|0);L=x}else f=-1;if((f|0)==1)g=L;else g=0;while(1){if(g){h=-1;i=6;break}w=0;j=ma(17,a|0,b|0,1)|0;f=w;w=0;if((f|0)!=0&(x|0)!=0){l=vr(k[f>>2]|0,d|0,c|0)|0;if(!l)La(f|0,x|0);L=x}else l=-1;if((l|0)==1)g=L;else break}if((i|0)==6){kr(d|0);return h|0}h=j;kr(d|0);return h|0}function Ag(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;b=4;c=jr(40)|0;k[c>>2]=0;c=tr(a+624|0,1,c|0,b|0)|0;b=L;w=0;d=w;w=0;if((d|0)!=0&(x|0)!=0){e=vr(k[d>>2]|0,c|0,b|0)|0;if(!e)La(d|0,x|0);L=x}else e=-1;if((e|0)==1)f=L;else f=0;while(1){if(f){g=-1;h=6;break}w=0;i=ta(20,a|0)|0;e=w;w=0;if((e|0)!=0&(x|0)!=0){j=vr(k[e>>2]|0,c|0,b|0)|0;if(!j)La(e|0,x|0);L=x}else j=-1;if((j|0)==1)f=L;else break}if((h|0)==6){kr(c|0);return g|0}g=i;kr(c|0);return g|0}function Bg(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;b=4;c=jr(40)|0;k[c>>2]=0;c=tr(a+624|0,1,c|0,b|0)|0;b=L;w=0;d=w;w=0;if((d|0)!=0&(x|0)!=0){e=vr(k[d>>2]|0,c|0,b|0)|0;if(!e)La(d|0,x|0);L=x}else e=-1;if((e|0)==1)f=L;else f=0;while(1){if(f){g=0;h=6;break}w=0;pa(18,a|0);e=w;w=0;if((e|0)!=0&(x|0)!=0){i=vr(k[e>>2]|0,c|0,b|0)|0;if(!i)La(e|0,x|0);L=x}else i=-1;if((i|0)==1)f=L;else break}if((h|0)==6){kr(c|0);return g|0}g=1;kr(c|0);return g|0}function Cg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0;c=4;d=jr(40)|0;k[d>>2]=0;d=tr(a+624|0,1,d|0,c|0)|0;c=L;w=0;e=w;w=0;if((e|0)!=0&(x|0)!=0){f=vr(k[e>>2]|0,d|0,c|0)|0;if(!f)La(e|0,x|0);L=x}else f=-1;if((f|0)==1)g=L;else g=0;while(1){if(g){h=-1;i=6;break}w=0;j=xa(30,a|0,b|0)|0;f=w;w=0;if((f|0)!=0&(x|0)!=0){l=vr(k[f>>2]|0,d|0,c|0)|0;if(!l)La(f|0,x|0);L=x}else l=-1;if((l|0)==1)g=L;else break}if((i|0)==6){kr(d|0);return h|0}h=j;kr(d|0);return h|0}function Dg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;d=r;r=r+16|0;vc(k[a+628>>2]|0,145746,145763,d);r=d;return 0}function Eg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0;d=r;r=r+16|0;e=d+8|0;f=d;g=k[a+576>>2]|0;h=k[g+32>>2]|0;a:do if(h){j=g+216|0;l=k[(k[j>>2]|0)+132>>2]|0;n=k[g+888>>2]|0;o=g+840|0;p=g+884|0;q=g+320|0;s=g+844|0;t=g+36|0;u=g+836|0;v=a+444|0;w=l+-1|0;x=ha(n,w)|0;y=(l|0)==0;z=b;A=c;B=k[o>>2]|0;C=h;b:while(1){if((A|0)<(B|0)){D=4;break}E=k[p>>2]|0;if((E|0)>7){F=k[q>>2]<<3;if((Gg(g,s,F)|0)!=(F|0)){G=0;D=32;break}k[p>>2]=0;H=0}else H=E;if((k[t>>2]|0)>0){E=0;F=0;I=k[j>>2]|0;while(1){J=k[I+8>>2]|0;K=k[I+12>>2]|0;c:do if((K|0)>0){L=g+844+(E<<2)|0;M=J+x|0;if((J|0)==1){N=F;O=0;while(1){if((A|0)<(M+N|0)){D=19;break b}if(!y){P=(k[L>>2]|0)+((ha(k[p>>2]|0,K)|0)+O<<2)|0;Q=k[P>>2]|0;P=l;R=z+N|0;while(1){P=P+-1|0;i[R>>0]=i[Q>>0]|0;if(!P)break;else{Q=Q+1|0;R=R+n|0}}}R=N+1|0;O=O+1|0;if((O|0)>=(K|0)){S=R;break c}else N=R}}N=y|(J|0)<1;O=F;R=0;while(1){if((A|0)<(M+O|0)){D=19;break b}if(!N){Q=(k[L>>2]|0)+((ha(k[p>>2]|0,K)|0)+R<<2)|0;P=w;T=k[Q>>2]|0;Q=z+O|0;while(1){U=T;V=0;while(1){i[Q+V>>0]=i[U>>0]|0;V=V+1|0;if((V|0)==(J|0))break;else U=U+1|0}if(!P)break;else{P=P+-1|0;T=T+J|0;Q=Q+n|0}}}Q=O+J|0;R=R+1|0;if((R|0)>=(K|0)){S=Q;break}else O=Q}}else S=F;while(0);E=E+1|0;if((E|0)>=(k[t>>2]|0))break;else{F=S;I=I+88|0}}W=k[p>>2]|0}else W=H;k[p>>2]=W+1;I=m[u>>1]|0;k[v>>2]=(k[v>>2]|0)+I;F=k[o>>2]|0;C=C-I|0;if((C|0)<=0)break a;else{z=z+F|0;A=A-F|0;B=F}}if((D|0)==4){vc(k[a+628>>2]|0,145605,145619,f);G=0;r=d;return G|0}else if((D|0)==19){vc(k[a+628>>2]|0,145605,145669,e);G=0;r=d;return G|0}else if((D|0)==32){r=d;return G|0}}while(0);if((k[g+140>>2]|0)>>>0<(k[g+116>>2]|0)>>>0)X=1;else X=(Ag(g)|0)!=0;G=X&1;r=d;return G|0}function Fg(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;b=4;c=jr(40)|0;k[c>>2]=0;c=tr(a+624|0,1,c|0,b|0)|0;b=L;w=0;d=w;w=0;if((d|0)!=0&(x|0)!=0){e=vr(k[d>>2]|0,c|0,b|0)|0;if(!e)La(d|0,x|0);L=x}else e=-1;if((e|0)==1)f=L;else f=0;while(1){if(f){g=0;h=6;break}w=0;ta(21,a|0)|0;e=w;w=0;if((e|0)!=0&(x|0)!=0){i=vr(k[e>>2]|0,c|0,b|0)|0;if(!i)La(e|0,x|0);L=x}else i=-1;if((i|0)==1)f=L;else break}if((h|0)==6){kr(c|0);return g|0}g=1;kr(c|0);return g|0}function Gg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0;d=4;e=jr(40)|0;k[e>>2]=0;e=tr(a+624|0,1,e|0,d|0)|0;d=L;w=0;f=w;w=0;if((f|0)!=0&(x|0)!=0){g=vr(k[f>>2]|0,e|0,d|0)|0;if(!g)La(f|0,x|0);L=x}else g=-1;if((g|0)==1)h=L;else h=0;while(1){if(h){i=-1;j=6;break}w=0;l=ma(18,a|0,b|0,c|0)|0;g=w;w=0;if((g|0)!=0&(x|0)!=0){m=vr(k[g>>2]|0,e|0,d|0)|0;if(!m)La(g|0,x|0);L=x}else m=-1;if((m|0)==1)h=L;else break}if((j|0)==6){kr(e|0);return i|0}i=l;kr(e|0);return i|0}function Hg(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0;b=4;c=jr(40)|0;k[c>>2]=0;d=a+492|0;w=0;e=ta(19,d|0)|0;f=w;w=0;if((f|0)!=0&(x|0)!=0){g=vr(k[f>>2]|0,c|0,b|0)|0;if(!g)La(f|0,x|0);L=x}else g=-1;if((g|0)!=1){k[a>>2]=e;k[d>>2]=14;k[a+500>>2]=15;k[a+12>>2]=0;c=tr(a+624|0,1,c|0,b|0)|0;b=L;w=0;d=w;w=0;if((d|0)!=0&(x|0)!=0){h=vr(k[d>>2]|0,c|0,b|0)|0;if(!h)La(d|0,x|0);L=x}else h=-1;if((h|0)!=1)i=0;else i=L}else i=L;while(1){if(i){j=0;l=7;break}w=0;ua(14,a|0,90,488);h=w;w=0;if((h|0)!=0&(x|0)!=0){m=vr(k[h>>2]|0,c|0,b|0)|0;if(!m)La(h|0,x|0);L=x}else m=-1;if((m|0)==1)i=L;else break}if((l|0)==7){kr(c|0);return j|0}j=1;kr(c|0);return j|0}function Ig(a){a=a|0;var b=0;b=k[a>>2]|0;k[b+20>>2]=123;rb[k[b+4>>2]&31](a,-1);b=a+800|0;k[b>>2]=145943;k[b+4>>2]=2;return 1}function Jg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0;if((b|0)<=0)return;c=a+800|0;d=c+4|0;e=k[d>>2]|0;if(e>>>0<b>>>0){f=k[a>>2]|0;k[f+20>>2]=123;rb[k[f+4>>2]&31](a,-1);k[c>>2]=145943;k[d>>2]=2;return}else{k[c>>2]=(k[c>>2]|0)+b;k[d>>2]=e-b;return}}function Kg(a){a=a|0;return}function Lg(a){a=a|0;var b=0;b=a+800|0;k[b>>2]=k[a+912>>2];k[b+4>>2]=k[a+916>>2];return}function Mg(a){a=a|0;var b=0,c=0;b=k[a+828>>2]|0;c=a+800|0;k[c>>2]=k[b+588>>2];k[c+4>>2]=k[b+608>>2];return}function Ng(a,b,c){a=+a;b=+b;c=c|0;var d=0,e=0,f=0.0,g=0.0,h=0.0;if(b<.016939999535679817){d=Sg(a,b)|0;return d|0}e=(c|0)==0;f=(b+-.016939999535679817)*285.7142768952314;if(e)g=f;else g=f+ +(iq()|0)*4.656612875245797e-10+-.5;c=~~g;if((c|0)>162){d=Sg(a,b)|0;return d|0}g=+o[107752+(c<<3)>>2];if(g>a){d=Sg(a,b)|0;return d|0}f=(a-g)*285.7142768952314;if(e)h=f;else h=f+ +(iq()|0)*4.656612875245797e-10+-.5;e=~~h;if((e|0)<(j[107752+(c<<3)+4>>1]|0)){d=(j[107752+(c<<3)+6>>1]|0)+e|0;return d|0}else{d=Sg(a,b)|0;return d|0}return 0}function Og(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,g=0,h=0,i=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0,w=0.0;c=a>>>14&1023;if((c|0)!=0?(d=+ea(+((+(c|0)+.5)*.010830424696249145+-8.317766166719343)),!(d<=0.0)):0){c=a&16383;if(c>>>0>16288){e=.210526316;f=.473684211}else{a=0;g=163;a:while(1){h=a;while(1){if((g-h|0)<=1){i=h;k=9;break a}l=h+g>>1;m=j[107752+(l<<3)+6>>1]|0;n=c-(m<<16>>16)|0;if((n|0)>0)h=l;else{p=l;q=m;r=n;s=h;break}}if((r|0)<0){a=s;g=p}else{t=q;u=p;break}}if((k|0)==9){t=j[107752+(i<<3)+6>>1]|0;u=i}e=+o[107752+(u<<3)>>2]+(+(c-(t<<16>>16)|0)+.5)*3.5000001080334187e-03;f=(+(u|0)+.5)*3.5000001080334187e-03+.016939999535679817}v=1.0/(e*6.0-f*16.0+12.0);w=e*9.0*v;e=f*4.0*v;o[b>>2]=d*(w/e);o[b+4>>2]=d;o[b+8>>2]=d*((1.0-w-e)/e);return}o[b+8>>2]=0.0;o[b+4>>2]=0.0;o[b>>2]=0.0;return}function Pg(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,g=0.0,h=0.0,i=0,j=0.0,k=0.0,l=0.0,m=0,n=0,p=0,q=0,r=0;c=a+4|0;d=+o[c>>2];e=d;if(!(e>=15.742))if(!(e<=.00024283)){f=(+fa(+e)*1.4426950408889634+12.0)*64.0;if(!b){g=d;h=f}else{e=f+ +(iq()|0)*4.656612875245797e-10+-.5;g=+o[c>>2];h=e}i=~~h;j=g}else{i=0;j=d}else{i=1023;j=d}d=+o[a>>2];g=j;j=d+g*15.0+ +o[a+8>>2]*3.0;if((i|0)==0|j<=0.0){k=.210526316;l=.473684211;m=Ng(k,l,b)|0;n=(m|0)<0;p=n?12266:m;q=i<<14;r=p|q;return r|0}k=d*4.0/j;l=g*9.0/j;m=Ng(k,l,b)|0;n=(m|0)<0;p=n?12266:m;q=i<<14;r=p|q;return r|0}function Qg(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,g=0,h=0.0,i=0.0,j=0.0,k=0,l=0,m=0.0,n=0.0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0;c=a+4|0;d=+o[c>>2];do if(!(d>=18371976.0e12))if(!(d<=-18371976.0e12)){if(d>5.4136769e-20){e=(+fa(+d)*1.4426950408889634+64.0)*256.0;if(!b)f=e;else f=e+ +(iq()|0)*4.656612875245797e-10+-.5;g=~~f;break}if(d<-5.4136769e-20){e=(+fa(+-d)*1.4426950408889634+64.0)*256.0;if(!b)h=e;else h=e+ +(iq()|0)*4.656612875245797e-10+-.5;g=~~h|-32768}else g=0}else g=65535;else g=32767;while(0);h=+o[a>>2];d=+o[c>>2];f=h+d*15.0+ +o[a+8>>2]*3.0;if(!((g|0)==0|f<=0.0)){e=h*4.0/f;h=d*9.0/f;if(!(e<=0.0)){i=e;j=h;k=13}else{l=0;m=h}}else{i=.210526316;j=.473684211;k=13}if((k|0)==13){h=i*410.0;if(!b)n=h;else n=h+ +(iq()|0)*4.656612875245797e-10+-.5;l=~~n;m=j}k=l>>>0>255;if(m<=0.0){p=0;q=p>>>0>255;r=q?255:p;s=g<<16;t=l<<8;u=k?65280:t;v=u|s;w=v|r;return w|0}j=m*410.0;if(!b)x=j;else x=j+ +(iq()|0)*4.656612875245797e-10+-.5;p=~~x;q=p>>>0>255;r=q?255:p;s=g<<16;t=l<<8;u=k?65280:t;v=u|s;w=v|r;return w|0}function Rg(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=r;r=r+16|0;d=c+8|0;if((b&-2|0)!=34676)Ja(146583,146646,1634,146656);if(!(_b(a,109056,2)|0)){vc(k[a+628>>2]|0,146656,146671,c);e=0;r=c;return e|0}f=me(32)|0;k[a+576>>2]=f;if(!f){g=k[a+628>>2]|0;k[d>>2]=k[a>>2];vc(g,146656,146713,d);e=0;r=c;return e|0}else{pe(f,0,32);k[f>>2]=-1;k[f+4>>2]=(b|0)==34677&1;k[f+20>>2]=15;k[a+504>>2]=22;k[a+508>>2]=23;k[a+540>>2]=25;k[a+548>>2]=26;k[a+516>>2]=24;k[a+544>>2]=27;k[a+552>>2]=28;k[a+556>>2]=19;k[a+564>>2]=20;b=a+672|0;k[f+24>>2]=k[b>>2];k[b>>2]=19;b=a+668|0;k[f+28>>2]=k[b>>2];k[b>>2]=20;e=1;r=c;return e|0}return 0}function Sg(a,b){a=+a;b=+b;var c=0,d=0,e=0.0,f=0.0,g=0.0,h=0.0,i=0.0,l=0,m=0,n=0,q=0,s=0,t=0,u=0.0,v=0,w=0.0,x=0.0,y=0,z=0,A=0.0,B=0,C=0,D=0,E=0,F=0,G=0;c=r;r=r+800|0;d=c;if(k[27282]|0){e=b+-.473684211;f=a+-.210526316;g=+da(+e,+f);h=g*15.915494277358546;i=h+50.0;l=~~i;m=109132+(l<<2)|0;n=k[m>>2]|0;r=c;return n|0}q=99;while(1){p[d+(q<<3)>>3]=2.0;if(!q){s=162;t=163;break}else q=q+-1|0}while(1){u=(+(s|0)+.5)*3.5000001080334187e-03+.016939999535679817;q=(j[107752+(s<<3)+4>>1]|0)+-1|0;switch(t|0){case 1:case 163:{v=1;break}default:v=q}w=+o[107752+(s<<3)>>2];x=u+-.473684211;y=107752+(s<<3)+6|0;z=q;do{u=+da(+x,+((+(z|0)+.5)*3.5000001080334187e-03+w+-.210526316))*15.915494277358546+50.0;q=~~u;A=+W(+(u-(+(q|0)+.5)));B=d+(q<<3)|0;if(A<+p[B>>3]){k[109132+(q<<2)>>2]=(j[y>>1]|0)+z;p[B>>3]=A}z=z-v|0}while((z|0)>-1);if(!s){C=99;D=100;break}else{z=s;s=s+-1|0;t=z}}while(1){do if(+p[d+(C<<3)>>3]>1.5){t=1;while(1){if(+p[d+(((t+C|0)%100|0)<<3)>>3]<1.5){E=t;break}s=t+1|0;if((s|0)<50)t=s;else{E=s;break}}t=D+99|0;s=-1;v=1;while(1){if(+p[d+(((t+s|0)%100|0)<<3)>>3]<1.5){F=v;G=s;break}z=v+1|0;y=~v;if((z|0)<50){s=y;v=z}else{F=z;G=y;break}}if((E|0)<(F|0)){k[109132+(C<<2)>>2]=k[109132+(((E+C|0)%100|0)<<2)>>2];break}else{k[109132+(C<<2)>>2]=k[109132+(((t+G|0)%100|0)<<2)>>2];break}}while(0);if(!C)break;else{v=C;C=C+-1|0;D=v}}k[27282]=1;e=b+-.473684211;f=a+-.210526316;g=+da(+e,+f);h=g*15.915494277358546;i=h+50.0;l=~~i;m=109132+(l<<2)|0;n=k[m>>2]|0;r=c;return n|0}function Tg(a,b,c){a=a|0;b=b|0;c=c|0;return}function Ug(a){a=a|0;return 1}function Vg(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0;b=r;r=r+16|0;c=b;d=k[a+576>>2]|0;k[a+652>>2]=3;e=m[a+90>>1]|0;a:do switch(e|0){case 32845:{if(dh(a)|0){f=a+532|0;if((j[a+88>>1]|0)==-30859){k[f>>2]=29;switch(k[d>>2]|0){case 0:{k[d+20>>2]=16;g=1;break a;break}case 1:{k[d+20>>2]=17;g=1;break a;break}case 3:{k[d+20>>2]=18;g=1;break a;break}default:{g=1;break a}}}else{k[f>>2]=30;switch(k[d>>2]|0){case 0:{k[d+20>>2]=19;g=1;break a;break}case 1:{k[d+20>>2]=20;g=1;break a;break}case 3:{k[d+20>>2]=21;g=1;break a;break}default:{g=1;break a}}}}else g=0;break}case 32844:{if(!(kh(a)|0))g=0;else{k[a+532>>2]=31;switch(k[d>>2]|0){case 0:{k[d+20>>2]=22;g=1;break a;break}case 3:{k[d+20>>2]=23;g=1;break a;break}default:{g=1;break a}}}break}default:{f=k[a+628>>2]|0;k[c>>2]=e;k[c+4>>2]=147007;vc(f,147521,146936,c);g=0}}while(0);r=b;return g|0}function Wg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=Pd(a)|0;if(!e){f=0;return f|0}if((c|0)%(e|0)|0)Ja(146868,146646,385,147503);g=a+532|0;if(!c){f=1;return f|0}else{h=b;i=c}while(1){if(!(xb[k[g>>2]&63](a,h,e,d)|0)){f=0;j=7;break}if((i|0)==(e|0)){f=1;j=7;break}else{h=h+e|0;i=i-e|0}}if((j|0)==7)return f|0;return 0}function Xg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=de(a)|0;if(!e){f=0;return f|0}if((c|0)%(e|0)|0)Ja(146868,146646,404,147486);g=a+532|0;if(!c){f=1;return f|0}else{h=b;i=c}while(1){if(!(xb[k[g>>2]&63](a,h,e,d)|0)){f=0;j=7;break}if((i|0)==(e|0)){f=1;j=7;break}else{h=h+e|0;i=i-e|0}}if((j|0)==7)return f|0;return 0}function Yg(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,l=0;b=r;r=r+16|0;c=b+8|0;d=b;e=k[a+576>>2]|0;f=a+90|0;g=m[f>>1]|0;a:do switch(g|0){case 32845:{if(dh(a)|0){h=a+536|0;if((j[a+88>>1]|0)==-30859){k[h>>2]=32;switch(k[e>>2]|0){case 2:{i=1;break a;break}case 0:{k[e+20>>2]=24;i=1;break a;break}case 1:{k[e+20>>2]=25;i=1;break a;break}default:{l=14;break a}}}else{k[h>>2]=33;switch(k[e>>2]|0){case 2:{i=1;break a;break}case 0:{k[e+20>>2]=26;i=1;break a;break}case 1:{k[e+20>>2]=27;i=1;break a;break}default:{l=14;break a}}}}else i=1;break}case 32844:{if(!(kh(a)|0))i=1;else{k[a+536>>2]=34;switch(k[e>>2]|0){case 1:{i=1;break a;break}case 0:break;default:{l=14;break a}}k[e+20>>2]=28;i=1}break}default:{h=k[a+628>>2]|0;k[d>>2]=g;k[d+4>>2]=147007;vc(h,146918,146936,d);i=1}}while(0);if((l|0)==14){l=k[a+628>>2]|0;k[c>>2]=(j[f>>1]|0)==-32692?147037:147042;vc(l,146918,147051,c);i=0}r=b;return i|0}function Zg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=Pd(a)|0;if(!e){f=0;return f|0}if((c|0)%(e|0)|0)Ja(146868,146646,656,146900);g=a+536|0;if(!c){f=1;return f|0}else{h=b;i=c}while(1){if((xb[k[g>>2]&63](a,h,e,d)|0)!=1){f=0;j=7;break}if((i|0)==(e|0)){f=1;j=7;break}else{h=h+e|0;i=i-e|0}}if((j|0)==7)return f|0;return 0}function _g(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=de(a)|0;if(!e){f=0;return f|0}if((c|0)%(e|0)|0)Ja(146868,146646,674,146883);g=a+536|0;if(!c){f=1;return f|0}else{h=b;i=c}while(1){if((xb[k[g>>2]&63](a,h,e,d)|0)!=1){f=0;j=7;break}if((i|0)==(e|0)){f=1;j=7;break}else{h=h+e|0;i=i-e|0}}if((j|0)==7)return f|0;return 0}function $g(a){a=a|0;j[a+98>>1]=(j[a+90>>1]|0)==-32692?1:3;j[a+84>>1]=16;j[a+86>>1]=2;return}function ah(a){a=a|0;var b=0,c=0,d=0;b=a+576|0;c=k[b>>2]|0;if(!c)Ja(154168,146646,1537,146854);k[a+672>>2]=k[c+24>>2];k[a+668>>2]=k[c+28>>2];d=k[c+12>>2]|0;if(!d){ne(c);k[b>>2]=0;Ve(a);return}ne(d);ne(c);k[b>>2]=0;Ve(a);return}function bh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;d=k[a+576>>2]|0;if((b|0)==65560){e=k[d>>2]|0;f=(k[c>>2]|0)+(4-1)&~(4-1);g=k[f>>2]|0;k[c>>2]=f+4;k[g>>2]=e;h=1;return h|0}else{h=nb[k[d+24>>2]&63](a,b,c)|0;return h|0}return 0}function ch(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0;d=r;r=r+48|0;e=d+32|0;f=d+24|0;g=d+16|0;h=d+8|0;i=d;j=k[a+576>>2]|0;switch(b|0){case 65560:{l=(k[c>>2]|0)+(4-1)&~(4-1);m=k[l>>2]|0;k[c>>2]=l+4;k[j>>2]=m;switch(m|0){case 0:{n=32;o=3;break}case 1:{n=16;o=2;break}case 2:{k[i>>2]=1;Ob(a,277,i)|0;n=32;o=1;break}case 3:{n=8;o=1;break}default:{i=k[a+628>>2]|0;l=k[a>>2]|0;k[h>>2]=m;vc(i,l,146749,h);p=0;r=d;return p|0}}k[g>>2]=n;Ob(a,258,g)|0;k[f>>2]=o;Ob(a,339,f)|0;if(!(k[a+12>>2]&1024))q=-1;else q=ge(a)|0;k[a+496>>2]=q;q=Pd(a)|0;k[a+580>>2]=q;p=1;r=d;return p|0}case 65561:{q=(k[c>>2]|0)+(4-1)&~(4-1);f=k[q>>2]|0;k[c>>2]=q+4;k[j+4>>2]=f;if(f>>>0<2){p=1;r=d;return p|0}q=k[a+628>>2]|0;k[e>>2]=f;vc(q,146795,146811,e);p=0;r=d;return p|0}default:{p=nb[k[j+28>>2]&63](a,b,c)|0;r=d;return p|0}}return 0}function dh(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,l=0,n=0;b=r;r=r+32|0;c=b+16|0;d=b+8|0;e=k[a+576>>2]|0;if(!e)Ja(154187,146646,1335,147323);if((j[a+90>>1]|0)!=-32691)Ja(147339,146646,1336,147323);if((j[a+126>>1]|0)!=1){vc(k[a+628>>2]|0,147323,147380,b);f=0;r=b;return f|0}g=k[e>>2]|0;if((g|0)==-1){switch(m[a+84>>1]<<3|m[a+86>>1]|0){case 259:{h=0;break}case 258:case 257:case 260:{h=2;break}case 129:case 130:case 132:{h=1;break}case 65:case 68:{h=3;break}default:h=-1}switch(m[a+98>>1]|0){case 1:{i=(h|0)==2?2:-1;break}case 3:{i=(h|0)==2?-1:h;break}default:i=-1}k[e>>2]=i;l=i}else l=g;switch(l|0){case 0:{k[e+8>>2]=12;break}case 1:{k[e+8>>2]=6;break}case 2:{k[e+8>>2]=4;break}case 3:{k[e+8>>2]=3;break}default:{vc(k[a+628>>2]|0,147323,147433,d);f=0;r=b;return f|0}}if(!(k[a+12>>2]&1024))n=ha(k[a+100>>2]|0,k[a+56>>2]|0)|0;else n=ha(k[a+72>>2]|0,k[a+68>>2]|0)|0;k[e+16>>2]=n;if((n|0)!=0?(d=me(n<<2)|0,k[e+12>>2]=d,(d|0)!=0):0){f=1;r=b;return f|0}vc(k[a+628>>2]|0,147323,147254,c);f=0;r=b;return f|0}function eh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;e=k[a+576>>2]|0;if(d<<16>>16)Ja(147105,146646,516,147308);if(!e)Ja(154187,146646,517,147308);d=(c|0)/(k[e+8>>2]|0)|0;do if((k[e>>2]|0)!=2)if((k[e+16>>2]|0)<(d|0))Ja(147125,146646,524,147308);else{c=k[e+12>>2]|0;vb[k[e+20>>2]&127](e,b,d);f=c;break}else f=b;while(0);b=a+604|0;e=k[b>>2]|0;c=a+592|0;g=k[c>>2]|0;h=a+608|0;j=g-(k[h>>2]|0)|0;do if(d){l=d;m=j;n=e;o=f;while(1){l=l+-1|0;if((m|0)<3){k[b>>2]=n;k[h>>2]=(k[c>>2]|0)-m;if(!(je(a)|0)){p=-1;q=17;break}r=(k[c>>2]|0)-(k[h>>2]|0)|0;s=k[b>>2]|0}else{r=m;s=n}i[s>>0]=(k[o>>2]|0)>>>16;i[s+1>>0]=(k[o>>2]|0)>>>8;t=s+3|0;i[s+2>>0]=k[o>>2];u=r+-3|0;if(!l){v=t;w=u;q=15;break}else{m=u;n=t;o=o+4|0}}if((q|0)==15){x=k[c>>2]|0;y=w;z=v;break}else if((q|0)==17)return p|0}else{x=g;y=j;z=e}while(0);k[b>>2]=z;k[h>>2]=x-y;p=1;return p|0}function fh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;if((c|0)<=0)return;d=a+4|0;e=c;c=k[a+12>>2]|0;a=b;while(1){b=Pg(a,k[d>>2]|0)|0;k[c>>2]=b;if((e|0)>1){e=e+-1|0;c=c+4|0;a=a+12|0}else break}return}function gh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;if((c|0)<=0)return;d=a+4|0;e=c;c=k[a+12>>2]|0;a=b;while(1){b=e;e=e+-1|0;f=j[a>>1]|0;g=f<<16>>16;do if(f<<16>>16>=1)if(f<<16>>16<=7409)if(!(k[d>>2]|0)){h=g+-3314>>2;break}else{h=~~((+(f<<16>>16)+-3314.0)*.25+ +(iq()|0)*4.656612875245797e-10+-.5);break}else h=1023;else h=0;while(0);f=Ng((+(j[a+2>>1]|0)+.5)*.000030517578125,(+(j[a+4>>1]|0)+.5)*.000030517578125,k[d>>2]|0)|0;k[c>>2]=((f|0)<0?12266:f)|h<<14;if((b|0)<=1)break;else{c=c+4|0;a=a+6|0}}return}function hh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0;e=k[a+576>>2]|0;if(d<<16>>16)Ja(147105,146646,568,147293);if(!e)Ja(154187,146646,569,147293);d=(c|0)/(k[e+8>>2]|0)|0;do if((k[e>>2]|0)!=2)if((k[e+16>>2]|0)<(d|0))Ja(147125,146646,577,147293);else{c=k[e+12>>2]|0;vb[k[e+20>>2]&127](e,b,d);f=c;break}else f=b;while(0);b=a+604|0;e=a+592|0;c=a+608|0;g=(d|0)>0;h=24;j=(k[e>>2]|0)-(k[c>>2]|0)|0;l=k[b>>2]|0;m=0;a:while(1){if(g){n=255<<h;o=0;p=j;q=l;r=m;while(1){if((p|0)<4){k[b>>2]=q;k[c>>2]=(k[e>>2]|0)-p;if(!(je(a)|0)){s=-1;t=43;break a}u=(k[e>>2]|0)-(k[c>>2]|0)|0;v=k[b>>2]|0}else{u=p;v=q}b:do if((o|0)<(d|0)){w=o;while(1){x=k[f+(w<<2)>>2]|0;y=1;while(1){z=y+w|0;A=(z|0)<(d|0);if(!A){B=z;C=A;D=y;break}if((k[f+(z<<2)>>2]^x)&n){B=z;C=A;D=y;break}A=y+1|0;if((A|0)<129)y=A;else{E=w;F=A;break b}}y=(D|0)>3;if(y|C^1){G=B;H=y;I=w;J=D;break}else w=B}E=H?I:G;F=J}else{E=o;F=r}while(0);c:do if((E-o&-2|0)==2){w=k[f+(o<<2)>>2]&n;y=o+1|0;while(1){x=y+1|0;if((k[f+(y<<2)>>2]&n|0)!=(w|0)){K=o;L=u;M=v;break c}if((x|0)==(E|0)){N=y;break}else y=x}i[v>>0]=127-o+N;i[v+1>>0]=w>>>h;K=E;L=u+-2|0;M=v+2|0}else{K=o;L=u;M=v}while(0);if((E|0)>(K|0)){y=~E;x=K;A=L;z=M;while(1){O=E-x|0;P=(O|0)>127?127:O;if((A|0)<(P+3|0)){k[b>>2]=z;k[c>>2]=(k[e>>2]|0)-A;if(!(je(a)|0)){s=-1;t=43;break a}Q=(k[e>>2]|0)-(k[c>>2]|0)|0;R=k[b>>2]|0}else{Q=A;R=z}i[R>>0]=P;O=R+1|0;if(!P){S=x;T=O;U=-1}else{V=x+y|0;W=(V|0)>-128?V:-128;V=R+(0-W)|0;X=x+-1|0;Y=x;Z=P;P=O;while(1){Z=Z+-1|0;i[P>>0]=(k[f+(Y<<2)>>2]|0)>>>h;if(!Z)break;else{Y=Y+1|0;P=P+1|0}}S=X-W|0;T=V;U=W}P=Q+U|0;if((E|0)>(S|0)){x=S;A=P;z=T}else{_=S;$=P;aa=T;break}}}else{_=K;$=L;aa=M}if((F|0)>3){i[aa>>0]=F+126;i[aa+1>>0]=(k[f+(E<<2)>>2]|0)>>>h;ba=$+-2|0;ca=aa+2|0;da=F}else{ba=$;ca=aa;da=0}o=da+_|0;if((o|0)>=(d|0)){ea=ba;fa=ca;ga=da;break}else{p=ba;q=ca;r=da}}}else{ea=j;fa=l;ga=m}h=h+-8|0;if((h|0)<=-1){ha=ea;ia=fa;t=42;break}else{j=ea;l=fa;m=ga}}if((t|0)==42){k[b>>2]=ia;k[c>>2]=(k[e>>2]|0)-ha;s=1;return s|0}else if((t|0)==43)return s|0;return 0}function ih(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;if((c|0)<=0)return;d=a+4|0;e=c;c=k[a+12>>2]|0;a=b;while(1){b=Qg(a,k[d>>2]|0)|0;k[c>>2]=b;if((e|0)>1){e=e+-1|0;c=c+4|0;a=a+12|0}else break}return}function jh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,l=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0,t=0.0,u=0.0;d=k[a+12>>2]|0;e=a+4|0;a=k[e>>2]|0;f=(c|0)>0;if(!a){if(f){g=c;h=d;i=b}else return;while(1){k[h>>2]=((j[i+2>>1]|0)*410|0)>>>7&65280|m[i>>1]<<16|((j[i+4>>1]|0)*410|0)>>>15&255;if((g|0)>1){g=g+-1|0;h=h+4|0;i=i+6|0}else break}return}if(f){l=c;n=a;o=d;p=b}else return;while(1){b=m[p>>1]<<16;q=+(j[p+2>>1]|0)*.01251220703125;if(!n){r=q;s=0}else{t=q+ +(iq()|0)*4.656612875245797e-10+-.5;r=t;s=k[e>>2]|0}t=+(j[p+4>>1]|0)*.01251220703125;if(!s)u=t;else u=t+ +(iq()|0)*4.656612875245797e-10+-.5;k[o>>2]=~~r<<8&65280|b|~~u&255;if((l|0)<=1)break;l=l+-1|0;n=k[e>>2]|0;o=o+4|0;p=p+6|0}return}function kh(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,l=0;b=r;r=r+16|0;c=b+8|0;d=b;e=k[a+576>>2]|0;if(!e)Ja(154187,146646,1243,147148);if((j[a+90>>1]|0)!=-32692)Ja(147164,146646,1244,147148);f=k[e>>2]|0;if((f|0)==-1){switch(m[a+86>>1]|m[a+84>>1]<<6|m[a+98>>1]<<3|0){case 2059:{g=0;break}case 1033:case 1034:case 1036:{g=1;break}case 521:case 524:{g=3;break}default:g=-1}k[e>>2]=g;h=g}else h=f;switch(h|0){case 0:{k[e+8>>2]=4;break}case 1:{k[e+8>>2]=2;break}case 3:{k[e+8>>2]=1;break}default:{vc(k[a+628>>2]|0,147148,147203,d);i=0;r=b;return i|0}}if(!(k[a+12>>2]&1024))l=ha(k[a+100>>2]|0,k[a+56>>2]|0)|0;else l=ha(k[a+72>>2]|0,k[a+68>>2]|0)|0;k[e+16>>2]=l;if((l|0)!=0?(d=me(l<<1)|0,k[e+12>>2]=d,(d|0)!=0):0){i=1;r=b;return i|0}vc(k[a+628>>2]|0,147148,147254,c);i=0;r=b;return i|0}function lh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0;e=k[a+576>>2]|0;if(d<<16>>16)Ja(147105,146646,428,147112);if(!e)Ja(154187,146646,429,147112);d=(c|0)/(k[e+8>>2]|0)|0;do if((k[e>>2]|0)!=1)if((k[e+16>>2]|0)<(d|0))Ja(147125,146646,436,147112);else{c=k[e+12>>2]|0;vb[k[e+20>>2]&127](e,b,d);f=c;break}else f=b;while(0);b=a+604|0;e=a+592|0;c=a+608|0;g=(d|0)>0;h=8;l=(k[e>>2]|0)-(k[c>>2]|0)|0;n=k[b>>2]|0;o=0;a:while(1){if(g){p=255<<h;q=0;r=l;s=n;t=o;while(1){if((r|0)<4){k[b>>2]=s;k[c>>2]=(k[e>>2]|0)-r;if(!(je(a)|0)){u=-1;v=43;break a}w=(k[e>>2]|0)-(k[c>>2]|0)|0;x=k[b>>2]|0}else{w=r;x=s}b:do if((q|0)<(d|0)){y=q;while(1){z=(m[f+(y<<1)>>1]&p)<<16>>16;A=1;while(1){B=A+y|0;C=(B|0)<(d|0);if(!C){D=B;E=C;F=A;break}if((j[f+(B<<1)>>1]&p|0)!=(z|0)){D=B;E=C;F=A;break}C=A+1|0;if((C|0)<129)A=C;else{G=y;H=C;break b}}A=(F|0)>3;if(A|E^1){I=D;J=A;K=y;L=F;break}else y=D}G=J?K:I;H=L}else{G=q;H=t}while(0);c:do if((G-q&-2|0)==2){y=(m[f+(q<<1)>>1]&p)<<16>>16;A=q+1|0;while(1){z=A+1|0;if((j[f+(A<<1)>>1]&p|0)!=(y|0)){M=q;N=w;O=x;break c}if((z|0)==(G|0)){P=A;break}else A=z}i[x>>0]=127-q+P;i[x+1>>0]=y>>h;M=G;N=w+-2|0;O=x+2|0}else{M=q;N=w;O=x}while(0);if((G|0)>(M|0)){A=~G;z=M;C=N;B=O;while(1){Q=G-z|0;R=(Q|0)>127?127:Q;if((C|0)<(R+3|0)){k[b>>2]=B;k[c>>2]=(k[e>>2]|0)-C;if(!(je(a)|0)){u=-1;v=43;break a}S=(k[e>>2]|0)-(k[c>>2]|0)|0;T=k[b>>2]|0}else{S=C;T=B}i[T>>0]=R;Q=T+1|0;if(!R){U=z;V=Q;W=-1}else{X=z+A|0;Y=(X|0)>-128?X:-128;X=T+(0-Y)|0;Z=z+-1|0;_=z;$=R;R=Q;while(1){$=$+-1|0;i[R>>0]=j[f+(_<<1)>>1]>>h;if(!$)break;else{_=_+1|0;R=R+1|0}}U=Z-Y|0;V=X;W=Y}R=S+W|0;if((G|0)>(U|0)){z=U;C=R;B=V}else{aa=U;ba=R;ca=V;break}}}else{aa=M;ba=N;ca=O}if((H|0)>3){i[ca>>0]=H+126;i[ca+1>>0]=j[f+(G<<1)>>1]>>h;da=ba+-2|0;ea=ca+2|0;fa=H}else{da=ba;ea=ca;fa=0}q=fa+aa|0;if((q|0)>=(d|0)){ga=da;ha=ea;ia=fa;break}else{r=da;s=ea;t=fa}}}else{ga=l;ha=n;ia=o}h=h+-8|0;if((h|0)<=-1){ja=ga;ka=ha;v=42;break}else{l=ga;n=ha;o=ia}}if((v|0)==42){k[b>>2]=ka;k[c>>2]=(k[e>>2]|0)-ja;u=1;return u|0}else if((v|0)==43)return u|0;return 0}function mh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0.0,g=0,h=0.0,i=0.0,l=0,m=0.0;if((c|0)<=0)return;d=a+4|0;e=c;c=k[a+12>>2]|0;a=b;while(1){b=e;e=e+-1|0;f=+o[a>>2];a=a+4|0;g=k[d>>2]|0;do if(!(f>=18371976.0e12))if(!(f<=-18371976.0e12)){if(f>5.4136769e-20){h=(+fa(+f)*1.4426950408889634+64.0)*256.0;if(!g)i=h;else i=h+ +(iq()|0)*4.656612875245797e-10+-.5;l=~~i;break}if(f<-5.4136769e-20){h=(+fa(+-f)*1.4426950408889634+64.0)*256.0;if(!g)m=h;else m=h+ +(iq()|0)*4.656612875245797e-10+-.5;l=~~m|-32768}else l=0}else l=65535;else l=32767;while(0);j[c>>1]=l;if((b|0)<=1)break;else c=c+2|0}return}function nh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0;e=r;r=r+16|0;f=e;g=k[a+576>>2]|0;if(d<<16>>16)Ja(147105,146646,263,147614);if(!g)Ja(154187,146646,264,147614);d=(c|0)/(k[g+8>>2]|0)|0;do if((k[g>>2]|0)!=2)if((k[g+16>>2]|0)<(d|0))Ja(147125,146646,271,147614);else{h=k[g+12>>2]|0;break}else h=b;while(0);c=a+604|0;i=k[c>>2]|0;j=a+608|0;m=k[j>>2]|0;if((m|0)>0&(d|0)>0){n=((m+((m|0)<3?~m:-4)+3|0)>>>0)/3|0;o=d+-1|0;p=n>>>0>o>>>0?o:n;n=~p;o=p+1|0;p=n*3|0;q=ha(n,-3)|0;n=i;s=0;while(1){k[h+(s<<2)>>2]=(l[n+1>>0]|0)<<8|(l[n>>0]|0)<<16|(l[n+2>>0]|0);s=s+1|0;if((s|0)==(o|0))break;else n=n+3|0}t=i+q|0;u=m+p|0;v=o}else{t=i;u=m;v=0}k[c>>2]=t;k[j>>2]=u;if((d|0)==(v|0)){vb[k[g+20>>2]&127](g,b,d);w=1;r=e;return w|0}else{b=k[a+628>>2]|0;g=d-v|0;k[f>>2]=k[a+444>>2];a=f+8|0;k[a>>2]=g;k[a+4>>2]=((g|0)<0)<<31>>31;vc(b,147614,147552,f);w=0;r=e;return w|0}return 0}function oh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;if((c|0)<=0)return;d=c;c=k[a+12>>2]|0;a=b;while(1){Og(k[c>>2]|0,a);if((d|0)>1){d=d+-1|0;c=c+4|0;a=a+12|0}else break}return}function ph(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0.0,i=0.0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;if((c|0)<=0)return;d=c;c=k[a+12>>2]|0;a=b;while(1){b=d;d=d+-1|0;e=k[c>>2]|0;f=a+2|0;j[a>>1]=(e>>>12&4093)+13314;g=e&16383;if(g>>>0>16288){h=.210526316;i=.473684211}else{e=0;l=163;a:while(1){m=e;while(1){if((l-m|0)<=1){n=m;p=8;break a}q=m+l>>1;r=j[107752+(q<<3)+6>>1]|0;s=g-(r<<16>>16)|0;if((s|0)>0)m=q;else{t=q;u=r;v=s;w=m;break}}if((v|0)<0){e=w;l=t}else{x=u;y=t;break}}if((p|0)==8){p=0;x=j[107752+(n<<3)+6>>1]|0;y=n}h=+o[107752+(y<<3)>>2]+(+(g-(x<<16>>16)|0)+.5)*3.5000001080334187e-03;i=(+(y|0)+.5)*3.5000001080334187e-03+.016939999535679817}j[f>>1]=~~(h*32768.0);j[a+4>>1]=~~(i*32768.0);if((b|0)<=1)break;else{c=c+4|0;a=a+6|0}}return}function qh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0.0,l=0.0,m=0.0,n=0.0,p=0.0,q=0.0,s=0,t=0,u=0;d=r;r=r+16|0;e=d;if((c|0)<=0){r=d;return}f=e+4|0;g=e+8|0;h=c;c=k[a+12>>2]|0;a=b;while(1){b=h;h=h+-1|0;Og(k[c>>2]|0,e);c=c+4|0;j=+o[e>>2];l=+o[f>>2];m=+o[g>>2];n=j*2.69-l*1.276-m*.414;p=l*1.978-j*1.022+m*.044;q=j*.061-l*.224+m*1.163;if(!(n<=0.0))if(!(n>=1.0))s=~~(+X(+n)*256.0)&255;else s=-1;else s=0;i[a>>0]=s;if(!(p<=0.0))if(!(p>=1.0))t=~~(+X(+p)*256.0)&255;else t=-1;else t=0;i[a+1>>0]=t;if(!(q<=0.0))if(!(q>=1.0))u=~~(+X(+q)*256.0)&255;else u=-1;else u=0;i[a+2>>0]=u;if((b|0)<=1)break;else a=a+3|0}r=d;return}function rh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0;e=r;r=r+16|0;f=e;if(d<<16>>16)Ja(147105,146646,319,147599);d=k[a+576>>2]|0;if(!d)Ja(154187,146646,321,147599);g=(c|0)/(k[d+8>>2]|0)|0;do if((k[d>>2]|0)!=2)if((k[d+16>>2]|0)<(g|0))Ja(147125,146646,328,147599);else{h=k[d+12>>2]|0;break}else h=b;while(0);pe(h,0,g<<2);c=a+604|0;j=k[c>>2]|0;m=a+608|0;n=k[m>>2]|0;a:do if((g|0)>0){o=j;p=n;q=32;while(1){q=q+-8|0;if((q|0)<=-1){s=o;t=p;u=26;break a}b:do if((p|0)>0){v=o;w=p;x=0;while(1){y=i[v>>0]|0;z=y&255;A=v+1|0;c:do if(y<<24>>24<0){B=v+2|0;C=(l[A>>0]|0)<<q;D=w+-2|0;if((x|0)<(g|0)){E=x-g|0;F=126-z|0;G=x-(E>>>0>F>>>0?E:F)|0;F=x;do{E=h+(F<<2)|0;F=F+1|0;k[E>>2]=k[E>>2]|C}while((F|0)!=(G|0));H=B;I=D;J=G}else{H=B;I=D;J=x}}else{G=w+-1|0;if(!G){K=A;L=0;M=x;break b}else{N=G;O=A;P=x;Q=z}while(1){if(!((P|0)<(g|0)&(Q|0)!=0)){H=O;I=N;J=P;break c}G=O+1|0;F=P+1|0;C=h+(P<<2)|0;k[C>>2]=(l[O>>0]|0)<<q|k[C>>2];N=N+-1|0;if(!N){K=G;L=0;M=F;break b}else{O=G;P=F;Q=Q+-1|0}}}while(0);if((g|0)>(J|0)&(I|0)>0){v=H;w=I;x=J}else{K=H;L=I;M=J;break}}}else{K=o;L=p;M=0}while(0);if((g|0)!=(M|0)){R=K;S=L;T=M;u=25;break}else{o=K;p=L}}}else{p=(g|0)==0;o=32;while(1){o=o+-8|0;if((o|0)<=-1){s=j;t=n;u=26;break a}if(!p){R=j;S=n;T=0;u=25;break}}}while(0);if((u|0)==25){n=k[a+628>>2]|0;j=g-T|0;k[f>>2]=k[a+444>>2];a=f+8|0;k[a>>2]=j;k[a+4>>2]=((j|0)<0)<<31>>31;vc(n,147599,147552,f);U=0;V=S;W=R;k[c>>2]=W;k[m>>2]=V;r=e;return U|0}else if((u|0)==26){vb[k[d+20>>2]&127](d,b,g);U=1;V=t;W=s;k[c>>2]=W;k[m>>2]=V;r=e;return U|0}return 0}function sh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0.0,i=0.0,j=0.0,l=0.0,m=0.0;if((c|0)<=0)return;d=c;c=k[a+12>>2]|0;a=b;while(1){b=d;d=d+-1|0;e=k[c>>2]|0;c=c+4|0;f=e>>16;g=f&32767;if((g|0)!=0?(h=+ea(+((+(g|0)+.5)*2.7076061740622863e-03+-44.3614195558365)),i=(f&32768|0)!=0?-h:h,!(i<=0.0)):0){h=(+((e>>>8&255)>>>0)+.5)*2.4390243902439024e-03;j=(+((e&255)>>>0)+.5)*2.4390243902439024e-03;l=1.0/(h*6.0-j*16.0+12.0);m=h*9.0*l;h=j*4.0*l;o[a>>2]=i*(m/h);o[a+4>>2]=i;o[a+8>>2]=i*((1.0-m-h)/h)}else{o[a+8>>2]=0.0;o[a+4>>2]=0.0;o[a>>2]=0.0}if((b|0)<=1)break;else a=a+12|0}return}function th(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;if((c|0)<=0)return;d=c;c=k[a+12>>2]|0;a=b;while(1){b=k[c>>2]|0;j[a>>1]=b>>>16;j[a+2>>1]=~~((+((b>>>8&255)>>>0)+.5)*2.4390243902439024e-03*32768.0);j[a+4>>1]=~~((+((b&255)>>>0)+.5)*2.4390243902439024e-03*32768.0);if((d|0)>1){d=d+-1|0;c=c+4|0;a=a+6|0}else break}return}function uh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0;if((c|0)<=0)return;d=c;c=k[a+12>>2]|0;a=b;while(1){b=d;d=d+-1|0;e=k[c>>2]|0;c=c+4|0;f=e>>16;g=f&32767;if((g|0)!=0?(h=+ea(+((+(g|0)+.5)*2.7076061740622863e-03+-44.3614195558365)),j=(f&32768|0)!=0?-h:h,!(j<=0.0)):0){h=(+((e>>>8&255)>>>0)+.5)*2.4390243902439024e-03;l=(+((e&255)>>>0)+.5)*2.4390243902439024e-03;m=1.0/(h*6.0-l*16.0+12.0);n=h*9.0*m;h=l*4.0*m;o=j*(n/h);p=j;q=j*((1.0-n-h)/h)}else{o=0.0;p=0.0;q=0.0}h=o;n=p;j=q;m=h*2.69-n*1.276-j*.414;l=j*.044+(n*1.978-h*1.022);r=j*1.163+(h*.061-n*.224);if(!(m<=0.0))if(!(m>=1.0))s=~~(+X(+m)*256.0)&255;else s=-1;else s=0;i[a>>0]=s;if(!(l<=0.0))if(!(l>=1.0))t=~~(+X(+l)*256.0)&255;else t=-1;else t=0;i[a+1>>0]=t;if(!(r<=0.0))if(!(r>=1.0))u=~~(+X(+r)*256.0)&255;else u=-1;else u=0;i[a+2>>0]=u;if((b|0)<=1)break;else a=a+3|0}return}function vh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0;e=r;r=r+16|0;f=e;g=k[a+576>>2]|0;if(d<<16>>16)Ja(147105,146646,197,147539);if(!g)Ja(154187,146646,198,147539);d=(c|0)/(k[g+8>>2]|0)|0;do if((k[g>>2]|0)!=1)if((k[g+16>>2]|0)<(d|0))Ja(147125,146646,205,147539);else{h=k[g+12>>2]|0;break}else h=b;while(0);pe(h,0,d<<1);c=a+604|0;n=a+608|0;o=(d|0)>0;p=k[c>>2]|0;q=k[n>>2]|0;s=16;while(1){s=s+-8|0;if((s|0)<=-1){t=p;u=q;v=23;break}a:do if(o&(q|0)>0){w=p;x=q;y=0;while(1){z=i[w>>0]|0;A=z&255;B=w+1|0;b:do if(z<<24>>24<0){C=w+2|0;D=(l[B>>0]|0)<<s;E=x+-2|0;if((y|0)<(d|0)){F=y-d|0;G=126-A|0;H=y-(F>>>0>G>>>0?F:G)|0;G=y;do{F=h+(G<<1)|0;G=G+1|0;j[F>>1]=m[F>>1]|0|D}while((G|0)!=(H|0));I=C;J=E;K=H}else{I=C;J=E;K=y}}else{H=x+-1|0;if(!H){L=B;M=0;N=y;break a}else{O=H;P=B;Q=y;R=A}while(1){if(!((Q|0)<(d|0)&(R|0)!=0)){I=P;J=O;K=Q;break b}H=P+1|0;G=Q+1|0;D=h+(Q<<1)|0;j[D>>1]=m[D>>1]|0|(l[P>>0]|0)<<s;O=O+-1|0;if(!O){L=H;M=0;N=G;break a}else{P=H;Q=G;R=R+-1|0}}}while(0);if((d|0)>(K|0)&(J|0)>0){w=I;x=J;y=K}else{L=I;M=J;N=K;break}}}else{L=p;M=q;N=0}while(0);if((d|0)!=(N|0)){S=L;T=M;U=N;v=22;break}else{p=L;q=M}}if((v|0)==22){M=k[a+628>>2]|0;q=d-U|0;k[f>>2]=k[a+444>>2];a=f+8|0;k[a>>2]=q;k[a+4>>2]=((q|0)<0)<<31>>31;vc(M,147539,147552,f);V=0;W=T;X=S;k[c>>2]=X;k[n>>2]=W;r=e;return V|0}else if((v|0)==23){vb[k[g+20>>2]&127](g,b,d);V=1;W=u;X=t;k[c>>2]=X;k[n>>2]=W;r=e;return V|0}return 0}function wh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0.0,g=0.0;if((c|0)<=0)return;d=c;c=k[a+12>>2]|0;a=b;while(1){b=j[c>>1]|0;e=b&32767;if(!e)f=0.0;else{g=+ea(+((+(e|0)+.5)*2.7076061740622863e-03+-44.3614195558365));f=(b&32768|0)!=0?-g:g}o[a>>2]=f;if((d|0)>1){d=d+-1|0;c=c+2|0;a=a+4|0}else break}return}function xh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0.0,h=0.0,l=0;if((c|0)<=0)return;d=c;c=b;b=k[a+12>>2]|0;while(1){a=d;d=d+-1|0;e=j[b>>1]|0;b=b+2|0;f=e&32767;if((f|0)!=0?(g=+ea(+((+(f|0)+.5)*2.7076061740622863e-03+-44.3614195558365)),h=(e&32768|0)!=0?-g:g,!(h<=0.0)):0)if(!(h>=1.0))l=~~(+X(+h)*256.0);else l=255;else l=0;i[c>>0]=l;if((a|0)<=1)break;else c=c+1|0}return}function yh(a,b){a=a|0;b=b|0;var c=0,d=0;c=r;r=r+16|0;if((b|0)!=5)Ja(147656,147682,1110,147692);b=me(160)|0;k[a+576>>2]=b;if(!b){vc(k[a+628>>2]|0,147692,147704,c);d=0;r=c;return d|0}else{k[b+124>>2]=0;k[b+104>>2]=0;k[b+152>>2]=0;k[b+80>>2]=k[a+8>>2];k[a+504>>2]=25;k[a+508>>2]=26;k[a+512>>2]=31;k[a+532>>2]=35;k[a+540>>2]=35;k[a+548>>2]=35;k[a+516>>2]=27;k[a+524>>2]=32;k[a+528>>2]=28;k[a+536>>2]=36;k[a+544>>2]=36;k[a+552>>2]=36;k[a+564>>2]=21;Ii(a)|0;d=1;r=c;return d|0}return 0}function zh(a){a=a|0;return 1}function Ah(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,l=0,m=0;b=r;r=r+16|0;c=b+8|0;d=b;e=a+576|0;f=k[e>>2]|0;do if(!f){g=me(160)|0;k[e>>2]=g;if(!g){vc(k[a+628>>2]|0,148271,147704,d);h=0;r=b;return h|0}else{k[g+124>>2]=0;k[g+104>>2]=0;Ii(a)|0;g=k[e>>2]|0;if(g){l=g;break}Ja(154187,147682,229,148271)}}else l=f;while(0);f=l+124|0;if(k[f>>2]|0){h=1;r=b;return h|0}l=me(40952)|0;k[f>>2]=l;if(!l){vc(k[a+628>>2]|0,148271,148286,c);h=0;r=b;return h|0}else m=255;while(1){c=m&255;i[l+(m<<3)+6>>0]=c;i[l+(m<<3)+7>>0]=c;j[l+(m<<3)+4>>1]=1;k[l+(m<<3)>>2]=0;if(!m)break;else m=m+-1|0}pe(l+2048|0,0,16);h=1;r=b;return h|0}function Bh(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,l=0,m=0,n=0;b=r;r=r+16|0;c=b;d=k[a+576>>2]|0;if(!d)Ja(154187,147682,267,148208);e=d+124|0;f=k[e>>2]|0;if(!f){ub[k[a+508>>2]&63](a)|0;g=k[e>>2]|0;if(!g){h=0;r=b;return h|0}else l=g}else l=f;f=k[a+588>>2]|0;if((i[f>>0]|0)==0?(i[f+1>>0]&1)!=0:0){f=d+104|0;if(!(k[f>>2]|0)){ie(k[a+628>>2]|0,148208,148221,c);k[a+532>>2]=37;k[a+540>>2]=37;k[a+548>>2]=37;ub[k[a+508>>2]&63](a)|0;k[f>>2]=37;m=k[e>>2]|0}else m=l;j[d+66>>1]=511;n=m}else{j[d+66>>1]=510;k[d+104>>2]=35;n=l}j[d+64>>1]=9;k[d+76>>2]=0;k[d+72>>2]=0;k[d+88>>2]=0;l=d+84|0;k[l>>2]=511;m=k[a+608>>2]|0;a=rr(m|0,((m|0)<0)<<31>>31|0,3)|0;m=d+96|0;k[m>>2]=a;k[m+4>>2]=L;m=n+2064|0;k[d+116>>2]=m;pe(m,0,38888);m=k[e>>2]|0;k[d+112>>2]=m+-8;k[d+120>>2]=m+((k[l>>2]|0)+-1<<3);h=1;r=b;return h|0}function Ch(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0;d=r;r=r+80|0;e=d+64|0;f=d+56|0;g=d+48|0;h=d+40|0;n=d+32|0;o=d+24|0;p=d+16|0;q=d+8|0;s=d;t=k[a+576>>2]|0;if(!t)Ja(154187,147682,375,147871);u=t+124|0;if(!(k[u>>2]|0))Ja(147881,147682,376,147871);v=t+88|0;w=k[v>>2]|0;do if(!w){x=c;y=b}else{z=k[t+108>>2]|0;A=(m[z+4>>1]|0)-w|0;if((A|0)<=(c|0)){B=b+A|0;C=z;D=A;E=B;do{E=E+-1|0;F=C;C=k[C>>2]|0;i[E>>0]=i[F+6>>0]|0;D=D+-1|0}while((D|0)!=0&(C|0)!=0);k[v>>2]=0;x=c-A|0;y=B;break}k[v>>2]=w+c;C=z;D=A;do{C=k[C>>2]|0;D=D+-1|0;G=(C|0)!=0}while((D|0)>(c|0)&G);if(!G){H=1;r=d;return H|0}D=C;A=c;z=b+c|0;do{z=z+-1|0;i[z>>0]=i[D+6>>0]|0;D=k[D>>2]|0;A=A+-1|0}while((A|0)!=0&(D|0)!=0);H=1;r=d;return H|0}while(0);c=a+604|0;b=k[c>>2]|0;G=t+64|0;w=m[G>>1]|0;D=t+72|0;A=k[D>>2]|0;z=t+76|0;C=k[z>>2]|0;B=t+84|0;E=k[B>>2]|0;F=t+112|0;I=k[F>>2]|0;J=t+116|0;K=k[J>>2]|0;M=t+120|0;N=k[M>>2]|0;a:do if((x|0)>0){O=t+96|0;P=I;Q=b;R=K;S=N;T=w;U=E;V=C;W=A;X=x;Y=y;b:while(1){Z=O;_=k[Z>>2]|0;$=k[Z+4>>2]|0;Z=((T|0)<0)<<31>>31;if($>>>0<Z>>>0|($|0)==(Z|0)&_>>>0<T>>>0){aa=P;ba=Q;ca=R;da=S;ea=T;fa=U;ga=V;ha=W;ia=X;ja=18;break}ka=Q+1|0;la=l[Q>>0]|0|W<<8;ma=V+8|0;if((ma|0)<(T|0)){na=Q+2|0;oa=V+16|0;pa=l[ka>>0]|0|la<<8}else{na=ka;oa=ma;pa=la}la=oa-T|0;ma=pa>>>la&U;ka=ma&65535;qa=pr(_|0,$|0,T|0,Z|0)|0;Z=O;k[Z>>2]=qa;k[Z+4>>2]=L;Z=ma&65535;c:do switch(ka<<16>>16){case 257:{ra=na;sa=R;ta=S;ua=T;va=U;wa=la;xa=pa;ya=X;za=P;break a;break}case 256:{qa=k[u>>2]|0;$=na;_=la;Aa=pa;d:while(1){Ba=qa+2064|0;pe(Ba,0,38888);Ca=k[u>>2]|0;Da=O;Ea=k[Da>>2]|0;Fa=k[Da+4>>2]|0;if(Fa>>>0<0|(Fa|0)==0&Ea>>>0<9){Ga=Ba;Ha=Ca;Ia=P;Ka=$;La=_;Ma=Aa;Na=X;ja=24;break b}Da=$+1|0;Oa=l[$>>0]|0|Aa<<8;Pa=_+8|0;if((Pa|0)<9){Qa=$+2|0;Ra=_+16|0;Sa=l[Da>>0]|0|Oa<<8}else{Qa=Da;Ra=Pa;Sa=Oa}Oa=Ra+-9|0;Pa=Sa>>>Oa;Da=Pa&511;Ta=Da&65535;Ua=sr(Ea|0,Fa|0,-9,-1)|0;Fa=O;k[Fa>>2]=Ua;k[Fa+4>>2]=L;switch(Ta<<16>>16){case 257:{Va=Ba;Wa=Ca;Xa=Oa;Ya=P;Za=Qa;_a=Sa;$a=X;ja=55;break b;break}case 256:{qa=Ca;$=Qa;_=Oa;Aa=Sa;break}default:{ab=Ba;bb=Ca;cb=Oa;db=Pa;eb=Da;fb=Ta;gb=Qa;hb=Sa;break d}}}if((fb&65535)>256){ja=29;break b}i[Y>>0]=db;ib=gb;jb=ab;kb=bb+4080|0;lb=9;mb=511;nb=cb;ob=hb;pb=X+-1|0;qb=(k[u>>2]|0)+(eb<<3)|0;rb=Y+1|0;break}default:{Aa=k[u>>2]|0;_=Aa+(Z<<3)|0;$=Aa+40952|0;if(!(R>>>0>=Aa>>>0&R>>>0<$>>>0)){ja=33;break b}k[R>>2]=P;if(!(P>>>0>=Aa>>>0&P>>>0<$>>>0)){ja=35;break b}$=R+7|0;i[$>>0]=i[P+7>>0]|0;j[R+4>>1]=(m[P+4>>1]|0)+1;i[R+6>>0]=i[(_>>>0<R>>>0?Aa+(Z<<3)+7|0:$)>>0]|0;$=R+8|0;if($>>>0>S>>>0){qa=T+1|0;Ta=(qa|0)>12?12:qa;qa=1<<Ta;sb=Aa+(qa+-2<<3)|0;tb=Ta;ub=qa+-1|0}else{sb=S;tb=T;ub=U}if((ka&65535)<=255){i[Y>>0]=ma;ib=na;jb=$;kb=sb;lb=tb;mb=ub;nb=la;ob=pa;pb=X+-1|0;qb=_;rb=Y+1|0;break c}qa=j[Aa+(Z<<3)+4>>1]|0;Aa=qa&65535;if(!(qa<<16>>16)){ja=40;break b}if((X|0)<(Aa|0)){vb=la;wb=_;xb=$;yb=na;zb=sb;Ab=tb;Bb=ub;Cb=pa;Db=X;Eb=Y;ja=42;break b}qa=Y+Aa|0;Ta=_;Da=qa;do{Da=Da+-1|0;Pa=Ta;Ta=k[Ta>>2]|0;i[Da>>0]=i[Pa+6>>0]|0;Fb=(Ta|0)!=0}while(Da>>>0>Y>>>0&Fb);if(Fb){Gb=la;Hb=_;Ib=$;Jb=na;Kb=sb;Lb=tb;Mb=ub;Nb=pa;Ob=X;ja=52;break b}ib=na;jb=$;kb=sb;lb=tb;mb=ub;nb=la;ob=pa;pb=X-Aa|0;qb=_;rb=qa}}while(0);if((pb|0)>0){P=qb;Q=ib;R=jb;S=kb;T=lb;U=mb;V=nb;W=ob;X=pb;Y=rb}else{ra=ib;sa=jb;ta=kb;ua=lb;va=mb;wa=nb;xa=ob;ya=pb;za=qb;break a}}if((ja|0)==18){Y=k[a+628>>2]|0;k[s>>2]=k[a+452>>2];ie(Y,147871,147905,s);ra=ba;sa=ca;ta=da;ua=ea;va=fa;wa=ga;xa=ha;ya=ia;za=aa;break}else if((ja|0)==24){Y=k[a+628>>2]|0;k[q>>2]=k[a+452>>2];ie(Y,147871,147905,q);ra=Ka;sa=Ga;ta=Ha+4080|0;ua=9;va=511;wa=La;xa=Ma;ya=Na;za=Ia;break}else if((ja|0)==29){Y=k[a+628>>2]|0;X=k[a>>2]|0;k[p>>2]=k[a+444>>2];vc(Y,X,147954,p);H=0;r=d;return H|0}else if((ja|0)==33){X=k[a+628>>2]|0;k[o>>2]=k[a+444>>2];vc(X,147871,148e3,o);H=0;r=d;return H|0}else if((ja|0)==35){X=k[a+628>>2]|0;k[n>>2]=k[a+444>>2];vc(X,147871,148e3,n);H=0;r=d;return H|0}else if((ja|0)==40){X=k[a+628>>2]|0;k[h>>2]=k[a+444>>2];vc(X,147871,148035,h);H=0;r=d;return H|0}else if((ja|0)==42){k[t+108>>2]=wb;X=wb;while(1){Y=k[X>>2]|0;if(!Y){ra=yb;sa=xb;ta=zb;ua=Ab;va=Bb;wa=vb;xa=Cb;ya=Db;za=wb;break a}if((m[Y+4>>1]|0|0)>(Db|0))X=Y;else{Pb=Y;break}}k[v>>2]=Db;X=Pb;Y=Db;W=Eb+Db|0;do{W=W+-1|0;i[W>>0]=i[X+6>>0]|0;X=k[X>>2]|0;Y=Y+-1|0;Qb=(X|0)!=0}while((Y|0)!=0&Qb);if(!Qb){ra=yb;sa=xb;ta=zb;ua=Ab;va=Bb;wa=vb;xa=Cb;ya=Y;za=wb;break}X=k[a+628>>2]|0;k[g>>2]=k[a+444>>2];vc(X,147871,148106,g);ra=yb;sa=xb;ta=zb;ua=Ab;va=Bb;wa=vb;xa=Cb;ya=Y;za=wb;break}else if((ja|0)==52){X=k[a+628>>2]|0;k[f>>2]=k[a+444>>2];vc(X,147871,148106,f);ra=Jb;sa=Ib;ta=Kb;ua=Lb;va=Mb;wa=Gb;xa=Nb;ya=Ob;za=Hb;break}else if((ja|0)==55){ra=Za;sa=Va;ta=Wa+4080|0;ua=9;va=511;wa=Xa;xa=_a;ya=$a;za=Ya;break}}else{ra=b;sa=K;ta=N;ua=w;va=E;wa=C;xa=A;ya=x;za=I}while(0);k[c>>2]=ra;j[G>>1]=ua;k[D>>2]=xa;k[z>>2]=wa;k[B>>2]=va;k[F>>2]=za;k[J>>2]=sa;k[M>>2]=ta;if((ya|0)<=0){H=1;r=d;return H|0}ta=k[a+628>>2]|0;k[e>>2]=k[a+444>>2];a=e+8|0;k[a>>2]=ya;k[a+4>>2]=((ya|0)<0)<<31>>31;vc(ta,147871,148158,e);H=0;r=d;return H|0}function Dh(a){a=a|0;var b=0,c=0,d=0,e=0;b=r;r=r+16|0;c=k[a+576>>2]|0;if(!c)Ja(154187,147682,788,147828);d=me(72008)|0;k[c+152>>2]=d;if(d){e=1;r=b;return e|0}vc(k[a+628>>2]|0,147828,147843,b);e=0;r=b;return e|0}function Eh(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;b=k[a+576>>2]|0;if(!b)Ja(154187,147682,807,147815);c=b+152|0;d=k[c>>2]|0;if(!d){ub[k[a+516>>2]&63](a)|0;e=k[c>>2]|0}else e=d;j[b+64>>1]=9;j[b+66>>1]=511;j[b+68>>1]=258;k[b+76>>2]=0;k[b+72>>2]=0;k[b+132>>2]=1e4;k[b+136>>2]=0;k[b+140>>2]=0;k[b+144>>2]=0;k[b+148>>2]=(k[a+588>>2]|0)+((k[a+592>>2]|0)+-5);a=e+72e3|0;d=8993;while(1){d=d+-8|0;k[a+-56>>2]=-1;k[a+-48>>2]=-1;k[a+-40>>2]=-1;k[a+-32>>2]=-1;k[a+-24>>2]=-1;k[a+-16>>2]=-1;k[a+-8>>2]=-1;k[a>>2]=-1;if((d|0)<=-1)break;else a=a+-64|0}k[e>>2]=-1;k[b+128>>2]=65535;return 1}function Fh(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,j=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;b=k[a+576>>2]|0;c=k[a+604>>2]|0;d=k[b+76>>2]|0;e=k[b+72>>2]|0;f=m[b+64>>1]|0;if(c>>>0>(k[b+148>>2]|0)>>>0){g=a+588|0;k[a+608>>2]=c-(k[g>>2]|0);je(a)|0;h=k[g>>2]|0}else h=c;c=b+128|0;b=k[c>>2]|0;if((b|0)==65535){j=d;l=e;n=h}else{g=b|e<<f;e=f+d|0;d=e+-8|0;b=h+1|0;i[h>>0]=g>>>d;if((d|0)>7){o=e+-16|0;i[b>>0]=g>>>o;p=o;q=h+2|0}else{p=d;q=b}k[c>>2]=65535;j=p;l=g;n=q}q=l<<f|257;l=j+f|0;f=l+-8|0;j=n+1|0;i[n>>0]=q>>>f;if((f|0)>7){g=l+-16|0;i[j>>0]=q>>>g;r=j;s=g;t=n+2|0}else{r=n;s=f;t=j}if((s|0)<=0){u=t;v=a+588|0;w=k[v>>2]|0;x=u;y=w;z=x-y|0;A=a+608|0;k[A>>2]=z;return 1}i[t>>0]=q<<8-s;u=r+2|0;v=a+588|0;w=k[v>>2]|0;x=u;y=w;z=x-y|0;A=a+608|0;k[A>>2]=z;return 1}function Gh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ka=0,La=0,Ma=0,Na=0,Oa=0;d=k[a+576>>2]|0;if(!d){e=0;return e|0}f=d+152|0;if(!(k[f>>2]|0))Ja(147763,147682,888,147787);g=d+140|0;h=k[g>>2]|0;n=d+144|0;o=k[n>>2]|0;p=d+132|0;q=k[p>>2]|0;r=d+72|0;s=k[r>>2]|0;t=d+76|0;u=k[t>>2]|0;v=d+68|0;w=m[v>>1]|0;x=d+66|0;y=m[x>>1]|0;z=d+64|0;A=m[z>>1]|0;B=a+604|0;C=k[B>>2]|0;D=k[d+148>>2]|0;E=d+128|0;F=k[E>>2]|0;G=F&65535;if((c|0)>0&(F&65535|0)==65535){F=s<<A|256;H=A+u|0;I=H+-8|0;J=C+1|0;i[C>>0]=F>>>I;if((I|0)>7){K=H+-16|0;i[J>>0]=F>>>K;L=K;M=C+2|0}else{L=I;M=J}N=b+1|0;O=c+-1|0;P=l[b>>0]|0;Q=h+1|0;R=L;S=F;T=M;U=A+o|0}else{N=b;O=c;P=G;Q=h;R=u;S=s;T=C;U=o}a:do if((O|0)>0){o=a+588|0;C=a+608|0;s=d+136|0;u=N;h=O;G=q;c=P;b=w;M=Q;F=y;L=A;J=R;I=S;K=T;H=U;b:while(1){V=i[u>>0]|0;u=u+1|0;W=V&255;X=h;h=h+-1|0;Y=M+1|0;Z=c&65535;_=(W<<12)+Z|0;$=W<<5;W=$^Z;aa=k[f>>2]|0;ba=k[aa+(W<<3)>>2]|0;c:do if((ba|0)!=(_|0)){d:do if((ba|0)>-1){ca=($|0)==(Z|0)?1:9001-W|0;da=W;while(1){ea=da-ca|0;fa=(ea|0)<0?ea+9001|0:ea;ea=k[aa+(fa<<3)>>2]|0;if((ea|0)==(_|0)){ga=fa;break}if((ea|0)>-1)da=fa;else{ha=fa;break d}}ia=G;ja=j[aa+(ga<<3)+4>>1]|0;ka=b;la=Y;ma=F;na=L;oa=J;pa=I;qa=K;ra=H;break c}else ha=W;while(0);if(K>>>0>D>>>0){k[C>>2]=K-(k[o>>2]|0);je(a)|0;sa=k[o>>2]|0}else sa=K;da=I<<L|Z;ca=L+J|0;fa=ca+-8|0;ea=sa+1|0;i[sa>>0]=da>>>fa;if((fa|0)>7){ta=ca+-16|0;i[ea>>0]=da>>>ta;ua=ea;va=ta;wa=sa+2|0}else{ua=sa;va=fa;wa=ea}ea=L+H|0;fa=V&255;ta=b+1|0;j[aa+(ha<<3)+4>>1]=b;k[aa+(ha<<3)>>2]=_;if((ta|0)==4094){ca=k[f>>2]|0;xa=ca+72e3|0;ya=8993;while(1){ya=ya+-8|0;k[xa+-56>>2]=-1;k[xa+-48>>2]=-1;k[xa+-40>>2]=-1;k[xa+-32>>2]=-1;k[xa+-24>>2]=-1;k[xa+-16>>2]=-1;k[xa+-8>>2]=-1;k[xa>>2]=-1;if((ya|0)<=-1)break;else xa=xa+-64|0}k[ca>>2]=-1;k[s>>2]=0;xa=da<<L|256;ya=va+L|0;za=ya+-8|0;Aa=ua+2|0;i[wa>>0]=xa>>>za;if((za|0)<=7){ia=G;ja=fa;ka=258;la=0;ma=511;na=9;oa=za;pa=xa;qa=Aa;ra=L;break}za=ya+-16|0;i[Aa>>0]=xa>>>za;ia=G;ja=fa;ka=258;la=0;ma=511;na=9;oa=za;pa=xa;qa=ua+3|0;ra=L;break}if((b|0)>=(F|0)){xa=L+1|0;if((xa|0)>=13)break b;ia=G;ja=fa;ka=ta;la=Y;ma=(1<<xa)+-1|0;na=xa;oa=va;pa=da;qa=wa;ra=ea;break}if((Y|0)>=(G|0)){xa=M+10001|0;if((M|0)>8388606){za=ea>>8;if(!za)Ba=2147483647;else Ba=(Y|0)/(za|0)|0}else Ba=(Y<<8|0)/(ea|0)|0;if((Ba|0)>(k[s>>2]|0)){k[s>>2]=Ba;ia=xa;ja=fa;ka=ta;la=Y;ma=F;na=L;oa=va;pa=da;qa=wa;ra=ea;break}za=k[f>>2]|0;Aa=za+72e3|0;ya=8993;while(1){ya=ya+-8|0;k[Aa+-56>>2]=-1;k[Aa+-48>>2]=-1;k[Aa+-40>>2]=-1;k[Aa+-32>>2]=-1;k[Aa+-24>>2]=-1;k[Aa+-16>>2]=-1;k[Aa+-8>>2]=-1;k[Aa>>2]=-1;if((ya|0)<=-1)break;else Aa=Aa+-64|0}k[za>>2]=-1;k[s>>2]=0;Aa=da<<L|256;ya=va+L|0;ca=ya+-8|0;Ca=ua+2|0;i[wa>>0]=Aa>>>ca;if((ca|0)>7){Da=ya+-16|0;i[Ca>>0]=Aa>>>Da;ia=xa;ja=fa;ka=258;la=0;ma=511;na=9;oa=Da;pa=Aa;qa=ua+3|0;ra=L}else{ia=xa;ja=fa;ka=258;la=0;ma=511;na=9;oa=ca;pa=Aa;qa=Ca;ra=L}}else{ia=G;ja=fa;ka=ta;la=Y;ma=F;na=L;oa=va;pa=da;qa=wa;ra=ea}}else{ia=G;ja=j[aa+(W<<3)+4>>1]|0;ka=b;la=Y;ma=F;na=L;oa=J;pa=I;qa=K;ra=H}while(0);if((X|0)<=1){Ea=ia;Fa=ja;Ga=ka;Ha=la;Ia=ma;Ka=na;La=oa;Ma=pa;Na=qa;Oa=ra;break a}else{G=ia;c=ja;b=ka;M=la;F=ma;L=na;J=oa;I=pa;K=qa;H=ra}}Ja(147797,147682,986,147787)}else{Ea=q;Fa=P;Ga=w;Ha=Q;Ia=y;Ka=A;La=R;Ma=S;Na=T;Oa=U}while(0);k[g>>2]=Ha;k[n>>2]=Oa;k[p>>2]=Ea;k[E>>2]=Fa&65535;k[r>>2]=Ma;k[t>>2]=La;j[v>>1]=Ga;j[x>>1]=Ia;j[z>>1]=Ka;k[B>>2]=Na;e=1;return e|0}function Hh(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0;Ji(a)|0;b=a+576|0;c=k[b>>2]|0;if(!c)Ja(147733,147682,1092,147752);d=k[c+124>>2]|0;if(!d){e=c;f=c}else{ne(d);d=k[b>>2]|0;e=d;f=d}d=k[f+152>>2]|0;if(!d){g=e;ne(g);k[b>>2]=0;Ve(a);return}ne(d);g=k[b>>2]|0;ne(g);k[b>>2]=0;Ve(a);return}function Ih(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Bb=0;d=r;r=r+64|0;e=d+48|0;f=d+40|0;g=d+32|0;h=d+24|0;n=d+16|0;o=d+8|0;p=d;q=k[a+576>>2]|0;if(!q)Ja(154187,147682,601,148255);s=q+88|0;t=k[s>>2]|0;do if(!t){u=c;v=b}else{w=k[q+108>>2]|0;x=(m[w+4>>1]|0)-t|0;if((x|0)<=(c|0)){y=b+x|0;z=w;A=x;B=y;while(1){B=B+-1|0;i[B>>0]=i[z+6>>0]|0;A=A+-1|0;if(!A)break;else z=k[z>>2]|0}k[s>>2]=0;u=c-x|0;v=y;break}k[s>>2]=t+c;z=w;A=x;while(1){B=k[z>>2]|0;A=A+-1|0;if((A|0)<=(c|0)){C=B;break}else z=B}z=C;A=c;x=b+c|0;while(1){x=x+-1|0;i[x>>0]=i[z+6>>0]|0;A=A+-1|0;if(!A){D=1;break}else z=k[z>>2]|0}r=d;return D|0}while(0);c=a+604|0;b=k[c>>2]|0;C=q+64|0;t=m[C>>1]|0;z=q+72|0;A=k[z>>2]|0;x=q+76|0;w=k[x>>2]|0;y=q+84|0;B=k[y>>2]|0;E=q+112|0;F=k[E>>2]|0;G=q+116|0;H=k[G>>2]|0;I=q+120|0;J=k[I>>2]|0;a:do if((u|0)>0){K=q+96|0;M=q+124|0;N=F;O=b;P=H;Q=J;R=t;S=B;T=w;U=A;V=u;W=v;b:while(1){X=K;Y=k[X>>2]|0;Z=k[X+4>>2]|0;X=((R|0)<0)<<31>>31;if(Z>>>0<X>>>0|(Z|0)==(X|0)&Y>>>0<R>>>0){_=N;$=O;aa=P;ba=Q;ca=R;da=S;ea=T;fa=U;ga=V;ha=16;break}ia=O+1|0;ja=(l[O>>0]|0)<<T|U;ka=T+8|0;if((ka|0)<(R|0)){la=O+2|0;ma=T+16|0;na=(l[ia>>0]|0)<<ka|ja}else{la=ia;ma=ka;na=ja}ja=na&S;ka=ja&65535;ia=na>>R;oa=ma-R|0;pa=pr(Y|0,Z|0,R|0,X|0)|0;X=K;k[X>>2]=pa;k[X+4>>2]=L;c:do switch(ka|0){case 257:{qa=la;ra=P;sa=Q;ta=R;ua=S;va=oa;wa=ia;xa=V;ya=N;break a;break}case 256:{X=k[M>>2]|0;pa=la;Z=oa;Y=ia;d:while(1){za=X+2064|0;pe(za,0,38888);Aa=k[M>>2]|0;Ba=K;Ca=k[Ba>>2]|0;Da=k[Ba+4>>2]|0;if(Da>>>0<0|(Da|0)==0&Ca>>>0<9){Ea=za;Fa=Aa;Ga=N;Ha=pa;Ia=Z;Ka=Y;La=V;ha=22;break b}Ba=pa+1|0;Ma=(l[pa>>0]|0)<<Z|Y;Na=Z+8|0;if((Na|0)<9){Oa=pa+2|0;Pa=Z+16|0;Qa=(l[Ba>>0]|0)<<Na|Ma}else{Oa=Ba;Pa=Na;Qa=Ma}Ma=Qa&511;Na=Qa>>9;Ba=Pa+-9|0;Ra=sr(Ca|0,Da|0,-9,-1)|0;Da=K;k[Da>>2]=Ra;k[Da+4>>2]=L;switch(Ma|0){case 257:{Sa=za;Ta=Aa;Ua=Na;Va=Ba;Wa=N;Xa=Oa;Ya=V;ha=47;break b;break}case 256:{X=Aa;pa=Oa;Z=Ba;Y=Na;break}default:{Za=za;_a=Aa;$a=Ma;ab=Na;bb=Ba;cb=Oa;db=Qa;break d}}}if($a>>>0>256){ha=27;break b}i[W>>0]=db;eb=cb;fb=Za;gb=_a+4088|0;hb=9;ib=511;jb=bb;kb=ab;lb=V+-1|0;mb=(k[M>>2]|0)+($a<<3)|0;nb=W+1|0;break}default:{Y=k[M>>2]|0;Z=Y+(ka<<3)|0;pa=Y+40952|0;if(!(P>>>0>=Y>>>0&P>>>0<pa>>>0)){ha=31;break b}k[P>>2]=N;if(!(N>>>0>=Y>>>0&N>>>0<pa>>>0)){ha=33;break b}pa=P+7|0;i[pa>>0]=i[N+7>>0]|0;j[P+4>>1]=(m[N+4>>1]|0)+1;i[P+6>>0]=i[(Z>>>0<P>>>0?Y+(ka<<3)+7|0:pa)>>0]|0;pa=P+8|0;if(pa>>>0>Q>>>0){X=R+1|0;Ba=(X|0)>12?12:X;X=(1<<Ba)+-1|0;ob=Y+(X<<3)|0;pb=Ba;qb=X}else{ob=Q;pb=R;qb=S}if(ka>>>0<=255){i[W>>0]=ja;eb=la;fb=pa;gb=ob;hb=pb;ib=qb;jb=oa;kb=ia;lb=V+-1|0;mb=Z;nb=W+1|0;break c}X=j[Y+(ka<<3)+4>>1]|0;Y=X&65535;if(!(X<<16>>16)){ha=38;break b}if((V|0)<(Y|0)){rb=ia;sb=oa;tb=Z;ub=pa;vb=la;wb=ob;xb=pb;yb=qb;zb=V;Ab=W;ha=40;break b}X=W+Y|0;Ba=Z;Na=X;do{Na=Na+-1|0;i[Na>>0]=i[Ba+6>>0]|0;Ba=k[Ba>>2]|0}while((Ba|0)!=0);eb=la;fb=pa;gb=ob;hb=pb;ib=qb;jb=oa;kb=ia;lb=V-Y|0;mb=Z;nb=X}}while(0);if((lb|0)>0){N=mb;O=eb;P=fb;Q=gb;R=hb;S=ib;T=jb;U=kb;V=lb;W=nb}else{qa=eb;ra=fb;sa=gb;ta=hb;ua=ib;va=jb;wa=kb;xa=lb;ya=mb;break a}}if((ha|0)==16){W=k[a+628>>2]|0;k[p>>2]=k[a+452>>2];ie(W,148255,147905,p);qa=$;ra=aa;sa=ba;ta=ca;ua=da;va=ea;wa=fa;xa=ga;ya=_;break}else if((ha|0)==22){W=k[a+628>>2]|0;k[o>>2]=k[a+452>>2];ie(W,148255,147905,o);qa=Ha;ra=Ea;sa=Fa+4088|0;ta=9;ua=511;va=Ia;wa=Ka;xa=La;ya=Ga;break}else if((ha|0)==27){W=k[a+628>>2]|0;V=k[a>>2]|0;k[n>>2]=k[a+444>>2];vc(W,V,147954,n);D=0;r=d;return D|0}else if((ha|0)==31){V=k[a+628>>2]|0;k[h>>2]=k[a+444>>2];vc(V,148255,148e3,h);D=0;r=d;return D|0}else if((ha|0)==33){V=k[a+628>>2]|0;k[g>>2]=k[a+444>>2];vc(V,148255,148e3,g);D=0;r=d;return D|0}else if((ha|0)==38){V=k[a+628>>2]|0;k[f>>2]=k[a+444>>2];vc(V,148255,148035,f);D=0;r=d;return D|0}else if((ha|0)==40){k[q+108>>2]=tb;V=tb;while(1){W=k[V>>2]|0;if((m[W+4>>1]|0|0)>(zb|0))V=W;else{Bb=W;break}}k[s>>2]=zb;V=Bb;W=zb;U=Ab+zb|0;while(1){U=U+-1|0;i[U>>0]=i[V+6>>0]|0;W=W+-1|0;if(!W){qa=vb;ra=ub;sa=wb;ta=xb;ua=yb;va=sb;wa=rb;xa=0;ya=tb;break}else V=k[V>>2]|0}}else if((ha|0)==47){qa=Xa;ra=Sa;sa=Ta+4088|0;ta=9;ua=511;va=Va;wa=Ua;xa=Ya;ya=Wa;break}}else{qa=b;ra=H;sa=J;ta=t;ua=B;va=w;wa=A;xa=u;ya=F}while(0);k[c>>2]=qa;j[C>>1]=ta;k[z>>2]=wa;k[x>>2]=va;k[y>>2]=ua;k[E>>2]=ya;k[G>>2]=ra;k[I>>2]=sa;if((xa|0)<=0){D=1;r=d;return D|0}sa=k[a+628>>2]|0;k[e>>2]=k[a+444>>2];a=e+8|0;k[a>>2]=xa;k[a+4>>2]=((xa|0)<0)<<31>>31;vc(sa,148255,148158,e);D=0;r=d;return D|0}function Jh(a,b){a=a|0;b=b|0;k[a+512>>2]=33;k[a+532>>2]=38;k[a+540>>2]=38;k[a+548>>2]=38;return 1}function Kh(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0;b=r;r=r+16|0;c=b;d=j[a+84>>1]|0;if(d<<16>>16==2){e=1;r=b;return e|0}f=k[a+628>>2]|0;k[c>>2]=d&65535;vc(f,148358,148372,c);e=0;r=b;return e|0}function Lh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0;d=r;r=r+16|0;e=d+8|0;f=(c|0)>0;if(f)qr(b|0,-1,c|0)|0;g=a+604|0;h=a+608|0;j=k[a+580>>2]|0;if((c|0)%(j|0)|0){vc(k[a+628>>2]|0,148314,153793,d);m=0;r=d;return m|0}n=k[h>>2]|0;o=k[g>>2]|0;a:do if((n|0)>0&f){p=a+56|0;q=a+12|0;s=a+68|0;t=j+1|0;u=c;v=o;w=n;x=b;b:while(1){y=v+1|0;z=l[v>>0]|0;A=w+-1|0;c:do switch(z|0){case 0:{if((w|0)<=(j|0))break b;qe(x,y,j);B=v+t|0;C=A-j|0;break}case 64:{if((w|0)<5)break b;D=(l[y>>0]|0)<<8|(l[v+2>>0]|0);E=(l[v+3>>0]|0)<<8|(l[v+4>>0]|0);F=E+4|0;if((w|0)<=(F|0)|(E+D|0)>(j|0))break b;qe(x+D|0,v+5|0,E);B=v+(E+5)|0;C=A-F|0;break}default:{F=k[((k[q>>2]&1024|0)==0?p:s)>>2]|0;E=y;D=A;G=z;H=0;I=x;while(1){J=G>>>6;K=G&63;L=H>>>0<F>>>0;d:do if((K|0)!=0&L){M=J<<6&255;N=J<<4;O=J<<2;P=K;Q=H;R=I;while(1){S=P;T=Q;e:while(1){U=S;S=S+-1|0;V=T+1|0;switch(T&3|0){case 3:{W=U;X=S;Y=V;break e;break}case 0:{i[R>>0]=M;break}case 1:{i[R>>0]=l[R>>0]|0|N;break}case 2:{i[R>>0]=l[R>>0]|0|O;break}default:{}}Z=V>>>0<F>>>0;if(!((U|0)>1&Z)){_=Z;$=V;aa=R;break d}else T=V}T=R+1|0;i[R>>0]=l[R>>0]|0|J;S=Y>>>0<F>>>0;if((W|0)>1&S){P=X;Q=Y;R=T}else{_=S;$=Y;aa=T;break}}}else{_=L;$=H;aa=I}while(0);if(!_){B=E;C=D;break c}if(!D)break b;L=l[E>>0]|0;E=E+1|0;D=D+-1|0;G=L;H=$;I=aa}}}while(0);u=u-j|0;if(!((C|0)>0&(u|0)>0)){ba=B;ca=C;break a}else{v=B;w=C;x=x+j|0}}x=k[a+628>>2]|0;k[e>>2]=k[a+444>>2];vc(x,148314,148325,e);m=0;r=d;return m|0}else{ba=o;ca=n}while(0);k[g>>2]=ba;k[h>>2]=ca;m=1;r=d;return m|0}function Mh(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0;c=r;r=r+32|0;d=c+16|0;if((b|0)!=6)Ja(148403,148429,424,148441);if(!(_b(a,109532,7)|0)){vc(k[a+628>>2]|0,148441,148455,c);e=0;r=c;return e|0}b=me(5368)|0;if(!b){vc(k[a+628>>2]|0,148441,148499,c+8|0);e=0;r=c;return e|0}else{pe(b,0,5368);k[b>>2]=a;i[b+224>>0]=1;i[b+228>>0]=2;i[b+229>>0]=2;k[d>>2]=2;k[d+4>>2]=2;Ob(a,530,d)|0;k[a+504>>2]=29;k[a+508>>2]=30;k[a+512>>2]=34;k[a+652>>2]=29;k[a+532>>2]=39;k[a+540>>2]=39;k[a+548>>2]=39;k[a+516>>2]=31;k[a+524>>2]=35;k[a+528>>2]=32;k[a+536>>2]=40;k[a+544>>2]=40;k[a+552>>2]=40;k[a+564>>2]=22;k[a+576>>2]=b;d=a+668|0;f=a+672|0;k[b+160>>2]=k[f>>2];k[f>>2]=21;k[b+164>>2]=k[d>>2];k[d>>2]=22;d=a+676|0;k[b+168>>2]=k[d>>2];k[d>>2]=30;d=a+12|0;k[d>>2]=k[d>>2]|131072;e=1;r=c;return e|0}return 0}function Nh(a){a=a|0;return 1}function Oh(a){a=a|0;var b=0;b=r;r=r+16|0;ie(k[a+628>>2]|0,151837,151854,b);r=b;return 1}function Ph(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0;c=r;r=r+48|0;d=c+32|0;e=c+24|0;f=c+16|0;g=c+8|0;h=c;n=a+576|0;o=k[n>>2]|0;if(!(i[o+226>>0]|0))_h(a);do if(!(i[o+488>>0]|0)){p=k[n>>2]|0;q=p+488|0;if(i[q>>0]|0)Ja(151233,148429,1040,151256);s=k[a+56>>2]|0;k[p+184>>2]=s;t=k[a+60>>2]|0;k[p+188>>2]=t;if(!(k[a+12>>2]&1024)){u=t;v=s;w=k[a+100>>2]|0}else{s=k[a+72>>2]|0;x=t+-1+s|0;u=x-((x>>>0)%(s>>>0)|0)|0;v=k[a+68>>2]|0;w=s}k[p+192>>2]=v;k[p+196>>2]=w;k[p+200>>2]=u;a:do switch(j[a+98>>1]|0){case 1:{i[p+204>>0]=1;i[p+205>>0]=0;i[p+206>>0]=1;i[p+228>>0]=1;i[p+229>>0]=1;break}case 3:{i[p+204>>0]=3;i[p+205>>0]=0;s=p+206|0;if((j[a+126>>1]|0)==1){i[s>>0]=3;break a}else{i[s>>0]=1;break a}break}default:{s=k[a+628>>2]|0;k[h>>2]=l[p+204>>0];vc(s,151256,151276,h);y=0;r=c;return y|0}}while(0);do if(w>>>0<t>>>0){s=l[p+229>>0]<<3;if(!((w>>>0)%(s>>>0)|0)){x=l[p+228>>0]<<3;z=(ha((w>>>0)/(s>>>0)|0,((v+-1+x|0)>>>0)/(x>>>0)|0)|0)&65535;j[p+360>>1]=z;break}vc(k[a+628>>2]|0,151256,151337,g);y=0;r=c;return y|0}while(0);if(!($h(a)|0)){y=0;r=c;return y|0}else{i[p+392>>0]=1;k[p+396>>2]=k[p+1220>>2];k[p+400>>2]=k[p+1224>>2];t=p+1232|0;z=m[p+1256>>1]|0;x=pr(k[t>>2]|0,k[t+4>>2]|0,z|0,0)|0;t=p+408|0;k[t>>2]=x;k[t+4>>2]=L;t=p+1248|0;x=sr(z|0,0,k[t>>2]|0,k[t+4>>2]|0)|0;t=p+416|0;k[t>>2]=x;k[t+4>>2]=L;i[q>>0]=1;break}}while(0);g=b&65535;b:do if(!(i[o+392+(g<<5)>>0]|0)){v=k[n>>2]|0;if(!(b<<16>>16))Ja(151399,148429,1102,151403);if((b&65535)>=3)Ja(151425,148429,1103,151403);if(!(i[v+392>>0]|0))Ja(151429,148429,1104,151403);if(i[v+392+(g<<5)>>0]|0)Ja(151451,148429,1105,151403);w=g+255&255;while(1){h=w&255;if(!(i[v+392+(h<<5)>>0]|0))w=w+-1<<24>>24;else{A=h;B=w;break}}w=v+205|0;i[w>>0]=B;q=v+1220|0;k[q>>2]=k[v+392+(A<<5)+4>>2];p=v+1224|0;k[p>>2]=k[v+392+(A<<5)+8>>2];h=v+392+(A<<5)+16|0;u=k[h+4>>2]|0;t=v+1232|0;x=t;k[x>>2]=k[h>>2];k[x+4>>2]=u;i[v+1240>>0]=0;u=v+392+(A<<5)+24|0;x=k[u+4>>2]|0;h=v+1248|0;z=h;k[z>>2]=k[u>>2];k[z+4>>2]=x;x=v+1256|0;j[x>>1]=0;z=v+1260|0;k[z>>2]=0;if(A>>>0<g>>>0){u=0;c:while(1){if(!(u<<16>>16)){if(!(ai(v)|0)){y=0;C=105;break}s=j[x>>1]|0;if(!(s<<16>>16)){C=36;break}else D=s}else D=u;s=k[z>>2]|0;E=i[s>>0]|0;F=s+1|0;k[z>>2]=F;s=D+-1<<16>>16;j[x>>1]=s;if(E<<24>>24==-1){G=s;H=F}else{u=s;continue}d:while(1){if(!(G<<16>>16)){if(!(ai(v)|0)){y=0;C=105;break c}s=j[x>>1]|0;if(!(s<<16>>16)){C=42;break c}I=k[z>>2]|0;J=s}else{I=H;J=G}s=i[I>>0]|0;F=I+1|0;k[z>>2]=F;E=J+-1<<16>>16;j[x>>1]=E;switch(s<<24>>24){case -1:{G=E;H=F;break}case -38:{break d;break}default:{u=E;continue c}}}i[w>>0]=(i[w>>0]|0)+1<<24>>24;if(!(bi(a)|0)){y=0;C=105;break}E=l[w>>0]|0;i[v+392+(E<<5)>>0]=1;k[v+392+(E<<5)+4>>2]=k[q>>2];k[v+392+(E<<5)+8>>2]=k[p>>2];F=t;u=j[x>>1]|0;s=u&65535;K=pr(k[F>>2]|0,k[F+4>>2]|0,s|0,0)|0;F=v+392+(E<<5)+16|0;k[F>>2]=K;k[F+4>>2]=L;F=h;K=sr(s|0,0,k[F>>2]|0,k[F+4>>2]|0)|0;F=v+392+(E<<5)+24|0;k[F>>2]=K;k[F+4>>2]=L;if(E>>>0>=g>>>0)break b}if((C|0)==36)Ja(149747,148429,2016,149786);else if((C|0)==42)Ja(149747,148429,2016,149786);else if((C|0)==105){r=c;return y|0}}}while(0);H=k[((k[a+12>>2]&1024|0)==0?a+452|0:a+492|0)>>2]|0;G=o+489|0;J=o+490|0;do if(!(i[G>>0]|0))C=54;else{if((j[J>>1]|0)==b<<16>>16?(I=o+492|0,D=k[I>>2]|0,D>>>0<=H>>>0):0){M=I;N=D;break}do if(i[o+496>>0]|0){D=k[n>>2]|0;I=D+496|0;if(!(i[I>>0]|0))Ja(150963,148429,1245,150993);else{Bk(D+632|0);i[I>>0]=0;break}}while(0);i[G>>0]=0;C=54}while(0);do if((C|0)==54){i[o+205>>0]=b;j[J>>1]=b;G=ha(k[a+164>>2]|0,g)|0;I=o+492|0;k[I>>2]=G;G=o+1240|0;if(i[G>>0]|0){D=o+1232|0;A=D;B=o+1256|0;v=pr(k[A>>2]|0,k[A+4>>2]|0,m[B>>1]|0,0)|0;A=o+392+(g<<5)+16|0;h=k[A>>2]|0;u=k[A+4>>2]|0;if(!((v|0)==(h|0)&(L|0)==(u|0))){O=D;P=B;Q=h;R=u;C=57}}else{u=o+392+(g<<5)+16|0;O=o+1232|0;P=o+1256|0;Q=k[u>>2]|0;R=k[u+4>>2]|0;C=57}if((C|0)==57){k[o+1220>>2]=k[o+392+(g<<5)+4>>2];k[o+1224>>2]=k[o+392+(g<<5)+8>>2];u=O;k[u>>2]=Q;k[u+4>>2]=R;i[G>>0]=0;G=o+392+(g<<5)+24|0;u=k[G+4>>2]|0;h=o+1248|0;k[h>>2]=k[G>>2];k[h+4>>2]=u;j[P>>1]=0;k[o+1260>>2]=0}u=k[n>>2]|0;h=u+496|0;if(i[h>>0]|0){y=0;r=c;return y|0}k[u+3312>>2]=0;i[u+362>>0]=0;G=u+500|0;Ql(G)|0;k[u+508>>2]=23;k[G>>2]=24;B=u+632|0;k[B>>2]=G;k[u+644>>2]=a;if(!(gi(u,B)|0)){y=0;r=c;return y|0}i[h>>0]=1;k[u+1124>>2]=0;k[u+1128>>2]=25;k[u+1132>>2]=33;k[u+1136>>2]=5;k[u+1140>>2]=36;k[u+1144>>2]=26;k[u+656>>2]=u+1120;if(!(mi(u,B)|0)){y=0;r=c;return y|0}h=i[u+206>>0]|0;if((i[u+230>>0]|0)==0&(h&255)>1){k[u+700>>2]=1;k[u+708>>2]=0;i[u+497>>0]=0;G=u+1148|0;if(!(i[G>>0]|0)){D=u+1180|0;if(k[D>>2]|0)Ja(151473,148429,1185,151509);v=u+1200|0;if(k[v>>2]|0)Ja(151530,148429,1186,151509);A=u+192|0;x=u+228|0;t=l[x>>0]|0;p=t<<3;q=(k[A>>2]|0)+-1+p|0;w=q-((q>>>0)%(p>>>0)|0)|0;p=u+1152|0;k[p>>2]=w;q=u+229|0;z=l[q>>0]<<3;E=u+1156|0;k[E>>2]=z;F=(w>>>0)/(t>>>0)|0;t=u+1160|0;k[t>>2]=F;K=u+1164|0;k[K>>2]=8;s=ha(z,w)|0;w=u+1168|0;k[w>>2]=s;z=u+1172|0;k[z>>2]=F<<3;S=s+(F<<4)|0;k[u+1176>>2]=S;F=me(S)|0;k[D>>2]=F;if(!F){vc(k[a+628>>2]|0,151509,150005,f);y=0;r=c;return y|0}D=u+1184|0;k[D>>2]=F;S=k[w>>2]|0;w=u+1188|0;k[w>>2]=F+S;s=u+1192|0;k[s>>2]=F+((k[z>>2]|0)+S);S=(k[E>>2]|0)+3+(k[K>>2]<<1)|0;k[u+1196>>2]=S;z=me(S<<2)|0;k[v>>2]=z;if(!z){vc(k[a+628>>2]|0,151509,150005,e);y=0;r=c;return y|0}S=z+12|0;k[z>>2]=S;F=k[E>>2]|0;E=F+3|0;k[z+4>>2]=(k[v>>2]|0)+(E<<2);T=k[K>>2]|0;k[z+8>>2]=(k[v>>2]|0)+(T+E<<2);if(!F)U=S;else{E=k[p>>2]|0;p=F>>>0>1?(F<<2)+12|0:16;v=S;S=0;while(1){K=(k[D>>2]|0)+(ha(S,E)|0)|0;k[v>>2]=K;S=S+1|0;if((S|0)==(F|0))break;else v=v+4|0}U=z+p|0}if(T){v=k[t>>2]|0;F=T>>>0>1;S=U;E=0;while(1){D=(k[w>>2]|0)+(ha(E,v)|0)|0;k[S>>2]=D;E=E+1|0;if((E|0)==(T|0))break;else S=S+4|0}S=U+((F?T:1)<<2)|0;E=0;while(1){w=(k[s>>2]|0)+(ha(E,v)|0)|0;k[S>>2]=w;E=E+1|0;if((E|0)==(T|0))break;else S=S+4|0}}S=l[x>>0]|0;T=(((k[A>>2]|0)+-1+S|0)>>>0)/(S>>>0)|0;k[u+1204>>2]=T;k[u+1208>>2]=0;E=l[q>>0]|0;v=ha((ha(E,S)|0)+2|0,T)|0;k[u+1212>>2]=v;k[u+1216>>2]=(((k[u+196>>2]|0)+-1+E|0)>>>0)/(E>>>0)|0;i[G>>0]=1}}else{k[u+672>>2]=0;k[u+676>>2]=0;i[u+497>>0]=1;E=ha(k[u+192>>2]|0,h&255)|0;k[u+1212>>2]=E;k[u+1216>>2]=k[u+196>>2]}if(!(ni(u,B)|0)){y=0;r=c;return y|0}else{i[u+489>>0]=1;M=I;N=k[I>>2]|0;break}}while(0);if(N>>>0>=H>>>0){y=1;r=c;return y|0}N=o+497|0;e:while(1){o=k[n>>2]|0;f:do if(!(i[N>>0]|0)){U=k[o+1216>>2]|0;e=o+1208|0;f=k[e>>2]|0;P=o+1164|0;g=k[P>>2]|0;do if(f){R=g-f|0;if(U>>>0>R>>>0){k[e>>2]=0;V=U-R|0;break}else{R=f+U|0;k[e>>2]=(R|0)==(g|0)?0:R;break f}}else V=U;while(0);if(V>>>0<g>>>0)W=V;else{U=o+632|0;f=o+1200|0;R=o+229|0;Q=V;while(1){if(!(ci(o,U,k[f>>2]|0,l[R>>0]<<3)|0)){y=0;C=105;break e}O=k[P>>2]|0;b=Q-O|0;if(b>>>0<O>>>0){W=b;break}else Q=b}}if(W){if(!(ci(o,o+632|0,k[o+1200>>2]|0,l[o+229>>0]<<3)|0)){y=0;C=105;break e}k[e>>2]=W}}else{Q=o+5364|0;if((k[Q>>2]|0)==0?(P=me(k[o+1212>>2]|0)|0,k[Q>>2]=P,(P|0)==0):0){C=101;break e}P=o+632|0;R=o+1216|0;if(k[R>>2]|0){f=0;do{f=f+1|0;if(!(di(o,P,Q)|0)){y=0;C=105;break e}}while(f>>>0<(k[R>>2]|0)>>>0)}}while(0);o=(k[M>>2]|0)+1|0;k[M>>2]=o;if(o>>>0>=H>>>0){y=1;C=105;break}}if((C|0)==101){vc(k[a+628>>2]|0,151568,150005,d);y=0;r=c;return y|0}else if((C|0)==105){r=c;return y|0}return 0}function Qh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;c=k[a+576>>2]|0;b=c+492|0;d=(k[b>>2]|0)+1|0;k[b>>2]=d;if((d>>>0)%((k[a+164>>2]|0)>>>0)|0)return;a=c+496|0;if(!(i[a>>0]|0))Ja(150963,148429,891,151217);Bk(c+632|0);i[a>>0]=0;i[c+489>>0]=0;return}function Rh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;d=r;r=r+16|0;e=d+8|0;f=d;g=d+12|0;h=k[a+576>>2]|0;if(i[h+497>>0]|0){j=h+1212|0;a:do if(!((c>>>0)%((k[j>>2]|0)>>>0)|0)){if((c|0)<=0)Ja(151191,148429,869,151196);k[g>>2]=b;m=h+632|0;n=c;do{if(!(di(h,m,g)|0))break a;o=k[j>>2]|0;k[g>>2]=(k[g>>2]|0)+o;n=n-o|0}while((n|0)>0);p=1;r=d;return p|0}else vc(k[a+628>>2]|0,151196,151162,e);while(0);p=0;r=d;return p|0}e=h+1212|0;if((c>>>0)%((k[e>>2]|0)>>>0)|0){vc(k[a+628>>2]|0,151147,151162,f);p=0;r=d;return p|0}if((c|0)<=0)Ja(151191,148429,821,151147);f=h+632|0;a=h+1200|0;g=h+1208|0;j=h+229|0;n=h+1184|0;m=h+1152|0;o=h+1188|0;q=h+1160|0;s=h+1192|0;t=h+1204|0;u=h+1164|0;v=h+228|0;w=k[g>>2]|0;x=b;b=c;while(1){if(!w){if(!(ci(h,f,k[a>>2]|0,l[j>>0]<<3)|0)){p=0;y=30;break}z=k[g>>2]|0}else z=w;c=ha(k[q>>2]|0,z)|0;if(!(k[t>>2]|0))A=z;else{B=i[j>>0]|0;C=ha(B&255,z)|0;D=B;B=(k[o>>2]|0)+c|0;E=(k[s>>2]|0)+c|0;c=(k[n>>2]|0)+(ha(C,k[m>>2]|0)|0)|0;C=x;F=0;while(1){G=i[v>>0]|0;if(!(D<<24>>24)){H=G;I=C}else{J=G;K=D;L=G;G=C;M=c;N=0;while(1){if(!(L<<24>>24)){O=J;P=0;Q=K;R=G;S=M}else{T=G;U=M;V=0;while(1){W=U+1|0;X=T+1|0;i[T>>0]=i[U>>0]|0;V=V+1<<24>>24;Y=i[v>>0]|0;if((V&255)>=(Y&255)){Z=W;_=X;$=Y;break}else{T=X;U=W}}O=$;P=$;Q=i[j>>0]|0;R=_;S=Z}N=N+1<<24>>24;if((N&255)>=(Q&255)){H=O;I=R;break}else{J=O;K=Q;L=P;G=R;M=S+((k[m>>2]|0)-(P&255))|0}}}i[I>>0]=i[B>>0]|0;i[I+1>>0]=i[E>>0]|0;M=F+1|0;if(M>>>0>=(k[t>>2]|0)>>>0)break;D=i[j>>0]|0;B=B+1|0;E=E+1|0;c=c+(H&255)|0;C=I+2|0;F=M}A=k[g>>2]|0}F=A+1|0;w=(F|0)==(k[u>>2]|0)?0:F;k[g>>2]=w;F=k[e>>2]|0;b=b-F|0;if((b|0)<=0){p=1;y=30;break}else x=x+F|0}if((y|0)==30){r=d;return p|0}return 0}function Sh(a){a=a|0;var b=0;b=r;r=r+16|0;vc(k[a+628>>2]|0,151130,151030,b);r=b;return 0}function Th(a,b){a=a|0;b=b|0;b=r;r=r+16|0;vc(k[a+628>>2]|0,151115,151030,b);r=b;return 0}function Uh(a){a=a|0;var b=0;b=r;r=r+16|0;vc(k[a+628>>2]|0,151099,151030,b);r=b;return 0}function Vh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;d=r;r=r+16|0;vc(k[a+628>>2]|0,151018,151030,d);r=d;return 0}function Wh(a){a=a|0;var b=0,c=0,d=0,e=0;b=a+576|0;c=k[b>>2]|0;if(!c)return;k[a+672>>2]=k[c+160>>2];k[a+668>>2]=k[c+164>>2];k[a+676>>2]=k[c+168>>2];d=k[c+312>>2]|0;if(d)ne(d);d=k[c+316>>2]|0;if(d)ne(d);d=k[c+320>>2]|0;if(d)ne(d);d=k[c+324>>2]|0;if(d)ne(d);d=k[c+328>>2]|0;if(d)ne(d);d=k[c+332>>2]|0;if(d)ne(d);d=k[c+336>>2]|0;if(d)ne(d);d=k[c+340>>2]|0;if(d)ne(d);d=k[c+344>>2]|0;if(d)ne(d);d=k[c+348>>2]|0;if(d)ne(d);d=k[c+352>>2]|0;if(d)ne(d);d=k[c+356>>2]|0;if(d)ne(d);do if(i[c+496>>0]|0){d=k[b>>2]|0;e=d+496|0;if(!(i[e>>0]|0))Ja(150963,148429,1245,150993);else{Bk(d+632|0);i[e>>0]=0;break}}while(0);e=k[c+1180>>2]|0;if(e)ne(e);e=k[c+1200>>2]|0;if(e)ne(e);e=k[c+5364>>2]|0;if(e)ne(e);ne(c);k[b>>2]=0;Ve(a);return}function Xh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,m=0;d=k[a+576>>2]|0;switch(b|0){case 513:{e=d+208|0;f=k[e>>2]|0;g=k[e+4>>2]|0;e=(k[c>>2]|0)+(4-1)&~(4-1);h=k[e>>2]|0;k[c>>2]=e+4;e=h;k[e>>2]=f;k[e+4>>2]=g;m=1;return m|0}case 514:{g=d+216|0;e=k[g>>2]|0;f=k[g+4>>2]|0;g=(k[c>>2]|0)+(4-1)&~(4-1);h=k[g>>2]|0;k[c>>2]=g+4;g=h;k[g>>2]=e;k[g+4>>2]=f;m=1;return m|0}case 530:{if(!(i[d+226>>0]|0))_h(a);f=l[d+228>>0]|0;g=(k[c>>2]|0)+(4-1)&~(4-1);e=k[g>>2]|0;k[c>>2]=g+4;j[e>>1]=f;f=l[d+229>>0]|0;e=(k[c>>2]|0)+(4-1)&~(4-1);g=k[e>>2]|0;k[c>>2]=e+4;j[g>>1]=f;m=1;return m|0}case 519:{f=l[d+231>>0]|0;g=(k[c>>2]|0)+(4-1)&~(4-1);e=k[g>>2]|0;k[c>>2]=g+4;k[e>>2]=f;f=(k[c>>2]|0)+(4-1)&~(4-1);e=k[f>>2]|0;k[c>>2]=f+4;k[e>>2]=d+240;m=1;return m|0}case 520:{e=l[d+232>>0]|0;f=(k[c>>2]|0)+(4-1)&~(4-1);g=k[f>>2]|0;k[c>>2]=f+4;k[g>>2]=e;e=(k[c>>2]|0)+(4-1)&~(4-1);g=k[e>>2]|0;k[c>>2]=e+4;k[g>>2]=d+264;m=1;return m|0}case 521:{g=l[d+233>>0]|0;e=(k[c>>2]|0)+(4-1)&~(4-1);f=k[e>>2]|0;k[c>>2]=e+4;k[f>>2]=g;g=(k[c>>2]|0)+(4-1)&~(4-1);f=k[g>>2]|0;k[c>>2]=g+4;k[f>>2]=d+288;m=1;return m|0}case 512:{f=l[d+224>>0]|0;g=(k[c>>2]|0)+(4-1)&~(4-1);e=k[g>>2]|0;k[c>>2]=g+4;j[e>>1]=f;m=1;return m|0}case 515:{f=j[d+360>>1]|0;e=(k[c>>2]|0)+(4-1)&~(4-1);g=k[e>>2]|0;k[c>>2]=e+4;j[g>>1]=f;m=1;return m|0}default:{m=nb[k[d+160>>2]&63](a,b,c)|0;return m|0}}return 0}function Yh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,m=0,n=0,o=0,p=0,q=0,s=0;d=r;r=r+32|0;e=d+16|0;f=d+8|0;g=d;h=k[a+576>>2]|0;switch(b|0){case 513:{m=(k[c>>2]|0)+(8-1)&~(8-1);n=m;o=k[n>>2]|0;p=k[n+4>>2]|0;k[c>>2]=m+8;m=h+208|0;k[m>>2]=o;k[m+4>>2]=p;break}case 514:{p=(k[c>>2]|0)+(8-1)&~(8-1);m=p;o=k[m>>2]|0;n=k[m+4>>2]|0;k[c>>2]=p+8;p=h+216|0;k[p>>2]=o;k[p+4>>2]=n;break}case 530:{i[h+227>>0]=1;n=(k[c>>2]|0)+(4-1)&~(4-1);p=k[n>>2]|0;k[c>>2]=n+4;n=h+228|0;i[n>>0]=p;p=(k[c>>2]|0)+(4-1)&~(4-1);o=k[p>>2]|0;k[c>>2]=p+4;i[h+229>>0]=o;j[a+192>>1]=l[n>>0]|0;j[a+194>>1]=o&255;break}case 519:{o=(k[c>>2]|0)+(4-1)&~(4-1);n=k[o>>2]|0;k[c>>2]=o+4;if(n)if(n>>>0>3){vc(k[a+628>>2]|0,148714,148729,g);q=0;r=d;return q|0}else{i[h+231>>0]=n;g=(k[c>>2]|0)+(4-1)&~(4-1);o=k[g>>2]|0;k[c>>2]=g+4;g=0;do{p=o+(g<<3)|0;m=k[p+4>>2]|0;s=h+240+(g<<3)|0;k[s>>2]=k[p>>2];k[s+4>>2]=m;g=g+1|0}while((g|0)!=(n|0))}break}case 520:{n=(k[c>>2]|0)+(4-1)&~(4-1);g=k[n>>2]|0;k[c>>2]=n+4;if(g)if(g>>>0>3){vc(k[a+628>>2]|0,148714,148765,f);q=0;r=d;return q|0}else{i[h+232>>0]=g;f=(k[c>>2]|0)+(4-1)&~(4-1);n=k[f>>2]|0;k[c>>2]=f+4;f=0;do{o=n+(f<<3)|0;m=k[o+4>>2]|0;s=h+264+(f<<3)|0;k[s>>2]=k[o>>2];k[s+4>>2]=m;f=f+1|0}while((f|0)!=(g|0))}break}case 521:{g=(k[c>>2]|0)+(4-1)&~(4-1);f=k[g>>2]|0;k[c>>2]=g+4;if(f)if(f>>>0>3){vc(k[a+628>>2]|0,148714,148802,e);q=0;r=d;return q|0}else{i[h+233>>0]=f;e=(k[c>>2]|0)+(4-1)&~(4-1);g=k[e>>2]|0;k[c>>2]=e+4;e=0;do{n=g+(e<<3)|0;m=k[n+4>>2]|0;s=h+288+(e<<3)|0;k[s>>2]=k[n>>2];k[s+4>>2]=m;e=e+1|0}while((e|0)!=(f|0))}break}case 512:{f=(k[c>>2]|0)+(4-1)&~(4-1);e=k[f>>2]|0;k[c>>2]=f+4;i[h+224>>0]=e;break}case 515:{e=(k[c>>2]|0)+(4-1)&~(4-1);f=k[e>>2]|0;k[c>>2]=e+4;j[h+360>>1]=f;break}default:{q=nb[k[h+164>>2]&63](a,b,c)|0;r=d;return q|0}}c=cc(a,b)|0;if(!c){q=0;r=d;return q|0}b=j[c+24>>1]|0;c=a+40+(((b&65535)>>>5&65535)<<2)|0;k[c>>2]=1<<(b&31)|k[c>>2];c=a+12|0;k[c>>2]=k[c>>2]|8;q=1;r=d;return q|0}function Zh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;d=r;r=r+64|0;e=d+48|0;f=d+40|0;g=d+32|0;h=d+24|0;j=d+16|0;n=d+8|0;o=d;p=k[a+576>>2]|0;if(!p)Ja(148530,148429,616,148539);q=a+48|0;s=k[q>>2]|0;if(!(s&4))t=s;else{k[o>>2]=k[p+208>>2];wq(b,148553,o)|0;t=k[q>>2]|0}if(!(t&8))u=t;else{k[n>>2]=k[p+216>>2];wq(b,148583,n)|0;u=k[q>>2]|0}if(!(u&16))v=u;else{zq(148619,14,1,b)|0;u=p+231|0;if(i[u>>0]|0){n=0;do{k[j>>2]=k[p+240+((n&255)<<3)>>2];wq(b,148634,j)|0;n=n+1<<24>>24}while((n&255)<(l[u>>0]|0))}xq(10,b)|0;v=k[q>>2]|0}if(!(v&32))w=v;else{zq(148639,15,1,b)|0;v=p+232|0;if(i[v>>0]|0){u=0;do{k[h>>2]=k[p+264+((u&255)<<3)>>2];wq(b,148634,h)|0;u=u+1<<24>>24}while((u&255)<(l[v>>0]|0))}xq(10,b)|0;w=k[q>>2]|0}if(!(w&64))x=w;else{zq(148655,15,1,b)|0;w=p+233|0;if(i[w>>0]|0){v=0;do{k[g>>2]=k[p+288+((v&255)<<3)>>2];wq(b,148634,g)|0;v=v+1<<24>>24}while((v&255)<(l[w>>0]|0))}xq(10,b)|0;x=k[q>>2]|0}if(!(x&128))y=x;else{k[f>>2]=l[p+224>>0];wq(b,148671,f)|0;y=k[q>>2]|0}if(y&256){k[e>>2]=m[p+360>>1];wq(b,148687,e)|0}e=k[p+168>>2]|0;if(!e){r=d;return}vb[e&127](a,b,c);r=d;return}function _h(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;b=r;r=r+64|0;c=b+48|0;d=b+40|0;e=b+32|0;f=b+16|0;g=b+8|0;h=b;m=k[a+576>>2]|0;gc(a)|0;n=m+226|0;if(i[n>>0]|0)Ja(148839,148429,989,148870);a:do if((j[a+98>>1]|0)==3){switch(j[a+90>>1]|0){case 10:case 6:break;default:break a}i[n>>0]=1;o=m+228|0;p=i[o>>0]|0;q=m+229|0;s=i[q>>0]|0;t=m+225|0;i[t>>0]=1;$h(a)|0;u=m+230|0;v=(i[u>>0]|0)==0;if(v)w=i[o>>0]|0;else{i[o>>0]=1;i[q>>0]=1;w=1}i[t>>0]=0;t=p&255;if(w<<24>>24==p<<24>>24?(i[q>>0]|0)==s<<24>>24:0)x=17;else x=13;do if((x|0)==13)if(v){p=k[a+628>>2]|0;y=w&255;z=l[q>>0]|0;if(!(i[m+227>>0]|0)){k[g>>2]=y;k[g+4>>2]=z;ie(p,148870,148970,g);x=17;break}else{k[f>>2]=y;k[f+4>>2]=z;k[f+8>>2]=t;k[f+12>>2]=s&255;ie(p,148870,149125,f);x=17;break}}else x=18;while(0);if((x|0)==17?(i[u>>0]|0)!=0:0)x=18;if((x|0)==18){v=k[a+628>>2]|0;if(!(i[m+227>>0]|0))ie(v,148870,149258,e);else{k[d>>2]=t;k[d+4>>2]=s&255;ie(v,148870,149488,d)}if(i[u>>0]|0){i[n>>0]=1;r=b;return}}v=i[o>>0]|0;p=i[q>>0]|0;if((v&255)>=(p&255)){i[n>>0]=1;r=b;return}z=k[a+628>>2]|0;k[c>>2]=v&255;k[c+4>>2]=p&255;ie(z,148870,149696,c);i[n>>0]=1;r=b;return}while(0);if(i[m+227>>0]|0)ie(k[a+628>>2]|0,148870,148894,h);i[m+228>>0]=1;i[m+229>>0]=1;i[m+230>>0]=0;i[n>>0]=1;r=b;return}
function Cj(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0;c=a+116|0;d=(b|0)==0;e=a+72|0;f=a+88|0;g=a+108|0;h=a+56|0;m=a+84|0;n=a+68|0;o=a+52|0;p=a+64|0;q=a+96|0;r=a+120|0;s=a+112|0;t=a+100|0;u=a+5792|0;v=a+5796|0;w=a+5784|0;x=a+5788|0;y=a+104|0;z=a+92|0;A=a+128|0;B=a+44|0;C=a+136|0;a:while(1){D=k[c>>2]|0;while(1){if(D>>>0<262){zj(a);E=k[c>>2]|0;if(d&E>>>0<262){F=0;G=55;break a}if(!E){G=38;break a}if(E>>>0<=2){k[r>>2]=k[q>>2];k[t>>2]=k[s>>2];k[q>>2]=2;H=2;G=16}else G=8}else G=8;do if((G|0)==8){G=0;E=k[g>>2]|0;I=((l[(k[h>>2]|0)+(E+2)>>0]|0)^k[e>>2]<<k[f>>2])&k[m>>2];k[e>>2]=I;J=(k[n>>2]|0)+(I<<1)|0;I=j[J>>1]|0;j[(k[p>>2]|0)+((k[o>>2]&E)<<1)>>1]=I;K=I&65535;j[J>>1]=E;E=k[q>>2]|0;k[r>>2]=E;k[t>>2]=k[s>>2];k[q>>2]=2;if(I<<16>>16)if(E>>>0<(k[A>>2]|0)>>>0)if(((k[g>>2]|0)-K|0)>>>0<=((k[B>>2]|0)+-262|0)>>>0){I=Dj(a,K)|0;k[q>>2]=I;if(I>>>0<6){if((k[C>>2]|0)!=1){if((I|0)!=3){H=I;G=16;break}if(((k[g>>2]|0)-(k[s>>2]|0)|0)>>>0<=4096){H=3;G=16;break}}k[q>>2]=2;H=2;G=16}else{H=I;G=16}}else{H=2;G=16}else{L=E;M=2}else{H=2;G=16}}while(0);if((G|0)==16){G=0;L=k[r>>2]|0;M=H}if(!(L>>>0<3|M>>>0>L>>>0)){N=L;break}if(!(k[y>>2]|0)){k[y>>2]=1;k[g>>2]=(k[g>>2]|0)+1;E=(k[c>>2]|0)+-1|0;k[c>>2]=E;D=E;continue}E=i[(k[h>>2]|0)+((k[g>>2]|0)+-1)>>0]|0;I=k[u>>2]|0;j[(k[v>>2]|0)+(I<<1)>>1]=0;k[u>>2]=I+1;i[(k[w>>2]|0)+I>>0]=E;I=a+148+((E&255)<<2)|0;j[I>>1]=(j[I>>1]|0)+1<<16>>16;if((k[u>>2]|0)==((k[x>>2]|0)+-1|0)){I=k[z>>2]|0;if((I|0)>-1)O=(k[h>>2]|0)+I|0;else O=0;Pj(a,O,(k[g>>2]|0)-I|0,0);k[z>>2]=k[g>>2];I=k[a>>2]|0;E=k[I+28>>2]|0;Nj(E);K=E+20|0;J=k[K>>2]|0;P=I+16|0;Q=k[P>>2]|0;R=J>>>0>Q>>>0?Q:J;if((R|0)!=0?(J=I+12|0,Q=E+16|0,wr(k[J>>2]|0,k[Q>>2]|0,R|0)|0,k[J>>2]=(k[J>>2]|0)+R,k[Q>>2]=(k[Q>>2]|0)+R,J=I+20|0,k[J>>2]=(k[J>>2]|0)+R,k[P>>2]=(k[P>>2]|0)-R,P=k[K>>2]|0,k[K>>2]=P-R,(P|0)==(R|0)):0)k[Q>>2]=k[E+8>>2]}k[g>>2]=(k[g>>2]|0)+1;D=(k[c>>2]|0)+-1|0;k[c>>2]=D;if(!(k[(k[a>>2]|0)+16>>2]|0)){F=0;G=55;break a}}D=k[g>>2]|0;E=D+-3+(k[c>>2]|0)|0;Q=N+253|0;R=D+65535-(k[t>>2]|0)|0;D=k[u>>2]|0;j[(k[v>>2]|0)+(D<<1)>>1]=R;k[u>>2]=D+1;i[(k[w>>2]|0)+D>>0]=Q;D=a+148+((l[155385+(Q&255)>>0]|0|256)+1<<2)|0;j[D>>1]=(j[D>>1]|0)+1<<16>>16;D=R+65535&65535;R=a+2440+((l[154873+(D>>>0<256?D:(D>>>7)+256|0)>>0]|0)<<2)|0;j[R>>1]=(j[R>>1]|0)+1<<16>>16;R=k[u>>2]|0;D=(k[x>>2]|0)+-1|0;Q=k[r>>2]|0;k[c>>2]=1-Q+(k[c>>2]|0);P=Q+-2|0;k[r>>2]=P;Q=k[g>>2]|0;K=P;while(1){P=Q+1|0;k[g>>2]=P;if(P>>>0<=E>>>0){J=((l[(k[h>>2]|0)+(Q+3)>>0]|0)^k[e>>2]<<k[f>>2])&k[m>>2];k[e>>2]=J;I=(k[n>>2]|0)+(J<<1)|0;j[(k[p>>2]|0)+((k[o>>2]&P)<<1)>>1]=j[I>>1]|0;j[I>>1]=P}K=K+-1|0;k[r>>2]=K;if(!K){S=Q;break}else Q=P}k[y>>2]=0;k[q>>2]=2;Q=S+2|0;k[g>>2]=Q;if((R|0)!=(D|0))continue;K=k[z>>2]|0;if((K|0)>-1)T=(k[h>>2]|0)+K|0;else T=0;Pj(a,T,Q-K|0,0);k[z>>2]=k[g>>2];K=k[a>>2]|0;Q=k[K+28>>2]|0;Nj(Q);E=Q+20|0;P=k[E>>2]|0;I=K+16|0;J=k[I>>2]|0;U=P>>>0>J>>>0?J:P;if((U|0)!=0?(P=K+12|0,J=Q+16|0,wr(k[P>>2]|0,k[J>>2]|0,U|0)|0,k[P>>2]=(k[P>>2]|0)+U,k[J>>2]=(k[J>>2]|0)+U,P=K+20|0,k[P>>2]=(k[P>>2]|0)+U,k[I>>2]=(k[I>>2]|0)-U,I=k[E>>2]|0,k[E>>2]=I-U,(I|0)==(U|0)):0)k[J>>2]=k[Q+8>>2];if(!(k[(k[a>>2]|0)+16>>2]|0)){F=0;G=55;break}}if((G|0)==38){if(k[y>>2]|0){T=i[(k[h>>2]|0)+((k[g>>2]|0)+-1)>>0]|0;S=k[u>>2]|0;j[(k[v>>2]|0)+(S<<1)>>1]=0;k[u>>2]=S+1;i[(k[w>>2]|0)+S>>0]=T;S=a+148+((T&255)<<2)|0;j[S>>1]=(j[S>>1]|0)+1<<16>>16;k[y>>2]=0}y=k[g>>2]|0;k[a+5812>>2]=y>>>0<2?y:2;if((b|0)==4){b=k[z>>2]|0;if((b|0)>-1)V=(k[h>>2]|0)+b|0;else V=0;Pj(a,V,y-b|0,1);k[z>>2]=k[g>>2];b=k[a>>2]|0;V=k[b+28>>2]|0;Nj(V);S=V+20|0;T=k[S>>2]|0;w=b+16|0;v=k[w>>2]|0;q=T>>>0>v>>>0?v:T;if((q|0)!=0?(T=b+12|0,v=V+16|0,wr(k[T>>2]|0,k[v>>2]|0,q|0)|0,k[T>>2]=(k[T>>2]|0)+q,k[v>>2]=(k[v>>2]|0)+q,T=b+20|0,k[T>>2]=(k[T>>2]|0)+q,k[w>>2]=(k[w>>2]|0)-q,w=k[S>>2]|0,k[S>>2]=w-q,(w|0)==(q|0)):0)k[v>>2]=k[V+8>>2];F=(k[(k[a>>2]|0)+16>>2]|0)==0?2:3;return F|0}if(k[u>>2]|0){u=k[z>>2]|0;if((u|0)>-1)W=(k[h>>2]|0)+u|0;else W=0;Pj(a,W,y-u|0,0);k[z>>2]=k[g>>2];g=k[a>>2]|0;z=k[g+28>>2]|0;Nj(z);u=z+20|0;y=k[u>>2]|0;W=g+16|0;h=k[W>>2]|0;V=y>>>0>h>>>0?h:y;if((V|0)!=0?(y=g+12|0,h=z+16|0,wr(k[y>>2]|0,k[h>>2]|0,V|0)|0,k[y>>2]=(k[y>>2]|0)+V,k[h>>2]=(k[h>>2]|0)+V,y=g+20|0,k[y>>2]=(k[y>>2]|0)+V,k[W>>2]=(k[W>>2]|0)-V,W=k[u>>2]|0,k[u>>2]=W-V,(W|0)==(V|0)):0)k[h>>2]=k[z+8>>2];if(!(k[(k[a>>2]|0)+16>>2]|0)){F=0;return F|0}}F=1;return F|0}else if((G|0)==55)return F|0;return 0}function Dj(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,j=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;c=k[a+124>>2]|0;d=k[a+56>>2]|0;e=k[a+108>>2]|0;f=d+e|0;g=k[a+120>>2]|0;h=k[a+144>>2]|0;j=(k[a+44>>2]|0)+-262|0;l=e>>>0>j>>>0?e-j|0:0;j=k[a+64>>2]|0;n=k[a+52>>2]|0;o=d+(e+258)|0;p=k[a+116>>2]|0;q=h>>>0>p>>>0?p:h;h=a+112|0;r=d+(e+1)|0;s=d+(e+2)|0;t=o;u=e+257|0;v=b;b=g;w=g>>>0<(k[a+140>>2]|0)>>>0?c:c>>>2;c=i[d+(g+e)>>0]|0;a=i[d+(e+-1+g)>>0]|0;while(1){g=d+v|0;if((((i[d+(v+b)>>0]|0)==c<<24>>24?(i[d+(b+-1+v)>>0]|0)==a<<24>>24:0)?(i[g>>0]|0)==(i[f>>0]|0):0)?(i[d+(v+1)>>0]|0)==(i[r>>0]|0):0){g=d+(v+2)|0;x=s;while(1){y=x+1|0;if((i[y>>0]|0)!=(i[g+1>>0]|0)){z=y;break}y=x+2|0;if((i[y>>0]|0)!=(i[g+2>>0]|0)){z=y;break}y=x+3|0;if((i[y>>0]|0)!=(i[g+3>>0]|0)){z=y;break}y=x+4|0;if((i[y>>0]|0)!=(i[g+4>>0]|0)){z=y;break}y=x+5|0;if((i[y>>0]|0)!=(i[g+5>>0]|0)){z=y;break}y=x+6|0;if((i[y>>0]|0)!=(i[g+6>>0]|0)){z=y;break}y=x+7|0;if((i[y>>0]|0)!=(i[g+7>>0]|0)){z=y;break}y=x+8|0;g=g+8|0;if(!(y>>>0<o>>>0?(i[y>>0]|0)==(i[g>>0]|0):0)){z=y;break}else x=y}x=z-t|0;g=x+258|0;if((g|0)>(b|0)){k[h>>2]=v;if((g|0)>=(q|0)){A=g;B=20;break}C=g;D=i[d+(g+e)>>0]|0;E=i[d+(u+x)>>0]|0}else{C=b;D=c;E=a}}else{C=b;D=c;E=a}v=m[j+((v&n)<<1)>>1]|0;if(v>>>0<=l>>>0){A=C;B=20;break}w=w+-1|0;if(!w){A=C;B=20;break}else{b=C;c=D;a=E}}if((B|0)==20)return (A>>>0>p>>>0?p:A)|0;return 0}function Ej(a){a=a|0;var b=0,c=0,d=0;if(!a){b=-2;return b|0}c=k[a+28>>2]|0;if(!c){b=-2;return b|0}k[c+40>>2]=0;k[c+44>>2]=0;k[c+48>>2]=0;k[c+28>>2]=0;k[a+20>>2]=0;k[a+8>>2]=0;k[a+24>>2]=0;d=k[c+8>>2]|0;if(d)k[a+48>>2]=d&1;k[c>>2]=0;k[c+4>>2]=0;k[c+12>>2]=0;k[c+20>>2]=32768;k[c+32>>2]=0;k[c+56>>2]=0;k[c+60>>2]=0;d=c+1328|0;k[c+108>>2]=d;k[c+80>>2]=d;k[c+76>>2]=d;k[c+7104>>2]=1;k[c+7108>>2]=-1;b=0;return b|0}function Fj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;if(!b){d=-6;return d|0}if((c|0)!=56|(i[b>>0]|0)!=49){d=-6;return d|0}if(!a){d=-2;return d|0}b=a+24|0;k[b>>2]=0;c=a+32|0;e=k[c>>2]|0;if(!e){k[c>>2]=29;k[a+40>>2]=0;f=29}else f=e;e=a+36|0;if(!(k[e>>2]|0))k[e>>2]=6;e=nb[f&63](k[a+40>>2]|0,1,7116)|0;if(!e){d=-4;return d|0}k[a+28>>2]=e;k[e+52>>2]=0;k[e+8>>2]=1;k[e+36>>2]=15;k[e+40>>2]=0;k[e+44>>2]=0;k[e+48>>2]=0;k[e+28>>2]=0;k[a+20>>2]=0;k[a+8>>2]=0;k[b>>2]=0;k[a+48>>2]=1;k[e>>2]=0;k[e+4>>2]=0;k[e+12>>2]=0;k[e+20>>2]=32768;k[e+32>>2]=0;k[e+56>>2]=0;k[e+60>>2]=0;a=e+1328|0;k[e+108>>2]=a;k[e+80>>2]=a;k[e+76>>2]=a;k[e+7104>>2]=1;k[e+7108>>2]=-1;d=0;return d|0}function Gj(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0,Xb=0,Yb=0,Zb=0,_b=0,$b=0,ac=0,bc=0,cc=0,dc=0,ec=0,fc=0,gc=0,hc=0,ic=0,jc=0,kc=0,lc=0,mc=0,nc=0,oc=0,pc=0,qc=0,rc=0,sc=0,tc=0,uc=0,vc=0,wc=0,xc=0,yc=0,zc=0,Ac=0,Bc=0,Cc=0,Dc=0,Ec=0,Fc=0,Gc=0,Hc=0,Ic=0,Jc=0,Kc=0,Lc=0,Mc=0,Nc=0,Oc=0,Pc=0,Qc=0,Rc=0,Sc=0,Tc=0,Uc=0,Vc=0,Wc=0,Xc=0,Yc=0,Zc=0,_c=0,$c=0,ad=0,bd=0,cd=0,dd=0,ed=0,fd=0,gd=0,hd=0,id=0,jd=0,kd=0,ld=0,md=0,nd=0,od=0,pd=0,qd=0,rd=0,sd=0,td=0,ud=0,vd=0,wd=0,xd=0,yd=0,zd=0,Ad=0,Bd=0,Cd=0,Dd=0,Ed=0,Fd=0,Gd=0,Hd=0,Id=0,Jd=0,Kd=0,Ld=0,Md=0,Nd=0,Od=0,Pd=0,Qd=0,Rd=0,Sd=0,Td=0,Ud=0,Vd=0,Wd=0,Xd=0,Yd=0,Zd=0,_d=0,$d=0,ae=0,be=0,ce=0,de=0,ee=0,fe=0,ge=0,he=0,ie=0,je=0,ke=0,le=0,me=0,ne=0,oe=0,pe=0,qe=0,re=0,se=0,te=0,ue=0,ve=0,we=0,xe=0,ye=0,ze=0,Ae=0,Be=0,Ce=0,De=0,Ee=0,Fe=0,Ge=0,He=0,Ie=0,Je=0,Ke=0,Le=0,Me=0,Ne=0,Oe=0,Pe=0,Qe=0,Re=0,Se=0,Te=0,Ue=0,Ve=0,We=0,Xe=0,Ye=0,Ze=0,_e=0,$e=0,af=0,bf=0,cf=0,df=0,ef=0,ff=0,gf=0,hf=0,jf=0,kf=0,lf=0,mf=0,nf=0,of=0,pf=0,qf=0,rf=0,sf=0,tf=0,uf=0,vf=0,wf=0,xf=0,yf=0,zf=0,Af=0,Bf=0,Cf=0,Df=0,Ef=0,Ff=0,Gf=0,Hf=0,If=0,Jf=0,Kf=0,Lf=0,Mf=0,Nf=0,Of=0,Pf=0,Qf=0,Rf=0,Sf=0,Tf=0,Uf=0,Vf=0,Wf=0,Xf=0,Yf=0,Zf=0,_f=0,$f=0,ag=0,bg=0,cg=0,dg=0,eg=0,fg=0,gg=0,hg=0,ig=0,jg=0,kg=0,lg=0,mg=0,ng=0,og=0,pg=0,qg=0,rg=0,sg=0,tg=0,ug=0,vg=0,wg=0,xg=0,yg=0,zg=0,Ag=0,Bg=0,Cg=0,Dg=0,Eg=0,Fg=0,Gg=0,Hg=0,Ig=0,Jg=0,Kg=0,Lg=0,Mg=0,Ng=0,Og=0,Pg=0,Qg=0,Rg=0,Sg=0,Tg=0,Ug=0,Vg=0,Wg=0,Xg=0,Yg=0,Zg=0;c=r;r=r+16|0;d=c;if(!a){e=-2;r=c;return e|0}f=k[a+28>>2]|0;if(!f){e=-2;r=c;return e|0}g=a+12|0;h=k[g>>2]|0;if(!h){e=-2;r=c;return e|0}n=k[a>>2]|0;if((n|0)==0?(k[a+4>>2]|0)!=0:0){e=-2;r=c;return e|0}o=k[f>>2]|0;if((o|0)==11){k[f>>2]=12;p=12}else p=o;o=a+16|0;q=k[o>>2]|0;s=a+4|0;t=k[s>>2]|0;u=f+56|0;v=f+60|0;w=f+8|0;x=f+24|0;y=d+1|0;z=f+16|0;A=f+32|0;B=a+24|0;C=f+36|0;D=f+20|0;E=a+48|0;F=f+64|0;G=f+12|0;H=(b+-5|0)>>>0<2;I=f+4|0;J=f+76|0;K=f+84|0;L=f+80|0;M=f+88|0;N=(b|0)==6;O=f+7108|0;P=f+72|0;Q=f+7112|0;R=f+68|0;S=f+44|0;T=f+7104|0;U=f+48|0;V=f+52|0;W=f+40|0;X=a+20|0;Y=f+28|0;Z=d+2|0;_=d+3|0;$=f+104|0;aa=f+96|0;ba=f+100|0;ca=f+624|0;da=f+1328|0;ea=f+108|0;fa=f+112|0;ga=f+752|0;ha=f+92|0;ia=h;h=p;p=k[v>>2]|0;ja=t;ka=k[u>>2]|0;la=q;ma=n;n=q;q=0;a:while(1){b:do switch(h|0){case 28:{na=ia;oa=la;pa=p;qa=ja;ra=ka;sa=ma;ta=n;ua=1;break a;break}case 29:{va=ia;wa=p;xa=ja;ya=ka;za=la;Aa=ma;Ba=n;Ca=281;break a;break}case 30:{e=-4;Ca=296;break a;break}case 0:{Da=k[w>>2]|0;if(!Da){k[f>>2]=12;Ea=p;Fa=ja;Ga=ka;Ha=la;Ia=ma;Ja=n;Ka=ia;La=q;break b}if(p>>>0<16){Ma=p;Na=ja;Oa=ka;Pa=ma;while(1){if(!Na){na=ia;oa=la;pa=Ma;qa=0;ra=Oa;sa=Pa;ta=n;ua=q;break a}Qa=Na+-1|0;Ra=Pa+1|0;Sa=(l[Pa>>0]<<Ma)+Oa|0;Ta=Ma+8|0;if(Ta>>>0<16){Ma=Ta;Na=Qa;Oa=Sa;Pa=Ra}else{Ua=Ta;Va=Qa;Wa=Sa;Xa=Ra;break}}}else{Ua=p;Va=ja;Wa=ka;Xa=ma}if((Wa|0)==35615&(Da&2|0)!=0){Pa=Xj(0,0,0)|0;k[x>>2]=Pa;i[d>>0]=31;i[y>>0]=-117;Pa=Xj(k[x>>2]|0,d,2)|0;k[x>>2]=Pa;k[f>>2]=1;Ea=0;Fa=Va;Ga=0;Ha=la;Ia=Xa;Ja=n;Ka=ia;La=q;break b}k[z>>2]=0;Pa=k[A>>2]|0;if(Pa)k[Pa+48>>2]=-1;if((Da&1|0)!=0?((((Wa<<8&65280)+(Wa>>>8)|0)>>>0)%31|0|0)==0:0){if((Wa&15|0)!=8){k[B>>2]=154515;k[f>>2]=29;Ea=Ua;Fa=Va;Ga=Wa;Ha=la;Ia=Xa;Ja=n;Ka=ia;La=q;break b}Pa=Wa>>>4;Oa=Ua+-4|0;Na=(Pa&15)+8|0;Ma=k[C>>2]|0;if(Ma){if(Na>>>0>Ma>>>0){k[B>>2]=154542;k[f>>2]=29;Ea=Oa;Fa=Va;Ga=Pa;Ha=la;Ia=Xa;Ja=n;Ka=ia;La=q;break b}}else k[C>>2]=Na;k[D>>2]=1<<Na;Na=Wj(0,0,0)|0;k[x>>2]=Na;k[E>>2]=Na;k[f>>2]=Wa>>>12&2^11;Ea=0;Fa=Va;Ga=0;Ha=la;Ia=Xa;Ja=n;Ka=ia;La=q;break b}k[B>>2]=154492;k[f>>2]=29;Ea=Ua;Fa=Va;Ga=Wa;Ha=la;Ia=Xa;Ja=n;Ka=ia;La=q;break}case 1:{if(p>>>0<16){Na=p;Pa=ja;Oa=ka;Ma=ma;while(1){if(!Pa){na=ia;oa=la;pa=Na;qa=0;ra=Oa;sa=Ma;ta=n;ua=q;break a}Ra=Pa+-1|0;Sa=Ma+1|0;Qa=(l[Ma>>0]<<Na)+Oa|0;Ta=Na+8|0;if(Ta>>>0<16){Na=Ta;Pa=Ra;Oa=Qa;Ma=Sa}else{Ya=Qa;Za=Ta;_a=Ra;$a=Sa;break}}}else{Ya=ka;Za=p;_a=ja;$a=ma}k[z>>2]=Ya;if((Ya&255|0)!=8){k[B>>2]=154515;k[f>>2]=29;Ea=Za;Fa=_a;Ga=Ya;Ha=la;Ia=$a;Ja=n;Ka=ia;La=q;break b}if(Ya&57344){k[B>>2]=154562;k[f>>2]=29;Ea=Za;Fa=_a;Ga=Ya;Ha=la;Ia=$a;Ja=n;Ka=ia;La=q;break b}Ma=k[A>>2]|0;if(Ma)k[Ma>>2]=Ya>>>8&1;if(Ya&512){i[d>>0]=Ya;i[y>>0]=Ya>>>8;Ma=Xj(k[x>>2]|0,d,2)|0;k[x>>2]=Ma}k[f>>2]=2;ab=0;bb=_a;cb=0;db=$a;Ca=47;break}case 2:{if(p>>>0<32){ab=p;bb=ja;cb=ka;db=ma;Ca=47}else{eb=ja;fb=ka;gb=ma;Ca=49}break}case 3:{if(p>>>0<16){hb=p;ib=ja;jb=ka;kb=ma;Ca=55}else{lb=ja;mb=ka;nb=ma;Ca=57}break}case 4:{ob=p;pb=ja;qb=ka;rb=ma;Ca=62;break}case 5:{sb=p;tb=ja;ub=ka;vb=ma;Ca=73;break}case 6:{wb=p;xb=ja;yb=ka;zb=ma;Ca=83;break}case 7:{Ab=p;Bb=ja;Cb=ka;Db=ma;Ca=96;break}case 8:{Eb=p;Fb=ja;Gb=ka;Hb=ma;Ca=109;break}case 9:{if(p>>>0<32){Ma=p;Oa=ja;Pa=ka;Na=ma;while(1){if(!Oa){na=ia;oa=la;pa=Ma;qa=0;ra=Pa;sa=Na;ta=n;ua=q;break a}Da=Oa+-1|0;Sa=Na+1|0;Ra=(l[Na>>0]<<Ma)+Pa|0;Ma=Ma+8|0;if(Ma>>>0>=32){Ib=Da;Jb=Ra;Kb=Sa;break}else{Oa=Da;Pa=Ra;Na=Sa}}}else{Ib=ja;Jb=ka;Kb=ma}Na=xr(Jb|0)|0;k[x>>2]=Na;k[E>>2]=Na;k[f>>2]=10;Lb=0;Mb=Ib;Nb=0;Ob=Kb;Ca=121;break}case 10:{Lb=p;Mb=ja;Nb=ka;Ob=ma;Ca=121;break}case 11:{Pb=p;Qb=ja;Rb=ka;Sb=ma;Ca=124;break}case 12:{Tb=p;Ub=ja;Vb=ka;Wb=ma;Ca=125;break}case 13:{Na=p&7;Pa=ka>>>Na;Oa=p-Na|0;if(Oa>>>0<32){Na=Oa;Ma=ja;Sa=Pa;Ra=ma;while(1){if(!Ma){na=ia;oa=la;pa=Na;qa=0;ra=Sa;sa=Ra;ta=n;ua=q;break a}Da=Ma+-1|0;Ta=Ra+1|0;Qa=(l[Ra>>0]<<Na)+Sa|0;Xb=Na+8|0;if(Xb>>>0<32){Na=Xb;Ma=Da;Sa=Qa;Ra=Ta}else{Yb=Xb;Zb=Da;_b=Qa;$b=Ta;break}}}else{Yb=Oa;Zb=ja;_b=Pa;$b=ma}Ra=_b&65535;if((Ra|0)==(_b>>>16^65535|0)){k[F>>2]=Ra;k[f>>2]=14;if(N){na=ia;oa=la;pa=0;qa=Zb;ra=0;sa=$b;ta=n;ua=q;break a}else{ac=0;bc=Zb;cc=0;dc=$b;Ca=143;break b}}else{k[B>>2]=154626;k[f>>2]=29;Ea=Yb;Fa=Zb;Ga=_b;Ha=la;Ia=$b;Ja=n;Ka=ia;La=q;break b}break}case 14:{ac=p;bc=ja;cc=ka;dc=ma;Ca=143;break}case 15:{ec=p;fc=ja;gc=ka;hc=ma;Ca=144;break}case 16:{if(p>>>0<14){Ra=p;Sa=ja;Ma=ka;Na=ma;while(1){if(!Sa){na=ia;oa=la;pa=Ra;qa=0;ra=Ma;sa=Na;ta=n;ua=q;break a}Ta=Sa+-1|0;Qa=Na+1|0;Da=(l[Na>>0]<<Ra)+Ma|0;Xb=Ra+8|0;if(Xb>>>0<14){Ra=Xb;Sa=Ta;Ma=Da;Na=Qa}else{ic=Xb;jc=Ta;kc=Da;lc=Qa;break}}}else{ic=p;jc=ja;kc=ka;lc=ma}Na=(kc&31)+257|0;k[aa>>2]=Na;Ma=(kc>>>5&31)+1|0;k[ba>>2]=Ma;Sa=(kc>>>10&15)+4|0;k[ha>>2]=Sa;Ra=kc>>>14;Pa=ic+-14|0;if(Na>>>0>286|Ma>>>0>30){k[B>>2]=154655;k[f>>2]=29;Ea=Pa;Fa=jc;Ga=Ra;Ha=la;Ia=lc;Ja=n;Ka=ia;La=q;break b}else{k[$>>2]=0;k[f>>2]=17;mc=Sa;nc=0;oc=Pa;pc=jc;qc=Ra;rc=lc;Ca=154;break b}break}case 17:{Ra=k[$>>2]|0;Pa=k[ha>>2]|0;if(Ra>>>0<Pa>>>0){mc=Pa;nc=Ra;oc=p;pc=ja;qc=ka;rc=ma;Ca=154}else{sc=Ra;tc=p;uc=ja;vc=ka;wc=ma;Ca=155}break}case 18:{xc=k[$>>2]|0;yc=p;zc=ja;Ac=ka;Bc=ma;Cc=q;Ca=165;break}case 19:{Dc=p;Ec=ja;Fc=ka;Gc=ma;Hc=q;Ca=199;break}case 20:{Ic=p;Jc=ja;Kc=ka;Lc=ma;Mc=q;Ca=200;break}case 21:{Nc=k[P>>2]|0;Oc=p;Pc=ja;Qc=ka;Rc=ma;Sc=q;Ca=218;break}case 22:{Tc=p;Uc=ja;Vc=ka;Wc=ma;Xc=q;Ca=225;break}case 23:{Yc=k[P>>2]|0;Zc=p;_c=ja;$c=ka;ad=ma;bd=q;Ca=237;break}case 24:{cd=p;dd=ja;ed=ka;fd=ma;gd=q;Ca=243;break}case 25:{if(!la){na=ia;oa=0;pa=p;qa=ja;ra=ka;sa=ma;ta=n;ua=q;break a}i[ia>>0]=k[F>>2];k[f>>2]=20;Ea=p;Fa=ja;Ga=ka;Ha=la+-1|0;Ia=ma;Ja=n;Ka=ia+1|0;La=q;break}case 26:{if(k[w>>2]|0){if(p>>>0<32){Ra=p;Pa=ja;Sa=ka;Ma=ma;while(1){if(!Pa){na=ia;oa=la;pa=Ra;qa=0;ra=Sa;sa=Ma;ta=n;ua=q;break a}Na=Pa+-1|0;Oa=Ma+1|0;Qa=(l[Ma>>0]<<Ra)+Sa|0;Da=Ra+8|0;if(Da>>>0<32){Ra=Da;Pa=Na;Sa=Qa;Ma=Oa}else{hd=Da;id=Na;jd=Qa;kd=Oa;break}}}else{hd=p;id=ja;jd=ka;kd=ma}Ma=n-la|0;k[X>>2]=(k[X>>2]|0)+Ma;k[Y>>2]=(k[Y>>2]|0)+Ma;if((n|0)==(la|0))ld=k[x>>2]|0;else{Sa=k[x>>2]|0;Pa=ia+(0-Ma)|0;if(!(k[z>>2]|0))md=Wj(Sa,Pa,Ma)|0;else md=Xj(Sa,Pa,Ma)|0;k[x>>2]=md;k[E>>2]=md;ld=md}Ma=(k[z>>2]|0)==0;Pa=xr(jd|0)|0;if(((Ma?Pa:jd)|0)==(ld|0)){nd=0;od=id;pd=0;qd=kd;rd=la}else{k[B>>2]=154829;k[f>>2]=29;Ea=hd;Fa=id;Ga=jd;Ha=la;Ia=kd;Ja=la;Ka=ia;La=q;break b}}else{nd=p;od=ja;pd=ka;qd=ma;rd=n}k[f>>2]=27;sd=nd;td=od;ud=pd;vd=qd;wd=rd;Ca=273;break}case 27:{sd=p;td=ja;ud=ka;vd=ma;wd=n;Ca=273;break}default:{Ca=295;break a}}while(0);if((Ca|0)==47)while(1){Ca=0;if(!bb){na=ia;oa=la;pa=ab;qa=0;ra=cb;sa=db;ta=n;ua=q;break a}Pa=bb+-1|0;Ma=db+1|0;Sa=(l[db>>0]<<ab)+cb|0;ab=ab+8|0;if(ab>>>0>=32){eb=Pa;fb=Sa;gb=Ma;Ca=49;break}else{bb=Pa;cb=Sa;db=Ma;Ca=47}}else if((Ca|0)==121){Ca=0;if(!(k[G>>2]|0)){xd=ia;yd=Lb;zd=Mb;Ad=Nb;Bd=la;Cd=Ob;Ca=122;break}Ma=Wj(0,0,0)|0;k[x>>2]=Ma;k[E>>2]=Ma;k[f>>2]=11;Pb=Lb;Qb=Mb;Rb=Nb;Sb=Ob;Ca=124}else if((Ca|0)==143){Ca=0;k[f>>2]=15;ec=ac;fc=bc;gc=cc;hc=dc;Ca=144}else if((Ca|0)==154){Ca=0;Ma=nc;Sa=oc;Pa=pc;Ra=qc;Oa=rc;while(1){if(Sa>>>0<3){Qa=Sa;Na=Pa;Da=Ra;Ta=Oa;while(1){if(!Na){na=ia;oa=la;pa=Qa;qa=0;ra=Da;sa=Ta;ta=n;ua=q;break a}Xb=Na+-1|0;Dd=Ta+1|0;Ed=(l[Ta>>0]<<Qa)+Da|0;Fd=Qa+8|0;if(Fd>>>0<3){Qa=Fd;Na=Xb;Da=Ed;Ta=Dd}else{Gd=Fd;Hd=Xb;Id=Ed;Jd=Dd;break}}}else{Gd=Sa;Hd=Pa;Id=Ra;Jd=Oa}Ta=Ma+1|0;k[$>>2]=Ta;j[f+112+(m[127246+(Ma<<1)>>1]<<1)>>1]=Id&7;Da=Id>>>3;Na=Gd+-3|0;if(Ta>>>0<mc>>>0){Ma=Ta;Sa=Na;Pa=Hd;Ra=Da;Oa=Jd}else{sc=Ta;tc=Na;uc=Hd;vc=Da;wc=Jd;Ca=155;break}}}else if((Ca|0)==273){Ca=0;if(!(k[w>>2]|0)){Kd=ia;Ld=sd;Md=td;Nd=ud;Od=la;Pd=vd;Qd=wd;Ca=280;break}if(!(k[z>>2]|0)){Kd=ia;Ld=sd;Md=td;Nd=ud;Od=la;Pd=vd;Qd=wd;Ca=280;break}if(sd>>>0<32){Oa=sd;Ra=td;Pa=ud;Sa=vd;while(1){if(!Ra){na=ia;oa=la;pa=Oa;qa=0;ra=Pa;sa=Sa;ta=wd;ua=q;break a}Ma=Ra+-1|0;Da=Sa+1|0;Na=(l[Sa>>0]<<Oa)+Pa|0;Ta=Oa+8|0;if(Ta>>>0<32){Oa=Ta;Ra=Ma;Pa=Na;Sa=Da}else{Rd=Ta;Sd=Ma;Td=Na;Ud=Da;break}}}else{Rd=sd;Sd=td;Td=ud;Ud=vd}if((Td|0)==(k[Y>>2]|0)){Kd=ia;Ld=0;Md=Sd;Nd=0;Od=la;Pd=Ud;Qd=wd;Ca=280;break}k[B>>2]=154850;k[f>>2]=29;Ea=Rd;Fa=Sd;Ga=Td;Ha=la;Ia=Ud;Ja=wd;Ka=ia;La=q}do if((Ca|0)==49){Ca=0;Sa=k[A>>2]|0;if(Sa)k[Sa+4>>2]=fb;if(k[z>>2]&512){i[d>>0]=fb;i[y>>0]=fb>>>8;i[Z>>0]=fb>>>16;i[_>>0]=fb>>>24;Sa=Xj(k[x>>2]|0,d,4)|0;k[x>>2]=Sa}k[f>>2]=3;hb=0;ib=eb;jb=0;kb=gb;Ca=55}else if((Ca|0)==124){Ca=0;if(H){na=ia;oa=la;pa=Pb;qa=Qb;ra=Rb;sa=Sb;ta=n;ua=q;break a}else{Tb=Pb;Ub=Qb;Vb=Rb;Wb=Sb;Ca=125}}else if((Ca|0)==144){Ca=0;Sa=k[F>>2]|0;if(!Sa){k[f>>2]=11;Ea=ec;Fa=fc;Ga=gc;Ha=la;Ia=hc;Ja=n;Ka=ia;La=q;break}Pa=Sa>>>0>fc>>>0?fc:Sa;Sa=Pa>>>0>la>>>0?la:Pa;if(!Sa){na=ia;oa=la;pa=ec;qa=fc;ra=gc;sa=hc;ta=n;ua=q;break a}wr(ia|0,hc|0,Sa|0)|0;k[F>>2]=(k[F>>2]|0)-Sa;Ea=ec;Fa=fc-Sa|0;Ga=gc;Ha=la-Sa|0;Ia=hc+Sa|0;Ja=n;Ka=ia+Sa|0;La=q}else if((Ca|0)==155){Ca=0;if(sc>>>0<19){Sa=sc;do{j[f+112+(m[127246+(Sa<<1)>>1]<<1)>>1]=0;Sa=Sa+1|0}while((Sa|0)!=19);k[$>>2]=19}k[ea>>2]=da;k[J>>2]=da;k[K>>2]=7;Sa=Kj(0,fa,19,ea,K,ga)|0;if(!Sa){k[$>>2]=0;k[f>>2]=18;xc=0;yc=tc;zc=uc;Ac=vc;Bc=wc;Cc=0;Ca=165;break}else{k[B>>2]=154691;k[f>>2]=29;Ea=tc;Fa=uc;Ga=vc;Ha=la;Ia=wc;Ja=n;Ka=ia;La=Sa;break}}while(0);c:do if((Ca|0)==55)while(1){Ca=0;if(!ib){na=ia;oa=la;pa=hb;qa=0;ra=jb;sa=kb;ta=n;ua=q;break a}Sa=ib+-1|0;Pa=kb+1|0;Ra=(l[kb>>0]<<hb)+jb|0;hb=hb+8|0;if(hb>>>0>=16){lb=Sa;mb=Ra;nb=Pa;Ca=57;break}else{ib=Sa;jb=Ra;kb=Pa;Ca=55}}else if((Ca|0)==125){Ca=0;if(k[I>>2]|0){Pa=Tb&7;k[f>>2]=26;Ea=Tb-Pa|0;Fa=Ub;Ga=Vb>>>Pa;Ha=la;Ia=Wb;Ja=n;Ka=ia;La=q;break}if(Tb>>>0<3){Pa=Tb;Ra=Ub;Sa=Vb;Oa=Wb;while(1){if(!Ra){na=ia;oa=la;pa=Pa;qa=0;ra=Sa;sa=Oa;ta=n;ua=q;break a}Da=Ra+-1|0;Na=Oa+1|0;Ma=(l[Oa>>0]<<Pa)+Sa|0;Ta=Pa+8|0;if(Ta>>>0<3){Pa=Ta;Ra=Da;Sa=Ma;Oa=Na}else{Vd=Ta;Wd=Da;Xd=Ma;Yd=Na;break}}}else{Vd=Tb;Wd=Ub;Xd=Vb;Yd=Wb}k[I>>2]=Xd&1;switch(Xd>>>1&3|0){case 0:{k[f>>2]=13;break}case 1:{k[J>>2]=125070;k[K>>2]=9;k[L>>2]=127118;k[M>>2]=5;k[f>>2]=19;if(N){Zd=ia;_d=Vd;$d=Wd;ae=Xd;be=la;ce=Yd;de=n;ee=q;Ca=133;break a}break}case 2:{k[f>>2]=16;break}case 3:{k[B>>2]=154607;k[f>>2]=29;break}default:{}}Ea=Vd+-3|0;Fa=Wd;Ga=Xd>>>3;Ha=la;Ia=Yd;Ja=n;Ka=ia;La=q}else if((Ca|0)==165){Ca=0;Oa=k[aa>>2]|0;Sa=k[ba>>2]|0;do if(xc>>>0<(Sa+Oa|0)>>>0){Ra=xc;Pa=Sa;Na=Oa;Ma=yc;Da=zc;Ta=Ac;Qa=Bc;d:while(1){Dd=(1<<k[K>>2])+-1|0;Ed=Dd&Ta;Xb=k[J>>2]|0;Fd=l[Xb+(Ed<<2)+1>>0]|0;if(Ma>>>0<Fd>>>0){fe=Ma;ge=Da;he=Ta;ie=Qa;while(1){if(!ge){na=ia;oa=la;pa=fe;qa=0;ra=he;sa=ie;ta=n;ua=Cc;break a}je=ge+-1|0;ke=ie+1|0;le=(l[ie>>0]<<fe)+he|0;me=fe+8|0;ne=Dd&le;oe=l[Xb+(ne<<2)+1>>0]|0;if(me>>>0<oe>>>0){fe=me;ge=je;he=le;ie=ke}else{pe=oe;qe=ne;re=me;se=je;te=le;ue=ke;break}}}else{pe=Fd;qe=Ed;re=Ma;se=Da;te=Ta;ue=Qa}ie=j[Xb+(qe<<2)+2>>1]|0;if((ie&65535)>=16){switch(ie<<16>>16){case 16:{he=pe+2|0;if(re>>>0<he>>>0){ge=re;fe=se;Dd=te;ke=ue;while(1){if(!fe){na=ia;oa=la;pa=ge;qa=0;ra=Dd;sa=ke;ta=n;ua=Cc;break a}le=fe+-1|0;je=ke+1|0;me=(l[ke>>0]<<ge)+Dd|0;ne=ge+8|0;if(ne>>>0<he>>>0){ge=ne;fe=le;Dd=me;ke=je}else{ve=ne;we=le;xe=me;ye=je;break}}}else{ve=re;we=se;xe=te;ye=ue}ke=xe>>>pe;Dd=ve-pe|0;if(!Ra){ze=ke;Ae=Dd;Be=we;Ce=ye;Ca=179;break d}De=Dd+-2|0;Ee=(ke&3)+3|0;Fe=we;Ge=ke>>>2;He=m[f+112+(Ra+-1<<1)>>1]|0;Ie=ye;break}case 17:{ke=pe+3|0;if(re>>>0<ke>>>0){Dd=re;fe=se;ge=te;he=ue;while(1){if(!fe){na=ia;oa=la;pa=Dd;qa=0;ra=ge;sa=he;ta=n;ua=Cc;break a}Xb=fe+-1|0;Ed=he+1|0;Fd=(l[he>>0]<<Dd)+ge|0;je=Dd+8|0;if(je>>>0<ke>>>0){Dd=je;fe=Xb;ge=Fd;he=Ed}else{Je=je;Ke=Xb;Le=Fd;Me=Ed;break}}}else{Je=re;Ke=se;Le=te;Me=ue}he=Le>>>pe;De=-3-pe+Je|0;Ee=(he&7)+3|0;Fe=Ke;Ge=he>>>3;He=0;Ie=Me;break}default:{he=pe+7|0;if(re>>>0<he>>>0){ge=re;fe=se;Dd=te;ke=ue;while(1){if(!fe){na=ia;oa=la;pa=ge;qa=0;ra=Dd;sa=ke;ta=n;ua=Cc;break a}Ed=fe+-1|0;Fd=ke+1|0;Xb=(l[ke>>0]<<ge)+Dd|0;je=ge+8|0;if(je>>>0<he>>>0){ge=je;fe=Ed;Dd=Xb;ke=Fd}else{Ne=je;Oe=Ed;Pe=Xb;Qe=Fd;break}}}else{Ne=re;Oe=se;Pe=te;Qe=ue}ke=Pe>>>pe;De=-7-pe+Ne|0;Ee=(ke&127)+11|0;Fe=Oe;Ge=ke>>>7;He=0;Ie=Qe}}if((Ra+Ee|0)>>>0>(Pa+Na|0)>>>0){Re=De;Se=Fe;Te=Ge;Ue=Ie;Ca=189;break}ke=He&65535;Dd=Ee+-1|0;k[$>>2]=Ra+1;j[f+112+(Ra<<1)>>1]=ke;if(!Dd){Ve=De;We=Fe;Xe=Ge;Ye=Ie}else{fe=Dd;do{Dd=k[$>>2]|0;fe=fe+-1|0;k[$>>2]=Dd+1;j[f+112+(Dd<<1)>>1]=ke}while((fe|0)!=0);Ve=De;We=Fe;Xe=Ge;Ye=Ie}}else{k[$>>2]=Ra+1;j[f+112+(Ra<<1)>>1]=ie;Ve=re-pe|0;We=se;Xe=te>>>pe;Ye=ue}Ra=k[$>>2]|0;fe=k[aa>>2]|0;Pa=k[ba>>2]|0;if(Ra>>>0>=(Pa+fe|0)>>>0){Ze=fe;_e=Ve;$e=We;af=Xe;bf=Ye;Ca=191;break}else{Na=fe;Ma=Ve;Da=We;Ta=Xe;Qa=Ye}}if((Ca|0)==179){Ca=0;k[B>>2]=154716;k[f>>2]=29;Ea=Ae;Fa=Be;Ga=ze;Ha=la;Ia=Ce;Ja=n;Ka=ia;La=Cc;break c}else if((Ca|0)==189){Ca=0;k[B>>2]=154716;k[f>>2]=29;Ea=Re;Fa=Se;Ga=Te;Ha=la;Ia=Ue;Ja=n;Ka=ia;La=Cc;break c}else if((Ca|0)==191){Ca=0;if((k[f>>2]|0)==29){Ea=_e;Fa=$e;Ga=af;Ha=la;Ia=bf;Ja=n;Ka=ia;La=Cc;break c}else{cf=Ze;df=_e;ef=$e;ff=af;gf=bf;break}}}else{cf=Oa;df=yc;ef=zc;ff=Ac;gf=Bc}while(0);if(!(j[ca>>1]|0)){k[B>>2]=154742;k[f>>2]=29;Ea=df;Fa=ef;Ga=ff;Ha=la;Ia=gf;Ja=n;Ka=ia;La=Cc;break}k[ea>>2]=da;k[J>>2]=da;k[K>>2]=9;Oa=Kj(1,fa,cf,ea,K,ga)|0;if(Oa){k[B>>2]=154779;k[f>>2]=29;Ea=df;Fa=ef;Ga=ff;Ha=la;Ia=gf;Ja=n;Ka=ia;La=Oa;break}k[L>>2]=k[ea>>2];k[M>>2]=6;Oa=Kj(2,f+112+(k[aa>>2]<<1)|0,k[ba>>2]|0,ea,M,ga)|0;if(!Oa){k[f>>2]=19;if(N){na=ia;oa=la;pa=df;qa=ef;ra=ff;sa=gf;ta=n;ua=0;break a}else{Dc=df;Ec=ef;Fc=ff;Gc=gf;Hc=0;Ca=199;break}}else{k[B>>2]=154807;k[f>>2]=29;Ea=df;Fa=ef;Ga=ff;Ha=la;Ia=gf;Ja=n;Ka=ia;La=Oa;break}}while(0);if((Ca|0)==57){Ca=0;Oa=k[A>>2]|0;if(Oa){k[Oa+8>>2]=mb&255;k[Oa+12>>2]=mb>>>8}if(k[z>>2]&512){i[d>>0]=mb;i[y>>0]=mb>>>8;Oa=Xj(k[x>>2]|0,d,2)|0;k[x>>2]=Oa}k[f>>2]=4;ob=0;pb=lb;qb=0;rb=nb;Ca=62}else if((Ca|0)==199){Ca=0;k[f>>2]=20;Ic=Dc;Jc=Ec;Kc=Fc;Lc=Gc;Mc=Hc;Ca=200}do if((Ca|0)==62){Ca=0;Oa=k[z>>2]|0;if(!(Oa&1024)){Sa=k[A>>2]|0;if(!Sa){hf=ob;jf=pb;kf=qb;lf=rb}else{k[Sa+16>>2]=0;hf=ob;jf=pb;kf=qb;lf=rb}}else{if(ob>>>0<16){Sa=ob;Qa=pb;Ta=qb;Da=rb;while(1){if(!Qa){na=ia;oa=la;pa=Sa;qa=0;ra=Ta;sa=Da;ta=n;ua=q;break a}Ma=Qa+-1|0;Na=Da+1|0;Pa=(l[Da>>0]<<Sa)+Ta|0;Sa=Sa+8|0;if(Sa>>>0>=16){mf=Ma;nf=Pa;of=Na;break}else{Qa=Ma;Ta=Pa;Da=Na}}}else{mf=pb;nf=qb;of=rb}k[F>>2]=nf;Da=k[A>>2]|0;if(Da)k[Da+20>>2]=nf;if(!(Oa&512)){hf=0;jf=mf;kf=0;lf=of}else{i[d>>0]=nf;i[y>>0]=nf>>>8;Da=Xj(k[x>>2]|0,d,2)|0;k[x>>2]=Da;hf=0;jf=mf;kf=0;lf=of}}k[f>>2]=5;sb=hf;tb=jf;ub=kf;vb=lf;Ca=73}else if((Ca|0)==200){Ca=0;if(la>>>0>257&Jc>>>0>5){k[g>>2]=ia;k[o>>2]=la;k[a>>2]=Lc;k[s>>2]=Jc;k[u>>2]=Kc;k[v>>2]=Ic;Yj(a,n);Da=k[g>>2]|0;Ta=k[o>>2]|0;Qa=k[a>>2]|0;Sa=k[s>>2]|0;Na=k[u>>2]|0;Pa=k[v>>2]|0;if((k[f>>2]|0)!=11){Ea=Pa;Fa=Sa;Ga=Na;Ha=Ta;Ia=Qa;Ja=n;Ka=Da;La=Mc;break}k[O>>2]=-1;Ea=Pa;Fa=Sa;Ga=Na;Ha=Ta;Ia=Qa;Ja=n;Ka=Da;La=Mc;break}k[O>>2]=0;Da=(1<<k[K>>2])+-1|0;Qa=Da&Kc;Ta=k[J>>2]|0;Na=i[Ta+(Qa<<2)+1>>0]|0;Sa=Na&255;if(Sa>>>0>Ic>>>0){Pa=Ic;Ma=Jc;Ra=Kc;fe=Lc;while(1){if(!Ma){na=ia;oa=la;pa=Pa;qa=0;ra=Ra;sa=fe;ta=n;ua=Mc;break a}ke=Ma+-1|0;Dd=fe+1|0;ge=(l[fe>>0]<<Pa)+Ra|0;he=Pa+8|0;Fd=Da&ge;Xb=i[Ta+(Fd<<2)+1>>0]|0;Ed=Xb&255;if(Ed>>>0>he>>>0){Pa=he;Ma=ke;Ra=ge;fe=Dd}else{pf=Xb;qf=Ed;rf=Fd;sf=he;tf=ke;uf=ge;vf=Dd;break}}}else{pf=Na;qf=Sa;rf=Qa;sf=Ic;tf=Jc;uf=Kc;vf=Lc}fe=i[Ta+(rf<<2)>>0]|0;Ra=j[Ta+(rf<<2)+2>>1]|0;Ma=fe&255;if(fe<<24>>24!=0&(Ma&240|0)==0){Pa=Ra&65535;Da=(1<<qf+Ma)+-1|0;Ma=((uf&Da)>>>qf)+Pa|0;Oa=i[Ta+(Ma<<2)+1>>0]|0;if(((Oa&255)+qf|0)>>>0>sf>>>0){Dd=sf;ge=tf;ke=uf;he=vf;while(1){if(!ge){na=ia;oa=la;pa=Dd;qa=0;ra=ke;sa=he;ta=n;ua=Mc;break a}Fd=ge+-1|0;Ed=he+1|0;Xb=(l[he>>0]<<Dd)+ke|0;je=Dd+8|0;me=((Xb&Da)>>>qf)+Pa|0;le=i[Ta+(me<<2)+1>>0]|0;if(((le&255)+qf|0)>>>0>je>>>0){Dd=je;ge=Fd;ke=Xb;he=Ed}else{wf=me;xf=le;yf=je;zf=Fd;Af=Xb;Bf=Ed;break}}}else{wf=Ma;xf=Oa;yf=sf;zf=tf;Af=uf;Bf=vf}he=j[Ta+(wf<<2)+2>>1]|0;ke=i[Ta+(wf<<2)>>0]|0;k[O>>2]=qf;Cf=qf;Df=yf-qf|0;Ef=zf;Ff=ke;Gf=xf;Hf=he;If=Af>>>qf;Jf=Bf}else{Cf=0;Df=sf;Ef=tf;Ff=fe;Gf=pf;Hf=Ra;If=uf;Jf=vf}he=Gf&255;ke=If>>>he;ge=Df-he|0;k[O>>2]=Cf+he;k[F>>2]=Hf&65535;he=Ff&255;if(!(Ff<<24>>24)){k[f>>2]=25;Ea=ge;Fa=Ef;Ga=ke;Ha=la;Ia=Jf;Ja=n;Ka=ia;La=Mc;break}if(he&32){k[O>>2]=-1;k[f>>2]=11;Ea=ge;Fa=Ef;Ga=ke;Ha=la;Ia=Jf;Ja=n;Ka=ia;La=Mc;break}if(!(he&64)){Dd=he&15;k[P>>2]=Dd;k[f>>2]=21;Nc=Dd;Oc=ge;Pc=Ef;Qc=ke;Rc=Jf;Sc=Mc;Ca=218;break}else{k[B>>2]=155829;k[f>>2]=29;Ea=ge;Fa=Ef;Ga=ke;Ha=la;Ia=Jf;Ja=n;Ka=ia;La=Mc;break}}while(0);if((Ca|0)==73){Ca=0;ke=k[z>>2]|0;if(ke&1024){ge=k[F>>2]|0;Dd=ge>>>0>tb>>>0?tb:ge;if(!Dd){Kf=ge;Lf=tb;Mf=vb}else{he=k[A>>2]|0;if((he|0)!=0?(Pa=k[he+16>>2]|0,(Pa|0)!=0):0){Da=(k[he+20>>2]|0)-ge|0;ge=k[he+24>>2]|0;wr(Pa+Da|0,vb|0,((Da+Dd|0)>>>0>ge>>>0?ge-Da|0:Dd)|0)|0;Nf=k[z>>2]|0}else Nf=ke;if(Nf&512){ke=Xj(k[x>>2]|0,vb,Dd)|0;k[x>>2]=ke}ke=(k[F>>2]|0)-Dd|0;k[F>>2]=ke;Kf=ke;Lf=tb-Dd|0;Mf=vb+Dd|0}if(!Kf){Of=Lf;Pf=Mf}else{na=ia;oa=la;pa=sb;qa=Lf;ra=ub;sa=Mf;ta=n;ua=q;break}}else{Of=tb;Pf=vb}k[F>>2]=0;k[f>>2]=6;wb=sb;xb=Of;yb=ub;zb=Pf;Ca=83}else if((Ca|0)==218){Ca=0;if(!Nc){Qf=k[F>>2]|0;Rf=Oc;Sf=Pc;Tf=Qc;Uf=Rc}else{if(Oc>>>0<Nc>>>0){Dd=Oc;ke=Pc;Da=Qc;ge=Rc;while(1){if(!ke){na=ia;oa=la;pa=Dd;qa=0;ra=Da;sa=ge;ta=n;ua=Sc;break a}Pa=ke+-1|0;he=ge+1|0;Qa=(l[ge>>0]<<Dd)+Da|0;Sa=Dd+8|0;if(Sa>>>0<Nc>>>0){Dd=Sa;ke=Pa;Da=Qa;ge=he}else{Vf=Sa;Wf=Pa;Xf=Qa;Yf=he;break}}}else{Vf=Oc;Wf=Pc;Xf=Qc;Yf=Rc}ge=(k[F>>2]|0)+((1<<Nc)+-1&Xf)|0;k[F>>2]=ge;k[O>>2]=(k[O>>2]|0)+Nc;Qf=ge;Rf=Vf-Nc|0;Sf=Wf;Tf=Xf>>>Nc;Uf=Yf}k[Q>>2]=Qf;k[f>>2]=22;Tc=Rf;Uc=Sf;Vc=Tf;Wc=Uf;Xc=Sc;Ca=225}do if((Ca|0)==83){Ca=0;if(!(k[z>>2]&2048)){ge=k[A>>2]|0;if(!ge){Zf=xb;_f=zb}else{k[ge+28>>2]=0;Zf=xb;_f=zb}}else{if(!xb){na=ia;oa=la;pa=wb;qa=0;ra=yb;sa=zb;ta=n;ua=q;break a}else $f=0;while(1){ge=$f+1|0;Da=i[zb+$f>>0]|0;ke=k[A>>2]|0;if(((ke|0)!=0?(Dd=k[ke+28>>2]|0,(Dd|0)!=0):0)?(he=k[F>>2]|0,he>>>0<(k[ke+32>>2]|0)>>>0):0){k[F>>2]=he+1;i[Dd+he>>0]=Da}he=Da<<24>>24!=0;if(he&xb>>>0>ge>>>0)$f=ge;else{ag=ge;bg=he;break}}if(k[z>>2]&512){Ra=Xj(k[x>>2]|0,zb,ag)|0;k[x>>2]=Ra}Ra=xb-ag|0;fe=zb+ag|0;if(bg){na=ia;oa=la;pa=wb;qa=Ra;ra=yb;sa=fe;ta=n;ua=q;break a}else{Zf=Ra;_f=fe}}k[F>>2]=0;k[f>>2]=7;Ab=wb;Bb=Zf;Cb=yb;Db=_f;Ca=96}else if((Ca|0)==225){Ca=0;fe=(1<<k[M>>2])+-1|0;Ra=fe&Vc;Ta=k[L>>2]|0;Oa=i[Ta+(Ra<<2)+1>>0]|0;Ma=Oa&255;if(Ma>>>0>Tc>>>0){he=Tc;ge=Uc;Da=Vc;Dd=Wc;while(1){if(!ge){na=ia;oa=la;pa=he;qa=0;ra=Da;sa=Dd;ta=n;ua=Xc;break a}ke=ge+-1|0;Qa=Dd+1|0;Pa=(l[Dd>>0]<<he)+Da|0;Sa=he+8|0;Na=fe&Pa;Ed=i[Ta+(Na<<2)+1>>0]|0;Xb=Ed&255;if(Xb>>>0>Sa>>>0){he=Sa;ge=ke;Da=Pa;Dd=Qa}else{cg=Ed;dg=Xb;eg=Na;fg=Sa;gg=ke;hg=Pa;ig=Qa;break}}}else{cg=Oa;dg=Ma;eg=Ra;fg=Tc;gg=Uc;hg=Vc;ig=Wc}Dd=i[Ta+(eg<<2)>>0]|0;Da=j[Ta+(eg<<2)+2>>1]|0;ge=Dd&255;if(!(ge&240)){he=Da&65535;fe=(1<<dg+ge)+-1|0;ge=((hg&fe)>>>dg)+he|0;Qa=i[Ta+(ge<<2)+1>>0]|0;if(((Qa&255)+dg|0)>>>0>fg>>>0){Pa=fg;ke=gg;Sa=hg;Na=ig;while(1){if(!ke){na=ia;oa=la;pa=Pa;qa=0;ra=Sa;sa=Na;ta=n;ua=Xc;break a}Xb=ke+-1|0;Ed=Na+1|0;Fd=(l[Na>>0]<<Pa)+Sa|0;je=Pa+8|0;le=((Fd&fe)>>>dg)+he|0;me=i[Ta+(le<<2)+1>>0]|0;if(((me&255)+dg|0)>>>0>je>>>0){Pa=je;ke=Xb;Sa=Fd;Na=Ed}else{jg=le;kg=me;lg=je;mg=Xb;ng=Fd;og=Ed;break}}}else{jg=ge;kg=Qa;lg=fg;mg=gg;ng=hg;og=ig}Na=j[Ta+(jg<<2)+2>>1]|0;Sa=i[Ta+(jg<<2)>>0]|0;ke=(k[O>>2]|0)+dg|0;k[O>>2]=ke;pg=ke;qg=lg-dg|0;rg=mg;sg=Sa;tg=kg;ug=Na;vg=ng>>>dg;wg=og}else{pg=k[O>>2]|0;qg=fg;rg=gg;sg=Dd;tg=cg;ug=Da;vg=hg;wg=ig}Na=tg&255;Sa=vg>>>Na;ke=qg-Na|0;k[O>>2]=pg+Na;Na=sg&255;if(!(Na&64)){k[R>>2]=ug&65535;Pa=Na&15;k[P>>2]=Pa;k[f>>2]=23;Yc=Pa;Zc=ke;_c=rg;$c=Sa;ad=wg;bd=Xc;Ca=237;break}else{k[B>>2]=155807;k[f>>2]=29;Ea=ke;Fa=rg;Ga=Sa;Ha=la;Ia=wg;Ja=n;Ka=ia;La=Xc;break}}while(0);if((Ca|0)==96){Ca=0;if(!(k[z>>2]&4096)){Sa=k[A>>2]|0;if(!Sa){xg=Bb;yg=Db}else{k[Sa+36>>2]=0;xg=Bb;yg=Db}}else{if(!Bb){na=ia;oa=la;pa=Ab;qa=0;ra=Cb;sa=Db;ta=n;ua=q;break}else zg=0;while(1){Sa=zg+1|0;ke=i[Db+zg>>0]|0;Pa=k[A>>2]|0;if(((Pa|0)!=0?(Na=k[Pa+36>>2]|0,(Na|0)!=0):0)?(he=k[F>>2]|0,he>>>0<(k[Pa+40>>2]|0)>>>0):0){k[F>>2]=he+1;i[Na+he>>0]=ke}he=ke<<24>>24!=0;if(he&Bb>>>0>Sa>>>0)zg=Sa;else{Ag=Sa;Bg=he;break}}if(k[z>>2]&512){he=Xj(k[x>>2]|0,Db,Ag)|0;k[x>>2]=he}he=Bb-Ag|0;Sa=Db+Ag|0;if(Bg){na=ia;oa=la;pa=Ab;qa=he;ra=Cb;sa=Sa;ta=n;ua=q;break}else{xg=he;yg=Sa}}k[f>>2]=8;Eb=Ab;Fb=xg;Gb=Cb;Hb=yg;Ca=109}else if((Ca|0)==237){Ca=0;if(!Yc){Cg=Zc;Dg=_c;Eg=$c;Fg=ad}else{if(Zc>>>0<Yc>>>0){Sa=Zc;he=_c;ke=$c;Na=ad;while(1){if(!he){na=ia;oa=la;pa=Sa;qa=0;ra=ke;sa=Na;ta=n;ua=bd;break a}Pa=he+-1|0;fe=Na+1|0;Ra=(l[Na>>0]<<Sa)+ke|0;Ma=Sa+8|0;if(Ma>>>0<Yc>>>0){Sa=Ma;he=Pa;ke=Ra;Na=fe}else{Gg=Ma;Hg=Pa;Ig=Ra;Jg=fe;break}}}else{Gg=Zc;Hg=_c;Ig=$c;Jg=ad}k[R>>2]=(k[R>>2]|0)+((1<<Yc)+-1&Ig);k[O>>2]=(k[O>>2]|0)+Yc;Cg=Gg-Yc|0;Dg=Hg;Eg=Ig>>>Yc;Fg=Jg}k[f>>2]=24;cd=Cg;dd=Dg;ed=Eg;fd=Fg;gd=bd;Ca=243}do if((Ca|0)==109){Ca=0;Na=k[z>>2]|0;if(Na&512){if(Eb>>>0<16){ke=Eb;he=Fb;Sa=Gb;fe=Hb;while(1){if(!he){na=ia;oa=la;pa=ke;qa=0;ra=Sa;sa=fe;ta=n;ua=q;break a}Ra=he+-1|0;Pa=fe+1|0;Ma=(l[fe>>0]<<ke)+Sa|0;Oa=ke+8|0;if(Oa>>>0<16){ke=Oa;he=Ra;Sa=Ma;fe=Pa}else{Kg=Oa;Lg=Ra;Mg=Ma;Ng=Pa;break}}}else{Kg=Eb;Lg=Fb;Mg=Gb;Ng=Hb}if((Mg|0)==(k[x>>2]&65535|0)){Og=0;Pg=Lg;Qg=0;Rg=Ng}else{k[B>>2]=154587;k[f>>2]=29;Ea=Kg;Fa=Lg;Ga=Mg;Ha=la;Ia=Ng;Ja=n;Ka=ia;La=q;break}}else{Og=Eb;Pg=Fb;Qg=Gb;Rg=Hb}fe=k[A>>2]|0;if(fe){k[fe+44>>2]=Na>>>9&1;k[fe+48>>2]=1}fe=Xj(0,0,0)|0;k[x>>2]=fe;k[E>>2]=fe;k[f>>2]=11;Ea=Og;Fa=Pg;Ga=Qg;Ha=la;Ia=Rg;Ja=n;Ka=ia;La=q}else if((Ca|0)==243){Ca=0;if(!la){na=ia;oa=0;pa=cd;qa=dd;ra=ed;sa=fd;ta=n;ua=gd;break a}fe=n-la|0;Sa=k[R>>2]|0;if(Sa>>>0>fe>>>0){he=Sa-fe|0;if(he>>>0>(k[S>>2]|0)>>>0?(k[T>>2]|0)!=0:0){k[B>>2]=155777;k[f>>2]=29;Ea=cd;Fa=dd;Ga=ed;Ha=la;Ia=fd;Ja=n;Ka=ia;La=gd;break}fe=k[U>>2]|0;if(he>>>0>fe>>>0){ke=he-fe|0;Sg=ke;Tg=(k[V>>2]|0)+((k[W>>2]|0)-ke)|0}else{Sg=he;Tg=(k[V>>2]|0)+(fe-he)|0}he=k[F>>2]|0;Ug=he;Vg=Sg>>>0>he>>>0?he:Sg;Wg=Tg}else{he=k[F>>2]|0;Ug=he;Vg=he;Wg=ia+(0-Sa)|0}Sa=Vg>>>0>la>>>0?la:Vg;k[F>>2]=Ug-Sa;he=Vg>>>0>la>>>0?la:Vg;fe=Sa;ke=Wg;Da=ia;while(1){i[Da>>0]=i[ke>>0]|0;fe=fe+-1|0;if(!fe)break;else{ke=ke+1|0;Da=Da+1|0}}Da=la-Sa|0;ke=ia+he|0;if(!(k[F>>2]|0)){k[f>>2]=20;Ea=cd;Fa=dd;Ga=ed;Ha=Da;Ia=fd;Ja=n;Ka=ke;La=gd}else{Ea=cd;Fa=dd;Ga=ed;Ha=Da;Ia=fd;Ja=n;Ka=ke;La=gd}}while(0);ia=Ka;h=k[f>>2]|0;p=Ea;ja=Fa;ka=Ga;la=Ha;ma=Ia;n=Ja;q=La}if((Ca|0)==122){k[g>>2]=xd;k[o>>2]=Bd;k[a>>2]=Cd;k[s>>2]=zd;k[u>>2]=Ad;k[v>>2]=yd;e=2;r=c;return e|0}else if((Ca|0)==133){na=Zd;oa=be;pa=_d+-3|0;qa=$d;ra=ae>>>3;sa=ce;ta=de;ua=ee}else if((Ca|0)==280){k[f>>2]=28;na=Kd;oa=Od;pa=Ld;qa=Md;ra=Nd;sa=Pd;ta=Qd;ua=1}else if((Ca|0)==281){na=va;oa=za;pa=wa;qa=xa;ra=ya;sa=Aa;ta=Ba;ua=-3}else if((Ca|0)==295){e=-2;r=c;return e|0}else if((Ca|0)==296){r=c;return e|0}k[g>>2]=na;k[o>>2]=oa;k[a>>2]=sa;k[s>>2]=qa;k[u>>2]=ra;k[v>>2]=pa;if(!(k[W>>2]|0))if(((ta|0)!=(oa|0)?(W=k[f>>2]|0,W>>>0<29):0)?(b|0)!=4|W>>>0<26:0)Ca=286;else{Xg=qa;Yg=oa}else Ca=286;do if((Ca|0)==286){if(!(Jj(a,na,ta-oa|0)|0)){Xg=k[s>>2]|0;Yg=k[o>>2]|0;break}k[f>>2]=30;e=-4;r=c;return e|0}while(0);o=ta-Yg|0;s=a+8|0;k[s>>2]=t-Xg+(k[s>>2]|0);k[X>>2]=(k[X>>2]|0)+o;k[Y>>2]=(k[Y>>2]|0)+o;if((ta|0)!=(Yg|0)&(k[w>>2]|0)!=0){w=k[x>>2]|0;Y=(k[g>>2]|0)+(0-o)|0;if(!(k[z>>2]|0))Zg=Wj(w,Y,o)|0;else Zg=Xj(w,Y,o)|0;k[x>>2]=Zg;k[E>>2]=Zg}Zg=k[f>>2]|0;k[a+44>>2]=((k[I>>2]|0)!=0?64:0)+(k[v>>2]|0)+((Zg|0)==11?128:0)+((Zg|0)==19|(Zg|0)==14?256:0);e=(ua|0)==0&((b|0)==4|(t|0)==(Xg|0)&(ta|0)==(Yg|0))?-5:ua;r=c;return e|0}function Hj(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;if(!a){b=-2;return b|0}c=a+28|0;d=k[c>>2]|0;if(!d){b=-2;return b|0}e=a+36|0;f=k[e>>2]|0;if(!f){b=-2;return b|0}g=k[d+52>>2]|0;h=a+40|0;if(!g){i=f;j=d}else{rb[f&31](k[h>>2]|0,g);i=k[e>>2]|0;j=k[c>>2]|0}rb[i&31](k[h>>2]|0,j);k[c>>2]=0;b=0;return b|0}function Ij(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;b=r;r=r+16|0;c=b;if(!a){d=-2;r=b;return d|0}e=k[a+28>>2]|0;if(!e){d=-2;r=b;return d|0}f=a+4|0;g=k[f>>2]|0;if((g|0)==0?(k[e+60>>2]|0)>>>0<8:0){d=-5;r=b;return d|0}if((k[e>>2]|0)==31){h=e+104|0;j=h;l=g;m=k[h>>2]|0}else{k[e>>2]=31;h=e+60|0;g=k[h>>2]|0;n=e+56|0;o=k[n>>2]<<(g&7);k[n>>2]=o;p=g&-8;k[h>>2]=p;if(p>>>0>7){g=7-p|0;q=(p+(g>>>0>4294967288?g:-8)|0)>>>3;g=q<<3;s=q+1|0;q=o;o=0;while(1){i[c+o>>0]=q;o=o+1|0;t=q>>>8;if((o|0)==(s|0)){u=t;break}else q=t}k[n>>2]=u;k[h>>2]=p+-8-g;g=e+104|0;k[g>>2]=0;p=0;h=0;while(1){u=i[c+h>>0]|0;if((u&255|0)==((p>>>0<2?0:255)|0))v=p+1|0;else v=u<<24>>24==0?4-p|0:0;h=h+1|0;if(!(h>>>0<s>>>0&v>>>0<4)){w=g;x=v;break}else p=v}}else{v=e+104|0;k[v>>2]=0;w=v;x=0}k[w>>2]=x;j=w;l=k[f>>2]|0;m=x}x=k[a>>2]|0;if((l|0)!=0&m>>>0<4){w=m;v=0;while(1){p=i[x+v>>0]|0;if((p&255|0)==((w>>>0<2?0:255)|0))y=w+1|0;else y=p<<24>>24==0?4-w|0:0;p=v+1|0;if(p>>>0<l>>>0&y>>>0<4){w=y;v=p}else{z=y;A=p;break}}}else{z=m;A=0}k[j>>2]=z;k[f>>2]=(k[f>>2]|0)-A;k[a>>2]=x+A;x=a+8|0;f=(k[x>>2]|0)+A|0;k[x>>2]=f;if((z|0)!=4){d=-3;r=b;return d|0}z=a+20|0;A=k[z>>2]|0;k[e+40>>2]=0;k[e+44>>2]=0;k[e+48>>2]=0;k[e+28>>2]=0;k[z>>2]=0;k[x>>2]=0;k[a+24>>2]=0;j=k[e+8>>2]|0;if(j)k[a+48>>2]=j&1;k[e+4>>2]=0;k[e+12>>2]=0;k[e+20>>2]=32768;k[e+32>>2]=0;k[e+56>>2]=0;k[e+60>>2]=0;j=e+1328|0;k[e+108>>2]=j;k[e+80>>2]=j;k[e+76>>2]=j;k[e+7104>>2]=1;k[e+7108>>2]=-1;k[x>>2]=f;k[z>>2]=A;k[e>>2]=11;d=0;r=b;return d|0}function Jj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0;d=k[a+28>>2]|0;e=d+52|0;f=k[e>>2]|0;if(!f){g=nb[k[a+32>>2]&63](k[a+40>>2]|0,1<<k[d+36>>2],1)|0;k[e>>2]=g;if(!g){h=1;return h|0}else i=g}else i=f;f=d+40|0;g=k[f>>2]|0;if(!g){a=1<<k[d+36>>2];k[f>>2]=a;k[d+48>>2]=0;k[d+44>>2]=0;j=a}else j=g;if(j>>>0<=c>>>0){wr(i|0,b+(0-j)|0,j|0)|0;k[d+48>>2]=0;k[d+44>>2]=k[f>>2];h=0;return h|0}g=d+48|0;a=k[g>>2]|0;l=j-a|0;j=l>>>0>c>>>0?c:l;wr(i+a|0,b+(0-c)|0,j|0)|0;a=c-j|0;if((j|0)!=(c|0)){wr(k[e>>2]|0,b+(0-a)|0,a|0)|0;k[g>>2]=a;k[d+44>>2]=k[f>>2];h=0;return h|0}a=(k[g>>2]|0)+c|0;b=k[f>>2]|0;k[g>>2]=(a|0)==(b|0)?0:a;a=d+44|0;d=k[a>>2]|0;if(d>>>0>=b>>>0){h=0;return h|0}k[a>>2]=d+c;h=0;return h|0}function Kj(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,l=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0;g=r;r=r+64|0;h=g+32|0;l=g;n=h;o=n+32|0;do{j[n>>1]=0;n=n+2|0}while((n|0)<(o|0));n=(c|0)==0;if(!n){o=0;do{p=h+(m[b+(o<<1)>>1]<<1)|0;j[p>>1]=(j[p>>1]|0)+1<<16>>16;o=o+1|0}while((o|0)!=(c|0));o=j[h+30>>1]|0;p=k[e>>2]|0;if(!(o<<16>>16)){q=p;s=5}else{t=p;u=o;v=15;s=6}}else{q=k[e>>2]|0;s=5}do if((s|0)==5)if(!(j[h+28>>1]|0))if(!(j[h+26>>1]|0))if(!(j[h+24>>1]|0))if(!(j[h+22>>1]|0))if(!(j[h+20>>1]|0))if(!(j[h+18>>1]|0))if(!(j[h+16>>1]|0))if(!(j[h+14>>1]|0))if(!(j[h+12>>1]|0))if(!(j[h+10>>1]|0))if(!(j[h+8>>1]|0))if(!(j[h+6>>1]|0))if(!(j[h+4>>1]|0)){if(j[h+2>>1]|0){w=0;x=q>>>0>1?1:q;y=1;z=1;break}o=k[d>>2]|0;k[d>>2]=o+4;i[o>>0]=64;i[o+1>>0]=1;j[o+2>>1]=0;o=k[d>>2]|0;k[d>>2]=o+4;i[o>>0]=64;i[o+1>>0]=1;j[o+2>>1]=0;k[e>>2]=1;A=0;r=g;return A|0}else{t=q;u=0;v=2;s=6}else{t=q;u=0;v=3;s=6}else{t=q;u=0;v=4;s=6}else{t=q;u=0;v=5;s=6}else{t=q;u=0;v=6;s=6}else{t=q;u=0;v=7;s=6}else{t=q;u=0;v=8;s=6}else{t=q;u=0;v=9;s=6}else{t=q;u=0;v=10;s=6}else{t=q;u=0;v=11;s=6}else{t=q;u=0;v=12;s=6}else{t=q;u=0;v=13;s=6}else{t=q;u=0;v=14;s=6}while(0);a:do if((s|0)==6){q=t>>>0>v>>>0?v:t;o=1;while(1){if(j[h+(o<<1)>>1]|0){w=u;x=q;y=v;z=o;break a}p=o+1|0;if(p>>>0<v>>>0)o=p;else{w=u;x=q;y=v;z=p;break}}}while(0);v=x>>>0<z>>>0?z:x;x=j[h+2>>1]|0;u=2-(x&65535)|0;if((u|0)<0){A=-1;r=g;return A|0}t=(u<<1)-(m[h+4>>1]|0)|0;if((t|0)<0){A=-1;r=g;return A|0}u=(t<<1)-(m[h+6>>1]|0)|0;if((u|0)<0){A=-1;r=g;return A|0}t=(u<<1)-(m[h+8>>1]|0)|0;if((t|0)<0){A=-1;r=g;return A|0}u=(t<<1)-(m[h+10>>1]|0)|0;if((u|0)<0){A=-1;r=g;return A|0}t=(u<<1)-(m[h+12>>1]|0)|0;if((t|0)<0){A=-1;r=g;return A|0}u=(t<<1)-(m[h+14>>1]|0)|0;if((u|0)<0){A=-1;r=g;return A|0}t=(u<<1)-(m[h+16>>1]|0)|0;if((t|0)<0){A=-1;r=g;return A|0}u=(t<<1)-(m[h+18>>1]|0)|0;if((u|0)<0){A=-1;r=g;return A|0}t=(u<<1)-(m[h+20>>1]|0)|0;if((t|0)<0){A=-1;r=g;return A|0}u=(t<<1)-(m[h+22>>1]|0)|0;if((u|0)<0){A=-1;r=g;return A|0}t=(u<<1)-(m[h+24>>1]|0)|0;if((t|0)<0){A=-1;r=g;return A|0}u=(t<<1)-(m[h+26>>1]|0)|0;if((u|0)<0){A=-1;r=g;return A|0}t=(u<<1)-(m[h+28>>1]|0)|0;if((t|0)<0){A=-1;r=g;return A|0}u=(t<<1)-(w&65535)|0;if((u|0)<0){A=-1;r=g;return A|0}if((u|0)>0?(a|0)==0|(y|0)!=1:0){A=-1;r=g;return A|0}j[l+2>>1]=0;j[l+4>>1]=x;u=(m[h+4>>1]|0)+(x&65535)|0;j[l+6>>1]=u;x=(m[h+6>>1]|0)+(u&65535)|0;j[l+8>>1]=x;u=(m[h+8>>1]|0)+(x&65535)|0;j[l+10>>1]=u;x=(m[h+10>>1]|0)+(u&65535)|0;j[l+12>>1]=x;u=(m[h+12>>1]|0)+(x&65535)|0;j[l+14>>1]=u;x=(m[h+14>>1]|0)+(u&65535)|0;j[l+16>>1]=x;u=(m[h+16>>1]|0)+(x&65535)|0;j[l+18>>1]=u;x=(m[h+18>>1]|0)+(u&65535)|0;j[l+20>>1]=x;u=(m[h+20>>1]|0)+(x&65535)|0;j[l+22>>1]=u;x=(m[h+22>>1]|0)+(u&65535)|0;j[l+24>>1]=x;u=(m[h+24>>1]|0)+(x&65535)|0;j[l+26>>1]=u;x=(m[h+26>>1]|0)+(u&65535)|0;j[l+28>>1]=x;j[l+30>>1]=(m[h+28>>1]|0)+(x&65535);if(!n){n=0;do{x=j[b+(n<<1)>>1]|0;if(x<<16>>16){u=l+((x&65535)<<1)|0;x=j[u>>1]|0;j[u>>1]=x+1<<16>>16;j[f+((x&65535)<<1)>>1]=n}n=n+1|0}while((n|0)!=(c|0))}switch(a|0){case 0:{B=0;C=0;D=f;E=19;F=f;break}case 1:{if(v>>>0>9){A=1;r=g;return A|0}else{B=0;C=1;D=126834;E=256;F=126960}break}default:{c=(a|0)==2;if(c&v>>>0>9){A=1;r=g;return A|0}else{B=c;C=0;D=127284;E=-1;F=127410}}}c=1<<v;a=c+-1|0;n=v&255;l=v;x=0;u=0;w=z;z=-1;t=k[d>>2]|0;q=0;o=c;b:while(1){c=1<<l;p=u;G=w;H=q;while(1){I=G-x|0;J=I&255;K=j[f+(H<<1)>>1]|0;L=K&65535;do if((L|0)<(E|0)){M=0;N=K}else{if((L|0)<=(E|0)){M=96;N=0;break}M=j[F+(L<<1)>>1]&255;N=j[D+(L<<1)>>1]|0}while(0);L=1<<I;K=p>>>x;O=c;do{P=O;O=O-L|0;Q=O+K|0;i[t+(Q<<2)>>0]=M;i[t+(Q<<2)+1>>0]=J;j[t+(Q<<2)+2>>1]=N}while((P|0)!=(L|0));L=1<<G+-1;while(1)if(!(L&p)){R=L;break}else L=L>>>1;if(!R)S=0;else S=(R+-1&p)+R|0;L=H+1|0;K=h+(G<<1)|0;O=(j[K>>1]|0)+-1<<16>>16;j[K>>1]=O;if(!(O<<16>>16)){if((G|0)==(y|0)){T=J;U=S;V=t;W=o;break b}X=m[b+(m[f+(L<<1)>>1]<<1)>>1]|0}else X=G;if(X>>>0<=v>>>0){p=S;G=X;H=L;continue}O=S&a;if((O|0)==(z|0)){p=S;G=X;H=L}else{Y=L;Z=O;_=S;$=X;break}}H=(x|0)==0?v:x;G=t+(c<<2)|0;p=$-H|0;c:do if($>>>0<y>>>0){O=$;L=p;K=1<<p;while(1){I=K-(m[h+(O<<1)>>1]|0)|0;if((I|0)<1){aa=L;break c}P=L+1|0;O=P+H|0;if(O>>>0>=y>>>0){aa=P;break}else{L=P;K=I<<1}}}else aa=p;while(0);p=(1<<aa)+o|0;if(C&p>>>0>852|B&p>>>0>592){A=1;s=44;break}c=k[d>>2]|0;i[c+(Z<<2)>>0]=aa;i[c+(Z<<2)+1>>0]=n;j[c+(Z<<2)+2>>1]=(G-c|0)>>>2;l=aa;x=H;u=_;w=$;z=Z;t=G;q=Y;o=p}if((s|0)==44){r=g;return A|0}if(U){i[V+(U<<2)>>0]=64;i[V+(U<<2)+1>>0]=T;j[V+(U<<2)+2>>1]=0}k[d>>2]=(k[d>>2]|0)+(W<<2);k[e>>2]=v;A=0;r=g;return A|0}function Lj(a){a=a|0;k[a+2840>>2]=a+148;k[a+2848>>2]=110108;k[a+2852>>2]=a+2440;k[a+2860>>2]=110128;k[a+2864>>2]=a+2684;k[a+2872>>2]=110148;j[a+5816>>1]=0;k[a+5820>>2]=0;Qj(a);return}function Mj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;e=a+5820|0;f=k[e>>2]|0;g=d&65535;d=a+5816|0;h=m[d>>1]|0|g<<f;j[d>>1]=h;if((f|0)>13){l=a+20|0;n=k[l>>2]|0;k[l>>2]=n+1;o=a+8|0;i[(k[o>>2]|0)+n>>0]=h;n=(m[d>>1]|0)>>>8&255;p=k[l>>2]|0;k[l>>2]=p+1;i[(k[o>>2]|0)+p>>0]=n;n=k[e>>2]|0;p=g>>>(16-n|0);j[d>>1]=p;q=p;r=n+-13|0}else{q=h;r=f+3|0}f=q&255;k[e>>2]=r;do if((r|0)<=8){q=a+20|0;if((r|0)>0){h=k[q>>2]|0;k[q>>2]=h+1;n=a+8|0;i[(k[n>>2]|0)+h>>0]=f;s=q;t=n;break}else{s=q;t=a+8|0;break}}else{q=a+20|0;n=k[q>>2]|0;k[q>>2]=n+1;h=a+8|0;i[(k[h>>2]|0)+n>>0]=f;n=(m[d>>1]|0)>>>8&255;p=k[q>>2]|0;k[q>>2]=p+1;i[(k[h>>2]|0)+p>>0]=n;s=q;t=h}while(0);j[d>>1]=0;k[e>>2]=0;e=k[s>>2]|0;k[s>>2]=e+1;i[(k[t>>2]|0)+e>>0]=c;e=k[s>>2]|0;k[s>>2]=e+1;i[(k[t>>2]|0)+e>>0]=c>>>8;e=c&65535^65535;d=k[s>>2]|0;k[s>>2]=d+1;i[(k[t>>2]|0)+d>>0]=e;d=k[s>>2]|0;k[s>>2]=d+1;i[(k[t>>2]|0)+d>>0]=e>>>8;if(!c)return;else{u=c;v=b}while(1){u=u+-1|0;b=i[v>>0]|0;c=k[s>>2]|0;k[s>>2]=c+1;i[(k[t>>2]|0)+c>>0]=b;if(!u)break;else v=v+1|0}return}function Nj(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0;b=a+5820|0;c=k[b>>2]|0;if((c|0)==16){d=a+5816|0;e=j[d>>1]&255;f=a+20|0;g=k[f>>2]|0;k[f>>2]=g+1;h=a+8|0;i[(k[h>>2]|0)+g>>0]=e;e=(m[d>>1]|0)>>>8&255;g=k[f>>2]|0;k[f>>2]=g+1;i[(k[h>>2]|0)+g>>0]=e;j[d>>1]=0;k[b>>2]=0;return}if((c|0)<=7)return;c=a+5816|0;d=j[c>>1]&255;e=a+20|0;g=k[e>>2]|0;k[e>>2]=g+1;i[(k[a+8>>2]|0)+g>>0]=d;j[c>>1]=(m[c>>1]|0)>>>8;k[b>>2]=(k[b>>2]|0)+-8;return}function Oj(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,l=0,n=0,o=0,p=0,q=0;b=a+5820|0;c=k[b>>2]|0;d=a+5816|0;e=m[d>>1]|0|2<<c;j[d>>1]=e;if((c|0)>13){f=a+20|0;g=k[f>>2]|0;k[f>>2]=g+1;h=a+8|0;i[(k[h>>2]|0)+g>>0]=e;g=(m[d>>1]|0)>>>8&255;l=k[f>>2]|0;k[f>>2]=l+1;i[(k[h>>2]|0)+l>>0]=g;g=k[b>>2]|0;l=2>>>(16-g|0);j[d>>1]=l;n=l;o=g+-13|0}else{n=e;o=c+3|0}c=n&255;k[b>>2]=o;if((o|0)>9){n=a+20|0;e=k[n>>2]|0;k[n>>2]=e+1;g=a+8|0;i[(k[g>>2]|0)+e>>0]=c;e=(m[d>>1]|0)>>>8&255;l=k[n>>2]|0;k[n>>2]=l+1;i[(k[g>>2]|0)+l>>0]=e;j[d>>1]=0;p=0;q=(k[b>>2]|0)+-9|0}else{p=c;q=o+7|0}k[b>>2]=q;if((q|0)==16){o=a+20|0;c=k[o>>2]|0;k[o>>2]=c+1;e=a+8|0;i[(k[e>>2]|0)+c>>0]=p;c=(m[d>>1]|0)>>>8&255;l=k[o>>2]|0;k[o>>2]=l+1;i[(k[e>>2]|0)+l>>0]=c;j[d>>1]=0;k[b>>2]=0;return}if((q|0)<=7)return;q=a+20|0;c=k[q>>2]|0;k[q>>2]=c+1;i[(k[a+8>>2]|0)+c>>0]=p;j[d>>1]=(m[d>>1]|0)>>>8;k[b>>2]=(k[b>>2]|0)+-8;return}function Pj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0;if((k[a+132>>2]|0)>0){e=(k[a>>2]|0)+44|0;if((k[e>>2]|0)==2){f=-201342849;g=0;while(1){if((f&1|0)!=0?(j[a+148+(g<<2)>>1]|0)!=0:0){h=0;break}g=g+1|0;if((g|0)>=32){n=6;break}else f=f>>>1}a:do if((n|0)==6)if(((j[a+184>>1]|0)==0?(j[a+188>>1]|0)==0:0)?(j[a+200>>1]|0)==0:0){f=32;while(1){if(j[a+148+(f<<2)>>1]|0){h=1;break a}f=f+1|0;if((f|0)>=256){h=0;break}}}else h=1;while(0);k[e>>2]=h}Rj(a,a+2840|0);Rj(a,a+2852|0);h=k[a+2844>>2]|0;e=j[a+150>>1]|0;n=e<<16>>16==0;j[a+148+(h+1<<2)+2>>1]=-1;f=a+2752|0;g=a+2756|0;o=a+2748|0;p=n?138:7;q=n?3:4;n=0;r=e&65535;e=-1;b:while(1){s=0;t=n;while(1){if((t|0)>(h|0))break b;u=t+1|0;v=j[a+148+(u<<2)+2>>1]|0;w=v&65535;x=s+1|0;y=(r|0)==(w|0);if((x|0)<(p|0)&y){s=x;t=u}else{z=u;A=v;B=w;C=x;D=y;break}}do if((C|0)>=(q|0))if(!r)if((C|0)<11){j[f>>1]=(j[f>>1]|0)+1<<16>>16;break}else{j[g>>1]=(j[g>>1]|0)+1<<16>>16;break}else{if((r|0)!=(e|0)){t=a+2684+(r<<2)|0;j[t>>1]=(j[t>>1]|0)+1<<16>>16}j[o>>1]=(j[o>>1]|0)+1<<16>>16;break}else{t=a+2684+(r<<2)|0;j[t>>1]=(m[t>>1]|0)+C}while(0);t=A<<16>>16==0;s=r;p=t?138:D?6:7;q=t|D?3:4;n=z;r=B;e=s}e=k[a+2856>>2]|0;B=j[a+2442>>1]|0;r=B<<16>>16==0;j[a+2440+(e+1<<2)+2>>1]=-1;z=r?138:7;n=r?3:4;r=0;D=B&65535;B=-1;c:while(1){q=0;p=r;while(1){if((p|0)>(e|0))break c;A=p+1|0;C=j[a+2440+(A<<2)+2>>1]|0;h=C&65535;s=q+1|0;t=(D|0)==(h|0);if((s|0)<(z|0)&t){q=s;p=A}else{E=A;F=C;G=h;H=s;I=t;break}}do if((H|0)>=(n|0))if(!D)if((H|0)<11){j[f>>1]=(j[f>>1]|0)+1<<16>>16;break}else{j[g>>1]=(j[g>>1]|0)+1<<16>>16;break}else{if((D|0)!=(B|0)){p=a+2684+(D<<2)|0;j[p>>1]=(j[p>>1]|0)+1<<16>>16}j[o>>1]=(j[o>>1]|0)+1<<16>>16;break}else{p=a+2684+(D<<2)|0;j[p>>1]=(m[p>>1]|0)+H}while(0);p=F<<16>>16==0;q=D;z=p?138:I?6:7;n=p|I?3:4;r=E;D=G;B=q}Rj(a,a+2864|0);if(!(j[a+2746>>1]|0))if(!(j[a+2690>>1]|0))if(!(j[a+2742>>1]|0))if(!(j[a+2694>>1]|0))if(!(j[a+2738>>1]|0))if(!(j[a+2698>>1]|0))if(!(j[a+2734>>1]|0))if(!(j[a+2702>>1]|0))if(!(j[a+2730>>1]|0))if(!(j[a+2706>>1]|0))if(!(j[a+2726>>1]|0))if(!(j[a+2710>>1]|0))if(!(j[a+2722>>1]|0))if(!(j[a+2714>>1]|0))if(!(j[a+2718>>1]|0))J=(j[a+2686>>1]|0)==0?2:3;else J=4;else J=5;else J=6;else J=7;else J=8;else J=9;else J=10;else J=11;else J=12;else J=13;else J=14;else J=15;else J=16;else J=17;else J=18;B=a+5800|0;G=(J*3|0)+17+(k[B>>2]|0)|0;k[B>>2]=G;B=(G+10|0)>>>3;G=((k[a+5804>>2]|0)+10|0)>>>3;K=J;L=G>>>0>B>>>0?B:G;M=G}else{G=c+5|0;K=0;L=G;M=G}do if((b|0)!=0&(c+4|0)>>>0<=L>>>0)Mj(a,b,c,d);else{G=a+5820|0;B=k[G>>2]|0;J=(B|0)>13;if((M|0)==(L|0)?1:(k[a+136>>2]|0)==4){D=d+2&65535;E=a+5816|0;r=m[E>>1]|D<<B;j[E>>1]=r;if(J){I=a+20|0;n=k[I>>2]|0;k[I>>2]=n+1;z=a+8|0;i[(k[z>>2]|0)+n>>0]=r;r=(m[E>>1]|0)>>>8&255;n=k[I>>2]|0;k[I>>2]=n+1;i[(k[z>>2]|0)+n>>0]=r;r=k[G>>2]|0;j[E>>1]=D>>>(16-r|0);N=r+-13|0}else N=B+3|0;k[G>>2]=N;Sj(a,127536,128688);break}r=d+4&65535;D=a+5816|0;E=m[D>>1]|r<<B;j[D>>1]=E;if(J){J=a+20|0;n=k[J>>2]|0;k[J>>2]=n+1;z=a+8|0;i[(k[z>>2]|0)+n>>0]=E;n=(m[D>>1]|0)>>>8&255;I=k[J>>2]|0;k[J>>2]=I+1;i[(k[z>>2]|0)+I>>0]=n;n=k[G>>2]|0;I=r>>>(16-n|0);j[D>>1]=I;O=I;P=n+-13|0}else{O=E;P=B+3|0}k[G>>2]=P;B=k[a+2844>>2]|0;E=k[a+2856>>2]|0;n=B+65280&65535;I=O&65535|n<<P;j[D>>1]=I;if((P|0)>11){r=a+20|0;z=k[r>>2]|0;k[r>>2]=z+1;J=a+8|0;i[(k[J>>2]|0)+z>>0]=I;z=(m[D>>1]|0)>>>8&255;F=k[r>>2]|0;k[r>>2]=F+1;i[(k[J>>2]|0)+F>>0]=z;z=k[G>>2]|0;F=n>>>(16-z|0);j[D>>1]=F;Q=z+-11|0;R=F}else{Q=P+5|0;R=I}k[G>>2]=Q;I=E&65535;F=I<<Q|R&65535;j[D>>1]=F;if((Q|0)>11){z=a+20|0;n=k[z>>2]|0;k[z>>2]=n+1;J=a+8|0;i[(k[J>>2]|0)+n>>0]=F;n=(m[D>>1]|0)>>>8&255;r=k[z>>2]|0;k[z>>2]=r+1;i[(k[J>>2]|0)+r>>0]=n;n=k[G>>2]|0;r=I>>>(16-n|0);j[D>>1]=r;S=n+-11|0;T=r}else{S=Q+5|0;T=F}k[G>>2]=S;F=K+65533&65535;r=F<<S|T&65535;j[D>>1]=r;if((S|0)>12){n=a+20|0;I=k[n>>2]|0;k[n>>2]=I+1;J=a+8|0;i[(k[J>>2]|0)+I>>0]=r;I=(m[D>>1]|0)>>>8&255;z=k[n>>2]|0;k[n>>2]=z+1;i[(k[J>>2]|0)+z>>0]=I;I=k[G>>2]|0;z=F>>>(16-I|0);j[D>>1]=z;U=J;V=n;W=z;X=I+-12|0}else{U=a+8|0;V=a+20|0;W=r;X=S+4|0}k[G>>2]=X;r=X;I=W;z=0;while(1){n=m[a+2684+(l[155641+z>>0]<<2)+2>>1]|0;J=n<<r|I&65535;j[D>>1]=J;if((r|0)>13){F=k[V>>2]|0;k[V>>2]=F+1;i[(k[U>>2]|0)+F>>0]=J;F=(m[D>>1]|0)>>>8&255;H=k[V>>2]|0;k[V>>2]=H+1;i[(k[U>>2]|0)+H>>0]=F;F=k[G>>2]|0;H=n>>>(16-F|0);j[D>>1]=H;Y=H;Z=F+-13|0}else{Y=J;Z=r+3|0}k[G>>2]=Z;if((z|0)==(K|0))break;else{r=Z;I=Y;z=z+1|0}}z=a+148|0;Tj(a,z,B);I=a+2440|0;Tj(a,I,E);Sj(a,z,I)}while(0);Qj(a);if(!d)return;d=a+5820|0;Y=k[d>>2]|0;if((Y|0)<=8){Z=a+5816|0;if((Y|0)>0){Y=j[Z>>1]&255;K=a+20|0;U=k[K>>2]|0;k[K>>2]=U+1;i[(k[a+8>>2]|0)+U>>0]=Y;_=Z}else _=Z}else{Z=a+5816|0;Y=j[Z>>1]&255;U=a+20|0;K=k[U>>2]|0;k[U>>2]=K+1;V=a+8|0;i[(k[V>>2]|0)+K>>0]=Y;Y=(m[Z>>1]|0)>>>8&255;K=k[U>>2]|0;k[U>>2]=K+1;i[(k[V>>2]|0)+K>>0]=Y;_=Z}j[_>>1]=0;k[d>>2]=0;return}function Qj(a){a=a|0;var b=0;b=0;do{j[a+148+(b<<2)>>1]=0;b=b+1|0}while((b|0)!=286);j[a+2440>>1]=0;j[a+2444>>1]=0;j[a+2448>>1]=0;j[a+2452>>1]=0;j[a+2456>>1]=0;j[a+2460>>1]=0;j[a+2464>>1]=0;j[a+2468>>1]=0;j[a+2472>>1]=0;j[a+2476>>1]=0;j[a+2480>>1]=0;j[a+2484>>1]=0;j[a+2488>>1]=0;j[a+2492>>1]=0;j[a+2496>>1]=0;j[a+2500>>1]=0;j[a+2504>>1]=0;j[a+2508>>1]=0;j[a+2512>>1]=0;j[a+2516>>1]=0;j[a+2520>>1]=0;j[a+2524>>1]=0;j[a+2528>>1]=0;j[a+2532>>1]=0;j[a+2536>>1]=0;j[a+2540>>1]=0;j[a+2544>>1]=0;j[a+2548>>1]=0;j[a+2552>>1]=0;j[a+2556>>1]=0;j[a+2684>>1]=0;j[a+2688>>1]=0;j[a+2692>>1]=0;j[a+2696>>1]=0;j[a+2700>>1]=0;j[a+2704>>1]=0;j[a+2708>>1]=0;j[a+2712>>1]=0;j[a+2716>>1]=0;j[a+2720>>1]=0;j[a+2724>>1]=0;j[a+2728>>1]=0;j[a+2732>>1]=0;j[a+2736>>1]=0;j[a+2740>>1]=0;j[a+2744>>1]=0;j[a+2748>>1]=0;j[a+2752>>1]=0;j[a+2756>>1]=0;j[a+1172>>1]=1;k[a+5804>>2]=0;k[a+5800>>2]=0;k[a+5808>>2]=0;k[a+5792>>2]=0;return}function Rj(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0;c=r;r=r+32|0;d=c;e=k[b>>2]|0;f=b+8|0;g=k[f>>2]|0;h=k[g>>2]|0;n=k[g+12>>2]|0;g=a+5200|0;k[g>>2]=0;o=a+5204|0;k[o>>2]=573;if((n|0)>0){p=-1;q=0;while(1){if(!(j[e+(q<<2)>>1]|0)){j[e+(q<<2)+2>>1]=0;s=p}else{t=(k[g>>2]|0)+1|0;k[g>>2]=t;k[a+2908+(t<<2)>>2]=q;i[a+5208+q>>0]=0;s=q}q=q+1|0;if((q|0)==(n|0)){u=s;break}else p=s}s=k[g>>2]|0;if((s|0)<2){v=s;w=u;x=3}else{y=s;z=u}}else{v=0;w=-1;x=3}if((x|0)==3){x=a+5800|0;u=a+5804|0;if(!h){s=v;p=w;while(1){q=(p|0)<2;t=p+1|0;A=q?t:p;B=q?t:0;t=s+1|0;k[g>>2]=t;k[a+2908+(t<<2)>>2]=B;j[e+(B<<2)>>1]=1;i[a+5208+B>>0]=0;k[x>>2]=(k[x>>2]|0)+-1;B=k[g>>2]|0;if((B|0)<2){s=B;p=A}else{y=B;z=A;break}}}else{p=v;v=w;while(1){w=(v|0)<2;s=v+1|0;A=w?s:v;B=w?s:0;s=p+1|0;k[g>>2]=s;k[a+2908+(s<<2)>>2]=B;j[e+(B<<2)>>1]=1;i[a+5208+B>>0]=0;k[x>>2]=(k[x>>2]|0)+-1;k[u>>2]=(k[u>>2]|0)-(m[h+(B<<2)+2>>1]|0);B=k[g>>2]|0;if((B|0)<2){p=B;v=A}else{y=B;z=A;break}}}}v=b+4|0;k[v>>2]=z;p=y;h=(y|0)/2|0;while(1){y=k[a+2908+(h<<2)>>2]|0;u=a+5208+y|0;x=h<<1;a:do if((x|0)>(p|0))C=h;else{A=e+(y<<2)|0;B=h;s=p;w=x;while(1){do if((w|0)<(s|0)){t=w|1;q=k[a+2908+(t<<2)>>2]|0;D=j[e+(q<<2)>>1]|0;E=k[a+2908+(w<<2)>>2]|0;F=j[e+(E<<2)>>1]|0;if((D&65535)>=(F&65535)){if(D<<16>>16!=F<<16>>16){G=w;break}if((l[a+5208+q>>0]|0)>(l[a+5208+E>>0]|0)){G=w;break}}G=t}else G=w;while(0);t=j[A>>1]|0;E=k[a+2908+(G<<2)>>2]|0;q=j[e+(E<<2)>>1]|0;if((t&65535)<(q&65535)){C=B;break a}if(t<<16>>16==q<<16>>16?(l[u>>0]|0)<=(l[a+5208+E>>0]|0):0){C=B;break a}k[a+2908+(B<<2)>>2]=E;w=G<<1;s=k[g>>2]|0;if((w|0)>(s|0)){C=G;break}else B=G}}while(0);k[a+2908+(C<<2)>>2]=y;if((h|0)<=1)break;p=k[g>>2]|0;h=h+-1|0}h=a+2912|0;p=k[g>>2]|0;C=n;do{n=k[h>>2]|0;G=p+-1|0;k[g>>2]=G;u=k[a+2908+(p<<2)>>2]|0;k[h>>2]=u;x=a+5208+u|0;b:do if((p|0)<3)H=1;else{B=e+(u<<2)|0;s=1;w=G;A=2;while(1){do if((A|0)<(w|0)){E=A|1;q=k[a+2908+(E<<2)>>2]|0;t=j[e+(q<<2)>>1]|0;F=k[a+2908+(A<<2)>>2]|0;D=j[e+(F<<2)>>1]|0;if((t&65535)>=(D&65535)){if(t<<16>>16!=D<<16>>16){I=A;break}if((l[a+5208+q>>0]|0)>(l[a+5208+F>>0]|0)){I=A;break}}I=E}else I=A;while(0);E=j[B>>1]|0;F=k[a+2908+(I<<2)>>2]|0;q=j[e+(F<<2)>>1]|0;if((E&65535)<(q&65535)){H=s;break b}if(E<<16>>16==q<<16>>16?(l[x>>0]|0)<=(l[a+5208+F>>0]|0):0){H=s;break b}k[a+2908+(s<<2)>>2]=F;A=I<<1;w=k[g>>2]|0;if((A|0)>(w|0)){H=I;break}else s=I}}while(0);k[a+2908+(H<<2)>>2]=u;x=k[h>>2]|0;G=(k[o>>2]|0)+-1|0;k[o>>2]=G;k[a+2908+(G<<2)>>2]=n;G=(k[o>>2]|0)+-1|0;k[o>>2]=G;k[a+2908+(G<<2)>>2]=x;G=e+(C<<2)|0;j[G>>1]=(m[e+(x<<2)>>1]|0)+(m[e+(n<<2)>>1]|0);y=i[a+5208+n>>0]|0;s=i[a+5208+x>>0]|0;w=a+5208+C|0;i[w>>0]=(((y&255)<(s&255)?s:y)&255)+1;y=C&65535;j[e+(x<<2)+2>>1]=y;j[e+(n<<2)+2>>1]=y;k[h>>2]=C;y=k[g>>2]|0;c:do if((y|0)<2)J=1;else{x=1;s=y;A=2;while(1){do if((A|0)<(s|0)){B=A|1;F=k[a+2908+(B<<2)>>2]|0;q=j[e+(F<<2)>>1]|0;E=k[a+2908+(A<<2)>>2]|0;D=j[e+(E<<2)>>1]|0;if((q&65535)>=(D&65535)){if(q<<16>>16!=D<<16>>16){K=A;break}if((l[a+5208+F>>0]|0)>(l[a+5208+E>>0]|0)){K=A;break}}K=B}else K=A;while(0);B=j[G>>1]|0;E=k[a+2908+(K<<2)>>2]|0;F=j[e+(E<<2)>>1]|0;if((B&65535)<(F&65535)){J=x;break c}if(B<<16>>16==F<<16>>16?(l[w>>0]|0)<=(l[a+5208+E>>0]|0):0){J=x;break c}k[a+2908+(x<<2)>>2]=E;A=K<<1;s=k[g>>2]|0;if((A|0)>(s|0)){J=K;break}else x=K}}while(0);k[a+2908+(J<<2)>>2]=C;C=C+1|0;p=k[g>>2]|0}while((p|0)>1);p=k[h>>2]|0;h=(k[o>>2]|0)+-1|0;k[o>>2]=h;k[a+2908+(h<<2)>>2]=p;p=k[b>>2]|0;b=k[v>>2]|0;v=k[f>>2]|0;f=k[v>>2]|0;h=k[v+4>>2]|0;g=k[v+8>>2]|0;C=k[v+16>>2]|0;v=a+2876|0;J=v+32|0;do{j[v>>1]=0;v=v+2|0}while((v|0)<(J|0));v=k[o>>2]|0;j[p+(k[a+2908+(v<<2)>>2]<<2)+2>>1]=0;o=v+1|0;d:do if((o|0)<573){v=a+5800|0;J=a+5804|0;if(!f){K=o;H=0;while(1){I=k[a+2908+(K<<2)>>2]|0;w=p+(I<<2)+2|0;G=m[p+(m[w>>1]<<2)+2>>1]|0;y=(G|0)<(C|0);n=y?G+1|0:C;G=(y&1^1)+H|0;j[w>>1]=n;if((I|0)<=(b|0)){w=a+2876+(n<<1)|0;j[w>>1]=(j[w>>1]|0)+1<<16>>16;if((I|0)<(g|0))L=0;else L=k[h+(I-g<<2)>>2]|0;w=ha(m[p+(I<<2)>>1]|0,L+n|0)|0;k[v>>2]=w+(k[v>>2]|0)}K=K+1|0;if((K|0)==573){M=G;break}else H=G}}else{H=o;K=0;while(1){G=k[a+2908+(H<<2)>>2]|0;w=p+(G<<2)+2|0;n=m[p+(m[w>>1]<<2)+2>>1]|0;I=(n|0)<(C|0);y=I?n+1|0:C;n=(I&1^1)+K|0;j[w>>1]=y;if((G|0)<=(b|0)){w=a+2876+(y<<1)|0;j[w>>1]=(j[w>>1]|0)+1<<16>>16;if((G|0)<(g|0))N=0;else N=k[h+(G-g<<2)>>2]|0;w=m[p+(G<<2)>>1]|0;I=ha(w,N+y|0)|0;k[v>>2]=I+(k[v>>2]|0);I=ha((m[f+(G<<2)+2>>1]|0)+N|0,w)|0;k[J>>2]=I+(k[J>>2]|0)}H=H+1|0;if((H|0)==573){M=n;break}else K=n}}if(M){K=a+2876+(C<<1)|0;H=M;while(1){J=C;while(1){n=J+-1|0;I=a+2876+(n<<1)|0;w=j[I>>1]|0;if(!(w<<16>>16))J=n;else{O=I;P=w;Q=J;break}}j[O>>1]=P+-1<<16>>16;J=a+2876+(Q<<1)|0;j[J>>1]=(m[J>>1]|0)+2;J=(j[K>>1]|0)+-1<<16>>16;j[K>>1]=J;if((H|0)>2)H=H+-2|0;else{R=J;break}}if(C){H=R;K=C;J=573;while(1){w=K&65535;if(!(H<<16>>16))S=J;else{I=J;n=H&65535;while(1){G=I;while(1){y=G+-1|0;u=k[a+2908+(y<<2)>>2]|0;if((u|0)>(b|0))G=y;else{T=y;U=u;break}}G=p+(U<<2)+2|0;u=m[G>>1]|0;if((K|0)!=(u|0)){y=ha(m[p+(U<<2)>>1]|0,K-u|0)|0;k[v>>2]=y+(k[v>>2]|0);j[G>>1]=w}n=n+-1|0;if(!n){S=T;break}else I=T}}I=K+-1|0;if(!I)break d;H=j[a+2876+(I<<1)>>1]|0;K=I;J=S}}}}while(0);S=1;T=0;do{T=(m[a+2876+(S+-1<<1)>>1]|0)+(T&65534)<<1;j[d+(S<<1)>>1]=T;S=S+1|0}while((S|0)!=16);if((z|0)<0){r=c;return}else V=0;while(1){S=j[e+(V<<2)+2>>1]|0;T=S&65535;if(S<<16>>16){S=d+(T<<1)|0;a=j[S>>1]|0;j[S>>1]=a+1<<16>>16;S=T;T=a&65535;a=0;while(1){U=a|T&1;if((S|0)>1){S=S+-1|0;T=T>>>1;a=U<<1}else{W=U;break}}j[e+(V<<2)>>1]=W}if((V|0)==(z|0))break;else V=V+1|0}r=c;return}function Sj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0;d=a+5792|0;if(!(k[d>>2]|0)){e=a+5820|0;f=a+5816|0;g=f;h=e;n=k[e>>2]|0;o=j[f>>1]|0}else{f=a+5796|0;e=a+5784|0;p=a+5820|0;q=a+5816|0;r=a+20|0;s=a+8|0;t=0;do{u=j[(k[f>>2]|0)+(t<<1)>>1]|0;v=u&65535;w=l[(k[e>>2]|0)+t>>0]|0;t=t+1|0;do if(!(u<<16>>16)){x=m[b+(w<<2)+2>>1]|0;y=k[p>>2]|0;z=m[b+(w<<2)>>1]|0;A=m[q>>1]|0|z<<y;B=A&65535;j[q>>1]=B;if((y|0)>(16-x|0)){C=k[r>>2]|0;k[r>>2]=C+1;i[(k[s>>2]|0)+C>>0]=A;A=(m[q>>1]|0)>>>8&255;C=k[r>>2]|0;k[r>>2]=C+1;i[(k[s>>2]|0)+C>>0]=A;A=k[p>>2]|0;C=z>>>(16-A|0)&65535;j[q>>1]=C;z=x+-16+A|0;k[p>>2]=z;D=C;E=z;break}else{z=y+x|0;k[p>>2]=z;D=B;E=z;break}}else{z=l[155385+w>>0]|0;B=(z|256)+1|0;x=m[b+(B<<2)+2>>1]|0;y=k[p>>2]|0;C=m[b+(B<<2)>>1]|0;B=m[q>>1]|0|C<<y;A=B&65535;j[q>>1]=A;if((y|0)>(16-x|0)){F=k[r>>2]|0;k[r>>2]=F+1;i[(k[s>>2]|0)+F>>0]=B;B=(m[q>>1]|0)>>>8&255;F=k[r>>2]|0;k[r>>2]=F+1;i[(k[s>>2]|0)+F>>0]=B;B=k[p>>2]|0;F=C>>>(16-B|0)&65535;j[q>>1]=F;G=F;H=x+-16+B|0}else{G=A;H=y+x|0}k[p>>2]=H;x=k[110168+(z<<2)>>2]|0;do if((z+-8|0)>>>0<20){y=w-(k[110284+(z<<2)>>2]|0)&65535;A=y<<H|G&65535;B=A&65535;j[q>>1]=B;if((H|0)>(16-x|0)){F=k[r>>2]|0;k[r>>2]=F+1;i[(k[s>>2]|0)+F>>0]=A;A=(m[q>>1]|0)>>>8&255;F=k[r>>2]|0;k[r>>2]=F+1;i[(k[s>>2]|0)+F>>0]=A;A=k[p>>2]|0;F=y>>>(16-A|0)&65535;j[q>>1]=F;y=x+-16+A|0;k[p>>2]=y;I=y;J=F;break}else{F=H+x|0;k[p>>2]=F;I=F;J=B;break}}else{I=H;J=G}while(0);x=v+-1|0;z=l[154873+(x>>>0<256?x:(x>>>7)+256|0)>>0]|0;B=m[c+(z<<2)+2>>1]|0;F=m[c+(z<<2)>>1]|0;y=J&65535|F<<I;A=y&65535;j[q>>1]=A;if((I|0)>(16-B|0)){C=k[r>>2]|0;k[r>>2]=C+1;i[(k[s>>2]|0)+C>>0]=y;y=(m[q>>1]|0)>>>8&255;C=k[r>>2]|0;k[r>>2]=C+1;i[(k[s>>2]|0)+C>>0]=y;y=k[p>>2]|0;C=F>>>(16-y|0)&65535;j[q>>1]=C;K=B+-16+y|0;L=C}else{K=I+B|0;L=A}k[p>>2]=K;A=k[110400+(z<<2)>>2]|0;if((z+-4|0)>>>0<26){B=x-(k[110520+(z<<2)>>2]|0)&65535;z=B<<K|L&65535;x=z&65535;j[q>>1]=x;if((K|0)>(16-A|0)){C=k[r>>2]|0;k[r>>2]=C+1;i[(k[s>>2]|0)+C>>0]=z;z=(m[q>>1]|0)>>>8&255;C=k[r>>2]|0;k[r>>2]=C+1;i[(k[s>>2]|0)+C>>0]=z;z=k[p>>2]|0;C=B>>>(16-z|0)&65535;j[q>>1]=C;B=A+-16+z|0;k[p>>2]=B;D=C;E=B;break}else{B=K+A|0;k[p>>2]=B;D=x;E=B;break}}else{D=L;E=K}}while(0)}while(t>>>0<(k[d>>2]|0)>>>0);g=q;h=p;n=E;o=D}D=m[b+1026>>1]|0;E=m[b+1024>>1]|0;b=o&65535|E<<n;j[g>>1]=b;if((n|0)>(16-D|0)){o=a+20|0;p=k[o>>2]|0;k[o>>2]=p+1;q=a+8|0;i[(k[q>>2]|0)+p>>0]=b;b=(m[g>>1]|0)>>>8&255;p=k[o>>2]|0;k[o>>2]=p+1;i[(k[q>>2]|0)+p>>0]=b;b=k[h>>2]|0;j[g>>1]=E>>>(16-b|0);M=D+-16+b|0;k[h>>2]=M;return}else{M=n+D|0;k[h>>2]=M;return}}function Tj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0;d=j[b+2>>1]|0;e=d<<16>>16==0;f=a+2754|0;g=a+5820|0;h=a+2752|0;l=a+5816|0;n=a+20|0;o=a+8|0;p=a+2758|0;q=a+2756|0;r=a+2750|0;s=a+2748|0;t=e?138:7;u=e?3:4;e=0;v=d&65535;d=-1;a:while(1){w=0;x=e;while(1){if((x|0)>(c|0))break a;y=x+1|0;z=j[b+(y<<2)+2>>1]|0;A=z&65535;B=w+1|0;C=(v|0)==(A|0);if((B|0)<(t|0)&C){w=B;x=y}else{D=y;E=z;F=A;G=B;H=C;I=w;break}}do if((G|0)>=(u|0)){if(v){if((v|0)==(d|0)){J=j[l>>1]|0;K=k[g>>2]|0;L=G}else{w=m[a+2684+(v<<2)+2>>1]|0;x=k[g>>2]|0;C=m[a+2684+(v<<2)>>1]|0;B=m[l>>1]|0|C<<x;A=B&65535;j[l>>1]=A;if((x|0)>(16-w|0)){z=k[n>>2]|0;k[n>>2]=z+1;i[(k[o>>2]|0)+z>>0]=B;B=(m[l>>1]|0)>>>8&255;z=k[n>>2]|0;k[n>>2]=z+1;i[(k[o>>2]|0)+z>>0]=B;B=k[g>>2]|0;z=C>>>(16-B|0)&65535;j[l>>1]=z;M=z;N=w+-16+B|0}else{M=A;N=x+w|0}k[g>>2]=N;J=M;K=N;L=I}w=m[r>>1]|0;x=m[s>>1]|0;A=J&65535|x<<K;j[l>>1]=A;if((K|0)>(16-w|0)){B=k[n>>2]|0;k[n>>2]=B+1;i[(k[o>>2]|0)+B>>0]=A;B=(m[l>>1]|0)>>>8&255;z=k[n>>2]|0;k[n>>2]=z+1;i[(k[o>>2]|0)+z>>0]=B;B=k[g>>2]|0;z=x>>>(16-B|0);j[l>>1]=z;O=w+-16+B|0;P=z}else{O=K+w|0;P=A}k[g>>2]=O;A=L+65533&65535;w=P&65535|A<<O;j[l>>1]=w;if((O|0)>14){z=k[n>>2]|0;k[n>>2]=z+1;i[(k[o>>2]|0)+z>>0]=w;w=(m[l>>1]|0)>>>8&255;z=k[n>>2]|0;k[n>>2]=z+1;i[(k[o>>2]|0)+z>>0]=w;w=k[g>>2]|0;j[l>>1]=A>>>(16-w|0);k[g>>2]=w+-14;break}else{k[g>>2]=O+2;break}}if((G|0)<11){w=m[f>>1]|0;A=k[g>>2]|0;z=m[h>>1]|0;B=m[l>>1]|0|z<<A;j[l>>1]=B;if((A|0)>(16-w|0)){x=k[n>>2]|0;k[n>>2]=x+1;i[(k[o>>2]|0)+x>>0]=B;x=(m[l>>1]|0)>>>8&255;C=k[n>>2]|0;k[n>>2]=C+1;i[(k[o>>2]|0)+C>>0]=x;x=k[g>>2]|0;C=z>>>(16-x|0);j[l>>1]=C;Q=w+-16+x|0;R=C}else{Q=A+w|0;R=B}k[g>>2]=Q;B=I+65534&65535;w=R&65535|B<<Q;j[l>>1]=w;if((Q|0)>13){A=k[n>>2]|0;k[n>>2]=A+1;i[(k[o>>2]|0)+A>>0]=w;w=(m[l>>1]|0)>>>8&255;A=k[n>>2]|0;k[n>>2]=A+1;i[(k[o>>2]|0)+A>>0]=w;w=k[g>>2]|0;j[l>>1]=B>>>(16-w|0);k[g>>2]=w+-13;break}else{k[g>>2]=Q+3;break}}else{w=m[p>>1]|0;B=k[g>>2]|0;A=m[q>>1]|0;C=m[l>>1]|0|A<<B;j[l>>1]=C;if((B|0)>(16-w|0)){x=k[n>>2]|0;k[n>>2]=x+1;i[(k[o>>2]|0)+x>>0]=C;x=(m[l>>1]|0)>>>8&255;z=k[n>>2]|0;k[n>>2]=z+1;i[(k[o>>2]|0)+z>>0]=x;x=k[g>>2]|0;z=A>>>(16-x|0);j[l>>1]=z;S=w+-16+x|0;T=z}else{S=B+w|0;T=C}k[g>>2]=S;C=I+65526&65535;w=T&65535|C<<S;j[l>>1]=w;if((S|0)>9){B=k[n>>2]|0;k[n>>2]=B+1;i[(k[o>>2]|0)+B>>0]=w;w=(m[l>>1]|0)>>>8&255;B=k[n>>2]|0;k[n>>2]=B+1;i[(k[o>>2]|0)+B>>0]=w;w=k[g>>2]|0;j[l>>1]=C>>>(16-w|0);k[g>>2]=w+-9;break}else{k[g>>2]=S+7;break}}}else{w=a+2684+(v<<2)+2|0;C=a+2684+(v<<2)|0;B=k[g>>2]|0;z=j[l>>1]|0;x=G;while(1){A=m[w>>1]|0;y=m[C>>1]|0;U=z&65535|y<<B;V=U&65535;j[l>>1]=V;if((B|0)>(16-A|0)){W=k[n>>2]|0;k[n>>2]=W+1;i[(k[o>>2]|0)+W>>0]=U;U=(m[l>>1]|0)>>>8&255;W=k[n>>2]|0;k[n>>2]=W+1;i[(k[o>>2]|0)+W>>0]=U;U=k[g>>2]|0;W=y>>>(16-U|0)&65535;j[l>>1]=W;X=W;Y=A+-16+U|0}else{X=V;Y=B+A|0}k[g>>2]=Y;x=x+-1|0;if(!x)break;else{B=Y;z=X}}}while(0);z=E<<16>>16==0;B=v;t=z?138:H?6:7;u=z|H?3:4;e=D;v=F;d=B}return}function Uj(a,b,c){a=a|0;b=b|0;c=c|0;return jr(ha(c,b)|0)|0}function Vj(a,b){a=a|0;b=b|0;kr(b);return}function Wj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0;d=a>>>16;e=a&65535;if((c|0)==1){a=(l[b>>0]|0)+e|0;f=a>>>0>65520?a+-65521|0:a;a=f+d|0;g=(a>>>0>65520?a+15|0:a)<<16|f;return g|0}if(!b){g=1;return g|0}if(c>>>0<16){if(!c){h=e;i=d}else{f=b;a=c;j=e;k=d;while(1){a=a+-1|0;m=(l[f>>0]|0)+j|0;n=m+k|0;if(!a){h=m;i=n;break}else{f=f+1|0;j=m;k=n}}}g=((i>>>0)%65521|0)<<16|(h>>>0>65520?h+-65521|0:h);return g|0}if(c>>>0>5551){h=c+-5552|0;i=(h>>>0)%5552|0;k=h-i+5552|0;h=b;j=c;f=e;a=d;while(1){j=j+-5552|0;n=h;m=f;o=347;p=a;while(1){q=(l[n>>0]|0)+m|0;r=q+(l[n+1>>0]|0)|0;s=r+(l[n+2>>0]|0)|0;t=s+(l[n+3>>0]|0)|0;u=t+(l[n+4>>0]|0)|0;v=u+(l[n+5>>0]|0)|0;w=v+(l[n+6>>0]|0)|0;x=w+(l[n+7>>0]|0)|0;y=x+(l[n+8>>0]|0)|0;z=y+(l[n+9>>0]|0)|0;A=z+(l[n+10>>0]|0)|0;B=A+(l[n+11>>0]|0)|0;C=B+(l[n+12>>0]|0)|0;D=C+(l[n+13>>0]|0)|0;E=D+(l[n+14>>0]|0)|0;F=E+(l[n+15>>0]|0)|0;G=q+p+r+s+t+u+v+w+x+y+z+A+B+C+D+E+F|0;o=o+-1|0;if(!o){H=F;I=G;break}else{n=n+16|0;m=F;p=G}}p=(H>>>0)%65521|0;m=(I>>>0)%65521|0;if(j>>>0<=5551){J=p;K=m;break}else{h=h+5552|0;f=p;a=m}}a=b+k|0;if(i)if(i>>>0>15){L=i;M=a;N=J;O=K;P=15}else{Q=i;R=a;S=J;T=K;P=18}else{U=J;V=K}}else{L=c;M=b;N=e;O=d;P=15}if((P|0)==15){d=L+-16|0;e=d&-16;b=M+(e+16)|0;c=L;L=M;M=N;N=O;while(1){c=c+-16|0;O=(l[L>>0]|0)+M|0;K=O+(l[L+1>>0]|0)|0;J=K+(l[L+2>>0]|0)|0;a=J+(l[L+3>>0]|0)|0;i=a+(l[L+4>>0]|0)|0;k=i+(l[L+5>>0]|0)|0;f=k+(l[L+6>>0]|0)|0;h=f+(l[L+7>>0]|0)|0;j=h+(l[L+8>>0]|0)|0;I=j+(l[L+9>>0]|0)|0;H=I+(l[L+10>>0]|0)|0;m=H+(l[L+11>>0]|0)|0;p=m+(l[L+12>>0]|0)|0;n=p+(l[L+13>>0]|0)|0;o=n+(l[L+14>>0]|0)|0;G=o+(l[L+15>>0]|0)|0;F=O+N+K+J+a+i+k+f+h+j+I+H+m+p+n+o+G|0;if(c>>>0<=15){W=G;X=F;break}else{L=L+16|0;M=G;N=F}}if((d|0)==(e|0)){Y=W;Z=X;P=19}else{Q=d-e|0;R=b;S=W;T=X;P=18}}if((P|0)==18)while(1){P=0;Q=Q+-1|0;X=(l[R>>0]|0)+S|0;W=X+T|0;if(!Q){Y=X;Z=W;P=19;break}else{R=R+1|0;S=X;T=W;P=18}}if((P|0)==19){U=(Y>>>0)%65521|0;V=(Z>>>0)%65521|0}g=V<<16|U;return g|0}function Xj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;if(!b){d=0;return d|0}e=~a;a:do if(c){a=b;f=c;g=e;while(1){if(!(a&3)){h=a;i=f;j=g;break}m=k[110756+(((l[a>>0]|0)^g&255)<<2)>>2]^g>>>8;f=f+-1|0;if(!f){n=m;break a}else{a=a+1|0;g=m}}if(i>>>0>31){g=i+-32|0;a=g&-32;f=a+32|0;m=i;o=h;p=j;while(1){q=k[o>>2]^p;r=k[112804+((q>>>8&255)<<2)>>2]^k[113828+((q&255)<<2)>>2]^k[111780+((q>>>16&255)<<2)>>2]^k[110756+(q>>>24<<2)>>2]^k[o+4>>2];q=k[112804+((r>>>8&255)<<2)>>2]^k[113828+((r&255)<<2)>>2]^k[111780+((r>>>16&255)<<2)>>2]^k[110756+(r>>>24<<2)>>2]^k[o+8>>2];r=k[112804+((q>>>8&255)<<2)>>2]^k[113828+((q&255)<<2)>>2]^k[111780+((q>>>16&255)<<2)>>2]^k[110756+(q>>>24<<2)>>2]^k[o+12>>2];q=k[112804+((r>>>8&255)<<2)>>2]^k[113828+((r&255)<<2)>>2]^k[111780+((r>>>16&255)<<2)>>2]^k[110756+(r>>>24<<2)>>2]^k[o+16>>2];r=k[112804+((q>>>8&255)<<2)>>2]^k[113828+((q&255)<<2)>>2]^k[111780+((q>>>16&255)<<2)>>2]^k[110756+(q>>>24<<2)>>2]^k[o+20>>2];q=k[112804+((r>>>8&255)<<2)>>2]^k[113828+((r&255)<<2)>>2]^k[111780+((r>>>16&255)<<2)>>2]^k[110756+(r>>>24<<2)>>2]^k[o+24>>2];r=k[112804+((q>>>8&255)<<2)>>2]^k[113828+((q&255)<<2)>>2]^k[111780+((q>>>16&255)<<2)>>2]^k[110756+(q>>>24<<2)>>2]^k[o+28>>2];q=k[112804+((r>>>8&255)<<2)>>2]^k[113828+((r&255)<<2)>>2]^k[111780+((r>>>16&255)<<2)>>2]^k[110756+(r>>>24<<2)>>2];m=m+-32|0;if(m>>>0<=31){s=q;break}else{o=o+32|0;p=q}}t=g-a|0;u=h+f|0;v=s}else{t=i;u=h;v=j}if(t>>>0>3){p=t+-4|0;o=p>>>2;m=o<<2;q=t;r=u;w=v;while(1){x=k[r>>2]^w;y=k[112804+((x>>>8&255)<<2)>>2]^k[113828+((x&255)<<2)>>2]^k[111780+((x>>>16&255)<<2)>>2]^k[110756+(x>>>24<<2)>>2];q=q+-4|0;if(q>>>0<=3){z=y;break}else{r=r+4|0;w=y}}A=p-m|0;B=u+(o+1<<2)|0;C=z}else{A=t;B=u;C=v}if(!A)n=C;else{w=B;r=A;q=C;while(1){f=k[110756+(((l[w>>0]|0)^q&255)<<2)>>2]^q>>>8;r=r+-1|0;if(!r){n=f;break}else{w=w+1|0;q=f}}}}else n=e;while(0);d=~n;return d|0}function Yj(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0;c=k[a+28>>2]|0;d=k[a>>2]|0;e=a+4|0;f=d+((k[e>>2]|0)+-6)|0;g=a+12|0;h=k[g>>2]|0;m=a+16|0;n=k[m>>2]|0;o=h+(n+-258)|0;p=k[c+44>>2]|0;q=k[c+48>>2]|0;r=k[c+52>>2]|0;s=c+56|0;t=c+60|0;u=k[c+76>>2]|0;v=k[c+80>>2]|0;w=(1<<k[c+84>>2])+-1|0;x=(1<<k[c+88>>2])+-1|0;y=h+(n+~b)|0;b=c+7104|0;n=r+-1|0;z=(q|0)==0;A=(k[c+40>>2]|0)+-1|0;B=A+q|0;C=q+-1|0;D=y+-1|0;E=y-q|0;F=y+-2|0;G=k[t>>2]|0;H=k[s>>2]|0;I=d+-1|0;d=h+-1|0;a:while(1){if(G>>>0<15){h=I+2|0;J=G+16|0;K=((l[I+1>>0]|0)<<G)+H+((l[h>>0]|0)<<G+8)|0;L=h}else{J=G;K=H;L=I}h=K&w;M=i[u+(h<<2)>>0]|0;N=j[u+(h<<2)+2>>1]|0;O=l[u+(h<<2)+1>>0]|0;h=K>>>O;P=J-O|0;do if(M<<24>>24){O=h;Q=P;R=M&255;S=N;while(1){if(R&16){T=R;U=Q;V=O;W=S;break}if(R&64){X=R;Y=Q;Z=O;_=L;$=d;aa=57;break a}ba=(O&(1<<R)+-1)+(S&65535)|0;ca=i[u+(ba<<2)>>0]|0;da=j[u+(ba<<2)+2>>1]|0;ea=l[u+(ba<<2)+1>>0]|0;ba=O>>>ea;fa=Q-ea|0;if(!(ca<<24>>24)){ga=ba;ha=fa;ia=da;aa=6;break}else{O=ba;Q=fa;R=ca&255;S=da}}if((aa|0)==6){aa=0;ja=ga;ka=ha;la=ia&255;aa=7;break}S=W&65535;R=T&15;if(!R){ma=U;na=V;oa=L;pa=S}else{if(U>>>0<R>>>0){Q=L+1|0;qa=U+8|0;ra=((l[Q>>0]|0)<<U)+V|0;sa=Q}else{qa=U;ra=V;sa=L}ma=qa-R|0;na=ra>>>R;oa=sa;pa=(ra&(1<<R)+-1)+S|0}if(ma>>>0<15){S=oa+2|0;ta=ma+16|0;ua=((l[oa+1>>0]|0)<<ma)+na+((l[S>>0]|0)<<ma+8)|0;va=S}else{ta=ma;ua=na;va=oa}S=ua&x;R=j[v+(S<<2)+2>>1]|0;Q=l[v+(S<<2)+1>>0]|0;O=ua>>>Q;da=ta-Q|0;Q=l[v+(S<<2)>>0]|0;if(!(Q&16)){S=Q;ca=O;fa=da;ba=R;while(1){if(S&64){wa=fa;xa=ca;ya=va;za=d;aa=54;break a}ea=(ca&(1<<S)+-1)+(ba&65535)|0;Aa=j[v+(ea<<2)+2>>1]|0;Ba=l[v+(ea<<2)+1>>0]|0;Ca=ca>>>Ba;Da=fa-Ba|0;Ba=l[v+(ea<<2)>>0]|0;if(!(Ba&16)){S=Ba;ca=Ca;fa=Da;ba=Aa}else{Ea=Ca;Fa=Da;Ga=Ba;Ha=Aa;break}}}else{Ea=O;Fa=da;Ga=Q;Ha=R}ba=Ha&65535;fa=Ga&15;if(Fa>>>0<fa>>>0){ca=va+1|0;S=((l[ca>>0]|0)<<Fa)+Ea|0;Aa=Fa+8|0;if(Aa>>>0<fa>>>0){Ba=va+2|0;Ia=Fa+16|0;Ja=((l[Ba>>0]|0)<<Aa)+S|0;Ka=Ba}else{Ia=Aa;Ja=S;Ka=ca}}else{Ia=Fa;Ja=Ea;Ka=va}ca=(Ja&(1<<fa)+-1)+ba|0;ba=Ja>>>fa;S=Ia-fa|0;fa=d;Aa=fa-y|0;if(ca>>>0<=Aa>>>0){Ba=2-pa|0;Da=pa+(Ba>>>0>4294967293?Ba:-3)|0;Ba=Da-((Da>>>0)%3|0)|0;Da=Ba-ca|0;Ca=d+(0-ca)|0;ea=pa;La=d;do{i[La+1>>0]=i[Ca+1>>0]|0;i[La+2>>0]=i[Ca+2>>0]|0;Ca=Ca+3|0;La=La+3|0;i[La>>0]=i[Ca>>0]|0;ea=ea+-3|0}while(ea>>>0>2);ea=pa+-3|0;if((ea|0)==(Ba|0)){Ma=S;Na=ba;Oa=Ka;Pa=d+(Ba+3)|0;break}Ca=d+(Ba+4)|0;i[Ca>>0]=i[d+(Da+4)>>0]|0;if((ea-Ba|0)>>>0<=1){Ma=S;Na=ba;Oa=Ka;Pa=Ca;break}Ca=d+(Ba+5)|0;i[Ca>>0]=i[d+(Da+5)>>0]|0;Ma=S;Na=ba;Oa=Ka;Pa=Ca;break}Ca=ca-Aa|0;if(Ca>>>0>p>>>0?(k[b>>2]|0)!=0:0){Qa=ba;Ra=S;Sa=Ka;Ta=d;aa=22;break a}do if(z){ea=r+(A-Ca)|0;if(pa>>>0>Ca>>>0){La=pa-Ca|0;R=ca-fa|0;Q=ea;da=Ca;O=d;do{Q=Q+1|0;O=O+1|0;i[O>>0]=i[Q>>0]|0;da=da+-1|0}while((da|0)!=0);Ua=d+(D+R+(1-ca))|0;Va=La;Wa=d+(y+R)|0}else{Ua=ea;Va=pa;Wa=d}}else{if(Ca>>>0<=q>>>0){da=r+(C-Ca)|0;if(pa>>>0<=Ca>>>0){Ua=da;Va=pa;Wa=d;break}Q=pa-Ca|0;O=ca-fa|0;Xa=da;da=Ca;Ya=d;do{Xa=Xa+1|0;Ya=Ya+1|0;i[Ya>>0]=i[Xa>>0]|0;da=da+-1|0}while((da|0)!=0);Ua=d+(D+O+(1-ca))|0;Va=Q;Wa=d+(y+O)|0;break}da=r+(B-Ca)|0;Xa=Ca-q|0;if(pa>>>0>Xa>>>0){Ya=pa-Xa|0;ea=ca-fa|0;R=da;La=Xa;Xa=d;do{R=R+1|0;Xa=Xa+1|0;i[Xa>>0]=i[R>>0]|0;La=La+-1|0}while((La|0)!=0);La=d+(E+ea)|0;if(Ya>>>0>q>>>0){R=Ya-q|0;Xa=n;O=q;Q=La;do{Xa=Xa+1|0;Q=Q+1|0;i[Q>>0]=i[Xa>>0]|0;O=O+-1|0}while((O|0)!=0);Ua=d+(F+ea+(2-ca))|0;Va=R;Wa=d+(y+ea)|0}else{Ua=n;Va=Ya;Wa=La}}else{Ua=da;Va=pa;Wa=d}}while(0);if(Va>>>0>2){ca=Va+-3|0;fa=(ca>>>0)%3|0;Ca=ca-fa|0;ca=Ua;Aa=Va;Da=Wa;do{i[Da+1>>0]=i[ca+1>>0]|0;i[Da+2>>0]=i[ca+2>>0]|0;ca=ca+3|0;Da=Da+3|0;i[Da>>0]=i[ca>>0]|0;Aa=Aa+-3|0}while(Aa>>>0>2);Za=Ua+(Ca+3)|0;_a=fa;$a=Wa+(Ca+3)|0}else{Za=Ua;_a=Va;$a=Wa}if(_a){Aa=$a+1|0;i[Aa>>0]=i[Za+1>>0]|0;if(_a>>>0>1){ca=$a+2|0;i[ca>>0]=i[Za+2>>0]|0;Ma=S;Na=ba;Oa=Ka;Pa=ca}else{Ma=S;Na=ba;Oa=Ka;Pa=Aa}}else{Ma=S;Na=ba;Oa=Ka;Pa=$a}}else{ja=h;ka=P;la=N&255;aa=7}while(0);if((aa|0)==7){aa=0;N=d+1|0;i[N>>0]=la;Ma=ka;Na=ja;Oa=L;Pa=N}if(Pa>>>0<o>>>0&Oa>>>0<f>>>0){G=Ma;H=Na;I=Oa;d=Pa}else{ab=Ma;bb=Na;cb=Oa;db=Pa;break}}do if((aa|0)==22){k[a+24>>2]=155777;k[c>>2]=29;ab=Ra;bb=Qa;cb=Sa;db=Ta}else if((aa|0)==54){k[a+24>>2]=155807;k[c>>2]=29;ab=wa;bb=xa;cb=ya;db=za}else if((aa|0)==57)if(!(X&32)){k[a+24>>2]=155829;k[c>>2]=29;ab=Y;bb=Z;cb=_;db=$;break}else{k[c>>2]=11;ab=Y;bb=Z;cb=_;db=$;break}while(0);$=ab>>>3;_=ab-($<<3)|0;k[a>>2]=cb+(1-$);k[g>>2]=db+1;k[e>>2]=f+5-(cb+(0-$));k[m>>2]=o+257-db;k[s>>2]=(1<<_)+-1&bb;k[t>>2]=_;return}function Zj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;k[a+4>>2]=0;if((b|0)!=90){d=k[a>>2]|0;k[d+20>>2]=13;k[d+24>>2]=90;k[d+28>>2]=b;qb[k[d>>2]&127](a)}if((c|0)==440)e=a;else{d=k[a>>2]|0;k[d+20>>2]=22;k[d+24>>2]=440;k[d+28>>2]=c;qb[k[d>>2]&127](a);e=a}d=k[a>>2]|0;c=a+12|0;b=k[c>>2]|0;qr(a|0,0,440)|0;k[a>>2]=d;k[c>>2]=b;k[a+16>>2]=0;tm(e);k[a+8>>2]=0;k[a+24>>2]=0;k[a+84>>2]=0;k[a+88>>2]=0;k[a+104>>2]=100;k[a+92>>2]=0;k[a+108>>2]=100;k[a+96>>2]=0;k[a+112>>2]=100;k[a+100>>2]=0;k[a+116>>2]=100;e=a+120|0;k[e>>2]=0;k[e+4>>2]=0;k[e+8>>2]=0;k[e+12>>2]=0;k[e+16>>2]=0;k[e+20>>2]=0;k[e+24>>2]=0;k[e+28>>2]=0;k[a+380>>2]=8;k[a+384>>2]=119984;k[a+388>>2]=63;k[a+428>>2]=0;p[a+48>>3]=1.0;k[a+20>>2]=100;return}function _j(a,b){a=a|0;b=b|0;var c=0;c=k[a+88>>2]|0;if(c)k[c+128>>2]=b;c=k[a+92>>2]|0;if(c)k[c+128>>2]=b;c=k[a+96>>2]|0;if(c)k[c+128>>2]=b;c=k[a+100>>2]|0;if(c)k[c+128>>2]=b;c=k[a+120>>2]|0;if(c)k[c+276>>2]=b;c=k[a+136>>2]|0;if(c)k[c+276>>2]=b;c=k[a+124>>2]|0;if(c)k[c+276>>2]=b;c=k[a+140>>2]|0;if(c)k[c+276>>2]=b;c=k[a+128>>2]|0;if(c)k[c+276>>2]=b;c=k[a+144>>2]|0;if(c)k[c+276>>2]=b;c=k[a+132>>2]|0;if(c)k[c+276>>2]=b;c=k[a+148>>2]|0;if(!c)return;k[c+276>>2]=b;return}function $j(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;b=k[a+20>>2]|0;switch(b|0){case 102:case 101:{if((k[a+264>>2]|0)>>>0<(k[a+32>>2]|0)>>>0){c=k[a>>2]|0;k[c+20>>2]=69;qb[k[c>>2]&127](a)}qb[k[(k[a+392>>2]|0)+8>>2]&127](a);break}case 103:break;default:{c=k[a>>2]|0;k[c+20>>2]=21;k[c+24>>2]=b;qb[k[c>>2]&127](a)}}c=a+392|0;b=k[c>>2]|0;if(k[b+16>>2]|0){d=a;e=a+408|0;f=k[e>>2]|0;g=f+12|0;h=k[g>>2]|0;qb[h&127](a);i=a+24|0;j=k[i>>2]|0;l=j+16|0;m=k[l>>2]|0;qb[m&127](a);Ak(d);return}n=a+288|0;o=a+8|0;p=a+404|0;q=b;do{qb[k[q>>2]&127](a);b=k[n>>2]|0;if(b){r=b;b=0;do{s=k[o>>2]|0;if(s){k[s+4>>2]=b;k[s+8>>2]=r;qb[k[s>>2]&127](a)}if(!(yb[k[(k[p>>2]|0)+4>>2]&127](a,0)|0)){s=k[a>>2]|0;k[s+20>>2]=25;qb[k[s>>2]&127](a)}b=b+1|0;r=k[n>>2]|0}while(b>>>0<r>>>0)}qb[k[(k[c>>2]|0)+8>>2]&127](a);q=k[c>>2]|0}while((k[q+16>>2]|0)==0);d=a;e=a+408|0;f=k[e>>2]|0;g=f+12|0;h=k[g>>2]|0;qb[h&127](a);i=a+24|0;j=k[i>>2]|0;l=j+16|0;m=k[l>>2]|0;qb[m&127](a);Ak(d);return}function ak(a){a=a|0;var b=0,c=0,d=0;b=k[a+20>>2]|0;if((b|0)==100)c=a;else{d=k[a>>2]|0;k[d+20>>2]=21;k[d+24>>2]=b;qb[k[d>>2]&127](a);c=a}qb[k[(k[a>>2]|0)+16>>2]&127](c);c=a+24|0;qb[k[(k[c>>2]|0)+8>>2]&127](a);ik(a);qb[k[(k[a+408>>2]|0)+16>>2]&127](a);qb[k[(k[c>>2]|0)+16>>2]&127](a);return}function bk(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=a+20|0;d=k[c>>2]|0;if((d|0)!=100){e=k[a>>2]|0;k[e+20>>2]=21;k[e+24>>2]=d;qb[k[e>>2]&127](a)}if(b)_j(a,0);qb[k[(k[a>>2]|0)+16>>2]&127](a);qb[k[(k[a+24>>2]|0)+8>>2]&127](a);ek(a);qb[k[k[a+392>>2]>>2]&127](a);k[a+264>>2]=0;k[c>>2]=(k[a+208>>2]|0)!=0?102:101;return}function ck(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;d=r;r=r+16|0;e=d;f=k[a+20>>2]|0;if((f|0)!=101){g=k[a>>2]|0;k[g+20>>2]=21;k[g+24>>2]=f;qb[k[g>>2]&127](a)}g=a+264|0;f=a+32|0;if((k[g>>2]|0)>>>0>=(k[f>>2]|0)>>>0){h=k[a>>2]|0;k[h+20>>2]=126;rb[k[h+4>>2]&31](a,-1)}h=k[a+8>>2]|0;if(h){k[h+4>>2]=k[g>>2];k[h+8>>2]=k[f>>2];qb[k[h>>2]&127](a)}h=k[a+392>>2]|0;if(k[h+12>>2]|0)qb[k[h+4>>2]&127](a);h=(k[f>>2]|0)-(k[g>>2]|0)|0;k[e>>2]=0;Ab[k[(k[a+396>>2]|0)+4>>2]&31](a,b,e,h>>>0<c>>>0?h:c);c=k[e>>2]|0;k[g>>2]=(k[g>>2]|0)+c;r=d;return c|0}function dk(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;d=k[a+20>>2]|0;if((d|0)!=102){e=k[a>>2]|0;k[e+20>>2]=21;k[e+24>>2]=d;qb[k[e>>2]&127](a)}e=a+264|0;d=k[e>>2]|0;f=k[a+32>>2]|0;if(d>>>0>=f>>>0){g=k[a>>2]|0;k[g+20>>2]=126;rb[k[g+4>>2]&31](a,-1);h=0;return h|0}g=k[a+8>>2]|0;if(g){k[g+4>>2]=d;k[g+8>>2]=f;qb[k[g>>2]&127](a)}g=k[a+392>>2]|0;if(k[g+12>>2]|0)qb[k[g+4>>2]&127](a);g=ha(k[a+284>>2]|0,k[a+276>>2]|0)|0;if(g>>>0>c>>>0){c=k[a>>2]|0;k[c+20>>2]=24;qb[k[c>>2]&127](a)}if(!(yb[k[(k[a+404>>2]|0)+4>>2]&127](a,b)|0)){h=0;return h|0}k[e>>2]=(k[e>>2]|0)+g;h=g;return h|0}function ek(a){a=a|0;var b=0,c=0,d=0;b=k[a+72>>2]|0;if((b|0)!=8){c=k[a>>2]|0;k[c+20>>2]=16;k[c+24>>2]=b;qb[k[c>>2]&127](a)}if(!(((k[a+32>>2]|0)!=0?(k[a+28>>2]|0)!=0:0)?(k[a+36>>2]|0)>=1:0)){c=k[a>>2]|0;k[c+20>>2]=33;qb[k[c>>2]&127](a)}uk(a,0);if(!(k[a+208>>2]|0)){an(a);Ok(a);Kk(a,0)}ln(a);if(!(k[a+212>>2]|0))pn(a);else Nm(a);if((k[a+200>>2]|0)>1)d=1;else d=(k[a+216>>2]|0)!=0;Xm(a,d&1);fk(a,0);ik(a);qb[k[(k[a+4>>2]|0)+24>>2]&127](a);qb[k[k[a+408>>2]>>2]&127](a);return}function fk(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;c=a+4|0;d=nb[k[k[c>>2]>>2]&63](a,1,64)|0;k[a+396>>2]=d;k[d>>2]=7;if(k[a+208>>2]|0)return;if(b){b=k[a>>2]|0;k[b+20>>2]=3;qb[k[b>>2]&127](a);return}b=a+76|0;if((k[b>>2]|0)<=0)return;e=d+24|0;d=0;f=k[a+84>>2]|0;while(1){g=ha(k[f+36>>2]|0,k[f+28>>2]|0)|0;h=ha(k[f+40>>2]|0,k[f+12>>2]|0)|0;i=xb[k[(k[c>>2]|0)+8>>2]&63](a,1,g,h)|0;k[e+(d<<2)>>2]=i;d=d+1|0;if((d|0)>=(k[b>>2]|0))break;else f=f+88|0}return}function gk(a,b){a=a|0;b=b|0;var c=0;c=k[a+396>>2]|0;if(k[a+208>>2]|0)return;k[c+8>>2]=0;k[c+12>>2]=0;k[c+16>>2]=0;k[c+20>>2]=b;if(!b){k[c+4>>2]=4;return}else{c=k[a>>2]|0;k[c+20>>2]=3;qb[k[c>>2]&127](a);return}}function hk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;e=k[a+396>>2]|0;f=e+8|0;g=a+288|0;if((k[f>>2]|0)>>>0>=(k[g>>2]|0)>>>0)return;h=e+12|0;i=a+284|0;j=a+400|0;l=e+24|0;m=a+404|0;n=e+16|0;e=k[h>>2]|0;while(1){o=k[i>>2]|0;if(e>>>0<o>>>0){ob[k[(k[j>>2]|0)+4>>2]&15](a,b,c,d,l,h,o);p=k[h>>2]|0;q=k[i>>2]|0}else{p=e;q=o}if((p|0)!=(q|0)){r=12;break}o=(yb[k[(k[m>>2]|0)+4>>2]&127](a,l)|0)==0;s=(k[n>>2]|0)!=0;if(o){r=7;break}if(s){k[c>>2]=(k[c>>2]|0)+1;k[n>>2]=0}k[h>>2]=0;o=(k[f>>2]|0)+1|0;k[f>>2]=o;if(o>>>0<(k[g>>2]|0)>>>0)e=0;else{r=12;break}}if((r|0)==7){if(s)return;k[c>>2]=(k[c>>2]|0)+-1;k[n>>2]=1;return}else if((r|0)==12)return}function ik(a){a=a|0;var b=0;b=nb[k[k[a+4>>2]>>2]&63](a,1,32)|0;k[a+408>>2]=b;k[b>>2]=30;k[b+4>>2]=31;k[b+8>>2]=32;k[b+12>>2]=33;k[b+16>>2]=34;k[b+20>>2]=44;k[b+24>>2]=8;k[b+28>>2]=0;return}function jk(a){a=a|0;var b=0,c=0,d=0,e=0,f=0;b=k[a+408>>2]|0;c=a+24|0;d=k[c>>2]|0;e=k[d>>2]|0;k[d>>2]=e+1;i[e>>0]=-1;e=d+4|0;f=(k[e>>2]|0)+-1|0;k[e>>2]=f;if((f|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;f=k[d>>2]|0;k[d>>2]=f+1;i[f>>0]=-40;f=d+4|0;e=(k[f>>2]|0)+-1|0;k[f>>2]=e;if((e|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}k[b+28>>2]=0;do if(k[a+244>>2]|0){b=k[c>>2]|0;d=k[b>>2]|0;k[b>>2]=d+1;i[d>>0]=-1;d=b+4|0;e=(k[d>>2]|0)+-1|0;k[d>>2]=e;if((e|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=k[c>>2]|0;e=k[b>>2]|0;k[b>>2]=e+1;i[e>>0]=-32;e=b+4|0;d=(k[e>>2]|0)+-1|0;k[e>>2]=d;if((d|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=k[c>>2]|0;d=k[b>>2]|0;k[b>>2]=d+1;i[d>>0]=0;d=b+4|0;e=(k[d>>2]|0)+-1|0;k[d>>2]=e;if((e|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=k[c>>2]|0;e=k[b>>2]|0;k[b>>2]=e+1;i[e>>0]=16;e=b+4|0;d=(k[e>>2]|0)+-1|0;k[e>>2]=d;if((d|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=k[c>>2]|0;d=k[b>>2]|0;k[b>>2]=d+1;i[d>>0]=74;d=b+4|0;e=(k[d>>2]|0)+-1|0;k[d>>2]=e;if((e|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=k[c>>2]|0;e=k[b>>2]|0;k[b>>2]=e+1;i[e>>0]=70;e=b+4|0;d=(k[e>>2]|0)+-1|0;k[e>>2]=d;if((d|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=k[c>>2]|0;d=k[b>>2]|0;k[b>>2]=d+1;i[d>>0]=73;d=b+4|0;e=(k[d>>2]|0)+-1|0;k[d>>2]=e;if((e|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=k[c>>2]|0;e=k[b>>2]|0;k[b>>2]=e+1;i[e>>0]=70;e=b+4|0;d=(k[e>>2]|0)+-1|0;k[e>>2]=d;if((d|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=k[c>>2]|0;d=k[b>>2]|0;k[b>>2]=d+1;i[d>>0]=0;d=b+4|0;e=(k[d>>2]|0)+-1|0;k[d>>2]=e;if((e|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=i[a+248>>0]|0;e=k[c>>2]|0;d=k[e>>2]|0;k[e>>2]=d+1;i[d>>0]=b;b=e+4|0;d=(k[b>>2]|0)+-1|0;k[b>>2]=d;if((d|0)==0?(ub[k[e+12>>2]&63](a)|0)==0:0){e=k[a>>2]|0;k[e+20>>2]=25;qb[k[e>>2]&127](a)}e=i[a+249>>0]|0;d=k[c>>2]|0;b=k[d>>2]|0;k[d>>2]=b+1;i[b>>0]=e;e=d+4|0;b=(k[e>>2]|0)+-1|0;k[e>>2]=b;if((b|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=i[a+250>>0]|0;b=k[c>>2]|0;e=k[b>>2]|0;k[b>>2]=e+1;i[e>>0]=d;d=b+4|0;e=(k[d>>2]|0)+-1|0;k[d>>2]=e;if((e|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=j[a+252>>1]|0;e=k[c>>2]|0;d=k[e>>2]|0;k[e>>2]=d+1;i[d>>0]=(b&65535)>>>8;d=e+4|0;f=(k[d>>2]|0)+-1|0;k[d>>2]=f;if((f|0)==0?(ub[k[e+12>>2]&63](a)|0)==0:0){e=k[a>>2]|0;k[e+20>>2]=25;qb[k[e>>2]&127](a)}e=k[c>>2]|0;f=k[e>>2]|0;k[e>>2]=f+1;i[f>>0]=b;b=e+4|0;f=(k[b>>2]|0)+-1|0;k[b>>2]=f;if((f|0)==0?(ub[k[e+12>>2]&63](a)|0)==0:0){e=k[a>>2]|0;k[e+20>>2]=25;qb[k[e>>2]&127](a)}e=j[a+254>>1]|0;f=k[c>>2]|0;b=k[f>>2]|0;k[f>>2]=b+1;i[b>>0]=(e&65535)>>>8;b=f+4|0;d=(k[b>>2]|0)+-1|0;k[b>>2]=d;do if(!d){if(ub[k[f+12>>2]&63](a)|0)break;b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}while(0);f=k[c>>2]|0;d=k[f>>2]|0;k[f>>2]=d+1;i[d>>0]=e;d=f+4|0;b=(k[d>>2]|0)+-1|0;k[d>>2]=b;do if(!b){if(ub[k[f+12>>2]&63](a)|0)break;d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}while(0);f=k[c>>2]|0;b=k[f>>2]|0;k[f>>2]=b+1;i[b>>0]=0;b=f+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;do if(!e){if(ub[k[f+12>>2]&63](a)|0)break;b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}while(0);f=k[c>>2]|0;e=k[f>>2]|0;k[f>>2]=e+1;i[e>>0]=0;e=f+4|0;b=(k[e>>2]|0)+-1|0;k[e>>2]=b;if(b)break;if(ub[k[f+12>>2]&63](a)|0)break;f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}while(0);if(!(k[a+256>>2]|0))return;f=k[c>>2]|0;b=k[f>>2]|0;k[f>>2]=b+1;i[b>>0]=-1;b=f+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;if((e|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;e=k[f>>2]|0;k[f>>2]=e+1;i[e>>0]=-18;e=f+4|0;b=(k[e>>2]|0)+-1|0;k[e>>2]=b;if((b|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;b=k[f>>2]|0;k[f>>2]=b+1;i[b>>0]=0;b=f+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;if((e|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;e=k[f>>2]|0;k[f>>2]=e+1;i[e>>0]=14;e=f+4|0;b=(k[e>>2]|0)+-1|0;k[e>>2]=b;if((b|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;b=k[f>>2]|0;k[f>>2]=b+1;i[b>>0]=65;b=f+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;if((e|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;e=k[f>>2]|0;k[f>>2]=e+1;i[e>>0]=100;e=f+4|0;b=(k[e>>2]|0)+-1|0;k[e>>2]=b;if((b|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;b=k[f>>2]|0;k[f>>2]=b+1;i[b>>0]=111;b=f+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;if((e|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;e=k[f>>2]|0;k[f>>2]=e+1;i[e>>0]=98;e=f+4|0;b=(k[e>>2]|0)+-1|0;k[e>>2]=b;if((b|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;b=k[f>>2]|0;k[f>>2]=b+1;i[b>>0]=101;b=f+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;if((e|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;e=k[f>>2]|0;k[f>>2]=e+1;i[e>>0]=0;e=f+4|0;b=(k[e>>2]|0)+-1|0;k[e>>2]=b;if((b|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;b=k[f>>2]|0;k[f>>2]=b+1;i[b>>0]=100;b=f+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;if((e|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;e=k[f>>2]|0;k[f>>2]=e+1;i[e>>0]=0;e=f+4|0;b=(k[e>>2]|0)+-1|0;k[e>>2]=b;if((b|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;b=k[f>>2]|0;k[f>>2]=b+1;i[b>>0]=0;b=f+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;if((e|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;e=k[f>>2]|0;k[f>>2]=e+1;i[e>>0]=0;e=f+4|0;b=(k[e>>2]|0)+-1|0;k[e>>2]=b;if((b|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;b=k[f>>2]|0;k[f>>2]=b+1;i[b>>0]=0;b=f+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;do if(!e){if(ub[k[f+12>>2]&63](a)|0)break;b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}while(0);switch(k[a+80>>2]|0){case 3:{f=k[c>>2]|0;e=k[f>>2]|0;k[f>>2]=e+1;i[e>>0]=1;e=f+4|0;b=(k[e>>2]|0)+-1|0;k[e>>2]=b;if(b)return;if(ub[k[f+12>>2]&63](a)|0)return;f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a);return}case 5:{f=k[c>>2]|0;b=k[f>>2]|0;k[f>>2]=b+1;i[b>>0]=2;b=f+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;if(e)return;if(ub[k[f+12>>2]&63](a)|0)return;f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a);return}default:{f=k[c>>2]|0;c=k[f>>2]|0;k[f>>2]=c+1;i[c>>0]=0;c=f+4|0;e=(k[c>>2]|0)+-1|0;k[c>>2]=e;if(e)return;if(ub[k[f+12>>2]&63](a)|0)return;f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a);return}}}function kk(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0;b=a+84|0;c=a+76|0;d=k[c>>2]|0;if((d|0)>0){e=0;f=k[b>>2]|0;g=0;while(1){h=(qk(a,k[f+16>>2]|0)|0)+g|0;e=e+1|0;j=k[c>>2]|0;if((e|0)>=(j|0)){l=j;m=h;break}else{f=f+88|0;g=h}}}else{l=d;m=0}d=a+212|0;g=a+268|0;f=(k[g>>2]|0)==0;a:do if(k[d>>2]|0)if(f)n=19;else n=18;else{b:do if(f){do if((k[a+72>>2]|0)==8?(k[a+380>>2]|0)==8:0){if((l|0)>0){e=0;h=k[b>>2]|0;j=1;while(1){if((k[h+20>>2]|0)<=1?(k[h+24>>2]|0)<=1:0)o=j;else o=0;e=e+1|0;if((e|0)>=(l|0)){p=o;break}else{h=h+88|0;j=o}}}else p=1;if(!((m|0)!=0&(p|0)!=0)){if(!p)break;sk(a,192);break a}j=k[a>>2]|0;k[j+20>>2]=77;rb[k[j+4>>2]&31](a,0);j=(k[g>>2]|0)!=0;if(!(k[d>>2]|0))if(j)break b;else break;else if(j){n=18;break a}else{n=19;break a}}while(0);sk(a,193);break a}while(0);sk(a,194)}while(0);if((n|0)==18)sk(a,202);else if((n|0)==19)sk(a,201);switch(k[a+260>>2]|0){case 0:break;case 1:{if((k[c>>2]|0)<3)n=27;else n=28;break}default:n=27}if((n|0)==27){c=k[a>>2]|0;k[c+20>>2]=28;qb[k[c>>2]&127](a);n=28}do if((n|0)==28){c=a+24|0;d=k[c>>2]|0;p=k[d>>2]|0;k[d>>2]=p+1;i[p>>0]=-1;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;if((m|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=-8;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;if((p|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;p=k[d>>2]|0;k[d>>2]=p+1;i[p>>0]=0;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;if((m|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=24;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;if((p|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;p=k[d>>2]|0;k[d>>2]=p+1;i[p>>0]=13;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;if((m|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=0;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;if((p|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;p=k[d>>2]|0;k[d>>2]=p+1;i[p>>0]=-1;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;if((m|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=3;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;if((p|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;p=k[(k[b>>2]|0)+88>>2]&255;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=p;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;if((m|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;m=k[k[b>>2]>>2]&255;p=k[d>>2]|0;k[d>>2]=p+1;i[p>>0]=m;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;if((p|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;p=k[(k[b>>2]|0)+176>>2]&255;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=p;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;if((m|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=-128;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;if((p|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;p=k[d>>2]|0;k[d>>2]=p+1;i[p>>0]=0;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;if((m|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=0;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;if((p|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;p=k[d>>2]|0;k[d>>2]=p+1;i[p>>0]=0;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;if((m|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=0;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;do if(!p){if(ub[k[d+12>>2]&63](a)|0)break;m=k[a>>2]|0;k[m+20>>2]=25;qb[k[m>>2]&127](a)}while(0);d=k[c>>2]|0;p=k[d>>2]|0;k[d>>2]=p+1;i[p>>0]=0;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;do if(!m){if(ub[k[d+12>>2]&63](a)|0)break;p=k[a>>2]|0;k[p+20>>2]=25;qb[k[p>>2]&127](a)}while(0);d=k[c>>2]|0;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=0;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;do if(!p){if(ub[k[d+12>>2]&63](a)|0)break;m=k[a>>2]|0;k[m+20>>2]=25;qb[k[m>>2]&127](a)}while(0);d=k[c>>2]|0;p=k[d>>2]|0;k[d>>2]=p+1;i[p>>0]=1;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;do if(!m){if(ub[k[d+12>>2]&63](a)|0)break;p=k[a>>2]|0;k[p+20>>2]=25;qb[k[p>>2]&127](a)}while(0);d=k[c>>2]|0;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=0;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;do if(!p){if(ub[k[d+12>>2]&63](a)|0)break;m=k[a>>2]|0;k[m+20>>2]=25;qb[k[m>>2]&127](a)}while(0);d=k[c>>2]|0;p=k[d>>2]|0;k[d>>2]=p+1;i[p>>0]=0;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;do if(!m){if(ub[k[d+12>>2]&63](a)|0)break;p=k[a>>2]|0;k[p+20>>2]=25;qb[k[p>>2]&127](a)}while(0);d=k[c>>2]|0;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=0;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;do if(!p){if(ub[k[d+12>>2]&63](a)|0)break;m=k[a>>2]|0;k[m+20>>2]=25;qb[k[m>>2]&127](a)}while(0);d=k[c>>2]|0;p=k[d>>2]|0;k[d>>2]=p+1;i[p>>0]=0;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;do if(!m){if(ub[k[d+12>>2]&63](a)|0)break;p=k[a>>2]|0;k[p+20>>2]=25;qb[k[p>>2]&127](a)}while(0);d=k[c>>2]|0;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=1;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;do if(!p){if(ub[k[d+12>>2]&63](a)|0)break;m=k[a>>2]|0;k[m+20>>2]=25;qb[k[m>>2]&127](a)}while(0);d=k[c>>2]|0;p=k[d>>2]|0;k[d>>2]=p+1;i[p>>0]=0;p=d+4|0;m=(k[p>>2]|0)+-1|0;k[p>>2]=m;do if(!m){if(ub[k[d+12>>2]&63](a)|0)break;p=k[a>>2]|0;k[p+20>>2]=25;qb[k[p>>2]&127](a)}while(0);d=k[c>>2]|0;m=k[d>>2]|0;k[d>>2]=m+1;i[m>>0]=0;m=d+4|0;p=(k[m>>2]|0)+-1|0;k[m>>2]=p;if(p)break;if(ub[k[d+12>>2]&63](a)|0)break;d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}while(0);if(!(k[g>>2]|0))return;g=a+380|0;if((k[g>>2]|0)==8)return;b=a+24|0;n=k[b>>2]|0;d=k[n>>2]|0;k[n>>2]=d+1;i[d>>0]=-1;d=n+4|0;p=(k[d>>2]|0)+-1|0;k[d>>2]=p;if((p|0)==0?(ub[k[n+12>>2]&63](a)|0)==0:0){n=k[a>>2]|0;k[n+20>>2]=25;qb[k[n>>2]&127](a)}n=k[b>>2]|0;p=k[n>>2]|0;k[n>>2]=p+1;i[p>>0]=-38;p=n+4|0;d=(k[p>>2]|0)+-1|0;k[p>>2]=d;if((d|0)==0?(ub[k[n+12>>2]&63](a)|0)==0:0){n=k[a>>2]|0;k[n+20>>2]=25;qb[k[n>>2]&127](a)}n=k[b>>2]|0;d=k[n>>2]|0;k[n>>2]=d+1;i[d>>0]=0;d=n+4|0;p=(k[d>>2]|0)+-1|0;k[d>>2]=p;if((p|0)==0?(ub[k[n+12>>2]&63](a)|0)==0:0){n=k[a>>2]|0;k[n+20>>2]=25;qb[k[n>>2]&127](a)}n=k[b>>2]|0;p=k[n>>2]|0;k[n>>2]=p+1;i[p>>0]=6;p=n+4|0;d=(k[p>>2]|0)+-1|0;k[p>>2]=d;if((d|0)==0?(ub[k[n+12>>2]&63](a)|0)==0:0){n=k[a>>2]|0;k[n+20>>2]=25;qb[k[n>>2]&127](a)}n=k[b>>2]|0;d=k[n>>2]|0;k[n>>2]=d+1;i[d>>0]=0;d=n+4|0;p=(k[d>>2]|0)+-1|0;k[d>>2]=p;if((p|0)==0?(ub[k[n+12>>2]&63](a)|0)==0:0){n=k[a>>2]|0;k[n+20>>2]=25;qb[k[n>>2]&127](a)}n=k[b>>2]|0;p=k[n>>2]|0;k[n>>2]=p+1;i[p>>0]=0;p=n+4|0;d=(k[p>>2]|0)+-1|0;k[p>>2]=d;if((d|0)==0?(ub[k[n+12>>2]&63](a)|0)==0:0){n=k[a>>2]|0;k[n+20>>2]=25;qb[k[n>>2]&127](a)}n=k[g>>2]|0;g=(ha(n,n)|0)+255|0;n=k[b>>2]|0;d=k[n>>2]|0;k[n>>2]=d+1;i[d>>0]=g;g=n+4|0;d=(k[g>>2]|0)+-1|0;k[g>>2]=d;if((d|0)==0?(ub[k[n+12>>2]&63](a)|0)==0:0){n=k[a>>2]|0;k[n+20>>2]=25;qb[k[n>>2]&127](a)}n=k[b>>2]|0;b=k[n>>2]|0;k[n>>2]=b+1;i[b>>0]=0;b=n+4|0;d=(k[b>>2]|0)+-1|0;k[b>>2]=d;if(d)return;if(ub[k[n+12>>2]&63](a)|0)return;n=k[a>>2]|0;k[n+20>>2]=25;qb[k[n>>2]&127](a);return}function lk(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0;b=r;r=r+32|0;c=b+16|0;d=b;e=k[a+408>>2]|0;if(!(k[a+212>>2]|0)){f=a+292|0;if((k[f>>2]|0)>0){g=a+364|0;h=a+372|0;j=a+368|0;m=0;do{n=k[a+296+(m<<2)>>2]|0;if((k[g>>2]|0)==0?(k[h>>2]|0)==0:0)rk(a,k[n+20>>2]|0,0);if(k[j>>2]|0)rk(a,k[n+24>>2]|0,1);m=m+1|0}while((m|0)<(k[f>>2]|0))}}else{f=d;m=f+16|0;do{i[f>>0]=0;f=f+1|0}while((f|0)<(m|0));f=c;m=f+16|0;do{i[f>>0]=0;f=f+1|0}while((f|0)<(m|0));f=k[a+292>>2]|0;if((f|0)>0){m=(k[a+368>>2]|0)==0;if(k[a+364>>2]|0)if(m){o=0;p=0;q=0;s=0;t=0;u=0;v=0;w=0;x=0;y=0;z=0;A=0;B=0;C=0;D=0;E=0}else{j=0;do{i[d+(k[(k[a+296+(j<<2)>>2]|0)+24>>2]|0)>>0]=1;j=j+1|0}while((j|0)!=(f|0));o=0;p=0;q=0;s=0;t=0;u=0;v=0;w=0;x=0;y=0;z=0;A=0;B=0;C=0;D=0;E=0}else{j=(k[a+372>>2]|0)==0;if(m){m=0;do{if(j)i[c+(k[(k[a+296+(m<<2)>>2]|0)+20>>2]|0)>>0]=1;m=m+1|0}while((m|0)!=(f|0))}else{m=0;do{h=k[a+296+(m<<2)>>2]|0;if(j)i[c+(k[h+20>>2]|0)>>0]=1;i[d+(k[h+24>>2]|0)>>0]=1;m=m+1|0}while((m|0)!=(f|0))}o=i[c+13>>0]|0;p=i[c>>0]|0;q=i[c+14>>0]|0;s=i[c+15>>0]|0;t=i[c+1>>0]|0;u=i[c+2>>0]|0;v=i[c+3>>0]|0;w=i[c+4>>0]|0;x=i[c+5>>0]|0;y=i[c+6>>0]|0;z=i[c+7>>0]|0;A=i[c+8>>0]|0;B=i[c+9>>0]|0;C=i[c+10>>0]|0;D=i[c+11>>0]|0;E=i[c+12>>0]|0}F=i[d+15>>0]|0;G=p;H=i[d>>0]|0;I=t;J=i[d+1>>0]|0;K=u;L=i[d+2>>0]|0;M=v;N=i[d+3>>0]|0;O=w;P=i[d+4>>0]|0;Q=x;R=i[d+5>>0]|0;S=y;T=i[d+6>>0]|0;U=z;V=i[d+7>>0]|0;W=A;X=i[d+8>>0]|0;Y=B;Z=i[d+9>>0]|0;_=C;$=i[d+10>>0]|0;aa=D;ba=i[d+11>>0]|0;ca=E;da=i[d+12>>0]|0;ea=o;fa=i[d+13>>0]|0;ga=q;ha=i[d+14>>0]|0;ia=s}else{F=0;G=0;H=0;I=0;J=0;K=0;L=0;M=0;N=0;O=0;P=0;Q=0;R=0;S=0;T=0;U=0;V=0;W=0;X=0;Y=0;Z=0;_=0;$=0;aa=0;ba=0;ca=0;da=0;ea=0;fa=0;ga=0;ha=0;ia=0}s=(ca<<24>>24)+(da<<24>>24)+(ba<<24>>24)+(aa<<24>>24)+($<<24>>24)+(_<<24>>24)+(Z<<24>>24)+(Y<<24>>24)+(X<<24>>24)+(W<<24>>24)+(V<<24>>24)+(U<<24>>24)+(T<<24>>24)+(S<<24>>24)+(R<<24>>24)+(Q<<24>>24)+(P<<24>>24)+(O<<24>>24)+(N<<24>>24)+(M<<24>>24)+(L<<24>>24)+(K<<24>>24)+(J<<24>>24)+(I<<24>>24)+(H<<24>>24)+(G<<24>>24)+(ea<<24>>24)+(fa<<24>>24)+(ga<<24>>24)+(ha<<24>>24)+(ia<<24>>24)+(F<<24>>24)|0;if(s){F=a+24|0;ia=k[F>>2]|0;ha=k[ia>>2]|0;k[ia>>2]=ha+1;i[ha>>0]=-1;ha=ia+4|0;ga=(k[ha>>2]|0)+-1|0;k[ha>>2]=ga;if((ga|0)==0?(ub[k[ia+12>>2]&63](a)|0)==0:0){ia=k[a>>2]|0;k[ia+20>>2]=25;qb[k[ia>>2]&127](a)}ia=k[F>>2]|0;ga=k[ia>>2]|0;k[ia>>2]=ga+1;i[ga>>0]=-52;ga=ia+4|0;ha=(k[ga>>2]|0)+-1|0;k[ga>>2]=ha;if((ha|0)==0?(ub[k[ia+12>>2]&63](a)|0)==0:0){ia=k[a>>2]|0;k[ia+20>>2]=25;qb[k[ia>>2]&127](a)}ia=(s<<1)+2|0;s=k[F>>2]|0;ha=k[s>>2]|0;k[s>>2]=ha+1;i[ha>>0]=ia>>>8;ha=s+4|0;ga=(k[ha>>2]|0)+-1|0;k[ha>>2]=ga;if((ga|0)==0?(ub[k[s+12>>2]&63](a)|0)==0:0){s=k[a>>2]|0;k[s+20>>2]=25;qb[k[s>>2]&127](a)}s=k[F>>2]|0;ga=k[s>>2]|0;k[s>>2]=ga+1;i[ga>>0]=ia;ia=s+4|0;ga=(k[ia>>2]|0)+-1|0;k[ia>>2]=ga;if((ga|0)==0?(ub[k[s+12>>2]&63](a)|0)==0:0){s=k[a>>2]|0;k[s+20>>2]=25;qb[k[s>>2]&127](a)}s=0;do{if(i[c+s>>0]|0){ga=k[F>>2]|0;ia=k[ga>>2]|0;k[ga>>2]=ia+1;i[ia>>0]=s;ia=ga+4|0;ha=(k[ia>>2]|0)+-1|0;k[ia>>2]=ha;if((ha|0)==0?(ub[k[ga+12>>2]&63](a)|0)==0:0){ga=k[a>>2]|0;k[ga+20>>2]=25;qb[k[ga>>2]&127](a)}ga=k[F>>2]|0;ha=(l[a+168+s>>0]<<4)+(l[a+152+s>>0]|0)&255;ia=k[ga>>2]|0;k[ga>>2]=ia+1;i[ia>>0]=ha;ha=ga+4|0;ia=(k[ha>>2]|0)+-1|0;k[ha>>2]=ia;if((ia|0)==0?(ub[k[ga+12>>2]&63](a)|0)==0:0){ga=k[a>>2]|0;k[ga+20>>2]=25;qb[k[ga>>2]&127](a)}}if(i[d+s>>0]|0){ga=k[F>>2]|0;ia=k[ga>>2]|0;k[ga>>2]=ia+1;i[ia>>0]=s+16;ia=ga+4|0;ha=(k[ia>>2]|0)+-1|0;k[ia>>2]=ha;if((ha|0)==0?(ub[k[ga+12>>2]&63](a)|0)==0:0){ga=k[a>>2]|0;k[ga+20>>2]=25;qb[k[ga>>2]&127](a)}ga=i[a+184+s>>0]|0;ha=k[F>>2]|0;ia=k[ha>>2]|0;k[ha>>2]=ia+1;i[ia>>0]=ga;ga=ha+4|0;ia=(k[ga>>2]|0)+-1|0;k[ga>>2]=ia;if((ia|0)==0?(ub[k[ha+12>>2]&63](a)|0)==0:0){ha=k[a>>2]|0;k[ha+20>>2]=25;qb[k[ha>>2]&127](a)}}s=s+1|0}while((s|0)!=16)}}s=a+236|0;F=e+28|0;e=a+24|0;if((k[s>>2]|0)!=(k[F>>2]|0)){d=k[e>>2]|0;c=k[d>>2]|0;k[d>>2]=c+1;i[c>>0]=-1;c=d+4|0;ha=(k[c>>2]|0)+-1|0;k[c>>2]=ha;if((ha|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[e>>2]|0;ha=k[d>>2]|0;k[d>>2]=ha+1;i[ha>>0]=-35;ha=d+4|0;c=(k[ha>>2]|0)+-1|0;k[ha>>2]=c;if((c|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[e>>2]|0;c=k[d>>2]|0;k[d>>2]=c+1;i[c>>0]=0;c=d+4|0;ha=(k[c>>2]|0)+-1|0;k[c>>2]=ha;if((ha|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[e>>2]|0;ha=k[d>>2]|0;k[d>>2]=ha+1;i[ha>>0]=4;ha=d+4|0;c=(k[ha>>2]|0)+-1|0;k[ha>>2]=c;if((c|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[s>>2]|0;c=k[e>>2]|0;ha=k[c>>2]|0;k[c>>2]=ha+1;i[ha>>0]=d>>>8;ha=c+4|0;ia=(k[ha>>2]|0)+-1|0;k[ha>>2]=ia;if((ia|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}c=k[e>>2]|0;ia=k[c>>2]|0;k[c>>2]=ia+1;i[ia>>0]=d;d=c+4|0;ia=(k[d>>2]|0)+-1|0;k[d>>2]=ia;if((ia|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}k[F>>2]=k[s>>2]}s=k[e>>2]|0;F=k[s>>2]|0;k[s>>2]=F+1;i[F>>0]=-1;F=s+4|0;c=(k[F>>2]|0)+-1|0;k[F>>2]=c;if((c|0)==0?(ub[k[s+12>>2]&63](a)|0)==0:0){s=k[a>>2]|0;k[s+20>>2]=25;qb[k[s>>2]&127](a)}s=k[e>>2]|0;c=k[s>>2]|0;k[s>>2]=c+1;i[c>>0]=-38;c=s+4|0;F=(k[c>>2]|0)+-1|0;k[c>>2]=F;if((F|0)==0?(ub[k[s+12>>2]&63](a)|0)==0:0){s=k[a>>2]|0;k[s+20>>2]=25;qb[k[s>>2]&127](a)}s=a+292|0;F=(k[s>>2]<<1)+6|0;c=k[e>>2]|0;ia=k[c>>2]|0;k[c>>2]=ia+1;i[ia>>0]=F>>>8;ia=c+4|0;d=(k[ia>>2]|0)+-1|0;k[ia>>2]=d;if((d|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}c=k[e>>2]|0;d=k[c>>2]|0;k[c>>2]=d+1;i[d>>0]=F;F=c+4|0;d=(k[F>>2]|0)+-1|0;k[F>>2]=d;if((d|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}c=k[e>>2]|0;d=k[s>>2]&255;F=k[c>>2]|0;k[c>>2]=F+1;i[F>>0]=d;d=c+4|0;F=(k[d>>2]|0)+-1|0;k[d>>2]=F;if((F|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}if((k[s>>2]|0)>0){c=a+364|0;F=a+372|0;d=a+368|0;ia=0;do{ha=k[a+296+(ia<<2)>>2]|0;ga=k[e>>2]|0;fa=k[ha>>2]&255;ea=k[ga>>2]|0;k[ga>>2]=ea+1;i[ea>>0]=fa;fa=ga+4|0;ea=(k[fa>>2]|0)+-1|0;k[fa>>2]=ea;if((ea|0)==0?(ub[k[ga+12>>2]&63](a)|0)==0:0){ga=k[a>>2]|0;k[ga+20>>2]=25;qb[k[ga>>2]&127](a)}if((k[c>>2]|0)==0?(k[F>>2]|0)==0:0)ja=k[ha+20>>2]|0;else ja=0;if(!(k[d>>2]|0))ka=0;else ka=k[ha+24>>2]|0;ha=k[e>>2]|0;ga=k[ha>>2]|0;k[ha>>2]=ga+1;i[ga>>0]=ka+(ja<<4);ga=ha+4|0;ea=(k[ga>>2]|0)+-1|0;k[ga>>2]=ea;if((ea|0)==0?(ub[k[ha+12>>2]&63](a)|0)==0:0){ha=k[a>>2]|0;k[ha+20>>2]=25;qb[k[ha>>2]&127](a)}ia=ia+1|0}while((ia|0)<(k[s>>2]|0));la=c}else la=a+364|0;c=k[e>>2]|0;s=k[la>>2]&255;la=k[c>>2]|0;k[c>>2]=la+1;i[la>>0]=s;s=c+4|0;la=(k[s>>2]|0)+-1|0;k[s>>2]=la;if((la|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}c=k[e>>2]|0;la=k[a+368>>2]&255;s=k[c>>2]|0;k[c>>2]=s+1;i[s>>0]=la;la=c+4|0;s=(k[la>>2]|0)+-1|0;k[la>>2]=s;if((s|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}c=k[e>>2]|0;e=(k[a+372>>2]<<4)+(k[a+376>>2]|0)&255;s=k[c>>2]|0;k[c>>2]=s+1;i[s>>0]=e;e=c+4|0;s=(k[e>>2]|0)+-1|0;k[e>>2]=s;if(s){r=b;return}if(ub[k[c+12>>2]&63](a)|0){r=b;return}c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a);r=b;return}function mk(a){a=a|0;var b=0,c=0,d=0,e=0;b=a+24|0;c=k[b>>2]|0;d=k[c>>2]|0;k[c>>2]=d+1;i[d>>0]=-1;d=c+4|0;e=(k[d>>2]|0)+-1|0;k[d>>2]=e;if((e|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}c=k[b>>2]|0;b=k[c>>2]|0;k[c>>2]=b+1;i[b>>0]=-39;b=c+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;if(e)return;if(ub[k[c+12>>2]&63](a)|0)return;c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a);return}function nk(a){a=a|0;var b=0,c=0,d=0,e=0;b=a+24|0;c=k[b>>2]|0;d=k[c>>2]|0;k[c>>2]=d+1;i[d>>0]=-1;d=c+4|0;e=(k[d>>2]|0)+-1|0;k[d>>2]=e;if((e|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}c=k[b>>2]|0;e=k[c>>2]|0;k[c>>2]=e+1;i[e>>0]=-40;e=c+4|0;d=(k[e>>2]|0)+-1|0;k[e>>2]=d;if((d|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}if(k[a+88>>2]|0)qk(a,0)|0;if(k[a+92>>2]|0)qk(a,1)|0;if(k[a+96>>2]|0)qk(a,2)|0;if(k[a+100>>2]|0)qk(a,3)|0;if(!(k[a+212>>2]|0)){if(k[a+120>>2]|0)rk(a,0,0);if(k[a+136>>2]|0)rk(a,0,1);if(k[a+124>>2]|0)rk(a,1,0);if(k[a+140>>2]|0)rk(a,1,1);if(k[a+128>>2]|0)rk(a,2,0);if(k[a+144>>2]|0)rk(a,2,1);if(k[a+132>>2]|0)rk(a,3,0);if(k[a+148>>2]|0)rk(a,3,1)}c=k[b>>2]|0;d=k[c>>2]|0;k[c>>2]=d+1;i[d>>0]=-1;d=c+4|0;e=(k[d>>2]|0)+-1|0;k[d>>2]=e;if((e|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}c=k[b>>2]|0;b=k[c>>2]|0;k[c>>2]=b+1;i[b>>0]=-39;b=c+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;if(e)return;if(ub[k[c+12>>2]&63](a)|0)return;c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a);return}function ok(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;if(c>>>0>65533){d=k[a>>2]|0;k[d+20>>2]=12;qb[k[d>>2]&127](a)}d=a+24|0;e=k[d>>2]|0;f=k[e>>2]|0;k[e>>2]=f+1;i[f>>0]=-1;f=e+4|0;g=(k[f>>2]|0)+-1|0;k[f>>2]=g;if((g|0)==0?(ub[k[e+12>>2]&63](a)|0)==0:0){e=k[a>>2]|0;k[e+20>>2]=25;qb[k[e>>2]&127](a)}e=k[d>>2]|0;g=k[e>>2]|0;k[e>>2]=g+1;i[g>>0]=b;b=e+4|0;g=(k[b>>2]|0)+-1|0;k[b>>2]=g;if((g|0)==0?(ub[k[e+12>>2]&63](a)|0)==0:0){e=k[a>>2]|0;k[e+20>>2]=25;qb[k[e>>2]&127](a)}e=c+2|0;c=k[d>>2]|0;g=k[c>>2]|0;k[c>>2]=g+1;i[g>>0]=e>>>8;g=c+4|0;b=(k[g>>2]|0)+-1|0;k[g>>2]=b;if((b|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}c=k[d>>2]|0;d=k[c>>2]|0;k[c>>2]=d+1;i[d>>0]=e;e=c+4|0;d=(k[e>>2]|0)+-1|0;k[e>>2]=d;if(d)return;if(ub[k[c+12>>2]&63](a)|0)return;c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a);return}function pk(a,b){a=a|0;b=b|0;var c=0,d=0;c=k[a+24>>2]|0;d=k[c>>2]|0;k[c>>2]=d+1;i[d>>0]=b;b=c+4|0;d=(k[b>>2]|0)+-1|0;k[b>>2]=d;if(d)return;if(ub[k[c+12>>2]&63](a)|0)return;c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a);return}function qk(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,l=0,n=0,o=0,p=0,q=0;c=k[a+88+(b<<2)>>2]|0;if(!c){d=k[a>>2]|0;k[d+20>>2]=54;k[d+24>>2]=b;qb[k[d>>2]&127](a)}d=a+388|0;e=k[d>>2]|0;if((e|0)<0)f=0;else{g=k[a+384>>2]|0;h=0;l=0;while(1){n=(m[c+(k[g+(h<<2)>>2]<<1)>>1]|0)>255?1:l;if((h|0)<(e|0)){h=h+1|0;l=n}else{f=n;break}}}l=c+128|0;if(k[l>>2]|0)return f|0;h=a+24|0;e=k[h>>2]|0;g=k[e>>2]|0;k[e>>2]=g+1;i[g>>0]=-1;g=e+4|0;n=(k[g>>2]|0)+-1|0;k[g>>2]=n;if((n|0)==0?(ub[k[e+12>>2]&63](a)|0)==0:0){e=k[a>>2]|0;k[e+20>>2]=25;qb[k[e>>2]&127](a)}e=k[h>>2]|0;n=k[e>>2]|0;k[e>>2]=n+1;i[n>>0]=-37;n=e+4|0;g=(k[n>>2]|0)+-1|0;k[n>>2]=g;if((g|0)==0?(ub[k[e+12>>2]&63](a)|0)==0:0){e=k[a>>2]|0;k[e+20>>2]=25;qb[k[e>>2]&127](a)}e=(f|0)!=0;g=k[d>>2]|0;n=(e?(g<<1)+2|0:g+1|0)+3|0;g=k[h>>2]|0;o=k[g>>2]|0;k[g>>2]=o+1;i[o>>0]=n>>>8;o=g+4|0;p=(k[o>>2]|0)+-1|0;k[o>>2]=p;if((p|0)==0?(ub[k[g+12>>2]&63](a)|0)==0:0){g=k[a>>2]|0;k[g+20>>2]=25;qb[k[g>>2]&127](a)}g=k[h>>2]|0;p=k[g>>2]|0;k[g>>2]=p+1;i[p>>0]=n;n=g+4|0;p=(k[n>>2]|0)+-1|0;k[n>>2]=p;if((p|0)==0?(ub[k[g+12>>2]&63](a)|0)==0:0){g=k[a>>2]|0;k[g+20>>2]=25;qb[k[g>>2]&127](a)}g=k[h>>2]|0;p=k[g>>2]|0;k[g>>2]=p+1;i[p>>0]=(f<<4)+b;b=g+4|0;p=(k[b>>2]|0)+-1|0;k[b>>2]=p;if((p|0)==0?(ub[k[g+12>>2]&63](a)|0)==0:0){g=k[a>>2]|0;k[g+20>>2]=25;qb[k[g>>2]&127](a)}a:do if((k[d>>2]|0)>=0){g=a+384|0;if(e)q=0;else{p=0;while(1){b=k[h>>2]|0;n=j[c+(k[(k[g>>2]|0)+(p<<2)>>2]<<1)>>1]&255;o=k[b>>2]|0;k[b>>2]=o+1;i[o>>0]=n;n=b+4|0;o=(k[n>>2]|0)+-1|0;k[n>>2]=o;if((o|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}if((p|0)<(k[d>>2]|0))p=p+1|0;else break a}}while(1){p=j[c+(k[(k[g>>2]|0)+(q<<2)>>2]<<1)>>1]|0;b=k[h>>2]|0;o=k[b>>2]|0;k[b>>2]=o+1;i[o>>0]=(p&65535)>>>8;o=b+4|0;n=(k[o>>2]|0)+-1|0;k[o>>2]=n;if((n|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=k[h>>2]|0;n=k[b>>2]|0;k[b>>2]=n+1;i[n>>0]=p;p=b+4|0;n=(k[p>>2]|0)+-1|0;k[p>>2]=n;if((n|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}if((q|0)<(k[d>>2]|0))q=q+1|0;else break}}while(0);k[l>>2]=1;return f|0}function rk(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,j=0,m=0;d=(c|0)==0;c=d?b:b+16|0;e=k[(d?a+120+(b<<2)|0:a+136+(b<<2)|0)>>2]|0;if(!e){b=k[a>>2]|0;k[b+20>>2]=52;k[b+24>>2]=c;qb[k[b>>2]&127](a)}b=e+276|0;if(k[b>>2]|0)return;d=a+24|0;f=k[d>>2]|0;g=k[f>>2]|0;k[f>>2]=g+1;i[g>>0]=-1;g=f+4|0;h=(k[g>>2]|0)+-1|0;k[g>>2]=h;if((h|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[d>>2]|0;h=k[f>>2]|0;k[f>>2]=h+1;i[h>>0]=-60;h=f+4|0;g=(k[h>>2]|0)+-1|0;k[h>>2]=g;if((g|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=(l[e+16>>0]|0)+((l[e+15>>0]|0)+((l[e+14>>0]|0)+((l[e+13>>0]|0)+((l[e+12>>0]|0)+((l[e+11>>0]|0)+((l[e+10>>0]|0)+((l[e+9>>0]|0)+((l[e+8>>0]|0)+((l[e+7>>0]|0)+((l[e+6>>0]|0)+((l[e+5>>0]|0)+((l[e+4>>0]|0)+((l[e+3>>0]|0)+((l[e+2>>0]|0)+(l[e+1>>0]|0)))))))))))))))|0;g=f+19|0;h=k[d>>2]|0;j=k[h>>2]|0;k[h>>2]=j+1;i[j>>0]=g>>>8;j=h+4|0;m=(k[j>>2]|0)+-1|0;k[j>>2]=m;if((m|0)==0?(ub[k[h+12>>2]&63](a)|0)==0:0){h=k[a>>2]|0;k[h+20>>2]=25;qb[k[h>>2]&127](a)}h=k[d>>2]|0;m=k[h>>2]|0;k[h>>2]=m+1;i[m>>0]=g;g=h+4|0;m=(k[g>>2]|0)+-1|0;k[g>>2]=m;if((m|0)==0?(ub[k[h+12>>2]&63](a)|0)==0:0){h=k[a>>2]|0;k[h+20>>2]=25;qb[k[h>>2]&127](a)}h=k[d>>2]|0;m=k[h>>2]|0;k[h>>2]=m+1;i[m>>0]=c;c=h+4|0;m=(k[c>>2]|0)+-1|0;k[c>>2]=m;if((m|0)==0?(ub[k[h+12>>2]&63](a)|0)==0:0){h=k[a>>2]|0;k[h+20>>2]=25;qb[k[h>>2]&127](a)}h=1;do{m=i[e+h>>0]|0;c=k[d>>2]|0;g=k[c>>2]|0;k[c>>2]=g+1;i[g>>0]=m;m=c+4|0;g=(k[m>>2]|0)+-1|0;k[m>>2]=g;if((g|0)==0?(ub[k[c+12>>2]&63](a)|0)==0:0){c=k[a>>2]|0;k[c+20>>2]=25;qb[k[c>>2]&127](a)}h=h+1|0}while((h|0)!=17);if((f|0)>0){h=0;do{c=i[e+17+h>>0]|0;g=k[d>>2]|0;m=k[g>>2]|0;k[g>>2]=m+1;i[m>>0]=c;c=g+4|0;m=(k[c>>2]|0)+-1|0;k[c>>2]=m;if((m|0)==0?(ub[k[g+12>>2]&63](a)|0)==0:0){g=k[a>>2]|0;k[g+20>>2]=25;qb[k[g>>2]&127](a)}h=h+1|0}while((h|0)!=(f|0))}k[b>>2]=1;return}function sk(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0;c=a+24|0;d=k[c>>2]|0;e=k[d>>2]|0;k[d>>2]=e+1;i[e>>0]=-1;e=d+4|0;f=(k[e>>2]|0)+-1|0;k[e>>2]=f;if((f|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=k[c>>2]|0;f=k[d>>2]|0;k[d>>2]=f+1;i[f>>0]=b;b=d+4|0;f=(k[b>>2]|0)+-1|0;k[b>>2]=f;if((f|0)==0?(ub[k[d+12>>2]&63](a)|0)==0:0){d=k[a>>2]|0;k[d+20>>2]=25;qb[k[d>>2]&127](a)}d=a+76|0;f=((k[d>>2]|0)*3|0)+8|0;b=k[c>>2]|0;e=k[b>>2]|0;k[b>>2]=e+1;i[e>>0]=f>>>8;e=b+4|0;g=(k[e>>2]|0)+-1|0;k[e>>2]=g;if((g|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=k[c>>2]|0;g=k[b>>2]|0;k[b>>2]=g+1;i[g>>0]=f;f=b+4|0;g=(k[f>>2]|0)+-1|0;k[f>>2]=g;if((g|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=a+68|0;if(!((k[b>>2]|0)<=65535?(k[a+64>>2]|0)<=65535:0)){g=k[a>>2]|0;k[g+20>>2]=42;k[g+24>>2]=65535;qb[k[g>>2]&127](a)}g=k[c>>2]|0;f=k[a+72>>2]&255;e=k[g>>2]|0;k[g>>2]=e+1;i[e>>0]=f;f=g+4|0;e=(k[f>>2]|0)+-1|0;k[f>>2]=e;if((e|0)==0?(ub[k[g+12>>2]&63](a)|0)==0:0){g=k[a>>2]|0;k[g+20>>2]=25;qb[k[g>>2]&127](a)}g=k[b>>2]|0;b=k[c>>2]|0;e=k[b>>2]|0;k[b>>2]=e+1;i[e>>0]=g>>>8;e=b+4|0;f=(k[e>>2]|0)+-1|0;k[e>>2]=f;if((f|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=k[c>>2]|0;f=k[b>>2]|0;k[b>>2]=f+1;i[f>>0]=g;g=b+4|0;f=(k[g>>2]|0)+-1|0;k[g>>2]=f;if((f|0)==0?(ub[k[b+12>>2]&63](a)|0)==0:0){b=k[a>>2]|0;k[b+20>>2]=25;qb[k[b>>2]&127](a)}b=k[a+64>>2]|0;f=k[c>>2]|0;g=k[f>>2]|0;k[f>>2]=g+1;i[g>>0]=b>>>8;g=f+4|0;e=(k[g>>2]|0)+-1|0;k[g>>2]=e;if((e|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;e=k[f>>2]|0;k[f>>2]=e+1;i[e>>0]=b;b=f+4|0;e=(k[b>>2]|0)+-1|0;k[b>>2]=e;if((e|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}f=k[c>>2]|0;e=k[d>>2]&255;b=k[f>>2]|0;k[f>>2]=b+1;i[b>>0]=e;e=f+4|0;b=(k[e>>2]|0)+-1|0;k[e>>2]=b;if((b|0)==0?(ub[k[f+12>>2]&63](a)|0)==0:0){f=k[a>>2]|0;k[f+20>>2]=25;qb[k[f>>2]&127](a)}if((k[d>>2]|0)<=0)return;f=0;b=k[a+84>>2]|0;while(1){e=k[c>>2]|0;g=k[b>>2]&255;h=k[e>>2]|0;k[e>>2]=h+1;i[h>>0]=g;g=e+4|0;h=(k[g>>2]|0)+-1|0;k[g>>2]=h;if((h|0)==0?(ub[k[e+12>>2]&63](a)|0)==0:0){e=k[a>>2]|0;k[e+20>>2]=25;qb[k[e>>2]&127](a)}e=k[c>>2]|0;h=(k[b+8>>2]<<4)+(k[b+12>>2]|0)&255;g=k[e>>2]|0;k[e>>2]=g+1;i[g>>0]=h;h=e+4|0;g=(k[h>>2]|0)+-1|0;k[h>>2]=g;if((g|0)==0?(ub[k[e+12>>2]&63](a)|0)==0:0){e=k[a>>2]|0;k[e+20>>2]=25;qb[k[e>>2]&127](a)}e=k[c>>2]|0;g=k[b+16>>2]&255;h=k[e>>2]|0;k[e>>2]=h+1;i[h>>0]=g;g=e+4|0;h=(k[g>>2]|0)+-1|0;k[g>>2]=h;if((h|0)==0?(ub[k[e+12>>2]&63](a)|0)==0:0){e=k[a>>2]|0;k[e+20>>2]=25;qb[k[e>>2]&127](a)}f=f+1|0;if((f|0)>=(k[d>>2]|0))break;else b=b+88|0}return}function tk(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0;b=a+28|0;if(!((k[b>>2]|0)>>>0<=16777215?(k[a+32>>2]|0)>>>0<=16777215:0)){c=k[a>>2]|0;k[c+20>>2]=42;k[c+24>>2]=65500;qb[k[c>>2]&127](a)}c=k[a+56>>2]|0;d=a+380|0;e=k[d>>2]|0;f=ha(e,k[a+60>>2]|0)|0;if(c>>>0>=f>>>0){g=ha(k[b>>2]|0,e)|0;k[a+64>>2]=g;g=ha(e,k[a+32>>2]|0)|0;k[a+68>>2]=g;k[a+280>>2]=1;k[a+284>>2]=1;return}if(c<<1>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,2)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,2)|0;k[a+68>>2]=g;k[a+280>>2]=2;k[a+284>>2]=2;return}if((c*3|0)>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,3)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,3)|0;k[a+68>>2]=g;k[a+280>>2]=3;k[a+284>>2]=3;return}if(c<<2>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,4)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,4)|0;k[a+68>>2]=g;k[a+280>>2]=4;k[a+284>>2]=4;return}if((c*5|0)>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,5)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,5)|0;k[a+68>>2]=g;k[a+280>>2]=5;k[a+284>>2]=5;return}if((c*6|0)>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,6)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,6)|0;k[a+68>>2]=g;k[a+280>>2]=6;k[a+284>>2]=6;return}if((c*7|0)>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,7)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,7)|0;k[a+68>>2]=g;k[a+280>>2]=7;k[a+284>>2]=7;return}if(c<<3>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,8)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,8)|0;k[a+68>>2]=g;k[a+280>>2]=8;k[a+284>>2]=8;return}if((c*9|0)>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,9)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,9)|0;k[a+68>>2]=g;k[a+280>>2]=9;k[a+284>>2]=9;return}if((c*10|0)>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,10)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,10)|0;k[a+68>>2]=g;k[a+280>>2]=10;k[a+284>>2]=10;return}if((c*11|0)>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,11)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,11)|0;k[a+68>>2]=g;k[a+280>>2]=11;k[a+284>>2]=11;return}if((c*12|0)>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,12)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,12)|0;k[a+68>>2]=g;k[a+280>>2]=12;k[a+284>>2]=12;return}if((c*13|0)>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,13)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,13)|0;k[a+68>>2]=g;k[a+280>>2]=13;k[a+284>>2]=13;return}if((c*14|0)>>>0>=f>>>0){g=pm(ha(k[b>>2]|0,e)|0,14)|0;k[a+64>>2]=g;g=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,14)|0;k[a+68>>2]=g;k[a+280>>2]=14;k[a+284>>2]=14;return}g=ha(k[b>>2]|0,e)|0;if((c*15|0)>>>0<f>>>0){f=pm(g,16)|0;k[a+64>>2]=f;f=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,16)|0;k[a+68>>2]=f;k[a+280>>2]=16;k[a+284>>2]=16;return}else{f=pm(g,15)|0;k[a+64>>2]=f;f=pm(ha(k[d>>2]|0,k[a+32>>2]|0)|0,15)|0;k[a+68>>2]=f;k[a+280>>2]=15;k[a+284>>2]=15;return}}function uk(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;c=r;r=r+2608|0;d=c+2560|0;e=c;f=nb[k[k[a+4>>2]>>2]&63](a,1,36)|0;k[a+392>>2]=f;k[f>>2]=35;k[f+4>>2]=36;k[f+8>>2]=37;k[f+16>>2]=0;g=(b|0)==0;if(g){tk(a);b=a+380|0;h=b;i=k[b>>2]|0}else{b=a+280|0;j=k[b>>2]|0;l=a+284|0;if((j|0)==(k[l>>2]|0))m=j;else{n=k[a>>2]|0;k[n+20>>2]=7;k[n+24>>2]=j;k[n+28>>2]=k[l>>2];qb[k[n>>2]&127](a);m=k[b>>2]|0}b=a+380|0;k[b>>2]=m;h=b;i=m}if((i+-1|0)>>>0>15){m=k[a>>2]|0;k[m+20>>2]=7;k[m+24>>2]=i;k[m+28>>2]=k[h>>2];qb[k[m>>2]&127](a);o=k[h>>2]|0}else o=i;switch(o|0){case 2:{k[a+384>>2]=121164;break}case 3:{k[a+384>>2]=121064;break}case 4:{k[a+384>>2]=120936;break}case 5:{k[a+384>>2]=120772;break}case 6:{k[a+384>>2]=120564;break}case 7:{k[a+384>>2]=120304;break}default:k[a+384>>2]=119984}o=k[h>>2]|0;i=(ha(o,o)|0)+-1|0;m=a+388|0;k[m>>2]=(o|0)<8?i:63;i=a+68|0;o=k[i>>2]|0;if(((o|0)!=0?(k[a+64>>2]|0)!=0:0)?(k[a+76>>2]|0)>=1:0)p=o;else{o=k[a>>2]|0;k[o+20>>2]=33;qb[k[o>>2]&127](a);p=k[i>>2]|0}if(!((p|0)<=65500?(k[a+64>>2]|0)<=65500:0)){p=k[a>>2]|0;k[p+20>>2]=42;k[p+24>>2]=65500;qb[k[p>>2]&127](a)}p=k[a+72>>2]|0;if((p+-8|0)>>>0>4){o=k[a>>2]|0;k[o+20>>2]=16;k[o+24>>2]=p;qb[k[o>>2]&127](a)}o=a+76|0;p=k[o>>2]|0;if((p|0)>10){b=k[a>>2]|0;k[b+20>>2]=27;k[b+24>>2]=p;k[b+28>>2]=10;qb[k[b>>2]&127](a);q=k[o>>2]|0}else q=p;p=a+272|0;k[p>>2]=1;b=a+276|0;k[b>>2]=1;n=a+84|0;if((q|0)>0){l=q;q=1;j=1;s=0;t=k[n>>2]|0;while(1){u=t+8|0;v=k[u>>2]|0;w=t+12|0;if((v+-1|0)>>>0<=3?(x=k[w>>2]|0,(x+-1|0)>>>0<=3):0){y=l;z=j;A=v;B=q;C=x}else{x=k[a>>2]|0;k[x+20>>2]=19;qb[k[x>>2]&127](a);y=k[o>>2]|0;z=k[p>>2]|0;A=k[u>>2]|0;B=k[b>>2]|0;C=k[w>>2]|0}j=(z|0)>(A|0)?z:A;k[p>>2]=j;w=(B|0)>(C|0)?B:C;k[b>>2]=w;s=s+1|0;if((s|0)>=(y|0)){D=y;E=w;break}else{l=y;q=w;t=t+88|0}}if((D|0)>0){D=a+280|0;t=a+224|0;q=a+284|0;y=a+64|0;l=0;s=k[n>>2]|0;while(1){k[s+4>>2]=l;n=k[D>>2]|0;C=(k[t>>2]|0)!=0?8:4;a:do if((n|0)>(C|0))F=1;else{B=k[p>>2]|0;j=k[s+8>>2]|0;A=1;while(1){z=A<<1;if((B|0)%(ha(z,j)|0)|0){F=A;break a}if((ha(z,n)|0)>(C|0)){F=z;break}else A=z}}while(0);A=ha(F,n)|0;j=s+36|0;k[j>>2]=A;B=k[q>>2]|0;b:do if((B|0)>(C|0))G=1;else{z=k[b>>2]|0;w=k[s+12>>2]|0;u=1;while(1){x=u<<1;if((z|0)%(ha(x,w)|0)|0){G=u;break b}if((ha(x,B)|0)>(C|0)){G=x;break}else u=x}}while(0);C=ha(G,B)|0;n=s+40|0;k[n>>2]=C;u=C<<1;if((A|0)<=(u|0)){w=A<<1;if((C|0)>(w|0))k[n>>2]=w}else k[j>>2]=u;u=s+8|0;w=ha(k[u>>2]|0,k[y>>2]|0)|0;C=pm(w,ha(k[h>>2]|0,k[p>>2]|0)|0)|0;k[s+28>>2]=C;C=s+12|0;w=ha(k[C>>2]|0,k[i>>2]|0)|0;z=pm(w,ha(k[h>>2]|0,k[b>>2]|0)|0)|0;k[s+32>>2]=z;z=ha(ha(k[u>>2]|0,k[y>>2]|0)|0,k[j>>2]|0)|0;u=pm(z,ha(k[h>>2]|0,k[p>>2]|0)|0)|0;k[s+44>>2]=u;u=ha(ha(k[C>>2]|0,k[i>>2]|0)|0,k[n>>2]|0)|0;n=pm(u,ha(k[h>>2]|0,k[b>>2]|0)|0)|0;k[s+48>>2]=n;k[s+52>>2]=0;l=l+1|0;if((l|0)>=(k[o>>2]|0))break;else s=s+88|0}H=k[b>>2]|0}else H=E}else H=1;E=pm(k[i>>2]|0,ha(k[h>>2]|0,H)|0)|0;k[a+288>>2]=E;E=a+204|0;H=k[E>>2]|0;if(H){h=a+200|0;if((k[h>>2]|0)<1){i=k[a>>2]|0;k[i+20>>2]=20;k[i+24>>2]=0;qb[k[i>>2]&127](a);I=k[E>>2]|0}else I=H;if((k[I+20>>2]|0)==0?(k[I+24>>2]|0)==63:0){k[a+268>>2]=0;H=k[o>>2]|0;if((H|0)>0){qr(d|0,0,((H|0)>1?H<<2:4)|0)|0;J=H;K=0}else{J=H;K=0}}else{k[a+268>>2]=1;H=k[o>>2]|0;if((H|0)>0){qr(e|0,-1,H<<8|0)|0;J=H;K=1}else{J=H;K=1}}if((k[h>>2]|0)<1){L=K;M=J}else{J=a+268|0;K=1;H=I;while(1){I=k[H>>2]|0;if((I+-1|0)>>>0>3){i=k[a>>2]|0;k[i+20>>2]=27;k[i+24>>2]=I;k[i+28>>2]=4;qb[k[i>>2]&127](a)}i=(I|0)>0;if(i){b=0;do{s=k[H+4+(b<<2)>>2]|0;if(!((s|0)>=0?(s|0)<(k[o>>2]|0):0)){l=k[a>>2]|0;k[l+20>>2]=20;k[l+24>>2]=K;qb[k[l>>2]&127](a)}do if((b|0)>0){if((s|0)>(k[H+4+(b+-1<<2)>>2]|0))break;l=k[a>>2]|0;k[l+20>>2]=20;k[l+24>>2]=K;qb[k[l>>2]&127](a)}while(0);b=b+1|0}while((b|0)!=(I|0))}b=k[H+20>>2]|0;j=k[H+24>>2]|0;A=k[H+28>>2]|0;B=k[H+32>>2]|0;do if(!(k[J>>2]|0)){if((j|0)!=63|(A|b|B|0)!=0){s=k[a>>2]|0;k[s+20>>2]=18;k[s+24>>2]=K;qb[k[s>>2]&127](a)}if(i){s=0;do{l=d+(k[H+4+(s<<2)>>2]<<2)|0;if(k[l>>2]|0){p=k[a>>2]|0;k[p+20>>2]=20;k[p+24>>2]=K;qb[k[p>>2]&127](a)}k[l>>2]=1;s=s+1|0}while((s|0)!=(I|0))}}else{if(!(b>>>0<=63?!(B>>>0>10|(A>>>0>10|((j|0)<(b|0)|(j|0)>63))):0)){s=k[a>>2]|0;k[s+20>>2]=18;k[s+24>>2]=K;qb[k[s>>2]&127](a)}s=(b|0)==0;do if(s){if(!j)break;l=k[a>>2]|0;k[l+20>>2]=18;k[l+24>>2]=K;qb[k[l>>2]&127](a)}else{if((I|0)==1)break;l=k[a>>2]|0;k[l+20>>2]=18;k[l+24>>2]=K;qb[k[l>>2]&127](a)}while(0);if(!i)break;l=(A|0)==0;p=(B|0)==(A+-1|0);y=0;do{G=k[H+4+(y<<2)>>2]|0;do if(s)N=0;else{if((k[e+(G<<8)>>2]|0)>=0){N=b;break}q=k[a>>2]|0;k[q+20>>2]=18;k[q+24>>2]=K;qb[k[q>>2]&127](a);N=b}while(0);c:do if((N|0)<=(j|0)){if(!p){if(l)O=N;else{q=N;while(1){F=k[a>>2]|0;k[F+20>>2]=18;k[F+24>>2]=K;qb[k[F>>2]&127](a);k[e+(G<<8)+(q<<2)>>2]=B;if((q|0)<(j|0))q=q+1|0;else break c}}while(1){q=e+(G<<8)+(O<<2)|0;if((k[q>>2]|0)>=0){F=k[a>>2]|0;k[F+20>>2]=18;k[F+24>>2]=K;qb[k[F>>2]&127](a)}k[q>>2]=B;if((O|0)<(j|0))O=O+1|0;else break c}}if(l){q=N;while(1){F=e+(G<<8)+(q<<2)|0;if((k[F>>2]|0)>=1){t=k[a>>2]|0;k[t+20>>2]=18;k[t+24>>2]=K;qb[k[t>>2]&127](a)}k[F>>2]=B;if((q|0)<(j|0))q=q+1|0;else break c}}else P=N;while(1){q=e+(G<<8)+(P<<2)|0;F=k[q>>2]|0;do if((F|0)<0){t=k[a>>2]|0;k[t+20>>2]=18;k[t+24>>2]=K;qb[k[t>>2]&127](a)}else{if((A|0)==(F|0))break;t=k[a>>2]|0;k[t+20>>2]=18;k[t+24>>2]=K;qb[k[t>>2]&127](a)}while(0);k[q>>2]=B;if((P|0)<(j|0))P=P+1|0;else break}}while(0);y=y+1|0}while((y|0)!=(I|0))}while(0);if((K|0)<(k[h>>2]|0)){K=K+1|0;H=H+36|0}else break}L=k[J>>2]|0;M=k[o>>2]|0}J=(M|0)>0;if(!L){if(J){L=M;H=0;while(1){if(!(k[d+(H<<2)>>2]|0)){K=k[a>>2]|0;k[K+20>>2]=46;qb[k[K>>2]&127](a);Q=k[o>>2]|0}else Q=L;H=H+1|0;if((H|0)>=(Q|0))break;else L=Q}}}else if(J){J=M;M=0;while(1){if((k[e+(M<<8)>>2]|0)<0){Q=k[a>>2]|0;k[Q+20>>2]=46;qb[k[Q>>2]&127](a);R=k[o>>2]|0}else R=J;M=M+1|0;if((M|0)>=(R|0))break;else J=R}}if((k[a+380>>2]|0)<8){R=k[E>>2]|0;if((k[h>>2]|0)>0){E=0;J=0;while(1){if((E|0)!=(J|0)){M=R+(J*36|0)|0;o=R+(E*36|0)|0;e=M+36|0;do{k[M>>2]=k[o>>2];M=M+4|0;o=o+4|0}while((M|0)<(e|0))}o=k[m>>2]|0;if((k[R+(J*36|0)+20>>2]|0)>(o|0))S=J;else{M=R+(J*36|0)+24|0;if((k[M>>2]|0)>(o|0))k[M>>2]=o;S=J+1|0}E=E+1|0;if((E|0)>=(k[h>>2]|0)){T=S;break}else J=S}}else T=0;k[h>>2]=T}}else{k[a+268>>2]=0;k[a+200>>2]=1}T=a+216|0;h=k[T>>2]|0;S=a+212|0;do if(!h)if(!(k[S>>2]|0)){if((k[a+268>>2]|0)==0?((k[a+380>>2]|0)+-2|0)>>>0>=6:0){U=0;break}k[T>>2]=1;U=1}else U=0;else{k[S>>2]=0;U=h}while(0);do if(!g){h=f+20|0;if(!U){k[h>>2]=2;break}else{k[h>>2]=1;break}}else k[f+20>>2]=0;while(0);k[f+32>>2]=0;k[f+24>>2]=0;g=k[a+200>>2]|0;if(!U){k[f+28>>2]=g;r=c;return}else{k[f+28>>2]=g<<1;r=c;return}}function vk(a){a=a|0;var b=0,c=0,d=0,e=0,f=0;b=k[a+392>>2]|0;c=b+20|0;a:do switch(k[c>>2]|0){case 0:{yk(a);zk(a);if(!(k[a+208>>2]|0)){qb[k[k[a+412>>2]>>2]&127](a);qb[k[k[a+416>>2]>>2]&127](a);rb[k[k[a+400>>2]>>2]&31](a,0)}qb[k[k[a+420>>2]>>2]&127](a);d=a+216|0;rb[k[k[a+424>>2]>>2]&31](a,k[d>>2]|0);rb[k[k[a+404>>2]>>2]&31](a,(k[b+28>>2]|0)>1?3:0);rb[k[k[a+396>>2]>>2]&31](a,0);e=b+12|0;if(!(k[d>>2]|0)){k[e>>2]=1;break a}else{k[e>>2]=0;break a}break}case 1:{yk(a);zk(a);if((k[a+364>>2]|0)==0?(k[a+372>>2]|0)!=0:0){k[c>>2]=2;e=b+24|0;k[e>>2]=(k[e>>2]|0)+1;f=11;break a}rb[k[k[a+424>>2]>>2]&31](a,1);rb[k[k[a+404>>2]>>2]&31](a,2);k[b+12>>2]=0;break}case 2:{f=11;break}default:{e=k[a>>2]|0;k[e+20>>2]=49;qb[k[e>>2]&127](a)}}while(0);if((f|0)==11){if(!(k[a+216>>2]|0)){yk(a);zk(a)}rb[k[k[a+424>>2]>>2]&31](a,0);rb[k[k[a+404>>2]>>2]&31](a,2);f=a+408|0;if(!(k[b+32>>2]|0))qb[k[(k[f>>2]|0)+4>>2]&127](a);qb[k[(k[f>>2]|0)+8>>2]&127](a);k[b+12>>2]=0}f=k[b+24>>2]|0;c=k[b+28>>2]|0;k[b+16>>2]=(f|0)==(c+-1|0)&1;b=k[a+8>>2]|0;if(!b)return;k[b+12>>2]=f;k[b+16>>2]=c;return}function wk(a){a=a|0;var b=0;k[(k[a+392>>2]|0)+12>>2]=0;b=a+408|0;qb[k[(k[b>>2]|0)+4>>2]&127](a);qb[k[(k[b>>2]|0)+8>>2]&127](a);return}function xk(a){a=a|0;var b=0,c=0,d=0;b=k[a+392>>2]|0;qb[k[(k[a+424>>2]|0)+8>>2]&127](a);c=b+20|0;switch(k[c>>2]|0){case 0:{k[c>>2]=2;if(!(k[a+216>>2]|0)){d=b+32|0;k[d>>2]=(k[d>>2]|0)+1}break}case 1:{k[c>>2]=2;break}case 2:{if(k[a+216>>2]|0)k[c>>2]=1;c=b+32|0;k[c>>2]=(k[c>>2]|0)+1;break}default:{}}c=b+24|0;k[c>>2]=(k[c>>2]|0)+1;return}function yk(a){a=a|0;var b=0,c=0,d=0,e=0,f=0;b=k[a+204>>2]|0;if(!b){c=a+76|0;d=k[c>>2]|0;if((d|0)>4){e=k[a>>2]|0;k[e+20>>2]=27;k[e+24>>2]=d;k[e+28>>2]=4;qb[k[e>>2]&127](a);f=k[c>>2]|0}else f=d;k[a+292>>2]=f;if((f|0)>0){f=a+84|0;d=0;do{k[a+296+(d<<2)>>2]=(k[f>>2]|0)+(d*88|0);d=d+1|0}while((d|0)<(k[c>>2]|0))}}else{c=k[(k[a+392>>2]|0)+32>>2]|0;d=k[b+(c*36|0)>>2]|0;k[a+292>>2]=d;if((d|0)>0){f=a+84|0;e=0;do{k[a+296+(e<<2)>>2]=(k[f>>2]|0)+((k[b+(c*36|0)+4+(e<<2)>>2]|0)*88|0);e=e+1|0}while((e|0)<(d|0))}if(k[a+268>>2]|0){k[a+364>>2]=k[b+(c*36|0)+20>>2];k[a+368>>2]=k[b+(c*36|0)+24>>2];k[a+372>>2]=k[b+(c*36|0)+28>>2];k[a+376>>2]=k[b+(c*36|0)+32>>2];return}}k[a+364>>2]=0;c=k[a+380>>2]|0;b=(ha(c,c)|0)+-1|0;k[a+368>>2]=b;k[a+372>>2]=0;k[a+376>>2]=0;return}function zk(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0;b=a+292|0;c=k[b>>2]|0;a:do if((c|0)!=1){if((c+-1|0)>>>0>3){d=k[a>>2]|0;k[d+20>>2]=27;k[d+24>>2]=c;k[d+28>>2]=4;qb[k[d>>2]&127](a)}d=a+380|0;e=pm(k[a+64>>2]|0,ha(k[d>>2]|0,k[a+272>>2]|0)|0)|0;k[a+312>>2]=e;e=pm(k[a+68>>2]|0,ha(k[d>>2]|0,k[a+276>>2]|0)|0)|0;k[a+316>>2]=e;e=a+320|0;k[e>>2]=0;if((k[b>>2]|0)>0){d=0;f=0;while(1){g=k[a+296+(f<<2)>>2]|0;h=k[g+8>>2]|0;k[g+56>>2]=h;i=k[g+12>>2]|0;k[g+60>>2]=i;j=ha(h,i)|0;k[g+64>>2]=j;l=ha(k[g+36>>2]|0,h)|0;k[g+68>>2]=l;l=((k[g+28>>2]|0)>>>0)%(h>>>0)|0;k[g+72>>2]=(l|0)==0?h:l;l=((k[g+32>>2]|0)>>>0)%(i>>>0)|0;k[g+76>>2]=(l|0)==0?i:l;if((d+j|0)>10){l=k[a>>2]|0;k[l+20>>2]=14;qb[k[l>>2]&127](a)}if((j|0)>0){l=j;while(1){j=k[e>>2]|0;k[e>>2]=j+1;k[a+324+(j<<2)>>2]=f;if((l|0)>1)l=l+-1|0;else break}}l=f+1|0;if((l|0)>=(k[b>>2]|0))break a;d=k[e>>2]|0;f=l}}}else{f=k[a+296>>2]|0;k[a+312>>2]=k[f+28>>2];e=k[f+32>>2]|0;k[a+316>>2]=e;k[f+56>>2]=1;k[f+60>>2]=1;k[f+64>>2]=1;k[f+68>>2]=k[f+36>>2];k[f+72>>2]=1;d=k[f+12>>2]|0;l=(e>>>0)%(d>>>0)|0;k[f+76>>2]=(l|0)==0?d:l;k[a+320>>2]=1;k[a+324>>2]=0}while(0);b=k[a+240>>2]|0;if((b|0)<=0)return;c=ha(k[a+312>>2]|0,b)|0;k[a+236>>2]=(c|0)<65535?c:65535;return}function Ak(a){a=a|0;var b=0;b=k[a+4>>2]|0;if(!b)return;rb[k[b+36>>2]&31](a,1);b=a+20|0;if(!(k[a+16>>2]|0)){k[b>>2]=100;return}else{k[b>>2]=200;k[a+312>>2]=0;return}}function Bk(a){a=a|0;var b=0,c=0;b=a+4|0;c=k[b>>2]|0;if(c)qb[k[c+40>>2]&127](a);k[b>>2]=0;k[a+20>>2]=0;return}function Ck(a){a=a|0;var b=0;b=nb[k[k[a+4>>2]>>2]&63](a,0,132)|0;k[b+128>>2]=0;return b|0}function Dk(a){a=a|0;var b=0;b=nb[k[k[a+4>>2]>>2]&63](a,0,280)|0;k[b+276>>2]=0;return b|0}function Ek(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,l=0;d=a+20|0;e=k[d>>2]|0;if((e|0)!=100){f=k[a>>2]|0;k[f+20>>2]=21;k[f+24>>2]=e;qb[k[f>>2]&127](a)}f=a+88|0;e=k[f>>2]|0;if(!e){g=Ck(a)|0;k[f>>2]=g;h=g}else h=e;e=(c|0)==0;if(e){c=0;do{g=((ha(k[118948+(c<<2)>>2]|0,b)|0)+50|0)/100|0;f=(g|0)<1?1:g;j[h+(c<<1)>>1]=(f|0)>32767?32767:f&65535;c=c+1|0}while((c|0)!=64)}else{c=0;do{f=((ha(k[118948+(c<<2)>>2]|0,b)|0)+50|0)/100|0;g=(f|0)<1?1:f;f=(g|0)>32767?32767:g;j[h+(c<<1)>>1]=(f|0)>255?255:f&65535;c=c+1|0}while((c|0)!=64)}k[h+128>>2]=0;h=k[d>>2]|0;if((h|0)!=100){d=k[a>>2]|0;k[d+20>>2]=21;k[d+24>>2]=h;qb[k[d>>2]&127](a)}d=a+92|0;h=k[d>>2]|0;if(!h){c=Ck(a)|0;k[d>>2]=c;i=c}else i=h;if(e){e=0;do{h=((ha(k[119204+(e<<2)>>2]|0,b)|0)+50|0)/100|0;c=(h|0)<1?1:h;j[i+(e<<1)>>1]=(c|0)>32767?32767:c&65535;e=e+1|0}while((e|0)!=64);l=i+128|0;k[l>>2]=0;return}else{e=0;do{c=((ha(k[119204+(e<<2)>>2]|0,b)|0)+50|0)/100|0;h=(c|0)<1?1:c;c=(h|0)>32767?32767:h;j[i+(e<<1)>>1]=(c|0)>255?255:c&65535;e=e+1|0}while((e|0)!=64);l=i+128|0;k[l>>2]=0;return}}function Fk(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=(b|0)<1?1:b;b=(d|0)>100?100:d;if((b|0)<50)e=5e3/(b|0)|0;else e=200-(b<<1)|0;Ek(a,e,c);return}
function Gk(a){a=a|0;var b=0,c=0;b=k[a+20>>2]|0;if((b|0)!=100){c=k[a>>2]|0;k[c+20>>2]=21;k[c+24>>2]=b;qb[k[c>>2]&127](a)}c=a+84|0;if(!(k[c>>2]|0)){b=nb[k[k[a+4>>2]>>2]&63](a,0,880)|0;k[c>>2]=b}k[a+56>>2]=1;k[a+60>>2]=1;b=a+72|0;k[b>>2]=8;Ek(a,50,1);Jk(a,a+120|0,155857,155874);Jk(a,a+136|0,155886,155903);Jk(a,a+124|0,156065,156082);Jk(a,a+140|0,156094,156111);i[a+152>>0]=0;i[a+168>>0]=1;i[a+184>>0]=5;i[a+153>>0]=0;i[a+169>>0]=1;i[a+185>>0]=5;i[a+154>>0]=0;i[a+170>>0]=1;i[a+186>>0]=5;i[a+155>>0]=0;i[a+171>>0]=1;i[a+187>>0]=5;i[a+156>>0]=0;i[a+172>>0]=1;i[a+188>>0]=5;i[a+157>>0]=0;i[a+173>>0]=1;i[a+189>>0]=5;i[a+158>>0]=0;i[a+174>>0]=1;i[a+190>>0]=5;i[a+159>>0]=0;i[a+175>>0]=1;i[a+191>>0]=5;i[a+160>>0]=0;i[a+176>>0]=1;i[a+192>>0]=5;i[a+161>>0]=0;i[a+177>>0]=1;i[a+193>>0]=5;i[a+162>>0]=0;i[a+178>>0]=1;i[a+194>>0]=5;i[a+163>>0]=0;i[a+179>>0]=1;i[a+195>>0]=5;i[a+164>>0]=0;i[a+180>>0]=1;i[a+196>>0]=5;i[a+165>>0]=0;i[a+181>>0]=1;i[a+197>>0]=5;i[a+166>>0]=0;i[a+182>>0]=1;i[a+198>>0]=5;i[a+167>>0]=0;i[a+183>>0]=1;i[a+199>>0]=5;k[a+204>>2]=0;k[a+200>>2]=0;k[a+208>>2]=0;k[a+212>>2]=(k[b>>2]|0)>8&1;k[a+216>>2]=0;k[a+220>>2]=0;k[a+224>>2]=1;b=a+228|0;k[b>>2]=0;k[b+4>>2]=0;k[b+8>>2]=0;k[b+12>>2]=0;i[a+248>>0]=1;i[a+249>>0]=1;i[a+250>>0]=0;j[a+252>>1]=1;j[a+254>>1]=1;k[a+260>>2]=0;Hk(a);return}function Hk(a){a=a|0;var b=0,c=0,d=0,e=0;switch(k[a+40>>2]|0){case 0:{b=k[a+20>>2]|0;if((b|0)!=100){c=k[a>>2]|0;k[c+20>>2]=21;k[c+24>>2]=b;qb[k[c>>2]&127](a)}k[a+80>>2]=0;k[a+244>>2]=0;k[a+256>>2]=0;c=k[a+36>>2]|0;b=a+76|0;k[b>>2]=c;if((c+-1|0)>>>0>9){d=k[a>>2]|0;k[d+20>>2]=27;k[d+24>>2]=c;k[d+28>>2]=10;qb[k[d>>2]&127](a);e=k[b>>2]|0}else e=c;if((e|0)<=0)return;c=k[a+84>>2]|0;b=0;do{k[c+(b*88|0)>>2]=b;k[c+(b*88|0)+8>>2]=1;k[c+(b*88|0)+12>>2]=1;k[c+(b*88|0)+16>>2]=0;k[c+(b*88|0)+20>>2]=0;k[c+(b*88|0)+24>>2]=0;b=b+1|0}while((b|0)!=(e|0));return}case 1:{e=k[a+20>>2]|0;if((e|0)!=100){b=k[a>>2]|0;k[b+20>>2]=21;k[b+24>>2]=e;qb[k[b>>2]&127](a)}k[a+80>>2]=1;k[a+256>>2]=0;k[a+244>>2]=1;k[a+76>>2]=1;b=k[a+84>>2]|0;k[b>>2]=1;k[b+8>>2]=1;k[b+12>>2]=1;k[b+16>>2]=0;k[b+20>>2]=0;k[b+24>>2]=0;return}case 2:{b=k[a+20>>2]|0;if((b|0)!=100){e=k[a>>2]|0;k[e+20>>2]=21;k[e+24>>2]=b;qb[k[e>>2]&127](a)}k[a+80>>2]=3;k[a+256>>2]=0;k[a+244>>2]=1;k[a+76>>2]=3;e=k[a+84>>2]|0;k[e>>2]=1;k[e+8>>2]=2;k[e+12>>2]=2;k[e+16>>2]=0;k[e+20>>2]=0;k[e+24>>2]=0;k[e+88>>2]=2;k[e+96>>2]=1;k[e+100>>2]=1;k[e+104>>2]=1;k[e+108>>2]=1;k[e+112>>2]=1;k[e+176>>2]=3;k[e+184>>2]=1;k[e+188>>2]=1;k[e+192>>2]=1;k[e+196>>2]=1;k[e+200>>2]=1;return}case 3:{e=k[a+20>>2]|0;if((e|0)!=100){b=k[a>>2]|0;k[b+20>>2]=21;k[b+24>>2]=e;qb[k[b>>2]&127](a)}k[a+80>>2]=3;k[a+256>>2]=0;k[a+244>>2]=1;k[a+76>>2]=3;b=k[a+84>>2]|0;k[b>>2]=1;k[b+8>>2]=2;k[b+12>>2]=2;k[b+16>>2]=0;k[b+20>>2]=0;k[b+24>>2]=0;k[b+88>>2]=2;k[b+96>>2]=1;k[b+100>>2]=1;k[b+104>>2]=1;k[b+108>>2]=1;k[b+112>>2]=1;k[b+176>>2]=3;k[b+184>>2]=1;k[b+188>>2]=1;k[b+192>>2]=1;k[b+196>>2]=1;k[b+200>>2]=1;return}case 4:{b=k[a+20>>2]|0;if((b|0)!=100){e=k[a>>2]|0;k[e+20>>2]=21;k[e+24>>2]=b;qb[k[e>>2]&127](a)}k[a+80>>2]=4;k[a+244>>2]=0;k[a+256>>2]=1;k[a+76>>2]=4;e=k[a+84>>2]|0;k[e>>2]=67;k[e+8>>2]=1;k[e+12>>2]=1;k[e+16>>2]=0;k[e+20>>2]=0;k[e+24>>2]=0;k[e+88>>2]=77;k[e+96>>2]=1;k[e+100>>2]=1;k[e+104>>2]=0;k[e+108>>2]=0;k[e+112>>2]=0;k[e+176>>2]=89;k[e+184>>2]=1;k[e+188>>2]=1;k[e+192>>2]=0;k[e+196>>2]=0;k[e+200>>2]=0;k[e+264>>2]=75;k[e+272>>2]=1;k[e+276>>2]=1;k[e+280>>2]=0;k[e+284>>2]=0;k[e+288>>2]=0;return}case 5:{e=k[a+20>>2]|0;if((e|0)!=100){b=k[a>>2]|0;k[b+20>>2]=21;k[b+24>>2]=e;qb[k[b>>2]&127](a)}k[a+80>>2]=5;k[a+244>>2]=0;k[a+256>>2]=1;k[a+76>>2]=4;b=k[a+84>>2]|0;k[b>>2]=1;k[b+8>>2]=2;k[b+12>>2]=2;k[b+16>>2]=0;k[b+20>>2]=0;k[b+24>>2]=0;k[b+88>>2]=2;k[b+96>>2]=1;k[b+100>>2]=1;k[b+104>>2]=1;k[b+108>>2]=1;k[b+112>>2]=1;k[b+176>>2]=3;k[b+184>>2]=1;k[b+188>>2]=1;k[b+192>>2]=1;k[b+196>>2]=1;k[b+200>>2]=1;k[b+264>>2]=4;k[b+272>>2]=2;k[b+276>>2]=2;k[b+280>>2]=0;k[b+284>>2]=0;k[b+288>>2]=0;return}case 6:{b=k[a+20>>2]|0;if((b|0)!=100){e=k[a>>2]|0;k[e+20>>2]=21;k[e+24>>2]=b;qb[k[e>>2]&127](a)}k[a+80>>2]=6;k[a+256>>2]=0;k[a+244>>2]=1;i[a+248>>0]=2;k[a+76>>2]=3;e=k[a+84>>2]|0;k[e>>2]=114;k[e+8>>2]=1;k[e+12>>2]=1;k[e+16>>2]=0;b=(k[a+260>>2]|0)==1&1;k[e+20>>2]=b;k[e+24>>2]=b;k[e+88>>2]=103;k[e+96>>2]=1;k[e+100>>2]=1;k[e+104>>2]=0;k[e+108>>2]=0;k[e+112>>2]=0;k[e+176>>2]=98;k[e+184>>2]=1;k[e+188>>2]=1;k[e+192>>2]=0;k[e+196>>2]=b;k[e+200>>2]=b;return}case 7:{b=k[a+20>>2]|0;if((b|0)!=100){e=k[a>>2]|0;k[e+20>>2]=21;k[e+24>>2]=b;qb[k[e>>2]&127](a)}k[a+80>>2]=7;k[a+256>>2]=0;k[a+244>>2]=1;i[a+248>>0]=2;k[a+76>>2]=3;e=k[a+84>>2]|0;k[e>>2]=1;k[e+8>>2]=2;k[e+12>>2]=2;k[e+16>>2]=0;k[e+20>>2]=0;k[e+24>>2]=0;k[e+88>>2]=34;k[e+96>>2]=1;k[e+100>>2]=1;k[e+104>>2]=1;k[e+108>>2]=1;k[e+112>>2]=1;k[e+176>>2]=35;k[e+184>>2]=1;k[e+188>>2]=1;k[e+192>>2]=1;k[e+196>>2]=1;k[e+200>>2]=1;return}default:{e=k[a>>2]|0;k[e+20>>2]=10;qb[k[e>>2]&127](a);return}}}function Ik(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=k[a+20>>2]|0;if((c|0)!=100){d=k[a>>2]|0;k[d+20>>2]=21;k[d+24>>2]=c;qb[k[d>>2]&127](a)}k[a+80>>2]=b;d=a+244|0;k[d>>2]=0;c=a+256|0;k[c>>2]=0;switch(b|0){case 0:{b=k[a+36>>2]|0;e=a+76|0;k[e>>2]=b;if((b+-1|0)>>>0>9){f=k[a>>2]|0;k[f+20>>2]=27;k[f+24>>2]=b;k[f+28>>2]=10;qb[k[f>>2]&127](a);g=k[e>>2]|0}else g=b;if((g|0)<=0)return;b=k[a+84>>2]|0;e=0;do{k[b+(e*88|0)>>2]=e;k[b+(e*88|0)+8>>2]=1;k[b+(e*88|0)+12>>2]=1;k[b+(e*88|0)+16>>2]=0;k[b+(e*88|0)+20>>2]=0;k[b+(e*88|0)+24>>2]=0;e=e+1|0}while((e|0)<(g|0));return}case 1:{k[d>>2]=1;k[a+76>>2]=1;g=k[a+84>>2]|0;k[g>>2]=1;k[g+8>>2]=1;k[g+12>>2]=1;k[g+16>>2]=0;k[g+20>>2]=0;k[g+24>>2]=0;return}case 2:{k[c>>2]=1;k[a+76>>2]=3;g=k[a+84>>2]|0;k[g>>2]=82;k[g+8>>2]=1;k[g+12>>2]=1;k[g+16>>2]=0;e=(k[a+260>>2]|0)==1&1;k[g+20>>2]=e;k[g+24>>2]=e;k[g+88>>2]=71;k[g+96>>2]=1;k[g+100>>2]=1;k[g+104>>2]=0;k[g+108>>2]=0;k[g+112>>2]=0;k[g+176>>2]=66;k[g+184>>2]=1;k[g+188>>2]=1;k[g+192>>2]=0;k[g+196>>2]=e;k[g+200>>2]=e;return}case 3:{k[d>>2]=1;k[a+76>>2]=3;e=k[a+84>>2]|0;k[e>>2]=1;k[e+8>>2]=2;k[e+12>>2]=2;k[e+16>>2]=0;k[e+20>>2]=0;k[e+24>>2]=0;k[e+88>>2]=2;k[e+96>>2]=1;k[e+100>>2]=1;k[e+104>>2]=1;k[e+108>>2]=1;k[e+112>>2]=1;k[e+176>>2]=3;k[e+184>>2]=1;k[e+188>>2]=1;k[e+192>>2]=1;k[e+196>>2]=1;k[e+200>>2]=1;return}case 4:{k[c>>2]=1;k[a+76>>2]=4;e=k[a+84>>2]|0;k[e>>2]=67;k[e+8>>2]=1;k[e+12>>2]=1;k[e+16>>2]=0;k[e+20>>2]=0;k[e+24>>2]=0;k[e+88>>2]=77;k[e+96>>2]=1;k[e+100>>2]=1;k[e+104>>2]=0;k[e+108>>2]=0;k[e+112>>2]=0;k[e+176>>2]=89;k[e+184>>2]=1;k[e+188>>2]=1;k[e+192>>2]=0;k[e+196>>2]=0;k[e+200>>2]=0;k[e+264>>2]=75;k[e+272>>2]=1;k[e+276>>2]=1;k[e+280>>2]=0;k[e+284>>2]=0;k[e+288>>2]=0;return}case 5:{k[c>>2]=1;k[a+76>>2]=4;c=k[a+84>>2]|0;k[c>>2]=1;k[c+8>>2]=2;k[c+12>>2]=2;k[c+16>>2]=0;k[c+20>>2]=0;k[c+24>>2]=0;k[c+88>>2]=2;k[c+96>>2]=1;k[c+100>>2]=1;k[c+104>>2]=1;k[c+108>>2]=1;k[c+112>>2]=1;k[c+176>>2]=3;k[c+184>>2]=1;k[c+188>>2]=1;k[c+192>>2]=1;k[c+196>>2]=1;k[c+200>>2]=1;k[c+264>>2]=4;k[c+272>>2]=2;k[c+276>>2]=2;k[c+280>>2]=0;k[c+284>>2]=0;k[c+288>>2]=0;return}case 6:{k[d>>2]=1;i[a+248>>0]=2;k[a+76>>2]=3;c=k[a+84>>2]|0;k[c>>2]=114;k[c+8>>2]=1;k[c+12>>2]=1;k[c+16>>2]=0;e=(k[a+260>>2]|0)==1&1;k[c+20>>2]=e;k[c+24>>2]=e;k[c+88>>2]=103;k[c+96>>2]=1;k[c+100>>2]=1;k[c+104>>2]=0;k[c+108>>2]=0;k[c+112>>2]=0;k[c+176>>2]=98;k[c+184>>2]=1;k[c+188>>2]=1;k[c+192>>2]=0;k[c+196>>2]=e;k[c+200>>2]=e;return}case 7:{k[d>>2]=1;i[a+248>>0]=2;k[a+76>>2]=3;d=k[a+84>>2]|0;k[d>>2]=1;k[d+8>>2]=2;k[d+12>>2]=2;k[d+16>>2]=0;k[d+20>>2]=0;k[d+24>>2]=0;k[d+88>>2]=34;k[d+96>>2]=1;k[d+100>>2]=1;k[d+104>>2]=1;k[d+108>>2]=1;k[d+112>>2]=1;k[d+176>>2]=35;k[d+184>>2]=1;k[d+188>>2]=1;k[d+192>>2]=1;k[d+196>>2]=1;k[d+200>>2]=1;return}default:{d=k[a>>2]|0;k[d+20>>2]=11;qb[k[d>>2]&127](a);return}}}function Jk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0;e=k[b>>2]|0;if(!e){f=Dk(a)|0;k[b>>2]=f;g=f}else g=e;e=g;g=c;f=e+17|0;do{i[e>>0]=i[g>>0]|0;e=e+1|0;g=g+1|0}while((e|0)<(f|0));g=(l[c+16>>0]|0)+((l[c+15>>0]|0)+((l[c+14>>0]|0)+((l[c+13>>0]|0)+((l[c+12>>0]|0)+((l[c+11>>0]|0)+((l[c+10>>0]|0)+((l[c+9>>0]|0)+((l[c+8>>0]|0)+((l[c+7>>0]|0)+((l[c+6>>0]|0)+((l[c+5>>0]|0)+((l[c+4>>0]|0)+((l[c+3>>0]|0)+((l[c+2>>0]|0)+(l[c+1>>0]|0)))))))))))))))|0;if((g+-1|0)>>>0<=255){h=k[b>>2]|0;j=h+17|0;wr(j|0,d|0,g|0)|0;m=k[b>>2]|0;n=m+276|0;k[n>>2]=0;return}c=k[a>>2]|0;k[c+20>>2]=9;qb[k[c>>2]&127](a);h=k[b>>2]|0;j=h+17|0;wr(j|0,d|0,g|0)|0;m=k[b>>2]|0;n=m+276|0;k[n>>2]=0;return}function Kk(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;if(!b)c=a;else{b=k[a>>2]|0;k[b+20>>2]=3;qb[k[b>>2]&127](a);c=a}b=a+4|0;d=nb[k[k[b>>2]>>2]&63](c,1,64)|0;k[a+400>>2]=d;k[d>>2]=9;e=d+4|0;if(!(k[(k[a+416>>2]|0)+8>>2]|0)){k[e>>2]=2;f=a+76|0;if((k[f>>2]|0)<=0)return;g=a+280|0;h=a+272|0;i=a+276|0;j=d+8|0;l=0;m=k[a+84>>2]|0;while(1){n=ha(k[g>>2]|0,k[m+28>>2]|0)|0;o=ha(n,k[h>>2]|0)|0;n=xb[k[(k[b>>2]|0)+8>>2]&63](c,1,(o|0)/(k[m+8>>2]|0)|0,k[i>>2]|0)|0;k[j+(l<<2)>>2]=n;l=l+1|0;if((l|0)>=(k[f>>2]|0))break;else m=m+88|0}return}k[e>>2]=1;e=k[a+276>>2]|0;m=a+76|0;f=ha(e*20|0,k[m>>2]|0)|0;l=nb[k[k[b>>2]>>2]&63](c,1,f)|0;f=k[a+84>>2]|0;if((k[m>>2]|0)<=0)return;j=a+280|0;i=a+272|0;a=e*3|0;h=e*12|0;g=e*5|0;n=e<<1;o=e<<2;if((e|0)>0){p=0;q=f;r=l}else{s=0;t=f;f=l;while(1){l=ha(k[j>>2]|0,k[t+28>>2]|0)|0;u=ha(l,k[i>>2]|0)|0;l=f+(e<<2)|0;wr(l|0,xb[k[(k[b>>2]|0)+8>>2]&63](c,1,(u|0)/(k[t+8>>2]|0)|0,a)|0,h|0)|0;k[d+8+(s<<2)>>2]=l;s=s+1|0;if((s|0)>=(k[m>>2]|0))break;else{t=t+88|0;f=f+(g<<2)|0}}return}while(1){f=ha(k[j>>2]|0,k[q+28>>2]|0)|0;t=ha(f,k[i>>2]|0)|0;f=xb[k[(k[b>>2]|0)+8>>2]&63](c,1,(t|0)/(k[q+8>>2]|0)|0,a)|0;t=r+(e<<2)|0;wr(t|0,f|0,h|0)|0;s=0;do{k[r+(s<<2)>>2]=k[f+(s+n<<2)>>2];k[r+(s+o<<2)>>2]=k[f+(s<<2)>>2];s=s+1|0}while((s|0)!=(e|0));k[d+8+(p<<2)>>2]=t;p=p+1|0;if((p|0)>=(k[m>>2]|0))break;else{q=q+88|0;r=r+(g<<2)|0}}return}function Lk(a,b){a=a|0;b=b|0;var c=0;c=k[a+400>>2]|0;if(b){b=k[a>>2]|0;k[b+20>>2]=3;qb[k[b>>2]&127](a)}k[c+48>>2]=k[a+32>>2];k[c+52>>2]=0;k[c+56>>2]=0;k[c+60>>2]=k[a+276>>2]<<1;return}function Mk(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;h=k[a+400>>2]|0;i=a+276|0;j=(k[i>>2]|0)*3|0;l=h+48|0;if((k[f>>2]|0)>>>0>=g>>>0)return;m=h+60|0;n=h+52|0;o=a+412|0;p=h+8|0;q=a+32|0;r=a+76|0;s=a+28|0;t=a+416|0;u=h+56|0;while(1){v=k[c>>2]|0;if(v>>>0>=d>>>0){if(k[l>>2]|0){w=29;break}x=k[n>>2]|0;y=k[m>>2]|0;if((x|0)<(y|0)){z=k[r>>2]|0;if((z|0)>0){A=x;B=y;C=z;z=0;while(1){D=k[h+8+(z<<2)>>2]|0;E=k[s>>2]|0;if((A|0)<(B|0)){F=A+-1|0;G=A;do{rm(D,F,D,G,1,E);G=G+1|0}while((G|0)!=(B|0));H=k[r>>2]|0}else H=C;G=z+1|0;if((G|0)>=(H|0))break;A=k[n>>2]|0;B=k[m>>2]|0;C=H;z=G}I=k[m>>2]|0}else I=y;k[n>>2]=I;w=25}else{J=x;K=y;w=24}}else{z=d-v|0;C=k[n>>2]|0;B=(k[m>>2]|0)-C|0;A=B>>>0<z>>>0?B:z;pb[k[(k[o>>2]|0)+4>>2]&63](a,b+(v<<2)|0,p,C,A);if((k[l>>2]|0)==(k[q>>2]|0)?(C=k[r>>2]|0,(C|0)>0):0){z=k[i>>2]|0;B=C;C=0;while(1){if((z|0)<1){L=B;M=z}else{G=h+8+(C<<2)|0;E=1;while(1){D=k[G>>2]|0;rm(D,0,D,0-E|0,1,k[s>>2]|0);D=k[i>>2]|0;if((E|0)<(D|0))E=E+1|0;else{N=D;break}}L=k[r>>2]|0;M=N}C=C+1|0;if((C|0)>=(L|0))break;else{z=M;B=L}}}k[c>>2]=(k[c>>2]|0)+A;B=(k[n>>2]|0)+A|0;k[n>>2]=B;k[l>>2]=(k[l>>2]|0)-A;J=B;K=k[m>>2]|0;w=24}if((w|0)==24?(w=0,(J|0)==(K|0)):0)w=25;if((w|0)==25){w=0;pb[k[(k[t>>2]|0)+4>>2]&63](a,p,k[u>>2]|0,e,k[f>>2]|0);k[f>>2]=(k[f>>2]|0)+1;B=k[i>>2]|0;z=(k[u>>2]|0)+B|0;k[u>>2]=(z|0)<(j|0)?z:0;z=k[n>>2]|0;if((z|0)<(j|0))O=z;else{k[n>>2]=0;O=0}k[m>>2]=B+O}if((k[f>>2]|0)>>>0>=g>>>0){w=29;break}}if((w|0)==29)return}function Nk(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;h=k[a+400>>2]|0;i=k[c>>2]|0;if(i>>>0>=d>>>0)return;j=a+276|0;l=h+52|0;m=a+412|0;n=h+8|0;o=h+48|0;p=a+76|0;q=a+28|0;r=a+416|0;s=i;while(1){if((k[f>>2]|0)>>>0>=g>>>0){t=28;break}i=d-s|0;u=k[l>>2]|0;v=(k[j>>2]|0)-u|0;w=v>>>0<i>>>0?v:i;pb[k[(k[m>>2]|0)+4>>2]&63](a,b+(s<<2)|0,n,u,w);k[c>>2]=(k[c>>2]|0)+w;u=(k[l>>2]|0)+w|0;k[l>>2]=u;i=k[o>>2]|0;k[o>>2]=i-w;v=k[j>>2]|0;if(!((i|0)==(w|0)&(u|0)<(v|0))){if((u|0)==(v|0))t=15}else{w=k[p>>2]|0;if((w|0)>0){i=u;u=v;x=w;w=0;while(1){y=k[h+8+(w<<2)>>2]|0;z=k[q>>2]|0;if((i|0)<(u|0)){A=i+-1|0;B=i;do{rm(y,A,y,B,1,z);B=B+1|0}while((B|0)!=(u|0));C=k[p>>2]|0}else C=x;B=w+1|0;if((B|0)>=(C|0))break;i=k[l>>2]|0;u=k[j>>2]|0;x=C;w=B}D=k[j>>2]|0}else D=v;k[l>>2]=D;t=15}if((t|0)==15){t=0;pb[k[(k[r>>2]|0)+4>>2]&63](a,n,0,e,k[f>>2]|0);k[l>>2]=0;k[f>>2]=(k[f>>2]|0)+1}if((k[o>>2]|0)==0?(w=k[f>>2]|0,w>>>0<g>>>0):0){E=w;t=19;break}s=k[c>>2]|0;if(s>>>0>=d>>>0){t=28;break}}if((t|0)==19){d=k[p>>2]|0;a:do if((d|0)>0){s=a+284|0;c=E;o=d;l=0;n=k[a+84>>2]|0;while(1){r=ha(k[n+40>>2]|0,k[n+12>>2]|0)|0;D=(r|0)/(k[s>>2]|0)|0;r=k[e+(l<<2)>>2]|0;j=ha(k[n+36>>2]|0,k[n+28>>2]|0)|0;C=ha(c,D)|0;q=ha(D,g)|0;if((C|0)<(q|0)){D=C+-1|0;h=C;do{rm(r,D,r,h,1,j);h=h+1|0}while((h|0)!=(q|0));F=k[p>>2]|0}else F=o;q=l+1|0;if((q|0)>=(F|0))break a;c=k[f>>2]|0;o=F;l=q;n=n+88|0}}while(0);k[f>>2]=g;return}else if((t|0)==28)return}function Ok(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;b=nb[k[k[a+4>>2]>>2]&63](a,1,112)|0;k[a+416>>2]=b;k[b>>2]=38;k[b+4>>2]=1;c=b+8|0;k[c>>2]=0;if(k[a+220>>2]|0){d=k[a>>2]|0;k[d+20>>2]=26;qb[k[d>>2]&127](a)}d=a+76|0;if((k[d>>2]|0)<=0)return;e=a+280|0;f=a+284|0;g=a+272|0;h=a+276|0;j=b+52|0;l=a+228|0;m=b+12|0;n=0;o=k[a+84>>2]|0;p=1;while(1){q=ha(k[o+36>>2]|0,k[o+8>>2]|0)|0;r=(q|0)/(k[e>>2]|0)|0;q=ha(k[o+40>>2]|0,k[o+12>>2]|0)|0;s=(q|0)/(k[f>>2]|0)|0;q=k[g>>2]|0;t=k[h>>2]|0;k[j+(n<<2)>>2]=s;u=(t|0)==(s|0);do if((q|0)==(r|0)&u){v=m+(n<<2)|0;if(!(k[l>>2]|0)){k[v>>2]=6;w=p;break}else{k[v>>2]=5;k[c>>2]=1;w=p;break}}else{v=(q|0)==(r<<1|0);if(v&u){k[m+(n<<2)>>2]=7;w=0;break}if(v&(t|0)==(s<<1|0)){v=m+(n<<2)|0;if(!(k[l>>2]|0)){k[v>>2]=9;w=p;break}else{k[v>>2]=8;k[c>>2]=1;w=p;break}}if(((q|0)%(r|0)|0|0)==0?((t|0)%(s|0)|0|0)==0:0){k[m+(n<<2)>>2]=10;i[b+(n+92)>>0]=(q|0)/(r|0)|0;i[b+(n+102)>>0]=(t|0)/(s|0)|0;w=0;break}v=k[a>>2]|0;k[v+20>>2]=39;qb[k[v>>2]&127](a);w=p}while(0);n=n+1|0;if((n|0)>=(k[d>>2]|0)){x=w;break}else{o=o+88|0;p=w}}if((x|0)!=0|(k[l>>2]|0)==0)return;l=k[a>>2]|0;k[l+20>>2]=101;rb[k[l+4>>2]&31](a,0);return}function Pk(a){a=a|0;return}function Qk(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;f=k[a+416>>2]|0;g=a+76|0;if((k[g>>2]|0)<=0)return;h=0;i=k[a+84>>2]|0;while(1){j=(k[d+(h<<2)>>2]|0)+((ha(k[f+52+(h<<2)>>2]|0,e)|0)<<2)|0;Ab[k[f+12+(h<<2)>>2]&31](a,i,(k[b+(h<<2)>>2]|0)+(c<<2)|0,j);h=h+1|0;if((h|0)>=(k[g>>2]|0))break;else i=i+88|0}return}function Rk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;e=ha(k[b+36>>2]|0,k[b+28>>2]|0)|0;b=a+276|0;f=k[b>>2]|0;g=k[a+28>>2]|0;if((f|0)>-2&(e-g|0)>0){h=g+-1|0;j=h-e|0;m=e+2-g+((j|0)>-2?j:-2)|0;j=f+1|0;n=0;while(1){o=k[c+(n+-1<<2)>>2]|0;qr(o+g|0,i[o+h>>0]|0,m|0)|0;if((n|0)==(j|0))break;else n=n+1|0}p=k[b>>2]|0}else p=f;f=k[a+228>>2]|0;a=65536-(f<<9)|0;n=f<<6;if((p|0)<=0)return;p=e+-2|0;if(!p){f=0;do{j=k[d+(f<<2)>>2]|0;m=k[c+(f<<2)>>2]|0;h=k[c+(f+-1<<2)>>2]|0;f=f+1|0;g=k[c+(f<<2)>>2]|0;o=(l[g>>0]|0)+(l[h>>0]|0)|0;q=l[m>>0]|0;r=o+q|0;s=m+1|0;m=(l[g+1>>0]|0)+(l[h+1>>0]|0)+(l[s>>0]|0)|0;h=((ha(q,a)|0)+32768+(ha(r+o+m|0,n)|0)|0)>>>16&255;i[j>>0]=h;h=l[s>>0]|0;s=((ha(h,a)|0)+32768+(ha(r-h+(m<<1)|0,n)|0)|0)>>>16&255;i[j+1>>0]=s}while((f|0)<(k[b>>2]|0));return}f=e+-1|0;e=0;do{s=k[d+(e<<2)>>2]|0;j=k[c+(e<<2)>>2]|0;m=k[c+(e+-1<<2)>>2]|0;e=e+1|0;h=k[c+(e<<2)>>2]|0;r=m+1|0;o=h+1|0;q=(l[h>>0]|0)+(l[m>>0]|0)|0;m=l[j>>0]|0;h=q+m|0;g=j+1|0;t=(l[o>>0]|0)+(l[r>>0]|0)+(l[g>>0]|0)|0;u=((ha(m,a)|0)+32768+(ha(h+q+t|0,n)|0)|0)>>>16&255;i[s>>0]=u;u=s+f|0;q=s;s=r;r=o;o=p;m=t;t=g;g=h;while(1){q=q+1|0;h=l[t>>0]|0;t=t+1|0;s=s+1|0;r=r+1|0;v=(l[r>>0]|0)+(l[s>>0]|0)+(l[t>>0]|0)|0;w=((ha(h,a)|0)+32768+(ha(g+m-h+v|0,n)|0)|0)>>>16&255;i[q>>0]=w;o=o+-1|0;if(!o){x=v;y=m;break}else{w=m;m=v;g=w}}g=l[j+f>>0]|0;m=((ha(g,a)|0)+32768+(ha(y-g+(x<<1)|0,n)|0)|0)>>>16&255;i[u>>0]=m}while((e|0)<(k[b>>2]|0));return}function Sk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0;e=a+276|0;f=a+28|0;rm(c,0,d,0,k[e>>2]|0,k[f>>2]|0);c=k[e>>2]|0;e=k[f>>2]|0;f=ha(k[b+36>>2]|0,k[b+28>>2]|0)|0;if(!((c|0)>0&(f-e|0)>0))return;b=e+-1|0;a=b-f|0;g=2-e+f+((a|0)>-2?a:-2)|0;a=0;do{f=k[d+(a<<2)>>2]|0;qr(f+e|0,i[f+b>>0]|0,g|0)|0;a=a+1|0}while((a|0)!=(c|0));return}function Tk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0;e=ha(k[b+36>>2]|0,k[b+28>>2]|0)|0;b=a+276|0;f=k[b>>2]|0;g=k[a+28>>2]|0;a=e<<1;if((f|0)>0&(a-g|0)>0){h=g+-1|0;j=h-a|0;m=a+2-g+((j|0)>-2?j:-2)|0;j=0;do{a=k[c+(j<<2)>>2]|0;qr(a+g|0,i[a+h>>0]|0,m|0)|0;j=j+1|0}while((j|0)!=(f|0));n=k[b>>2]|0}else n=f;if((n|0)<=0)return;if(!e){f=0;do f=f+1|0;while((f|0)<(n|0));return}else o=0;do{n=0;f=k[c+(o<<2)>>2]|0;j=0;m=k[d+(o<<2)>>2]|0;while(1){i[m>>0]=((l[f>>0]|0)+n+(l[f+1>>0]|0)|0)>>>1;j=j+1|0;if((j|0)==(e|0))break;else{n=n^1;f=f+2|0;m=m+1|0}}o=o+1|0}while((o|0)<(k[b>>2]|0));return}function Uk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0;e=ha(k[b+36>>2]|0,k[b+28>>2]|0)|0;b=a+276|0;f=k[b>>2]|0;g=k[a+28>>2]|0;h=e<<1;if((f|0)>-2&(h-g|0)>0){j=g+-1|0;m=j-h|0;n=h+2-g+((m|0)>-2?m:-2)|0;m=f+1|0;h=0;while(1){o=k[c+(h+-1<<2)>>2]|0;qr(o+g|0,i[o+j>>0]|0,n|0)|0;if((h|0)==(m|0))break;else h=h+1|0}p=k[b>>2]|0}else p=f;f=k[a+228>>2]|0;a=(ha(f,-80)|0)+16384|0;h=f<<4;if((p|0)<=0)return;p=e+-2|0;f=e+-1|0;m=e<<1;e=m+-3|0;n=m+-3|0;j=m+-3|0;m=0;g=0;while(1){o=k[d+(g<<2)>>2]|0;q=k[c+(m<<2)>>2]|0;r=k[c+((m|1)<<2)>>2]|0;s=k[c+(m+-1<<2)>>2]|0;m=m+2|0;t=k[c+(m<<2)>>2]|0;u=l[q>>0]|0;v=l[r>>0]|0;w=l[s>>0]|0;x=l[t>>0]|0;y=q+2|0;z=r+2|0;A=s+2|0;B=t+2|0;C=((ha((l[q+1>>0]|0)+u+v+(l[r+1>>0]|0)|0,a)|0)+32768+(ha(x+w+(l[A>>0]|0)+(l[B>>0]|0)+(v+u+w+(l[s+1>>0]|0)+x+(l[t+1>>0]|0)+(l[y>>0]|0)+(l[z>>0]|0)<<1)|0,h)|0)|0)>>>16&255;i[o>>0]=C;C=o+f|0;x=o;o=q;q=r;w=s;u=t;v=A;A=B;B=p;D=y;y=z;while(1){z=x+1|0;E=l[o+3>>0]|0;F=l[q+3>>0]|0;G=E+(l[D>>0]|0)+(l[y>>0]|0)+F|0;H=l[w+3>>0]|0;I=l[u+3>>0]|0;J=H+(l[v>>0]|0)+(l[A>>0]|0)+I+(l[o+1>>0]|0)|0;if(!B){K=E;L=F;M=G;N=H;O=I;P=J;break}I=D+2|0;H=y+2|0;F=v+2|0;E=A+2|0;Q=((ha(G,a)|0)+32768+(ha((l[F>>0]|0)+(l[w+1>>0]|0)+((l[I>>0]|0)+J+(l[q+1>>0]|0)+(l[H>>0]|0)<<1)+(l[u+1>>0]|0)+(l[E>>0]|0)|0,h)|0)|0)>>>16&255;i[z>>0]=Q;Q=A;J=v;G=y;R=D;x=z;v=F;A=E;B=B+-1|0;D=I;y=H;u=Q;w=J;q=G;o=R}o=((ha(M,a)|0)+32768+(ha(O+N+(l[s+n>>0]|0)+(l[t+j>>0]|0)+(L+K+P+(l[r+e>>0]|0)<<1)|0,h)|0)|0)>>>16&255;i[C>>0]=o;if((m|0)>=(k[b>>2]|0))break;else g=g+1|0}return}function Vk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0;e=ha(k[b+36>>2]|0,k[b+28>>2]|0)|0;b=a+276|0;f=k[b>>2]|0;g=k[a+28>>2]|0;a=e<<1;if((f|0)>0&(a-g|0)>0){h=g+-1|0;j=h-a|0;m=a+2-g+((j|0)>-2?j:-2)|0;j=0;do{a=k[c+(j<<2)>>2]|0;qr(a+g|0,i[a+h>>0]|0,m|0)|0;j=j+1|0}while((j|0)!=(f|0));n=k[b>>2]|0}else n=f;if((n|0)<=0)return;if(!e){f=0;do f=f+2|0;while((f|0)<(n|0));return}else{o=0;p=0}while(1){n=1;f=k[c+(o<<2)>>2]|0;j=k[c+((o|1)<<2)>>2]|0;m=0;h=k[d+(p<<2)>>2]|0;while(1){i[h>>0]=((l[f>>0]|0)+n+(l[f+1>>0]|0)+(l[j>>0]|0)+(l[j+1>>0]|0)|0)>>>2;m=m+1|0;if((m|0)==(e|0))break;else{n=n^3;f=f+2|0;j=j+2|0;h=h+1|0}}o=o+2|0;if((o|0)>=(k[b>>2]|0))break;else p=p+1|0}return}function Wk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;e=k[a+416>>2]|0;f=ha(k[b+36>>2]|0,k[b+28>>2]|0)|0;g=k[b+4>>2]|0;b=i[e+92+g>>0]|0;h=b&255;j=i[e+102+g>>0]|0;g=j&255;e=ha(g,h)|0;m=e>>>1;n=a+276|0;o=k[n>>2]|0;p=k[a+28>>2]|0;a=ha(h,f)|0;if((o|0)>0&(a-p|0)>0){q=p+-1|0;r=q-a|0;s=a+2-p+((r|0)>-2?r:-2)|0;r=0;do{a=k[c+(r<<2)>>2]|0;qr(a+p|0,i[a+q>>0]|0,s|0)|0;r=r+1|0}while((r|0)!=(o|0));t=k[n>>2]|0}else t=o;if((t|0)<=0)return;o=(f|0)==0;r=j<<24>>24==0;j=b<<24>>24==0;b=t;t=0;s=0;while(1){if(o)u=b;else{q=0;p=0;a=k[d+(s<<2)>>2]|0;while(1){if(r)v=0;else{w=0;x=0;while(1){if(j)y=w;else{z=0;A=(k[c+(x+t<<2)>>2]|0)+p|0;B=w;while(1){C=(l[A>>0]|0)+B|0;z=z+1|0;if((z|0)==(h|0)){y=C;break}else{A=A+1|0;B=C}}}x=x+1|0;if((x|0)==(g|0)){v=y;break}else w=y}}i[a>>0]=(v+m|0)/(e|0)|0;q=q+1|0;if((q|0)==(f|0))break;else{p=p+h|0;a=a+1|0}}u=k[n>>2]|0}t=t+g|0;if((t|0)>=(u|0))break;else{b=u;s=s+1|0}}return}function Xk(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;k[a+4>>2]=0;if((b|0)!=90){d=k[a>>2]|0;k[d+20>>2]=13;k[d+24>>2]=90;k[d+28>>2]=b;qb[k[d>>2]&127](a)}if((c|0)==488)e=a;else{d=k[a>>2]|0;k[d+20>>2]=22;k[d+24>>2]=488;k[d+28>>2]=c;qb[k[d>>2]&127](a);e=a}d=k[a>>2]|0;c=a+12|0;b=k[c>>2]|0;qr(a|0,0,488)|0;k[a>>2]=d;k[c>>2]=b;k[a+16>>2]=1;tm(e);k[a+8>>2]=0;k[a+24>>2]=0;k[a+312>>2]=0;e=a+164|0;b=e+48|0;do{k[e>>2]=0;e=e+4|0}while((e|0)<(b|0));jl(a);dl(a);k[a+20>>2]=200;return}function Yk(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0;c=k[a+20>>2]|0;if((c&-2|0)!=200){d=k[a>>2]|0;k[d+20>>2]=21;k[d+24>>2]=c;qb[k[d>>2]&127](a)}d=Zk(a)|0;switch(d|0){case 1:{e=1;return e|0}case 2:{if(!b)f=a;else{b=k[a>>2]|0;k[b+20>>2]=53;qb[k[b>>2]&127](a);f=a}Ak(f);e=2;return e|0}default:{e=d;return e|0}}return 0}function Zk(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;b=a+20|0;c=k[b>>2]|0;switch(c|0){case 200:{d=a+460|0;qb[k[(k[d>>2]|0)+4>>2]&127](a);qb[k[(k[a+24>>2]|0)+8>>2]&127](a);k[b>>2]=201;e=d;break}case 201:{e=a+460|0;break}case 210:case 208:case 207:case 206:case 205:case 204:case 203:{f=ub[k[k[a+460>>2]>>2]&63](a)|0;return f|0}case 202:{f=1;return f|0}default:{d=k[a>>2]|0;k[d+20>>2]=21;k[d+24>>2]=c;qb[k[d>>2]&127](a);f=0;return f|0}}d=ub[k[k[e>>2]>>2]&63](a)|0;if((d|0)!=1){f=d;return f|0}switch(k[a+36>>2]|0){case 1:{k[a+40>>2]=1;k[a+44>>2]=1;break}case 3:{d=k[a+216>>2]|0;e=k[d>>2]|0;c=k[d+88>>2]|0;g=k[d+176>>2]|0;d=(e|0)==1;a:do if(d&(c|0)==2&(g|0)==3)k[a+40>>2]=3;else{if(d&(c|0)==34&(g|0)==35){k[a+40>>2]=7;break}if((e|0)==82&(c|0)==71&(g|0)==66){k[a+40>>2]=2;break}if((e|0)==114&(c|0)==103&(g|0)==98){k[a+40>>2]=6;break}if(k[a+284>>2]|0){k[a+40>>2]=3;break}if(!(k[a+296>>2]|0)){h=k[a>>2]|0;k[h+24>>2]=e;k[h+28>>2]=c;k[h+32>>2]=g;k[h+20>>2]=113;rb[k[h+4>>2]&31](a,1);k[a+40>>2]=3;break}h=l[a+300>>0]|0;switch(h|0){case 0:{k[a+40>>2]=2;break a;break}case 1:{k[a+40>>2]=3;break a;break}default:{i=k[a>>2]|0;k[i+20>>2]=116;k[i+24>>2]=h;rb[k[i+4>>2]&31](a,-1);k[a+40>>2]=3;break a}}}while(0);k[a+44>>2]=2;break}case 4:{b:do if(!(k[a+296>>2]|0))k[a+40>>2]=4;else{g=l[a+300>>0]|0;switch(g|0){case 0:{k[a+40>>2]=4;break b;break}case 2:{k[a+40>>2]=5;break b;break}default:{c=k[a>>2]|0;k[c+20>>2]=116;k[c+24>>2]=g;rb[k[c+4>>2]&31](a,-1);k[a+40>>2]=5;break b}}}while(0);k[a+44>>2]=4;break}default:{k[a+40>>2]=0;k[a+44>>2]=0}}c=k[a+428>>2]|0;k[a+48>>2]=c;k[a+52>>2]=c;p[a+56>>3]=1.0;k[a+64>>2]=0;k[a+68>>2]=0;k[a+72>>2]=0;k[a+76>>2]=1;k[a+80>>2]=1;k[a+84>>2]=0;k[a+88>>2]=2;k[a+92>>2]=1;k[a+96>>2]=256;k[a+136>>2]=0;k[a+100>>2]=0;k[a+104>>2]=0;k[a+108>>2]=0;k[b>>2]=202;f=1;return f|0}function _k(a){a=a|0;var b=0,c=0,d=0,e=0,f=0;b=a+20|0;c=k[b>>2]|0;if((c+-205|0)>>>0<2?(k[a+64>>2]|0)==0:0){if((k[a+140>>2]|0)>>>0<(k[a+116>>2]|0)>>>0){d=k[a>>2]|0;k[d+20>>2]=69;qb[k[d>>2]&127](a)}qb[k[(k[a+444>>2]|0)+4>>2]&127](a);k[b>>2]=210}else e=6;a:do if((e|0)==6)switch(c|0){case 210:{break a;break}case 207:{k[b>>2]=210;break a;break}default:{d=k[a>>2]|0;k[d+20>>2]=21;k[d+24>>2]=c;qb[k[d>>2]&127](a);break a}}while(0);c=a+460|0;while(1){b=k[c>>2]|0;if(k[b+20>>2]|0)break;if(!(ub[k[b>>2]&63](a)|0)){f=0;e=13;break}}if((e|0)==13)return f|0;qb[k[(k[a+24>>2]|0)+24>>2]&127](a);Ak(a);f=1;return f|0}function $k(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0;b=a+20|0;c=k[b>>2]|0;a:do switch(c|0){case 202:{tl(a);if(!(k[a+64>>2]|0)){k[b>>2]=203;d=6;break a}k[b>>2]=207;e=1;return e|0}case 203:{d=6;break}case 204:{f=a+444|0;break}default:{g=k[a>>2]|0;k[g+20>>2]=21;k[g+24>>2]=c;qb[k[g>>2]&127](a);d=16}}while(0);if((d|0)==6){c=a+460|0;b:do if(k[(k[c>>2]|0)+16>>2]|0){g=a+8|0;h=a+332|0;i=k[g>>2]|0;c:while(1){if(i)qb[k[i>>2]&127](a);j=ub[k[k[c>>2]>>2]&63](a)|0;switch(j|0){case 2:{break b;break}case 0:{e=0;break c;break}default:{}}l=k[g>>2]|0;if(!((j&-3|0)==1&(l|0)!=0)){i=l;continue}j=l+4|0;m=(k[j>>2]|0)+1|0;k[j>>2]=m;j=l+8|0;n=k[j>>2]|0;if((m|0)<(n|0)){i=l;continue}k[j>>2]=(k[h>>2]|0)+n;i=l}return e|0}while(0);k[a+152>>2]=k[a+144>>2];d=16}if((d|0)==16){d=a+444|0;if((k[b>>2]|0)==204)f=d;else{qb[k[k[d>>2]>>2]&127](a);k[a+140>>2]=0;k[b>>2]=204;f=d}}d:do if(k[(k[f>>2]|0)+8>>2]|0){d=a+140|0;c=a+116|0;i=a+8|0;h=a+448|0;g=k[d>>2]|0;while(1){l=k[c>>2]|0;if(g>>>0>=l>>>0){qb[k[(k[f>>2]|0)+4>>2]&127](a);qb[k[k[f>>2]>>2]&127](a);k[d>>2]=0;if(!(k[(k[f>>2]|0)+8>>2]|0))break d;else{g=0;continue}}n=k[i>>2]|0;if(!n)o=g;else{k[n+4>>2]=g;k[n+8>>2]=l;qb[k[n>>2]&127](a);o=k[d>>2]|0}Ab[k[(k[h>>2]|0)+4>>2]&31](a,0,d,0);g=k[d>>2]|0;if((g|0)==(o|0)){e=0;break}}return e|0}while(0);k[b>>2]=(k[a+68>>2]|0)!=0?206:205;e=1;return e|0}function al(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=r;r=r+16|0;e=d;f=k[a+20>>2]|0;if((f|0)!=205){g=k[a>>2]|0;k[g+20>>2]=21;k[g+24>>2]=f;qb[k[g>>2]&127](a)}g=a+140|0;f=k[g>>2]|0;h=k[a+116>>2]|0;if(f>>>0>=h>>>0){i=k[a>>2]|0;k[i+20>>2]=126;rb[k[i+4>>2]&31](a,-1);j=0;r=d;return j|0}i=k[a+8>>2]|0;if(i){k[i+4>>2]=f;k[i+8>>2]=h;qb[k[i>>2]&127](a)}k[e>>2]=0;Ab[k[(k[a+448>>2]|0)+4>>2]&31](a,b,e,c);c=k[e>>2]|0;k[g>>2]=(k[g>>2]|0)+c;j=c;r=d;return j|0}function bl(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;d=k[a+20>>2]|0;if((d|0)!=206){e=k[a>>2]|0;k[e+20>>2]=21;k[e+24>>2]=d;qb[k[e>>2]&127](a)}e=a+140|0;d=k[e>>2]|0;f=k[a+116>>2]|0;if(d>>>0>=f>>>0){g=k[a>>2]|0;k[g+20>>2]=126;rb[k[g+4>>2]&31](a,-1);h=0;return h|0}g=k[a+8>>2]|0;if(g){k[g+4>>2]=d;k[g+8>>2]=f;qb[k[g>>2]&127](a)}g=ha(k[a+328>>2]|0,k[a+320>>2]|0)|0;if(g>>>0>c>>>0){c=k[a>>2]|0;k[c+20>>2]=24;qb[k[c>>2]&127](a)}if(!(yb[k[(k[a+452>>2]|0)+12>>2]&127](a,b)|0)){h=0;return h|0}k[e>>2]=(k[e>>2]|0)+g;h=g;return h|0}function cl(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0;b=a+428|0;c=k[b>>2]|0;d=ha(c,k[a+48>>2]|0)|0;e=k[a+52>>2]|0;do if(d>>>0>e>>>0){if(d>>>0<=e<<1>>>0){f=pm(k[a+28>>2]<<1,c)|0;k[a+112>>2]=f;f=pm(k[a+32>>2]<<1,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=2;k[a+328>>2]=2;g=2;break}if(d>>>0<=(e*3|0)>>>0){f=pm((k[a+28>>2]|0)*3|0,c)|0;k[a+112>>2]=f;f=pm((k[a+32>>2]|0)*3|0,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=3;k[a+328>>2]=3;g=3;break}if(d>>>0<=e<<2>>>0){f=pm(k[a+28>>2]<<2,c)|0;k[a+112>>2]=f;f=pm(k[a+32>>2]<<2,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=4;k[a+328>>2]=4;g=4;break}if(d>>>0<=(e*5|0)>>>0){f=pm((k[a+28>>2]|0)*5|0,c)|0;k[a+112>>2]=f;f=pm((k[a+32>>2]|0)*5|0,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=5;k[a+328>>2]=5;g=5;break}if(d>>>0<=(e*6|0)>>>0){f=pm((k[a+28>>2]|0)*6|0,c)|0;k[a+112>>2]=f;f=pm((k[a+32>>2]|0)*6|0,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=6;k[a+328>>2]=6;g=6;break}if(d>>>0<=(e*7|0)>>>0){f=pm((k[a+28>>2]|0)*7|0,c)|0;k[a+112>>2]=f;f=pm((k[a+32>>2]|0)*7|0,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=7;k[a+328>>2]=7;g=7;break}if(d>>>0<=e<<3>>>0){f=pm(k[a+28>>2]<<3,c)|0;k[a+112>>2]=f;f=pm(k[a+32>>2]<<3,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=8;k[a+328>>2]=8;g=8;break}if(d>>>0<=(e*9|0)>>>0){f=pm((k[a+28>>2]|0)*9|0,c)|0;k[a+112>>2]=f;f=pm((k[a+32>>2]|0)*9|0,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=9;k[a+328>>2]=9;g=9;break}if(d>>>0<=(e*10|0)>>>0){f=pm((k[a+28>>2]|0)*10|0,c)|0;k[a+112>>2]=f;f=pm((k[a+32>>2]|0)*10|0,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=10;k[a+328>>2]=10;g=10;break}if(d>>>0<=(e*11|0)>>>0){f=pm((k[a+28>>2]|0)*11|0,c)|0;k[a+112>>2]=f;f=pm((k[a+32>>2]|0)*11|0,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=11;k[a+328>>2]=11;g=11;break}if(d>>>0<=(e*12|0)>>>0){f=pm((k[a+28>>2]|0)*12|0,c)|0;k[a+112>>2]=f;f=pm((k[a+32>>2]|0)*12|0,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=12;k[a+328>>2]=12;g=12;break}if(d>>>0<=(e*13|0)>>>0){f=pm((k[a+28>>2]|0)*13|0,c)|0;k[a+112>>2]=f;f=pm((k[a+32>>2]|0)*13|0,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=13;k[a+328>>2]=13;g=13;break}if(d>>>0<=(e*14|0)>>>0){f=pm((k[a+28>>2]|0)*14|0,c)|0;k[a+112>>2]=f;f=pm((k[a+32>>2]|0)*14|0,k[b>>2]|0)|0;k[a+116>>2]=f;k[a+324>>2]=14;k[a+328>>2]=14;g=14;break}f=k[a+28>>2]|0;if(d>>>0>(e*15|0)>>>0){h=pm(f<<4,c)|0;k[a+112>>2]=h;h=pm(k[a+32>>2]<<4,k[b>>2]|0)|0;k[a+116>>2]=h;k[a+324>>2]=16;k[a+328>>2]=16;g=16;break}else{h=pm(f*15|0,c)|0;k[a+112>>2]=h;h=pm((k[a+32>>2]|0)*15|0,k[b>>2]|0)|0;k[a+116>>2]=h;k[a+324>>2]=15;k[a+328>>2]=15;g=15;break}}else{h=pm(k[a+28>>2]|0,c)|0;k[a+112>>2]=h;h=pm(k[a+32>>2]|0,k[b>>2]|0)|0;k[a+116>>2]=h;k[a+324>>2]=1;k[a+328>>2]=1;g=1}while(0);b=k[a+36>>2]|0;if((b|0)<=0)return;c=0;e=k[a+216>>2]|0;while(1){k[e+36>>2]=g;k[e+40>>2]=g;c=c+1|0;if((c|0)>=(b|0))break;else e=e+88|0}return}function dl(a){a=a|0;var b=0;b=nb[k[k[a+4>>2]>>2]&63](a,0,28)|0;k[a+460>>2]=b;k[b>>2]=46;k[b+4>>2]=39;k[b+8>>2]=40;k[b+12>>2]=41;k[b+16>>2]=0;k[b+20>>2]=0;k[b+24>>2]=1;return}function el(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0;b=a+460|0;c=k[b>>2]|0;d=c+20|0;if(k[d>>2]|0){e=2;return e|0}f=a+464|0;g=c+24|0;h=a+340|0;i=c+16|0;c=a+32|0;j=a+212|0;l=a+36|0;m=a+316|0;n=a+320|0;o=a+216|0;p=a+220|0;q=a+224|0;r=a+416|0;s=a+412|0;t=a+420|0;u=a+424|0;v=a+428|0;w=a+432|0;x=a+436|0;y=a+324|0;z=a+328|0;A=a+28|0;B=a+332|0;a:while(1){C=ub[k[(k[f>>2]|0)+4>>2]&63](a)|0;switch(C|0){case 2:{D=57;break a;break}case 1:break;default:{e=C;D=62;break a}}b:do switch(k[g>>2]|0){case 0:{if(!(k[i>>2]|0)){C=k[a>>2]|0;k[C+20>>2]=36;qb[k[C>>2]&127](a)}if(!(k[h>>2]|0))continue a;else{D=56;break a}break}case 1:{if(!((k[c>>2]|0)<=65500?(k[A>>2]|0)<=65500:0)){C=k[a>>2]|0;k[C+20>>2]=42;k[C+24>>2]=65500;qb[k[C>>2]&127](a)}C=k[j>>2]|0;if((C+-8|0)>>>0>4){E=k[a>>2]|0;k[E+20>>2]=16;k[E+24>>2]=C;qb[k[E>>2]&127](a)}E=k[l>>2]|0;if((E|0)>10){C=k[a>>2]|0;k[C+20>>2]=27;k[C+24>>2]=E;k[C+28>>2]=10;qb[k[C>>2]&127](a);F=k[l>>2]|0}else F=E;k[m>>2]=1;k[n>>2]=1;if((F|0)>0){E=F;C=1;G=1;H=0;I=k[o>>2]|0;while(1){J=I+8|0;K=k[J>>2]|0;L=I+12|0;if((K+-1|0)>>>0<=3?(M=k[L>>2]|0,(M+-1|0)>>>0<=3):0){N=G;O=K;P=C;Q=M;R=E}else{M=k[a>>2]|0;k[M+20>>2]=19;qb[k[M>>2]&127](a);N=k[m>>2]|0;O=k[J>>2]|0;P=k[n>>2]|0;Q=k[L>>2]|0;R=k[l>>2]|0}G=(N|0)>(O|0)?N:O;k[m>>2]=G;C=(P|0)>(Q|0)?P:Q;k[n>>2]=C;H=H+1|0;if((H|0)>=(R|0)){S=R;break}else{E=R;I=I+88|0}}}else S=F;c:do if(!(k[p>>2]|0)){if((k[q>>2]|0)!=0?(k[h>>2]|0)!=0:0){D=22;break}do switch(k[r>>2]|0){case 0:{k[v>>2]=1;k[w>>2]=119984;k[x>>2]=0;T=1;U=S;break c;break}case 3:{k[v>>2]=2;k[w>>2]=121164;k[x>>2]=3;T=2;U=S;break c;break}case 8:{k[v>>2]=3;k[w>>2]=121064;k[x>>2]=8;T=3;U=S;break c;break}case 15:{k[v>>2]=4;k[w>>2]=120936;k[x>>2]=15;T=4;U=S;break c;break}case 24:{k[v>>2]=5;k[w>>2]=120772;k[x>>2]=24;T=5;U=S;break c;break}case 35:{k[v>>2]=6;k[w>>2]=120564;k[x>>2]=35;T=6;U=S;break c;break}case 48:{k[v>>2]=7;k[w>>2]=120304;k[x>>2]=48;T=7;U=S;break c;break}case 63:{k[v>>2]=8;k[w>>2]=119984;k[x>>2]=63;T=8;U=S;break c;break}case 80:{k[v>>2]=9;k[w>>2]=119984;k[x>>2]=63;T=9;U=S;break c;break}case 99:{k[v>>2]=10;k[w>>2]=119984;k[x>>2]=63;T=10;U=S;break c;break}case 120:{k[v>>2]=11;k[w>>2]=119984;k[x>>2]=63;T=11;U=S;break c;break}case 143:{k[v>>2]=12;k[w>>2]=119984;k[x>>2]=63;T=12;U=S;break c;break}case 168:{k[v>>2]=13;k[w>>2]=119984;k[x>>2]=63;T=13;U=S;break c;break}case 195:{k[v>>2]=14;k[w>>2]=119984;k[x>>2]=63;T=14;U=S;break c;break}case 224:{k[v>>2]=15;k[w>>2]=119984;k[x>>2]=63;T=15;U=S;break c;break}case 255:{k[v>>2]=16;k[w>>2]=119984;k[x>>2]=63;T=16;U=S;break c;break}default:{I=k[a>>2]|0;k[I+20>>2]=17;k[I+24>>2]=k[s>>2];k[I+28>>2]=k[r>>2];k[I+32>>2]=k[t>>2];k[I+36>>2]=k[u>>2];qb[k[I>>2]&127](a);T=k[v>>2]|0;U=k[l>>2]|0;break c}}while(0)}else D=22;while(0);if((D|0)==22){D=0;k[v>>2]=8;k[w>>2]=119984;k[x>>2]=63;T=8;U=S}k[y>>2]=T;k[z>>2]=T;if((U|0)>0){I=T;E=0;H=k[o>>2]|0;while(1){k[H+36>>2]=I;k[H+40>>2]=I;C=H+8|0;G=ha(k[C>>2]|0,k[A>>2]|0)|0;L=pm(G,ha(k[m>>2]|0,I)|0)|0;k[H+28>>2]=L;L=H+12|0;G=ha(k[L>>2]|0,k[c>>2]|0)|0;J=pm(G,ha(k[v>>2]|0,k[n>>2]|0)|0)|0;k[H+32>>2]=J;J=ha(k[C>>2]|0,k[A>>2]|0)|0;C=pm(J,k[m>>2]|0)|0;k[H+44>>2]=C;C=ha(k[L>>2]|0,k[c>>2]|0)|0;L=pm(C,k[n>>2]|0)|0;k[H+48>>2]=L;k[H+52>>2]=1;k[H+80>>2]=0;L=E+1|0;if((L|0)>=(k[l>>2]|0))break;I=k[v>>2]|0;E=L;H=H+88|0}V=k[v>>2]|0}else V=T;H=pm(k[c>>2]|0,ha(V,k[n>>2]|0)|0)|0;k[B>>2]=H;H=k[h>>2]|0;if((H|0)>=(k[l>>2]|0)?(k[q>>2]|0)==0:0){k[(k[b>>2]|0)+16>>2]=0;W=H;break b}k[(k[b>>2]|0)+16>>2]=1;W=H;break}default:W=k[h>>2]|0}while(0);if(W){D=52;break}k[g>>2]=2}if((D|0)==52){k[g>>2]=0;e=1;return e|0}else if((D|0)==56){gl(a);e=1;return e|0}else if((D|0)==57){k[d>>2]=1;if(!(k[g>>2]|0)){g=a+152|0;d=k[a+144>>2]|0;if((k[g>>2]|0)<=(d|0)){e=2;return e|0}k[g>>2]=d;e=2;return e|0}else{if(!(k[(k[f>>2]|0)+16>>2]|0)){e=2;return e|0}f=k[a>>2]|0;k[f+20>>2]=62;qb[k[f>>2]&127](a);e=2;return e|0}}else if((D|0)==62)return e|0;return 0}function fl(a){a=a|0;var b=0;b=k[a+460>>2]|0;k[b>>2]=46;k[b+16>>2]=0;k[b+20>>2]=0;k[b+24>>2]=1;qb[k[(k[a>>2]|0)+16>>2]&127](a);qb[k[k[a+464>>2]>>2]&127](a);k[a+160>>2]=0;return}function gl(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;b=a+340|0;c=k[b>>2]|0;if((c|0)!=1){if((c+-1|0)>>>0>3){d=k[a>>2]|0;k[d+20>>2]=27;k[d+24>>2]=c;k[d+28>>2]=4;qb[k[d>>2]&127](a)}d=a+428|0;c=pm(k[a+28>>2]|0,ha(k[d>>2]|0,k[a+316>>2]|0)|0)|0;k[a+360>>2]=c;c=pm(k[a+32>>2]|0,ha(k[d>>2]|0,k[a+320>>2]|0)|0)|0;k[a+364>>2]=c;c=a+368|0;k[c>>2]=0;if((k[b>>2]|0)<=0){e=a+468|0;f=k[e>>2]|0;g=k[f>>2]|0;qb[g&127](a);h=a+452|0;i=k[h>>2]|0;j=k[i>>2]|0;qb[j&127](a);l=k[h>>2]|0;m=l+4|0;n=k[m>>2]|0;o=a+460|0;p=k[o>>2]|0;k[p>>2]=n;return}d=0;q=0;while(1){r=k[a+344+(q<<2)>>2]|0;s=k[r+8>>2]|0;k[r+56>>2]=s;t=k[r+12>>2]|0;k[r+60>>2]=t;u=ha(t,s)|0;k[r+64>>2]=u;v=ha(k[r+36>>2]|0,s)|0;k[r+68>>2]=v;v=((k[r+28>>2]|0)>>>0)%(s>>>0)|0;k[r+72>>2]=(v|0)==0?s:v;v=((k[r+32>>2]|0)>>>0)%(t>>>0)|0;k[r+76>>2]=(v|0)==0?t:v;if((u+d|0)>10){v=k[a>>2]|0;k[v+20>>2]=14;qb[k[v>>2]&127](a)}if((u|0)>0){v=u;while(1){u=k[c>>2]|0;k[c>>2]=u+1;k[a+372+(u<<2)>>2]=q;if((v|0)>1)v=v+-1|0;else break}}v=q+1|0;u=k[b>>2]|0;if((v|0)>=(u|0)){w=u;break}d=k[c>>2]|0;q=v}if((w|0)>0)x=w;else{e=a+468|0;f=k[e>>2]|0;g=k[f>>2]|0;qb[g&127](a);h=a+452|0;i=k[h>>2]|0;j=k[i>>2]|0;qb[j&127](a);l=k[h>>2]|0;m=l+4|0;n=k[m>>2]|0;o=a+460|0;p=k[o>>2]|0;k[p>>2]=n;return}}else{w=k[a+344>>2]|0;k[a+360>>2]=k[w+28>>2];q=k[w+32>>2]|0;k[a+364>>2]=q;k[w+56>>2]=1;k[w+60>>2]=1;k[w+64>>2]=1;k[w+68>>2]=k[w+36>>2];k[w+72>>2]=1;c=k[w+12>>2]|0;d=(q>>>0)%(c>>>0)|0;k[w+76>>2]=(d|0)==0?c:d;k[a+368>>2]=1;k[a+372>>2]=0;x=1}d=a+4|0;c=x;x=0;while(1){w=k[a+344+(x<<2)>>2]|0;q=w+80|0;if(!(k[q>>2]|0)){v=k[w+16>>2]|0;w=a+164+(v<<2)|0;if(!(v>>>0<=3?(k[w>>2]|0)!=0:0)){u=k[a>>2]|0;k[u+20>>2]=54;k[u+24>>2]=v;qb[k[u>>2]&127](a)}u=nb[k[k[d>>2]>>2]&63](a,1,132)|0;wr(u|0,k[w>>2]|0,132)|0;k[q>>2]=u;y=k[b>>2]|0}else y=c;x=x+1|0;if((x|0)>=(y|0))break;else c=y}e=a+468|0;f=k[e>>2]|0;g=k[f>>2]|0;qb[g&127](a);h=a+452|0;i=k[h>>2]|0;j=k[i>>2]|0;qb[j&127](a);l=k[h>>2]|0;m=l+4|0;n=k[m>>2]|0;o=a+460|0;p=k[o>>2]|0;k[p>>2]=n;return}function hl(a){a=a|0;qb[k[(k[a+468>>2]|0)+8>>2]&127](a);k[k[a+460>>2]>>2]=46;return}function il(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0;c=a+440|0;d=k[c>>2]|0;e=k[a>>2]|0;k[e+20>>2]=124;k[e+24>>2]=d;k[e+28>>2]=b;rb[k[e+4>>2]&31](a,-1);e=b+1&7|208;f=b+2&7|208;g=b+7&7|208;h=b+6&7|208;b=d;a:while(1){d=(b&-8|0)==208;i=(b|0)==(e|0);j=(b|0)==(f|0);l=(b|0)==(g|0);m=(b|0)==(h|0);b:do if((b|0)<192){n=k[a>>2]|0;k[n+20>>2]=99;o=n+24|0;if(d){k[o>>2]=b;k[n+28>>2]=2;rb[k[n+4>>2]&31](a,4);break}if(i){k[o>>2]=e;k[n+28>>2]=2;rb[k[n+4>>2]&31](a,4);break}else{k[o>>2]=b;k[n+28>>2]=2;rb[k[n+4>>2]&31](a,4);break}}else{if(!d){p=10;break a}n=i|j?3:l|m?2:1;while(1){o=k[a>>2]|0;k[o+20>>2]=99;k[o+24>>2]=b;k[o+28>>2]=n;rb[k[o+4>>2]&31](a,4);switch(n|0){case 1:{p=13;break a;break}case 3:{q=1;p=17;break a;break}case 2:{break b;break}default:{}}}}while(0);if(!(kl(a)|0)){q=0;p=17;break}b=k[c>>2]|0}if((p|0)==10){h=k[a>>2]|0;k[h+20>>2]=99;g=h+24|0;if(i){k[g>>2]=e;k[h+28>>2]=3;rb[k[h+4>>2]&31](a,4);q=1;return q|0}else{k[g>>2]=b;k[h+28>>2]=3;rb[k[h+4>>2]&31](a,4);q=1;return q|0}}else if((p|0)==13){k[c>>2]=0;q=1;return q|0}else if((p|0)==17)return q|0;return 0}function jl(a){a=a|0;var b=0,c=0;b=nb[k[k[a+4>>2]>>2]&63](a,0,172)|0;c=a+464|0;k[c>>2]=b;k[b>>2]=42;k[b+4>>2]=47;k[b+8>>2]=48;k[b+28>>2]=49;k[b+96>>2]=0;k[b+100>>2]=0;k[b+36>>2]=49;k[b+104>>2]=0;k[b+40>>2]=49;k[b+108>>2]=0;k[b+44>>2]=49;k[b+112>>2]=0;k[b+48>>2]=49;k[b+116>>2]=0;k[b+52>>2]=49;k[b+120>>2]=0;k[b+56>>2]=49;k[b+124>>2]=0;k[b+60>>2]=49;k[b+128>>2]=0;k[b+64>>2]=49;k[b+132>>2]=0;k[b+68>>2]=49;k[b+136>>2]=0;k[b+72>>2]=49;k[b+140>>2]=0;k[b+76>>2]=49;k[b+144>>2]=0;k[b+80>>2]=49;k[b+148>>2]=0;k[b+84>>2]=49;k[b+152>>2]=0;k[b+156>>2]=0;k[b+92>>2]=49;k[b+160>>2]=0;k[b+32>>2]=50;k[b+88>>2]=50;b=k[c>>2]|0;k[a+216>>2]=0;k[a+144>>2]=0;k[a+440>>2]=0;k[b+12>>2]=0;k[b+16>>2]=0;k[b+24>>2]=0;k[b+164>>2]=0;return}function kl(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;b=k[a+24>>2]|0;c=b+4|0;d=b+12|0;e=a+464|0;f=k[c>>2]|0;g=k[b>>2]|0;a:while(1){if(!f){if(!(ub[k[d>>2]&63](a)|0)){h=0;j=19;break}l=k[b>>2]|0;m=k[c>>2]|0}else{l=g;m=f}n=m+-1|0;o=l+1|0;if((i[l>>0]|0)==-1){p=n;q=o}else{r=n;n=o;while(1){o=(k[e>>2]|0)+24|0;k[o>>2]=(k[o>>2]|0)+1;k[b>>2]=n;k[c>>2]=r;if(!r){if(!(ub[k[d>>2]&63](a)|0)){h=0;j=19;break a}s=k[b>>2]|0;t=k[c>>2]|0}else{s=n;t=r}o=t+-1|0;u=s+1|0;if((i[s>>0]|0)==-1){p=o;q=u;break}else{r=o;n=u}}}while(1){if(!p){if(!(ub[k[d>>2]&63](a)|0)){h=0;j=19;break a}v=k[c>>2]|0;w=k[b>>2]|0}else{v=p;w=q}n=v+-1|0;r=w+1|0;u=i[w>>0]|0;if(u<<24>>24==-1){p=n;q=r}else{x=n;y=r;z=u;break}}u=(k[e>>2]|0)+24|0;r=k[u>>2]|0;if(z<<24>>24){A=x;B=y;C=z;D=r;j=16;break}k[u>>2]=r+2;k[b>>2]=y;k[c>>2]=x;f=x;g=y}if((j|0)==16){y=C&255;if(D){C=k[a>>2]|0;k[C+20>>2]=119;k[C+24>>2]=D;k[C+28>>2]=y;rb[k[C+4>>2]&31](a,-1);k[(k[e>>2]|0)+24>>2]=0}k[a+440>>2]=y;k[b>>2]=B;k[c>>2]=A;h=1;return h|0}else if((j|0)==19)return h|0;return 0}function ll(a){a=a|0;var b=0;b=k[a+464>>2]|0;k[a+216>>2]=0;k[a+144>>2]=0;k[a+440>>2]=0;k[b+12>>2]=0;k[b+16>>2]=0;k[b+24>>2]=0;k[b+164>>2]=0;return}function ml(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,sb=0,tb=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0,Xb=0,Yb=0,Zb=0,_b=0,$b=0,ac=0,bc=0,cc=0,dc=0,ec=0,fc=0,gc=0,hc=0,ic=0,jc=0,kc=0,lc=0,mc=0,nc=0,oc=0,pc=0,qc=0,rc=0,sc=0,tc=0,uc=0,vc=0,wc=0,xc=0,yc=0,zc=0,Ac=0,Bc=0,Cc=0,Dc=0,Ec=0,Fc=0,Gc=0,Hc=0,Ic=0,Jc=0,Kc=0,Lc=0,Mc=0,Nc=0,Oc=0,Pc=0,Qc=0,Rc=0,Sc=0,Tc=0,Uc=0,Vc=0,Wc=0,Xc=0,Yc=0,Zc=0,_c=0,$c=0,ad=0,bd=0,cd=0,dd=0,ed=0,fd=0,gd=0,hd=0,id=0,jd=0,kd=0,ld=0,md=0,nd=0,od=0,pd=0,qd=0,rd=0,sd=0,td=0,ud=0,vd=0,wd=0,xd=0,yd=0,zd=0,Ad=0,Bd=0,Cd=0,Dd=0,Ed=0,Fd=0,Gd=0,Hd=0,Id=0,Jd=0,Kd=0,Ld=0,Md=0,Nd=0,Od=0,Pd=0,Qd=0,Rd=0,Sd=0,Td=0,Ud=0,Vd=0,Wd=0,Xd=0,Yd=0,Zd=0,_d=0,$d=0,ae=0,be=0,ce=0,de=0;b=r;r=r+288|0;c=b+256|0;d=b;e=a+440|0;f=a+464|0;g=a+24|0;h=a+232|0;n=a+248|0;o=a+264|0;p=a+233|0;q=a+249|0;s=a+265|0;t=a+234|0;u=a+250|0;v=a+266|0;w=a+235|0;x=a+251|0;y=a+267|0;z=a+236|0;A=a+252|0;B=a+268|0;C=a+237|0;D=a+253|0;E=a+269|0;F=a+238|0;G=a+254|0;H=a+270|0;I=a+239|0;J=a+255|0;K=a+271|0;L=a+240|0;M=a+256|0;N=a+272|0;O=a+241|0;P=a+257|0;Q=a+273|0;R=a+242|0;S=a+258|0;T=a+274|0;U=a+243|0;V=a+259|0;W=a+275|0;X=a+244|0;Y=a+260|0;Z=a+276|0;_=a+245|0;$=a+261|0;aa=a+277|0;ba=a+246|0;ca=a+262|0;da=a+278|0;ea=a+247|0;fa=a+263|0;ga=a+279|0;ha=a+280|0;ia=a+40|0;ja=a+304|0;ka=a+308|0;la=a+284|0;ma=a+288|0;na=a+289|0;oa=a+290|0;pa=a+292|0;qa=a+294|0;ra=a+296|0;sa=a+300|0;ta=c+1|0;ua=c+2|0;va=c+3|0;wa=c+4|0;xa=c+5|0;ya=c+6|0;za=c+7|0;Aa=c+8|0;Ba=c+9|0;Ca=c+10|0;Da=c+11|0;Ea=c+12|0;Fa=c+13|0;Ga=c+14|0;Ha=c+15|0;Ia=c+16|0;Ja=a+36|0;Ka=a+216|0;La=k[e>>2]|0;a:while(1){do if(!La){if(k[(k[f>>2]|0)+12>>2]|0){if(!(kl(a)|0)){Ma=0;Na=303;break a}Oa=k[e>>2]|0;break}Pa=k[g>>2]|0;Qa=Pa+4|0;Ra=k[Qa>>2]|0;if(!Ra){if(!(ub[k[Pa+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Sa=k[Qa>>2]|0}else Sa=Ra;Ra=k[Pa>>2]|0;Ta=Sa+-1|0;Ua=Ra+1|0;Va=i[Ra>>0]|0;Ra=Va&255;if(!Ta){if(!(ub[k[Pa+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Wa=k[Qa>>2]|0;Xa=k[Pa>>2]|0}else{Wa=Ta;Xa=Ua}Ua=i[Xa>>0]|0;Ta=Ua&255;if(Va<<24>>24!=-1|Ua<<24>>24!=-40){Ua=k[a>>2]|0;k[Ua+20>>2]=55;k[Ua+24>>2]=Ra;k[Ua+28>>2]=Ta;qb[k[Ua>>2]&127](a)}k[e>>2]=Ta;k[Pa>>2]=Xa+1;k[Qa>>2]=Wa+-1;Oa=Ta}else Oa=La;while(0);do switch(Oa|0){case 218:{Na=25;break a;break}case 217:{Na=72;break a;break}case 216:{Ta=k[a>>2]|0;k[Ta+20>>2]=104;rb[k[Ta+4>>2]&31](a,1);Ta=k[f>>2]|0;if(!(k[Ta+12>>2]|0))Ya=Ta;else{Ta=k[a>>2]|0;k[Ta+20>>2]=64;qb[k[Ta>>2]&127](a);Ya=k[f>>2]|0}i[h>>0]=0;i[n>>0]=1;i[o>>0]=5;i[p>>0]=0;i[q>>0]=1;i[s>>0]=5;i[t>>0]=0;i[u>>0]=1;i[v>>0]=5;i[w>>0]=0;i[x>>0]=1;i[y>>0]=5;i[z>>0]=0;i[A>>0]=1;i[B>>0]=5;i[C>>0]=0;i[D>>0]=1;i[E>>0]=5;i[F>>0]=0;i[G>>0]=1;i[H>>0]=5;i[I>>0]=0;i[J>>0]=1;i[K>>0]=5;i[L>>0]=0;i[M>>0]=1;i[N>>0]=5;i[O>>0]=0;i[P>>0]=1;i[Q>>0]=5;i[R>>0]=0;i[S>>0]=1;i[T>>0]=5;i[U>>0]=0;i[V>>0]=1;i[W>>0]=5;i[X>>0]=0;i[Y>>0]=1;i[Z>>0]=5;i[_>>0]=0;i[$>>0]=1;i[aa>>0]=5;i[ba>>0]=0;i[ca>>0]=1;i[da>>0]=5;i[ea>>0]=0;i[fa>>0]=1;i[ga>>0]=5;k[ha>>2]=0;k[ia>>2]=0;k[ja>>2]=0;k[ka>>2]=0;k[la>>2]=0;i[ma>>0]=1;i[na>>0]=1;i[oa>>0]=0;j[pa>>1]=1;j[qa>>1]=1;k[ra>>2]=0;i[sa>>0]=0;k[Ya+12>>2]=1;break}case 192:{if(!(rl(a,1,0,0)|0)){Ma=0;Na=303;break a}break}case 193:{if(!(rl(a,0,0,0)|0)){Ma=0;Na=303;break a}break}case 194:{if(!(rl(a,0,1,0)|0)){Ma=0;Na=303;break a}break}case 201:{if(!(rl(a,0,0,1)|0)){Ma=0;Na=303;break a}break}case 202:{if(!(rl(a,0,1,1)|0)){Ma=0;Na=303;break a}break}case 207:case 206:case 205:case 203:case 200:case 199:case 198:case 197:case 195:{Ta=k[a>>2]|0;k[Ta+20>>2]=63;k[Ta+24>>2]=Oa;qb[k[Ta>>2]&127](a);break}case 204:{Ta=k[g>>2]|0;Qa=Ta+4|0;Pa=k[Qa>>2]|0;if(!Pa){if(!(ub[k[Ta+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Za=k[Qa>>2]|0}else Za=Pa;Pa=k[Ta>>2]|0;Ua=Za+-1|0;Ra=Pa+1|0;Va=l[Pa>>0]<<8;if(!Ua){if(!(ub[k[Ta+12>>2]&63](a)|0)){Ma=0;Na=303;break a}_a=k[Qa>>2]|0;$a=k[Ta>>2]|0}else{_a=Ua;$a=Ra}Ra=_a+-1|0;Ua=$a+1|0;Pa=l[$a>>0]|Va;Va=Pa+-2|0;if(Pa>>>0>2){Pa=Ta+12|0;ab=Ra;bb=Va;cb=Ua;while(1){if(!ab){if(!(ub[k[Pa>>2]&63](a)|0)){Ma=0;Na=303;break a}db=k[Qa>>2]|0;eb=k[Ta>>2]|0}else{db=ab;eb=cb}fb=db+-1|0;gb=eb+1|0;hb=i[eb>>0]|0;ib=hb&255;if(!fb){if(!(ub[k[Pa>>2]&63](a)|0)){Ma=0;Na=303;break a}jb=k[Qa>>2]|0;kb=k[Ta>>2]|0}else{jb=fb;kb=gb}gb=jb+-1|0;fb=kb+1|0;lb=i[kb>>0]|0;mb=lb&255;nb=bb+-2|0;ob=k[a>>2]|0;k[ob+20>>2]=81;k[ob+24>>2]=ib;k[ob+28>>2]=mb;rb[k[ob+4>>2]&31](a,1);if((hb&255)<=31)if((hb&255)<=15){hb=mb&15;i[a+232+ib>>0]=hb;ob=(lb&255)>>>4;i[a+248+ib>>0]=ob;if((hb&255)>(ob&255)){ob=k[a>>2]|0;k[ob+20>>2]=30;k[ob+24>>2]=mb;qb[k[ob>>2]&127](a)}}else Na=90;else{ob=k[a>>2]|0;k[ob+20>>2]=29;k[ob+24>>2]=ib;qb[k[ob>>2]&127](a);Na=90}if((Na|0)==90){Na=0;i[ib+-16+(a+264)>>0]=lb}if((bb|0)>2){ab=gb;bb=nb;cb=fb}else{pb=gb;sb=nb;tb=fb;break}}}else{pb=Ra;sb=Va;tb=Ua}if(sb){cb=k[a>>2]|0;k[cb+20>>2]=12;qb[k[cb>>2]&127](a)}k[Ta>>2]=tb;k[Qa>>2]=pb;break}case 196:{cb=k[g>>2]|0;bb=cb+4|0;ab=k[bb>>2]|0;if(!ab){if(!(ub[k[cb+12>>2]&63](a)|0)){Na=127;break a}vb=k[bb>>2]|0}else vb=ab;ab=k[cb>>2]|0;Pa=vb+-1|0;fb=ab+1|0;nb=l[ab>>0]<<8;if(!Pa){if(!(ub[k[cb+12>>2]&63](a)|0)){Na=127;break a}wb=k[bb>>2]|0;xb=k[cb>>2]|0}else{wb=Pa;xb=fb}fb=wb+-1|0;Pa=xb+1|0;ab=(l[xb>>0]|nb)+-2|0;if((ab|0)>16){nb=cb+12|0;gb=fb;lb=ab;ib=Pa;while(1){if(!gb){if(!(ub[k[nb>>2]&63](a)|0)){Na=127;break a}yb=k[bb>>2]|0;zb=k[cb>>2]|0}else{yb=gb;zb=ib}ob=l[zb>>0]|0;mb=k[a>>2]|0;k[mb+20>>2]=82;k[mb+24>>2]=ob;rb[k[mb+4>>2]&31](a,1);i[c>>0]=0;mb=yb+-1|0;hb=0;Ab=1;Bb=zb+1|0;while(1){if(!mb){if(!(ub[k[nb>>2]&63](a)|0)){Na=127;break a}Cb=k[bb>>2]|0;Db=k[cb>>2]|0}else{Cb=mb;Db=Bb}Eb=i[Db>>0]|0;i[c+Ab>>0]=Eb;Fb=(Eb&255)+hb|0;Ab=Ab+1|0;Eb=Cb+-1|0;Gb=Db+1|0;if((Ab|0)>=17){Hb=Fb;Ib=Eb;Jb=Gb;break}else{mb=Eb;hb=Fb;Bb=Gb}}Bb=lb+-17|0;hb=k[a>>2]|0;k[hb+24>>2]=l[ta>>0];k[hb+28>>2]=l[ua>>0];k[hb+32>>2]=l[va>>0];k[hb+36>>2]=l[wa>>0];k[hb+40>>2]=l[xa>>0];k[hb+44>>2]=l[ya>>0];k[hb+48>>2]=l[za>>0];k[hb+52>>2]=l[Aa>>0];k[hb+20>>2]=88;rb[k[hb+4>>2]&31](a,2);hb=k[a>>2]|0;k[hb+24>>2]=l[Ba>>0];k[hb+28>>2]=l[Ca>>0];k[hb+32>>2]=l[Da>>0];k[hb+36>>2]=l[Ea>>0];k[hb+40>>2]=l[Fa>>0];k[hb+44>>2]=l[Ga>>0];k[hb+48>>2]=l[Ha>>0];k[hb+52>>2]=l[Ia>>0];k[hb+20>>2]=88;rb[k[hb+4>>2]&31](a,2);if((Hb|0)>256|(Bb|0)<(Hb|0)){hb=k[a>>2]|0;k[hb+20>>2]=9;qb[k[hb>>2]&127](a)}qr(d|0,0,256)|0;if((Hb|0)>0){hb=Ib;mb=0;Ab=Jb;while(1){if(!hb){if(!(ub[k[nb>>2]&63](a)|0)){Na=127;break a}Kb=k[bb>>2]|0;Lb=k[cb>>2]|0}else{Kb=hb;Lb=Ab}Gb=Kb+-1|0;Fb=Lb+1|0;i[d+mb>>0]=i[Lb>>0]|0;mb=mb+1|0;if((mb|0)>=(Hb|0)){Mb=Gb;Nb=Fb;break}else{hb=Gb;Ab=Fb}}}else{Mb=Ib;Nb=Jb}Ab=Bb-Hb|0;hb=(ob&16|0)==0;mb=ob+-16|0;Fb=hb?ob:mb;Gb=hb?a+180+(ob<<2)|0:a+196+(mb<<2)|0;if(Fb>>>0>3){mb=k[a>>2]|0;k[mb+20>>2]=31;k[mb+24>>2]=Fb;qb[k[mb>>2]&127](a)}mb=k[Gb>>2]|0;if(!mb){Fb=Dk(a)|0;k[Gb>>2]=Fb;Ob=Fb}else Ob=mb;mb=Ob;Fb=c;hb=mb+17|0;do{i[mb>>0]=i[Fb>>0]|0;mb=mb+1|0;Fb=Fb+1|0}while((mb|0)<(hb|0));wr((k[Gb>>2]|0)+17|0,d|0,256)|0;if((Ab|0)>16){gb=Mb;lb=Ab;ib=Nb}else{Pb=Mb;Qb=Ab;Rb=Nb;break}}}else{Pb=fb;Qb=ab;Rb=Pa}if(Qb){ib=k[a>>2]|0;k[ib+20>>2]=12;qb[k[ib>>2]&127](a)}k[cb>>2]=Rb;k[bb>>2]=Pb;break}case 219:{ib=k[g>>2]|0;lb=ib+4|0;gb=k[lb>>2]|0;if(!gb){if(!(ub[k[ib+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Sb=k[lb>>2]|0}else Sb=gb;gb=k[ib>>2]|0;nb=Sb+-1|0;Qa=gb+1|0;Ta=l[gb>>0]<<8;if(!nb){if(!(ub[k[ib+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Tb=k[lb>>2]|0;Ub=k[ib>>2]|0}else{Tb=nb;Ub=Qa}Qa=Tb+-1|0;nb=Ub+1|0;gb=l[Ub>>0]|Ta;Ta=gb+-2|0;if(gb>>>0>2){gb=ib+12|0;Ua=Qa;Va=Ta;Ra=nb;while(1){Fb=Va+-1|0;if(!Ua){if(!(ub[k[gb>>2]&63](a)|0)){Ma=0;Na=303;break a}Vb=k[lb>>2]|0;Wb=k[ib>>2]|0}else{Vb=Ua;Wb=Ra}mb=l[Wb>>0]|0;hb=mb>>>4;ob=mb&15;mb=k[a>>2]|0;k[mb+20>>2]=83;k[mb+24>>2]=ob;k[mb+28>>2]=hb;rb[k[mb+4>>2]&31](a,1);if(ob>>>0>3){mb=k[a>>2]|0;k[mb+20>>2]=32;k[mb+24>>2]=ob;qb[k[mb>>2]&127](a)}mb=a+164+(ob<<2)|0;ob=k[mb>>2]|0;if(!ob){Bb=Ck(a)|0;k[mb>>2]=Bb;Xb=Bb}else Xb=ob;ob=(hb|0)!=0;if(ob)if((Va|0)<129){hb=0;do{j[Xb+(hb<<1)>>1]=1;hb=hb+1|0}while((hb|0)!=64);Yb=Fb>>1;Na=150}else Na=157;else if((Va|0)<65){hb=0;do{j[Xb+(hb<<1)>>1]=1;hb=hb+1|0}while((hb|0)!=64);Yb=Fb;Na=150}else Na=157;b:do if((Na|0)==150){Na=0;switch(Yb|0){case 4:{Zb=4;_b=121164;break}case 9:{Zb=Yb;_b=121064;break}case 16:{Zb=Yb;_b=120936;break}case 25:{Zb=Yb;_b=120772;break}case 36:{Zb=Yb;_b=120564;break}case 49:{Zb=Yb;_b=120304;break}default:{hb=Vb+-1|0;Ab=Wb+1|0;if((Yb|0)>0){$b=hb;ac=Yb;bc=119984;cc=Ab;Na=159;break b}else{dc=hb;ec=Yb;fc=Ab;break b}}}$b=Vb+-1|0;ac=Zb;bc=_b;cc=Wb+1|0;Na=159}else if((Na|0)==157){Na=0;$b=Vb+-1|0;ac=64;bc=119984;cc=Wb+1|0;Na=159}while(0);if((Na|0)==159){Na=0;Ab=$b;hb=0;Gb=cc;while(1){Bb=(Ab|0)==0;if(ob){if(Bb){if(!(ub[k[gb>>2]&63](a)|0)){Ma=0;Na=303;break a}gc=k[lb>>2]|0;hc=k[ib>>2]|0}else{gc=Ab;hc=Gb}mb=gc+-1|0;Eb=hc+1|0;ic=l[hc>>0]<<8;if(!mb){if(!(ub[k[gb>>2]&63](a)|0)){Ma=0;Na=303;break a}jc=k[lb>>2]|0;kc=k[ib>>2]|0}else{jc=mb;kc=Eb}lc=jc;mc=kc;nc=l[kc>>0]|ic}else{if(Bb){if(!(ub[k[gb>>2]&63](a)|0)){Ma=0;Na=303;break a}oc=k[lb>>2]|0;pc=k[ib>>2]|0}else{oc=Ab;pc=Gb}lc=oc;mc=pc;nc=l[pc>>0]|0}j[Xb+(k[bc+(hb<<2)>>2]<<1)>>1]=nc;hb=hb+1|0;Bb=lc+-1|0;ic=mc+1|0;if((hb|0)>=(ac|0)){dc=Bb;ec=ac;fc=ic;break}else{Ab=Bb;Gb=ic}}}Gb=k[a>>2]|0;c:do if((k[Gb+104>>2]|0)>1){Ab=Gb;hb=0;while(1){k[Ab+24>>2]=m[Xb+(hb<<1)>>1];k[Ab+28>>2]=m[Xb+((hb|1)<<1)>>1];k[Ab+32>>2]=m[Xb+((hb|2)<<1)>>1];k[Ab+36>>2]=m[Xb+((hb|3)<<1)>>1];k[Ab+40>>2]=m[Xb+((hb|4)<<1)>>1];k[Ab+44>>2]=m[Xb+((hb|5)<<1)>>1];k[Ab+48>>2]=m[Xb+((hb|6)<<1)>>1];k[Ab+52>>2]=m[Xb+((hb|7)<<1)>>1];k[Ab+20>>2]=95;rb[k[Ab+4>>2]&31](a,2);ic=hb+8|0;if((ic|0)>=64)break c;Ab=k[a>>2]|0;hb=ic}}while(0);Gb=Fb-ec+(ob?0-ec|0:0)|0;if((Gb|0)>0){Ua=dc;Va=Gb;Ra=fc}else{qc=dc;rc=Gb;sc=fc;break}}}else{qc=Qa;rc=Ta;sc=nb}if(rc){Ra=k[a>>2]|0;k[Ra+20>>2]=12;qb[k[Ra>>2]&127](a)}k[ib>>2]=sc;k[lb>>2]=qc;break}case 221:{Ra=k[g>>2]|0;Va=Ra+4|0;Ua=k[Va>>2]|0;if(!Ua){if(!(ub[k[Ra+12>>2]&63](a)|0)){Ma=0;Na=303;break a}tc=k[Va>>2]|0}else tc=Ua;Ua=k[Ra>>2]|0;gb=tc+-1|0;bb=Ua+1|0;cb=l[Ua>>0]<<8;if(!gb){if(!(ub[k[Ra+12>>2]&63](a)|0)){Ma=0;Na=303;break a}uc=k[Va>>2]|0;vc=k[Ra>>2]|0}else{uc=gb;vc=bb}bb=uc+-1|0;gb=vc+1|0;if((l[vc>>0]|cb|0)!=4){cb=k[a>>2]|0;k[cb+20>>2]=12;qb[k[cb>>2]&127](a)}if(!bb){if(!(ub[k[Ra+12>>2]&63](a)|0)){Ma=0;Na=303;break a}wc=k[Va>>2]|0;xc=k[Ra>>2]|0}else{wc=bb;xc=gb}gb=wc+-1|0;bb=xc+1|0;cb=l[xc>>0]<<8;if(!gb){if(!(ub[k[Ra+12>>2]&63](a)|0)){Ma=0;Na=303;break a}yc=k[Va>>2]|0;zc=k[Ra>>2]|0}else{yc=gb;zc=bb}bb=l[zc>>0]|cb;cb=k[a>>2]|0;k[cb+20>>2]=84;k[cb+24>>2]=bb;rb[k[cb+4>>2]&31](a,1);k[ha>>2]=bb;k[Ra>>2]=zc+1;k[Va>>2]=yc+-1;break}case 248:{Va=k[g>>2]|0;Ra=k[Va>>2]|0;bb=Va+4|0;cb=k[bb>>2]|0;if(!(k[(k[f>>2]|0)+16>>2]|0)){gb=k[a>>2]|0;k[gb+20>>2]=60;Sq(gb+24|0,156277,80)|0;qb[k[k[a>>2]>>2]&127](a)}do if((k[Ja>>2]|0)>=3){if(!cb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Ac=k[bb>>2]|0;Bc=k[Va>>2]|0}else{Ac=cb;Bc=Ra}gb=Ac+-1|0;Ua=Bc+1|0;Pa=l[Bc>>0]<<8;if(!gb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Cc=k[bb>>2]|0;Dc=k[Va>>2]|0}else{Cc=gb;Dc=Ua}Ua=Cc+-1|0;gb=Dc+1|0;if((l[Dc>>0]|Pa|0)!=24){Pa=k[a>>2]|0;k[Pa+20>>2]=12;qb[k[Pa>>2]&127](a)}if(!Ua){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Ec=k[bb>>2]|0;Fc=k[Va>>2]|0}else{Ec=Ua;Fc=gb}gb=Ec+-1|0;Ua=Fc+1|0;if((i[Fc>>0]|0)!=13){Pa=k[a>>2]|0;k[Pa+20>>2]=70;k[Pa+24>>2]=k[e>>2];qb[k[Pa>>2]&127](a)}if(!gb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Gc=k[bb>>2]|0;Hc=k[Va>>2]|0}else{Gc=gb;Hc=Ua}Ua=Gc+-1|0;gb=Hc+1|0;Pa=l[Hc>>0]<<8;if(!Ua){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Ic=k[bb>>2]|0;Jc=k[Va>>2]|0}else{Ic=Ua;Jc=gb}gb=Ic+-1|0;Ua=Jc+1|0;if((l[Jc>>0]|Pa|0)==255){if(!gb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Kc=k[bb>>2]|0;Lc=k[Va>>2]|0}else{Kc=gb;Lc=Ua}Pa=Kc+-1|0;ab=Lc+1|0;if((i[Lc>>0]|0)==3){if(!Pa){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Mc=k[bb>>2]|0;Nc=k[Va>>2]|0}else{Mc=Pa;Nc=ab}fb=Mc+-1|0;Gb=Nc+1|0;hb=k[Ka>>2]|0;if((l[Nc>>0]|0)==(k[hb+88>>2]|0)){if(!fb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Oc=k[Ka>>2]|0;Pc=k[bb>>2]|0;Qc=k[Va>>2]|0}else{Oc=hb;Pc=fb;Qc=Gb}hb=Pc+-1|0;Ab=Qc+1|0;if((l[Qc>>0]|0)==(k[Oc>>2]|0)){if(!hb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Rc=k[Ka>>2]|0;Sc=k[bb>>2]|0;Tc=k[Va>>2]|0}else{Rc=Oc;Sc=hb;Tc=Ab}ic=Sc+-1|0;Bb=Tc+1|0;if((l[Tc>>0]|0)!=(k[Rc+176>>2]|0)){Uc=ic;Vc=Bb;Na=288;break}if(!ic){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Wc=k[bb>>2]|0;Xc=k[Va>>2]|0}else{Wc=ic;Xc=Bb}Bb=Wc+-1|0;ic=Xc+1|0;if((i[Xc>>0]|0)!=-128){Uc=Bb;Vc=ic;Na=288;break}if(!Bb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Yc=k[bb>>2]|0;Zc=k[Va>>2]|0}else{Yc=Bb;Zc=ic}ic=Yc+-1|0;Bb=Zc+1|0;Eb=l[Zc>>0]<<8;if(!ic){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}_c=k[bb>>2]|0;$c=k[Va>>2]|0}else{_c=ic;$c=Bb}Bb=_c+-1|0;ic=$c+1|0;if(l[$c>>0]|Eb){Uc=Bb;Vc=ic;Na=288;break}if(!Bb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}ad=k[bb>>2]|0;bd=k[Va>>2]|0}else{ad=Bb;bd=ic}ic=ad+-1|0;Bb=bd+1|0;Eb=l[bd>>0]<<8;if(!ic){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}cd=k[bb>>2]|0;dd=k[Va>>2]|0}else{cd=ic;dd=Bb}Bb=cd+-1|0;ic=dd+1|0;if(l[dd>>0]|Eb){Uc=Bb;Vc=ic;Na=288;break}if(!Bb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}ed=k[bb>>2]|0;fd=k[Va>>2]|0}else{ed=Bb;fd=ic}ic=ed+-1|0;Bb=fd+1|0;if(i[fd>>0]|0){Uc=ic;Vc=Bb;Na=288;break}if(!ic){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}gd=k[bb>>2]|0;hd=k[Va>>2]|0}else{gd=ic;hd=Bb}Bb=gd+-1|0;ic=hd+1|0;Eb=l[hd>>0]<<8;if(!Bb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}id=k[bb>>2]|0;jd=k[Va>>2]|0}else{id=Bb;jd=ic}ic=id+-1|0;Bb=jd+1|0;if((l[jd>>0]|Eb|0)!=1){Uc=ic;Vc=Bb;Na=288;break}if(!ic){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}kd=k[bb>>2]|0;ld=k[Va>>2]|0}else{kd=ic;ld=Bb}Bb=kd+-1|0;ic=ld+1|0;Eb=l[ld>>0]<<8;if(!Bb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}md=k[bb>>2]|0;nd=k[Va>>2]|0}else{md=Bb;nd=ic}ic=md+-1|0;Bb=nd+1|0;if(l[nd>>0]|Eb){Uc=ic;Vc=Bb;Na=288;break}if(!ic){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}od=k[bb>>2]|0;pd=k[Va>>2]|0}else{od=ic;pd=Bb}Bb=od+-1|0;ic=pd+1|0;if(i[pd>>0]|0){Uc=Bb;Vc=ic;Na=288;break}if(!Bb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}qd=k[bb>>2]|0;rd=k[Va>>2]|0}else{qd=Bb;rd=ic}ic=qd+-1|0;Bb=rd+1|0;Eb=l[rd>>0]<<8;if(!ic){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}sd=k[bb>>2]|0;td=k[Va>>2]|0}else{sd=ic;td=Bb}Bb=sd+-1|0;ic=td+1|0;if((l[td>>0]|Eb|0)!=1){Uc=Bb;Vc=ic;Na=288;break}if(!Bb){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}ud=k[bb>>2]|0;vd=k[Va>>2]|0}else{ud=Bb;vd=ic}ic=ud+-1|0;Bb=vd+1|0;Eb=l[vd>>0]<<8;if(!ic){if(!(ub[k[Va+12>>2]&63](a)|0)){Ma=0;Na=303;break a}wd=k[bb>>2]|0;xd=k[Va>>2]|0}else{wd=ic;xd=Bb}Bb=wd+-1|0;ic=xd+1|0;if(!(l[xd>>0]|Eb)){yd=Bb;zd=ic}else{Uc=Bb;Vc=ic;Na=288}}else{Uc=hb;Vc=Ab;Na=288}}else{Uc=fb;Vc=Gb;Na=288}}else{Uc=Pa;Vc=ab;Na=288}}else{Uc=gb;Vc=Ua;Na=288}}else{Uc=cb;Vc=Ra;Na=288}while(0);if((Na|0)==288){Na=0;Ra=k[a>>2]|0;k[Ra+20>>2]=28;qb[k[Ra>>2]&127](a);yd=Uc;zd=Vc}k[ja>>2]=1;k[Va>>2]=zd;k[bb>>2]=yd;break}case 239:case 238:case 237:case 236:case 235:case 234:case 233:case 232:case 231:case 230:case 229:case 228:case 227:case 226:case 225:case 224:{if(!(ub[k[(k[f>>2]|0)+32+(Oa+-224<<2)>>2]&63](a)|0)){Ma=0;Na=303;break a}break}case 254:{if(!(ub[k[(k[f>>2]|0)+28>>2]&63](a)|0)){Ma=0;Na=303;break a}break}case 1:case 215:case 214:case 213:case 212:case 211:case 210:case 209:case 208:{Ra=k[a>>2]|0;k[Ra+20>>2]=94;k[Ra+24>>2]=Oa;rb[k[Ra+4>>2]&31](a,1);break}case 220:{Ra=k[g>>2]|0;cb=Ra+4|0;lb=k[cb>>2]|0;if(!lb){if(!(ub[k[Ra+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Ad=k[cb>>2]|0}else Ad=lb;lb=k[Ra>>2]|0;ib=Ad+-1|0;nb=lb+1|0;Ta=l[lb>>0]<<8;if(!ib){if(!(ub[k[Ra+12>>2]&63](a)|0)){Ma=0;Na=303;break a}Bd=k[cb>>2]|0;Cd=k[Ra>>2]|0}else{Bd=ib;Cd=nb}nb=l[Cd>>0]|Ta;Ta=nb+-2|0;ib=k[a>>2]|0;k[ib+20>>2]=93;k[ib+24>>2]=k[e>>2];k[ib+28>>2]=Ta;rb[k[ib+4>>2]&31](a,1);k[Ra>>2]=Cd+1;k[cb>>2]=Bd+-1;if(nb>>>0>2)rb[k[(k[g>>2]|0)+16>>2]&31](a,Ta);break}default:{Ta=k[a>>2]|0;k[Ta+20>>2]=70;k[Ta+24>>2]=Oa;qb[k[Ta>>2]&127](a)}}while(0);k[e>>2]=0;La=0}if((Na|0)==25){La=k[g>>2]|0;g=k[La>>2]|0;Oa=La+4|0;Bd=k[Oa>>2]|0;if(!(k[(k[f>>2]|0)+16>>2]|0)){Cd=k[a>>2]|0;k[Cd+20>>2]=60;Sq(Cd+24|0,156273,80)|0;qb[k[k[a>>2]>>2]&127](a)}do if(!Bd)if(!(ub[k[La+12>>2]&63](a)|0)){Ma=0;r=b;return Ma|0}else{Dd=k[Oa>>2]|0;Ed=k[La>>2]|0;break}else{Dd=Bd;Ed=g}while(0);g=Dd+-1|0;Dd=Ed+1|0;Bd=l[Ed>>0]<<8;do if(!g)if(!(ub[k[La+12>>2]&63](a)|0)){Ma=0;r=b;return Ma|0}else{Fd=k[Oa>>2]|0;Gd=k[La>>2]|0;break}else{Fd=g;Gd=Dd}while(0);Dd=Fd+-1|0;Fd=Gd+1|0;g=l[Gd>>0]|Bd;do if(!Dd)if(!(ub[k[La+12>>2]&63](a)|0)){Ma=0;r=b;return Ma|0}else{Hd=k[Oa>>2]|0;Id=k[La>>2]|0;break}else{Hd=Dd;Id=Fd}while(0);Fd=i[Id>>0]|0;Dd=Fd&255;Bd=k[a>>2]|0;k[Bd+20>>2]=105;k[Bd+24>>2]=Dd;rb[k[Bd+4>>2]&31](a,1);do if(!((Fd&255)>4|(g|0)!=((Dd<<1)+6|0))){if(Fd<<24>>24){k[a+340>>2]=Dd;Bd=Hd+-1|0;Jd=(Bd|0)==0;Kd=Bd;Ld=Id+1|0;Na=42;break}if(k[a+224>>2]|0){k[a+340>>2]=Dd;Bd=Hd+-1|0;if(!Bd){Md=1;Na=61}else{Nd=1;Od=Bd;Pd=Id+1|0}}else Na=41}else Na=41;while(0);if((Na|0)==41){g=k[a>>2]|0;k[g+20>>2]=12;qb[k[g>>2]&127](a);k[a+340>>2]=Dd;g=Hd+-1|0;Hd=Id+1|0;Id=(g|0)==0;if(!(Fd<<24>>24)){Qd=Id;Rd=1;Sd=g;Td=Hd;Na=60}else{Jd=Id;Kd=g;Ld=Hd;Na=42}}d:do if((Na|0)==42){Hd=La+12|0;g=a+344|0;Id=Jd;Fd=Kd;Bd=0;Gd=Ld;while(1){if(Id){if(!(ub[k[Hd>>2]&63](a)|0)){Ma=0;Na=303;break}Ud=k[Oa>>2]|0;Vd=k[La>>2]|0}else{Ud=Fd;Vd=Gd}Ed=Ud+-1|0;Cd=Vd+1|0;Ad=l[Vd>>0]|0;e:do if((Bd|0)>0){yd=0;while(1){if((Ad|0)==(k[k[a+344+(yd<<2)>>2]>>2]|0))break;yd=yd+1|0;if((yd|0)>=(Bd|0)){Wd=Ad;break e}}yd=k[k[g>>2]>>2]|0;if((Bd|0)>1){ob=yd;Fb=1;while(1){zd=k[k[a+344+(Fb<<2)>>2]>>2]|0;ja=(zd|0)>(ob|0)?zd:ob;Fb=Fb+1|0;if((Fb|0)==(Bd|0)){Xd=ja;break}else ob=ja}}else Xd=yd;Wd=Xd+1|0}else Wd=Ad;while(0);Ad=k[Ka>>2]|0;bb=k[Ja>>2]|0;f:do if((bb|0)>0){Va=0;ob=Ad;while(1){if((Wd|0)==(k[ob>>2]|0)){Yd=ob;break f}Va=Va+1|0;Fb=ob+88|0;if((Va|0)>=(bb|0)){Zd=Fb;Na=55;break}else ob=Fb}}else{Zd=Ad;Na=55}while(0);if((Na|0)==55){Na=0;Ad=k[a>>2]|0;k[Ad+20>>2]=4;k[Ad+24>>2]=Wd;qb[k[Ad>>2]&127](a);Yd=Zd}k[a+344+(Bd<<2)>>2]=Yd;if(!Ed){if(!(ub[k[Hd>>2]&63](a)|0)){Ma=0;Na=303;break}_d=k[Oa>>2]|0;$d=k[La>>2]|0}else{_d=Ed;$d=Cd}Ad=l[$d>>0]|0;bb=Yd+20|0;k[bb>>2]=Ad>>>4;ob=Yd+24|0;k[ob>>2]=Ad&15;Ad=k[a>>2]|0;k[Ad+24>>2]=k[Yd>>2];k[Ad+28>>2]=k[bb>>2];k[Ad+32>>2]=k[ob>>2];k[Ad+20>>2]=106;rb[k[Ad+4>>2]&31](a,1);Bd=Bd+1|0;Ad=_d+-1|0;ob=$d+1|0;bb=(Ad|0)==0;if((Bd|0)>=(Dd|0)){Qd=bb;Rd=0;Sd=Ad;Td=ob;Na=60;break d}else{Id=bb;Fd=Ad;Gd=ob}}if((Na|0)==303){r=b;return Ma|0}}while(0);if((Na|0)==60)if(Qd){Md=Rd;Na=61}else{Nd=Rd;Od=Sd;Pd=Td}do if((Na|0)==61)if(!(ub[k[La+12>>2]&63](a)|0)){Ma=0;r=b;return Ma|0}else{Nd=Md;Od=k[Oa>>2]|0;Pd=k[La>>2]|0;break}while(0);Md=Od+-1|0;Od=Pd+1|0;Td=a+412|0;k[Td>>2]=l[Pd>>0];do if(!Md)if(!(ub[k[La+12>>2]&63](a)|0)){Ma=0;r=b;return Ma|0}else{ae=k[Oa>>2]|0;be=k[La>>2]|0;break}else{ae=Md;be=Od}while(0);Od=ae+-1|0;ae=be+1|0;Md=a+416|0;k[Md>>2]=l[be>>0];do if(!Od)if(!(ub[k[La+12>>2]&63](a)|0)){Ma=0;r=b;return Ma|0}else{ce=k[Oa>>2]|0;de=k[La>>2]|0;break}else{ce=Od;de=ae}while(0);ae=l[de>>0]|0;Od=a+420|0;k[Od>>2]=ae>>>4;be=a+424|0;k[be>>2]=ae&15;ae=k[a>>2]|0;k[ae+24>>2]=k[Td>>2];k[ae+28>>2]=k[Md>>2];k[ae+32>>2]=k[Od>>2];k[ae+36>>2]=k[be>>2];k[ae+20>>2]=107;rb[k[ae+4>>2]&31](a,1);k[(k[f>>2]|0)+20>>2]=0;if(!Nd){Nd=a+144|0;k[Nd>>2]=(k[Nd>>2]|0)+1}k[La>>2]=de+1;k[Oa>>2]=ce+-1;k[e>>2]=0;Ma=1;r=b;return Ma|0}else if((Na|0)==72){ce=k[a>>2]|0;k[ce+20>>2]=87;rb[k[ce+4>>2]&31](a,1);k[e>>2]=0;Ma=2;r=b;return Ma|0}else if((Na|0)==127){Ma=0;r=b;return Ma|0}else if((Na|0)==303){r=b;return Ma|0}return 0}function nl(a){a=a|0;var b=0,c=0,d=0,e=0,f=0;b=a+440|0;c=k[b>>2]|0;do if(!c)if(!(kl(a)|0)){d=0;return d|0}else{e=k[b>>2]|0;break}else e=c;while(0);c=a+464|0;f=k[(k[c>>2]|0)+20>>2]|0;if((e|0)!=(f+208|0)){if(!(yb[k[(k[a+24>>2]|0)+20>>2]&127](a,f)|0)){d=0;return d|0}}else{e=k[a>>2]|0;k[e+20>>2]=100;k[e+24>>2]=f;rb[k[e+4>>2]&31](a,3);k[b>>2]=0}b=(k[c>>2]|0)+20|0;k[b>>2]=(k[b>>2]|0)+1&7;d=1;return d|0}function ol(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,m=0;b=a+24|0;c=k[b>>2]|0;d=c+4|0;e=k[d>>2]|0;do if(!e)if(!(ub[k[c+12>>2]&63](a)|0)){f=0;return f|0}else{g=k[d>>2]|0;break}else g=e;while(0);e=k[c>>2]|0;h=g+-1|0;g=e+1|0;i=(l[e>>0]|0)<<8;do if(!h)if(!(ub[k[c+12>>2]&63](a)|0)){f=0;return f|0}else{j=k[d>>2]|0;m=k[c>>2]|0;break}else{j=h;m=g}while(0);g=l[m>>0]|0|i;i=g+-2|0;h=k[a>>2]|0;k[h+20>>2]=93;k[h+24>>2]=k[a+440>>2];k[h+28>>2]=i;rb[k[h+4>>2]&31](a,1);k[c>>2]=m+1;k[d>>2]=j+-1;if(g>>>0<=2){f=1;return f|0}rb[k[(k[b>>2]|0)+16>>2]&31](a,i);f=1;return f|0}function pl(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;b=r;r=r+16|0;c=b;d=a+24|0;e=k[d>>2]|0;f=e+4|0;g=k[f>>2]|0;do if(!g)if(!(ub[k[e+12>>2]&63](a)|0)){h=0;r=b;return h|0}else{j=k[f>>2]|0;break}else j=g;while(0);g=k[e>>2]|0;m=j+-1|0;j=g+1|0;n=l[g>>0]<<8;do if(!m)if(!(ub[k[e+12>>2]&63](a)|0)){h=0;r=b;return h|0}else{o=k[f>>2]|0;p=k[e>>2]|0;break}else{o=m;p=j}while(0);j=l[p>>0]|n;n=j+-2|0;m=(n|0)>13?14:j>>>0>2?n:0;j=o+-1|0;o=p+1|0;a:do if(!m){q=j;s=o}else{p=e+12|0;g=j;t=0;u=o;while(1){if(!g){if(!(ub[k[p>>2]&63](a)|0)){h=0;break}v=k[f>>2]|0;w=k[e>>2]|0}else{v=g;w=u}i[c+t>>0]=i[w>>0]|0;t=t+1|0;x=v+-1|0;y=w+1|0;if(t>>>0>=m>>>0){q=x;s=y;break a}else{g=x;u=y}}r=b;return h|0}while(0);w=n-m|0;v=k[a+440>>2]|0;b:do switch(v|0){case 224:{ql(a,c,m,w);break}case 238:{if((((m>>>0>11&(i[c>>0]|0)==65?(i[c+1>>0]|0)==100:0)?(i[c+2>>0]|0)==111:0)?(i[c+3>>0]|0)==98:0)?(i[c+4>>0]|0)==101:0){o=l[c+7>>0]<<8|l[c+8>>0];j=l[c+9>>0]<<8|l[c+10>>0];u=i[c+11>>0]|0;g=k[a>>2]|0;k[g+24>>2]=l[c+5>>0]<<8|l[c+6>>0];k[g+28>>2]=o;k[g+32>>2]=j;k[g+36>>2]=u&255;k[g+20>>2]=78;rb[k[g+4>>2]&31](a,1);k[a+296>>2]=1;i[a+300>>0]=u;break b}u=k[a>>2]|0;k[u+20>>2]=80;k[u+24>>2]=n;rb[k[u+4>>2]&31](a,1);break}default:{u=k[a>>2]|0;k[u+20>>2]=70;k[u+24>>2]=v;qb[k[u>>2]&127](a)}}while(0);k[e>>2]=s;k[f>>2]=q;if((w|0)<=0){h=1;r=b;return h|0}rb[k[(k[d>>2]|0)+16>>2]&31](a,w);h=1;r=b;return h|0}function ql(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;e=d+c|0;if(c>>>0>13){if((i[b>>0]|0)==74)if((((i[b+1>>0]|0)==70?(i[b+2>>0]|0)==73:0)?(i[b+3>>0]|0)==70:0)?(i[b+4>>0]|0)==0:0){k[a+284>>2]=1;d=i[b+5>>0]|0;f=a+288|0;i[f>>0]=d;g=i[b+6>>0]|0;h=a+289|0;i[h>>0]=g;m=i[b+7>>0]|0;n=a+290|0;i[n>>0]=m;o=(l[b+8>>0]<<8|l[b+9>>0])&65535;p=a+292|0;j[p>>1]=o;q=(l[b+10>>0]<<8|l[b+11>>0])&65535;r=a+294|0;j[r>>1]=q;if((d+-1&255)<2){s=a;t=d;u=g;v=o;w=q;x=m}else{m=k[a>>2]|0;k[m+20>>2]=122;k[m+24>>2]=d&255;k[m+28>>2]=g&255;rb[k[m+4>>2]&31](a,-1);s=a;t=i[f>>0]|0;u=i[h>>0]|0;v=j[p>>1]|0;w=j[r>>1]|0;x=i[n>>0]|0}n=k[a>>2]|0;k[n+24>>2]=t&255;k[n+28>>2]=u&255;k[n+32>>2]=v&65535;k[n+36>>2]=w&65535;k[n+40>>2]=x&255;k[n+20>>2]=89;rb[k[n+4>>2]&31](s,1);n=b+12|0;x=i[n>>0]|0;w=b+13|0;v=i[w>>0]|0;if(!((v|x)<<24>>24)){y=x;z=v}else{v=k[a>>2]|0;k[v+20>>2]=92;k[v+24>>2]=l[n>>0];k[v+28>>2]=l[w>>0];rb[k[v+4>>2]&31](s,1);y=i[n>>0]|0;z=i[w>>0]|0}w=e+-14|0;if((w|0)==(ha((y&255)*3|0,z&255)|0))return;z=k[a>>2]|0;k[z+20>>2]=90;k[z+24>>2]=w;rb[k[z+4>>2]&31](s,1);return}else A=16}else if(c>>>0>5?(i[b>>0]|0)==74:0)A=16;if(((((A|0)==16?(i[b+1>>0]|0)==70:0)?(i[b+2>>0]|0)==88:0)?(i[b+3>>0]|0)==88:0)?(i[b+4>>0]|0)==0:0){A=b+5|0;switch(l[A>>0]|0){case 16:{b=k[a>>2]|0;k[b+20>>2]=110;k[b+24>>2]=e;rb[k[b+4>>2]&31](a,1);return}case 17:{b=k[a>>2]|0;k[b+20>>2]=111;k[b+24>>2]=e;rb[k[b+4>>2]&31](a,1);return}case 19:{b=k[a>>2]|0;k[b+20>>2]=112;k[b+24>>2]=e;rb[k[b+4>>2]&31](a,1);return}default:{b=k[a>>2]|0;k[b+20>>2]=91;k[b+24>>2]=l[A>>0];k[b+28>>2]=e;rb[k[b+4>>2]&31](a,1);return}}}b=k[a>>2]|0;k[b+20>>2]=79;k[b+24>>2]=e;rb[k[b+4>>2]&31](a,1);return}function rl(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0;e=k[a+24>>2]|0;f=k[e>>2]|0;g=e+4|0;h=k[g>>2]|0;k[a+220>>2]=b;k[a+224>>2]=c;k[a+228>>2]=d;do if(!h)if(!(ub[k[e+12>>2]&63](a)|0)){i=0;return i|0}else{j=k[g>>2]|0;m=k[e>>2]|0;break}else{j=h;m=f}while(0);f=j+-1|0;j=m+1|0;h=(l[m>>0]|0)<<8;do if(!f)if(!(ub[k[e+12>>2]&63](a)|0)){i=0;return i|0}else{n=k[g>>2]|0;o=k[e>>2]|0;break}else{n=f;o=j}while(0);j=n+-1|0;n=o+1|0;f=l[o>>0]|0|h;do if(!j)if(!(ub[k[e+12>>2]&63](a)|0)){i=0;return i|0}else{p=k[g>>2]|0;q=k[e>>2]|0;break}else{p=j;q=n}while(0);n=p+-1|0;p=q+1|0;k[a+212>>2]=l[q>>0];do if(!n)if(!(ub[k[e+12>>2]&63](a)|0)){i=0;return i|0}else{r=k[g>>2]|0;s=k[e>>2]|0;break}else{r=n;s=p}while(0);p=r+-1|0;r=s+1|0;n=(l[s>>0]|0)<<8;s=a+32|0;k[s>>2]=n;do if(!p)if(!(ub[k[e+12>>2]&63](a)|0)){i=0;return i|0}else{t=k[s>>2]|0;u=k[g>>2]|0;v=k[e>>2]|0;break}else{t=n;u=p;v=r}while(0);r=u+-1|0;u=v+1|0;k[s>>2]=t+(l[v>>0]|0);do if(!r)if(!(ub[k[e+12>>2]&63](a)|0)){i=0;return i|0}else{w=k[g>>2]|0;x=k[e>>2]|0;break}else{w=r;x=u}while(0);u=w+-1|0;w=x+1|0;r=(l[x>>0]|0)<<8;x=a+28|0;k[x>>2]=r;do if(!u)if(!(ub[k[e+12>>2]&63](a)|0)){i=0;return i|0}else{y=k[x>>2]|0;z=k[g>>2]|0;A=k[e>>2]|0;break}else{y=r;z=u;A=w}while(0);w=z+-1|0;z=A+1|0;k[x>>2]=y+(l[A>>0]|0);do if(!w)if(!(ub[k[e+12>>2]&63](a)|0)){i=0;return i|0}else{B=k[g>>2]|0;C=k[e>>2]|0;break}else{B=w;C=z}while(0);z=a+36|0;k[z>>2]=l[C>>0];w=f+-8|0;f=k[a>>2]|0;k[f+24>>2]=k[a+440>>2];k[f+28>>2]=k[x>>2];k[f+32>>2]=k[s>>2];k[f+36>>2]=k[z>>2];k[f+20>>2]=102;rb[k[f+4>>2]&31](a,1);f=a+464|0;if(k[(k[f>>2]|0)+16>>2]|0){A=k[a>>2]|0;k[A+20>>2]=61;qb[k[A>>2]&127](a)}if(((k[s>>2]|0)!=0?(k[x>>2]|0)!=0:0)?(x=k[z>>2]|0,(x|0)>=1):0)D=x;else{x=k[a>>2]|0;k[x+20>>2]=33;qb[k[x>>2]&127](a);D=k[z>>2]|0}if((w|0)!=(D*3|0)){D=k[a>>2]|0;k[D+20>>2]=12;qb[k[D>>2]&127](a)}D=a+216|0;if(!(k[D>>2]|0)){w=nb[k[k[a+4>>2]>>2]&63](a,1,(k[z>>2]|0)*88|0)|0;k[D>>2]=w}w=B+-1|0;B=C+1|0;a:do if((k[z>>2]|0)>0){C=e+12|0;x=w;s=0;A=B;while(1){if(!x){if(!(ub[k[C>>2]&63](a)|0)){i=0;E=55;break}F=k[g>>2]|0;G=k[e>>2]|0}else{F=x;G=A}y=F+-1|0;u=G+1|0;r=l[G>>0]|0;v=k[D>>2]|0;b:do if((s|0)>0){t=v;p=0;while(1){if((r|0)==(k[t>>2]|0))break;p=p+1|0;n=t+88|0;if((p|0)>=(s|0)){H=r;I=n;break b}else t=n}t=k[v>>2]|0;p=v+88|0;if((s|0)>1){n=v;q=t;j=p;h=1;while(1){o=k[n+88>>2]|0;m=(o|0)>(q|0)?o:q;h=h+1|0;if((h|0)==(s|0)){J=m;break}else{o=j;q=m;j=j+88|0;n=o}}K=J;L=v+(s*88|0)|0}else{K=t;L=p}H=K+1|0;I=L}else{H=r;I=v}while(0);k[I>>2]=H;k[I+4>>2]=s;if(!y){if(!(ub[k[C>>2]&63](a)|0)){i=0;E=55;break}M=k[g>>2]|0;N=k[e>>2]|0}else{M=y;N=u}v=M+-1|0;r=N+1|0;n=l[N>>0]|0;j=I+8|0;k[j>>2]=n>>>4;q=I+12|0;k[q>>2]=n&15;if(!v){if(!(ub[k[C>>2]&63](a)|0)){i=0;E=55;break}O=k[g>>2]|0;P=k[e>>2]|0}else{O=v;P=r}r=I+16|0;k[r>>2]=l[P>>0];v=k[a>>2]|0;k[v+24>>2]=k[I>>2];k[v+28>>2]=k[j>>2];k[v+32>>2]=k[q>>2];k[v+36>>2]=k[r>>2];k[v+20>>2]=103;rb[k[v+4>>2]&31](a,1);s=s+1|0;v=O+-1|0;r=P+1|0;if((s|0)>=(k[z>>2]|0)){Q=v;R=r;break a}else{x=v;A=r}}if((E|0)==55)return i|0}else{Q=w;R=B}while(0);k[(k[f>>2]|0)+16>>2]=1;k[e>>2]=R;k[g>>2]=Q;i=1;return i|0}function sl(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;b=k[a+20>>2]|0;if((b|0)!=202){c=k[a>>2]|0;k[c+20>>2]=21;k[c+24>>2]=b;qb[k[c>>2]&127](a)}cl(a);c=k[a+216>>2]|0;b=a+36|0;d=k[b>>2]|0;e=(d|0)>0;if(e){f=k[a+324>>2]|0;g=(k[a+76>>2]|0)!=0?8:4;h=a+320|0;i=k[a+328>>2]|0;if((f|0)>(g|0)){j=(i|0)>(g|0);l=f<<1;m=0;n=c;while(1){o=n+36|0;k[o>>2]=f;a:do if(j)p=1;else{q=k[h>>2]|0;r=k[n+12>>2]|0;s=1;while(1){t=s<<1;if((q|0)%(ha(t,r)|0)|0){p=s;break a}if((ha(i,t)|0)>(g|0)){p=t;break}else s=t}}while(0);s=ha(i,p)|0;r=n+40|0;k[r>>2]=s;q=s<<1;if((f|0)<=(q|0)){if((s|0)>(l|0))k[r>>2]=l}else k[o>>2]=q;m=m+1|0;if((m|0)>=(d|0))break;else n=n+88|0}}else{n=k[a+316>>2]|0;m=(i|0)>(g|0);l=0;p=c;while(1){j=k[p+8>>2]|0;q=1;while(1){r=q<<1;if((n|0)%(ha(r,j)|0)|0){u=q;break}if((ha(f,r)|0)>(g|0)){u=r;break}else q=r}q=ha(f,u)|0;j=p+36|0;k[j>>2]=q;b:do if(m)v=1;else{o=k[h>>2]|0;r=k[p+12>>2]|0;s=1;while(1){t=s<<1;if((o|0)%(ha(t,r)|0)|0){v=s;break b}if((ha(i,t)|0)>(g|0)){v=t;break}else s=t}}while(0);s=ha(i,v)|0;r=p+40|0;k[r>>2]=s;o=s<<1;if((q|0)<=(o|0)){t=q<<1;if((s|0)>(t|0))k[r>>2]=t}else k[j>>2]=o;l=l+1|0;if((l|0)>=(d|0))break;else p=p+88|0}}if(e){e=a+28|0;p=a+316|0;l=a+428|0;v=a+32|0;i=a+320|0;g=0;h=c;while(1){c=ha(ha(k[h+8>>2]|0,k[e>>2]|0)|0,k[h+36>>2]|0)|0;m=pm(c,ha(k[l>>2]|0,k[p>>2]|0)|0)|0;k[h+44>>2]=m;m=ha(ha(k[h+12>>2]|0,k[v>>2]|0)|0,k[h+40>>2]|0)|0;c=pm(m,ha(k[l>>2]|0,k[i>>2]|0)|0)|0;k[h+48>>2]=c;g=g+1|0;c=k[b>>2]|0;if((g|0)>=(c|0)){w=c;break}else h=h+88|0}}else w=d}else w=d;switch(k[a+44>>2]|0){case 1:{k[a+120>>2]=1;x=1;break}case 6:case 2:{k[a+120>>2]=3;x=3;break}case 7:case 3:{k[a+120>>2]=3;x=3;break}case 5:case 4:{k[a+120>>2]=4;x=4;break}default:{k[a+120>>2]=w;x=w}}k[a+124>>2]=(k[a+84>>2]|0)==0?x:1;if(!(ul(a)|0)){y=1;z=a+128|0;k[z>>2]=y;return}y=k[a+320>>2]|0;z=a+128|0;k[z>>2]=y;return}function tl(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,j=0,l=0,m=0;b=a+4|0;c=nb[k[k[b>>2]>>2]&63](a,1,28)|0;k[a+444>>2]=c;k[c>>2]=43;k[c+4>>2]=44;k[c+8>>2]=0;d=k[a+212>>2]|0;if((d|0)!=8){e=k[a>>2]|0;k[e+20>>2]=16;k[e+24>>2]=d;qb[k[e>>2]&127](a)}sl(a);e=nb[k[k[b>>2]>>2]&63](a,1,1280)|0;qr(e|0,0,512)|0;k[a+336>>2]=e+512;d=0;do{i[e+(d+512)>>0]=d;d=d+1|0}while((d|0)!=256);qr(e+768|0,-1,512)|0;if(((k[a+116>>2]|0)!=0?(k[a+112>>2]|0)!=0:0)?(e=a+120|0,(k[e>>2]|0)>=1):0)f=e;else{e=k[a>>2]|0;k[e+20>>2]=33;qb[k[e>>2]&127](a);f=a+120|0}e=c+12|0;k[e>>2]=0;d=ul(a)|0;g=c+16|0;k[g>>2]=d;d=c+20|0;k[d>>2]=0;h=c+24|0;k[h>>2]=0;do if(!(k[a+84>>2]|0)){k[a+100>>2]=0;k[a+104>>2]=0;k[a+108>>2]=0;j=a+68|0}else{if(!(k[a+64>>2]|0)){k[a+100>>2]=0;k[a+104>>2]=0;k[a+108>>2]=0}c=a+68|0;if(k[c>>2]|0){l=k[a>>2]|0;k[l+20>>2]=48;qb[k[l>>2]&127](a)}do if((k[f>>2]|0)==3){if(k[a+136>>2]|0){k[a+104>>2]=1;break}if(!(k[a+92>>2]|0)){k[a+100>>2]=1;break}else{k[a+108>>2]=1;break}}else{k[a+100>>2]=1;k[a+104>>2]=0;k[a+108>>2]=0;k[a+136>>2]=0}while(0);if(k[a+100>>2]|0){Wl(a);k[d>>2]=k[a+484>>2]}if((k[a+108>>2]|0)==0?(k[a+104>>2]|0)==0:0){j=c;break}em(a);k[h>>2]=k[a+484>>2];j=c}while(0);if(!(k[j>>2]|0)){if(!(k[g>>2]|0)){Vn(a);Il(a)}else xl(a);Dl(a,k[a+108>>2]|0)}fo(a);if(!(k[a+228>>2]|0))ho(a);else Dn(a);g=a+460|0;if(!(k[(k[g>>2]|0)+16>>2]|0))m=(k[a+64>>2]|0)!=0;else m=1;Nn(a,m&1);if(!(k[j>>2]|0))to(a,0);qb[k[(k[b>>2]|0)+24>>2]&127](a);qb[k[(k[g>>2]|0)+8>>2]&127](a);b=k[a+8>>2]|0;if(!b)return;if(k[a+64>>2]|0)return;if(!(k[(k[g>>2]|0)+16>>2]|0))return;g=k[a+36>>2]|0;j=(k[a+224>>2]|0)==0?g:(g*3|0)+2|0;k[b+4>>2]=0;g=ha(j,k[a+332>>2]|0)|0;k[b+8>>2]=g;k[b+12>>2]=0;k[b+16>>2]=(k[a+108>>2]|0)!=0?3:2;k[e>>2]=(k[e>>2]|0)+1;return}function ul(a){a=a|0;var b=0,c=0;if(k[a+308>>2]|0)return 0;switch(k[a+40>>2]|0){case 7:case 3:break;default:return 0}if((k[a+36>>2]|0)!=3)return 0;if((k[a+44>>2]|0)!=2)return 0;if((k[a+120>>2]|0)!=3)return 0;if(k[a+304>>2]|0)return 0;b=k[a+216>>2]|0;if((k[b+8>>2]|0)!=2)return 0;if((k[b+96>>2]|0)!=1)return 0;if((k[b+184>>2]|0)!=1)return 0;if((k[b+12>>2]|0)>2)return 0;if((k[b+100>>2]|0)!=1)return 0;if((k[b+188>>2]|0)!=1)return 0;c=k[b+36>>2]|0;if((c|0)!=(k[a+324>>2]|0))return 0;if((k[b+124>>2]|0)!=(c|0))return 0;if((k[b+212>>2]|0)!=(c|0))return 0;c=k[b+40>>2]|0;if((c|0)!=(k[a+328>>2]|0))return 0;if((k[b+128>>2]|0)==(c|0))return (k[b+216>>2]|0)==(c|0)|0;else return 0;return 0}function vl(a){a=a|0;var b=0,c=0,d=0,e=0;b=k[a+444>>2]|0;c=b+8|0;if(!(k[c>>2]|0)){d=a+84|0;do if((k[d>>2]|0)!=0?(k[a+136>>2]|0)==0:0){if((k[a+92>>2]|0)!=0?(k[a+108>>2]|0)!=0:0){k[a+484>>2]=k[b+24>>2];k[c>>2]=1;break}if(!(k[a+100>>2]|0)){e=k[a>>2]|0;k[e+20>>2]=47;qb[k[e>>2]&127](a);break}else{k[a+484>>2]=k[b+20>>2];break}}while(0);qb[k[k[a+472>>2]>>2]&127](a);qb[k[(k[a+452>>2]|0)+8>>2]&127](a);if(!(k[a+68>>2]|0)){if(!(k[b+16>>2]|0))qb[k[k[a+480>>2]>>2]&127](a);qb[k[k[a+476>>2]>>2]&127](a);if(k[d>>2]|0)rb[k[k[a+484>>2]>>2]&31](a,k[c>>2]|0);rb[k[k[a+456>>2]>>2]&31](a,(k[c>>2]|0)!=0?3:0);rb[k[k[a+448>>2]>>2]&31](a,0)}}else{k[c>>2]=0;rb[k[k[a+484>>2]>>2]&31](a,0);rb[k[k[a+456>>2]>>2]&31](a,2);rb[k[k[a+448>>2]>>2]&31](a,2)}d=k[a+8>>2]|0;if(!d)return;e=k[b+12>>2]|0;k[d+12>>2]=e;b=((k[c>>2]|0)!=0?2:1)+e|0;e=d+16|0;k[e>>2]=b;if(!(k[a+64>>2]|0))return;if(k[(k[a+460>>2]|0)+20>>2]|0)return;k[e>>2]=b+((k[a+108>>2]|0)!=0?2:1);return}function wl(a){a=a|0;var b=0;b=k[a+444>>2]|0;if(k[a+84>>2]|0)qb[k[(k[a+484>>2]|0)+8>>2]&127](a);a=b+12|0;k[a>>2]=(k[a>>2]|0)+1;return}function xl(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0;b=a+4|0;c=nb[k[k[b>>2]>>2]&63](a,1,48)|0;d=a+476|0;k[d>>2]=c;k[c>>2]=45;k[c+8>>2]=0;e=ha(k[a+120>>2]|0,k[a+112>>2]|0)|0;k[c+40>>2]=e;f=c+4|0;if((k[a+320>>2]|0)==2){k[f>>2]=3;k[c+12>>2]=11;g=nb[k[(k[b>>2]|0)+4>>2]&63](a,1,e)|0;k[c+32>>2]=g;h=k[d>>2]|0}else{k[f>>2]=4;k[c+12>>2]=12;k[c+32>>2]=0;h=c}c=(k[a+40>>2]|0)==7;f=nb[k[k[b>>2]>>2]&63](a,1,1024)|0;d=h+16|0;k[d>>2]=f;f=nb[k[k[b>>2]>>2]&63](a,1,1024)|0;g=h+20|0;k[g>>2]=f;f=nb[k[k[b>>2]>>2]&63](a,1,1024)|0;e=h+24|0;k[e>>2]=f;f=nb[k[k[b>>2]>>2]&63](a,1,1024)|0;k[h+28>>2]=f;h=k[d>>2]|0;d=k[g>>2]|0;g=k[e>>2]|0;if(c){c=0;e=-128;while(1){k[h+(c<<2)>>2]=(e*183763|0)+32768>>16;k[d+(c<<2)>>2]=(e*232260|0)+32768>>16;a=ha(e,-93603)|0;k[g+(c<<2)>>2]=a;a=(ha(e,-45107)|0)+32768|0;k[f+(c<<2)>>2]=a;c=c+1|0;if((c|0)==256)break;else e=e+1|0}return}else{e=0;c=-128;while(1){k[h+(e<<2)>>2]=(c*91881|0)+32768>>16;k[d+(e<<2)>>2]=(c*116130|0)+32768>>16;a=ha(c,-46802)|0;k[g+(e<<2)>>2]=a;a=(ha(c,-22553)|0)+32768|0;k[f+(e<<2)>>2]=a;e=e+1|0;if((e|0)==256)break;else c=c+1|0}return}}function yl(a){a=a|0;var b=0;b=k[a+476>>2]|0;k[b+36>>2]=0;k[b+44>>2]=k[a+116>>2];return}function zl(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,l=0,m=0,n=0,o=0;d=r;r=r+16|0;h=d;i=k[a+476>>2]|0;j=i+36|0;if(!(k[j>>2]|0)){l=i+44|0;m=k[l>>2]|0;n=m>>>0<2?m:2;m=k[f>>2]|0;o=g-m|0;g=n>>>0>o>>>0?o:n;k[h>>2]=k[e+(m<<2)>>2];if(g>>>0>1)k[h+4>>2]=k[e+(m+1<<2)>>2];else{k[h+4>>2]=k[i+32>>2];k[j>>2]=1}Ab[k[i+12>>2]&31](a,b,k[c>>2]|0,h);h=(k[j>>2]|0)==0;k[f>>2]=(k[f>>2]|0)+g;k[l>>2]=(k[l>>2]|0)-g;if(!h){r=d;return}}else{rm(i+32|0,0,e+(k[f>>2]<<2)|0,0,1,k[i+40>>2]|0);k[j>>2]=0;j=i+44|0;k[f>>2]=(k[f>>2]|0)+1;k[j>>2]=(k[j>>2]|0)+-1}k[c>>2]=(k[c>>2]|0)+1;r=d;return}function Al(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;e=k[a+476>>2]|0;f=k[a+336>>2]|0;g=k[e+16>>2]|0;h=k[e+20>>2]|0;j=k[e+24>>2]|0;m=k[e+28>>2]|0;e=c<<1;n=k[b>>2]|0;o=k[n+(e<<2)>>2]|0;p=k[n+((e|1)<<2)>>2]|0;e=k[(k[b+4>>2]|0)+(c<<2)>>2]|0;n=k[(k[b+8>>2]|0)+(c<<2)>>2]|0;c=k[d>>2]|0;b=k[d+4>>2]|0;d=a+112|0;a=k[d>>2]|0;q=a>>>1;if(!q){r=a;s=o;t=p;u=e;v=n;w=c;x=b}else{a=q*6|0;y=q<<1;z=c+a|0;A=n+q|0;B=q;C=o;D=p;E=e;F=n;n=c;c=b;while(1){G=l[E>>0]|0;H=l[F>>0]|0;I=k[g+(H<<2)>>2]|0;J=(k[j+(H<<2)>>2]|0)+(k[m+(G<<2)>>2]|0)>>16;H=k[h+(G<<2)>>2]|0;G=l[C>>0]|0;i[n>>0]=i[f+(G+I)>>0]|0;i[n+1>>0]=i[f+(G+J)>>0]|0;i[n+2>>0]=i[f+(G+H)>>0]|0;G=l[C+1>>0]|0;i[n+3>>0]=i[f+(G+I)>>0]|0;i[n+4>>0]=i[f+(G+J)>>0]|0;i[n+5>>0]=i[f+(G+H)>>0]|0;G=l[D>>0]|0;i[c>>0]=i[f+(G+I)>>0]|0;i[c+1>>0]=i[f+(G+J)>>0]|0;i[c+2>>0]=i[f+(G+H)>>0]|0;G=l[D+1>>0]|0;i[c+3>>0]=i[f+(G+I)>>0]|0;i[c+4>>0]=i[f+(G+J)>>0]|0;i[c+5>>0]=i[f+(G+H)>>0]|0;B=B+-1|0;if(!B)break;else{C=C+2|0;D=D+2|0;E=E+1|0;F=F+1|0;n=n+6|0;c=c+6|0}}r=k[d>>2]|0;s=o+y|0;t=p+y|0;u=e+q|0;v=A;w=z;x=b+a|0}if(!(r&1))return;r=l[u>>0]|0;u=l[v>>0]|0;v=k[g+(u<<2)>>2]|0;g=(k[j+(u<<2)>>2]|0)+(k[m+(r<<2)>>2]|0)>>16;m=k[h+(r<<2)>>2]|0;r=l[s>>0]|0;i[w>>0]=i[f+(r+v)>>0]|0;i[w+1>>0]=i[f+(r+g)>>0]|0;i[w+2>>0]=i[f+(r+m)>>0]|0;r=l[t>>0]|0;i[x>>0]=i[f+(r+v)>>0]|0;i[x+1>>0]=i[f+(r+g)>>0]|0;i[x+2>>0]=i[f+(r+m)>>0]|0;return}function Bl(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Ab[k[(k[a+476>>2]|0)+12>>2]&31](a,b,k[c>>2]|0,e+(k[f>>2]<<2)|0);k[f>>2]=(k[f>>2]|0)+1;k[c>>2]=(k[c>>2]|0)+1;return}function Cl(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;e=k[a+476>>2]|0;f=k[a+336>>2]|0;g=k[e+16>>2]|0;h=k[e+20>>2]|0;j=k[e+24>>2]|0;m=k[e+28>>2]|0;e=k[(k[b>>2]|0)+(c<<2)>>2]|0;n=k[(k[b+4>>2]|0)+(c<<2)>>2]|0;o=k[(k[b+8>>2]|0)+(c<<2)>>2]|0;c=k[d>>2]|0;d=a+112|0;a=k[d>>2]|0;b=a>>>1;if(!b){p=a;q=e;r=n;s=o;t=c}else{a=b*6|0;u=b<<1;v=o+b|0;w=b;x=e;y=n;z=o;o=c;while(1){A=l[y>>0]|0;B=l[z>>0]|0;C=k[g+(B<<2)>>2]|0;D=(k[j+(B<<2)>>2]|0)+(k[m+(A<<2)>>2]|0)>>16;B=k[h+(A<<2)>>2]|0;A=l[x>>0]|0;i[o>>0]=i[f+(A+C)>>0]|0;i[o+1>>0]=i[f+(A+D)>>0]|0;i[o+2>>0]=i[f+(A+B)>>0]|0;A=l[x+1>>0]|0;i[o+3>>0]=i[f+(A+C)>>0]|0;i[o+4>>0]=i[f+(A+D)>>0]|0;i[o+5>>0]=i[f+(A+B)>>0]|0;w=w+-1|0;if(!w)break;else{x=x+2|0;y=y+1|0;z=z+1|0;o=o+6|0}}p=k[d>>2]|0;q=e+u|0;r=n+b|0;s=v;t=c+a|0}if(!(p&1))return;p=l[r>>0]|0;r=l[s>>0]|0;s=(k[j+(r<<2)>>2]|0)+(k[m+(p<<2)>>2]|0)>>16;m=k[h+(p<<2)>>2]|0;p=l[q>>0]|0;i[t>>0]=i[f+(p+(k[g+(r<<2)>>2]|0))>>0]|0;i[t+1>>0]=i[f+(p+s)>>0]|0;i[t+2>>0]=i[f+(p+m)>>0]|0;return}function Dl(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;c=a+4|0;d=nb[k[k[c>>2]>>2]&63](a,1,28)|0;k[a+456>>2]=d;k[d>>2]=10;e=d+8|0;k[e>>2]=0;f=d+12|0;k[f>>2]=0;if(!(k[a+84>>2]|0))return;g=k[a+320>>2]|0;h=d+16|0;k[h>>2]=g;d=k[c>>2]|0;c=k[a+112>>2]|0;i=k[a+120>>2]|0;if(!b){b=ha(i,c)|0;j=xb[k[d+8>>2]&63](a,1,b,g)|0;k[f>>2]=j;return}else{j=k[d+16>>2]|0;d=ha(i,c)|0;c=qm(k[a+116>>2]|0,g)|0;g=sb[j&3](a,1,0,d,c,k[h>>2]|0)|0;k[e>>2]=g;return}}function El(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=k[a+456>>2]|0;a:do switch(b|0){case 0:{if(!(k[a+84>>2]|0)){k[c+4>>2]=k[(k[a+476>>2]|0)+4>>2];break a}k[c+4>>2]=5;d=c+12|0;if(!(k[d>>2]|0)){e=zb[k[(k[a+4>>2]|0)+28>>2]&3](a,k[c+8>>2]|0,0,k[c+16>>2]|0,1)|0;k[d>>2]=e}break}case 3:{if(!(k[c+8>>2]|0)){e=k[a>>2]|0;k[e+20>>2]=3;qb[k[e>>2]&127](a)}k[c+4>>2]=6;break}case 2:{if(!(k[c+8>>2]|0)){e=k[a>>2]|0;k[e+20>>2]=3;qb[k[e>>2]&127](a)}k[c+4>>2]=7;break}default:{e=k[a>>2]|0;k[e+20>>2]=3;qb[k[e>>2]&127](a)}}while(0);k[c+24>>2]=0;k[c+20>>2]=0;return}function Fl(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,l=0,m=0;h=r;r=r+16|0;i=h;j=k[a+456>>2]|0;l=g-(k[f>>2]|0)|0;g=k[j+16>>2]|0;k[i>>2]=0;m=j+12|0;ob[k[(k[a+476>>2]|0)+4>>2]&15](a,b,c,d,k[m>>2]|0,i,l>>>0>g>>>0?g:l);Ab[k[(k[a+484>>2]|0)+4>>2]&31](a,k[m>>2]|0,e+(k[f>>2]<<2)|0,k[i>>2]|0);k[f>>2]=(k[f>>2]|0)+(k[i>>2]|0);r=h;return}function Gl(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0;g=k[a+456>>2]|0;e=g+24|0;h=k[e>>2]|0;if(!h){i=g+16|0;j=zb[k[(k[a+4>>2]|0)+28>>2]&3](a,k[g+8>>2]|0,k[g+20>>2]|0,k[i>>2]|0,1)|0;l=g+12|0;k[l>>2]=j;m=i;n=l;o=j;p=k[e>>2]|0}else{j=g+12|0;m=g+16|0;n=j;o=k[j>>2]|0;p=h}ob[k[(k[a+476>>2]|0)+4>>2]&15](a,b,c,d,o,e,k[m>>2]|0);o=k[e>>2]|0;if(o>>>0>p>>>0){d=o-p|0;Ab[k[(k[a+484>>2]|0)+4>>2]&31](a,(k[n>>2]|0)+(p<<2)|0,0,d);k[f>>2]=(k[f>>2]|0)+d;q=k[e>>2]|0}else q=o;o=k[m>>2]|0;if(q>>>0<o>>>0)return;q=g+20|0;k[q>>2]=(k[q>>2]|0)+o;k[e>>2]=0;return}function Hl(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,l=0,m=0,n=0,o=0;d=k[a+456>>2]|0;c=d+24|0;b=k[c>>2]|0;if(!b){h=d+20|0;i=d+16|0;j=zb[k[(k[a+4>>2]|0)+28>>2]&3](a,k[d+8>>2]|0,k[h>>2]|0,k[i>>2]|0,0)|0;k[d+12>>2]=j;l=h;m=i;n=k[c>>2]|0;o=j}else{l=d+20|0;m=d+16|0;n=b;o=k[d+12>>2]|0}d=(k[m>>2]|0)-n|0;b=k[f>>2]|0;j=g-b|0;g=d>>>0>j>>>0?j:d;d=(k[a+116>>2]|0)-(k[l>>2]|0)|0;j=g>>>0>d>>>0?d:g;Ab[k[(k[a+484>>2]|0)+4>>2]&31](a,o+(n<<2)|0,e+(b<<2)|0,j);k[f>>2]=(k[f>>2]|0)+j;f=(k[c>>2]|0)+j|0;k[c>>2]=f;j=k[m>>2]|0;if(f>>>0<j>>>0)return;k[l>>2]=(k[l>>2]|0)+j;k[c>>2]=0;return}function Il(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;b=a+4|0;c=nb[k[k[b>>2]>>2]&63](a,1,160)|0;k[a+476>>2]=c;k[c>>2]=46;k[c+4>>2]=8;k[c+8>>2]=0;if(k[a+308>>2]|0){d=k[a>>2]|0;k[d+20>>2]=26;qb[k[d>>2]&127](a)}d=a+36|0;if((k[d>>2]|0)<=0)return;e=a+324|0;f=a+328|0;g=a+316|0;h=a+320|0;j=c+100|0;l=c+52|0;m=a+112|0;n=c+12|0;o=0;p=k[a+216>>2]|0;while(1){q=ha(k[p+36>>2]|0,k[p+8>>2]|0)|0;r=(q|0)/(k[e>>2]|0)|0;q=ha(k[p+40>>2]|0,k[p+12>>2]|0)|0;s=(q|0)/(k[f>>2]|0)|0;q=k[g>>2]|0;t=k[h>>2]|0;k[j+(o<<2)>>2]=s;do if(!(k[p+52>>2]|0))k[l+(o<<2)>>2]=13;else{u=(s|0)==(t|0);if((r|0)==(q|0)&u){k[l+(o<<2)>>2]=14;break}v=(r<<1|0)==(q|0);do if(v&u)k[l+(o<<2)>>2]=15;else{if(v&(s<<1|0)==(t|0)){k[l+(o<<2)>>2]=16;break}if(((q|0)%(r|0)|0|0)==0?((t|0)%(s|0)|0|0)==0:0){k[l+(o<<2)>>2]=17;i[c+(o+140)>>0]=(q|0)/(r|0)|0;i[c+(o+150)>>0]=(t|0)/(s|0)|0;break}w=k[a>>2]|0;k[w+20>>2]=39;qb[k[w>>2]&127](a)}while(0);v=k[(k[b>>2]|0)+8>>2]|0;u=qm(k[m>>2]|0,k[g>>2]|0)|0;w=xb[v&63](a,1,u,k[h>>2]|0)|0;k[n+(o<<2)>>2]=w}while(0);o=o+1|0;if((o|0)>=(k[d>>2]|0))break;else p=p+88|0}return}function Jl(a){a=a|0;var b=0;b=k[a+476>>2]|0;k[b+92>>2]=k[a+320>>2];k[b+96>>2]=k[a+116>>2];return}function Kl(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;d=k[a+476>>2]|0;h=d+92|0;i=k[h>>2]|0;j=a+320|0;l=k[j>>2]|0;if((i|0)<(l|0)){m=l;n=i}else{i=a+36|0;if((k[i>>2]|0)>0){o=0;p=k[a+216>>2]|0;while(1){q=(k[b+(o<<2)>>2]|0)+((ha(k[d+100+(o<<2)>>2]|0,k[c>>2]|0)|0)<<2)|0;Ab[k[d+52+(o<<2)>>2]&31](a,p,q,d+12+(o<<2)|0);o=o+1|0;if((o|0)>=(k[i>>2]|0))break;else p=p+88|0}r=k[j>>2]|0}else r=l;k[h>>2]=0;m=r;n=0}r=m-n|0;m=d+96|0;l=k[m>>2]|0;p=r>>>0>l>>>0?l:r;r=k[f>>2]|0;l=g-r|0;g=p>>>0>l>>>0?l:p;pb[k[(k[a+480>>2]|0)+4>>2]&63](a,d+12|0,n,e+(r<<2)|0,g);k[f>>2]=(k[f>>2]|0)+g;k[m>>2]=(k[m>>2]|0)-g;m=(k[h>>2]|0)+g|0;k[h>>2]=m;if((m|0)<(k[j>>2]|0))return;k[c>>2]=(k[c>>2]|0)+1;return}function Ll(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;k[d>>2]=0;return}function Ml(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;k[d>>2]=c;return}function Nl(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,l=0,m=0;b=k[d>>2]|0;d=a+320|0;e=k[d>>2]|0;if((e|0)<=0)return;f=a+112|0;a=e;e=0;while(1){g=k[b+(e<<2)>>2]|0;h=k[f>>2]|0;j=g+h|0;if((h|0)>0){h=k[c+(e<<2)>>2]|0;l=g;while(1){g=i[h>>0]|0;i[l>>0]=g;i[l+1>>0]=g;l=l+2|0;if(l>>>0>=j>>>0)break;else h=h+1|0}m=k[d>>2]|0}else m=a;e=e+1|0;if((e|0)>=(m|0))break;else a=m}return}function Ol(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,l=0,m=0,n=0;b=k[d>>2]|0;d=a+320|0;if((k[d>>2]|0)<=0)return;e=a+112|0;a=0;f=0;while(1){g=k[b+(f<<2)>>2]|0;h=k[e>>2]|0;j=g+h|0;if((h|0)>0){l=k[c+(a<<2)>>2]|0;m=g;while(1){g=i[l>>0]|0;i[m>>0]=g;i[m+1>>0]=g;m=m+2|0;if(m>>>0>=j>>>0)break;else l=l+1|0}n=k[e>>2]|0}else n=h;rm(b,f,b,f|1,1,n);f=f+2|0;if((f|0)>=(k[d>>2]|0))break;else a=a+1|0}return}function Pl(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0;e=k[a+476>>2]|0;f=k[d>>2]|0;d=k[b+4>>2]|0;b=i[e+140+d>>0]|0;g=b&255;h=i[e+150+d>>0]|0;d=h&255;e=a+320|0;if((k[e>>2]|0)<=0)return;j=a+112|0;a=b<<24>>24!=0;l=d+-1|0;m=(b<<24>>24==0?~g:-2)+g+2|0;if((h&255)>1){h=0;g=0;while(1){b=k[f+(g<<2)>>2]|0;n=k[j>>2]|0;o=b+n|0;if((n|0)>0){if(!a){p=5;break}n=k[c+(h<<2)>>2]|0;q=b;while(1){qr(q|0,i[n>>0]|0,m|0)|0;q=q+m|0;if(q>>>0>=o>>>0)break;else n=n+1|0}}rm(f,g,f,g+1|0,l,k[j>>2]|0);g=g+d|0;if((g|0)>=(k[e>>2]|0)){p=15;break}else h=h+1|0}if((p|0)==5)while(1){p=0;p=5}else if((p|0)==15)return}else{h=0;g=0;while(1){l=k[f+(g<<2)>>2]|0;n=k[j>>2]|0;o=l+n|0;if((n|0)>0){if(!a){p=13;break}n=k[c+(h<<2)>>2]|0;q=l;while(1){qr(q|0,i[n>>0]|0,m|0)|0;q=q+m|0;if(q>>>0>=o>>>0)break;else n=n+1|0}}g=g+d|0;if((g|0)>=(k[e>>2]|0)){p=15;break}else h=h+1|0}if((p|0)==13)while(1){p=0;p=13}else if((p|0)==15)return}}function Ql(a){a=a|0;k[a>>2]=47;k[a+4>>2]=11;k[a+8>>2]=48;k[a+12>>2]=12;k[a+16>>2]=49;k[a+104>>2]=0;k[a+108>>2]=0;k[a+20>>2]=0;k[a+112>>2]=119460;k[a+116>>2]=126;k[a+120>>2]=0;k[a+124>>2]=0;k[a+128>>2]=0;return a|0}function Rl(a){a=a|0;qb[k[(k[a>>2]|0)+8>>2]&127](a);Bk(a);jb(1)}function Sl(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=k[a>>2]|0;if((b|0)>=0){if((k[c+104>>2]|0)<(b|0))return;qb[k[c+8>>2]&127](a);return}b=c+108|0;d=k[b>>2]|0;if((d|0)!=0?(k[c+104>>2]|0)<=2:0)e=d;else{qb[k[c+8>>2]&127](a);e=k[b>>2]|0}k[b>>2]=e+1;return}function Tl(a){a=a|0;var b=0,c=0,d=0;b=r;r=r+208|0;c=b;d=b+8|0;rb[k[(k[a>>2]|0)+12>>2]&31](a,d);a=k[30710]|0;k[c>>2]=d;wq(a,160973,c)|0;r=b;return}function Ul(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,j=0,l=0,m=0,n=0;c=r;r=r+48|0;d=c+8|0;e=c;f=k[a>>2]|0;a=k[f+20>>2]|0;if((a|0)>0?(a|0)<=(k[f+116>>2]|0):0){g=(k[f+112>>2]|0)+(a<<2)|0;h=8}else{j=k[f+120>>2]|0;if(((j|0)!=0?(l=k[f+124>>2]|0,(a|0)>=(l|0)):0)?(a|0)<=(k[f+128>>2]|0):0){g=j+(a-l<<2)|0;h=8}else h=9}if((h|0)==8){l=k[g>>2]|0;if(!l)h=9;else m=l}if((h|0)==9){k[f+24>>2]=a;m=k[k[f+112>>2]>>2]|0}a=m;a:while(1){l=a+1|0;switch(i[a>>0]|0){case 0:{break a;break}case 37:{n=l;h=12;break a;break}default:a=l}}if((h|0)==12?(i[n>>0]|0)==115:0){k[e>>2]=f+24;Bq(b,m,e)|0;r=c;return}e=k[f+28>>2]|0;n=k[f+32>>2]|0;h=k[f+36>>2]|0;a=k[f+40>>2]|0;l=k[f+44>>2]|0;g=k[f+48>>2]|0;j=k[f+52>>2]|0;k[d>>2]=k[f+24>>2];k[d+4>>2]=e;k[d+8>>2]=n;k[d+12>>2]=h;k[d+16>>2]=a;k[d+20>>2]=l;k[d+24>>2]=g;k[d+28>>2]=j;Bq(b,m,d)|0;r=c;return}function Vl(a){a=a|0;var b=0;b=k[a>>2]|0;k[b+108>>2]=0;k[b+20>>2]=0;return}function Wl(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;b=a+4|0;c=nb[k[k[b>>2]>>2]&63](a,1,88)|0;d=a+484|0;k[d>>2]=c;k[c>>2]=13;k[c+8>>2]=50;k[c+12>>2]=51;k[c+68>>2]=0;k[c+52>>2]=0;c=a+120|0;if((k[c>>2]|0)>4){e=k[a>>2]|0;k[e+20>>2]=57;k[e+24>>2]=4;qb[k[e>>2]&127](a)}e=a+96|0;f=k[e>>2]|0;if((f|0)>256){g=k[a>>2]|0;k[g+20>>2]=59;k[g+24>>2]=256;qb[k[g>>2]&127](a);h=k[e>>2]|0}else h=f;f=k[d>>2]|0;e=f+32|0;g=k[c>>2]|0;if((g|0)>1){j=1;while(1){l=j+1|0;m=1;n=l;while(1){o=ha(n,l)|0;m=m+1|0;if((m|0)==(g|0)){p=o;break}else n=o}if((p|0)>(h|0)){q=j;r=p;break}else j=l}}else{j=(h|0)>1?h:1;q=j;r=j+1|0}if((q|0)<2){j=k[a>>2]|0;k[j+20>>2]=58;k[j+24>>2]=r;qb[k[j>>2]&127](a)}if((g|0)>0){j=0;r=1;while(1){k[f+32+(j<<2)>>2]=q;p=ha(r,q)|0;j=j+1|0;if((j|0)==(g|0)){s=p;break}else r=p}}else s=1;r=a+44|0;j=0;q=0;p=s;a:while(1){s=j;n=q;while(1){if((n|0)<(g|0)){if((k[r>>2]|0)==2)t=k[119972+(n<<2)>>2]|0;else t=n;m=f+32+(t<<2)|0;o=k[m>>2]|0;u=o+1|0;v=ha((p|0)/(o|0)|0,u)|0;if((v|0)<=(h|0)){w=m;x=u;y=v;z=n;break}}if(!s){A=p;break a}else{s=0;n=0}}k[w>>2]=x;j=1;q=z+1|0;p=y}y=k[a>>2]|0;p=k[y+4>>2]|0;if((k[c>>2]|0)==3){k[y+24>>2]=A;k[y+28>>2]=k[e>>2];k[y+32>>2]=k[f+36>>2];k[y+36>>2]=k[f+40>>2];k[y+20>>2]=96;rb[p&31](a,1)}else{k[y+20>>2]=97;k[y+24>>2]=A;rb[p&31](a,1)}p=xb[k[(k[b>>2]|0)+8>>2]&63](a,1,A,k[c>>2]|0)|0;y=k[c>>2]|0;if((y|0)>0){e=y;y=A;z=0;while(1){q=k[f+32+(z<<2)>>2]|0;j=y;y=(y|0)/(q|0)|0;b:do if((q|0)>0){x=q+-1|0;w=(x|0)/2|0;h=p+(z<<2)|0;if((y|0)>0)B=0;else{t=0;while(1){r=ha(t,y)|0;if((r|0)<(A|0)){g=r;do g=g+j|0;while((g|0)<(A|0))}t=t+1|0;if((t|0)==(q|0)){C=e;break b}}}do{t=ha(B,y)|0;if((t|0)<(A|0)){g=(((B*255|0)+w|0)/(x|0)|0)&255;r=t;do{t=0;do{i[(k[h>>2]|0)+(t+r)>>0]=g;t=t+1|0}while((t|0)!=(y|0));r=r+j|0}while((r|0)<(A|0))}B=B+1|0}while((B|0)!=(q|0));C=k[c>>2]|0}else C=e;while(0);z=z+1|0;if((z|0)>=(C|0))break;else e=C}}k[f+16>>2]=p;k[f+20>>2]=A;_l(a);if((k[a+88>>2]|0)!=2)return;A=k[d>>2]|0;d=(k[a+112>>2]<<1)+4|0;if((k[c>>2]|0)>0)D=0;else return;do{f=nb[k[(k[b>>2]|0)+4>>2]&63](a,1,d)|0;k[A+68+(D<<2)>>2]=f;D=D+1|0}while((D|0)<(k[c>>2]|0));return}function Xl(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;b=a+484|0;c=k[b>>2]|0;k[a+136>>2]=k[c+16>>2];k[a+132>>2]=k[c+20>>2];switch(k[a+88>>2]|0){case 0:{d=c+4|0;if((k[a+120>>2]|0)==3){k[d>>2]=18;return}else{k[d>>2]=19;return}break}case 1:{d=a+120|0;k[c+4>>2]=(k[d>>2]|0)==3?20:21;k[c+48>>2]=0;if(!(k[c+28>>2]|0))_l(a);if(k[c+52>>2]|0)return;e=k[b>>2]|0;b=k[d>>2]|0;if((b|0)<=0)return;f=a+4|0;g=b;b=0;while(1){h=k[e+32+(b<<2)>>2]|0;a:do if((b|0)>0){i=0;while(1){if((h|0)==(k[e+32+(i<<2)>>2]|0)){j=i;break}i=i+1|0;if((i|0)>=(b|0)){m=14;break a}}i=k[e+52+(j<<2)>>2]|0;if(i){n=g;o=i}else m=14}else m=14;while(0);if((m|0)==14){m=0;i=nb[k[k[f>>2]>>2]&63](a,1,1024)|0;p=(h<<9)+-512|0;q=0;do{r=0;do{s=255-((l[160977+(q<<4)+r>>0]|0)<<1)|0;t=s*255|0;if((s|0)<0)u=0-((0-t|0)/(p|0)|0)|0;else u=(t|0)/(p|0)|0;k[i+(q<<6)+(r<<2)>>2]=u;r=r+1|0}while((r|0)!=16);q=q+1|0}while((q|0)!=16);n=k[d>>2]|0;o=i}k[e+52+(b<<2)>>2]=o;b=b+1|0;if((b|0)>=(n|0))break;else g=n}return}case 2:{k[c+4>>2]=22;k[c+84>>2]=0;if(!(k[c+68>>2]|0)){n=a+112|0;g=(k[n>>2]<<1)+4|0;b=a+120|0;if((k[b>>2]|0)<=0)return;o=a+4|0;e=0;do{d=nb[k[(k[o>>2]|0)+4>>2]&63](a,1,g)|0;k[c+68+(e<<2)>>2]=d;e=e+1|0;d=k[b>>2]|0}while((e|0)<(d|0));v=b;w=n;x=d}else{n=a+120|0;v=n;w=a+112|0;x=k[n>>2]|0}n=(k[w>>2]<<1)+4|0;if((x|0)>0)y=0;else return;do{qr(k[c+68+(y<<2)>>2]|0,0,n|0)|0;y=y+1|0}while((y|0)<(k[v>>2]|0));return}default:{v=k[a>>2]|0;k[v+20>>2]=49;qb[k[v>>2]&127](a);return}}}function Yl(a){a=a|0;return}function Zl(a){a=a|0;var b=0;b=k[a>>2]|0;k[b+20>>2]=47;qb[k[b>>2]&127](a);return}function _l(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;b=k[a+484>>2]|0;c=(k[a+88>>2]|0)==1;k[b+28>>2]=c&1;d=a+120|0;e=xb[k[(k[a+4>>2]|0)+8>>2]&63](a,1,c?766:256,k[d>>2]|0)|0;a=b+24|0;k[a>>2]=e;if((k[d>>2]|0)<=0)return;e=k[b+20>>2]|0;f=0;do{g=k[b+32+(f<<2)>>2]|0;e=(e|0)/(g|0)|0;if(c){h=(k[a>>2]|0)+(f<<2)|0;k[h>>2]=(k[h>>2]|0)+255}h=k[(k[a>>2]|0)+(f<<2)>>2]|0;j=g+-1|0;l=j<<1;m=0;n=(g+254|0)/(l|0)|0;g=0;while(1){if((m|0)>(n|0)){o=g;while(1){p=o+1|0;q=(((p<<1|1)*255|0)+j|0)/(l|0)|0;if((m|0)>(q|0))o=p;else{r=q;s=p;break}}}else{r=n;s=g}o=(ha(s,e)|0)&255;i[h+m>>0]=o;m=m+1|0;if((m|0)==256)break;else{n=r;g=s}}if(c){g=h+255|0;n=1;do{i[h+(0-n)>>0]=i[h>>0]|0;i[h+(n+255)>>0]=i[g>>0]|0;n=n+1|0}while((n|0)!=256)}f=f+1|0}while((f|0)<(k[d>>2]|0));return}function $l(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0;e=k[(k[a+484>>2]|0)+24>>2]|0;f=k[e>>2]|0;g=k[e+4>>2]|0;h=k[e+8>>2]|0;e=k[a+112>>2]|0;if((d|0)<1|(e|0)==0)return;else j=0;do{a=e;m=k[b+(j<<2)>>2]|0;n=k[c+(j<<2)>>2]|0;while(1){i[n>>0]=(l[g+(l[m+1>>0]|0)>>0]|0)+(l[f+(l[m>>0]|0)>>0]|0)+(l[h+(l[m+2>>0]|0)>>0]|0);a=a+-1|0;if(!a)break;else{m=m+3|0;n=n+1|0}}j=j+1|0}while((j|0)!=(d|0));return}function am(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;e=k[(k[a+484>>2]|0)+24>>2]|0;f=k[a+112>>2]|0;g=k[a+120>>2]|0;if((d|0)<=0)return;a=(f|0)==0;h=(g|0)>0;j=0;do{if(!a){m=f;n=k[b+(j<<2)>>2]|0;o=k[c+(j<<2)>>2]|0;while(1){if(h){p=0;q=0;r=n;while(1){s=(l[(k[e+(p<<2)>>2]|0)+(l[r>>0]|0)>>0]|0)+q|0;p=p+1|0;if((p|0)==(g|0)){t=s;break}else{q=s;r=r+1|0}}u=t;v=n+g|0}else{u=0;v=n}i[o>>0]=u;m=m+-1|0;if(!m)break;else{n=v;o=o+1|0}}}j=j+1|0}while((j|0)!=(d|0));return}function bm(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;e=k[a+484>>2]|0;f=k[e+24>>2]|0;g=k[f>>2]|0;h=k[f+4>>2]|0;j=k[f+8>>2]|0;f=k[a+112>>2]|0;if((d|0)<=0)return;a=e+48|0;m=e+52|0;n=e+56|0;o=e+60|0;e=(f|0)==0;p=k[a>>2]|0;q=0;do{r=k[m>>2]|0;s=k[n>>2]|0;t=k[o>>2]|0;if(!e){u=f;v=0;w=k[b+(q<<2)>>2]|0;x=k[c+(q<<2)>>2]|0;while(1){i[x>>0]=(l[h+((l[w+1>>0]|0)+(k[s+(p<<6)+(v<<2)>>2]|0))>>0]|0)+(l[g+((l[w>>0]|0)+(k[r+(p<<6)+(v<<2)>>2]|0))>>0]|0)+(l[j+((l[w+2>>0]|0)+(k[t+(p<<6)+(v<<2)>>2]|0))>>0]|0);u=u+-1|0;if(!u)break;else{v=v+1&15;w=w+3|0;x=x+1|0}}}p=p+1&15;k[a>>2]=p;q=q+1|0}while((q|0)!=(d|0));return}function cm(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;e=k[a+484>>2]|0;f=k[a+120>>2]|0;g=k[a+112>>2]|0;if((d|0)<=0)return;a=e+48|0;h=(f|0)>0;j=e+24|0;m=(g|0)==0;n=0;do{o=c+(n<<2)|0;qr(k[o>>2]|0,0,g|0)|0;p=k[a>>2]|0;if(h){q=b+(n<<2)|0;r=0;do{s=k[(k[j>>2]|0)+(r<<2)>>2]|0;t=k[e+52+(r<<2)>>2]|0;if(!m){u=g;v=0;w=(k[q>>2]|0)+r|0;x=k[o>>2]|0;while(1){i[x>>0]=(l[x>>0]|0)+(l[s+((l[w>>0]|0)+(k[t+(p<<6)+(v<<2)>>2]|0))>>0]|0);u=u+-1|0;if(!u)break;else{v=v+1&15;w=w+f|0;x=x+1|0}}}r=r+1|0}while((r|0)!=(f|0))}k[a>>2]=p+1&15;n=n+1|0}while((n|0)!=(d|0));return}function dm(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0;e=k[a+484>>2]|0;f=k[a+120>>2]|0;g=k[a+112>>2]|0;h=k[a+336>>2]|0;if((d|0)<=0)return;a=(f|0)>0;m=e+84|0;n=e+24|0;o=e+16|0;p=(g|0)==0;q=g+-1|0;r=ha(q,f)|0;s=0-f|0;t=g+1|0;u=0;do{v=c+(u<<2)|0;qr(k[v>>2]|0,0,g|0)|0;if(a){w=b+(u<<2)|0;x=0;do{y=k[v>>2]|0;z=k[e+68+(x<<2)>>2]|0;if(!(k[m>>2]|0)){A=x;B=1;C=f;D=z;E=y}else{A=x+r|0;B=-1;C=s;D=z+(t<<1)|0;E=y+q|0}y=k[(k[n>>2]|0)+(x<<2)>>2]|0;z=k[(k[o>>2]|0)+(x<<2)>>2]|0;if(p){F=0;G=D}else{H=ha(g,B)|0;I=0;J=0;K=g;L=0;M=D;N=(k[w>>2]|0)+A|0;O=E;while(1){P=M;M=M+(B<<1)|0;Q=l[h+((L+8+(j[M>>1]|0)>>4)+(l[N>>0]|0))>>0]|0;R=l[y+Q>>0]|0;i[O>>0]=(l[O>>0]|0)+R;S=Q-(l[z+R>>0]|0)|0;j[P>>1]=(S*3|0)+J;P=(S*5|0)+I|0;K=K+-1|0;if(!K){T=P;break}else{I=S;J=P;L=S*7|0;N=N+C|0;O=O+B|0}}F=T;G=D+(H<<1)|0}j[G>>1]=F;x=x+1|0}while((x|0)!=(f|0))}k[m>>2]=(k[m>>2]|0)==0&1;u=u+1|0}while((u|0)!=(d|0));return}function em(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0;b=a+4|0;c=nb[k[k[b>>2]>>2]&63](a,1,44)|0;k[a+484>>2]=c;k[c>>2]=14;k[c+12>>2]=52;d=c+32|0;k[d>>2]=0;k[c+40>>2]=0;if((k[a+120>>2]|0)!=3){e=k[a>>2]|0;k[e+20>>2]=48;qb[k[e>>2]&127](a)}e=nb[k[k[b>>2]>>2]&63](a,1,128)|0;f=c+24|0;k[f>>2]=e;e=0;do{g=nb[k[(k[b>>2]|0)+4>>2]&63](a,1,4096)|0;k[(k[f>>2]|0)+(e<<2)>>2]=g;e=e+1|0}while((e|0)!=32);k[c+28>>2]=1;if(!(k[a+108>>2]|0))k[c+16>>2]=0;else{e=k[a+96>>2]|0;if((e|0)>=8){if((e|0)>256){f=k[a>>2]|0;k[f+20>>2]=59;k[f+24>>2]=256;qb[k[f>>2]&127](a)}}else{f=k[a>>2]|0;k[f+20>>2]=58;k[f+24>>2]=8;qb[k[f>>2]&127](a)}f=xb[k[(k[b>>2]|0)+8>>2]&63](a,1,e,3)|0;k[c+16>>2]=f;k[c+20>>2]=e}e=a+88|0;if(!(k[e>>2]|0))return;k[e>>2]=2;e=nb[k[(k[b>>2]|0)+4>>2]&63](a,1,((k[a+112>>2]|0)*6|0)+12|0)|0;k[d>>2]=e;hm(a);return}function fm(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0;c=k[a+484>>2]|0;d=k[c+24>>2]|0;e=a+88|0;if(!(k[e>>2]|0))f=0;else{k[e>>2]=2;f=2}if(!b){k[c+4>>2]=(f|0)==2?24:25;k[c+8>>2]=54;f=k[a+132>>2]|0;if((f|0)>=1){if((f|0)>256){f=k[a>>2]|0;k[f+20>>2]=59;k[f+24>>2]=256;qb[k[f>>2]&127](a)}}else{f=k[a>>2]|0;k[f+20>>2]=58;k[f+24>>2]=1;qb[k[f>>2]&127](a)}if((k[e>>2]|0)==2){e=((k[a+112>>2]|0)*6|0)+12|0;f=c+32|0;b=k[f>>2]|0;if(!b){g=nb[k[(k[a+4>>2]|0)+4>>2]&63](a,1,e)|0;k[f>>2]=g;h=g}else h=b;qr(h|0,0,e|0)|0;if(!(k[c+40>>2]|0))hm(a);k[c+36>>2]=0}}else{k[c+4>>2]=23;k[c+8>>2]=53;k[c+28>>2]=1}a=c+28|0;if(!(k[a>>2]|0))return;qr(k[d>>2]|0,0,4096)|0;qr(k[d+4>>2]|0,0,4096)|0;qr(k[d+8>>2]|0,0,4096)|0;qr(k[d+12>>2]|0,0,4096)|0;qr(k[d+16>>2]|0,0,4096)|0;qr(k[d+20>>2]|0,0,4096)|0;qr(k[d+24>>2]|0,0,4096)|0;qr(k[d+28>>2]|0,0,4096)|0;qr(k[d+32>>2]|0,0,4096)|0;qr(k[d+36>>2]|0,0,4096)|0;qr(k[d+40>>2]|0,0,4096)|0;qr(k[d+44>>2]|0,0,4096)|0;qr(k[d+48>>2]|0,0,4096)|0;qr(k[d+52>>2]|0,0,4096)|0;qr(k[d+56>>2]|0,0,4096)|0;qr(k[d+60>>2]|0,0,4096)|0;qr(k[d+64>>2]|0,0,4096)|0;qr(k[d+68>>2]|0,0,4096)|0;qr(