<?php
namespace OpenEMR\Custom\DietOrders;

use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class GetSingle
{
    public function __invoke(Request $request, Response $response, $args)
    {
        $id = intval($args['id']);
        $row = \sqlQuery("SELECT * FROM form_diet_orders WHERE id = ?", [$id]);
        if (!$row) {
            $response->getBody()->write(json_encode(['error' => 'Form not found']));
            return $response->withStatus(404)->withHeader('Content-Type', 'application/json');
        }

        $data = [
            'form_id' => $row['id'],
            'pid' => $row['pid'],
            'encounter' => $row['encounter'],
            'submitted_by' => $row['user'],
            'submitted_at' => $row['date'],
            'data' => [
                'diet_type1' => $row['diet_type1'],
                'diet_type2' => $row['diet_type2'],
                'texture_mod' => $row['texture_mod'],
                'supplements' => $row['supplements'],
                'allergies' => $row['allergies'],
                'additional_instructions' => $row['additional_instructions'],
                'feeding_route' => $row['feeding_route'],
                'feeding_route_other' => $row['feeding_route_other'],
                'formula' => $row['formula'],
                'formula_other' => $row['formula_other'],
                'method_admin' => $row['method_admin'],
                'amount_ml' => $row['amount_ml'],
                'frequency' => $row['frequency'],
                'rate_ml_hr' => $row['rate_ml_hr'],
                'total_volume' => $row['total_volume'],
                'flush_amount' => $row['flush_amount'],
                'flush_frequency' => $row['flush_frequency'],
                'flush_other' => $row['flush_other'],
                'tube_instructions' => $row['tube_instructions'],
            ]
        ];

        $response->getBody()->write(json_encode($data));
        return $response->withHeader('Content-Type', 'application/json');
    }
}
