<?php
require_once('DietOrdersController.php');

$controller = new DietOrdersController();

// Make sure method is GET
$method = $_SERVER['REQUEST_METHOD'];
if ($method !== 'GET') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Only GET requests are allowed']);
    exit;
}

// Use query parameters for routing
$action = $_GET['action'] ?? '';
$id = $_GET['id'] ?? null;

header('Content-Type: application/json');

switch ($action) {
    case 'getAll':
        $controller->getAll();
        break;

    case 'getById':
        if ($id !== null && is_numeric($id)) {
            $controller->getById((int)$id);
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid or missing ID']);
        }
        break;

    default:
        http_response_code(404);
        echo json_encode(['error' => 'Endpoint not found']);
        break;
}
